"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));

// node_modules/decimal.js/decimal.js
var require_decimal = __commonJS({
  "node_modules/decimal.js/decimal.js"(exports2, module2) {
    (function(globalScope) {
      "use strict";
      var EXP_LIMIT = 9e15, MAX_DIGITS = 1e9, NUMERALS = "0123456789abcdef", LN10 = "2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058", PI = "3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632789", DEFAULTS = {
        // These values must be integers within the stated ranges (inclusive).
        // Most of these values can be changed at run-time using the `Decimal.config` method.
        // The maximum number of significant digits of the result of a calculation or base conversion.
        // E.g. `Decimal.config({ precision: 20 });`
        precision: 20,
        // 1 to MAX_DIGITS
        // The rounding mode used when rounding to `precision`.
        //
        // ROUND_UP         0 Away from zero.
        // ROUND_DOWN       1 Towards zero.
        // ROUND_CEIL       2 Towards +Infinity.
        // ROUND_FLOOR      3 Towards -Infinity.
        // ROUND_HALF_UP    4 Towards nearest neighbour. If equidistant, up.
        // ROUND_HALF_DOWN  5 Towards nearest neighbour. If equidistant, down.
        // ROUND_HALF_EVEN  6 Towards nearest neighbour. If equidistant, towards even neighbour.
        // ROUND_HALF_CEIL  7 Towards nearest neighbour. If equidistant, towards +Infinity.
        // ROUND_HALF_FLOOR 8 Towards nearest neighbour. If equidistant, towards -Infinity.
        //
        // E.g.
        // `Decimal.rounding = 4;`
        // `Decimal.rounding = Decimal.ROUND_HALF_UP;`
        rounding: 4,
        // 0 to 8
        // The modulo mode used when calculating the modulus: a mod n.
        // The quotient (q = a / n) is calculated according to the corresponding rounding mode.
        // The remainder (r) is calculated as: r = a - n * q.
        //
        // UP         0 The remainder is positive if the dividend is negative, else is negative.
        // DOWN       1 The remainder has the same sign as the dividend (JavaScript %).
        // FLOOR      3 The remainder has the same sign as the divisor (Python %).
        // HALF_EVEN  6 The IEEE 754 remainder function.
        // EUCLID     9 Euclidian division. q = sign(n) * floor(a / abs(n)). Always positive.
        //
        // Truncated division (1), floored division (3), the IEEE 754 remainder (6), and Euclidian
        // division (9) are commonly used for the modulus operation. The other rounding modes can also
        // be used, but they may not give useful results.
        modulo: 1,
        // 0 to 9
        // The exponent value at and beneath which `toString` returns exponential notation.
        // JavaScript numbers: -7
        toExpNeg: -7,
        // 0 to -EXP_LIMIT
        // The exponent value at and above which `toString` returns exponential notation.
        // JavaScript numbers: 21
        toExpPos: 21,
        // 0 to EXP_LIMIT
        // The minimum exponent value, beneath which underflow to zero occurs.
        // JavaScript numbers: -324  (5e-324)
        minE: -EXP_LIMIT,
        // -1 to -EXP_LIMIT
        // The maximum exponent value, above which overflow to Infinity occurs.
        // JavaScript numbers: 308  (1.7976931348623157e+308)
        maxE: EXP_LIMIT,
        // 1 to EXP_LIMIT
        // Whether to use cryptographically-secure random number generation, if available.
        crypto: false
        // true/false
      }, Decimal2, inexact, noConflict, quadrant, external = true, decimalError = "[DecimalError] ", invalidArgument = decimalError + "Invalid argument: ", precisionLimitExceeded = decimalError + "Precision limit exceeded", cryptoUnavailable = decimalError + "crypto unavailable", tag = "[object Decimal]", mathfloor = Math.floor, mathpow = Math.pow, isBinary = /^0b([01]+(\.[01]*)?|\.[01]+)(p[+-]?\d+)?$/i, isHex = /^0x([0-9a-f]+(\.[0-9a-f]*)?|\.[0-9a-f]+)(p[+-]?\d+)?$/i, isOctal = /^0o([0-7]+(\.[0-7]*)?|\.[0-7]+)(p[+-]?\d+)?$/i, isDecimal = /^(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i, BASE = 1e7, LOG_BASE = 7, MAX_SAFE_INTEGER = 9007199254740991, LN10_PRECISION = LN10.length - 1, PI_PRECISION = PI.length - 1, P = { toStringTag: tag };
      P.absoluteValue = P.abs = function() {
        var x = new this.constructor(this);
        if (x.s < 0) x.s = 1;
        return finalise(x);
      };
      P.ceil = function() {
        return finalise(new this.constructor(this), this.e + 1, 2);
      };
      P.clampedTo = P.clamp = function(min2, max2) {
        var k, x = this, Ctor = x.constructor;
        min2 = new Ctor(min2);
        max2 = new Ctor(max2);
        if (!min2.s || !max2.s) return new Ctor(NaN);
        if (min2.gt(max2)) throw Error(invalidArgument + max2);
        k = x.cmp(min2);
        return k < 0 ? min2 : x.cmp(max2) > 0 ? max2 : new Ctor(x);
      };
      P.comparedTo = P.cmp = function(y) {
        var i, j, xdL, ydL, x = this, xd = x.d, yd = (y = new x.constructor(y)).d, xs = x.s, ys = y.s;
        if (!xd || !yd) {
          return !xs || !ys ? NaN : xs !== ys ? xs : xd === yd ? 0 : !xd ^ xs < 0 ? 1 : -1;
        }
        if (!xd[0] || !yd[0]) return xd[0] ? xs : yd[0] ? -ys : 0;
        if (xs !== ys) return xs;
        if (x.e !== y.e) return x.e > y.e ^ xs < 0 ? 1 : -1;
        xdL = xd.length;
        ydL = yd.length;
        for (i = 0, j = xdL < ydL ? xdL : ydL; i < j; ++i) {
          if (xd[i] !== yd[i]) return xd[i] > yd[i] ^ xs < 0 ? 1 : -1;
        }
        return xdL === ydL ? 0 : xdL > ydL ^ xs < 0 ? 1 : -1;
      };
      P.cosine = P.cos = function() {
        var pr, rm, x = this, Ctor = x.constructor;
        if (!x.d) return new Ctor(NaN);
        if (!x.d[0]) return new Ctor(1);
        pr = Ctor.precision;
        rm = Ctor.rounding;
        Ctor.precision = pr + Math.max(x.e, x.sd()) + LOG_BASE;
        Ctor.rounding = 1;
        x = cosine(Ctor, toLessThanHalfPi(Ctor, x));
        Ctor.precision = pr;
        Ctor.rounding = rm;
        return finalise(quadrant == 2 || quadrant == 3 ? x.neg() : x, pr, rm, true);
      };
      P.cubeRoot = P.cbrt = function() {
        var e, m, n, r, rep, s, sd, t, t3, t3plusx, x = this, Ctor = x.constructor;
        if (!x.isFinite() || x.isZero()) return new Ctor(x);
        external = false;
        s = x.s * mathpow(x.s * x, 1 / 3);
        if (!s || Math.abs(s) == 1 / 0) {
          n = digitsToString(x.d);
          e = x.e;
          if (s = (e - n.length + 1) % 3) n += s == 1 || s == -2 ? "0" : "00";
          s = mathpow(n, 1 / 3);
          e = mathfloor((e + 1) / 3) - (e % 3 == (e < 0 ? -1 : 2));
          if (s == 1 / 0) {
            n = "5e" + e;
          } else {
            n = s.toExponential();
            n = n.slice(0, n.indexOf("e") + 1) + e;
          }
          r = new Ctor(n);
          r.s = x.s;
        } else {
          r = new Ctor(s.toString());
        }
        sd = (e = Ctor.precision) + 3;
        for (; ; ) {
          t = r;
          t3 = t.times(t).times(t);
          t3plusx = t3.plus(x);
          r = divide(t3plusx.plus(x).times(t), t3plusx.plus(t3), sd + 2, 1);
          if (digitsToString(t.d).slice(0, sd) === (n = digitsToString(r.d)).slice(0, sd)) {
            n = n.slice(sd - 3, sd + 1);
            if (n == "9999" || !rep && n == "4999") {
              if (!rep) {
                finalise(t, e + 1, 0);
                if (t.times(t).times(t).eq(x)) {
                  r = t;
                  break;
                }
              }
              sd += 4;
              rep = 1;
            } else {
              if (!+n || !+n.slice(1) && n.charAt(0) == "5") {
                finalise(r, e + 1, 1);
                m = !r.times(r).times(r).eq(x);
              }
              break;
            }
          }
        }
        external = true;
        return finalise(r, e, Ctor.rounding, m);
      };
      P.decimalPlaces = P.dp = function() {
        var w, d = this.d, n = NaN;
        if (d) {
          w = d.length - 1;
          n = (w - mathfloor(this.e / LOG_BASE)) * LOG_BASE;
          w = d[w];
          if (w) for (; w % 10 == 0; w /= 10) n--;
          if (n < 0) n = 0;
        }
        return n;
      };
      P.dividedBy = P.div = function(y) {
        return divide(this, new this.constructor(y));
      };
      P.dividedToIntegerBy = P.divToInt = function(y) {
        var x = this, Ctor = x.constructor;
        return finalise(divide(x, new Ctor(y), 0, 1, 1), Ctor.precision, Ctor.rounding);
      };
      P.equals = P.eq = function(y) {
        return this.cmp(y) === 0;
      };
      P.floor = function() {
        return finalise(new this.constructor(this), this.e + 1, 3);
      };
      P.greaterThan = P.gt = function(y) {
        return this.cmp(y) > 0;
      };
      P.greaterThanOrEqualTo = P.gte = function(y) {
        var k = this.cmp(y);
        return k == 1 || k === 0;
      };
      P.hyperbolicCosine = P.cosh = function() {
        var k, n, pr, rm, len, x = this, Ctor = x.constructor, one = new Ctor(1);
        if (!x.isFinite()) return new Ctor(x.s ? 1 / 0 : NaN);
        if (x.isZero()) return one;
        pr = Ctor.precision;
        rm = Ctor.rounding;
        Ctor.precision = pr + Math.max(x.e, x.sd()) + 4;
        Ctor.rounding = 1;
        len = x.d.length;
        if (len < 32) {
          k = Math.ceil(len / 3);
          n = (1 / tinyPow(4, k)).toString();
        } else {
          k = 16;
          n = "2.3283064365386962890625e-10";
        }
        x = taylorSeries(Ctor, 1, x.times(n), new Ctor(1), true);
        var cosh2_x, i = k, d8 = new Ctor(8);
        for (; i--; ) {
          cosh2_x = x.times(x);
          x = one.minus(cosh2_x.times(d8.minus(cosh2_x.times(d8))));
        }
        return finalise(x, Ctor.precision = pr, Ctor.rounding = rm, true);
      };
      P.hyperbolicSine = P.sinh = function() {
        var k, pr, rm, len, x = this, Ctor = x.constructor;
        if (!x.isFinite() || x.isZero()) return new Ctor(x);
        pr = Ctor.precision;
        rm = Ctor.rounding;
        Ctor.precision = pr + Math.max(x.e, x.sd()) + 4;
        Ctor.rounding = 1;
        len = x.d.length;
        if (len < 3) {
          x = taylorSeries(Ctor, 2, x, x, true);
        } else {
          k = 1.4 * Math.sqrt(len);
          k = k > 16 ? 16 : k | 0;
          x = x.times(1 / tinyPow(5, k));
          x = taylorSeries(Ctor, 2, x, x, true);
          var sinh2_x, d5 = new Ctor(5), d16 = new Ctor(16), d20 = new Ctor(20);
          for (; k--; ) {
            sinh2_x = x.times(x);
            x = x.times(d5.plus(sinh2_x.times(d16.times(sinh2_x).plus(d20))));
          }
        }
        Ctor.precision = pr;
        Ctor.rounding = rm;
        return finalise(x, pr, rm, true);
      };
      P.hyperbolicTangent = P.tanh = function() {
        var pr, rm, x = this, Ctor = x.constructor;
        if (!x.isFinite()) return new Ctor(x.s);
        if (x.isZero()) return new Ctor(x);
        pr = Ctor.precision;
        rm = Ctor.rounding;
        Ctor.precision = pr + 7;
        Ctor.rounding = 1;
        return divide(x.sinh(), x.cosh(), Ctor.precision = pr, Ctor.rounding = rm);
      };
      P.inverseCosine = P.acos = function() {
        var halfPi, x = this, Ctor = x.constructor, k = x.abs().cmp(1), pr = Ctor.precision, rm = Ctor.rounding;
        if (k !== -1) {
          return k === 0 ? x.isNeg() ? getPi(Ctor, pr, rm) : new Ctor(0) : new Ctor(NaN);
        }
        if (x.isZero()) return getPi(Ctor, pr + 4, rm).times(0.5);
        Ctor.precision = pr + 6;
        Ctor.rounding = 1;
        x = x.asin();
        halfPi = getPi(Ctor, pr + 4, rm).times(0.5);
        Ctor.precision = pr;
        Ctor.rounding = rm;
        return halfPi.minus(x);
      };
      P.inverseHyperbolicCosine = P.acosh = function() {
        var pr, rm, x = this, Ctor = x.constructor;
        if (x.lte(1)) return new Ctor(x.eq(1) ? 0 : NaN);
        if (!x.isFinite()) return new Ctor(x);
        pr = Ctor.precision;
        rm = Ctor.rounding;
        Ctor.precision = pr + Math.max(Math.abs(x.e), x.sd()) + 4;
        Ctor.rounding = 1;
        external = false;
        x = x.times(x).minus(1).sqrt().plus(x);
        external = true;
        Ctor.precision = pr;
        Ctor.rounding = rm;
        return x.ln();
      };
      P.inverseHyperbolicSine = P.asinh = function() {
        var pr, rm, x = this, Ctor = x.constructor;
        if (!x.isFinite() || x.isZero()) return new Ctor(x);
        pr = Ctor.precision;
        rm = Ctor.rounding;
        Ctor.precision = pr + 2 * Math.max(Math.abs(x.e), x.sd()) + 6;
        Ctor.rounding = 1;
        external = false;
        x = x.times(x).plus(1).sqrt().plus(x);
        external = true;
        Ctor.precision = pr;
        Ctor.rounding = rm;
        return x.ln();
      };
      P.inverseHyperbolicTangent = P.atanh = function() {
        var pr, rm, wpr, xsd, x = this, Ctor = x.constructor;
        if (!x.isFinite()) return new Ctor(NaN);
        if (x.e >= 0) return new Ctor(x.abs().eq(1) ? x.s / 0 : x.isZero() ? x : NaN);
        pr = Ctor.precision;
        rm = Ctor.rounding;
        xsd = x.sd();
        if (Math.max(xsd, pr) < 2 * -x.e - 1) return finalise(new Ctor(x), pr, rm, true);
        Ctor.precision = wpr = xsd - x.e;
        x = divide(x.plus(1), new Ctor(1).minus(x), wpr + pr, 1);
        Ctor.precision = pr + 4;
        Ctor.rounding = 1;
        x = x.ln();
        Ctor.precision = pr;
        Ctor.rounding = rm;
        return x.times(0.5);
      };
      P.inverseSine = P.asin = function() {
        var halfPi, k, pr, rm, x = this, Ctor = x.constructor;
        if (x.isZero()) return new Ctor(x);
        k = x.abs().cmp(1);
        pr = Ctor.precision;
        rm = Ctor.rounding;
        if (k !== -1) {
          if (k === 0) {
            halfPi = getPi(Ctor, pr + 4, rm).times(0.5);
            halfPi.s = x.s;
            return halfPi;
          }
          return new Ctor(NaN);
        }
        Ctor.precision = pr + 6;
        Ctor.rounding = 1;
        x = x.div(new Ctor(1).minus(x.times(x)).sqrt().plus(1)).atan();
        Ctor.precision = pr;
        Ctor.rounding = rm;
        return x.times(2);
      };
      P.inverseTangent = P.atan = function() {
        var i, j, k, n, px, t, r, wpr, x2, x = this, Ctor = x.constructor, pr = Ctor.precision, rm = Ctor.rounding;
        if (!x.isFinite()) {
          if (!x.s) return new Ctor(NaN);
          if (pr + 4 <= PI_PRECISION) {
            r = getPi(Ctor, pr + 4, rm).times(0.5);
            r.s = x.s;
            return r;
          }
        } else if (x.isZero()) {
          return new Ctor(x);
        } else if (x.abs().eq(1) && pr + 4 <= PI_PRECISION) {
          r = getPi(Ctor, pr + 4, rm).times(0.25);
          r.s = x.s;
          return r;
        }
        Ctor.precision = wpr = pr + 10;
        Ctor.rounding = 1;
        k = Math.min(28, wpr / LOG_BASE + 2 | 0);
        for (i = k; i; --i) x = x.div(x.times(x).plus(1).sqrt().plus(1));
        external = false;
        j = Math.ceil(wpr / LOG_BASE);
        n = 1;
        x2 = x.times(x);
        r = new Ctor(x);
        px = x;
        for (; i !== -1; ) {
          px = px.times(x2);
          t = r.minus(px.div(n += 2));
          px = px.times(x2);
          r = t.plus(px.div(n += 2));
          if (r.d[j] !== void 0) for (i = j; r.d[i] === t.d[i] && i--; ) ;
        }
        if (k) r = r.times(2 << k - 1);
        external = true;
        return finalise(r, Ctor.precision = pr, Ctor.rounding = rm, true);
      };
      P.isFinite = function() {
        return !!this.d;
      };
      P.isInteger = P.isInt = function() {
        return !!this.d && mathfloor(this.e / LOG_BASE) > this.d.length - 2;
      };
      P.isNaN = function() {
        return !this.s;
      };
      P.isNegative = P.isNeg = function() {
        return this.s < 0;
      };
      P.isPositive = P.isPos = function() {
        return this.s > 0;
      };
      P.isZero = function() {
        return !!this.d && this.d[0] === 0;
      };
      P.lessThan = P.lt = function(y) {
        return this.cmp(y) < 0;
      };
      P.lessThanOrEqualTo = P.lte = function(y) {
        return this.cmp(y) < 1;
      };
      P.logarithm = P.log = function(base) {
        var isBase10, d, denominator, k, inf, num, sd, r, arg = this, Ctor = arg.constructor, pr = Ctor.precision, rm = Ctor.rounding, guard = 5;
        if (base == null) {
          base = new Ctor(10);
          isBase10 = true;
        } else {
          base = new Ctor(base);
          d = base.d;
          if (base.s < 0 || !d || !d[0] || base.eq(1)) return new Ctor(NaN);
          isBase10 = base.eq(10);
        }
        d = arg.d;
        if (arg.s < 0 || !d || !d[0] || arg.eq(1)) {
          return new Ctor(d && !d[0] ? -1 / 0 : arg.s != 1 ? NaN : d ? 0 : 1 / 0);
        }
        if (isBase10) {
          if (d.length > 1) {
            inf = true;
          } else {
            for (k = d[0]; k % 10 === 0; ) k /= 10;
            inf = k !== 1;
          }
        }
        external = false;
        sd = pr + guard;
        num = naturalLogarithm(arg, sd);
        denominator = isBase10 ? getLn10(Ctor, sd + 10) : naturalLogarithm(base, sd);
        r = divide(num, denominator, sd, 1);
        if (checkRoundingDigits(r.d, k = pr, rm)) {
          do {
            sd += 10;
            num = naturalLogarithm(arg, sd);
            denominator = isBase10 ? getLn10(Ctor, sd + 10) : naturalLogarithm(base, sd);
            r = divide(num, denominator, sd, 1);
            if (!inf) {
              if (+digitsToString(r.d).slice(k + 1, k + 15) + 1 == 1e14) {
                r = finalise(r, pr + 1, 0);
              }
              break;
            }
          } while (checkRoundingDigits(r.d, k += 10, rm));
        }
        external = true;
        return finalise(r, pr, rm);
      };
      P.minus = P.sub = function(y) {
        var d, e, i, j, k, len, pr, rm, xd, xe, xLTy, yd, x = this, Ctor = x.constructor;
        y = new Ctor(y);
        if (!x.d || !y.d) {
          if (!x.s || !y.s) y = new Ctor(NaN);
          else if (x.d) y.s = -y.s;
          else y = new Ctor(y.d || x.s !== y.s ? x : NaN);
          return y;
        }
        if (x.s != y.s) {
          y.s = -y.s;
          return x.plus(y);
        }
        xd = x.d;
        yd = y.d;
        pr = Ctor.precision;
        rm = Ctor.rounding;
        if (!xd[0] || !yd[0]) {
          if (yd[0]) y.s = -y.s;
          else if (xd[0]) y = new Ctor(x);
          else return new Ctor(rm === 3 ? -0 : 0);
          return external ? finalise(y, pr, rm) : y;
        }
        e = mathfloor(y.e / LOG_BASE);
        xe = mathfloor(x.e / LOG_BASE);
        xd = xd.slice();
        k = xe - e;
        if (k) {
          xLTy = k < 0;
          if (xLTy) {
            d = xd;
            k = -k;
            len = yd.length;
          } else {
            d = yd;
            e = xe;
            len = xd.length;
          }
          i = Math.max(Math.ceil(pr / LOG_BASE), len) + 2;
          if (k > i) {
            k = i;
            d.length = 1;
          }
          d.reverse();
          for (i = k; i--; ) d.push(0);
          d.reverse();
        } else {
          i = xd.length;
          len = yd.length;
          xLTy = i < len;
          if (xLTy) len = i;
          for (i = 0; i < len; i++) {
            if (xd[i] != yd[i]) {
              xLTy = xd[i] < yd[i];
              break;
            }
          }
          k = 0;
        }
        if (xLTy) {
          d = xd;
          xd = yd;
          yd = d;
          y.s = -y.s;
        }
        len = xd.length;
        for (i = yd.length - len; i > 0; --i) xd[len++] = 0;
        for (i = yd.length; i > k; ) {
          if (xd[--i] < yd[i]) {
            for (j = i; j && xd[--j] === 0; ) xd[j] = BASE - 1;
            --xd[j];
            xd[i] += BASE;
          }
          xd[i] -= yd[i];
        }
        for (; xd[--len] === 0; ) xd.pop();
        for (; xd[0] === 0; xd.shift()) --e;
        if (!xd[0]) return new Ctor(rm === 3 ? -0 : 0);
        y.d = xd;
        y.e = getBase10Exponent(xd, e);
        return external ? finalise(y, pr, rm) : y;
      };
      P.modulo = P.mod = function(y) {
        var q, x = this, Ctor = x.constructor;
        y = new Ctor(y);
        if (!x.d || !y.s || y.d && !y.d[0]) return new Ctor(NaN);
        if (!y.d || x.d && !x.d[0]) {
          return finalise(new Ctor(x), Ctor.precision, Ctor.rounding);
        }
        external = false;
        if (Ctor.modulo == 9) {
          q = divide(x, y.abs(), 0, 3, 1);
          q.s *= y.s;
        } else {
          q = divide(x, y, 0, Ctor.modulo, 1);
        }
        q = q.times(y);
        external = true;
        return x.minus(q);
      };
      P.naturalExponential = P.exp = function() {
        return naturalExponential(this);
      };
      P.naturalLogarithm = P.ln = function() {
        return naturalLogarithm(this);
      };
      P.negated = P.neg = function() {
        var x = new this.constructor(this);
        x.s = -x.s;
        return finalise(x);
      };
      P.plus = P.add = function(y) {
        var carry, d, e, i, k, len, pr, rm, xd, yd, x = this, Ctor = x.constructor;
        y = new Ctor(y);
        if (!x.d || !y.d) {
          if (!x.s || !y.s) y = new Ctor(NaN);
          else if (!x.d) y = new Ctor(y.d || x.s === y.s ? x : NaN);
          return y;
        }
        if (x.s != y.s) {
          y.s = -y.s;
          return x.minus(y);
        }
        xd = x.d;
        yd = y.d;
        pr = Ctor.precision;
        rm = Ctor.rounding;
        if (!xd[0] || !yd[0]) {
          if (!yd[0]) y = new Ctor(x);
          return external ? finalise(y, pr, rm) : y;
        }
        k = mathfloor(x.e / LOG_BASE);
        e = mathfloor(y.e / LOG_BASE);
        xd = xd.slice();
        i = k - e;
        if (i) {
          if (i < 0) {
            d = xd;
            i = -i;
            len = yd.length;
          } else {
            d = yd;
            e = k;
            len = xd.length;
          }
          k = Math.ceil(pr / LOG_BASE);
          len = k > len ? k + 1 : len + 1;
          if (i > len) {
            i = len;
            d.length = 1;
          }
          d.reverse();
          for (; i--; ) d.push(0);
          d.reverse();
        }
        len = xd.length;
        i = yd.length;
        if (len - i < 0) {
          i = len;
          d = yd;
          yd = xd;
          xd = d;
        }
        for (carry = 0; i; ) {
          carry = (xd[--i] = xd[i] + yd[i] + carry) / BASE | 0;
          xd[i] %= BASE;
        }
        if (carry) {
          xd.unshift(carry);
          ++e;
        }
        for (len = xd.length; xd[--len] == 0; ) xd.pop();
        y.d = xd;
        y.e = getBase10Exponent(xd, e);
        return external ? finalise(y, pr, rm) : y;
      };
      P.precision = P.sd = function(z) {
        var k, x = this;
        if (z !== void 0 && z !== !!z && z !== 1 && z !== 0) throw Error(invalidArgument + z);
        if (x.d) {
          k = getPrecision(x.d);
          if (z && x.e + 1 > k) k = x.e + 1;
        } else {
          k = NaN;
        }
        return k;
      };
      P.round = function() {
        var x = this, Ctor = x.constructor;
        return finalise(new Ctor(x), x.e + 1, Ctor.rounding);
      };
      P.sine = P.sin = function() {
        var pr, rm, x = this, Ctor = x.constructor;
        if (!x.isFinite()) return new Ctor(NaN);
        if (x.isZero()) return new Ctor(x);
        pr = Ctor.precision;
        rm = Ctor.rounding;
        Ctor.precision = pr + Math.max(x.e, x.sd()) + LOG_BASE;
        Ctor.rounding = 1;
        x = sine(Ctor, toLessThanHalfPi(Ctor, x));
        Ctor.precision = pr;
        Ctor.rounding = rm;
        return finalise(quadrant > 2 ? x.neg() : x, pr, rm, true);
      };
      P.squareRoot = P.sqrt = function() {
        var m, n, sd, r, rep, t, x = this, d = x.d, e = x.e, s = x.s, Ctor = x.constructor;
        if (s !== 1 || !d || !d[0]) {
          return new Ctor(!s || s < 0 && (!d || d[0]) ? NaN : d ? x : 1 / 0);
        }
        external = false;
        s = Math.sqrt(+x);
        if (s == 0 || s == 1 / 0) {
          n = digitsToString(d);
          if ((n.length + e) % 2 == 0) n += "0";
          s = Math.sqrt(n);
          e = mathfloor((e + 1) / 2) - (e < 0 || e % 2);
          if (s == 1 / 0) {
            n = "5e" + e;
          } else {
            n = s.toExponential();
            n = n.slice(0, n.indexOf("e") + 1) + e;
          }
          r = new Ctor(n);
        } else {
          r = new Ctor(s.toString());
        }
        sd = (e = Ctor.precision) + 3;
        for (; ; ) {
          t = r;
          r = t.plus(divide(x, t, sd + 2, 1)).times(0.5);
          if (digitsToString(t.d).slice(0, sd) === (n = digitsToString(r.d)).slice(0, sd)) {
            n = n.slice(sd - 3, sd + 1);
            if (n == "9999" || !rep && n == "4999") {
              if (!rep) {
                finalise(t, e + 1, 0);
                if (t.times(t).eq(x)) {
                  r = t;
                  break;
                }
              }
              sd += 4;
              rep = 1;
            } else {
              if (!+n || !+n.slice(1) && n.charAt(0) == "5") {
                finalise(r, e + 1, 1);
                m = !r.times(r).eq(x);
              }
              break;
            }
          }
        }
        external = true;
        return finalise(r, e, Ctor.rounding, m);
      };
      P.tangent = P.tan = function() {
        var pr, rm, x = this, Ctor = x.constructor;
        if (!x.isFinite()) return new Ctor(NaN);
        if (x.isZero()) return new Ctor(x);
        pr = Ctor.precision;
        rm = Ctor.rounding;
        Ctor.precision = pr + 10;
        Ctor.rounding = 1;
        x = x.sin();
        x.s = 1;
        x = divide(x, new Ctor(1).minus(x.times(x)).sqrt(), pr + 10, 0);
        Ctor.precision = pr;
        Ctor.rounding = rm;
        return finalise(quadrant == 2 || quadrant == 4 ? x.neg() : x, pr, rm, true);
      };
      P.times = P.mul = function(y) {
        var carry, e, i, k, r, rL, t, xdL, ydL, x = this, Ctor = x.constructor, xd = x.d, yd = (y = new Ctor(y)).d;
        y.s *= x.s;
        if (!xd || !xd[0] || !yd || !yd[0]) {
          return new Ctor(!y.s || xd && !xd[0] && !yd || yd && !yd[0] && !xd ? NaN : !xd || !yd ? y.s / 0 : y.s * 0);
        }
        e = mathfloor(x.e / LOG_BASE) + mathfloor(y.e / LOG_BASE);
        xdL = xd.length;
        ydL = yd.length;
        if (xdL < ydL) {
          r = xd;
          xd = yd;
          yd = r;
          rL = xdL;
          xdL = ydL;
          ydL = rL;
        }
        r = [];
        rL = xdL + ydL;
        for (i = rL; i--; ) r.push(0);
        for (i = ydL; --i >= 0; ) {
          carry = 0;
          for (k = xdL + i; k > i; ) {
            t = r[k] + yd[i] * xd[k - i - 1] + carry;
            r[k--] = t % BASE | 0;
            carry = t / BASE | 0;
          }
          r[k] = (r[k] + carry) % BASE | 0;
        }
        for (; !r[--rL]; ) r.pop();
        if (carry) ++e;
        else r.shift();
        y.d = r;
        y.e = getBase10Exponent(r, e);
        return external ? finalise(y, Ctor.precision, Ctor.rounding) : y;
      };
      P.toBinary = function(sd, rm) {
        return toStringBinary(this, 2, sd, rm);
      };
      P.toDecimalPlaces = P.toDP = function(dp, rm) {
        var x = this, Ctor = x.constructor;
        x = new Ctor(x);
        if (dp === void 0) return x;
        checkInt32(dp, 0, MAX_DIGITS);
        if (rm === void 0) rm = Ctor.rounding;
        else checkInt32(rm, 0, 8);
        return finalise(x, dp + x.e + 1, rm);
      };
      P.toExponential = function(dp, rm) {
        var str, x = this, Ctor = x.constructor;
        if (dp === void 0) {
          str = finiteToString(x, true);
        } else {
          checkInt32(dp, 0, MAX_DIGITS);
          if (rm === void 0) rm = Ctor.rounding;
          else checkInt32(rm, 0, 8);
          x = finalise(new Ctor(x), dp + 1, rm);
          str = finiteToString(x, true, dp + 1);
        }
        return x.isNeg() && !x.isZero() ? "-" + str : str;
      };
      P.toFixed = function(dp, rm) {
        var str, y, x = this, Ctor = x.constructor;
        if (dp === void 0) {
          str = finiteToString(x);
        } else {
          checkInt32(dp, 0, MAX_DIGITS);
          if (rm === void 0) rm = Ctor.rounding;
          else checkInt32(rm, 0, 8);
          y = finalise(new Ctor(x), dp + x.e + 1, rm);
          str = finiteToString(y, false, dp + y.e + 1);
        }
        return x.isNeg() && !x.isZero() ? "-" + str : str;
      };
      P.toFraction = function(maxD) {
        var d, d0, d1, d2, e, k, n, n0, n1, pr, q, r, x = this, xd = x.d, Ctor = x.constructor;
        if (!xd) return new Ctor(x);
        n1 = d0 = new Ctor(1);
        d1 = n0 = new Ctor(0);
        d = new Ctor(d1);
        e = d.e = getPrecision(xd) - x.e - 1;
        k = e % LOG_BASE;
        d.d[0] = mathpow(10, k < 0 ? LOG_BASE + k : k);
        if (maxD == null) {
          maxD = e > 0 ? d : n1;
        } else {
          n = new Ctor(maxD);
          if (!n.isInt() || n.lt(n1)) throw Error(invalidArgument + n);
          maxD = n.gt(d) ? e > 0 ? d : n1 : n;
        }
        external = false;
        n = new Ctor(digitsToString(xd));
        pr = Ctor.precision;
        Ctor.precision = e = xd.length * LOG_BASE * 2;
        for (; ; ) {
          q = divide(n, d, 0, 1, 1);
          d2 = d0.plus(q.times(d1));
          if (d2.cmp(maxD) == 1) break;
          d0 = d1;
          d1 = d2;
          d2 = n1;
          n1 = n0.plus(q.times(d2));
          n0 = d2;
          d2 = d;
          d = n.minus(q.times(d2));
          n = d2;
        }
        d2 = divide(maxD.minus(d0), d1, 0, 1, 1);
        n0 = n0.plus(d2.times(n1));
        d0 = d0.plus(d2.times(d1));
        n0.s = n1.s = x.s;
        r = divide(n1, d1, e, 1).minus(x).abs().cmp(divide(n0, d0, e, 1).minus(x).abs()) < 1 ? [n1, d1] : [n0, d0];
        Ctor.precision = pr;
        external = true;
        return r;
      };
      P.toHexadecimal = P.toHex = function(sd, rm) {
        return toStringBinary(this, 16, sd, rm);
      };
      P.toNearest = function(y, rm) {
        var x = this, Ctor = x.constructor;
        x = new Ctor(x);
        if (y == null) {
          if (!x.d) return x;
          y = new Ctor(1);
          rm = Ctor.rounding;
        } else {
          y = new Ctor(y);
          if (rm === void 0) {
            rm = Ctor.rounding;
          } else {
            checkInt32(rm, 0, 8);
          }
          if (!x.d) return y.s ? x : y;
          if (!y.d) {
            if (y.s) y.s = x.s;
            return y;
          }
        }
        if (y.d[0]) {
          external = false;
          x = divide(x, y, 0, rm, 1).times(y);
          external = true;
          finalise(x);
        } else {
          y.s = x.s;
          x = y;
        }
        return x;
      };
      P.toNumber = function() {
        return +this;
      };
      P.toOctal = function(sd, rm) {
        return toStringBinary(this, 8, sd, rm);
      };
      P.toPower = P.pow = function(y) {
        var e, k, pr, r, rm, s, x = this, Ctor = x.constructor, yn = +(y = new Ctor(y));
        if (!x.d || !y.d || !x.d[0] || !y.d[0]) return new Ctor(mathpow(+x, yn));
        x = new Ctor(x);
        if (x.eq(1)) return x;
        pr = Ctor.precision;
        rm = Ctor.rounding;
        if (y.eq(1)) return finalise(x, pr, rm);
        e = mathfloor(y.e / LOG_BASE);
        if (e >= y.d.length - 1 && (k = yn < 0 ? -yn : yn) <= MAX_SAFE_INTEGER) {
          r = intPow(Ctor, x, k, pr);
          return y.s < 0 ? new Ctor(1).div(r) : finalise(r, pr, rm);
        }
        s = x.s;
        if (s < 0) {
          if (e < y.d.length - 1) return new Ctor(NaN);
          if ((y.d[e] & 1) == 0) s = 1;
          if (x.e == 0 && x.d[0] == 1 && x.d.length == 1) {
            x.s = s;
            return x;
          }
        }
        k = mathpow(+x, yn);
        e = k == 0 || !isFinite(k) ? mathfloor(yn * (Math.log("0." + digitsToString(x.d)) / Math.LN10 + x.e + 1)) : new Ctor(k + "").e;
        if (e > Ctor.maxE + 1 || e < Ctor.minE - 1) return new Ctor(e > 0 ? s / 0 : 0);
        external = false;
        Ctor.rounding = x.s = 1;
        k = Math.min(12, (e + "").length);
        r = naturalExponential(y.times(naturalLogarithm(x, pr + k)), pr);
        if (r.d) {
          r = finalise(r, pr + 5, 1);
          if (checkRoundingDigits(r.d, pr, rm)) {
            e = pr + 10;
            r = finalise(naturalExponential(y.times(naturalLogarithm(x, e + k)), e), e + 5, 1);
            if (+digitsToString(r.d).slice(pr + 1, pr + 15) + 1 == 1e14) {
              r = finalise(r, pr + 1, 0);
            }
          }
        }
        r.s = s;
        external = true;
        Ctor.rounding = rm;
        return finalise(r, pr, rm);
      };
      P.toPrecision = function(sd, rm) {
        var str, x = this, Ctor = x.constructor;
        if (sd === void 0) {
          str = finiteToString(x, x.e <= Ctor.toExpNeg || x.e >= Ctor.toExpPos);
        } else {
          checkInt32(sd, 1, MAX_DIGITS);
          if (rm === void 0) rm = Ctor.rounding;
          else checkInt32(rm, 0, 8);
          x = finalise(new Ctor(x), sd, rm);
          str = finiteToString(x, sd <= x.e || x.e <= Ctor.toExpNeg, sd);
        }
        return x.isNeg() && !x.isZero() ? "-" + str : str;
      };
      P.toSignificantDigits = P.toSD = function(sd, rm) {
        var x = this, Ctor = x.constructor;
        if (sd === void 0) {
          sd = Ctor.precision;
          rm = Ctor.rounding;
        } else {
          checkInt32(sd, 1, MAX_DIGITS);
          if (rm === void 0) rm = Ctor.rounding;
          else checkInt32(rm, 0, 8);
        }
        return finalise(new Ctor(x), sd, rm);
      };
      P.toString = function() {
        var x = this, Ctor = x.constructor, str = finiteToString(x, x.e <= Ctor.toExpNeg || x.e >= Ctor.toExpPos);
        return x.isNeg() && !x.isZero() ? "-" + str : str;
      };
      P.truncated = P.trunc = function() {
        return finalise(new this.constructor(this), this.e + 1, 1);
      };
      P.valueOf = P.toJSON = function() {
        var x = this, Ctor = x.constructor, str = finiteToString(x, x.e <= Ctor.toExpNeg || x.e >= Ctor.toExpPos);
        return x.isNeg() ? "-" + str : str;
      };
      function digitsToString(d) {
        var i, k, ws, indexOfLastWord = d.length - 1, str = "", w = d[0];
        if (indexOfLastWord > 0) {
          str += w;
          for (i = 1; i < indexOfLastWord; i++) {
            ws = d[i] + "";
            k = LOG_BASE - ws.length;
            if (k) str += getZeroString(k);
            str += ws;
          }
          w = d[i];
          ws = w + "";
          k = LOG_BASE - ws.length;
          if (k) str += getZeroString(k);
        } else if (w === 0) {
          return "0";
        }
        for (; w % 10 === 0; ) w /= 10;
        return str + w;
      }
      function checkInt32(i, min2, max2) {
        if (i !== ~~i || i < min2 || i > max2) {
          throw Error(invalidArgument + i);
        }
      }
      function checkRoundingDigits(d, i, rm, repeating) {
        var di, k, r, rd;
        for (k = d[0]; k >= 10; k /= 10) --i;
        if (--i < 0) {
          i += LOG_BASE;
          di = 0;
        } else {
          di = Math.ceil((i + 1) / LOG_BASE);
          i %= LOG_BASE;
        }
        k = mathpow(10, LOG_BASE - i);
        rd = d[di] % k | 0;
        if (repeating == null) {
          if (i < 3) {
            if (i == 0) rd = rd / 100 | 0;
            else if (i == 1) rd = rd / 10 | 0;
            r = rm < 4 && rd == 99999 || rm > 3 && rd == 49999 || rd == 5e4 || rd == 0;
          } else {
            r = (rm < 4 && rd + 1 == k || rm > 3 && rd + 1 == k / 2) && (d[di + 1] / k / 100 | 0) == mathpow(10, i - 2) - 1 || (rd == k / 2 || rd == 0) && (d[di + 1] / k / 100 | 0) == 0;
          }
        } else {
          if (i < 4) {
            if (i == 0) rd = rd / 1e3 | 0;
            else if (i == 1) rd = rd / 100 | 0;
            else if (i == 2) rd = rd / 10 | 0;
            r = (repeating || rm < 4) && rd == 9999 || !repeating && rm > 3 && rd == 4999;
          } else {
            r = ((repeating || rm < 4) && rd + 1 == k || !repeating && rm > 3 && rd + 1 == k / 2) && (d[di + 1] / k / 1e3 | 0) == mathpow(10, i - 3) - 1;
          }
        }
        return r;
      }
      function convertBase(str, baseIn, baseOut) {
        var j, arr = [0], arrL, i = 0, strL = str.length;
        for (; i < strL; ) {
          for (arrL = arr.length; arrL--; ) arr[arrL] *= baseIn;
          arr[0] += NUMERALS.indexOf(str.charAt(i++));
          for (j = 0; j < arr.length; j++) {
            if (arr[j] > baseOut - 1) {
              if (arr[j + 1] === void 0) arr[j + 1] = 0;
              arr[j + 1] += arr[j] / baseOut | 0;
              arr[j] %= baseOut;
            }
          }
        }
        return arr.reverse();
      }
      function cosine(Ctor, x) {
        var k, len, y;
        if (x.isZero()) return x;
        len = x.d.length;
        if (len < 32) {
          k = Math.ceil(len / 3);
          y = (1 / tinyPow(4, k)).toString();
        } else {
          k = 16;
          y = "2.3283064365386962890625e-10";
        }
        Ctor.precision += k;
        x = taylorSeries(Ctor, 1, x.times(y), new Ctor(1));
        for (var i = k; i--; ) {
          var cos2x = x.times(x);
          x = cos2x.times(cos2x).minus(cos2x).times(8).plus(1);
        }
        Ctor.precision -= k;
        return x;
      }
      var divide = /* @__PURE__ */ function() {
        function multiplyInteger(x, k, base) {
          var temp, carry = 0, i = x.length;
          for (x = x.slice(); i--; ) {
            temp = x[i] * k + carry;
            x[i] = temp % base | 0;
            carry = temp / base | 0;
          }
          if (carry) x.unshift(carry);
          return x;
        }
        function compare(a, b, aL, bL) {
          var i, r;
          if (aL != bL) {
            r = aL > bL ? 1 : -1;
          } else {
            for (i = r = 0; i < aL; i++) {
              if (a[i] != b[i]) {
                r = a[i] > b[i] ? 1 : -1;
                break;
              }
            }
          }
          return r;
        }
        function subtract(a, b, aL, base) {
          var i = 0;
          for (; aL--; ) {
            a[aL] -= i;
            i = a[aL] < b[aL] ? 1 : 0;
            a[aL] = i * base + a[aL] - b[aL];
          }
          for (; !a[0] && a.length > 1; ) a.shift();
        }
        return function(x, y, pr, rm, dp, base) {
          var cmp, e, i, k, logBase, more, prod, prodL, q, qd, rem, remL, rem0, sd, t, xi, xL, yd0, yL, yz, Ctor = x.constructor, sign2 = x.s == y.s ? 1 : -1, xd = x.d, yd = y.d;
          if (!xd || !xd[0] || !yd || !yd[0]) {
            return new Ctor(
              // Return NaN if either NaN, or both Infinity or 0.
              !x.s || !y.s || (xd ? yd && xd[0] == yd[0] : !yd) ? NaN : (
                // Return ±0 if x is 0 or y is ±Infinity, or return ±Infinity as y is 0.
                xd && xd[0] == 0 || !yd ? sign2 * 0 : sign2 / 0
              )
            );
          }
          if (base) {
            logBase = 1;
            e = x.e - y.e;
          } else {
            base = BASE;
            logBase = LOG_BASE;
            e = mathfloor(x.e / logBase) - mathfloor(y.e / logBase);
          }
          yL = yd.length;
          xL = xd.length;
          q = new Ctor(sign2);
          qd = q.d = [];
          for (i = 0; yd[i] == (xd[i] || 0); i++) ;
          if (yd[i] > (xd[i] || 0)) e--;
          if (pr == null) {
            sd = pr = Ctor.precision;
            rm = Ctor.rounding;
          } else if (dp) {
            sd = pr + (x.e - y.e) + 1;
          } else {
            sd = pr;
          }
          if (sd < 0) {
            qd.push(1);
            more = true;
          } else {
            sd = sd / logBase + 2 | 0;
            i = 0;
            if (yL == 1) {
              k = 0;
              yd = yd[0];
              sd++;
              for (; (i < xL || k) && sd--; i++) {
                t = k * base + (xd[i] || 0);
                qd[i] = t / yd | 0;
                k = t % yd | 0;
              }
              more = k || i < xL;
            } else {
              k = base / (yd[0] + 1) | 0;
              if (k > 1) {
                yd = multiplyInteger(yd, k, base);
                xd = multiplyInteger(xd, k, base);
                yL = yd.length;
                xL = xd.length;
              }
              xi = yL;
              rem = xd.slice(0, yL);
              remL = rem.length;
              for (; remL < yL; ) rem[remL++] = 0;
              yz = yd.slice();
              yz.unshift(0);
              yd0 = yd[0];
              if (yd[1] >= base / 2) ++yd0;
              do {
                k = 0;
                cmp = compare(yd, rem, yL, remL);
                if (cmp < 0) {
                  rem0 = rem[0];
                  if (yL != remL) rem0 = rem0 * base + (rem[1] || 0);
                  k = rem0 / yd0 | 0;
                  if (k > 1) {
                    if (k >= base) k = base - 1;
                    prod = multiplyInteger(yd, k, base);
                    prodL = prod.length;
                    remL = rem.length;
                    cmp = compare(prod, rem, prodL, remL);
                    if (cmp == 1) {
                      k--;
                      subtract(prod, yL < prodL ? yz : yd, prodL, base);
                    }
                  } else {
                    if (k == 0) cmp = k = 1;
                    prod = yd.slice();
                  }
                  prodL = prod.length;
                  if (prodL < remL) prod.unshift(0);
                  subtract(rem, prod, remL, base);
                  if (cmp == -1) {
                    remL = rem.length;
                    cmp = compare(yd, rem, yL, remL);
                    if (cmp < 1) {
                      k++;
                      subtract(rem, yL < remL ? yz : yd, remL, base);
                    }
                  }
                  remL = rem.length;
                } else if (cmp === 0) {
                  k++;
                  rem = [0];
                }
                qd[i++] = k;
                if (cmp && rem[0]) {
                  rem[remL++] = xd[xi] || 0;
                } else {
                  rem = [xd[xi]];
                  remL = 1;
                }
              } while ((xi++ < xL || rem[0] !== void 0) && sd--);
              more = rem[0] !== void 0;
            }
            if (!qd[0]) qd.shift();
          }
          if (logBase == 1) {
            q.e = e;
            inexact = more;
          } else {
            for (i = 1, k = qd[0]; k >= 10; k /= 10) i++;
            q.e = i + e * logBase - 1;
            finalise(q, dp ? pr + q.e + 1 : pr, rm, more);
          }
          return q;
        };
      }();
      function finalise(x, sd, rm, isTruncated) {
        var digits, i, j, k, rd, roundUp, w, xd, xdi, Ctor = x.constructor;
        out: if (sd != null) {
          xd = x.d;
          if (!xd) return x;
          for (digits = 1, k = xd[0]; k >= 10; k /= 10) digits++;
          i = sd - digits;
          if (i < 0) {
            i += LOG_BASE;
            j = sd;
            w = xd[xdi = 0];
            rd = w / mathpow(10, digits - j - 1) % 10 | 0;
          } else {
            xdi = Math.ceil((i + 1) / LOG_BASE);
            k = xd.length;
            if (xdi >= k) {
              if (isTruncated) {
                for (; k++ <= xdi; ) xd.push(0);
                w = rd = 0;
                digits = 1;
                i %= LOG_BASE;
                j = i - LOG_BASE + 1;
              } else {
                break out;
              }
            } else {
              w = k = xd[xdi];
              for (digits = 1; k >= 10; k /= 10) digits++;
              i %= LOG_BASE;
              j = i - LOG_BASE + digits;
              rd = j < 0 ? 0 : w / mathpow(10, digits - j - 1) % 10 | 0;
            }
          }
          isTruncated = isTruncated || sd < 0 || xd[xdi + 1] !== void 0 || (j < 0 ? w : w % mathpow(10, digits - j - 1));
          roundUp = rm < 4 ? (rd || isTruncated) && (rm == 0 || rm == (x.s < 0 ? 3 : 2)) : rd > 5 || rd == 5 && (rm == 4 || isTruncated || rm == 6 && // Check whether the digit to the left of the rounding digit is odd.
          (i > 0 ? j > 0 ? w / mathpow(10, digits - j) : 0 : xd[xdi - 1]) % 10 & 1 || rm == (x.s < 0 ? 8 : 7));
          if (sd < 1 || !xd[0]) {
            xd.length = 0;
            if (roundUp) {
              sd -= x.e + 1;
              xd[0] = mathpow(10, (LOG_BASE - sd % LOG_BASE) % LOG_BASE);
              x.e = -sd || 0;
            } else {
              xd[0] = x.e = 0;
            }
            return x;
          }
          if (i == 0) {
            xd.length = xdi;
            k = 1;
            xdi--;
          } else {
            xd.length = xdi + 1;
            k = mathpow(10, LOG_BASE - i);
            xd[xdi] = j > 0 ? (w / mathpow(10, digits - j) % mathpow(10, j) | 0) * k : 0;
          }
          if (roundUp) {
            for (; ; ) {
              if (xdi == 0) {
                for (i = 1, j = xd[0]; j >= 10; j /= 10) i++;
                j = xd[0] += k;
                for (k = 1; j >= 10; j /= 10) k++;
                if (i != k) {
                  x.e++;
                  if (xd[0] == BASE) xd[0] = 1;
                }
                break;
              } else {
                xd[xdi] += k;
                if (xd[xdi] != BASE) break;
                xd[xdi--] = 0;
                k = 1;
              }
            }
          }
          for (i = xd.length; xd[--i] === 0; ) xd.pop();
        }
        if (external) {
          if (x.e > Ctor.maxE) {
            x.d = null;
            x.e = NaN;
          } else if (x.e < Ctor.minE) {
            x.e = 0;
            x.d = [0];
          }
        }
        return x;
      }
      function finiteToString(x, isExp, sd) {
        if (!x.isFinite()) return nonFiniteToString(x);
        var k, e = x.e, str = digitsToString(x.d), len = str.length;
        if (isExp) {
          if (sd && (k = sd - len) > 0) {
            str = str.charAt(0) + "." + str.slice(1) + getZeroString(k);
          } else if (len > 1) {
            str = str.charAt(0) + "." + str.slice(1);
          }
          str = str + (x.e < 0 ? "e" : "e+") + x.e;
        } else if (e < 0) {
          str = "0." + getZeroString(-e - 1) + str;
          if (sd && (k = sd - len) > 0) str += getZeroString(k);
        } else if (e >= len) {
          str += getZeroString(e + 1 - len);
          if (sd && (k = sd - e - 1) > 0) str = str + "." + getZeroString(k);
        } else {
          if ((k = e + 1) < len) str = str.slice(0, k) + "." + str.slice(k);
          if (sd && (k = sd - len) > 0) {
            if (e + 1 === len) str += ".";
            str += getZeroString(k);
          }
        }
        return str;
      }
      function getBase10Exponent(digits, e) {
        var w = digits[0];
        for (e *= LOG_BASE; w >= 10; w /= 10) e++;
        return e;
      }
      function getLn10(Ctor, sd, pr) {
        if (sd > LN10_PRECISION) {
          external = true;
          if (pr) Ctor.precision = pr;
          throw Error(precisionLimitExceeded);
        }
        return finalise(new Ctor(LN10), sd, 1, true);
      }
      function getPi(Ctor, sd, rm) {
        if (sd > PI_PRECISION) throw Error(precisionLimitExceeded);
        return finalise(new Ctor(PI), sd, rm, true);
      }
      function getPrecision(digits) {
        var w = digits.length - 1, len = w * LOG_BASE + 1;
        w = digits[w];
        if (w) {
          for (; w % 10 == 0; w /= 10) len--;
          for (w = digits[0]; w >= 10; w /= 10) len++;
        }
        return len;
      }
      function getZeroString(k) {
        var zs = "";
        for (; k--; ) zs += "0";
        return zs;
      }
      function intPow(Ctor, x, n, pr) {
        var isTruncated, r = new Ctor(1), k = Math.ceil(pr / LOG_BASE + 4);
        external = false;
        for (; ; ) {
          if (n % 2) {
            r = r.times(x);
            if (truncate(r.d, k)) isTruncated = true;
          }
          n = mathfloor(n / 2);
          if (n === 0) {
            n = r.d.length - 1;
            if (isTruncated && r.d[n] === 0) ++r.d[n];
            break;
          }
          x = x.times(x);
          truncate(x.d, k);
        }
        external = true;
        return r;
      }
      function isOdd(n) {
        return n.d[n.d.length - 1] & 1;
      }
      function maxOrMin(Ctor, args, ltgt) {
        var y, x = new Ctor(args[0]), i = 0;
        for (; ++i < args.length; ) {
          y = new Ctor(args[i]);
          if (!y.s) {
            x = y;
            break;
          } else if (x[ltgt](y)) {
            x = y;
          }
        }
        return x;
      }
      function naturalExponential(x, sd) {
        var denominator, guard, j, pow2, sum2, t, wpr, rep = 0, i = 0, k = 0, Ctor = x.constructor, rm = Ctor.rounding, pr = Ctor.precision;
        if (!x.d || !x.d[0] || x.e > 17) {
          return new Ctor(x.d ? !x.d[0] ? 1 : x.s < 0 ? 0 : 1 / 0 : x.s ? x.s < 0 ? 0 : x : 0 / 0);
        }
        if (sd == null) {
          external = false;
          wpr = pr;
        } else {
          wpr = sd;
        }
        t = new Ctor(0.03125);
        while (x.e > -2) {
          x = x.times(t);
          k += 5;
        }
        guard = Math.log(mathpow(2, k)) / Math.LN10 * 2 + 5 | 0;
        wpr += guard;
        denominator = pow2 = sum2 = new Ctor(1);
        Ctor.precision = wpr;
        for (; ; ) {
          pow2 = finalise(pow2.times(x), wpr, 1);
          denominator = denominator.times(++i);
          t = sum2.plus(divide(pow2, denominator, wpr, 1));
          if (digitsToString(t.d).slice(0, wpr) === digitsToString(sum2.d).slice(0, wpr)) {
            j = k;
            while (j--) sum2 = finalise(sum2.times(sum2), wpr, 1);
            if (sd == null) {
              if (rep < 3 && checkRoundingDigits(sum2.d, wpr - guard, rm, rep)) {
                Ctor.precision = wpr += 10;
                denominator = pow2 = t = new Ctor(1);
                i = 0;
                rep++;
              } else {
                return finalise(sum2, Ctor.precision = pr, rm, external = true);
              }
            } else {
              Ctor.precision = pr;
              return sum2;
            }
          }
          sum2 = t;
        }
      }
      function naturalLogarithm(y, sd) {
        var c, c0, denominator, e, numerator, rep, sum2, t, wpr, x1, x2, n = 1, guard = 10, x = y, xd = x.d, Ctor = x.constructor, rm = Ctor.rounding, pr = Ctor.precision;
        if (x.s < 0 || !xd || !xd[0] || !x.e && xd[0] == 1 && xd.length == 1) {
          return new Ctor(xd && !xd[0] ? -1 / 0 : x.s != 1 ? NaN : xd ? 0 : x);
        }
        if (sd == null) {
          external = false;
          wpr = pr;
        } else {
          wpr = sd;
        }
        Ctor.precision = wpr += guard;
        c = digitsToString(xd);
        c0 = c.charAt(0);
        if (Math.abs(e = x.e) < 15e14) {
          while (c0 < 7 && c0 != 1 || c0 == 1 && c.charAt(1) > 3) {
            x = x.times(y);
            c = digitsToString(x.d);
            c0 = c.charAt(0);
            n++;
          }
          e = x.e;
          if (c0 > 1) {
            x = new Ctor("0." + c);
            e++;
          } else {
            x = new Ctor(c0 + "." + c.slice(1));
          }
        } else {
          t = getLn10(Ctor, wpr + 2, pr).times(e + "");
          x = naturalLogarithm(new Ctor(c0 + "." + c.slice(1)), wpr - guard).plus(t);
          Ctor.precision = pr;
          return sd == null ? finalise(x, pr, rm, external = true) : x;
        }
        x1 = x;
        sum2 = numerator = x = divide(x.minus(1), x.plus(1), wpr, 1);
        x2 = finalise(x.times(x), wpr, 1);
        denominator = 3;
        for (; ; ) {
          numerator = finalise(numerator.times(x2), wpr, 1);
          t = sum2.plus(divide(numerator, new Ctor(denominator), wpr, 1));
          if (digitsToString(t.d).slice(0, wpr) === digitsToString(sum2.d).slice(0, wpr)) {
            sum2 = sum2.times(2);
            if (e !== 0) sum2 = sum2.plus(getLn10(Ctor, wpr + 2, pr).times(e + ""));
            sum2 = divide(sum2, new Ctor(n), wpr, 1);
            if (sd == null) {
              if (checkRoundingDigits(sum2.d, wpr - guard, rm, rep)) {
                Ctor.precision = wpr += guard;
                t = numerator = x = divide(x1.minus(1), x1.plus(1), wpr, 1);
                x2 = finalise(x.times(x), wpr, 1);
                denominator = rep = 1;
              } else {
                return finalise(sum2, Ctor.precision = pr, rm, external = true);
              }
            } else {
              Ctor.precision = pr;
              return sum2;
            }
          }
          sum2 = t;
          denominator += 2;
        }
      }
      function nonFiniteToString(x) {
        return String(x.s * x.s / 0);
      }
      function parseDecimal(x, str) {
        var e, i, len;
        if ((e = str.indexOf(".")) > -1) str = str.replace(".", "");
        if ((i = str.search(/e/i)) > 0) {
          if (e < 0) e = i;
          e += +str.slice(i + 1);
          str = str.substring(0, i);
        } else if (e < 0) {
          e = str.length;
        }
        for (i = 0; str.charCodeAt(i) === 48; i++) ;
        for (len = str.length; str.charCodeAt(len - 1) === 48; --len) ;
        str = str.slice(i, len);
        if (str) {
          len -= i;
          x.e = e = e - i - 1;
          x.d = [];
          i = (e + 1) % LOG_BASE;
          if (e < 0) i += LOG_BASE;
          if (i < len) {
            if (i) x.d.push(+str.slice(0, i));
            for (len -= LOG_BASE; i < len; ) x.d.push(+str.slice(i, i += LOG_BASE));
            str = str.slice(i);
            i = LOG_BASE - str.length;
          } else {
            i -= len;
          }
          for (; i--; ) str += "0";
          x.d.push(+str);
          if (external) {
            if (x.e > x.constructor.maxE) {
              x.d = null;
              x.e = NaN;
            } else if (x.e < x.constructor.minE) {
              x.e = 0;
              x.d = [0];
            }
          }
        } else {
          x.e = 0;
          x.d = [0];
        }
        return x;
      }
      function parseOther(x, str) {
        var base, Ctor, divisor, i, isFloat, len, p, xd, xe;
        if (str.indexOf("_") > -1) {
          str = str.replace(/(\d)_(?=\d)/g, "$1");
          if (isDecimal.test(str)) return parseDecimal(x, str);
        } else if (str === "Infinity" || str === "NaN") {
          if (!+str) x.s = NaN;
          x.e = NaN;
          x.d = null;
          return x;
        }
        if (isHex.test(str)) {
          base = 16;
          str = str.toLowerCase();
        } else if (isBinary.test(str)) {
          base = 2;
        } else if (isOctal.test(str)) {
          base = 8;
        } else {
          throw Error(invalidArgument + str);
        }
        i = str.search(/p/i);
        if (i > 0) {
          p = +str.slice(i + 1);
          str = str.substring(2, i);
        } else {
          str = str.slice(2);
        }
        i = str.indexOf(".");
        isFloat = i >= 0;
        Ctor = x.constructor;
        if (isFloat) {
          str = str.replace(".", "");
          len = str.length;
          i = len - i;
          divisor = intPow(Ctor, new Ctor(base), i, i * 2);
        }
        xd = convertBase(str, base, BASE);
        xe = xd.length - 1;
        for (i = xe; xd[i] === 0; --i) xd.pop();
        if (i < 0) return new Ctor(x.s * 0);
        x.e = getBase10Exponent(xd, xe);
        x.d = xd;
        external = false;
        if (isFloat) x = divide(x, divisor, len * 4);
        if (p) x = x.times(Math.abs(p) < 54 ? mathpow(2, p) : Decimal2.pow(2, p));
        external = true;
        return x;
      }
      function sine(Ctor, x) {
        var k, len = x.d.length;
        if (len < 3) {
          return x.isZero() ? x : taylorSeries(Ctor, 2, x, x);
        }
        k = 1.4 * Math.sqrt(len);
        k = k > 16 ? 16 : k | 0;
        x = x.times(1 / tinyPow(5, k));
        x = taylorSeries(Ctor, 2, x, x);
        var sin2_x, d5 = new Ctor(5), d16 = new Ctor(16), d20 = new Ctor(20);
        for (; k--; ) {
          sin2_x = x.times(x);
          x = x.times(d5.plus(sin2_x.times(d16.times(sin2_x).minus(d20))));
        }
        return x;
      }
      function taylorSeries(Ctor, n, x, y, isHyperbolic) {
        var j, t, u, x2, i = 1, pr = Ctor.precision, k = Math.ceil(pr / LOG_BASE);
        external = false;
        x2 = x.times(x);
        u = new Ctor(y);
        for (; ; ) {
          t = divide(u.times(x2), new Ctor(n++ * n++), pr, 1);
          u = isHyperbolic ? y.plus(t) : y.minus(t);
          y = divide(t.times(x2), new Ctor(n++ * n++), pr, 1);
          t = u.plus(y);
          if (t.d[k] !== void 0) {
            for (j = k; t.d[j] === u.d[j] && j--; ) ;
            if (j == -1) break;
          }
          j = u;
          u = y;
          y = t;
          t = j;
          i++;
        }
        external = true;
        t.d.length = k + 1;
        return t;
      }
      function tinyPow(b, e) {
        var n = b;
        while (--e) n *= b;
        return n;
      }
      function toLessThanHalfPi(Ctor, x) {
        var t, isNeg = x.s < 0, pi = getPi(Ctor, Ctor.precision, 1), halfPi = pi.times(0.5);
        x = x.abs();
        if (x.lte(halfPi)) {
          quadrant = isNeg ? 4 : 1;
          return x;
        }
        t = x.divToInt(pi);
        if (t.isZero()) {
          quadrant = isNeg ? 3 : 2;
        } else {
          x = x.minus(t.times(pi));
          if (x.lte(halfPi)) {
            quadrant = isOdd(t) ? isNeg ? 2 : 3 : isNeg ? 4 : 1;
            return x;
          }
          quadrant = isOdd(t) ? isNeg ? 1 : 4 : isNeg ? 3 : 2;
        }
        return x.minus(pi).abs();
      }
      function toStringBinary(x, baseOut, sd, rm) {
        var base, e, i, k, len, roundUp, str, xd, y, Ctor = x.constructor, isExp = sd !== void 0;
        if (isExp) {
          checkInt32(sd, 1, MAX_DIGITS);
          if (rm === void 0) rm = Ctor.rounding;
          else checkInt32(rm, 0, 8);
        } else {
          sd = Ctor.precision;
          rm = Ctor.rounding;
        }
        if (!x.isFinite()) {
          str = nonFiniteToString(x);
        } else {
          str = finiteToString(x);
          i = str.indexOf(".");
          if (isExp) {
            base = 2;
            if (baseOut == 16) {
              sd = sd * 4 - 3;
            } else if (baseOut == 8) {
              sd = sd * 3 - 2;
            }
          } else {
            base = baseOut;
          }
          if (i >= 0) {
            str = str.replace(".", "");
            y = new Ctor(1);
            y.e = str.length - i;
            y.d = convertBase(finiteToString(y), 10, base);
            y.e = y.d.length;
          }
          xd = convertBase(str, 10, base);
          e = len = xd.length;
          for (; xd[--len] == 0; ) xd.pop();
          if (!xd[0]) {
            str = isExp ? "0p+0" : "0";
          } else {
            if (i < 0) {
              e--;
            } else {
              x = new Ctor(x);
              x.d = xd;
              x.e = e;
              x = divide(x, y, sd, rm, 0, base);
              xd = x.d;
              e = x.e;
              roundUp = inexact;
            }
            i = xd[sd];
            k = base / 2;
            roundUp = roundUp || xd[sd + 1] !== void 0;
            roundUp = rm < 4 ? (i !== void 0 || roundUp) && (rm === 0 || rm === (x.s < 0 ? 3 : 2)) : i > k || i === k && (rm === 4 || roundUp || rm === 6 && xd[sd - 1] & 1 || rm === (x.s < 0 ? 8 : 7));
            xd.length = sd;
            if (roundUp) {
              for (; ++xd[--sd] > base - 1; ) {
                xd[sd] = 0;
                if (!sd) {
                  ++e;
                  xd.unshift(1);
                }
              }
            }
            for (len = xd.length; !xd[len - 1]; --len) ;
            for (i = 0, str = ""; i < len; i++) str += NUMERALS.charAt(xd[i]);
            if (isExp) {
              if (len > 1) {
                if (baseOut == 16 || baseOut == 8) {
                  i = baseOut == 16 ? 4 : 3;
                  for (--len; len % i; len++) str += "0";
                  xd = convertBase(str, base, baseOut);
                  for (len = xd.length; !xd[len - 1]; --len) ;
                  for (i = 1, str = "1."; i < len; i++) str += NUMERALS.charAt(xd[i]);
                } else {
                  str = str.charAt(0) + "." + str.slice(1);
                }
              }
              str = str + (e < 0 ? "p" : "p+") + e;
            } else if (e < 0) {
              for (; ++e; ) str = "0" + str;
              str = "0." + str;
            } else {
              if (++e > len) for (e -= len; e--; ) str += "0";
              else if (e < len) str = str.slice(0, e) + "." + str.slice(e);
            }
          }
          str = (baseOut == 16 ? "0x" : baseOut == 2 ? "0b" : baseOut == 8 ? "0o" : "") + str;
        }
        return x.s < 0 ? "-" + str : str;
      }
      function truncate(arr, len) {
        if (arr.length > len) {
          arr.length = len;
          return true;
        }
      }
      function abs(x) {
        return new this(x).abs();
      }
      function acos(x) {
        return new this(x).acos();
      }
      function acosh(x) {
        return new this(x).acosh();
      }
      function add(x, y) {
        return new this(x).plus(y);
      }
      function asin(x) {
        return new this(x).asin();
      }
      function asinh(x) {
        return new this(x).asinh();
      }
      function atan(x) {
        return new this(x).atan();
      }
      function atanh(x) {
        return new this(x).atanh();
      }
      function atan2(y, x) {
        y = new this(y);
        x = new this(x);
        var r, pr = this.precision, rm = this.rounding, wpr = pr + 4;
        if (!y.s || !x.s) {
          r = new this(NaN);
        } else if (!y.d && !x.d) {
          r = getPi(this, wpr, 1).times(x.s > 0 ? 0.25 : 0.75);
          r.s = y.s;
        } else if (!x.d || y.isZero()) {
          r = x.s < 0 ? getPi(this, pr, rm) : new this(0);
          r.s = y.s;
        } else if (!y.d || x.isZero()) {
          r = getPi(this, wpr, 1).times(0.5);
          r.s = y.s;
        } else if (x.s < 0) {
          this.precision = wpr;
          this.rounding = 1;
          r = this.atan(divide(y, x, wpr, 1));
          x = getPi(this, wpr, 1);
          this.precision = pr;
          this.rounding = rm;
          r = y.s < 0 ? r.minus(x) : r.plus(x);
        } else {
          r = this.atan(divide(y, x, wpr, 1));
        }
        return r;
      }
      function cbrt(x) {
        return new this(x).cbrt();
      }
      function ceil(x) {
        return finalise(x = new this(x), x.e + 1, 2);
      }
      function clamp(x, min2, max2) {
        return new this(x).clamp(min2, max2);
      }
      function config(obj) {
        if (!obj || typeof obj !== "object") throw Error(decimalError + "Object expected");
        var i, p, v, useDefaults = obj.defaults === true, ps = [
          "precision",
          1,
          MAX_DIGITS,
          "rounding",
          0,
          8,
          "toExpNeg",
          -EXP_LIMIT,
          0,
          "toExpPos",
          0,
          EXP_LIMIT,
          "maxE",
          0,
          EXP_LIMIT,
          "minE",
          -EXP_LIMIT,
          0,
          "modulo",
          0,
          9
        ];
        for (i = 0; i < ps.length; i += 3) {
          if (p = ps[i], useDefaults) this[p] = DEFAULTS[p];
          if ((v = obj[p]) !== void 0) {
            if (mathfloor(v) === v && v >= ps[i + 1] && v <= ps[i + 2]) this[p] = v;
            else throw Error(invalidArgument + p + ": " + v);
          }
        }
        if (p = "crypto", useDefaults) this[p] = DEFAULTS[p];
        if ((v = obj[p]) !== void 0) {
          if (v === true || v === false || v === 0 || v === 1) {
            if (v) {
              if (typeof crypto != "undefined" && crypto && (crypto.getRandomValues || crypto.randomBytes)) {
                this[p] = true;
              } else {
                throw Error(cryptoUnavailable);
              }
            } else {
              this[p] = false;
            }
          } else {
            throw Error(invalidArgument + p + ": " + v);
          }
        }
        return this;
      }
      function cos(x) {
        return new this(x).cos();
      }
      function cosh(x) {
        return new this(x).cosh();
      }
      function clone(obj) {
        var i, p, ps;
        function Decimal3(v) {
          var e, i2, t, x = this;
          if (!(x instanceof Decimal3)) return new Decimal3(v);
          x.constructor = Decimal3;
          if (isDecimalInstance(v)) {
            x.s = v.s;
            if (external) {
              if (!v.d || v.e > Decimal3.maxE) {
                x.e = NaN;
                x.d = null;
              } else if (v.e < Decimal3.minE) {
                x.e = 0;
                x.d = [0];
              } else {
                x.e = v.e;
                x.d = v.d.slice();
              }
            } else {
              x.e = v.e;
              x.d = v.d ? v.d.slice() : v.d;
            }
            return;
          }
          t = typeof v;
          if (t === "number") {
            if (v === 0) {
              x.s = 1 / v < 0 ? -1 : 1;
              x.e = 0;
              x.d = [0];
              return;
            }
            if (v < 0) {
              v = -v;
              x.s = -1;
            } else {
              x.s = 1;
            }
            if (v === ~~v && v < 1e7) {
              for (e = 0, i2 = v; i2 >= 10; i2 /= 10) e++;
              if (external) {
                if (e > Decimal3.maxE) {
                  x.e = NaN;
                  x.d = null;
                } else if (e < Decimal3.minE) {
                  x.e = 0;
                  x.d = [0];
                } else {
                  x.e = e;
                  x.d = [v];
                }
              } else {
                x.e = e;
                x.d = [v];
              }
              return;
            } else if (v * 0 !== 0) {
              if (!v) x.s = NaN;
              x.e = NaN;
              x.d = null;
              return;
            }
            return parseDecimal(x, v.toString());
          } else if (t !== "string") {
            throw Error(invalidArgument + v);
          }
          if ((i2 = v.charCodeAt(0)) === 45) {
            v = v.slice(1);
            x.s = -1;
          } else {
            if (i2 === 43) v = v.slice(1);
            x.s = 1;
          }
          return isDecimal.test(v) ? parseDecimal(x, v) : parseOther(x, v);
        }
        Decimal3.prototype = P;
        Decimal3.ROUND_UP = 0;
        Decimal3.ROUND_DOWN = 1;
        Decimal3.ROUND_CEIL = 2;
        Decimal3.ROUND_FLOOR = 3;
        Decimal3.ROUND_HALF_UP = 4;
        Decimal3.ROUND_HALF_DOWN = 5;
        Decimal3.ROUND_HALF_EVEN = 6;
        Decimal3.ROUND_HALF_CEIL = 7;
        Decimal3.ROUND_HALF_FLOOR = 8;
        Decimal3.EUCLID = 9;
        Decimal3.config = Decimal3.set = config;
        Decimal3.clone = clone;
        Decimal3.isDecimal = isDecimalInstance;
        Decimal3.abs = abs;
        Decimal3.acos = acos;
        Decimal3.acosh = acosh;
        Decimal3.add = add;
        Decimal3.asin = asin;
        Decimal3.asinh = asinh;
        Decimal3.atan = atan;
        Decimal3.atanh = atanh;
        Decimal3.atan2 = atan2;
        Decimal3.cbrt = cbrt;
        Decimal3.ceil = ceil;
        Decimal3.clamp = clamp;
        Decimal3.cos = cos;
        Decimal3.cosh = cosh;
        Decimal3.div = div;
        Decimal3.exp = exp;
        Decimal3.floor = floor;
        Decimal3.hypot = hypot;
        Decimal3.ln = ln;
        Decimal3.log = log;
        Decimal3.log10 = log10;
        Decimal3.log2 = log2;
        Decimal3.max = max;
        Decimal3.min = min;
        Decimal3.mod = mod;
        Decimal3.mul = mul;
        Decimal3.pow = pow;
        Decimal3.random = random;
        Decimal3.round = round;
        Decimal3.sign = sign;
        Decimal3.sin = sin;
        Decimal3.sinh = sinh;
        Decimal3.sqrt = sqrt;
        Decimal3.sub = sub;
        Decimal3.sum = sum;
        Decimal3.tan = tan;
        Decimal3.tanh = tanh;
        Decimal3.trunc = trunc;
        if (obj === void 0) obj = {};
        if (obj) {
          if (obj.defaults !== true) {
            ps = ["precision", "rounding", "toExpNeg", "toExpPos", "maxE", "minE", "modulo", "crypto"];
            for (i = 0; i < ps.length; ) if (!obj.hasOwnProperty(p = ps[i++])) obj[p] = this[p];
          }
        }
        Decimal3.config(obj);
        return Decimal3;
      }
      function div(x, y) {
        return new this(x).div(y);
      }
      function exp(x) {
        return new this(x).exp();
      }
      function floor(x) {
        return finalise(x = new this(x), x.e + 1, 3);
      }
      function hypot() {
        var i, n, t = new this(0);
        external = false;
        for (i = 0; i < arguments.length; ) {
          n = new this(arguments[i++]);
          if (!n.d) {
            if (n.s) {
              external = true;
              return new this(1 / 0);
            }
            t = n;
          } else if (t.d) {
            t = t.plus(n.times(n));
          }
        }
        external = true;
        return t.sqrt();
      }
      function isDecimalInstance(obj) {
        return obj instanceof Decimal2 || obj && obj.toStringTag === tag || false;
      }
      function ln(x) {
        return new this(x).ln();
      }
      function log(x, y) {
        return new this(x).log(y);
      }
      function log2(x) {
        return new this(x).log(2);
      }
      function log10(x) {
        return new this(x).log(10);
      }
      function max() {
        return maxOrMin(this, arguments, "lt");
      }
      function min() {
        return maxOrMin(this, arguments, "gt");
      }
      function mod(x, y) {
        return new this(x).mod(y);
      }
      function mul(x, y) {
        return new this(x).mul(y);
      }
      function pow(x, y) {
        return new this(x).pow(y);
      }
      function random(sd) {
        var d, e, k, n, i = 0, r = new this(1), rd = [];
        if (sd === void 0) sd = this.precision;
        else checkInt32(sd, 1, MAX_DIGITS);
        k = Math.ceil(sd / LOG_BASE);
        if (!this.crypto) {
          for (; i < k; ) rd[i++] = Math.random() * 1e7 | 0;
        } else if (crypto.getRandomValues) {
          d = crypto.getRandomValues(new Uint32Array(k));
          for (; i < k; ) {
            n = d[i];
            if (n >= 429e7) {
              d[i] = crypto.getRandomValues(new Uint32Array(1))[0];
            } else {
              rd[i++] = n % 1e7;
            }
          }
        } else if (crypto.randomBytes) {
          d = crypto.randomBytes(k *= 4);
          for (; i < k; ) {
            n = d[i] + (d[i + 1] << 8) + (d[i + 2] << 16) + ((d[i + 3] & 127) << 24);
            if (n >= 214e7) {
              crypto.randomBytes(4).copy(d, i);
            } else {
              rd.push(n % 1e7);
              i += 4;
            }
          }
          i = k / 4;
        } else {
          throw Error(cryptoUnavailable);
        }
        k = rd[--i];
        sd %= LOG_BASE;
        if (k && sd) {
          n = mathpow(10, LOG_BASE - sd);
          rd[i] = (k / n | 0) * n;
        }
        for (; rd[i] === 0; i--) rd.pop();
        if (i < 0) {
          e = 0;
          rd = [0];
        } else {
          e = -1;
          for (; rd[0] === 0; e -= LOG_BASE) rd.shift();
          for (k = 1, n = rd[0]; n >= 10; n /= 10) k++;
          if (k < LOG_BASE) e -= LOG_BASE - k;
        }
        r.e = e;
        r.d = rd;
        return r;
      }
      function round(x) {
        return finalise(x = new this(x), x.e + 1, this.rounding);
      }
      function sign(x) {
        x = new this(x);
        return x.d ? x.d[0] ? x.s : 0 * x.s : x.s || NaN;
      }
      function sin(x) {
        return new this(x).sin();
      }
      function sinh(x) {
        return new this(x).sinh();
      }
      function sqrt(x) {
        return new this(x).sqrt();
      }
      function sub(x, y) {
        return new this(x).sub(y);
      }
      function sum() {
        var i = 0, args = arguments, x = new this(args[i]);
        external = false;
        for (; x.s && ++i < args.length; ) x = x.plus(args[i]);
        external = true;
        return finalise(x, this.precision, this.rounding);
      }
      function tan(x) {
        return new this(x).tan();
      }
      function tanh(x) {
        return new this(x).tanh();
      }
      function trunc(x) {
        return finalise(x = new this(x), x.e + 1, 1);
      }
      Decimal2 = clone(DEFAULTS);
      Decimal2.prototype.constructor = Decimal2;
      Decimal2["default"] = Decimal2.Decimal = Decimal2;
      LN10 = new Decimal2(LN10);
      PI = new Decimal2(PI);
      if (typeof define == "function" && define.amd) {
        define(function() {
          return Decimal2;
        });
      } else if (typeof module2 != "undefined" && module2.exports) {
        if (typeof Symbol == "function" && typeof Symbol.iterator == "symbol") {
          P[Symbol["for"]("nodejs.util.inspect.custom")] = P.toString;
          P[Symbol.toStringTag] = "Decimal";
        }
        module2.exports = Decimal2;
      } else {
        if (!globalScope) {
          globalScope = typeof self != "undefined" && self && self.self == self ? self : window;
        }
        noConflict = globalScope.Decimal;
        Decimal2.noConflict = function() {
          globalScope.Decimal = noConflict;
          return Decimal2;
        };
        globalScope.Decimal = Decimal2;
      }
    })(exports2);
  }
});

// node_modules/bn.js/lib/bn.js
var require_bn = __commonJS({
  "node_modules/bn.js/lib/bn.js"(exports2, module2) {
    (function(module3, exports3) {
      "use strict";
      function assert(val, msg) {
        if (!val) throw new Error(msg || "Assertion failed");
      }
      function inherits(ctor, superCtor) {
        ctor.super_ = superCtor;
        var TempCtor = function() {
        };
        TempCtor.prototype = superCtor.prototype;
        ctor.prototype = new TempCtor();
        ctor.prototype.constructor = ctor;
      }
      function BN(number, base, endian) {
        if (BN.isBN(number)) {
          return number;
        }
        this.negative = 0;
        this.words = null;
        this.length = 0;
        this.red = null;
        if (number !== null) {
          if (base === "le" || base === "be") {
            endian = base;
            base = 10;
          }
          this._init(number || 0, base || 10, endian || "be");
        }
      }
      if (typeof module3 === "object") {
        module3.exports = BN;
      } else {
        exports3.BN = BN;
      }
      BN.BN = BN;
      BN.wordSize = 26;
      var Buffer2;
      try {
        if (typeof window !== "undefined" && typeof window.Buffer !== "undefined") {
          Buffer2 = window.Buffer;
        } else {
          Buffer2 = require("buffer").Buffer;
        }
      } catch (e) {
      }
      BN.isBN = function isBN(num) {
        if (num instanceof BN) {
          return true;
        }
        return num !== null && typeof num === "object" && num.constructor.wordSize === BN.wordSize && Array.isArray(num.words);
      };
      BN.max = function max(left, right) {
        if (left.cmp(right) > 0) return left;
        return right;
      };
      BN.min = function min(left, right) {
        if (left.cmp(right) < 0) return left;
        return right;
      };
      BN.prototype._init = function init(number, base, endian) {
        if (typeof number === "number") {
          return this._initNumber(number, base, endian);
        }
        if (typeof number === "object") {
          return this._initArray(number, base, endian);
        }
        if (base === "hex") {
          base = 16;
        }
        assert(base === (base | 0) && base >= 2 && base <= 36);
        number = number.toString().replace(/\s+/g, "");
        var start = 0;
        if (number[0] === "-") {
          start++;
          this.negative = 1;
        }
        if (start < number.length) {
          if (base === 16) {
            this._parseHex(number, start, endian);
          } else {
            this._parseBase(number, base, start);
            if (endian === "le") {
              this._initArray(this.toArray(), base, endian);
            }
          }
        }
      };
      BN.prototype._initNumber = function _initNumber(number, base, endian) {
        if (number < 0) {
          this.negative = 1;
          number = -number;
        }
        if (number < 67108864) {
          this.words = [number & 67108863];
          this.length = 1;
        } else if (number < 4503599627370496) {
          this.words = [
            number & 67108863,
            number / 67108864 & 67108863
          ];
          this.length = 2;
        } else {
          assert(number < 9007199254740992);
          this.words = [
            number & 67108863,
            number / 67108864 & 67108863,
            1
          ];
          this.length = 3;
        }
        if (endian !== "le") return;
        this._initArray(this.toArray(), base, endian);
      };
      BN.prototype._initArray = function _initArray(number, base, endian) {
        assert(typeof number.length === "number");
        if (number.length <= 0) {
          this.words = [0];
          this.length = 1;
          return this;
        }
        this.length = Math.ceil(number.length / 3);
        this.words = new Array(this.length);
        for (var i = 0; i < this.length; i++) {
          this.words[i] = 0;
        }
        var j, w;
        var off = 0;
        if (endian === "be") {
          for (i = number.length - 1, j = 0; i >= 0; i -= 3) {
            w = number[i] | number[i - 1] << 8 | number[i - 2] << 16;
            this.words[j] |= w << off & 67108863;
            this.words[j + 1] = w >>> 26 - off & 67108863;
            off += 24;
            if (off >= 26) {
              off -= 26;
              j++;
            }
          }
        } else if (endian === "le") {
          for (i = 0, j = 0; i < number.length; i += 3) {
            w = number[i] | number[i + 1] << 8 | number[i + 2] << 16;
            this.words[j] |= w << off & 67108863;
            this.words[j + 1] = w >>> 26 - off & 67108863;
            off += 24;
            if (off >= 26) {
              off -= 26;
              j++;
            }
          }
        }
        return this.strip();
      };
      function parseHex4Bits(string, index) {
        var c = string.charCodeAt(index);
        if (c >= 65 && c <= 70) {
          return c - 55;
        } else if (c >= 97 && c <= 102) {
          return c - 87;
        } else {
          return c - 48 & 15;
        }
      }
      function parseHexByte(string, lowerBound, index) {
        var r = parseHex4Bits(string, index);
        if (index - 1 >= lowerBound) {
          r |= parseHex4Bits(string, index - 1) << 4;
        }
        return r;
      }
      BN.prototype._parseHex = function _parseHex(number, start, endian) {
        this.length = Math.ceil((number.length - start) / 6);
        this.words = new Array(this.length);
        for (var i = 0; i < this.length; i++) {
          this.words[i] = 0;
        }
        var off = 0;
        var j = 0;
        var w;
        if (endian === "be") {
          for (i = number.length - 1; i >= start; i -= 2) {
            w = parseHexByte(number, start, i) << off;
            this.words[j] |= w & 67108863;
            if (off >= 18) {
              off -= 18;
              j += 1;
              this.words[j] |= w >>> 26;
            } else {
              off += 8;
            }
          }
        } else {
          var parseLength = number.length - start;
          for (i = parseLength % 2 === 0 ? start + 1 : start; i < number.length; i += 2) {
            w = parseHexByte(number, start, i) << off;
            this.words[j] |= w & 67108863;
            if (off >= 18) {
              off -= 18;
              j += 1;
              this.words[j] |= w >>> 26;
            } else {
              off += 8;
            }
          }
        }
        this.strip();
      };
      function parseBase(str, start, end, mul) {
        var r = 0;
        var len = Math.min(str.length, end);
        for (var i = start; i < len; i++) {
          var c = str.charCodeAt(i) - 48;
          r *= mul;
          if (c >= 49) {
            r += c - 49 + 10;
          } else if (c >= 17) {
            r += c - 17 + 10;
          } else {
            r += c;
          }
        }
        return r;
      }
      BN.prototype._parseBase = function _parseBase(number, base, start) {
        this.words = [0];
        this.length = 1;
        for (var limbLen = 0, limbPow = 1; limbPow <= 67108863; limbPow *= base) {
          limbLen++;
        }
        limbLen--;
        limbPow = limbPow / base | 0;
        var total = number.length - start;
        var mod = total % limbLen;
        var end = Math.min(total, total - mod) + start;
        var word = 0;
        for (var i = start; i < end; i += limbLen) {
          word = parseBase(number, i, i + limbLen, base);
          this.imuln(limbPow);
          if (this.words[0] + word < 67108864) {
            this.words[0] += word;
          } else {
            this._iaddn(word);
          }
        }
        if (mod !== 0) {
          var pow = 1;
          word = parseBase(number, i, number.length, base);
          for (i = 0; i < mod; i++) {
            pow *= base;
          }
          this.imuln(pow);
          if (this.words[0] + word < 67108864) {
            this.words[0] += word;
          } else {
            this._iaddn(word);
          }
        }
        this.strip();
      };
      BN.prototype.copy = function copy(dest) {
        dest.words = new Array(this.length);
        for (var i = 0; i < this.length; i++) {
          dest.words[i] = this.words[i];
        }
        dest.length = this.length;
        dest.negative = this.negative;
        dest.red = this.red;
      };
      BN.prototype.clone = function clone() {
        var r = new BN(null);
        this.copy(r);
        return r;
      };
      BN.prototype._expand = function _expand(size) {
        while (this.length < size) {
          this.words[this.length++] = 0;
        }
        return this;
      };
      BN.prototype.strip = function strip() {
        while (this.length > 1 && this.words[this.length - 1] === 0) {
          this.length--;
        }
        return this._normSign();
      };
      BN.prototype._normSign = function _normSign() {
        if (this.length === 1 && this.words[0] === 0) {
          this.negative = 0;
        }
        return this;
      };
      BN.prototype.inspect = function inspect() {
        return (this.red ? "<BN-R: " : "<BN: ") + this.toString(16) + ">";
      };
      var zeros = [
        "",
        "0",
        "00",
        "000",
        "0000",
        "00000",
        "000000",
        "0000000",
        "00000000",
        "000000000",
        "0000000000",
        "00000000000",
        "000000000000",
        "0000000000000",
        "00000000000000",
        "000000000000000",
        "0000000000000000",
        "00000000000000000",
        "000000000000000000",
        "0000000000000000000",
        "00000000000000000000",
        "000000000000000000000",
        "0000000000000000000000",
        "00000000000000000000000",
        "000000000000000000000000",
        "0000000000000000000000000"
      ];
      var groupSizes = [
        0,
        0,
        25,
        16,
        12,
        11,
        10,
        9,
        8,
        8,
        7,
        7,
        7,
        7,
        6,
        6,
        6,
        6,
        6,
        6,
        6,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5
      ];
      var groupBases = [
        0,
        0,
        33554432,
        43046721,
        16777216,
        48828125,
        60466176,
        40353607,
        16777216,
        43046721,
        1e7,
        19487171,
        35831808,
        62748517,
        7529536,
        11390625,
        16777216,
        24137569,
        34012224,
        47045881,
        64e6,
        4084101,
        5153632,
        6436343,
        7962624,
        9765625,
        11881376,
        14348907,
        17210368,
        20511149,
        243e5,
        28629151,
        33554432,
        39135393,
        45435424,
        52521875,
        60466176
      ];
      BN.prototype.toString = function toString(base, padding) {
        base = base || 10;
        padding = padding | 0 || 1;
        var out;
        if (base === 16 || base === "hex") {
          out = "";
          var off = 0;
          var carry = 0;
          for (var i = 0; i < this.length; i++) {
            var w = this.words[i];
            var word = ((w << off | carry) & 16777215).toString(16);
            carry = w >>> 24 - off & 16777215;
            if (carry !== 0 || i !== this.length - 1) {
              out = zeros[6 - word.length] + word + out;
            } else {
              out = word + out;
            }
            off += 2;
            if (off >= 26) {
              off -= 26;
              i--;
            }
          }
          if (carry !== 0) {
            out = carry.toString(16) + out;
          }
          while (out.length % padding !== 0) {
            out = "0" + out;
          }
          if (this.negative !== 0) {
            out = "-" + out;
          }
          return out;
        }
        if (base === (base | 0) && base >= 2 && base <= 36) {
          var groupSize = groupSizes[base];
          var groupBase = groupBases[base];
          out = "";
          var c = this.clone();
          c.negative = 0;
          while (!c.isZero()) {
            var r = c.modn(groupBase).toString(base);
            c = c.idivn(groupBase);
            if (!c.isZero()) {
              out = zeros[groupSize - r.length] + r + out;
            } else {
              out = r + out;
            }
          }
          if (this.isZero()) {
            out = "0" + out;
          }
          while (out.length % padding !== 0) {
            out = "0" + out;
          }
          if (this.negative !== 0) {
            out = "-" + out;
          }
          return out;
        }
        assert(false, "Base should be between 2 and 36");
      };
      BN.prototype.toNumber = function toNumber() {
        var ret = this.words[0];
        if (this.length === 2) {
          ret += this.words[1] * 67108864;
        } else if (this.length === 3 && this.words[2] === 1) {
          ret += 4503599627370496 + this.words[1] * 67108864;
        } else if (this.length > 2) {
          assert(false, "Number can only safely store up to 53 bits");
        }
        return this.negative !== 0 ? -ret : ret;
      };
      BN.prototype.toJSON = function toJSON() {
        return this.toString(16);
      };
      BN.prototype.toBuffer = function toBuffer(endian, length) {
        assert(typeof Buffer2 !== "undefined");
        return this.toArrayLike(Buffer2, endian, length);
      };
      BN.prototype.toArray = function toArray(endian, length) {
        return this.toArrayLike(Array, endian, length);
      };
      BN.prototype.toArrayLike = function toArrayLike(ArrayType, endian, length) {
        var byteLength = this.byteLength();
        var reqLength = length || Math.max(1, byteLength);
        assert(byteLength <= reqLength, "byte array longer than desired length");
        assert(reqLength > 0, "Requested array length <= 0");
        this.strip();
        var littleEndian = endian === "le";
        var res = new ArrayType(reqLength);
        var b, i;
        var q = this.clone();
        if (!littleEndian) {
          for (i = 0; i < reqLength - byteLength; i++) {
            res[i] = 0;
          }
          for (i = 0; !q.isZero(); i++) {
            b = q.andln(255);
            q.iushrn(8);
            res[reqLength - i - 1] = b;
          }
        } else {
          for (i = 0; !q.isZero(); i++) {
            b = q.andln(255);
            q.iushrn(8);
            res[i] = b;
          }
          for (; i < reqLength; i++) {
            res[i] = 0;
          }
        }
        return res;
      };
      if (Math.clz32) {
        BN.prototype._countBits = function _countBits(w) {
          return 32 - Math.clz32(w);
        };
      } else {
        BN.prototype._countBits = function _countBits(w) {
          var t = w;
          var r = 0;
          if (t >= 4096) {
            r += 13;
            t >>>= 13;
          }
          if (t >= 64) {
            r += 7;
            t >>>= 7;
          }
          if (t >= 8) {
            r += 4;
            t >>>= 4;
          }
          if (t >= 2) {
            r += 2;
            t >>>= 2;
          }
          return r + t;
        };
      }
      BN.prototype._zeroBits = function _zeroBits(w) {
        if (w === 0) return 26;
        var t = w;
        var r = 0;
        if ((t & 8191) === 0) {
          r += 13;
          t >>>= 13;
        }
        if ((t & 127) === 0) {
          r += 7;
          t >>>= 7;
        }
        if ((t & 15) === 0) {
          r += 4;
          t >>>= 4;
        }
        if ((t & 3) === 0) {
          r += 2;
          t >>>= 2;
        }
        if ((t & 1) === 0) {
          r++;
        }
        return r;
      };
      BN.prototype.bitLength = function bitLength() {
        var w = this.words[this.length - 1];
        var hi = this._countBits(w);
        return (this.length - 1) * 26 + hi;
      };
      function toBitArray(num) {
        var w = new Array(num.bitLength());
        for (var bit = 0; bit < w.length; bit++) {
          var off = bit / 26 | 0;
          var wbit = bit % 26;
          w[bit] = (num.words[off] & 1 << wbit) >>> wbit;
        }
        return w;
      }
      BN.prototype.zeroBits = function zeroBits() {
        if (this.isZero()) return 0;
        var r = 0;
        for (var i = 0; i < this.length; i++) {
          var b = this._zeroBits(this.words[i]);
          r += b;
          if (b !== 26) break;
        }
        return r;
      };
      BN.prototype.byteLength = function byteLength() {
        return Math.ceil(this.bitLength() / 8);
      };
      BN.prototype.toTwos = function toTwos(width) {
        if (this.negative !== 0) {
          return this.abs().inotn(width).iaddn(1);
        }
        return this.clone();
      };
      BN.prototype.fromTwos = function fromTwos(width) {
        if (this.testn(width - 1)) {
          return this.notn(width).iaddn(1).ineg();
        }
        return this.clone();
      };
      BN.prototype.isNeg = function isNeg() {
        return this.negative !== 0;
      };
      BN.prototype.neg = function neg() {
        return this.clone().ineg();
      };
      BN.prototype.ineg = function ineg() {
        if (!this.isZero()) {
          this.negative ^= 1;
        }
        return this;
      };
      BN.prototype.iuor = function iuor(num) {
        while (this.length < num.length) {
          this.words[this.length++] = 0;
        }
        for (var i = 0; i < num.length; i++) {
          this.words[i] = this.words[i] | num.words[i];
        }
        return this.strip();
      };
      BN.prototype.ior = function ior(num) {
        assert((this.negative | num.negative) === 0);
        return this.iuor(num);
      };
      BN.prototype.or = function or(num) {
        if (this.length > num.length) return this.clone().ior(num);
        return num.clone().ior(this);
      };
      BN.prototype.uor = function uor(num) {
        if (this.length > num.length) return this.clone().iuor(num);
        return num.clone().iuor(this);
      };
      BN.prototype.iuand = function iuand(num) {
        var b;
        if (this.length > num.length) {
          b = num;
        } else {
          b = this;
        }
        for (var i = 0; i < b.length; i++) {
          this.words[i] = this.words[i] & num.words[i];
        }
        this.length = b.length;
        return this.strip();
      };
      BN.prototype.iand = function iand(num) {
        assert((this.negative | num.negative) === 0);
        return this.iuand(num);
      };
      BN.prototype.and = function and(num) {
        if (this.length > num.length) return this.clone().iand(num);
        return num.clone().iand(this);
      };
      BN.prototype.uand = function uand(num) {
        if (this.length > num.length) return this.clone().iuand(num);
        return num.clone().iuand(this);
      };
      BN.prototype.iuxor = function iuxor(num) {
        var a;
        var b;
        if (this.length > num.length) {
          a = this;
          b = num;
        } else {
          a = num;
          b = this;
        }
        for (var i = 0; i < b.length; i++) {
          this.words[i] = a.words[i] ^ b.words[i];
        }
        if (this !== a) {
          for (; i < a.length; i++) {
            this.words[i] = a.words[i];
          }
        }
        this.length = a.length;
        return this.strip();
      };
      BN.prototype.ixor = function ixor(num) {
        assert((this.negative | num.negative) === 0);
        return this.iuxor(num);
      };
      BN.prototype.xor = function xor(num) {
        if (this.length > num.length) return this.clone().ixor(num);
        return num.clone().ixor(this);
      };
      BN.prototype.uxor = function uxor(num) {
        if (this.length > num.length) return this.clone().iuxor(num);
        return num.clone().iuxor(this);
      };
      BN.prototype.inotn = function inotn(width) {
        assert(typeof width === "number" && width >= 0);
        var bytesNeeded = Math.ceil(width / 26) | 0;
        var bitsLeft = width % 26;
        this._expand(bytesNeeded);
        if (bitsLeft > 0) {
          bytesNeeded--;
        }
        for (var i = 0; i < bytesNeeded; i++) {
          this.words[i] = ~this.words[i] & 67108863;
        }
        if (bitsLeft > 0) {
          this.words[i] = ~this.words[i] & 67108863 >> 26 - bitsLeft;
        }
        return this.strip();
      };
      BN.prototype.notn = function notn(width) {
        return this.clone().inotn(width);
      };
      BN.prototype.setn = function setn(bit, val) {
        assert(typeof bit === "number" && bit >= 0);
        var off = bit / 26 | 0;
        var wbit = bit % 26;
        this._expand(off + 1);
        if (val) {
          this.words[off] = this.words[off] | 1 << wbit;
        } else {
          this.words[off] = this.words[off] & ~(1 << wbit);
        }
        return this.strip();
      };
      BN.prototype.iadd = function iadd(num) {
        var r;
        if (this.negative !== 0 && num.negative === 0) {
          this.negative = 0;
          r = this.isub(num);
          this.negative ^= 1;
          return this._normSign();
        } else if (this.negative === 0 && num.negative !== 0) {
          num.negative = 0;
          r = this.isub(num);
          num.negative = 1;
          return r._normSign();
        }
        var a, b;
        if (this.length > num.length) {
          a = this;
          b = num;
        } else {
          a = num;
          b = this;
        }
        var carry = 0;
        for (var i = 0; i < b.length; i++) {
          r = (a.words[i] | 0) + (b.words[i] | 0) + carry;
          this.words[i] = r & 67108863;
          carry = r >>> 26;
        }
        for (; carry !== 0 && i < a.length; i++) {
          r = (a.words[i] | 0) + carry;
          this.words[i] = r & 67108863;
          carry = r >>> 26;
        }
        this.length = a.length;
        if (carry !== 0) {
          this.words[this.length] = carry;
          this.length++;
        } else if (a !== this) {
          for (; i < a.length; i++) {
            this.words[i] = a.words[i];
          }
        }
        return this;
      };
      BN.prototype.add = function add(num) {
        var res;
        if (num.negative !== 0 && this.negative === 0) {
          num.negative = 0;
          res = this.sub(num);
          num.negative ^= 1;
          return res;
        } else if (num.negative === 0 && this.negative !== 0) {
          this.negative = 0;
          res = num.sub(this);
          this.negative = 1;
          return res;
        }
        if (this.length > num.length) return this.clone().iadd(num);
        return num.clone().iadd(this);
      };
      BN.prototype.isub = function isub(num) {
        if (num.negative !== 0) {
          num.negative = 0;
          var r = this.iadd(num);
          num.negative = 1;
          return r._normSign();
        } else if (this.negative !== 0) {
          this.negative = 0;
          this.iadd(num);
          this.negative = 1;
          return this._normSign();
        }
        var cmp = this.cmp(num);
        if (cmp === 0) {
          this.negative = 0;
          this.length = 1;
          this.words[0] = 0;
          return this;
        }
        var a, b;
        if (cmp > 0) {
          a = this;
          b = num;
        } else {
          a = num;
          b = this;
        }
        var carry = 0;
        for (var i = 0; i < b.length; i++) {
          r = (a.words[i] | 0) - (b.words[i] | 0) + carry;
          carry = r >> 26;
          this.words[i] = r & 67108863;
        }
        for (; carry !== 0 && i < a.length; i++) {
          r = (a.words[i] | 0) + carry;
          carry = r >> 26;
          this.words[i] = r & 67108863;
        }
        if (carry === 0 && i < a.length && a !== this) {
          for (; i < a.length; i++) {
            this.words[i] = a.words[i];
          }
        }
        this.length = Math.max(this.length, i);
        if (a !== this) {
          this.negative = 1;
        }
        return this.strip();
      };
      BN.prototype.sub = function sub(num) {
        return this.clone().isub(num);
      };
      function smallMulTo(self2, num, out) {
        out.negative = num.negative ^ self2.negative;
        var len = self2.length + num.length | 0;
        out.length = len;
        len = len - 1 | 0;
        var a = self2.words[0] | 0;
        var b = num.words[0] | 0;
        var r = a * b;
        var lo = r & 67108863;
        var carry = r / 67108864 | 0;
        out.words[0] = lo;
        for (var k = 1; k < len; k++) {
          var ncarry = carry >>> 26;
          var rword = carry & 67108863;
          var maxJ = Math.min(k, num.length - 1);
          for (var j = Math.max(0, k - self2.length + 1); j <= maxJ; j++) {
            var i = k - j | 0;
            a = self2.words[i] | 0;
            b = num.words[j] | 0;
            r = a * b + rword;
            ncarry += r / 67108864 | 0;
            rword = r & 67108863;
          }
          out.words[k] = rword | 0;
          carry = ncarry | 0;
        }
        if (carry !== 0) {
          out.words[k] = carry | 0;
        } else {
          out.length--;
        }
        return out.strip();
      }
      var comb10MulTo = function comb10MulTo2(self2, num, out) {
        var a = self2.words;
        var b = num.words;
        var o = out.words;
        var c = 0;
        var lo;
        var mid;
        var hi;
        var a0 = a[0] | 0;
        var al0 = a0 & 8191;
        var ah0 = a0 >>> 13;
        var a1 = a[1] | 0;
        var al1 = a1 & 8191;
        var ah1 = a1 >>> 13;
        var a2 = a[2] | 0;
        var al2 = a2 & 8191;
        var ah2 = a2 >>> 13;
        var a3 = a[3] | 0;
        var al3 = a3 & 8191;
        var ah3 = a3 >>> 13;
        var a4 = a[4] | 0;
        var al4 = a4 & 8191;
        var ah4 = a4 >>> 13;
        var a5 = a[5] | 0;
        var al5 = a5 & 8191;
        var ah5 = a5 >>> 13;
        var a6 = a[6] | 0;
        var al6 = a6 & 8191;
        var ah6 = a6 >>> 13;
        var a7 = a[7] | 0;
        var al7 = a7 & 8191;
        var ah7 = a7 >>> 13;
        var a8 = a[8] | 0;
        var al8 = a8 & 8191;
        var ah8 = a8 >>> 13;
        var a9 = a[9] | 0;
        var al9 = a9 & 8191;
        var ah9 = a9 >>> 13;
        var b0 = b[0] | 0;
        var bl0 = b0 & 8191;
        var bh0 = b0 >>> 13;
        var b1 = b[1] | 0;
        var bl1 = b1 & 8191;
        var bh1 = b1 >>> 13;
        var b2 = b[2] | 0;
        var bl2 = b2 & 8191;
        var bh2 = b2 >>> 13;
        var b3 = b[3] | 0;
        var bl3 = b3 & 8191;
        var bh3 = b3 >>> 13;
        var b4 = b[4] | 0;
        var bl4 = b4 & 8191;
        var bh4 = b4 >>> 13;
        var b5 = b[5] | 0;
        var bl5 = b5 & 8191;
        var bh5 = b5 >>> 13;
        var b6 = b[6] | 0;
        var bl6 = b6 & 8191;
        var bh6 = b6 >>> 13;
        var b7 = b[7] | 0;
        var bl7 = b7 & 8191;
        var bh7 = b7 >>> 13;
        var b8 = b[8] | 0;
        var bl8 = b8 & 8191;
        var bh8 = b8 >>> 13;
        var b9 = b[9] | 0;
        var bl9 = b9 & 8191;
        var bh9 = b9 >>> 13;
        out.negative = self2.negative ^ num.negative;
        out.length = 19;
        lo = Math.imul(al0, bl0);
        mid = Math.imul(al0, bh0);
        mid = mid + Math.imul(ah0, bl0) | 0;
        hi = Math.imul(ah0, bh0);
        var w0 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w0 >>> 26) | 0;
        w0 &= 67108863;
        lo = Math.imul(al1, bl0);
        mid = Math.imul(al1, bh0);
        mid = mid + Math.imul(ah1, bl0) | 0;
        hi = Math.imul(ah1, bh0);
        lo = lo + Math.imul(al0, bl1) | 0;
        mid = mid + Math.imul(al0, bh1) | 0;
        mid = mid + Math.imul(ah0, bl1) | 0;
        hi = hi + Math.imul(ah0, bh1) | 0;
        var w1 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w1 >>> 26) | 0;
        w1 &= 67108863;
        lo = Math.imul(al2, bl0);
        mid = Math.imul(al2, bh0);
        mid = mid + Math.imul(ah2, bl0) | 0;
        hi = Math.imul(ah2, bh0);
        lo = lo + Math.imul(al1, bl1) | 0;
        mid = mid + Math.imul(al1, bh1) | 0;
        mid = mid + Math.imul(ah1, bl1) | 0;
        hi = hi + Math.imul(ah1, bh1) | 0;
        lo = lo + Math.imul(al0, bl2) | 0;
        mid = mid + Math.imul(al0, bh2) | 0;
        mid = mid + Math.imul(ah0, bl2) | 0;
        hi = hi + Math.imul(ah0, bh2) | 0;
        var w2 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w2 >>> 26) | 0;
        w2 &= 67108863;
        lo = Math.imul(al3, bl0);
        mid = Math.imul(al3, bh0);
        mid = mid + Math.imul(ah3, bl0) | 0;
        hi = Math.imul(ah3, bh0);
        lo = lo + Math.imul(al2, bl1) | 0;
        mid = mid + Math.imul(al2, bh1) | 0;
        mid = mid + Math.imul(ah2, bl1) | 0;
        hi = hi + Math.imul(ah2, bh1) | 0;
        lo = lo + Math.imul(al1, bl2) | 0;
        mid = mid + Math.imul(al1, bh2) | 0;
        mid = mid + Math.imul(ah1, bl2) | 0;
        hi = hi + Math.imul(ah1, bh2) | 0;
        lo = lo + Math.imul(al0, bl3) | 0;
        mid = mid + Math.imul(al0, bh3) | 0;
        mid = mid + Math.imul(ah0, bl3) | 0;
        hi = hi + Math.imul(ah0, bh3) | 0;
        var w3 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w3 >>> 26) | 0;
        w3 &= 67108863;
        lo = Math.imul(al4, bl0);
        mid = Math.imul(al4, bh0);
        mid = mid + Math.imul(ah4, bl0) | 0;
        hi = Math.imul(ah4, bh0);
        lo = lo + Math.imul(al3, bl1) | 0;
        mid = mid + Math.imul(al3, bh1) | 0;
        mid = mid + Math.imul(ah3, bl1) | 0;
        hi = hi + Math.imul(ah3, bh1) | 0;
        lo = lo + Math.imul(al2, bl2) | 0;
        mid = mid + Math.imul(al2, bh2) | 0;
        mid = mid + Math.imul(ah2, bl2) | 0;
        hi = hi + Math.imul(ah2, bh2) | 0;
        lo = lo + Math.imul(al1, bl3) | 0;
        mid = mid + Math.imul(al1, bh3) | 0;
        mid = mid + Math.imul(ah1, bl3) | 0;
        hi = hi + Math.imul(ah1, bh3) | 0;
        lo = lo + Math.imul(al0, bl4) | 0;
        mid = mid + Math.imul(al0, bh4) | 0;
        mid = mid + Math.imul(ah0, bl4) | 0;
        hi = hi + Math.imul(ah0, bh4) | 0;
        var w4 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w4 >>> 26) | 0;
        w4 &= 67108863;
        lo = Math.imul(al5, bl0);
        mid = Math.imul(al5, bh0);
        mid = mid + Math.imul(ah5, bl0) | 0;
        hi = Math.imul(ah5, bh0);
        lo = lo + Math.imul(al4, bl1) | 0;
        mid = mid + Math.imul(al4, bh1) | 0;
        mid = mid + Math.imul(ah4, bl1) | 0;
        hi = hi + Math.imul(ah4, bh1) | 0;
        lo = lo + Math.imul(al3, bl2) | 0;
        mid = mid + Math.imul(al3, bh2) | 0;
        mid = mid + Math.imul(ah3, bl2) | 0;
        hi = hi + Math.imul(ah3, bh2) | 0;
        lo = lo + Math.imul(al2, bl3) | 0;
        mid = mid + Math.imul(al2, bh3) | 0;
        mid = mid + Math.imul(ah2, bl3) | 0;
        hi = hi + Math.imul(ah2, bh3) | 0;
        lo = lo + Math.imul(al1, bl4) | 0;
        mid = mid + Math.imul(al1, bh4) | 0;
        mid = mid + Math.imul(ah1, bl4) | 0;
        hi = hi + Math.imul(ah1, bh4) | 0;
        lo = lo + Math.imul(al0, bl5) | 0;
        mid = mid + Math.imul(al0, bh5) | 0;
        mid = mid + Math.imul(ah0, bl5) | 0;
        hi = hi + Math.imul(ah0, bh5) | 0;
        var w5 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w5 >>> 26) | 0;
        w5 &= 67108863;
        lo = Math.imul(al6, bl0);
        mid = Math.imul(al6, bh0);
        mid = mid + Math.imul(ah6, bl0) | 0;
        hi = Math.imul(ah6, bh0);
        lo = lo + Math.imul(al5, bl1) | 0;
        mid = mid + Math.imul(al5, bh1) | 0;
        mid = mid + Math.imul(ah5, bl1) | 0;
        hi = hi + Math.imul(ah5, bh1) | 0;
        lo = lo + Math.imul(al4, bl2) | 0;
        mid = mid + Math.imul(al4, bh2) | 0;
        mid = mid + Math.imul(ah4, bl2) | 0;
        hi = hi + Math.imul(ah4, bh2) | 0;
        lo = lo + Math.imul(al3, bl3) | 0;
        mid = mid + Math.imul(al3, bh3) | 0;
        mid = mid + Math.imul(ah3, bl3) | 0;
        hi = hi + Math.imul(ah3, bh3) | 0;
        lo = lo + Math.imul(al2, bl4) | 0;
        mid = mid + Math.imul(al2, bh4) | 0;
        mid = mid + Math.imul(ah2, bl4) | 0;
        hi = hi + Math.imul(ah2, bh4) | 0;
        lo = lo + Math.imul(al1, bl5) | 0;
        mid = mid + Math.imul(al1, bh5) | 0;
        mid = mid + Math.imul(ah1, bl5) | 0;
        hi = hi + Math.imul(ah1, bh5) | 0;
        lo = lo + Math.imul(al0, bl6) | 0;
        mid = mid + Math.imul(al0, bh6) | 0;
        mid = mid + Math.imul(ah0, bl6) | 0;
        hi = hi + Math.imul(ah0, bh6) | 0;
        var w6 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w6 >>> 26) | 0;
        w6 &= 67108863;
        lo = Math.imul(al7, bl0);
        mid = Math.imul(al7, bh0);
        mid = mid + Math.imul(ah7, bl0) | 0;
        hi = Math.imul(ah7, bh0);
        lo = lo + Math.imul(al6, bl1) | 0;
        mid = mid + Math.imul(al6, bh1) | 0;
        mid = mid + Math.imul(ah6, bl1) | 0;
        hi = hi + Math.imul(ah6, bh1) | 0;
        lo = lo + Math.imul(al5, bl2) | 0;
        mid = mid + Math.imul(al5, bh2) | 0;
        mid = mid + Math.imul(ah5, bl2) | 0;
        hi = hi + Math.imul(ah5, bh2) | 0;
        lo = lo + Math.imul(al4, bl3) | 0;
        mid = mid + Math.imul(al4, bh3) | 0;
        mid = mid + Math.imul(ah4, bl3) | 0;
        hi = hi + Math.imul(ah4, bh3) | 0;
        lo = lo + Math.imul(al3, bl4) | 0;
        mid = mid + Math.imul(al3, bh4) | 0;
        mid = mid + Math.imul(ah3, bl4) | 0;
        hi = hi + Math.imul(ah3, bh4) | 0;
        lo = lo + Math.imul(al2, bl5) | 0;
        mid = mid + Math.imul(al2, bh5) | 0;
        mid = mid + Math.imul(ah2, bl5) | 0;
        hi = hi + Math.imul(ah2, bh5) | 0;
        lo = lo + Math.imul(al1, bl6) | 0;
        mid = mid + Math.imul(al1, bh6) | 0;
        mid = mid + Math.imul(ah1, bl6) | 0;
        hi = hi + Math.imul(ah1, bh6) | 0;
        lo = lo + Math.imul(al0, bl7) | 0;
        mid = mid + Math.imul(al0, bh7) | 0;
        mid = mid + Math.imul(ah0, bl7) | 0;
        hi = hi + Math.imul(ah0, bh7) | 0;
        var w7 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w7 >>> 26) | 0;
        w7 &= 67108863;
        lo = Math.imul(al8, bl0);
        mid = Math.imul(al8, bh0);
        mid = mid + Math.imul(ah8, bl0) | 0;
        hi = Math.imul(ah8, bh0);
        lo = lo + Math.imul(al7, bl1) | 0;
        mid = mid + Math.imul(al7, bh1) | 0;
        mid = mid + Math.imul(ah7, bl1) | 0;
        hi = hi + Math.imul(ah7, bh1) | 0;
        lo = lo + Math.imul(al6, bl2) | 0;
        mid = mid + Math.imul(al6, bh2) | 0;
        mid = mid + Math.imul(ah6, bl2) | 0;
        hi = hi + Math.imul(ah6, bh2) | 0;
        lo = lo + Math.imul(al5, bl3) | 0;
        mid = mid + Math.imul(al5, bh3) | 0;
        mid = mid + Math.imul(ah5, bl3) | 0;
        hi = hi + Math.imul(ah5, bh3) | 0;
        lo = lo + Math.imul(al4, bl4) | 0;
        mid = mid + Math.imul(al4, bh4) | 0;
        mid = mid + Math.imul(ah4, bl4) | 0;
        hi = hi + Math.imul(ah4, bh4) | 0;
        lo = lo + Math.imul(al3, bl5) | 0;
        mid = mid + Math.imul(al3, bh5) | 0;
        mid = mid + Math.imul(ah3, bl5) | 0;
        hi = hi + Math.imul(ah3, bh5) | 0;
        lo = lo + Math.imul(al2, bl6) | 0;
        mid = mid + Math.imul(al2, bh6) | 0;
        mid = mid + Math.imul(ah2, bl6) | 0;
        hi = hi + Math.imul(ah2, bh6) | 0;
        lo = lo + Math.imul(al1, bl7) | 0;
        mid = mid + Math.imul(al1, bh7) | 0;
        mid = mid + Math.imul(ah1, bl7) | 0;
        hi = hi + Math.imul(ah1, bh7) | 0;
        lo = lo + Math.imul(al0, bl8) | 0;
        mid = mid + Math.imul(al0, bh8) | 0;
        mid = mid + Math.imul(ah0, bl8) | 0;
        hi = hi + Math.imul(ah0, bh8) | 0;
        var w8 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w8 >>> 26) | 0;
        w8 &= 67108863;
        lo = Math.imul(al9, bl0);
        mid = Math.imul(al9, bh0);
        mid = mid + Math.imul(ah9, bl0) | 0;
        hi = Math.imul(ah9, bh0);
        lo = lo + Math.imul(al8, bl1) | 0;
        mid = mid + Math.imul(al8, bh1) | 0;
        mid = mid + Math.imul(ah8, bl1) | 0;
        hi = hi + Math.imul(ah8, bh1) | 0;
        lo = lo + Math.imul(al7, bl2) | 0;
        mid = mid + Math.imul(al7, bh2) | 0;
        mid = mid + Math.imul(ah7, bl2) | 0;
        hi = hi + Math.imul(ah7, bh2) | 0;
        lo = lo + Math.imul(al6, bl3) | 0;
        mid = mid + Math.imul(al6, bh3) | 0;
        mid = mid + Math.imul(ah6, bl3) | 0;
        hi = hi + Math.imul(ah6, bh3) | 0;
        lo = lo + Math.imul(al5, bl4) | 0;
        mid = mid + Math.imul(al5, bh4) | 0;
        mid = mid + Math.imul(ah5, bl4) | 0;
        hi = hi + Math.imul(ah5, bh4) | 0;
        lo = lo + Math.imul(al4, bl5) | 0;
        mid = mid + Math.imul(al4, bh5) | 0;
        mid = mid + Math.imul(ah4, bl5) | 0;
        hi = hi + Math.imul(ah4, bh5) | 0;
        lo = lo + Math.imul(al3, bl6) | 0;
        mid = mid + Math.imul(al3, bh6) | 0;
        mid = mid + Math.imul(ah3, bl6) | 0;
        hi = hi + Math.imul(ah3, bh6) | 0;
        lo = lo + Math.imul(al2, bl7) | 0;
        mid = mid + Math.imul(al2, bh7) | 0;
        mid = mid + Math.imul(ah2, bl7) | 0;
        hi = hi + Math.imul(ah2, bh7) | 0;
        lo = lo + Math.imul(al1, bl8) | 0;
        mid = mid + Math.imul(al1, bh8) | 0;
        mid = mid + Math.imul(ah1, bl8) | 0;
        hi = hi + Math.imul(ah1, bh8) | 0;
        lo = lo + Math.imul(al0, bl9) | 0;
        mid = mid + Math.imul(al0, bh9) | 0;
        mid = mid + Math.imul(ah0, bl9) | 0;
        hi = hi + Math.imul(ah0, bh9) | 0;
        var w9 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w9 >>> 26) | 0;
        w9 &= 67108863;
        lo = Math.imul(al9, bl1);
        mid = Math.imul(al9, bh1);
        mid = mid + Math.imul(ah9, bl1) | 0;
        hi = Math.imul(ah9, bh1);
        lo = lo + Math.imul(al8, bl2) | 0;
        mid = mid + Math.imul(al8, bh2) | 0;
        mid = mid + Math.imul(ah8, bl2) | 0;
        hi = hi + Math.imul(ah8, bh2) | 0;
        lo = lo + Math.imul(al7, bl3) | 0;
        mid = mid + Math.imul(al7, bh3) | 0;
        mid = mid + Math.imul(ah7, bl3) | 0;
        hi = hi + Math.imul(ah7, bh3) | 0;
        lo = lo + Math.imul(al6, bl4) | 0;
        mid = mid + Math.imul(al6, bh4) | 0;
        mid = mid + Math.imul(ah6, bl4) | 0;
        hi = hi + Math.imul(ah6, bh4) | 0;
        lo = lo + Math.imul(al5, bl5) | 0;
        mid = mid + Math.imul(al5, bh5) | 0;
        mid = mid + Math.imul(ah5, bl5) | 0;
        hi = hi + Math.imul(ah5, bh5) | 0;
        lo = lo + Math.imul(al4, bl6) | 0;
        mid = mid + Math.imul(al4, bh6) | 0;
        mid = mid + Math.imul(ah4, bl6) | 0;
        hi = hi + Math.imul(ah4, bh6) | 0;
        lo = lo + Math.imul(al3, bl7) | 0;
        mid = mid + Math.imul(al3, bh7) | 0;
        mid = mid + Math.imul(ah3, bl7) | 0;
        hi = hi + Math.imul(ah3, bh7) | 0;
        lo = lo + Math.imul(al2, bl8) | 0;
        mid = mid + Math.imul(al2, bh8) | 0;
        mid = mid + Math.imul(ah2, bl8) | 0;
        hi = hi + Math.imul(ah2, bh8) | 0;
        lo = lo + Math.imul(al1, bl9) | 0;
        mid = mid + Math.imul(al1, bh9) | 0;
        mid = mid + Math.imul(ah1, bl9) | 0;
        hi = hi + Math.imul(ah1, bh9) | 0;
        var w10 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w10 >>> 26) | 0;
        w10 &= 67108863;
        lo = Math.imul(al9, bl2);
        mid = Math.imul(al9, bh2);
        mid = mid + Math.imul(ah9, bl2) | 0;
        hi = Math.imul(ah9, bh2);
        lo = lo + Math.imul(al8, bl3) | 0;
        mid = mid + Math.imul(al8, bh3) | 0;
        mid = mid + Math.imul(ah8, bl3) | 0;
        hi = hi + Math.imul(ah8, bh3) | 0;
        lo = lo + Math.imul(al7, bl4) | 0;
        mid = mid + Math.imul(al7, bh4) | 0;
        mid = mid + Math.imul(ah7, bl4) | 0;
        hi = hi + Math.imul(ah7, bh4) | 0;
        lo = lo + Math.imul(al6, bl5) | 0;
        mid = mid + Math.imul(al6, bh5) | 0;
        mid = mid + Math.imul(ah6, bl5) | 0;
        hi = hi + Math.imul(ah6, bh5) | 0;
        lo = lo + Math.imul(al5, bl6) | 0;
        mid = mid + Math.imul(al5, bh6) | 0;
        mid = mid + Math.imul(ah5, bl6) | 0;
        hi = hi + Math.imul(ah5, bh6) | 0;
        lo = lo + Math.imul(al4, bl7) | 0;
        mid = mid + Math.imul(al4, bh7) | 0;
        mid = mid + Math.imul(ah4, bl7) | 0;
        hi = hi + Math.imul(ah4, bh7) | 0;
        lo = lo + Math.imul(al3, bl8) | 0;
        mid = mid + Math.imul(al3, bh8) | 0;
        mid = mid + Math.imul(ah3, bl8) | 0;
        hi = hi + Math.imul(ah3, bh8) | 0;
        lo = lo + Math.imul(al2, bl9) | 0;
        mid = mid + Math.imul(al2, bh9) | 0;
        mid = mid + Math.imul(ah2, bl9) | 0;
        hi = hi + Math.imul(ah2, bh9) | 0;
        var w11 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w11 >>> 26) | 0;
        w11 &= 67108863;
        lo = Math.imul(al9, bl3);
        mid = Math.imul(al9, bh3);
        mid = mid + Math.imul(ah9, bl3) | 0;
        hi = Math.imul(ah9, bh3);
        lo = lo + Math.imul(al8, bl4) | 0;
        mid = mid + Math.imul(al8, bh4) | 0;
        mid = mid + Math.imul(ah8, bl4) | 0;
        hi = hi + Math.imul(ah8, bh4) | 0;
        lo = lo + Math.imul(al7, bl5) | 0;
        mid = mid + Math.imul(al7, bh5) | 0;
        mid = mid + Math.imul(ah7, bl5) | 0;
        hi = hi + Math.imul(ah7, bh5) | 0;
        lo = lo + Math.imul(al6, bl6) | 0;
        mid = mid + Math.imul(al6, bh6) | 0;
        mid = mid + Math.imul(ah6, bl6) | 0;
        hi = hi + Math.imul(ah6, bh6) | 0;
        lo = lo + Math.imul(al5, bl7) | 0;
        mid = mid + Math.imul(al5, bh7) | 0;
        mid = mid + Math.imul(ah5, bl7) | 0;
        hi = hi + Math.imul(ah5, bh7) | 0;
        lo = lo + Math.imul(al4, bl8) | 0;
        mid = mid + Math.imul(al4, bh8) | 0;
        mid = mid + Math.imul(ah4, bl8) | 0;
        hi = hi + Math.imul(ah4, bh8) | 0;
        lo = lo + Math.imul(al3, bl9) | 0;
        mid = mid + Math.imul(al3, bh9) | 0;
        mid = mid + Math.imul(ah3, bl9) | 0;
        hi = hi + Math.imul(ah3, bh9) | 0;
        var w12 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w12 >>> 26) | 0;
        w12 &= 67108863;
        lo = Math.imul(al9, bl4);
        mid = Math.imul(al9, bh4);
        mid = mid + Math.imul(ah9, bl4) | 0;
        hi = Math.imul(ah9, bh4);
        lo = lo + Math.imul(al8, bl5) | 0;
        mid = mid + Math.imul(al8, bh5) | 0;
        mid = mid + Math.imul(ah8, bl5) | 0;
        hi = hi + Math.imul(ah8, bh5) | 0;
        lo = lo + Math.imul(al7, bl6) | 0;
        mid = mid + Math.imul(al7, bh6) | 0;
        mid = mid + Math.imul(ah7, bl6) | 0;
        hi = hi + Math.imul(ah7, bh6) | 0;
        lo = lo + Math.imul(al6, bl7) | 0;
        mid = mid + Math.imul(al6, bh7) | 0;
        mid = mid + Math.imul(ah6, bl7) | 0;
        hi = hi + Math.imul(ah6, bh7) | 0;
        lo = lo + Math.imul(al5, bl8) | 0;
        mid = mid + Math.imul(al5, bh8) | 0;
        mid = mid + Math.imul(ah5, bl8) | 0;
        hi = hi + Math.imul(ah5, bh8) | 0;
        lo = lo + Math.imul(al4, bl9) | 0;
        mid = mid + Math.imul(al4, bh9) | 0;
        mid = mid + Math.imul(ah4, bl9) | 0;
        hi = hi + Math.imul(ah4, bh9) | 0;
        var w13 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w13 >>> 26) | 0;
        w13 &= 67108863;
        lo = Math.imul(al9, bl5);
        mid = Math.imul(al9, bh5);
        mid = mid + Math.imul(ah9, bl5) | 0;
        hi = Math.imul(ah9, bh5);
        lo = lo + Math.imul(al8, bl6) | 0;
        mid = mid + Math.imul(al8, bh6) | 0;
        mid = mid + Math.imul(ah8, bl6) | 0;
        hi = hi + Math.imul(ah8, bh6) | 0;
        lo = lo + Math.imul(al7, bl7) | 0;
        mid = mid + Math.imul(al7, bh7) | 0;
        mid = mid + Math.imul(ah7, bl7) | 0;
        hi = hi + Math.imul(ah7, bh7) | 0;
        lo = lo + Math.imul(al6, bl8) | 0;
        mid = mid + Math.imul(al6, bh8) | 0;
        mid = mid + Math.imul(ah6, bl8) | 0;
        hi = hi + Math.imul(ah6, bh8) | 0;
        lo = lo + Math.imul(al5, bl9) | 0;
        mid = mid + Math.imul(al5, bh9) | 0;
        mid = mid + Math.imul(ah5, bl9) | 0;
        hi = hi + Math.imul(ah5, bh9) | 0;
        var w14 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w14 >>> 26) | 0;
        w14 &= 67108863;
        lo = Math.imul(al9, bl6);
        mid = Math.imul(al9, bh6);
        mid = mid + Math.imul(ah9, bl6) | 0;
        hi = Math.imul(ah9, bh6);
        lo = lo + Math.imul(al8, bl7) | 0;
        mid = mid + Math.imul(al8, bh7) | 0;
        mid = mid + Math.imul(ah8, bl7) | 0;
        hi = hi + Math.imul(ah8, bh7) | 0;
        lo = lo + Math.imul(al7, bl8) | 0;
        mid = mid + Math.imul(al7, bh8) | 0;
        mid = mid + Math.imul(ah7, bl8) | 0;
        hi = hi + Math.imul(ah7, bh8) | 0;
        lo = lo + Math.imul(al6, bl9) | 0;
        mid = mid + Math.imul(al6, bh9) | 0;
        mid = mid + Math.imul(ah6, bl9) | 0;
        hi = hi + Math.imul(ah6, bh9) | 0;
        var w15 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w15 >>> 26) | 0;
        w15 &= 67108863;
        lo = Math.imul(al9, bl7);
        mid = Math.imul(al9, bh7);
        mid = mid + Math.imul(ah9, bl7) | 0;
        hi = Math.imul(ah9, bh7);
        lo = lo + Math.imul(al8, bl8) | 0;
        mid = mid + Math.imul(al8, bh8) | 0;
        mid = mid + Math.imul(ah8, bl8) | 0;
        hi = hi + Math.imul(ah8, bh8) | 0;
        lo = lo + Math.imul(al7, bl9) | 0;
        mid = mid + Math.imul(al7, bh9) | 0;
        mid = mid + Math.imul(ah7, bl9) | 0;
        hi = hi + Math.imul(ah7, bh9) | 0;
        var w16 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w16 >>> 26) | 0;
        w16 &= 67108863;
        lo = Math.imul(al9, bl8);
        mid = Math.imul(al9, bh8);
        mid = mid + Math.imul(ah9, bl8) | 0;
        hi = Math.imul(ah9, bh8);
        lo = lo + Math.imul(al8, bl9) | 0;
        mid = mid + Math.imul(al8, bh9) | 0;
        mid = mid + Math.imul(ah8, bl9) | 0;
        hi = hi + Math.imul(ah8, bh9) | 0;
        var w17 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w17 >>> 26) | 0;
        w17 &= 67108863;
        lo = Math.imul(al9, bl9);
        mid = Math.imul(al9, bh9);
        mid = mid + Math.imul(ah9, bl9) | 0;
        hi = Math.imul(ah9, bh9);
        var w18 = (c + lo | 0) + ((mid & 8191) << 13) | 0;
        c = (hi + (mid >>> 13) | 0) + (w18 >>> 26) | 0;
        w18 &= 67108863;
        o[0] = w0;
        o[1] = w1;
        o[2] = w2;
        o[3] = w3;
        o[4] = w4;
        o[5] = w5;
        o[6] = w6;
        o[7] = w7;
        o[8] = w8;
        o[9] = w9;
        o[10] = w10;
        o[11] = w11;
        o[12] = w12;
        o[13] = w13;
        o[14] = w14;
        o[15] = w15;
        o[16] = w16;
        o[17] = w17;
        o[18] = w18;
        if (c !== 0) {
          o[19] = c;
          out.length++;
        }
        return out;
      };
      if (!Math.imul) {
        comb10MulTo = smallMulTo;
      }
      function bigMulTo(self2, num, out) {
        out.negative = num.negative ^ self2.negative;
        out.length = self2.length + num.length;
        var carry = 0;
        var hncarry = 0;
        for (var k = 0; k < out.length - 1; k++) {
          var ncarry = hncarry;
          hncarry = 0;
          var rword = carry & 67108863;
          var maxJ = Math.min(k, num.length - 1);
          for (var j = Math.max(0, k - self2.length + 1); j <= maxJ; j++) {
            var i = k - j;
            var a = self2.words[i] | 0;
            var b = num.words[j] | 0;
            var r = a * b;
            var lo = r & 67108863;
            ncarry = ncarry + (r / 67108864 | 0) | 0;
            lo = lo + rword | 0;
            rword = lo & 67108863;
            ncarry = ncarry + (lo >>> 26) | 0;
            hncarry += ncarry >>> 26;
            ncarry &= 67108863;
          }
          out.words[k] = rword;
          carry = ncarry;
          ncarry = hncarry;
        }
        if (carry !== 0) {
          out.words[k] = carry;
        } else {
          out.length--;
        }
        return out.strip();
      }
      function jumboMulTo(self2, num, out) {
        var fftm = new FFTM();
        return fftm.mulp(self2, num, out);
      }
      BN.prototype.mulTo = function mulTo(num, out) {
        var res;
        var len = this.length + num.length;
        if (this.length === 10 && num.length === 10) {
          res = comb10MulTo(this, num, out);
        } else if (len < 63) {
          res = smallMulTo(this, num, out);
        } else if (len < 1024) {
          res = bigMulTo(this, num, out);
        } else {
          res = jumboMulTo(this, num, out);
        }
        return res;
      };
      function FFTM(x, y) {
        this.x = x;
        this.y = y;
      }
      FFTM.prototype.makeRBT = function makeRBT(N) {
        var t = new Array(N);
        var l = BN.prototype._countBits(N) - 1;
        for (var i = 0; i < N; i++) {
          t[i] = this.revBin(i, l, N);
        }
        return t;
      };
      FFTM.prototype.revBin = function revBin(x, l, N) {
        if (x === 0 || x === N - 1) return x;
        var rb = 0;
        for (var i = 0; i < l; i++) {
          rb |= (x & 1) << l - i - 1;
          x >>= 1;
        }
        return rb;
      };
      FFTM.prototype.permute = function permute(rbt, rws, iws, rtws, itws, N) {
        for (var i = 0; i < N; i++) {
          rtws[i] = rws[rbt[i]];
          itws[i] = iws[rbt[i]];
        }
      };
      FFTM.prototype.transform = function transform(rws, iws, rtws, itws, N, rbt) {
        this.permute(rbt, rws, iws, rtws, itws, N);
        for (var s = 1; s < N; s <<= 1) {
          var l = s << 1;
          var rtwdf = Math.cos(2 * Math.PI / l);
          var itwdf = Math.sin(2 * Math.PI / l);
          for (var p = 0; p < N; p += l) {
            var rtwdf_ = rtwdf;
            var itwdf_ = itwdf;
            for (var j = 0; j < s; j++) {
              var re = rtws[p + j];
              var ie = itws[p + j];
              var ro = rtws[p + j + s];
              var io = itws[p + j + s];
              var rx = rtwdf_ * ro - itwdf_ * io;
              io = rtwdf_ * io + itwdf_ * ro;
              ro = rx;
              rtws[p + j] = re + ro;
              itws[p + j] = ie + io;
              rtws[p + j + s] = re - ro;
              itws[p + j + s] = ie - io;
              if (j !== l) {
                rx = rtwdf * rtwdf_ - itwdf * itwdf_;
                itwdf_ = rtwdf * itwdf_ + itwdf * rtwdf_;
                rtwdf_ = rx;
              }
            }
          }
        }
      };
      FFTM.prototype.guessLen13b = function guessLen13b(n, m) {
        var N = Math.max(m, n) | 1;
        var odd = N & 1;
        var i = 0;
        for (N = N / 2 | 0; N; N = N >>> 1) {
          i++;
        }
        return 1 << i + 1 + odd;
      };
      FFTM.prototype.conjugate = function conjugate(rws, iws, N) {
        if (N <= 1) return;
        for (var i = 0; i < N / 2; i++) {
          var t = rws[i];
          rws[i] = rws[N - i - 1];
          rws[N - i - 1] = t;
          t = iws[i];
          iws[i] = -iws[N - i - 1];
          iws[N - i - 1] = -t;
        }
      };
      FFTM.prototype.normalize13b = function normalize13b(ws, N) {
        var carry = 0;
        for (var i = 0; i < N / 2; i++) {
          var w = Math.round(ws[2 * i + 1] / N) * 8192 + Math.round(ws[2 * i] / N) + carry;
          ws[i] = w & 67108863;
          if (w < 67108864) {
            carry = 0;
          } else {
            carry = w / 67108864 | 0;
          }
        }
        return ws;
      };
      FFTM.prototype.convert13b = function convert13b(ws, len, rws, N) {
        var carry = 0;
        for (var i = 0; i < len; i++) {
          carry = carry + (ws[i] | 0);
          rws[2 * i] = carry & 8191;
          carry = carry >>> 13;
          rws[2 * i + 1] = carry & 8191;
          carry = carry >>> 13;
        }
        for (i = 2 * len; i < N; ++i) {
          rws[i] = 0;
        }
        assert(carry === 0);
        assert((carry & ~8191) === 0);
      };
      FFTM.prototype.stub = function stub(N) {
        var ph = new Array(N);
        for (var i = 0; i < N; i++) {
          ph[i] = 0;
        }
        return ph;
      };
      FFTM.prototype.mulp = function mulp(x, y, out) {
        var N = 2 * this.guessLen13b(x.length, y.length);
        var rbt = this.makeRBT(N);
        var _ = this.stub(N);
        var rws = new Array(N);
        var rwst = new Array(N);
        var iwst = new Array(N);
        var nrws = new Array(N);
        var nrwst = new Array(N);
        var niwst = new Array(N);
        var rmws = out.words;
        rmws.length = N;
        this.convert13b(x.words, x.length, rws, N);
        this.convert13b(y.words, y.length, nrws, N);
        this.transform(rws, _, rwst, iwst, N, rbt);
        this.transform(nrws, _, nrwst, niwst, N, rbt);
        for (var i = 0; i < N; i++) {
          var rx = rwst[i] * nrwst[i] - iwst[i] * niwst[i];
          iwst[i] = rwst[i] * niwst[i] + iwst[i] * nrwst[i];
          rwst[i] = rx;
        }
        this.conjugate(rwst, iwst, N);
        this.transform(rwst, iwst, rmws, _, N, rbt);
        this.conjugate(rmws, _, N);
        this.normalize13b(rmws, N);
        out.negative = x.negative ^ y.negative;
        out.length = x.length + y.length;
        return out.strip();
      };
      BN.prototype.mul = function mul(num) {
        var out = new BN(null);
        out.words = new Array(this.length + num.length);
        return this.mulTo(num, out);
      };
      BN.prototype.mulf = function mulf(num) {
        var out = new BN(null);
        out.words = new Array(this.length + num.length);
        return jumboMulTo(this, num, out);
      };
      BN.prototype.imul = function imul(num) {
        return this.clone().mulTo(num, this);
      };
      BN.prototype.imuln = function imuln(num) {
        assert(typeof num === "number");
        assert(num < 67108864);
        var carry = 0;
        for (var i = 0; i < this.length; i++) {
          var w = (this.words[i] | 0) * num;
          var lo = (w & 67108863) + (carry & 67108863);
          carry >>= 26;
          carry += w / 67108864 | 0;
          carry += lo >>> 26;
          this.words[i] = lo & 67108863;
        }
        if (carry !== 0) {
          this.words[i] = carry;
          this.length++;
        }
        return this;
      };
      BN.prototype.muln = function muln(num) {
        return this.clone().imuln(num);
      };
      BN.prototype.sqr = function sqr() {
        return this.mul(this);
      };
      BN.prototype.isqr = function isqr() {
        return this.imul(this.clone());
      };
      BN.prototype.pow = function pow(num) {
        var w = toBitArray(num);
        if (w.length === 0) return new BN(1);
        var res = this;
        for (var i = 0; i < w.length; i++, res = res.sqr()) {
          if (w[i] !== 0) break;
        }
        if (++i < w.length) {
          for (var q = res.sqr(); i < w.length; i++, q = q.sqr()) {
            if (w[i] === 0) continue;
            res = res.mul(q);
          }
        }
        return res;
      };
      BN.prototype.iushln = function iushln(bits) {
        assert(typeof bits === "number" && bits >= 0);
        var r = bits % 26;
        var s = (bits - r) / 26;
        var carryMask = 67108863 >>> 26 - r << 26 - r;
        var i;
        if (r !== 0) {
          var carry = 0;
          for (i = 0; i < this.length; i++) {
            var newCarry = this.words[i] & carryMask;
            var c = (this.words[i] | 0) - newCarry << r;
            this.words[i] = c | carry;
            carry = newCarry >>> 26 - r;
          }
          if (carry) {
            this.words[i] = carry;
            this.length++;
          }
        }
        if (s !== 0) {
          for (i = this.length - 1; i >= 0; i--) {
            this.words[i + s] = this.words[i];
          }
          for (i = 0; i < s; i++) {
            this.words[i] = 0;
          }
          this.length += s;
        }
        return this.strip();
      };
      BN.prototype.ishln = function ishln(bits) {
        assert(this.negative === 0);
        return this.iushln(bits);
      };
      BN.prototype.iushrn = function iushrn(bits, hint, extended) {
        assert(typeof bits === "number" && bits >= 0);
        var h;
        if (hint) {
          h = (hint - hint % 26) / 26;
        } else {
          h = 0;
        }
        var r = bits % 26;
        var s = Math.min((bits - r) / 26, this.length);
        var mask = 67108863 ^ 67108863 >>> r << r;
        var maskedWords = extended;
        h -= s;
        h = Math.max(0, h);
        if (maskedWords) {
          for (var i = 0; i < s; i++) {
            maskedWords.words[i] = this.words[i];
          }
          maskedWords.length = s;
        }
        if (s === 0) {
        } else if (this.length > s) {
          this.length -= s;
          for (i = 0; i < this.length; i++) {
            this.words[i] = this.words[i + s];
          }
        } else {
          this.words[0] = 0;
          this.length = 1;
        }
        var carry = 0;
        for (i = this.length - 1; i >= 0 && (carry !== 0 || i >= h); i--) {
          var word = this.words[i] | 0;
          this.words[i] = carry << 26 - r | word >>> r;
          carry = word & mask;
        }
        if (maskedWords && carry !== 0) {
          maskedWords.words[maskedWords.length++] = carry;
        }
        if (this.length === 0) {
          this.words[0] = 0;
          this.length = 1;
        }
        return this.strip();
      };
      BN.prototype.ishrn = function ishrn(bits, hint, extended) {
        assert(this.negative === 0);
        return this.iushrn(bits, hint, extended);
      };
      BN.prototype.shln = function shln(bits) {
        return this.clone().ishln(bits);
      };
      BN.prototype.ushln = function ushln(bits) {
        return this.clone().iushln(bits);
      };
      BN.prototype.shrn = function shrn(bits) {
        return this.clone().ishrn(bits);
      };
      BN.prototype.ushrn = function ushrn(bits) {
        return this.clone().iushrn(bits);
      };
      BN.prototype.testn = function testn(bit) {
        assert(typeof bit === "number" && bit >= 0);
        var r = bit % 26;
        var s = (bit - r) / 26;
        var q = 1 << r;
        if (this.length <= s) return false;
        var w = this.words[s];
        return !!(w & q);
      };
      BN.prototype.imaskn = function imaskn(bits) {
        assert(typeof bits === "number" && bits >= 0);
        var r = bits % 26;
        var s = (bits - r) / 26;
        assert(this.negative === 0, "imaskn works only with positive numbers");
        if (this.length <= s) {
          return this;
        }
        if (r !== 0) {
          s++;
        }
        this.length = Math.min(s, this.length);
        if (r !== 0) {
          var mask = 67108863 ^ 67108863 >>> r << r;
          this.words[this.length - 1] &= mask;
        }
        return this.strip();
      };
      BN.prototype.maskn = function maskn(bits) {
        return this.clone().imaskn(bits);
      };
      BN.prototype.iaddn = function iaddn(num) {
        assert(typeof num === "number");
        assert(num < 67108864);
        if (num < 0) return this.isubn(-num);
        if (this.negative !== 0) {
          if (this.length === 1 && (this.words[0] | 0) < num) {
            this.words[0] = num - (this.words[0] | 0);
            this.negative = 0;
            return this;
          }
          this.negative = 0;
          this.isubn(num);
          this.negative = 1;
          return this;
        }
        return this._iaddn(num);
      };
      BN.prototype._iaddn = function _iaddn(num) {
        this.words[0] += num;
        for (var i = 0; i < this.length && this.words[i] >= 67108864; i++) {
          this.words[i] -= 67108864;
          if (i === this.length - 1) {
            this.words[i + 1] = 1;
          } else {
            this.words[i + 1]++;
          }
        }
        this.length = Math.max(this.length, i + 1);
        return this;
      };
      BN.prototype.isubn = function isubn(num) {
        assert(typeof num === "number");
        assert(num < 67108864);
        if (num < 0) return this.iaddn(-num);
        if (this.negative !== 0) {
          this.negative = 0;
          this.iaddn(num);
          this.negative = 1;
          return this;
        }
        this.words[0] -= num;
        if (this.length === 1 && this.words[0] < 0) {
          this.words[0] = -this.words[0];
          this.negative = 1;
        } else {
          for (var i = 0; i < this.length && this.words[i] < 0; i++) {
            this.words[i] += 67108864;
            this.words[i + 1] -= 1;
          }
        }
        return this.strip();
      };
      BN.prototype.addn = function addn(num) {
        return this.clone().iaddn(num);
      };
      BN.prototype.subn = function subn(num) {
        return this.clone().isubn(num);
      };
      BN.prototype.iabs = function iabs() {
        this.negative = 0;
        return this;
      };
      BN.prototype.abs = function abs() {
        return this.clone().iabs();
      };
      BN.prototype._ishlnsubmul = function _ishlnsubmul(num, mul, shift) {
        var len = num.length + shift;
        var i;
        this._expand(len);
        var w;
        var carry = 0;
        for (i = 0; i < num.length; i++) {
          w = (this.words[i + shift] | 0) + carry;
          var right = (num.words[i] | 0) * mul;
          w -= right & 67108863;
          carry = (w >> 26) - (right / 67108864 | 0);
          this.words[i + shift] = w & 67108863;
        }
        for (; i < this.length - shift; i++) {
          w = (this.words[i + shift] | 0) + carry;
          carry = w >> 26;
          this.words[i + shift] = w & 67108863;
        }
        if (carry === 0) return this.strip();
        assert(carry === -1);
        carry = 0;
        for (i = 0; i < this.length; i++) {
          w = -(this.words[i] | 0) + carry;
          carry = w >> 26;
          this.words[i] = w & 67108863;
        }
        this.negative = 1;
        return this.strip();
      };
      BN.prototype._wordDiv = function _wordDiv(num, mode) {
        var shift = this.length - num.length;
        var a = this.clone();
        var b = num;
        var bhi = b.words[b.length - 1] | 0;
        var bhiBits = this._countBits(bhi);
        shift = 26 - bhiBits;
        if (shift !== 0) {
          b = b.ushln(shift);
          a.iushln(shift);
          bhi = b.words[b.length - 1] | 0;
        }
        var m = a.length - b.length;
        var q;
        if (mode !== "mod") {
          q = new BN(null);
          q.length = m + 1;
          q.words = new Array(q.length);
          for (var i = 0; i < q.length; i++) {
            q.words[i] = 0;
          }
        }
        var diff = a.clone()._ishlnsubmul(b, 1, m);
        if (diff.negative === 0) {
          a = diff;
          if (q) {
            q.words[m] = 1;
          }
        }
        for (var j = m - 1; j >= 0; j--) {
          var qj = (a.words[b.length + j] | 0) * 67108864 + (a.words[b.length + j - 1] | 0);
          qj = Math.min(qj / bhi | 0, 67108863);
          a._ishlnsubmul(b, qj, j);
          while (a.negative !== 0) {
            qj--;
            a.negative = 0;
            a._ishlnsubmul(b, 1, j);
            if (!a.isZero()) {
              a.negative ^= 1;
            }
          }
          if (q) {
            q.words[j] = qj;
          }
        }
        if (q) {
          q.strip();
        }
        a.strip();
        if (mode !== "div" && shift !== 0) {
          a.iushrn(shift);
        }
        return {
          div: q || null,
          mod: a
        };
      };
      BN.prototype.divmod = function divmod(num, mode, positive) {
        assert(!num.isZero());
        if (this.isZero()) {
          return {
            div: new BN(0),
            mod: new BN(0)
          };
        }
        var div, mod, res;
        if (this.negative !== 0 && num.negative === 0) {
          res = this.neg().divmod(num, mode);
          if (mode !== "mod") {
            div = res.div.neg();
          }
          if (mode !== "div") {
            mod = res.mod.neg();
            if (positive && mod.negative !== 0) {
              mod.iadd(num);
            }
          }
          return {
            div,
            mod
          };
        }
        if (this.negative === 0 && num.negative !== 0) {
          res = this.divmod(num.neg(), mode);
          if (mode !== "mod") {
            div = res.div.neg();
          }
          return {
            div,
            mod: res.mod
          };
        }
        if ((this.negative & num.negative) !== 0) {
          res = this.neg().divmod(num.neg(), mode);
          if (mode !== "div") {
            mod = res.mod.neg();
            if (positive && mod.negative !== 0) {
              mod.isub(num);
            }
          }
          return {
            div: res.div,
            mod
          };
        }
        if (num.length > this.length || this.cmp(num) < 0) {
          return {
            div: new BN(0),
            mod: this
          };
        }
        if (num.length === 1) {
          if (mode === "div") {
            return {
              div: this.divn(num.words[0]),
              mod: null
            };
          }
          if (mode === "mod") {
            return {
              div: null,
              mod: new BN(this.modn(num.words[0]))
            };
          }
          return {
            div: this.divn(num.words[0]),
            mod: new BN(this.modn(num.words[0]))
          };
        }
        return this._wordDiv(num, mode);
      };
      BN.prototype.div = function div(num) {
        return this.divmod(num, "div", false).div;
      };
      BN.prototype.mod = function mod(num) {
        return this.divmod(num, "mod", false).mod;
      };
      BN.prototype.umod = function umod(num) {
        return this.divmod(num, "mod", true).mod;
      };
      BN.prototype.divRound = function divRound(num) {
        var dm = this.divmod(num);
        if (dm.mod.isZero()) return dm.div;
        var mod = dm.div.negative !== 0 ? dm.mod.isub(num) : dm.mod;
        var half = num.ushrn(1);
        var r2 = num.andln(1);
        var cmp = mod.cmp(half);
        if (cmp < 0 || r2 === 1 && cmp === 0) return dm.div;
        return dm.div.negative !== 0 ? dm.div.isubn(1) : dm.div.iaddn(1);
      };
      BN.prototype.modn = function modn(num) {
        assert(num <= 67108863);
        var p = (1 << 26) % num;
        var acc = 0;
        for (var i = this.length - 1; i >= 0; i--) {
          acc = (p * acc + (this.words[i] | 0)) % num;
        }
        return acc;
      };
      BN.prototype.idivn = function idivn(num) {
        assert(num <= 67108863);
        var carry = 0;
        for (var i = this.length - 1; i >= 0; i--) {
          var w = (this.words[i] | 0) + carry * 67108864;
          this.words[i] = w / num | 0;
          carry = w % num;
        }
        return this.strip();
      };
      BN.prototype.divn = function divn(num) {
        return this.clone().idivn(num);
      };
      BN.prototype.egcd = function egcd(p) {
        assert(p.negative === 0);
        assert(!p.isZero());
        var x = this;
        var y = p.clone();
        if (x.negative !== 0) {
          x = x.umod(p);
        } else {
          x = x.clone();
        }
        var A = new BN(1);
        var B = new BN(0);
        var C = new BN(0);
        var D = new BN(1);
        var g = 0;
        while (x.isEven() && y.isEven()) {
          x.iushrn(1);
          y.iushrn(1);
          ++g;
        }
        var yp = y.clone();
        var xp = x.clone();
        while (!x.isZero()) {
          for (var i = 0, im = 1; (x.words[0] & im) === 0 && i < 26; ++i, im <<= 1) ;
          if (i > 0) {
            x.iushrn(i);
            while (i-- > 0) {
              if (A.isOdd() || B.isOdd()) {
                A.iadd(yp);
                B.isub(xp);
              }
              A.iushrn(1);
              B.iushrn(1);
            }
          }
          for (var j = 0, jm = 1; (y.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1) ;
          if (j > 0) {
            y.iushrn(j);
            while (j-- > 0) {
              if (C.isOdd() || D.isOdd()) {
                C.iadd(yp);
                D.isub(xp);
              }
              C.iushrn(1);
              D.iushrn(1);
            }
          }
          if (x.cmp(y) >= 0) {
            x.isub(y);
            A.isub(C);
            B.isub(D);
          } else {
            y.isub(x);
            C.isub(A);
            D.isub(B);
          }
        }
        return {
          a: C,
          b: D,
          gcd: y.iushln(g)
        };
      };
      BN.prototype._invmp = function _invmp(p) {
        assert(p.negative === 0);
        assert(!p.isZero());
        var a = this;
        var b = p.clone();
        if (a.negative !== 0) {
          a = a.umod(p);
        } else {
          a = a.clone();
        }
        var x1 = new BN(1);
        var x2 = new BN(0);
        var delta = b.clone();
        while (a.cmpn(1) > 0 && b.cmpn(1) > 0) {
          for (var i = 0, im = 1; (a.words[0] & im) === 0 && i < 26; ++i, im <<= 1) ;
          if (i > 0) {
            a.iushrn(i);
            while (i-- > 0) {
              if (x1.isOdd()) {
                x1.iadd(delta);
              }
              x1.iushrn(1);
            }
          }
          for (var j = 0, jm = 1; (b.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1) ;
          if (j > 0) {
            b.iushrn(j);
            while (j-- > 0) {
              if (x2.isOdd()) {
                x2.iadd(delta);
              }
              x2.iushrn(1);
            }
          }
          if (a.cmp(b) >= 0) {
            a.isub(b);
            x1.isub(x2);
          } else {
            b.isub(a);
            x2.isub(x1);
          }
        }
        var res;
        if (a.cmpn(1) === 0) {
          res = x1;
        } else {
          res = x2;
        }
        if (res.cmpn(0) < 0) {
          res.iadd(p);
        }
        return res;
      };
      BN.prototype.gcd = function gcd(num) {
        if (this.isZero()) return num.abs();
        if (num.isZero()) return this.abs();
        var a = this.clone();
        var b = num.clone();
        a.negative = 0;
        b.negative = 0;
        for (var shift = 0; a.isEven() && b.isEven(); shift++) {
          a.iushrn(1);
          b.iushrn(1);
        }
        do {
          while (a.isEven()) {
            a.iushrn(1);
          }
          while (b.isEven()) {
            b.iushrn(1);
          }
          var r = a.cmp(b);
          if (r < 0) {
            var t = a;
            a = b;
            b = t;
          } else if (r === 0 || b.cmpn(1) === 0) {
            break;
          }
          a.isub(b);
        } while (true);
        return b.iushln(shift);
      };
      BN.prototype.invm = function invm(num) {
        return this.egcd(num).a.umod(num);
      };
      BN.prototype.isEven = function isEven() {
        return (this.words[0] & 1) === 0;
      };
      BN.prototype.isOdd = function isOdd() {
        return (this.words[0] & 1) === 1;
      };
      BN.prototype.andln = function andln(num) {
        return this.words[0] & num;
      };
      BN.prototype.bincn = function bincn(bit) {
        assert(typeof bit === "number");
        var r = bit % 26;
        var s = (bit - r) / 26;
        var q = 1 << r;
        if (this.length <= s) {
          this._expand(s + 1);
          this.words[s] |= q;
          return this;
        }
        var carry = q;
        for (var i = s; carry !== 0 && i < this.length; i++) {
          var w = this.words[i] | 0;
          w += carry;
          carry = w >>> 26;
          w &= 67108863;
          this.words[i] = w;
        }
        if (carry !== 0) {
          this.words[i] = carry;
          this.length++;
        }
        return this;
      };
      BN.prototype.isZero = function isZero() {
        return this.length === 1 && this.words[0] === 0;
      };
      BN.prototype.cmpn = function cmpn(num) {
        var negative = num < 0;
        if (this.negative !== 0 && !negative) return -1;
        if (this.negative === 0 && negative) return 1;
        this.strip();
        var res;
        if (this.length > 1) {
          res = 1;
        } else {
          if (negative) {
            num = -num;
          }
          assert(num <= 67108863, "Number is too big");
          var w = this.words[0] | 0;
          res = w === num ? 0 : w < num ? -1 : 1;
        }
        if (this.negative !== 0) return -res | 0;
        return res;
      };
      BN.prototype.cmp = function cmp(num) {
        if (this.negative !== 0 && num.negative === 0) return -1;
        if (this.negative === 0 && num.negative !== 0) return 1;
        var res = this.ucmp(num);
        if (this.negative !== 0) return -res | 0;
        return res;
      };
      BN.prototype.ucmp = function ucmp(num) {
        if (this.length > num.length) return 1;
        if (this.length < num.length) return -1;
        var res = 0;
        for (var i = this.length - 1; i >= 0; i--) {
          var a = this.words[i] | 0;
          var b = num.words[i] | 0;
          if (a === b) continue;
          if (a < b) {
            res = -1;
          } else if (a > b) {
            res = 1;
          }
          break;
        }
        return res;
      };
      BN.prototype.gtn = function gtn(num) {
        return this.cmpn(num) === 1;
      };
      BN.prototype.gt = function gt(num) {
        return this.cmp(num) === 1;
      };
      BN.prototype.gten = function gten(num) {
        return this.cmpn(num) >= 0;
      };
      BN.prototype.gte = function gte(num) {
        return this.cmp(num) >= 0;
      };
      BN.prototype.ltn = function ltn(num) {
        return this.cmpn(num) === -1;
      };
      BN.prototype.lt = function lt(num) {
        return this.cmp(num) === -1;
      };
      BN.prototype.lten = function lten(num) {
        return this.cmpn(num) <= 0;
      };
      BN.prototype.lte = function lte(num) {
        return this.cmp(num) <= 0;
      };
      BN.prototype.eqn = function eqn(num) {
        return this.cmpn(num) === 0;
      };
      BN.prototype.eq = function eq(num) {
        return this.cmp(num) === 0;
      };
      BN.red = function red(num) {
        return new Red(num);
      };
      BN.prototype.toRed = function toRed(ctx) {
        assert(!this.red, "Already a number in reduction context");
        assert(this.negative === 0, "red works only with positives");
        return ctx.convertTo(this)._forceRed(ctx);
      };
      BN.prototype.fromRed = function fromRed() {
        assert(this.red, "fromRed works only with numbers in reduction context");
        return this.red.convertFrom(this);
      };
      BN.prototype._forceRed = function _forceRed(ctx) {
        this.red = ctx;
        return this;
      };
      BN.prototype.forceRed = function forceRed(ctx) {
        assert(!this.red, "Already a number in reduction context");
        return this._forceRed(ctx);
      };
      BN.prototype.redAdd = function redAdd(num) {
        assert(this.red, "redAdd works only with red numbers");
        return this.red.add(this, num);
      };
      BN.prototype.redIAdd = function redIAdd(num) {
        assert(this.red, "redIAdd works only with red numbers");
        return this.red.iadd(this, num);
      };
      BN.prototype.redSub = function redSub(num) {
        assert(this.red, "redSub works only with red numbers");
        return this.red.sub(this, num);
      };
      BN.prototype.redISub = function redISub(num) {
        assert(this.red, "redISub works only with red numbers");
        return this.red.isub(this, num);
      };
      BN.prototype.redShl = function redShl(num) {
        assert(this.red, "redShl works only with red numbers");
        return this.red.shl(this, num);
      };
      BN.prototype.redMul = function redMul(num) {
        assert(this.red, "redMul works only with red numbers");
        this.red._verify2(this, num);
        return this.red.mul(this, num);
      };
      BN.prototype.redIMul = function redIMul(num) {
        assert(this.red, "redMul works only with red numbers");
        this.red._verify2(this, num);
        return this.red.imul(this, num);
      };
      BN.prototype.redSqr = function redSqr() {
        assert(this.red, "redSqr works only with red numbers");
        this.red._verify1(this);
        return this.red.sqr(this);
      };
      BN.prototype.redISqr = function redISqr() {
        assert(this.red, "redISqr works only with red numbers");
        this.red._verify1(this);
        return this.red.isqr(this);
      };
      BN.prototype.redSqrt = function redSqrt() {
        assert(this.red, "redSqrt works only with red numbers");
        this.red._verify1(this);
        return this.red.sqrt(this);
      };
      BN.prototype.redInvm = function redInvm() {
        assert(this.red, "redInvm works only with red numbers");
        this.red._verify1(this);
        return this.red.invm(this);
      };
      BN.prototype.redNeg = function redNeg() {
        assert(this.red, "redNeg works only with red numbers");
        this.red._verify1(this);
        return this.red.neg(this);
      };
      BN.prototype.redPow = function redPow(num) {
        assert(this.red && !num.red, "redPow(normalNum)");
        this.red._verify1(this);
        return this.red.pow(this, num);
      };
      var primes = {
        k256: null,
        p224: null,
        p192: null,
        p25519: null
      };
      function MPrime(name2, p) {
        this.name = name2;
        this.p = new BN(p, 16);
        this.n = this.p.bitLength();
        this.k = new BN(1).iushln(this.n).isub(this.p);
        this.tmp = this._tmp();
      }
      MPrime.prototype._tmp = function _tmp() {
        var tmp = new BN(null);
        tmp.words = new Array(Math.ceil(this.n / 13));
        return tmp;
      };
      MPrime.prototype.ireduce = function ireduce(num) {
        var r = num;
        var rlen;
        do {
          this.split(r, this.tmp);
          r = this.imulK(r);
          r = r.iadd(this.tmp);
          rlen = r.bitLength();
        } while (rlen > this.n);
        var cmp = rlen < this.n ? -1 : r.ucmp(this.p);
        if (cmp === 0) {
          r.words[0] = 0;
          r.length = 1;
        } else if (cmp > 0) {
          r.isub(this.p);
        } else {
          if (r.strip !== void 0) {
            r.strip();
          } else {
            r._strip();
          }
        }
        return r;
      };
      MPrime.prototype.split = function split(input, out) {
        input.iushrn(this.n, 0, out);
      };
      MPrime.prototype.imulK = function imulK(num) {
        return num.imul(this.k);
      };
      function K256() {
        MPrime.call(
          this,
          "k256",
          "ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f"
        );
      }
      inherits(K256, MPrime);
      K256.prototype.split = function split(input, output) {
        var mask = 4194303;
        var outLen = Math.min(input.length, 9);
        for (var i = 0; i < outLen; i++) {
          output.words[i] = input.words[i];
        }
        output.length = outLen;
        if (input.length <= 9) {
          input.words[0] = 0;
          input.length = 1;
          return;
        }
        var prev = input.words[9];
        output.words[output.length++] = prev & mask;
        for (i = 10; i < input.length; i++) {
          var next = input.words[i] | 0;
          input.words[i - 10] = (next & mask) << 4 | prev >>> 22;
          prev = next;
        }
        prev >>>= 22;
        input.words[i - 10] = prev;
        if (prev === 0 && input.length > 10) {
          input.length -= 10;
        } else {
          input.length -= 9;
        }
      };
      K256.prototype.imulK = function imulK(num) {
        num.words[num.length] = 0;
        num.words[num.length + 1] = 0;
        num.length += 2;
        var lo = 0;
        for (var i = 0; i < num.length; i++) {
          var w = num.words[i] | 0;
          lo += w * 977;
          num.words[i] = lo & 67108863;
          lo = w * 64 + (lo / 67108864 | 0);
        }
        if (num.words[num.length - 1] === 0) {
          num.length--;
          if (num.words[num.length - 1] === 0) {
            num.length--;
          }
        }
        return num;
      };
      function P224() {
        MPrime.call(
          this,
          "p224",
          "ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001"
        );
      }
      inherits(P224, MPrime);
      function P192() {
        MPrime.call(
          this,
          "p192",
          "ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff"
        );
      }
      inherits(P192, MPrime);
      function P25519() {
        MPrime.call(
          this,
          "25519",
          "7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed"
        );
      }
      inherits(P25519, MPrime);
      P25519.prototype.imulK = function imulK(num) {
        var carry = 0;
        for (var i = 0; i < num.length; i++) {
          var hi = (num.words[i] | 0) * 19 + carry;
          var lo = hi & 67108863;
          hi >>>= 26;
          num.words[i] = lo;
          carry = hi;
        }
        if (carry !== 0) {
          num.words[num.length++] = carry;
        }
        return num;
      };
      BN._prime = function prime(name2) {
        if (primes[name2]) return primes[name2];
        var prime2;
        if (name2 === "k256") {
          prime2 = new K256();
        } else if (name2 === "p224") {
          prime2 = new P224();
        } else if (name2 === "p192") {
          prime2 = new P192();
        } else if (name2 === "p25519") {
          prime2 = new P25519();
        } else {
          throw new Error("Unknown prime " + name2);
        }
        primes[name2] = prime2;
        return prime2;
      };
      function Red(m) {
        if (typeof m === "string") {
          var prime = BN._prime(m);
          this.m = prime.p;
          this.prime = prime;
        } else {
          assert(m.gtn(1), "modulus must be greater than 1");
          this.m = m;
          this.prime = null;
        }
      }
      Red.prototype._verify1 = function _verify1(a) {
        assert(a.negative === 0, "red works only with positives");
        assert(a.red, "red works only with red numbers");
      };
      Red.prototype._verify2 = function _verify2(a, b) {
        assert((a.negative | b.negative) === 0, "red works only with positives");
        assert(
          a.red && a.red === b.red,
          "red works only with red numbers"
        );
      };
      Red.prototype.imod = function imod(a) {
        if (this.prime) return this.prime.ireduce(a)._forceRed(this);
        return a.umod(this.m)._forceRed(this);
      };
      Red.prototype.neg = function neg(a) {
        if (a.isZero()) {
          return a.clone();
        }
        return this.m.sub(a)._forceRed(this);
      };
      Red.prototype.add = function add(a, b) {
        this._verify2(a, b);
        var res = a.add(b);
        if (res.cmp(this.m) >= 0) {
          res.isub(this.m);
        }
        return res._forceRed(this);
      };
      Red.prototype.iadd = function iadd(a, b) {
        this._verify2(a, b);
        var res = a.iadd(b);
        if (res.cmp(this.m) >= 0) {
          res.isub(this.m);
        }
        return res;
      };
      Red.prototype.sub = function sub(a, b) {
        this._verify2(a, b);
        var res = a.sub(b);
        if (res.cmpn(0) < 0) {
          res.iadd(this.m);
        }
        return res._forceRed(this);
      };
      Red.prototype.isub = function isub(a, b) {
        this._verify2(a, b);
        var res = a.isub(b);
        if (res.cmpn(0) < 0) {
          res.iadd(this.m);
        }
        return res;
      };
      Red.prototype.shl = function shl(a, num) {
        this._verify1(a);
        return this.imod(a.ushln(num));
      };
      Red.prototype.imul = function imul(a, b) {
        this._verify2(a, b);
        return this.imod(a.imul(b));
      };
      Red.prototype.mul = function mul(a, b) {
        this._verify2(a, b);
        return this.imod(a.mul(b));
      };
      Red.prototype.isqr = function isqr(a) {
        return this.imul(a, a.clone());
      };
      Red.prototype.sqr = function sqr(a) {
        return this.mul(a, a);
      };
      Red.prototype.sqrt = function sqrt(a) {
        if (a.isZero()) return a.clone();
        var mod3 = this.m.andln(3);
        assert(mod3 % 2 === 1);
        if (mod3 === 3) {
          var pow = this.m.add(new BN(1)).iushrn(2);
          return this.pow(a, pow);
        }
        var q = this.m.subn(1);
        var s = 0;
        while (!q.isZero() && q.andln(1) === 0) {
          s++;
          q.iushrn(1);
        }
        assert(!q.isZero());
        var one = new BN(1).toRed(this);
        var nOne = one.redNeg();
        var lpow = this.m.subn(1).iushrn(1);
        var z = this.m.bitLength();
        z = new BN(2 * z * z).toRed(this);
        while (this.pow(z, lpow).cmp(nOne) !== 0) {
          z.redIAdd(nOne);
        }
        var c = this.pow(z, q);
        var r = this.pow(a, q.addn(1).iushrn(1));
        var t = this.pow(a, q);
        var m = s;
        while (t.cmp(one) !== 0) {
          var tmp = t;
          for (var i = 0; tmp.cmp(one) !== 0; i++) {
            tmp = tmp.redSqr();
          }
          assert(i < m);
          var b = this.pow(c, new BN(1).iushln(m - i - 1));
          r = r.redMul(b);
          c = b.redSqr();
          t = t.redMul(c);
          m = i;
        }
        return r;
      };
      Red.prototype.invm = function invm(a) {
        var inv = a._invmp(this.m);
        if (inv.negative !== 0) {
          inv.negative = 0;
          return this.imod(inv).redNeg();
        } else {
          return this.imod(inv);
        }
      };
      Red.prototype.pow = function pow(a, num) {
        if (num.isZero()) return new BN(1).toRed(this);
        if (num.cmpn(1) === 0) return a.clone();
        var windowSize = 4;
        var wnd = new Array(1 << windowSize);
        wnd[0] = new BN(1).toRed(this);
        wnd[1] = a;
        for (var i = 2; i < wnd.length; i++) {
          wnd[i] = this.mul(wnd[i - 1], a);
        }
        var res = wnd[0];
        var current = 0;
        var currentLen = 0;
        var start = num.bitLength() % 26;
        if (start === 0) {
          start = 26;
        }
        for (i = num.length - 1; i >= 0; i--) {
          var word = num.words[i];
          for (var j = start - 1; j >= 0; j--) {
            var bit = word >> j & 1;
            if (res !== wnd[0]) {
              res = this.sqr(res);
            }
            if (bit === 0 && current === 0) {
              currentLen = 0;
              continue;
            }
            current <<= 1;
            current |= bit;
            currentLen++;
            if (currentLen !== windowSize && (i !== 0 || j !== 0)) continue;
            res = this.mul(res, wnd[current]);
            currentLen = 0;
            current = 0;
          }
          start = 26;
        }
        return res;
      };
      Red.prototype.convertTo = function convertTo(num) {
        var r = num.umod(this.m);
        return r === num ? r.clone() : r;
      };
      Red.prototype.convertFrom = function convertFrom(num) {
        var res = num.clone();
        res.red = null;
        return res;
      };
      BN.mont = function mont(num) {
        return new Mont(num);
      };
      function Mont(m) {
        Red.call(this, m);
        this.shift = this.m.bitLength();
        if (this.shift % 26 !== 0) {
          this.shift += 26 - this.shift % 26;
        }
        this.r = new BN(1).iushln(this.shift);
        this.r2 = this.imod(this.r.sqr());
        this.rinv = this.r._invmp(this.m);
        this.minv = this.rinv.mul(this.r).isubn(1).div(this.m);
        this.minv = this.minv.umod(this.r);
        this.minv = this.r.sub(this.minv);
      }
      inherits(Mont, Red);
      Mont.prototype.convertTo = function convertTo(num) {
        return this.imod(num.ushln(this.shift));
      };
      Mont.prototype.convertFrom = function convertFrom(num) {
        var r = this.imod(num.mul(this.rinv));
        r.red = null;
        return r;
      };
      Mont.prototype.imul = function imul(a, b) {
        if (a.isZero() || b.isZero()) {
          a.words[0] = 0;
          a.length = 1;
          return a;
        }
        var t = a.imul(b);
        var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);
        var u = t.isub(c).iushrn(this.shift);
        var res = u;
        if (u.cmp(this.m) >= 0) {
          res = u.isub(this.m);
        } else if (u.cmpn(0) < 0) {
          res = u.iadd(this.m);
        }
        return res._forceRed(this);
      };
      Mont.prototype.mul = function mul(a, b) {
        if (a.isZero() || b.isZero()) return new BN(0)._forceRed(this);
        var t = a.mul(b);
        var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);
        var u = t.isub(c).iushrn(this.shift);
        var res = u;
        if (u.cmp(this.m) >= 0) {
          res = u.isub(this.m);
        } else if (u.cmpn(0) < 0) {
          res = u.iadd(this.m);
        }
        return res._forceRed(this);
      };
      Mont.prototype.invm = function invm(a) {
        var res = this.imod(a._invmp(this.m).mul(this.r2));
        return res._forceRed(this);
      };
    })(typeof module2 === "undefined" || module2, exports2);
  }
});

// node_modules/@ethersproject/logger/lib/_version.js
var require_version = __commonJS({
  "node_modules/@ethersproject/logger/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "logger/5.5.0";
  }
});

// node_modules/@ethersproject/logger/lib/index.js
var require_lib = __commonJS({
  "node_modules/@ethersproject/logger/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Logger = exports2.ErrorCode = exports2.LogLevel = void 0;
    var _permanentCensorErrors = false;
    var _censorErrors = false;
    var LogLevels = { debug: 1, "default": 2, info: 2, warning: 3, error: 4, off: 5 };
    var _logLevel = LogLevels["default"];
    var _version_1 = require_version();
    var _globalLogger = null;
    function _checkNormalize() {
      try {
        var missing_1 = [];
        ["NFD", "NFC", "NFKD", "NFKC"].forEach(function(form) {
          try {
            if ("test".normalize(form) !== "test") {
              throw new Error("bad normalize");
            }
            ;
          } catch (error) {
            missing_1.push(form);
          }
        });
        if (missing_1.length) {
          throw new Error("missing " + missing_1.join(", "));
        }
        if (String.fromCharCode(233).normalize("NFD") !== String.fromCharCode(101, 769)) {
          throw new Error("broken implementation");
        }
      } catch (error) {
        return error.message;
      }
      return null;
    }
    var _normalizeError = _checkNormalize();
    var LogLevel;
    (function(LogLevel2) {
      LogLevel2["DEBUG"] = "DEBUG";
      LogLevel2["INFO"] = "INFO";
      LogLevel2["WARNING"] = "WARNING";
      LogLevel2["ERROR"] = "ERROR";
      LogLevel2["OFF"] = "OFF";
    })(LogLevel = exports2.LogLevel || (exports2.LogLevel = {}));
    var ErrorCode;
    (function(ErrorCode2) {
      ErrorCode2["UNKNOWN_ERROR"] = "UNKNOWN_ERROR";
      ErrorCode2["NOT_IMPLEMENTED"] = "NOT_IMPLEMENTED";
      ErrorCode2["UNSUPPORTED_OPERATION"] = "UNSUPPORTED_OPERATION";
      ErrorCode2["NETWORK_ERROR"] = "NETWORK_ERROR";
      ErrorCode2["SERVER_ERROR"] = "SERVER_ERROR";
      ErrorCode2["TIMEOUT"] = "TIMEOUT";
      ErrorCode2["BUFFER_OVERRUN"] = "BUFFER_OVERRUN";
      ErrorCode2["NUMERIC_FAULT"] = "NUMERIC_FAULT";
      ErrorCode2["MISSING_NEW"] = "MISSING_NEW";
      ErrorCode2["INVALID_ARGUMENT"] = "INVALID_ARGUMENT";
      ErrorCode2["MISSING_ARGUMENT"] = "MISSING_ARGUMENT";
      ErrorCode2["UNEXPECTED_ARGUMENT"] = "UNEXPECTED_ARGUMENT";
      ErrorCode2["CALL_EXCEPTION"] = "CALL_EXCEPTION";
      ErrorCode2["INSUFFICIENT_FUNDS"] = "INSUFFICIENT_FUNDS";
      ErrorCode2["NONCE_EXPIRED"] = "NONCE_EXPIRED";
      ErrorCode2["REPLACEMENT_UNDERPRICED"] = "REPLACEMENT_UNDERPRICED";
      ErrorCode2["UNPREDICTABLE_GAS_LIMIT"] = "UNPREDICTABLE_GAS_LIMIT";
      ErrorCode2["TRANSACTION_REPLACED"] = "TRANSACTION_REPLACED";
    })(ErrorCode = exports2.ErrorCode || (exports2.ErrorCode = {}));
    var HEX = "0123456789abcdef";
    var Logger = (
      /** @class */
      function() {
        function Logger2(version) {
          Object.defineProperty(this, "version", {
            enumerable: true,
            value: version,
            writable: false
          });
        }
        Logger2.prototype._log = function(logLevel, args) {
          var level = logLevel.toLowerCase();
          if (LogLevels[level] == null) {
            this.throwArgumentError("invalid log level name", "logLevel", logLevel);
          }
          if (_logLevel > LogLevels[level]) {
            return;
          }
          console.log.apply(console, args);
        };
        Logger2.prototype.debug = function() {
          var args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
          }
          this._log(Logger2.levels.DEBUG, args);
        };
        Logger2.prototype.info = function() {
          var args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
          }
          this._log(Logger2.levels.INFO, args);
        };
        Logger2.prototype.warn = function() {
          var args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
          }
          this._log(Logger2.levels.WARNING, args);
        };
        Logger2.prototype.makeError = function(message, code, params) {
          if (_censorErrors) {
            return this.makeError("censored error", code, {});
          }
          if (!code) {
            code = Logger2.errors.UNKNOWN_ERROR;
          }
          if (!params) {
            params = {};
          }
          var messageDetails = [];
          Object.keys(params).forEach(function(key) {
            var value = params[key];
            try {
              if (value instanceof Uint8Array) {
                var hex = "";
                for (var i = 0; i < value.length; i++) {
                  hex += HEX[value[i] >> 4];
                  hex += HEX[value[i] & 15];
                }
                messageDetails.push(key + "=Uint8Array(0x" + hex + ")");
              } else {
                messageDetails.push(key + "=" + JSON.stringify(value));
              }
            } catch (error2) {
              messageDetails.push(key + "=" + JSON.stringify(params[key].toString()));
            }
          });
          messageDetails.push("code=" + code);
          messageDetails.push("version=" + this.version);
          var reason = message;
          if (messageDetails.length) {
            message += " (" + messageDetails.join(", ") + ")";
          }
          var error = new Error(message);
          error.reason = reason;
          error.code = code;
          Object.keys(params).forEach(function(key) {
            error[key] = params[key];
          });
          return error;
        };
        Logger2.prototype.throwError = function(message, code, params) {
          throw this.makeError(message, code, params);
        };
        Logger2.prototype.throwArgumentError = function(message, name2, value) {
          return this.throwError(message, Logger2.errors.INVALID_ARGUMENT, {
            argument: name2,
            value
          });
        };
        Logger2.prototype.assert = function(condition, message, code, params) {
          if (!!condition) {
            return;
          }
          this.throwError(message, code, params);
        };
        Logger2.prototype.assertArgument = function(condition, message, name2, value) {
          if (!!condition) {
            return;
          }
          this.throwArgumentError(message, name2, value);
        };
        Logger2.prototype.checkNormalize = function(message) {
          if (message == null) {
            message = "platform missing String.prototype.normalize";
          }
          if (_normalizeError) {
            this.throwError("platform missing String.prototype.normalize", Logger2.errors.UNSUPPORTED_OPERATION, {
              operation: "String.prototype.normalize",
              form: _normalizeError
            });
          }
        };
        Logger2.prototype.checkSafeUint53 = function(value, message) {
          if (typeof value !== "number") {
            return;
          }
          if (message == null) {
            message = "value not safe";
          }
          if (value < 0 || value >= 9007199254740991) {
            this.throwError(message, Logger2.errors.NUMERIC_FAULT, {
              operation: "checkSafeInteger",
              fault: "out-of-safe-range",
              value
            });
          }
          if (value % 1) {
            this.throwError(message, Logger2.errors.NUMERIC_FAULT, {
              operation: "checkSafeInteger",
              fault: "non-integer",
              value
            });
          }
        };
        Logger2.prototype.checkArgumentCount = function(count, expectedCount, message) {
          if (message) {
            message = ": " + message;
          } else {
            message = "";
          }
          if (count < expectedCount) {
            this.throwError("missing argument" + message, Logger2.errors.MISSING_ARGUMENT, {
              count,
              expectedCount
            });
          }
          if (count > expectedCount) {
            this.throwError("too many arguments" + message, Logger2.errors.UNEXPECTED_ARGUMENT, {
              count,
              expectedCount
            });
          }
        };
        Logger2.prototype.checkNew = function(target, kind) {
          if (target === Object || target == null) {
            this.throwError("missing new", Logger2.errors.MISSING_NEW, { name: kind.name });
          }
        };
        Logger2.prototype.checkAbstract = function(target, kind) {
          if (target === kind) {
            this.throwError("cannot instantiate abstract class " + JSON.stringify(kind.name) + " directly; use a sub-class", Logger2.errors.UNSUPPORTED_OPERATION, { name: target.name, operation: "new" });
          } else if (target === Object || target == null) {
            this.throwError("missing new", Logger2.errors.MISSING_NEW, { name: kind.name });
          }
        };
        Logger2.globalLogger = function() {
          if (!_globalLogger) {
            _globalLogger = new Logger2(_version_1.version);
          }
          return _globalLogger;
        };
        Logger2.setCensorship = function(censorship, permanent) {
          if (!censorship && permanent) {
            this.globalLogger().throwError("cannot permanently disable censorship", Logger2.errors.UNSUPPORTED_OPERATION, {
              operation: "setCensorship"
            });
          }
          if (_permanentCensorErrors) {
            if (!censorship) {
              return;
            }
            this.globalLogger().throwError("error censorship permanent", Logger2.errors.UNSUPPORTED_OPERATION, {
              operation: "setCensorship"
            });
          }
          _censorErrors = !!censorship;
          _permanentCensorErrors = !!permanent;
        };
        Logger2.setLogLevel = function(logLevel) {
          var level = LogLevels[logLevel.toLowerCase()];
          if (level == null) {
            Logger2.globalLogger().warn("invalid log level - " + logLevel);
            return;
          }
          _logLevel = level;
        };
        Logger2.from = function(version) {
          return new Logger2(version);
        };
        Logger2.errors = ErrorCode;
        Logger2.levels = LogLevel;
        return Logger2;
      }()
    );
    exports2.Logger = Logger;
  }
});

// node_modules/@ethersproject/bytes/lib/_version.js
var require_version2 = __commonJS({
  "node_modules/@ethersproject/bytes/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "bytes/5.5.0";
  }
});

// node_modules/@ethersproject/bytes/lib/index.js
var require_lib2 = __commonJS({
  "node_modules/@ethersproject/bytes/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.joinSignature = exports2.splitSignature = exports2.hexZeroPad = exports2.hexStripZeros = exports2.hexValue = exports2.hexConcat = exports2.hexDataSlice = exports2.hexDataLength = exports2.hexlify = exports2.isHexString = exports2.zeroPad = exports2.stripZeros = exports2.concat = exports2.arrayify = exports2.isBytes = exports2.isBytesLike = void 0;
    var logger_1 = require_lib();
    var _version_1 = require_version2();
    var logger = new logger_1.Logger(_version_1.version);
    function isHexable(value) {
      return !!value.toHexString;
    }
    function addSlice(array) {
      if (array.slice) {
        return array;
      }
      array.slice = function() {
        var args = Array.prototype.slice.call(arguments);
        return addSlice(new Uint8Array(Array.prototype.slice.apply(array, args)));
      };
      return array;
    }
    function isBytesLike(value) {
      return isHexString(value) && !(value.length % 2) || isBytes(value);
    }
    exports2.isBytesLike = isBytesLike;
    function isInteger(value) {
      return typeof value === "number" && value == value && value % 1 === 0;
    }
    function isBytes(value) {
      if (value == null) {
        return false;
      }
      if (value.constructor === Uint8Array) {
        return true;
      }
      if (typeof value === "string") {
        return false;
      }
      if (!isInteger(value.length) || value.length < 0) {
        return false;
      }
      for (var i = 0; i < value.length; i++) {
        var v = value[i];
        if (!isInteger(v) || v < 0 || v >= 256) {
          return false;
        }
      }
      return true;
    }
    exports2.isBytes = isBytes;
    function arrayify(value, options) {
      if (!options) {
        options = {};
      }
      if (typeof value === "number") {
        logger.checkSafeUint53(value, "invalid arrayify value");
        var result = [];
        while (value) {
          result.unshift(value & 255);
          value = parseInt(String(value / 256));
        }
        if (result.length === 0) {
          result.push(0);
        }
        return addSlice(new Uint8Array(result));
      }
      if (options.allowMissingPrefix && typeof value === "string" && value.substring(0, 2) !== "0x") {
        value = "0x" + value;
      }
      if (isHexable(value)) {
        value = value.toHexString();
      }
      if (isHexString(value)) {
        var hex = value.substring(2);
        if (hex.length % 2) {
          if (options.hexPad === "left") {
            hex = "0x0" + hex.substring(2);
          } else if (options.hexPad === "right") {
            hex += "0";
          } else {
            logger.throwArgumentError("hex data is odd-length", "value", value);
          }
        }
        var result = [];
        for (var i = 0; i < hex.length; i += 2) {
          result.push(parseInt(hex.substring(i, i + 2), 16));
        }
        return addSlice(new Uint8Array(result));
      }
      if (isBytes(value)) {
        return addSlice(new Uint8Array(value));
      }
      return logger.throwArgumentError("invalid arrayify value", "value", value);
    }
    exports2.arrayify = arrayify;
    function concat(items) {
      var objects = items.map(function(item) {
        return arrayify(item);
      });
      var length = objects.reduce(function(accum, item) {
        return accum + item.length;
      }, 0);
      var result = new Uint8Array(length);
      objects.reduce(function(offset, object) {
        result.set(object, offset);
        return offset + object.length;
      }, 0);
      return addSlice(result);
    }
    exports2.concat = concat;
    function stripZeros(value) {
      var result = arrayify(value);
      if (result.length === 0) {
        return result;
      }
      var start = 0;
      while (start < result.length && result[start] === 0) {
        start++;
      }
      if (start) {
        result = result.slice(start);
      }
      return result;
    }
    exports2.stripZeros = stripZeros;
    function zeroPad(value, length) {
      value = arrayify(value);
      if (value.length > length) {
        logger.throwArgumentError("value out of range", "value", arguments[0]);
      }
      var result = new Uint8Array(length);
      result.set(value, length - value.length);
      return addSlice(result);
    }
    exports2.zeroPad = zeroPad;
    function isHexString(value, length) {
      if (typeof value !== "string" || !value.match(/^0x[0-9A-Fa-f]*$/)) {
        return false;
      }
      if (length && value.length !== 2 + 2 * length) {
        return false;
      }
      return true;
    }
    exports2.isHexString = isHexString;
    var HexCharacters = "0123456789abcdef";
    function hexlify(value, options) {
      if (!options) {
        options = {};
      }
      if (typeof value === "number") {
        logger.checkSafeUint53(value, "invalid hexlify value");
        var hex = "";
        while (value) {
          hex = HexCharacters[value & 15] + hex;
          value = Math.floor(value / 16);
        }
        if (hex.length) {
          if (hex.length % 2) {
            hex = "0" + hex;
          }
          return "0x" + hex;
        }
        return "0x00";
      }
      if (typeof value === "bigint") {
        value = value.toString(16);
        if (value.length % 2) {
          return "0x0" + value;
        }
        return "0x" + value;
      }
      if (options.allowMissingPrefix && typeof value === "string" && value.substring(0, 2) !== "0x") {
        value = "0x" + value;
      }
      if (isHexable(value)) {
        return value.toHexString();
      }
      if (isHexString(value)) {
        if (value.length % 2) {
          if (options.hexPad === "left") {
            value = "0x0" + value.substring(2);
          } else if (options.hexPad === "right") {
            value += "0";
          } else {
            logger.throwArgumentError("hex data is odd-length", "value", value);
          }
        }
        return value.toLowerCase();
      }
      if (isBytes(value)) {
        var result = "0x";
        for (var i = 0; i < value.length; i++) {
          var v = value[i];
          result += HexCharacters[(v & 240) >> 4] + HexCharacters[v & 15];
        }
        return result;
      }
      return logger.throwArgumentError("invalid hexlify value", "value", value);
    }
    exports2.hexlify = hexlify;
    function hexDataLength(data) {
      if (typeof data !== "string") {
        data = hexlify(data);
      } else if (!isHexString(data) || data.length % 2) {
        return null;
      }
      return (data.length - 2) / 2;
    }
    exports2.hexDataLength = hexDataLength;
    function hexDataSlice(data, offset, endOffset) {
      if (typeof data !== "string") {
        data = hexlify(data);
      } else if (!isHexString(data) || data.length % 2) {
        logger.throwArgumentError("invalid hexData", "value", data);
      }
      offset = 2 + 2 * offset;
      if (endOffset != null) {
        return "0x" + data.substring(offset, 2 + 2 * endOffset);
      }
      return "0x" + data.substring(offset);
    }
    exports2.hexDataSlice = hexDataSlice;
    function hexConcat(items) {
      var result = "0x";
      items.forEach(function(item) {
        result += hexlify(item).substring(2);
      });
      return result;
    }
    exports2.hexConcat = hexConcat;
    function hexValue(value) {
      var trimmed = hexStripZeros(hexlify(value, { hexPad: "left" }));
      if (trimmed === "0x") {
        return "0x0";
      }
      return trimmed;
    }
    exports2.hexValue = hexValue;
    function hexStripZeros(value) {
      if (typeof value !== "string") {
        value = hexlify(value);
      }
      if (!isHexString(value)) {
        logger.throwArgumentError("invalid hex string", "value", value);
      }
      value = value.substring(2);
      var offset = 0;
      while (offset < value.length && value[offset] === "0") {
        offset++;
      }
      return "0x" + value.substring(offset);
    }
    exports2.hexStripZeros = hexStripZeros;
    function hexZeroPad(value, length) {
      if (typeof value !== "string") {
        value = hexlify(value);
      } else if (!isHexString(value)) {
        logger.throwArgumentError("invalid hex string", "value", value);
      }
      if (value.length > 2 * length + 2) {
        logger.throwArgumentError("value out of range", "value", arguments[1]);
      }
      while (value.length < 2 * length + 2) {
        value = "0x0" + value.substring(2);
      }
      return value;
    }
    exports2.hexZeroPad = hexZeroPad;
    function splitSignature(signature) {
      var result = {
        r: "0x",
        s: "0x",
        _vs: "0x",
        recoveryParam: 0,
        v: 0
      };
      if (isBytesLike(signature)) {
        var bytes = arrayify(signature);
        if (bytes.length !== 65) {
          logger.throwArgumentError("invalid signature string; must be 65 bytes", "signature", signature);
        }
        result.r = hexlify(bytes.slice(0, 32));
        result.s = hexlify(bytes.slice(32, 64));
        result.v = bytes[64];
        if (result.v < 27) {
          if (result.v === 0 || result.v === 1) {
            result.v += 27;
          } else {
            logger.throwArgumentError("signature invalid v byte", "signature", signature);
          }
        }
        result.recoveryParam = 1 - result.v % 2;
        if (result.recoveryParam) {
          bytes[32] |= 128;
        }
        result._vs = hexlify(bytes.slice(32, 64));
      } else {
        result.r = signature.r;
        result.s = signature.s;
        result.v = signature.v;
        result.recoveryParam = signature.recoveryParam;
        result._vs = signature._vs;
        if (result._vs != null) {
          var vs_1 = zeroPad(arrayify(result._vs), 32);
          result._vs = hexlify(vs_1);
          var recoveryParam = vs_1[0] >= 128 ? 1 : 0;
          if (result.recoveryParam == null) {
            result.recoveryParam = recoveryParam;
          } else if (result.recoveryParam !== recoveryParam) {
            logger.throwArgumentError("signature recoveryParam mismatch _vs", "signature", signature);
          }
          vs_1[0] &= 127;
          var s = hexlify(vs_1);
          if (result.s == null) {
            result.s = s;
          } else if (result.s !== s) {
            logger.throwArgumentError("signature v mismatch _vs", "signature", signature);
          }
        }
        if (result.recoveryParam == null) {
          if (result.v == null) {
            logger.throwArgumentError("signature missing v and recoveryParam", "signature", signature);
          } else if (result.v === 0 || result.v === 1) {
            result.recoveryParam = result.v;
          } else {
            result.recoveryParam = 1 - result.v % 2;
          }
        } else {
          if (result.v == null) {
            result.v = 27 + result.recoveryParam;
          } else {
            var recId = result.v === 0 || result.v === 1 ? result.v : 1 - result.v % 2;
            if (result.recoveryParam !== recId) {
              logger.throwArgumentError("signature recoveryParam mismatch v", "signature", signature);
            }
          }
        }
        if (result.r == null || !isHexString(result.r)) {
          logger.throwArgumentError("signature missing or invalid r", "signature", signature);
        } else {
          result.r = hexZeroPad(result.r, 32);
        }
        if (result.s == null || !isHexString(result.s)) {
          logger.throwArgumentError("signature missing or invalid s", "signature", signature);
        } else {
          result.s = hexZeroPad(result.s, 32);
        }
        var vs = arrayify(result.s);
        if (vs[0] >= 128) {
          logger.throwArgumentError("signature s out of range", "signature", signature);
        }
        if (result.recoveryParam) {
          vs[0] |= 128;
        }
        var _vs = hexlify(vs);
        if (result._vs) {
          if (!isHexString(result._vs)) {
            logger.throwArgumentError("signature invalid _vs", "signature", signature);
          }
          result._vs = hexZeroPad(result._vs, 32);
        }
        if (result._vs == null) {
          result._vs = _vs;
        } else if (result._vs !== _vs) {
          logger.throwArgumentError("signature _vs mismatch v and s", "signature", signature);
        }
      }
      return result;
    }
    exports2.splitSignature = splitSignature;
    function joinSignature(signature) {
      signature = splitSignature(signature);
      return hexlify(concat([
        signature.r,
        signature.s,
        signature.recoveryParam ? "0x1c" : "0x1b"
      ]));
    }
    exports2.joinSignature = joinSignature;
  }
});

// node_modules/@ethersproject/bignumber/lib/_version.js
var require_version3 = __commonJS({
  "node_modules/@ethersproject/bignumber/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "bignumber/5.5.0";
  }
});

// node_modules/@ethersproject/bignumber/lib/bignumber.js
var require_bignumber = __commonJS({
  "node_modules/@ethersproject/bignumber/lib/bignumber.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2._base16To36 = exports2._base36To16 = exports2.BigNumber = exports2.isBigNumberish = void 0;
    var bn_js_1 = __importDefault(require_bn());
    var BN = bn_js_1.default.BN;
    var bytes_1 = require_lib2();
    var logger_1 = require_lib();
    var _version_1 = require_version3();
    var logger = new logger_1.Logger(_version_1.version);
    var _constructorGuard = {};
    var MAX_SAFE = 9007199254740991;
    function isBigNumberish(value) {
      return value != null && (BigNumber.isBigNumber(value) || typeof value === "number" && value % 1 === 0 || typeof value === "string" && !!value.match(/^-?[0-9]+$/) || (0, bytes_1.isHexString)(value) || typeof value === "bigint" || (0, bytes_1.isBytes)(value));
    }
    exports2.isBigNumberish = isBigNumberish;
    var _warnedToStringRadix = false;
    var BigNumber = (
      /** @class */
      function() {
        function BigNumber2(constructorGuard, hex) {
          var _newTarget = this.constructor;
          logger.checkNew(_newTarget, BigNumber2);
          if (constructorGuard !== _constructorGuard) {
            logger.throwError("cannot call constructor directly; use BigNumber.from", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
              operation: "new (BigNumber)"
            });
          }
          this._hex = hex;
          this._isBigNumber = true;
          Object.freeze(this);
        }
        BigNumber2.prototype.fromTwos = function(value) {
          return toBigNumber(toBN(this).fromTwos(value));
        };
        BigNumber2.prototype.toTwos = function(value) {
          return toBigNumber(toBN(this).toTwos(value));
        };
        BigNumber2.prototype.abs = function() {
          if (this._hex[0] === "-") {
            return BigNumber2.from(this._hex.substring(1));
          }
          return this;
        };
        BigNumber2.prototype.add = function(other) {
          return toBigNumber(toBN(this).add(toBN(other)));
        };
        BigNumber2.prototype.sub = function(other) {
          return toBigNumber(toBN(this).sub(toBN(other)));
        };
        BigNumber2.prototype.div = function(other) {
          var o = BigNumber2.from(other);
          if (o.isZero()) {
            throwFault("division by zero", "div");
          }
          return toBigNumber(toBN(this).div(toBN(other)));
        };
        BigNumber2.prototype.mul = function(other) {
          return toBigNumber(toBN(this).mul(toBN(other)));
        };
        BigNumber2.prototype.mod = function(other) {
          var value = toBN(other);
          if (value.isNeg()) {
            throwFault("cannot modulo negative values", "mod");
          }
          return toBigNumber(toBN(this).umod(value));
        };
        BigNumber2.prototype.pow = function(other) {
          var value = toBN(other);
          if (value.isNeg()) {
            throwFault("cannot raise to negative values", "pow");
          }
          return toBigNumber(toBN(this).pow(value));
        };
        BigNumber2.prototype.and = function(other) {
          var value = toBN(other);
          if (this.isNegative() || value.isNeg()) {
            throwFault("cannot 'and' negative values", "and");
          }
          return toBigNumber(toBN(this).and(value));
        };
        BigNumber2.prototype.or = function(other) {
          var value = toBN(other);
          if (this.isNegative() || value.isNeg()) {
            throwFault("cannot 'or' negative values", "or");
          }
          return toBigNumber(toBN(this).or(value));
        };
        BigNumber2.prototype.xor = function(other) {
          var value = toBN(other);
          if (this.isNegative() || value.isNeg()) {
            throwFault("cannot 'xor' negative values", "xor");
          }
          return toBigNumber(toBN(this).xor(value));
        };
        BigNumber2.prototype.mask = function(value) {
          if (this.isNegative() || value < 0) {
            throwFault("cannot mask negative values", "mask");
          }
          return toBigNumber(toBN(this).maskn(value));
        };
        BigNumber2.prototype.shl = function(value) {
          if (this.isNegative() || value < 0) {
            throwFault("cannot shift negative values", "shl");
          }
          return toBigNumber(toBN(this).shln(value));
        };
        BigNumber2.prototype.shr = function(value) {
          if (this.isNegative() || value < 0) {
            throwFault("cannot shift negative values", "shr");
          }
          return toBigNumber(toBN(this).shrn(value));
        };
        BigNumber2.prototype.eq = function(other) {
          return toBN(this).eq(toBN(other));
        };
        BigNumber2.prototype.lt = function(other) {
          return toBN(this).lt(toBN(other));
        };
        BigNumber2.prototype.lte = function(other) {
          return toBN(this).lte(toBN(other));
        };
        BigNumber2.prototype.gt = function(other) {
          return toBN(this).gt(toBN(other));
        };
        BigNumber2.prototype.gte = function(other) {
          return toBN(this).gte(toBN(other));
        };
        BigNumber2.prototype.isNegative = function() {
          return this._hex[0] === "-";
        };
        BigNumber2.prototype.isZero = function() {
          return toBN(this).isZero();
        };
        BigNumber2.prototype.toNumber = function() {
          try {
            return toBN(this).toNumber();
          } catch (error) {
            throwFault("overflow", "toNumber", this.toString());
          }
          return null;
        };
        BigNumber2.prototype.toBigInt = function() {
          try {
            return BigInt(this.toString());
          } catch (e) {
          }
          return logger.throwError("this platform does not support BigInt", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
            value: this.toString()
          });
        };
        BigNumber2.prototype.toString = function() {
          if (arguments.length > 0) {
            if (arguments[0] === 10) {
              if (!_warnedToStringRadix) {
                _warnedToStringRadix = true;
                logger.warn("BigNumber.toString does not accept any parameters; base-10 is assumed");
              }
            } else if (arguments[0] === 16) {
              logger.throwError("BigNumber.toString does not accept any parameters; use bigNumber.toHexString()", logger_1.Logger.errors.UNEXPECTED_ARGUMENT, {});
            } else {
              logger.throwError("BigNumber.toString does not accept parameters", logger_1.Logger.errors.UNEXPECTED_ARGUMENT, {});
            }
          }
          return toBN(this).toString(10);
        };
        BigNumber2.prototype.toHexString = function() {
          return this._hex;
        };
        BigNumber2.prototype.toJSON = function(key) {
          return { type: "BigNumber", hex: this.toHexString() };
        };
        BigNumber2.from = function(value) {
          if (value instanceof BigNumber2) {
            return value;
          }
          if (typeof value === "string") {
            if (value.match(/^-?0x[0-9a-f]+$/i)) {
              return new BigNumber2(_constructorGuard, toHex(value));
            }
            if (value.match(/^-?[0-9]+$/)) {
              return new BigNumber2(_constructorGuard, toHex(new BN(value)));
            }
            return logger.throwArgumentError("invalid BigNumber string", "value", value);
          }
          if (typeof value === "number") {
            if (value % 1) {
              throwFault("underflow", "BigNumber.from", value);
            }
            if (value >= MAX_SAFE || value <= -MAX_SAFE) {
              throwFault("overflow", "BigNumber.from", value);
            }
            return BigNumber2.from(String(value));
          }
          var anyValue = value;
          if (typeof anyValue === "bigint") {
            return BigNumber2.from(anyValue.toString());
          }
          if ((0, bytes_1.isBytes)(anyValue)) {
            return BigNumber2.from((0, bytes_1.hexlify)(anyValue));
          }
          if (anyValue) {
            if (anyValue.toHexString) {
              var hex = anyValue.toHexString();
              if (typeof hex === "string") {
                return BigNumber2.from(hex);
              }
            } else {
              var hex = anyValue._hex;
              if (hex == null && anyValue.type === "BigNumber") {
                hex = anyValue.hex;
              }
              if (typeof hex === "string") {
                if ((0, bytes_1.isHexString)(hex) || hex[0] === "-" && (0, bytes_1.isHexString)(hex.substring(1))) {
                  return BigNumber2.from(hex);
                }
              }
            }
          }
          return logger.throwArgumentError("invalid BigNumber value", "value", value);
        };
        BigNumber2.isBigNumber = function(value) {
          return !!(value && value._isBigNumber);
        };
        return BigNumber2;
      }()
    );
    exports2.BigNumber = BigNumber;
    function toHex(value) {
      if (typeof value !== "string") {
        return toHex(value.toString(16));
      }
      if (value[0] === "-") {
        value = value.substring(1);
        if (value[0] === "-") {
          logger.throwArgumentError("invalid hex", "value", value);
        }
        value = toHex(value);
        if (value === "0x00") {
          return value;
        }
        return "-" + value;
      }
      if (value.substring(0, 2) !== "0x") {
        value = "0x" + value;
      }
      if (value === "0x") {
        return "0x00";
      }
      if (value.length % 2) {
        value = "0x0" + value.substring(2);
      }
      while (value.length > 4 && value.substring(0, 4) === "0x00") {
        value = "0x" + value.substring(4);
      }
      return value;
    }
    function toBigNumber(value) {
      return BigNumber.from(toHex(value));
    }
    function toBN(value) {
      var hex = BigNumber.from(value).toHexString();
      if (hex[0] === "-") {
        return new BN("-" + hex.substring(3), 16);
      }
      return new BN(hex.substring(2), 16);
    }
    function throwFault(fault, operation, value) {
      var params = { fault, operation };
      if (value != null) {
        params.value = value;
      }
      return logger.throwError(fault, logger_1.Logger.errors.NUMERIC_FAULT, params);
    }
    function _base36To16(value) {
      return new BN(value, 36).toString(16);
    }
    exports2._base36To16 = _base36To16;
    function _base16To36(value) {
      return new BN(value, 16).toString(36);
    }
    exports2._base16To36 = _base16To36;
  }
});

// node_modules/@ethersproject/bignumber/lib/fixednumber.js
var require_fixednumber = __commonJS({
  "node_modules/@ethersproject/bignumber/lib/fixednumber.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.FixedNumber = exports2.FixedFormat = exports2.parseFixed = exports2.formatFixed = void 0;
    var bytes_1 = require_lib2();
    var logger_1 = require_lib();
    var _version_1 = require_version3();
    var logger = new logger_1.Logger(_version_1.version);
    var bignumber_1 = require_bignumber();
    var _constructorGuard = {};
    var Zero = bignumber_1.BigNumber.from(0);
    var NegativeOne = bignumber_1.BigNumber.from(-1);
    function throwFault(message, fault, operation, value) {
      var params = { fault, operation };
      if (value !== void 0) {
        params.value = value;
      }
      return logger.throwError(message, logger_1.Logger.errors.NUMERIC_FAULT, params);
    }
    var zeros = "0";
    while (zeros.length < 256) {
      zeros += zeros;
    }
    function getMultiplier(decimals) {
      if (typeof decimals !== "number") {
        try {
          decimals = bignumber_1.BigNumber.from(decimals).toNumber();
        } catch (e) {
        }
      }
      if (typeof decimals === "number" && decimals >= 0 && decimals <= 256 && !(decimals % 1)) {
        return "1" + zeros.substring(0, decimals);
      }
      return logger.throwArgumentError("invalid decimal size", "decimals", decimals);
    }
    function formatFixed(value, decimals) {
      if (decimals == null) {
        decimals = 0;
      }
      var multiplier = getMultiplier(decimals);
      value = bignumber_1.BigNumber.from(value);
      var negative = value.lt(Zero);
      if (negative) {
        value = value.mul(NegativeOne);
      }
      var fraction = value.mod(multiplier).toString();
      while (fraction.length < multiplier.length - 1) {
        fraction = "0" + fraction;
      }
      fraction = fraction.match(/^([0-9]*[1-9]|0)(0*)/)[1];
      var whole = value.div(multiplier).toString();
      if (multiplier.length === 1) {
        value = whole;
      } else {
        value = whole + "." + fraction;
      }
      if (negative) {
        value = "-" + value;
      }
      return value;
    }
    exports2.formatFixed = formatFixed;
    function parseFixed(value, decimals) {
      if (decimals == null) {
        decimals = 0;
      }
      var multiplier = getMultiplier(decimals);
      if (typeof value !== "string" || !value.match(/^-?[0-9.]+$/)) {
        logger.throwArgumentError("invalid decimal value", "value", value);
      }
      var negative = value.substring(0, 1) === "-";
      if (negative) {
        value = value.substring(1);
      }
      if (value === ".") {
        logger.throwArgumentError("missing value", "value", value);
      }
      var comps = value.split(".");
      if (comps.length > 2) {
        logger.throwArgumentError("too many decimal points", "value", value);
      }
      var whole = comps[0], fraction = comps[1];
      if (!whole) {
        whole = "0";
      }
      if (!fraction) {
        fraction = "0";
      }
      while (fraction[fraction.length - 1] === "0") {
        fraction = fraction.substring(0, fraction.length - 1);
      }
      if (fraction.length > multiplier.length - 1) {
        throwFault("fractional component exceeds decimals", "underflow", "parseFixed");
      }
      if (fraction === "") {
        fraction = "0";
      }
      while (fraction.length < multiplier.length - 1) {
        fraction += "0";
      }
      var wholeValue = bignumber_1.BigNumber.from(whole);
      var fractionValue = bignumber_1.BigNumber.from(fraction);
      var wei = wholeValue.mul(multiplier).add(fractionValue);
      if (negative) {
        wei = wei.mul(NegativeOne);
      }
      return wei;
    }
    exports2.parseFixed = parseFixed;
    var FixedFormat = (
      /** @class */
      function() {
        function FixedFormat2(constructorGuard, signed, width, decimals) {
          if (constructorGuard !== _constructorGuard) {
            logger.throwError("cannot use FixedFormat constructor; use FixedFormat.from", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
              operation: "new FixedFormat"
            });
          }
          this.signed = signed;
          this.width = width;
          this.decimals = decimals;
          this.name = (signed ? "" : "u") + "fixed" + String(width) + "x" + String(decimals);
          this._multiplier = getMultiplier(decimals);
          Object.freeze(this);
        }
        FixedFormat2.from = function(value) {
          if (value instanceof FixedFormat2) {
            return value;
          }
          if (typeof value === "number") {
            value = "fixed128x" + value;
          }
          var signed = true;
          var width = 128;
          var decimals = 18;
          if (typeof value === "string") {
            if (value === "fixed") {
            } else if (value === "ufixed") {
              signed = false;
            } else {
              var match = value.match(/^(u?)fixed([0-9]+)x([0-9]+)$/);
              if (!match) {
                logger.throwArgumentError("invalid fixed format", "format", value);
              }
              signed = match[1] !== "u";
              width = parseInt(match[2]);
              decimals = parseInt(match[3]);
            }
          } else if (value) {
            var check = function(key, type, defaultValue) {
              if (value[key] == null) {
                return defaultValue;
              }
              if (typeof value[key] !== type) {
                logger.throwArgumentError("invalid fixed format (" + key + " not " + type + ")", "format." + key, value[key]);
              }
              return value[key];
            };
            signed = check("signed", "boolean", signed);
            width = check("width", "number", width);
            decimals = check("decimals", "number", decimals);
          }
          if (width % 8) {
            logger.throwArgumentError("invalid fixed format width (not byte aligned)", "format.width", width);
          }
          if (decimals > 80) {
            logger.throwArgumentError("invalid fixed format (decimals too large)", "format.decimals", decimals);
          }
          return new FixedFormat2(_constructorGuard, signed, width, decimals);
        };
        return FixedFormat2;
      }()
    );
    exports2.FixedFormat = FixedFormat;
    var FixedNumber = (
      /** @class */
      function() {
        function FixedNumber2(constructorGuard, hex, value, format) {
          var _newTarget = this.constructor;
          logger.checkNew(_newTarget, FixedNumber2);
          if (constructorGuard !== _constructorGuard) {
            logger.throwError("cannot use FixedNumber constructor; use FixedNumber.from", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
              operation: "new FixedFormat"
            });
          }
          this.format = format;
          this._hex = hex;
          this._value = value;
          this._isFixedNumber = true;
          Object.freeze(this);
        }
        FixedNumber2.prototype._checkFormat = function(other) {
          if (this.format.name !== other.format.name) {
            logger.throwArgumentError("incompatible format; use fixedNumber.toFormat", "other", other);
          }
        };
        FixedNumber2.prototype.addUnsafe = function(other) {
          this._checkFormat(other);
          var a = parseFixed(this._value, this.format.decimals);
          var b = parseFixed(other._value, other.format.decimals);
          return FixedNumber2.fromValue(a.add(b), this.format.decimals, this.format);
        };
        FixedNumber2.prototype.subUnsafe = function(other) {
          this._checkFormat(other);
          var a = parseFixed(this._value, this.format.decimals);
          var b = parseFixed(other._value, other.format.decimals);
          return FixedNumber2.fromValue(a.sub(b), this.format.decimals, this.format);
        };
        FixedNumber2.prototype.mulUnsafe = function(other) {
          this._checkFormat(other);
          var a = parseFixed(this._value, this.format.decimals);
          var b = parseFixed(other._value, other.format.decimals);
          return FixedNumber2.fromValue(a.mul(b).div(this.format._multiplier), this.format.decimals, this.format);
        };
        FixedNumber2.prototype.divUnsafe = function(other) {
          this._checkFormat(other);
          var a = parseFixed(this._value, this.format.decimals);
          var b = parseFixed(other._value, other.format.decimals);
          return FixedNumber2.fromValue(a.mul(this.format._multiplier).div(b), this.format.decimals, this.format);
        };
        FixedNumber2.prototype.floor = function() {
          var comps = this.toString().split(".");
          if (comps.length === 1) {
            comps.push("0");
          }
          var result = FixedNumber2.from(comps[0], this.format);
          var hasFraction = !comps[1].match(/^(0*)$/);
          if (this.isNegative() && hasFraction) {
            result = result.subUnsafe(ONE.toFormat(result.format));
          }
          return result;
        };
        FixedNumber2.prototype.ceiling = function() {
          var comps = this.toString().split(".");
          if (comps.length === 1) {
            comps.push("0");
          }
          var result = FixedNumber2.from(comps[0], this.format);
          var hasFraction = !comps[1].match(/^(0*)$/);
          if (!this.isNegative() && hasFraction) {
            result = result.addUnsafe(ONE.toFormat(result.format));
          }
          return result;
        };
        FixedNumber2.prototype.round = function(decimals) {
          if (decimals == null) {
            decimals = 0;
          }
          var comps = this.toString().split(".");
          if (comps.length === 1) {
            comps.push("0");
          }
          if (decimals < 0 || decimals > 80 || decimals % 1) {
            logger.throwArgumentError("invalid decimal count", "decimals", decimals);
          }
          if (comps[1].length <= decimals) {
            return this;
          }
          var factor = FixedNumber2.from("1" + zeros.substring(0, decimals), this.format);
          var bump = BUMP.toFormat(this.format);
          return this.mulUnsafe(factor).addUnsafe(bump).floor().divUnsafe(factor);
        };
        FixedNumber2.prototype.isZero = function() {
          return this._value === "0.0" || this._value === "0";
        };
        FixedNumber2.prototype.isNegative = function() {
          return this._value[0] === "-";
        };
        FixedNumber2.prototype.toString = function() {
          return this._value;
        };
        FixedNumber2.prototype.toHexString = function(width) {
          if (width == null) {
            return this._hex;
          }
          if (width % 8) {
            logger.throwArgumentError("invalid byte width", "width", width);
          }
          var hex = bignumber_1.BigNumber.from(this._hex).fromTwos(this.format.width).toTwos(width).toHexString();
          return (0, bytes_1.hexZeroPad)(hex, width / 8);
        };
        FixedNumber2.prototype.toUnsafeFloat = function() {
          return parseFloat(this.toString());
        };
        FixedNumber2.prototype.toFormat = function(format) {
          return FixedNumber2.fromString(this._value, format);
        };
        FixedNumber2.fromValue = function(value, decimals, format) {
          if (format == null && decimals != null && !(0, bignumber_1.isBigNumberish)(decimals)) {
            format = decimals;
            decimals = null;
          }
          if (decimals == null) {
            decimals = 0;
          }
          if (format == null) {
            format = "fixed";
          }
          return FixedNumber2.fromString(formatFixed(value, decimals), FixedFormat.from(format));
        };
        FixedNumber2.fromString = function(value, format) {
          if (format == null) {
            format = "fixed";
          }
          var fixedFormat = FixedFormat.from(format);
          var numeric = parseFixed(value, fixedFormat.decimals);
          if (!fixedFormat.signed && numeric.lt(Zero)) {
            throwFault("unsigned value cannot be negative", "overflow", "value", value);
          }
          var hex = null;
          if (fixedFormat.signed) {
            hex = numeric.toTwos(fixedFormat.width).toHexString();
          } else {
            hex = numeric.toHexString();
            hex = (0, bytes_1.hexZeroPad)(hex, fixedFormat.width / 8);
          }
          var decimal = formatFixed(numeric, fixedFormat.decimals);
          return new FixedNumber2(_constructorGuard, hex, decimal, fixedFormat);
        };
        FixedNumber2.fromBytes = function(value, format) {
          if (format == null) {
            format = "fixed";
          }
          var fixedFormat = FixedFormat.from(format);
          if ((0, bytes_1.arrayify)(value).length > fixedFormat.width / 8) {
            throw new Error("overflow");
          }
          var numeric = bignumber_1.BigNumber.from(value);
          if (fixedFormat.signed) {
            numeric = numeric.fromTwos(fixedFormat.width);
          }
          var hex = numeric.toTwos((fixedFormat.signed ? 0 : 1) + fixedFormat.width).toHexString();
          var decimal = formatFixed(numeric, fixedFormat.decimals);
          return new FixedNumber2(_constructorGuard, hex, decimal, fixedFormat);
        };
        FixedNumber2.from = function(value, format) {
          if (typeof value === "string") {
            return FixedNumber2.fromString(value, format);
          }
          if ((0, bytes_1.isBytes)(value)) {
            return FixedNumber2.fromBytes(value, format);
          }
          try {
            return FixedNumber2.fromValue(value, 0, format);
          } catch (error) {
            if (error.code !== logger_1.Logger.errors.INVALID_ARGUMENT) {
              throw error;
            }
          }
          return logger.throwArgumentError("invalid FixedNumber value", "value", value);
        };
        FixedNumber2.isFixedNumber = function(value) {
          return !!(value && value._isFixedNumber);
        };
        return FixedNumber2;
      }()
    );
    exports2.FixedNumber = FixedNumber;
    var ONE = FixedNumber.from(1);
    var BUMP = FixedNumber.from("0.5");
  }
});

// node_modules/@ethersproject/bignumber/lib/index.js
var require_lib3 = __commonJS({
  "node_modules/@ethersproject/bignumber/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2._base36To16 = exports2._base16To36 = exports2.parseFixed = exports2.FixedNumber = exports2.FixedFormat = exports2.formatFixed = exports2.BigNumber = void 0;
    var bignumber_1 = require_bignumber();
    Object.defineProperty(exports2, "BigNumber", { enumerable: true, get: function() {
      return bignumber_1.BigNumber;
    } });
    var fixednumber_1 = require_fixednumber();
    Object.defineProperty(exports2, "formatFixed", { enumerable: true, get: function() {
      return fixednumber_1.formatFixed;
    } });
    Object.defineProperty(exports2, "FixedFormat", { enumerable: true, get: function() {
      return fixednumber_1.FixedFormat;
    } });
    Object.defineProperty(exports2, "FixedNumber", { enumerable: true, get: function() {
      return fixednumber_1.FixedNumber;
    } });
    Object.defineProperty(exports2, "parseFixed", { enumerable: true, get: function() {
      return fixednumber_1.parseFixed;
    } });
    var bignumber_2 = require_bignumber();
    Object.defineProperty(exports2, "_base16To36", { enumerable: true, get: function() {
      return bignumber_2._base16To36;
    } });
    Object.defineProperty(exports2, "_base36To16", { enumerable: true, get: function() {
      return bignumber_2._base36To16;
    } });
  }
});

// node_modules/@ethersproject/properties/lib/_version.js
var require_version4 = __commonJS({
  "node_modules/@ethersproject/properties/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "properties/5.5.0";
  }
});

// node_modules/@ethersproject/properties/lib/index.js
var require_lib4 = __commonJS({
  "node_modules/@ethersproject/properties/lib/index.js"(exports2) {
    "use strict";
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator = exports2 && exports2.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1) throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return { value: op[1], done: false };
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2]) _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
        if (op[0] & 5) throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
      }
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Description = exports2.deepCopy = exports2.shallowCopy = exports2.checkProperties = exports2.resolveProperties = exports2.getStatic = exports2.defineReadOnly = void 0;
    var logger_1 = require_lib();
    var _version_1 = require_version4();
    var logger = new logger_1.Logger(_version_1.version);
    function defineReadOnly(object, name2, value) {
      Object.defineProperty(object, name2, {
        enumerable: true,
        value,
        writable: false
      });
    }
    exports2.defineReadOnly = defineReadOnly;
    function getStatic(ctor, key) {
      for (var i = 0; i < 32; i++) {
        if (ctor[key]) {
          return ctor[key];
        }
        if (!ctor.prototype || typeof ctor.prototype !== "object") {
          break;
        }
        ctor = Object.getPrototypeOf(ctor.prototype).constructor;
      }
      return null;
    }
    exports2.getStatic = getStatic;
    function resolveProperties(object) {
      return __awaiter(this, void 0, void 0, function() {
        var promises, results;
        return __generator(this, function(_a) {
          switch (_a.label) {
            case 0:
              promises = Object.keys(object).map(function(key) {
                var value = object[key];
                return Promise.resolve(value).then(function(v) {
                  return { key, value: v };
                });
              });
              return [4, Promise.all(promises)];
            case 1:
              results = _a.sent();
              return [2, results.reduce(function(accum, result) {
                accum[result.key] = result.value;
                return accum;
              }, {})];
          }
        });
      });
    }
    exports2.resolveProperties = resolveProperties;
    function checkProperties(object, properties) {
      if (!object || typeof object !== "object") {
        logger.throwArgumentError("invalid object", "object", object);
      }
      Object.keys(object).forEach(function(key) {
        if (!properties[key]) {
          logger.throwArgumentError("invalid object key - " + key, "transaction:" + key, object);
        }
      });
    }
    exports2.checkProperties = checkProperties;
    function shallowCopy(object) {
      var result = {};
      for (var key in object) {
        result[key] = object[key];
      }
      return result;
    }
    exports2.shallowCopy = shallowCopy;
    var opaque = { bigint: true, boolean: true, "function": true, number: true, string: true };
    function _isFrozen(object) {
      if (object === void 0 || object === null || opaque[typeof object]) {
        return true;
      }
      if (Array.isArray(object) || typeof object === "object") {
        if (!Object.isFrozen(object)) {
          return false;
        }
        var keys = Object.keys(object);
        for (var i = 0; i < keys.length; i++) {
          var value = null;
          try {
            value = object[keys[i]];
          } catch (error) {
            continue;
          }
          if (!_isFrozen(value)) {
            return false;
          }
        }
        return true;
      }
      return logger.throwArgumentError("Cannot deepCopy " + typeof object, "object", object);
    }
    function _deepCopy(object) {
      if (_isFrozen(object)) {
        return object;
      }
      if (Array.isArray(object)) {
        return Object.freeze(object.map(function(item) {
          return deepCopy(item);
        }));
      }
      if (typeof object === "object") {
        var result = {};
        for (var key in object) {
          var value = object[key];
          if (value === void 0) {
            continue;
          }
          defineReadOnly(result, key, deepCopy(value));
        }
        return result;
      }
      return logger.throwArgumentError("Cannot deepCopy " + typeof object, "object", object);
    }
    function deepCopy(object) {
      return _deepCopy(object);
    }
    exports2.deepCopy = deepCopy;
    var Description = (
      /** @class */
      /* @__PURE__ */ function() {
        function Description2(info) {
          for (var key in info) {
            this[key] = deepCopy(info[key]);
          }
        }
        return Description2;
      }()
    );
    exports2.Description = Description;
  }
});

// node_modules/@ethersproject/abi/lib/_version.js
var require_version5 = __commonJS({
  "node_modules/@ethersproject/abi/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "abi/5.5.0";
  }
});

// node_modules/@ethersproject/abi/lib/fragments.js
var require_fragments = __commonJS({
  "node_modules/@ethersproject/abi/lib/fragments.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ErrorFragment = exports2.FunctionFragment = exports2.ConstructorFragment = exports2.EventFragment = exports2.Fragment = exports2.ParamType = exports2.FormatTypes = void 0;
    var bignumber_1 = require_lib3();
    var properties_1 = require_lib4();
    var logger_1 = require_lib();
    var _version_1 = require_version5();
    var logger = new logger_1.Logger(_version_1.version);
    var _constructorGuard = {};
    var ModifiersBytes = { calldata: true, memory: true, storage: true };
    var ModifiersNest = { calldata: true, memory: true };
    function checkModifier(type, name2) {
      if (type === "bytes" || type === "string") {
        if (ModifiersBytes[name2]) {
          return true;
        }
      } else if (type === "address") {
        if (name2 === "payable") {
          return true;
        }
      } else if (type.indexOf("[") >= 0 || type === "tuple") {
        if (ModifiersNest[name2]) {
          return true;
        }
      }
      if (ModifiersBytes[name2] || name2 === "payable") {
        logger.throwArgumentError("invalid modifier", "name", name2);
      }
      return false;
    }
    function parseParamType(param, allowIndexed) {
      var originalParam = param;
      function throwError(i2) {
        logger.throwArgumentError("unexpected character at position " + i2, "param", param);
      }
      param = param.replace(/\s/g, " ");
      function newNode(parent2) {
        var node2 = { type: "", name: "", parent: parent2, state: { allowType: true } };
        if (allowIndexed) {
          node2.indexed = false;
        }
        return node2;
      }
      var parent = { type: "", name: "", state: { allowType: true } };
      var node = parent;
      for (var i = 0; i < param.length; i++) {
        var c = param[i];
        switch (c) {
          case "(":
            if (node.state.allowType && node.type === "") {
              node.type = "tuple";
            } else if (!node.state.allowParams) {
              throwError(i);
            }
            node.state.allowType = false;
            node.type = verifyType(node.type);
            node.components = [newNode(node)];
            node = node.components[0];
            break;
          case ")":
            delete node.state;
            if (node.name === "indexed") {
              if (!allowIndexed) {
                throwError(i);
              }
              node.indexed = true;
              node.name = "";
            }
            if (checkModifier(node.type, node.name)) {
              node.name = "";
            }
            node.type = verifyType(node.type);
            var child = node;
            node = node.parent;
            if (!node) {
              throwError(i);
            }
            delete child.parent;
            node.state.allowParams = false;
            node.state.allowName = true;
            node.state.allowArray = true;
            break;
          case ",":
            delete node.state;
            if (node.name === "indexed") {
              if (!allowIndexed) {
                throwError(i);
              }
              node.indexed = true;
              node.name = "";
            }
            if (checkModifier(node.type, node.name)) {
              node.name = "";
            }
            node.type = verifyType(node.type);
            var sibling = newNode(node.parent);
            node.parent.components.push(sibling);
            delete node.parent;
            node = sibling;
            break;
          case " ":
            if (node.state.allowType) {
              if (node.type !== "") {
                node.type = verifyType(node.type);
                delete node.state.allowType;
                node.state.allowName = true;
                node.state.allowParams = true;
              }
            }
            if (node.state.allowName) {
              if (node.name !== "") {
                if (node.name === "indexed") {
                  if (!allowIndexed) {
                    throwError(i);
                  }
                  if (node.indexed) {
                    throwError(i);
                  }
                  node.indexed = true;
                  node.name = "";
                } else if (checkModifier(node.type, node.name)) {
                  node.name = "";
                } else {
                  node.state.allowName = false;
                }
              }
            }
            break;
          case "[":
            if (!node.state.allowArray) {
              throwError(i);
            }
            node.type += c;
            node.state.allowArray = false;
            node.state.allowName = false;
            node.state.readArray = true;
            break;
          case "]":
            if (!node.state.readArray) {
              throwError(i);
            }
            node.type += c;
            node.state.readArray = false;
            node.state.allowArray = true;
            node.state.allowName = true;
            break;
          default:
            if (node.state.allowType) {
              node.type += c;
              node.state.allowParams = true;
              node.state.allowArray = true;
            } else if (node.state.allowName) {
              node.name += c;
              delete node.state.allowArray;
            } else if (node.state.readArray) {
              node.type += c;
            } else {
              throwError(i);
            }
        }
      }
      if (node.parent) {
        logger.throwArgumentError("unexpected eof", "param", param);
      }
      delete parent.state;
      if (node.name === "indexed") {
        if (!allowIndexed) {
          throwError(originalParam.length - 7);
        }
        if (node.indexed) {
          throwError(originalParam.length - 7);
        }
        node.indexed = true;
        node.name = "";
      } else if (checkModifier(node.type, node.name)) {
        node.name = "";
      }
      parent.type = verifyType(parent.type);
      return parent;
    }
    function populate(object, params) {
      for (var key in params) {
        (0, properties_1.defineReadOnly)(object, key, params[key]);
      }
    }
    exports2.FormatTypes = Object.freeze({
      // Bare formatting, as is needed for computing a sighash of an event or function
      sighash: "sighash",
      // Human-Readable with Minimal spacing and without names (compact human-readable)
      minimal: "minimal",
      // Human-Readable with nice spacing, including all names
      full: "full",
      // JSON-format a la Solidity
      json: "json"
    });
    var paramTypeArray = new RegExp(/^(.*)\[([0-9]*)\]$/);
    var ParamType = (
      /** @class */
      function() {
        function ParamType2(constructorGuard, params) {
          if (constructorGuard !== _constructorGuard) {
            logger.throwError("use fromString", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
              operation: "new ParamType()"
            });
          }
          populate(this, params);
          var match = this.type.match(paramTypeArray);
          if (match) {
            populate(this, {
              arrayLength: parseInt(match[2] || "-1"),
              arrayChildren: ParamType2.fromObject({
                type: match[1],
                components: this.components
              }),
              baseType: "array"
            });
          } else {
            populate(this, {
              arrayLength: null,
              arrayChildren: null,
              baseType: this.components != null ? "tuple" : this.type
            });
          }
          this._isParamType = true;
          Object.freeze(this);
        }
        ParamType2.prototype.format = function(format) {
          if (!format) {
            format = exports2.FormatTypes.sighash;
          }
          if (!exports2.FormatTypes[format]) {
            logger.throwArgumentError("invalid format type", "format", format);
          }
          if (format === exports2.FormatTypes.json) {
            var result_1 = {
              type: this.baseType === "tuple" ? "tuple" : this.type,
              name: this.name || void 0
            };
            if (typeof this.indexed === "boolean") {
              result_1.indexed = this.indexed;
            }
            if (this.components) {
              result_1.components = this.components.map(function(comp) {
                return JSON.parse(comp.format(format));
              });
            }
            return JSON.stringify(result_1);
          }
          var result = "";
          if (this.baseType === "array") {
            result += this.arrayChildren.format(format);
            result += "[" + (this.arrayLength < 0 ? "" : String(this.arrayLength)) + "]";
          } else {
            if (this.baseType === "tuple") {
              if (format !== exports2.FormatTypes.sighash) {
                result += this.type;
              }
              result += "(" + this.components.map(function(comp) {
                return comp.format(format);
              }).join(format === exports2.FormatTypes.full ? ", " : ",") + ")";
            } else {
              result += this.type;
            }
          }
          if (format !== exports2.FormatTypes.sighash) {
            if (this.indexed === true) {
              result += " indexed";
            }
            if (format === exports2.FormatTypes.full && this.name) {
              result += " " + this.name;
            }
          }
          return result;
        };
        ParamType2.from = function(value, allowIndexed) {
          if (typeof value === "string") {
            return ParamType2.fromString(value, allowIndexed);
          }
          return ParamType2.fromObject(value);
        };
        ParamType2.fromObject = function(value) {
          if (ParamType2.isParamType(value)) {
            return value;
          }
          return new ParamType2(_constructorGuard, {
            name: value.name || null,
            type: verifyType(value.type),
            indexed: value.indexed == null ? null : !!value.indexed,
            components: value.components ? value.components.map(ParamType2.fromObject) : null
          });
        };
        ParamType2.fromString = function(value, allowIndexed) {
          function ParamTypify(node) {
            return ParamType2.fromObject({
              name: node.name,
              type: node.type,
              indexed: node.indexed,
              components: node.components
            });
          }
          return ParamTypify(parseParamType(value, !!allowIndexed));
        };
        ParamType2.isParamType = function(value) {
          return !!(value != null && value._isParamType);
        };
        return ParamType2;
      }()
    );
    exports2.ParamType = ParamType;
    function parseParams(value, allowIndex) {
      return splitNesting(value).map(function(param) {
        return ParamType.fromString(param, allowIndex);
      });
    }
    var Fragment = (
      /** @class */
      function() {
        function Fragment2(constructorGuard, params) {
          if (constructorGuard !== _constructorGuard) {
            logger.throwError("use a static from method", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
              operation: "new Fragment()"
            });
          }
          populate(this, params);
          this._isFragment = true;
          Object.freeze(this);
        }
        Fragment2.from = function(value) {
          if (Fragment2.isFragment(value)) {
            return value;
          }
          if (typeof value === "string") {
            return Fragment2.fromString(value);
          }
          return Fragment2.fromObject(value);
        };
        Fragment2.fromObject = function(value) {
          if (Fragment2.isFragment(value)) {
            return value;
          }
          switch (value.type) {
            case "function":
              return FunctionFragment.fromObject(value);
            case "event":
              return EventFragment.fromObject(value);
            case "constructor":
              return ConstructorFragment.fromObject(value);
            case "error":
              return ErrorFragment.fromObject(value);
            case "fallback":
            case "receive":
              return null;
          }
          return logger.throwArgumentError("invalid fragment object", "value", value);
        };
        Fragment2.fromString = function(value) {
          value = value.replace(/\s/g, " ");
          value = value.replace(/\(/g, " (").replace(/\)/g, ") ").replace(/\s+/g, " ");
          value = value.trim();
          if (value.split(" ")[0] === "event") {
            return EventFragment.fromString(value.substring(5).trim());
          } else if (value.split(" ")[0] === "function") {
            return FunctionFragment.fromString(value.substring(8).trim());
          } else if (value.split("(")[0].trim() === "constructor") {
            return ConstructorFragment.fromString(value.trim());
          } else if (value.split(" ")[0] === "error") {
            return ErrorFragment.fromString(value.substring(5).trim());
          }
          return logger.throwArgumentError("unsupported fragment", "value", value);
        };
        Fragment2.isFragment = function(value) {
          return !!(value && value._isFragment);
        };
        return Fragment2;
      }()
    );
    exports2.Fragment = Fragment;
    var EventFragment = (
      /** @class */
      function(_super) {
        __extends(EventFragment2, _super);
        function EventFragment2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        EventFragment2.prototype.format = function(format) {
          if (!format) {
            format = exports2.FormatTypes.sighash;
          }
          if (!exports2.FormatTypes[format]) {
            logger.throwArgumentError("invalid format type", "format", format);
          }
          if (format === exports2.FormatTypes.json) {
            return JSON.stringify({
              type: "event",
              anonymous: this.anonymous,
              name: this.name,
              inputs: this.inputs.map(function(input) {
                return JSON.parse(input.format(format));
              })
            });
          }
          var result = "";
          if (format !== exports2.FormatTypes.sighash) {
            result += "event ";
          }
          result += this.name + "(" + this.inputs.map(function(input) {
            return input.format(format);
          }).join(format === exports2.FormatTypes.full ? ", " : ",") + ") ";
          if (format !== exports2.FormatTypes.sighash) {
            if (this.anonymous) {
              result += "anonymous ";
            }
          }
          return result.trim();
        };
        EventFragment2.from = function(value) {
          if (typeof value === "string") {
            return EventFragment2.fromString(value);
          }
          return EventFragment2.fromObject(value);
        };
        EventFragment2.fromObject = function(value) {
          if (EventFragment2.isEventFragment(value)) {
            return value;
          }
          if (value.type !== "event") {
            logger.throwArgumentError("invalid event object", "value", value);
          }
          var params = {
            name: verifyIdentifier(value.name),
            anonymous: value.anonymous,
            inputs: value.inputs ? value.inputs.map(ParamType.fromObject) : [],
            type: "event"
          };
          return new EventFragment2(_constructorGuard, params);
        };
        EventFragment2.fromString = function(value) {
          var match = value.match(regexParen);
          if (!match) {
            logger.throwArgumentError("invalid event string", "value", value);
          }
          var anonymous = false;
          match[3].split(" ").forEach(function(modifier) {
            switch (modifier.trim()) {
              case "anonymous":
                anonymous = true;
                break;
              case "":
                break;
              default:
                logger.warn("unknown modifier: " + modifier);
            }
          });
          return EventFragment2.fromObject({
            name: match[1].trim(),
            anonymous,
            inputs: parseParams(match[2], true),
            type: "event"
          });
        };
        EventFragment2.isEventFragment = function(value) {
          return value && value._isFragment && value.type === "event";
        };
        return EventFragment2;
      }(Fragment)
    );
    exports2.EventFragment = EventFragment;
    function parseGas(value, params) {
      params.gas = null;
      var comps = value.split("@");
      if (comps.length !== 1) {
        if (comps.length > 2) {
          logger.throwArgumentError("invalid human-readable ABI signature", "value", value);
        }
        if (!comps[1].match(/^[0-9]+$/)) {
          logger.throwArgumentError("invalid human-readable ABI signature gas", "value", value);
        }
        params.gas = bignumber_1.BigNumber.from(comps[1]);
        return comps[0];
      }
      return value;
    }
    function parseModifiers(value, params) {
      params.constant = false;
      params.payable = false;
      params.stateMutability = "nonpayable";
      value.split(" ").forEach(function(modifier) {
        switch (modifier.trim()) {
          case "constant":
            params.constant = true;
            break;
          case "payable":
            params.payable = true;
            params.stateMutability = "payable";
            break;
          case "nonpayable":
            params.payable = false;
            params.stateMutability = "nonpayable";
            break;
          case "pure":
            params.constant = true;
            params.stateMutability = "pure";
            break;
          case "view":
            params.constant = true;
            params.stateMutability = "view";
            break;
          case "external":
          case "public":
          case "":
            break;
          default:
            console.log("unknown modifier: " + modifier);
        }
      });
    }
    function verifyState(value) {
      var result = {
        constant: false,
        payable: true,
        stateMutability: "payable"
      };
      if (value.stateMutability != null) {
        result.stateMutability = value.stateMutability;
        result.constant = result.stateMutability === "view" || result.stateMutability === "pure";
        if (value.constant != null) {
          if (!!value.constant !== result.constant) {
            logger.throwArgumentError("cannot have constant function with mutability " + result.stateMutability, "value", value);
          }
        }
        result.payable = result.stateMutability === "payable";
        if (value.payable != null) {
          if (!!value.payable !== result.payable) {
            logger.throwArgumentError("cannot have payable function with mutability " + result.stateMutability, "value", value);
          }
        }
      } else if (value.payable != null) {
        result.payable = !!value.payable;
        if (value.constant == null && !result.payable && value.type !== "constructor") {
          logger.throwArgumentError("unable to determine stateMutability", "value", value);
        }
        result.constant = !!value.constant;
        if (result.constant) {
          result.stateMutability = "view";
        } else {
          result.stateMutability = result.payable ? "payable" : "nonpayable";
        }
        if (result.payable && result.constant) {
          logger.throwArgumentError("cannot have constant payable function", "value", value);
        }
      } else if (value.constant != null) {
        result.constant = !!value.constant;
        result.payable = !result.constant;
        result.stateMutability = result.constant ? "view" : "payable";
      } else if (value.type !== "constructor") {
        logger.throwArgumentError("unable to determine stateMutability", "value", value);
      }
      return result;
    }
    var ConstructorFragment = (
      /** @class */
      function(_super) {
        __extends(ConstructorFragment2, _super);
        function ConstructorFragment2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        ConstructorFragment2.prototype.format = function(format) {
          if (!format) {
            format = exports2.FormatTypes.sighash;
          }
          if (!exports2.FormatTypes[format]) {
            logger.throwArgumentError("invalid format type", "format", format);
          }
          if (format === exports2.FormatTypes.json) {
            return JSON.stringify({
              type: "constructor",
              stateMutability: this.stateMutability !== "nonpayable" ? this.stateMutability : void 0,
              payable: this.payable,
              gas: this.gas ? this.gas.toNumber() : void 0,
              inputs: this.inputs.map(function(input) {
                return JSON.parse(input.format(format));
              })
            });
          }
          if (format === exports2.FormatTypes.sighash) {
            logger.throwError("cannot format a constructor for sighash", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
              operation: "format(sighash)"
            });
          }
          var result = "constructor(" + this.inputs.map(function(input) {
            return input.format(format);
          }).join(format === exports2.FormatTypes.full ? ", " : ",") + ") ";
          if (this.stateMutability && this.stateMutability !== "nonpayable") {
            result += this.stateMutability + " ";
          }
          return result.trim();
        };
        ConstructorFragment2.from = function(value) {
          if (typeof value === "string") {
            return ConstructorFragment2.fromString(value);
          }
          return ConstructorFragment2.fromObject(value);
        };
        ConstructorFragment2.fromObject = function(value) {
          if (ConstructorFragment2.isConstructorFragment(value)) {
            return value;
          }
          if (value.type !== "constructor") {
            logger.throwArgumentError("invalid constructor object", "value", value);
          }
          var state = verifyState(value);
          if (state.constant) {
            logger.throwArgumentError("constructor cannot be constant", "value", value);
          }
          var params = {
            name: null,
            type: value.type,
            inputs: value.inputs ? value.inputs.map(ParamType.fromObject) : [],
            payable: state.payable,
            stateMutability: state.stateMutability,
            gas: value.gas ? bignumber_1.BigNumber.from(value.gas) : null
          };
          return new ConstructorFragment2(_constructorGuard, params);
        };
        ConstructorFragment2.fromString = function(value) {
          var params = { type: "constructor" };
          value = parseGas(value, params);
          var parens = value.match(regexParen);
          if (!parens || parens[1].trim() !== "constructor") {
            logger.throwArgumentError("invalid constructor string", "value", value);
          }
          params.inputs = parseParams(parens[2].trim(), false);
          parseModifiers(parens[3].trim(), params);
          return ConstructorFragment2.fromObject(params);
        };
        ConstructorFragment2.isConstructorFragment = function(value) {
          return value && value._isFragment && value.type === "constructor";
        };
        return ConstructorFragment2;
      }(Fragment)
    );
    exports2.ConstructorFragment = ConstructorFragment;
    var FunctionFragment = (
      /** @class */
      function(_super) {
        __extends(FunctionFragment2, _super);
        function FunctionFragment2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        FunctionFragment2.prototype.format = function(format) {
          if (!format) {
            format = exports2.FormatTypes.sighash;
          }
          if (!exports2.FormatTypes[format]) {
            logger.throwArgumentError("invalid format type", "format", format);
          }
          if (format === exports2.FormatTypes.json) {
            return JSON.stringify({
              type: "function",
              name: this.name,
              constant: this.constant,
              stateMutability: this.stateMutability !== "nonpayable" ? this.stateMutability : void 0,
              payable: this.payable,
              gas: this.gas ? this.gas.toNumber() : void 0,
              inputs: this.inputs.map(function(input) {
                return JSON.parse(input.format(format));
              }),
              outputs: this.outputs.map(function(output) {
                return JSON.parse(output.format(format));
              })
            });
          }
          var result = "";
          if (format !== exports2.FormatTypes.sighash) {
            result += "function ";
          }
          result += this.name + "(" + this.inputs.map(function(input) {
            return input.format(format);
          }).join(format === exports2.FormatTypes.full ? ", " : ",") + ") ";
          if (format !== exports2.FormatTypes.sighash) {
            if (this.stateMutability) {
              if (this.stateMutability !== "nonpayable") {
                result += this.stateMutability + " ";
              }
            } else if (this.constant) {
              result += "view ";
            }
            if (this.outputs && this.outputs.length) {
              result += "returns (" + this.outputs.map(function(output) {
                return output.format(format);
              }).join(", ") + ") ";
            }
            if (this.gas != null) {
              result += "@" + this.gas.toString() + " ";
            }
          }
          return result.trim();
        };
        FunctionFragment2.from = function(value) {
          if (typeof value === "string") {
            return FunctionFragment2.fromString(value);
          }
          return FunctionFragment2.fromObject(value);
        };
        FunctionFragment2.fromObject = function(value) {
          if (FunctionFragment2.isFunctionFragment(value)) {
            return value;
          }
          if (value.type !== "function") {
            logger.throwArgumentError("invalid function object", "value", value);
          }
          var state = verifyState(value);
          var params = {
            type: value.type,
            name: verifyIdentifier(value.name),
            constant: state.constant,
            inputs: value.inputs ? value.inputs.map(ParamType.fromObject) : [],
            outputs: value.outputs ? value.outputs.map(ParamType.fromObject) : [],
            payable: state.payable,
            stateMutability: state.stateMutability,
            gas: value.gas ? bignumber_1.BigNumber.from(value.gas) : null
          };
          return new FunctionFragment2(_constructorGuard, params);
        };
        FunctionFragment2.fromString = function(value) {
          var params = { type: "function" };
          value = parseGas(value, params);
          var comps = value.split(" returns ");
          if (comps.length > 2) {
            logger.throwArgumentError("invalid function string", "value", value);
          }
          var parens = comps[0].match(regexParen);
          if (!parens) {
            logger.throwArgumentError("invalid function signature", "value", value);
          }
          params.name = parens[1].trim();
          if (params.name) {
            verifyIdentifier(params.name);
          }
          params.inputs = parseParams(parens[2], false);
          parseModifiers(parens[3].trim(), params);
          if (comps.length > 1) {
            var returns = comps[1].match(regexParen);
            if (returns[1].trim() != "" || returns[3].trim() != "") {
              logger.throwArgumentError("unexpected tokens", "value", value);
            }
            params.outputs = parseParams(returns[2], false);
          } else {
            params.outputs = [];
          }
          return FunctionFragment2.fromObject(params);
        };
        FunctionFragment2.isFunctionFragment = function(value) {
          return value && value._isFragment && value.type === "function";
        };
        return FunctionFragment2;
      }(ConstructorFragment)
    );
    exports2.FunctionFragment = FunctionFragment;
    function checkForbidden(fragment) {
      var sig = fragment.format();
      if (sig === "Error(string)" || sig === "Panic(uint256)") {
        logger.throwArgumentError("cannot specify user defined " + sig + " error", "fragment", fragment);
      }
      return fragment;
    }
    var ErrorFragment = (
      /** @class */
      function(_super) {
        __extends(ErrorFragment2, _super);
        function ErrorFragment2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        ErrorFragment2.prototype.format = function(format) {
          if (!format) {
            format = exports2.FormatTypes.sighash;
          }
          if (!exports2.FormatTypes[format]) {
            logger.throwArgumentError("invalid format type", "format", format);
          }
          if (format === exports2.FormatTypes.json) {
            return JSON.stringify({
              type: "error",
              name: this.name,
              inputs: this.inputs.map(function(input) {
                return JSON.parse(input.format(format));
              })
            });
          }
          var result = "";
          if (format !== exports2.FormatTypes.sighash) {
            result += "error ";
          }
          result += this.name + "(" + this.inputs.map(function(input) {
            return input.format(format);
          }).join(format === exports2.FormatTypes.full ? ", " : ",") + ") ";
          return result.trim();
        };
        ErrorFragment2.from = function(value) {
          if (typeof value === "string") {
            return ErrorFragment2.fromString(value);
          }
          return ErrorFragment2.fromObject(value);
        };
        ErrorFragment2.fromObject = function(value) {
          if (ErrorFragment2.isErrorFragment(value)) {
            return value;
          }
          if (value.type !== "error") {
            logger.throwArgumentError("invalid error object", "value", value);
          }
          var params = {
            type: value.type,
            name: verifyIdentifier(value.name),
            inputs: value.inputs ? value.inputs.map(ParamType.fromObject) : []
          };
          return checkForbidden(new ErrorFragment2(_constructorGuard, params));
        };
        ErrorFragment2.fromString = function(value) {
          var params = { type: "error" };
          var parens = value.match(regexParen);
          if (!parens) {
            logger.throwArgumentError("invalid error signature", "value", value);
          }
          params.name = parens[1].trim();
          if (params.name) {
            verifyIdentifier(params.name);
          }
          params.inputs = parseParams(parens[2], false);
          return checkForbidden(ErrorFragment2.fromObject(params));
        };
        ErrorFragment2.isErrorFragment = function(value) {
          return value && value._isFragment && value.type === "error";
        };
        return ErrorFragment2;
      }(Fragment)
    );
    exports2.ErrorFragment = ErrorFragment;
    function verifyType(type) {
      if (type.match(/^uint($|[^1-9])/)) {
        type = "uint256" + type.substring(4);
      } else if (type.match(/^int($|[^1-9])/)) {
        type = "int256" + type.substring(3);
      }
      return type;
    }
    var regexIdentifier = new RegExp("^[a-zA-Z$_][a-zA-Z0-9$_]*$");
    function verifyIdentifier(value) {
      if (!value || !value.match(regexIdentifier)) {
        logger.throwArgumentError('invalid identifier "' + value + '"', "value", value);
      }
      return value;
    }
    var regexParen = new RegExp("^([^)(]*)\\((.*)\\)([^)(]*)$");
    function splitNesting(value) {
      value = value.trim();
      var result = [];
      var accum = "";
      var depth = 0;
      for (var offset = 0; offset < value.length; offset++) {
        var c = value[offset];
        if (c === "," && depth === 0) {
          result.push(accum);
          accum = "";
        } else {
          accum += c;
          if (c === "(") {
            depth++;
          } else if (c === ")") {
            depth--;
            if (depth === -1) {
              logger.throwArgumentError("unbalanced parenthesis", "value", value);
            }
          }
        }
      }
      if (accum) {
        result.push(accum);
      }
      return result;
    }
  }
});

// node_modules/@ethersproject/abi/lib/coders/abstract-coder.js
var require_abstract_coder = __commonJS({
  "node_modules/@ethersproject/abi/lib/coders/abstract-coder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Reader = exports2.Writer = exports2.Coder = exports2.checkResultErrors = void 0;
    var bytes_1 = require_lib2();
    var bignumber_1 = require_lib3();
    var properties_1 = require_lib4();
    var logger_1 = require_lib();
    var _version_1 = require_version5();
    var logger = new logger_1.Logger(_version_1.version);
    function checkResultErrors(result) {
      var errors = [];
      var checkErrors = function(path, object) {
        if (!Array.isArray(object)) {
          return;
        }
        for (var key in object) {
          var childPath = path.slice();
          childPath.push(key);
          try {
            checkErrors(childPath, object[key]);
          } catch (error) {
            errors.push({ path: childPath, error });
          }
        }
      };
      checkErrors([], result);
      return errors;
    }
    exports2.checkResultErrors = checkResultErrors;
    var Coder = (
      /** @class */
      function() {
        function Coder2(name2, type, localName, dynamic) {
          this.name = name2;
          this.type = type;
          this.localName = localName;
          this.dynamic = dynamic;
        }
        Coder2.prototype._throwError = function(message, value) {
          logger.throwArgumentError(message, this.localName, value);
        };
        return Coder2;
      }()
    );
    exports2.Coder = Coder;
    var Writer = (
      /** @class */
      function() {
        function Writer2(wordSize) {
          (0, properties_1.defineReadOnly)(this, "wordSize", wordSize || 32);
          this._data = [];
          this._dataLength = 0;
          this._padding = new Uint8Array(wordSize);
        }
        Object.defineProperty(Writer2.prototype, "data", {
          get: function() {
            return (0, bytes_1.hexConcat)(this._data);
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(Writer2.prototype, "length", {
          get: function() {
            return this._dataLength;
          },
          enumerable: false,
          configurable: true
        });
        Writer2.prototype._writeData = function(data) {
          this._data.push(data);
          this._dataLength += data.length;
          return data.length;
        };
        Writer2.prototype.appendWriter = function(writer) {
          return this._writeData((0, bytes_1.concat)(writer._data));
        };
        Writer2.prototype.writeBytes = function(value) {
          var bytes = (0, bytes_1.arrayify)(value);
          var paddingOffset = bytes.length % this.wordSize;
          if (paddingOffset) {
            bytes = (0, bytes_1.concat)([bytes, this._padding.slice(paddingOffset)]);
          }
          return this._writeData(bytes);
        };
        Writer2.prototype._getValue = function(value) {
          var bytes = (0, bytes_1.arrayify)(bignumber_1.BigNumber.from(value));
          if (bytes.length > this.wordSize) {
            logger.throwError("value out-of-bounds", logger_1.Logger.errors.BUFFER_OVERRUN, {
              length: this.wordSize,
              offset: bytes.length
            });
          }
          if (bytes.length % this.wordSize) {
            bytes = (0, bytes_1.concat)([this._padding.slice(bytes.length % this.wordSize), bytes]);
          }
          return bytes;
        };
        Writer2.prototype.writeValue = function(value) {
          return this._writeData(this._getValue(value));
        };
        Writer2.prototype.writeUpdatableValue = function() {
          var _this = this;
          var offset = this._data.length;
          this._data.push(this._padding);
          this._dataLength += this.wordSize;
          return function(value) {
            _this._data[offset] = _this._getValue(value);
          };
        };
        return Writer2;
      }()
    );
    exports2.Writer = Writer;
    var Reader = (
      /** @class */
      function() {
        function Reader2(data, wordSize, coerceFunc, allowLoose) {
          (0, properties_1.defineReadOnly)(this, "_data", (0, bytes_1.arrayify)(data));
          (0, properties_1.defineReadOnly)(this, "wordSize", wordSize || 32);
          (0, properties_1.defineReadOnly)(this, "_coerceFunc", coerceFunc);
          (0, properties_1.defineReadOnly)(this, "allowLoose", allowLoose);
          this._offset = 0;
        }
        Object.defineProperty(Reader2.prototype, "data", {
          get: function() {
            return (0, bytes_1.hexlify)(this._data);
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(Reader2.prototype, "consumed", {
          get: function() {
            return this._offset;
          },
          enumerable: false,
          configurable: true
        });
        Reader2.coerce = function(name2, value) {
          var match = name2.match("^u?int([0-9]+)$");
          if (match && parseInt(match[1]) <= 48) {
            value = value.toNumber();
          }
          return value;
        };
        Reader2.prototype.coerce = function(name2, value) {
          if (this._coerceFunc) {
            return this._coerceFunc(name2, value);
          }
          return Reader2.coerce(name2, value);
        };
        Reader2.prototype._peekBytes = function(offset, length, loose) {
          var alignedLength = Math.ceil(length / this.wordSize) * this.wordSize;
          if (this._offset + alignedLength > this._data.length) {
            if (this.allowLoose && loose && this._offset + length <= this._data.length) {
              alignedLength = length;
            } else {
              logger.throwError("data out-of-bounds", logger_1.Logger.errors.BUFFER_OVERRUN, {
                length: this._data.length,
                offset: this._offset + alignedLength
              });
            }
          }
          return this._data.slice(this._offset, this._offset + alignedLength);
        };
        Reader2.prototype.subReader = function(offset) {
          return new Reader2(this._data.slice(this._offset + offset), this.wordSize, this._coerceFunc, this.allowLoose);
        };
        Reader2.prototype.readBytes = function(length, loose) {
          var bytes = this._peekBytes(0, length, !!loose);
          this._offset += bytes.length;
          return bytes.slice(0, length);
        };
        Reader2.prototype.readValue = function() {
          return bignumber_1.BigNumber.from(this.readBytes(this.wordSize));
        };
        return Reader2;
      }()
    );
    exports2.Reader = Reader;
  }
});

// node_modules/js-sha3/src/sha3.js
var require_sha3 = __commonJS({
  "node_modules/js-sha3/src/sha3.js"(exports2, module2) {
    (function() {
      "use strict";
      var INPUT_ERROR = "input is invalid type";
      var FINALIZE_ERROR = "finalize already called";
      var WINDOW = typeof window === "object";
      var root = WINDOW ? window : {};
      if (root.JS_SHA3_NO_WINDOW) {
        WINDOW = false;
      }
      var WEB_WORKER = !WINDOW && typeof self === "object";
      var NODE_JS = !root.JS_SHA3_NO_NODE_JS && typeof process === "object" && process.versions && process.versions.node;
      if (NODE_JS) {
        root = global;
      } else if (WEB_WORKER) {
        root = self;
      }
      var COMMON_JS = !root.JS_SHA3_NO_COMMON_JS && typeof module2 === "object" && module2.exports;
      var AMD = typeof define === "function" && define.amd;
      var ARRAY_BUFFER = !root.JS_SHA3_NO_ARRAY_BUFFER && typeof ArrayBuffer !== "undefined";
      var HEX_CHARS = "0123456789abcdef".split("");
      var SHAKE_PADDING = [31, 7936, 2031616, 520093696];
      var CSHAKE_PADDING = [4, 1024, 262144, 67108864];
      var KECCAK_PADDING = [1, 256, 65536, 16777216];
      var PADDING = [6, 1536, 393216, 100663296];
      var SHIFT = [0, 8, 16, 24];
      var RC = [
        1,
        0,
        32898,
        0,
        32906,
        2147483648,
        2147516416,
        2147483648,
        32907,
        0,
        2147483649,
        0,
        2147516545,
        2147483648,
        32777,
        2147483648,
        138,
        0,
        136,
        0,
        2147516425,
        0,
        2147483658,
        0,
        2147516555,
        0,
        139,
        2147483648,
        32905,
        2147483648,
        32771,
        2147483648,
        32770,
        2147483648,
        128,
        2147483648,
        32778,
        0,
        2147483658,
        2147483648,
        2147516545,
        2147483648,
        32896,
        2147483648,
        2147483649,
        0,
        2147516424,
        2147483648
      ];
      var BITS = [224, 256, 384, 512];
      var SHAKE_BITS = [128, 256];
      var OUTPUT_TYPES = ["hex", "buffer", "arrayBuffer", "array", "digest"];
      var CSHAKE_BYTEPAD = {
        "128": 168,
        "256": 136
      };
      if (root.JS_SHA3_NO_NODE_JS || !Array.isArray) {
        Array.isArray = function(obj) {
          return Object.prototype.toString.call(obj) === "[object Array]";
        };
      }
      if (ARRAY_BUFFER && (root.JS_SHA3_NO_ARRAY_BUFFER_IS_VIEW || !ArrayBuffer.isView)) {
        ArrayBuffer.isView = function(obj) {
          return typeof obj === "object" && obj.buffer && obj.buffer.constructor === ArrayBuffer;
        };
      }
      var createOutputMethod = function(bits2, padding, outputType) {
        return function(message) {
          return new Keccak(bits2, padding, bits2).update(message)[outputType]();
        };
      };
      var createShakeOutputMethod = function(bits2, padding, outputType) {
        return function(message, outputBits) {
          return new Keccak(bits2, padding, outputBits).update(message)[outputType]();
        };
      };
      var createCshakeOutputMethod = function(bits2, padding, outputType) {
        return function(message, outputBits, n, s) {
          return methods["cshake" + bits2].update(message, outputBits, n, s)[outputType]();
        };
      };
      var createKmacOutputMethod = function(bits2, padding, outputType) {
        return function(key, message, outputBits, s) {
          return methods["kmac" + bits2].update(key, message, outputBits, s)[outputType]();
        };
      };
      var createOutputMethods = function(method, createMethod2, bits2, padding) {
        for (var i2 = 0; i2 < OUTPUT_TYPES.length; ++i2) {
          var type = OUTPUT_TYPES[i2];
          method[type] = createMethod2(bits2, padding, type);
        }
        return method;
      };
      var createMethod = function(bits2, padding) {
        var method = createOutputMethod(bits2, padding, "hex");
        method.create = function() {
          return new Keccak(bits2, padding, bits2);
        };
        method.update = function(message) {
          return method.create().update(message);
        };
        return createOutputMethods(method, createOutputMethod, bits2, padding);
      };
      var createShakeMethod = function(bits2, padding) {
        var method = createShakeOutputMethod(bits2, padding, "hex");
        method.create = function(outputBits) {
          return new Keccak(bits2, padding, outputBits);
        };
        method.update = function(message, outputBits) {
          return method.create(outputBits).update(message);
        };
        return createOutputMethods(method, createShakeOutputMethod, bits2, padding);
      };
      var createCshakeMethod = function(bits2, padding) {
        var w = CSHAKE_BYTEPAD[bits2];
        var method = createCshakeOutputMethod(bits2, padding, "hex");
        method.create = function(outputBits, n, s) {
          if (!n && !s) {
            return methods["shake" + bits2].create(outputBits);
          } else {
            return new Keccak(bits2, padding, outputBits).bytepad([n, s], w);
          }
        };
        method.update = function(message, outputBits, n, s) {
          return method.create(outputBits, n, s).update(message);
        };
        return createOutputMethods(method, createCshakeOutputMethod, bits2, padding);
      };
      var createKmacMethod = function(bits2, padding) {
        var w = CSHAKE_BYTEPAD[bits2];
        var method = createKmacOutputMethod(bits2, padding, "hex");
        method.create = function(key, outputBits, s) {
          return new Kmac(bits2, padding, outputBits).bytepad(["KMAC", s], w).bytepad([key], w);
        };
        method.update = function(key, message, outputBits, s) {
          return method.create(key, outputBits, s).update(message);
        };
        return createOutputMethods(method, createKmacOutputMethod, bits2, padding);
      };
      var algorithms = [
        { name: "keccak", padding: KECCAK_PADDING, bits: BITS, createMethod },
        { name: "sha3", padding: PADDING, bits: BITS, createMethod },
        { name: "shake", padding: SHAKE_PADDING, bits: SHAKE_BITS, createMethod: createShakeMethod },
        { name: "cshake", padding: CSHAKE_PADDING, bits: SHAKE_BITS, createMethod: createCshakeMethod },
        { name: "kmac", padding: CSHAKE_PADDING, bits: SHAKE_BITS, createMethod: createKmacMethod }
      ];
      var methods = {}, methodNames = [];
      for (var i = 0; i < algorithms.length; ++i) {
        var algorithm = algorithms[i];
        var bits = algorithm.bits;
        for (var j = 0; j < bits.length; ++j) {
          var methodName = algorithm.name + "_" + bits[j];
          methodNames.push(methodName);
          methods[methodName] = algorithm.createMethod(bits[j], algorithm.padding);
          if (algorithm.name !== "sha3") {
            var newMethodName = algorithm.name + bits[j];
            methodNames.push(newMethodName);
            methods[newMethodName] = methods[methodName];
          }
        }
      }
      function Keccak(bits2, padding, outputBits) {
        this.blocks = [];
        this.s = [];
        this.padding = padding;
        this.outputBits = outputBits;
        this.reset = true;
        this.finalized = false;
        this.block = 0;
        this.start = 0;
        this.blockCount = 1600 - (bits2 << 1) >> 5;
        this.byteCount = this.blockCount << 2;
        this.outputBlocks = outputBits >> 5;
        this.extraBytes = (outputBits & 31) >> 3;
        for (var i2 = 0; i2 < 50; ++i2) {
          this.s[i2] = 0;
        }
      }
      Keccak.prototype.update = function(message) {
        if (this.finalized) {
          throw new Error(FINALIZE_ERROR);
        }
        var notString, type = typeof message;
        if (type !== "string") {
          if (type === "object") {
            if (message === null) {
              throw new Error(INPUT_ERROR);
            } else if (ARRAY_BUFFER && message.constructor === ArrayBuffer) {
              message = new Uint8Array(message);
            } else if (!Array.isArray(message)) {
              if (!ARRAY_BUFFER || !ArrayBuffer.isView(message)) {
                throw new Error(INPUT_ERROR);
              }
            }
          } else {
            throw new Error(INPUT_ERROR);
          }
          notString = true;
        }
        var blocks = this.blocks, byteCount = this.byteCount, length = message.length, blockCount = this.blockCount, index = 0, s = this.s, i2, code;
        while (index < length) {
          if (this.reset) {
            this.reset = false;
            blocks[0] = this.block;
            for (i2 = 1; i2 < blockCount + 1; ++i2) {
              blocks[i2] = 0;
            }
          }
          if (notString) {
            for (i2 = this.start; index < length && i2 < byteCount; ++index) {
              blocks[i2 >> 2] |= message[index] << SHIFT[i2++ & 3];
            }
          } else {
            for (i2 = this.start; index < length && i2 < byteCount; ++index) {
              code = message.charCodeAt(index);
              if (code < 128) {
                blocks[i2 >> 2] |= code << SHIFT[i2++ & 3];
              } else if (code < 2048) {
                blocks[i2 >> 2] |= (192 | code >> 6) << SHIFT[i2++ & 3];
                blocks[i2 >> 2] |= (128 | code & 63) << SHIFT[i2++ & 3];
              } else if (code < 55296 || code >= 57344) {
                blocks[i2 >> 2] |= (224 | code >> 12) << SHIFT[i2++ & 3];
                blocks[i2 >> 2] |= (128 | code >> 6 & 63) << SHIFT[i2++ & 3];
                blocks[i2 >> 2] |= (128 | code & 63) << SHIFT[i2++ & 3];
              } else {
                code = 65536 + ((code & 1023) << 10 | message.charCodeAt(++index) & 1023);
                blocks[i2 >> 2] |= (240 | code >> 18) << SHIFT[i2++ & 3];
                blocks[i2 >> 2] |= (128 | code >> 12 & 63) << SHIFT[i2++ & 3];
                blocks[i2 >> 2] |= (128 | code >> 6 & 63) << SHIFT[i2++ & 3];
                blocks[i2 >> 2] |= (128 | code & 63) << SHIFT[i2++ & 3];
              }
            }
          }
          this.lastByteIndex = i2;
          if (i2 >= byteCount) {
            this.start = i2 - byteCount;
            this.block = blocks[blockCount];
            for (i2 = 0; i2 < blockCount; ++i2) {
              s[i2] ^= blocks[i2];
            }
            f(s);
            this.reset = true;
          } else {
            this.start = i2;
          }
        }
        return this;
      };
      Keccak.prototype.encode = function(x, right) {
        var o = x & 255, n = 1;
        var bytes = [o];
        x = x >> 8;
        o = x & 255;
        while (o > 0) {
          bytes.unshift(o);
          x = x >> 8;
          o = x & 255;
          ++n;
        }
        if (right) {
          bytes.push(n);
        } else {
          bytes.unshift(n);
        }
        this.update(bytes);
        return bytes.length;
      };
      Keccak.prototype.encodeString = function(str) {
        var notString, type = typeof str;
        if (type !== "string") {
          if (type === "object") {
            if (str === null) {
              throw new Error(INPUT_ERROR);
            } else if (ARRAY_BUFFER && str.constructor === ArrayBuffer) {
              str = new Uint8Array(str);
            } else if (!Array.isArray(str)) {
              if (!ARRAY_BUFFER || !ArrayBuffer.isView(str)) {
                throw new Error(INPUT_ERROR);
              }
            }
          } else {
            throw new Error(INPUT_ERROR);
          }
          notString = true;
        }
        var bytes = 0, length = str.length;
        if (notString) {
          bytes = length;
        } else {
          for (var i2 = 0; i2 < str.length; ++i2) {
            var code = str.charCodeAt(i2);
            if (code < 128) {
              bytes += 1;
            } else if (code < 2048) {
              bytes += 2;
            } else if (code < 55296 || code >= 57344) {
              bytes += 3;
            } else {
              code = 65536 + ((code & 1023) << 10 | str.charCodeAt(++i2) & 1023);
              bytes += 4;
            }
          }
        }
        bytes += this.encode(bytes * 8);
        this.update(str);
        return bytes;
      };
      Keccak.prototype.bytepad = function(strs, w) {
        var bytes = this.encode(w);
        for (var i2 = 0; i2 < strs.length; ++i2) {
          bytes += this.encodeString(strs[i2]);
        }
        var paddingBytes = w - bytes % w;
        var zeros = [];
        zeros.length = paddingBytes;
        this.update(zeros);
        return this;
      };
      Keccak.prototype.finalize = function() {
        if (this.finalized) {
          return;
        }
        this.finalized = true;
        var blocks = this.blocks, i2 = this.lastByteIndex, blockCount = this.blockCount, s = this.s;
        blocks[i2 >> 2] |= this.padding[i2 & 3];
        if (this.lastByteIndex === this.byteCount) {
          blocks[0] = blocks[blockCount];
          for (i2 = 1; i2 < blockCount + 1; ++i2) {
            blocks[i2] = 0;
          }
        }
        blocks[blockCount - 1] |= 2147483648;
        for (i2 = 0; i2 < blockCount; ++i2) {
          s[i2] ^= blocks[i2];
        }
        f(s);
      };
      Keccak.prototype.toString = Keccak.prototype.hex = function() {
        this.finalize();
        var blockCount = this.blockCount, s = this.s, outputBlocks = this.outputBlocks, extraBytes = this.extraBytes, i2 = 0, j2 = 0;
        var hex = "", block;
        while (j2 < outputBlocks) {
          for (i2 = 0; i2 < blockCount && j2 < outputBlocks; ++i2, ++j2) {
            block = s[i2];
            hex += HEX_CHARS[block >> 4 & 15] + HEX_CHARS[block & 15] + HEX_CHARS[block >> 12 & 15] + HEX_CHARS[block >> 8 & 15] + HEX_CHARS[block >> 20 & 15] + HEX_CHARS[block >> 16 & 15] + HEX_CHARS[block >> 28 & 15] + HEX_CHARS[block >> 24 & 15];
          }
          if (j2 % blockCount === 0) {
            f(s);
            i2 = 0;
          }
        }
        if (extraBytes) {
          block = s[i2];
          hex += HEX_CHARS[block >> 4 & 15] + HEX_CHARS[block & 15];
          if (extraBytes > 1) {
            hex += HEX_CHARS[block >> 12 & 15] + HEX_CHARS[block >> 8 & 15];
          }
          if (extraBytes > 2) {
            hex += HEX_CHARS[block >> 20 & 15] + HEX_CHARS[block >> 16 & 15];
          }
        }
        return hex;
      };
      Keccak.prototype.arrayBuffer = function() {
        this.finalize();
        var blockCount = this.blockCount, s = this.s, outputBlocks = this.outputBlocks, extraBytes = this.extraBytes, i2 = 0, j2 = 0;
        var bytes = this.outputBits >> 3;
        var buffer;
        if (extraBytes) {
          buffer = new ArrayBuffer(outputBlocks + 1 << 2);
        } else {
          buffer = new ArrayBuffer(bytes);
        }
        var array = new Uint32Array(buffer);
        while (j2 < outputBlocks) {
          for (i2 = 0; i2 < blockCount && j2 < outputBlocks; ++i2, ++j2) {
            array[j2] = s[i2];
          }
          if (j2 % blockCount === 0) {
            f(s);
          }
        }
        if (extraBytes) {
          array[i2] = s[i2];
          buffer = buffer.slice(0, bytes);
        }
        return buffer;
      };
      Keccak.prototype.buffer = Keccak.prototype.arrayBuffer;
      Keccak.prototype.digest = Keccak.prototype.array = function() {
        this.finalize();
        var blockCount = this.blockCount, s = this.s, outputBlocks = this.outputBlocks, extraBytes = this.extraBytes, i2 = 0, j2 = 0;
        var array = [], offset, block;
        while (j2 < outputBlocks) {
          for (i2 = 0; i2 < blockCount && j2 < outputBlocks; ++i2, ++j2) {
            offset = j2 << 2;
            block = s[i2];
            array[offset] = block & 255;
            array[offset + 1] = block >> 8 & 255;
            array[offset + 2] = block >> 16 & 255;
            array[offset + 3] = block >> 24 & 255;
          }
          if (j2 % blockCount === 0) {
            f(s);
          }
        }
        if (extraBytes) {
          offset = j2 << 2;
          block = s[i2];
          array[offset] = block & 255;
          if (extraBytes > 1) {
            array[offset + 1] = block >> 8 & 255;
          }
          if (extraBytes > 2) {
            array[offset + 2] = block >> 16 & 255;
          }
        }
        return array;
      };
      function Kmac(bits2, padding, outputBits) {
        Keccak.call(this, bits2, padding, outputBits);
      }
      Kmac.prototype = new Keccak();
      Kmac.prototype.finalize = function() {
        this.encode(this.outputBits, true);
        return Keccak.prototype.finalize.call(this);
      };
      var f = function(s) {
        var h, l, n, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13, b14, b15, b16, b17, b18, b19, b20, b21, b22, b23, b24, b25, b26, b27, b28, b29, b30, b31, b32, b33, b34, b35, b36, b37, b38, b39, b40, b41, b42, b43, b44, b45, b46, b47, b48, b49;
        for (n = 0; n < 48; n += 2) {
          c0 = s[0] ^ s[10] ^ s[20] ^ s[30] ^ s[40];
          c1 = s[1] ^ s[11] ^ s[21] ^ s[31] ^ s[41];
          c2 = s[2] ^ s[12] ^ s[22] ^ s[32] ^ s[42];
          c3 = s[3] ^ s[13] ^ s[23] ^ s[33] ^ s[43];
          c4 = s[4] ^ s[14] ^ s[24] ^ s[34] ^ s[44];
          c5 = s[5] ^ s[15] ^ s[25] ^ s[35] ^ s[45];
          c6 = s[6] ^ s[16] ^ s[26] ^ s[36] ^ s[46];
          c7 = s[7] ^ s[17] ^ s[27] ^ s[37] ^ s[47];
          c8 = s[8] ^ s[18] ^ s[28] ^ s[38] ^ s[48];
          c9 = s[9] ^ s[19] ^ s[29] ^ s[39] ^ s[49];
          h = c8 ^ (c2 << 1 | c3 >>> 31);
          l = c9 ^ (c3 << 1 | c2 >>> 31);
          s[0] ^= h;
          s[1] ^= l;
          s[10] ^= h;
          s[11] ^= l;
          s[20] ^= h;
          s[21] ^= l;
          s[30] ^= h;
          s[31] ^= l;
          s[40] ^= h;
          s[41] ^= l;
          h = c0 ^ (c4 << 1 | c5 >>> 31);
          l = c1 ^ (c5 << 1 | c4 >>> 31);
          s[2] ^= h;
          s[3] ^= l;
          s[12] ^= h;
          s[13] ^= l;
          s[22] ^= h;
          s[23] ^= l;
          s[32] ^= h;
          s[33] ^= l;
          s[42] ^= h;
          s[43] ^= l;
          h = c2 ^ (c6 << 1 | c7 >>> 31);
          l = c3 ^ (c7 << 1 | c6 >>> 31);
          s[4] ^= h;
          s[5] ^= l;
          s[14] ^= h;
          s[15] ^= l;
          s[24] ^= h;
          s[25] ^= l;
          s[34] ^= h;
          s[35] ^= l;
          s[44] ^= h;
          s[45] ^= l;
          h = c4 ^ (c8 << 1 | c9 >>> 31);
          l = c5 ^ (c9 << 1 | c8 >>> 31);
          s[6] ^= h;
          s[7] ^= l;
          s[16] ^= h;
          s[17] ^= l;
          s[26] ^= h;
          s[27] ^= l;
          s[36] ^= h;
          s[37] ^= l;
          s[46] ^= h;
          s[47] ^= l;
          h = c6 ^ (c0 << 1 | c1 >>> 31);
          l = c7 ^ (c1 << 1 | c0 >>> 31);
          s[8] ^= h;
          s[9] ^= l;
          s[18] ^= h;
          s[19] ^= l;
          s[28] ^= h;
          s[29] ^= l;
          s[38] ^= h;
          s[39] ^= l;
          s[48] ^= h;
          s[49] ^= l;
          b0 = s[0];
          b1 = s[1];
          b32 = s[11] << 4 | s[10] >>> 28;
          b33 = s[10] << 4 | s[11] >>> 28;
          b14 = s[20] << 3 | s[21] >>> 29;
          b15 = s[21] << 3 | s[20] >>> 29;
          b46 = s[31] << 9 | s[30] >>> 23;
          b47 = s[30] << 9 | s[31] >>> 23;
          b28 = s[40] << 18 | s[41] >>> 14;
          b29 = s[41] << 18 | s[40] >>> 14;
          b20 = s[2] << 1 | s[3] >>> 31;
          b21 = s[3] << 1 | s[2] >>> 31;
          b2 = s[13] << 12 | s[12] >>> 20;
          b3 = s[12] << 12 | s[13] >>> 20;
          b34 = s[22] << 10 | s[23] >>> 22;
          b35 = s[23] << 10 | s[22] >>> 22;
          b16 = s[33] << 13 | s[32] >>> 19;
          b17 = s[32] << 13 | s[33] >>> 19;
          b48 = s[42] << 2 | s[43] >>> 30;
          b49 = s[43] << 2 | s[42] >>> 30;
          b40 = s[5] << 30 | s[4] >>> 2;
          b41 = s[4] << 30 | s[5] >>> 2;
          b22 = s[14] << 6 | s[15] >>> 26;
          b23 = s[15] << 6 | s[14] >>> 26;
          b4 = s[25] << 11 | s[24] >>> 21;
          b5 = s[24] << 11 | s[25] >>> 21;
          b36 = s[34] << 15 | s[35] >>> 17;
          b37 = s[35] << 15 | s[34] >>> 17;
          b18 = s[45] << 29 | s[44] >>> 3;
          b19 = s[44] << 29 | s[45] >>> 3;
          b10 = s[6] << 28 | s[7] >>> 4;
          b11 = s[7] << 28 | s[6] >>> 4;
          b42 = s[17] << 23 | s[16] >>> 9;
          b43 = s[16] << 23 | s[17] >>> 9;
          b24 = s[26] << 25 | s[27] >>> 7;
          b25 = s[27] << 25 | s[26] >>> 7;
          b6 = s[36] << 21 | s[37] >>> 11;
          b7 = s[37] << 21 | s[36] >>> 11;
          b38 = s[47] << 24 | s[46] >>> 8;
          b39 = s[46] << 24 | s[47] >>> 8;
          b30 = s[8] << 27 | s[9] >>> 5;
          b31 = s[9] << 27 | s[8] >>> 5;
          b12 = s[18] << 20 | s[19] >>> 12;
          b13 = s[19] << 20 | s[18] >>> 12;
          b44 = s[29] << 7 | s[28] >>> 25;
          b45 = s[28] << 7 | s[29] >>> 25;
          b26 = s[38] << 8 | s[39] >>> 24;
          b27 = s[39] << 8 | s[38] >>> 24;
          b8 = s[48] << 14 | s[49] >>> 18;
          b9 = s[49] << 14 | s[48] >>> 18;
          s[0] = b0 ^ ~b2 & b4;
          s[1] = b1 ^ ~b3 & b5;
          s[10] = b10 ^ ~b12 & b14;
          s[11] = b11 ^ ~b13 & b15;
          s[20] = b20 ^ ~b22 & b24;
          s[21] = b21 ^ ~b23 & b25;
          s[30] = b30 ^ ~b32 & b34;
          s[31] = b31 ^ ~b33 & b35;
          s[40] = b40 ^ ~b42 & b44;
          s[41] = b41 ^ ~b43 & b45;
          s[2] = b2 ^ ~b4 & b6;
          s[3] = b3 ^ ~b5 & b7;
          s[12] = b12 ^ ~b14 & b16;
          s[13] = b13 ^ ~b15 & b17;
          s[22] = b22 ^ ~b24 & b26;
          s[23] = b23 ^ ~b25 & b27;
          s[32] = b32 ^ ~b34 & b36;
          s[33] = b33 ^ ~b35 & b37;
          s[42] = b42 ^ ~b44 & b46;
          s[43] = b43 ^ ~b45 & b47;
          s[4] = b4 ^ ~b6 & b8;
          s[5] = b5 ^ ~b7 & b9;
          s[14] = b14 ^ ~b16 & b18;
          s[15] = b15 ^ ~b17 & b19;
          s[24] = b24 ^ ~b26 & b28;
          s[25] = b25 ^ ~b27 & b29;
          s[34] = b34 ^ ~b36 & b38;
          s[35] = b35 ^ ~b37 & b39;
          s[44] = b44 ^ ~b46 & b48;
          s[45] = b45 ^ ~b47 & b49;
          s[6] = b6 ^ ~b8 & b0;
          s[7] = b7 ^ ~b9 & b1;
          s[16] = b16 ^ ~b18 & b10;
          s[17] = b17 ^ ~b19 & b11;
          s[26] = b26 ^ ~b28 & b20;
          s[27] = b27 ^ ~b29 & b21;
          s[36] = b36 ^ ~b38 & b30;
          s[37] = b37 ^ ~b39 & b31;
          s[46] = b46 ^ ~b48 & b40;
          s[47] = b47 ^ ~b49 & b41;
          s[8] = b8 ^ ~b0 & b2;
          s[9] = b9 ^ ~b1 & b3;
          s[18] = b18 ^ ~b10 & b12;
          s[19] = b19 ^ ~b11 & b13;
          s[28] = b28 ^ ~b20 & b22;
          s[29] = b29 ^ ~b21 & b23;
          s[38] = b38 ^ ~b30 & b32;
          s[39] = b39 ^ ~b31 & b33;
          s[48] = b48 ^ ~b40 & b42;
          s[49] = b49 ^ ~b41 & b43;
          s[0] ^= RC[n];
          s[1] ^= RC[n + 1];
        }
      };
      if (COMMON_JS) {
        module2.exports = methods;
      } else {
        for (i = 0; i < methodNames.length; ++i) {
          root[methodNames[i]] = methods[methodNames[i]];
        }
        if (AMD) {
          define(function() {
            return methods;
          });
        }
      }
    })();
  }
});

// node_modules/@ethersproject/keccak256/lib/index.js
var require_lib5 = __commonJS({
  "node_modules/@ethersproject/keccak256/lib/index.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.keccak256 = void 0;
    var js_sha3_1 = __importDefault(require_sha3());
    var bytes_1 = require_lib2();
    function keccak256(data) {
      return "0x" + js_sha3_1.default.keccak_256((0, bytes_1.arrayify)(data));
    }
    exports2.keccak256 = keccak256;
  }
});

// node_modules/@ethersproject/rlp/lib/_version.js
var require_version6 = __commonJS({
  "node_modules/@ethersproject/rlp/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "rlp/5.5.0";
  }
});

// node_modules/@ethersproject/rlp/lib/index.js
var require_lib6 = __commonJS({
  "node_modules/@ethersproject/rlp/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.decode = exports2.encode = void 0;
    var bytes_1 = require_lib2();
    var logger_1 = require_lib();
    var _version_1 = require_version6();
    var logger = new logger_1.Logger(_version_1.version);
    function arrayifyInteger(value) {
      var result = [];
      while (value) {
        result.unshift(value & 255);
        value >>= 8;
      }
      return result;
    }
    function unarrayifyInteger(data, offset, length) {
      var result = 0;
      for (var i = 0; i < length; i++) {
        result = result * 256 + data[offset + i];
      }
      return result;
    }
    function _encode(object) {
      if (Array.isArray(object)) {
        var payload_1 = [];
        object.forEach(function(child) {
          payload_1 = payload_1.concat(_encode(child));
        });
        if (payload_1.length <= 55) {
          payload_1.unshift(192 + payload_1.length);
          return payload_1;
        }
        var length_1 = arrayifyInteger(payload_1.length);
        length_1.unshift(247 + length_1.length);
        return length_1.concat(payload_1);
      }
      if (!(0, bytes_1.isBytesLike)(object)) {
        logger.throwArgumentError("RLP object must be BytesLike", "object", object);
      }
      var data = Array.prototype.slice.call((0, bytes_1.arrayify)(object));
      if (data.length === 1 && data[0] <= 127) {
        return data;
      } else if (data.length <= 55) {
        data.unshift(128 + data.length);
        return data;
      }
      var length = arrayifyInteger(data.length);
      length.unshift(183 + length.length);
      return length.concat(data);
    }
    function encode(object) {
      return (0, bytes_1.hexlify)(_encode(object));
    }
    exports2.encode = encode;
    function _decodeChildren(data, offset, childOffset, length) {
      var result = [];
      while (childOffset < offset + 1 + length) {
        var decoded = _decode(data, childOffset);
        result.push(decoded.result);
        childOffset += decoded.consumed;
        if (childOffset > offset + 1 + length) {
          logger.throwError("child data too short", logger_1.Logger.errors.BUFFER_OVERRUN, {});
        }
      }
      return { consumed: 1 + length, result };
    }
    function _decode(data, offset) {
      if (data.length === 0) {
        logger.throwError("data too short", logger_1.Logger.errors.BUFFER_OVERRUN, {});
      }
      if (data[offset] >= 248) {
        var lengthLength = data[offset] - 247;
        if (offset + 1 + lengthLength > data.length) {
          logger.throwError("data short segment too short", logger_1.Logger.errors.BUFFER_OVERRUN, {});
        }
        var length_2 = unarrayifyInteger(data, offset + 1, lengthLength);
        if (offset + 1 + lengthLength + length_2 > data.length) {
          logger.throwError("data long segment too short", logger_1.Logger.errors.BUFFER_OVERRUN, {});
        }
        return _decodeChildren(data, offset, offset + 1 + lengthLength, lengthLength + length_2);
      } else if (data[offset] >= 192) {
        var length_3 = data[offset] - 192;
        if (offset + 1 + length_3 > data.length) {
          logger.throwError("data array too short", logger_1.Logger.errors.BUFFER_OVERRUN, {});
        }
        return _decodeChildren(data, offset, offset + 1, length_3);
      } else if (data[offset] >= 184) {
        var lengthLength = data[offset] - 183;
        if (offset + 1 + lengthLength > data.length) {
          logger.throwError("data array too short", logger_1.Logger.errors.BUFFER_OVERRUN, {});
        }
        var length_4 = unarrayifyInteger(data, offset + 1, lengthLength);
        if (offset + 1 + lengthLength + length_4 > data.length) {
          logger.throwError("data array too short", logger_1.Logger.errors.BUFFER_OVERRUN, {});
        }
        var result = (0, bytes_1.hexlify)(data.slice(offset + 1 + lengthLength, offset + 1 + lengthLength + length_4));
        return { consumed: 1 + lengthLength + length_4, result };
      } else if (data[offset] >= 128) {
        var length_5 = data[offset] - 128;
        if (offset + 1 + length_5 > data.length) {
          logger.throwError("data too short", logger_1.Logger.errors.BUFFER_OVERRUN, {});
        }
        var result = (0, bytes_1.hexlify)(data.slice(offset + 1, offset + 1 + length_5));
        return { consumed: 1 + length_5, result };
      }
      return { consumed: 1, result: (0, bytes_1.hexlify)(data[offset]) };
    }
    function decode(data) {
      var bytes = (0, bytes_1.arrayify)(data);
      var decoded = _decode(bytes, 0);
      if (decoded.consumed !== bytes.length) {
        logger.throwArgumentError("invalid rlp data", "data", data);
      }
      return decoded.result;
    }
    exports2.decode = decode;
  }
});

// node_modules/@ethersproject/address/lib/_version.js
var require_version7 = __commonJS({
  "node_modules/@ethersproject/address/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "address/5.5.0";
  }
});

// node_modules/@ethersproject/address/lib/index.js
var require_lib7 = __commonJS({
  "node_modules/@ethersproject/address/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getCreate2Address = exports2.getContractAddress = exports2.getIcapAddress = exports2.isAddress = exports2.getAddress = void 0;
    var bytes_1 = require_lib2();
    var bignumber_1 = require_lib3();
    var keccak256_1 = require_lib5();
    var rlp_1 = require_lib6();
    var logger_1 = require_lib();
    var _version_1 = require_version7();
    var logger = new logger_1.Logger(_version_1.version);
    function getChecksumAddress(address) {
      if (!(0, bytes_1.isHexString)(address, 20)) {
        logger.throwArgumentError("invalid address", "address", address);
      }
      address = address.toLowerCase();
      var chars = address.substring(2).split("");
      var expanded = new Uint8Array(40);
      for (var i2 = 0; i2 < 40; i2++) {
        expanded[i2] = chars[i2].charCodeAt(0);
      }
      var hashed = (0, bytes_1.arrayify)((0, keccak256_1.keccak256)(expanded));
      for (var i2 = 0; i2 < 40; i2 += 2) {
        if (hashed[i2 >> 1] >> 4 >= 8) {
          chars[i2] = chars[i2].toUpperCase();
        }
        if ((hashed[i2 >> 1] & 15) >= 8) {
          chars[i2 + 1] = chars[i2 + 1].toUpperCase();
        }
      }
      return "0x" + chars.join("");
    }
    var MAX_SAFE_INTEGER = 9007199254740991;
    function log10(x) {
      if (Math.log10) {
        return Math.log10(x);
      }
      return Math.log(x) / Math.LN10;
    }
    var ibanLookup = {};
    for (i = 0; i < 10; i++) {
      ibanLookup[String(i)] = String(i);
    }
    var i;
    for (i = 0; i < 26; i++) {
      ibanLookup[String.fromCharCode(65 + i)] = String(10 + i);
    }
    var i;
    var safeDigits = Math.floor(log10(MAX_SAFE_INTEGER));
    function ibanChecksum(address) {
      address = address.toUpperCase();
      address = address.substring(4) + address.substring(0, 2) + "00";
      var expanded = address.split("").map(function(c) {
        return ibanLookup[c];
      }).join("");
      while (expanded.length >= safeDigits) {
        var block = expanded.substring(0, safeDigits);
        expanded = parseInt(block, 10) % 97 + expanded.substring(block.length);
      }
      var checksum = String(98 - parseInt(expanded, 10) % 97);
      while (checksum.length < 2) {
        checksum = "0" + checksum;
      }
      return checksum;
    }
    function getAddress(address) {
      var result = null;
      if (typeof address !== "string") {
        logger.throwArgumentError("invalid address", "address", address);
      }
      if (address.match(/^(0x)?[0-9a-fA-F]{40}$/)) {
        if (address.substring(0, 2) !== "0x") {
          address = "0x" + address;
        }
        result = getChecksumAddress(address);
        if (address.match(/([A-F].*[a-f])|([a-f].*[A-F])/) && result !== address) {
          logger.throwArgumentError("bad address checksum", "address", address);
        }
      } else if (address.match(/^XE[0-9]{2}[0-9A-Za-z]{30,31}$/)) {
        if (address.substring(2, 4) !== ibanChecksum(address)) {
          logger.throwArgumentError("bad icap checksum", "address", address);
        }
        result = (0, bignumber_1._base36To16)(address.substring(4));
        while (result.length < 40) {
          result = "0" + result;
        }
        result = getChecksumAddress("0x" + result);
      } else {
        logger.throwArgumentError("invalid address", "address", address);
      }
      return result;
    }
    exports2.getAddress = getAddress;
    function isAddress(address) {
      try {
        getAddress(address);
        return true;
      } catch (error) {
      }
      return false;
    }
    exports2.isAddress = isAddress;
    function getIcapAddress(address) {
      var base36 = (0, bignumber_1._base16To36)(getAddress(address).substring(2)).toUpperCase();
      while (base36.length < 30) {
        base36 = "0" + base36;
      }
      return "XE" + ibanChecksum("XE00" + base36) + base36;
    }
    exports2.getIcapAddress = getIcapAddress;
    function getContractAddress(transaction) {
      var from = null;
      try {
        from = getAddress(transaction.from);
      } catch (error) {
        logger.throwArgumentError("missing from address", "transaction", transaction);
      }
      var nonce = (0, bytes_1.stripZeros)((0, bytes_1.arrayify)(bignumber_1.BigNumber.from(transaction.nonce).toHexString()));
      return getAddress((0, bytes_1.hexDataSlice)((0, keccak256_1.keccak256)((0, rlp_1.encode)([from, nonce])), 12));
    }
    exports2.getContractAddress = getContractAddress;
    function getCreate2Address(from, salt, initCodeHash) {
      if ((0, bytes_1.hexDataLength)(salt) !== 32) {
        logger.throwArgumentError("salt must be 32 bytes", "salt", salt);
      }
      if ((0, bytes_1.hexDataLength)(initCodeHash) !== 32) {
        logger.throwArgumentError("initCodeHash must be 32 bytes", "initCodeHash", initCodeHash);
      }
      return getAddress((0, bytes_1.hexDataSlice)((0, keccak256_1.keccak256)((0, bytes_1.concat)(["0xff", getAddress(from), salt, initCodeHash])), 12));
    }
    exports2.getCreate2Address = getCreate2Address;
  }
});

// node_modules/@ethersproject/abi/lib/coders/address.js
var require_address = __commonJS({
  "node_modules/@ethersproject/abi/lib/coders/address.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AddressCoder = void 0;
    var address_1 = require_lib7();
    var bytes_1 = require_lib2();
    var abstract_coder_1 = require_abstract_coder();
    var AddressCoder = (
      /** @class */
      function(_super) {
        __extends(AddressCoder2, _super);
        function AddressCoder2(localName) {
          return _super.call(this, "address", "address", localName, false) || this;
        }
        AddressCoder2.prototype.defaultValue = function() {
          return "0x0000000000000000000000000000000000000000";
        };
        AddressCoder2.prototype.encode = function(writer, value) {
          try {
            value = (0, address_1.getAddress)(value);
          } catch (error) {
            this._throwError(error.message, value);
          }
          return writer.writeValue(value);
        };
        AddressCoder2.prototype.decode = function(reader) {
          return (0, address_1.getAddress)((0, bytes_1.hexZeroPad)(reader.readValue().toHexString(), 20));
        };
        return AddressCoder2;
      }(abstract_coder_1.Coder)
    );
    exports2.AddressCoder = AddressCoder;
  }
});

// node_modules/@ethersproject/abi/lib/coders/anonymous.js
var require_anonymous = __commonJS({
  "node_modules/@ethersproject/abi/lib/coders/anonymous.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AnonymousCoder = void 0;
    var abstract_coder_1 = require_abstract_coder();
    var AnonymousCoder = (
      /** @class */
      function(_super) {
        __extends(AnonymousCoder2, _super);
        function AnonymousCoder2(coder) {
          var _this = _super.call(this, coder.name, coder.type, void 0, coder.dynamic) || this;
          _this.coder = coder;
          return _this;
        }
        AnonymousCoder2.prototype.defaultValue = function() {
          return this.coder.defaultValue();
        };
        AnonymousCoder2.prototype.encode = function(writer, value) {
          return this.coder.encode(writer, value);
        };
        AnonymousCoder2.prototype.decode = function(reader) {
          return this.coder.decode(reader);
        };
        return AnonymousCoder2;
      }(abstract_coder_1.Coder)
    );
    exports2.AnonymousCoder = AnonymousCoder;
  }
});

// node_modules/@ethersproject/abi/lib/coders/array.js
var require_array = __commonJS({
  "node_modules/@ethersproject/abi/lib/coders/array.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ArrayCoder = exports2.unpack = exports2.pack = void 0;
    var logger_1 = require_lib();
    var _version_1 = require_version5();
    var logger = new logger_1.Logger(_version_1.version);
    var abstract_coder_1 = require_abstract_coder();
    var anonymous_1 = require_anonymous();
    function pack(writer, coders, values) {
      var arrayValues = null;
      if (Array.isArray(values)) {
        arrayValues = values;
      } else if (values && typeof values === "object") {
        var unique_1 = {};
        arrayValues = coders.map(function(coder) {
          var name2 = coder.localName;
          if (!name2) {
            logger.throwError("cannot encode object for signature with missing names", logger_1.Logger.errors.INVALID_ARGUMENT, {
              argument: "values",
              coder,
              value: values
            });
          }
          if (unique_1[name2]) {
            logger.throwError("cannot encode object for signature with duplicate names", logger_1.Logger.errors.INVALID_ARGUMENT, {
              argument: "values",
              coder,
              value: values
            });
          }
          unique_1[name2] = true;
          return values[name2];
        });
      } else {
        logger.throwArgumentError("invalid tuple value", "tuple", values);
      }
      if (coders.length !== arrayValues.length) {
        logger.throwArgumentError("types/value length mismatch", "tuple", values);
      }
      var staticWriter = new abstract_coder_1.Writer(writer.wordSize);
      var dynamicWriter = new abstract_coder_1.Writer(writer.wordSize);
      var updateFuncs = [];
      coders.forEach(function(coder, index) {
        var value = arrayValues[index];
        if (coder.dynamic) {
          var dynamicOffset_1 = dynamicWriter.length;
          coder.encode(dynamicWriter, value);
          var updateFunc_1 = staticWriter.writeUpdatableValue();
          updateFuncs.push(function(baseOffset) {
            updateFunc_1(baseOffset + dynamicOffset_1);
          });
        } else {
          coder.encode(staticWriter, value);
        }
      });
      updateFuncs.forEach(function(func) {
        func(staticWriter.length);
      });
      var length = writer.appendWriter(staticWriter);
      length += writer.appendWriter(dynamicWriter);
      return length;
    }
    exports2.pack = pack;
    function unpack(reader, coders) {
      var values = [];
      var baseReader = reader.subReader(0);
      coders.forEach(function(coder) {
        var value = null;
        if (coder.dynamic) {
          var offset = reader.readValue();
          var offsetReader = baseReader.subReader(offset.toNumber());
          try {
            value = coder.decode(offsetReader);
          } catch (error) {
            if (error.code === logger_1.Logger.errors.BUFFER_OVERRUN) {
              throw error;
            }
            value = error;
            value.baseType = coder.name;
            value.name = coder.localName;
            value.type = coder.type;
          }
        } else {
          try {
            value = coder.decode(reader);
          } catch (error) {
            if (error.code === logger_1.Logger.errors.BUFFER_OVERRUN) {
              throw error;
            }
            value = error;
            value.baseType = coder.name;
            value.name = coder.localName;
            value.type = coder.type;
          }
        }
        if (value != void 0) {
          values.push(value);
        }
      });
      var uniqueNames = coders.reduce(function(accum, coder) {
        var name2 = coder.localName;
        if (name2) {
          if (!accum[name2]) {
            accum[name2] = 0;
          }
          accum[name2]++;
        }
        return accum;
      }, {});
      coders.forEach(function(coder, index) {
        var name2 = coder.localName;
        if (!name2 || uniqueNames[name2] !== 1) {
          return;
        }
        if (name2 === "length") {
          name2 = "_length";
        }
        if (values[name2] != null) {
          return;
        }
        var value = values[index];
        if (value instanceof Error) {
          Object.defineProperty(values, name2, {
            enumerable: true,
            get: function() {
              throw value;
            }
          });
        } else {
          values[name2] = value;
        }
      });
      var _loop_1 = function(i2) {
        var value = values[i2];
        if (value instanceof Error) {
          Object.defineProperty(values, i2, {
            enumerable: true,
            get: function() {
              throw value;
            }
          });
        }
      };
      for (var i = 0; i < values.length; i++) {
        _loop_1(i);
      }
      return Object.freeze(values);
    }
    exports2.unpack = unpack;
    var ArrayCoder = (
      /** @class */
      function(_super) {
        __extends(ArrayCoder2, _super);
        function ArrayCoder2(coder, length, localName) {
          var _this = this;
          var type = coder.type + "[" + (length >= 0 ? length : "") + "]";
          var dynamic = length === -1 || coder.dynamic;
          _this = _super.call(this, "array", type, localName, dynamic) || this;
          _this.coder = coder;
          _this.length = length;
          return _this;
        }
        ArrayCoder2.prototype.defaultValue = function() {
          var defaultChild = this.coder.defaultValue();
          var result = [];
          for (var i = 0; i < this.length; i++) {
            result.push(defaultChild);
          }
          return result;
        };
        ArrayCoder2.prototype.encode = function(writer, value) {
          if (!Array.isArray(value)) {
            this._throwError("expected array value", value);
          }
          var count = this.length;
          if (count === -1) {
            count = value.length;
            writer.writeValue(value.length);
          }
          logger.checkArgumentCount(value.length, count, "coder array" + (this.localName ? " " + this.localName : ""));
          var coders = [];
          for (var i = 0; i < value.length; i++) {
            coders.push(this.coder);
          }
          return pack(writer, coders, value);
        };
        ArrayCoder2.prototype.decode = function(reader) {
          var count = this.length;
          if (count === -1) {
            count = reader.readValue().toNumber();
            if (count * 32 > reader._data.length) {
              logger.throwError("insufficient data length", logger_1.Logger.errors.BUFFER_OVERRUN, {
                length: reader._data.length,
                count
              });
            }
          }
          var coders = [];
          for (var i = 0; i < count; i++) {
            coders.push(new anonymous_1.AnonymousCoder(this.coder));
          }
          return reader.coerce(this.name, unpack(reader, coders));
        };
        return ArrayCoder2;
      }(abstract_coder_1.Coder)
    );
    exports2.ArrayCoder = ArrayCoder;
  }
});

// node_modules/@ethersproject/abi/lib/coders/boolean.js
var require_boolean = __commonJS({
  "node_modules/@ethersproject/abi/lib/coders/boolean.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.BooleanCoder = void 0;
    var abstract_coder_1 = require_abstract_coder();
    var BooleanCoder = (
      /** @class */
      function(_super) {
        __extends(BooleanCoder2, _super);
        function BooleanCoder2(localName) {
          return _super.call(this, "bool", "bool", localName, false) || this;
        }
        BooleanCoder2.prototype.defaultValue = function() {
          return false;
        };
        BooleanCoder2.prototype.encode = function(writer, value) {
          return writer.writeValue(value ? 1 : 0);
        };
        BooleanCoder2.prototype.decode = function(reader) {
          return reader.coerce(this.type, !reader.readValue().isZero());
        };
        return BooleanCoder2;
      }(abstract_coder_1.Coder)
    );
    exports2.BooleanCoder = BooleanCoder;
  }
});

// node_modules/@ethersproject/abi/lib/coders/bytes.js
var require_bytes = __commonJS({
  "node_modules/@ethersproject/abi/lib/coders/bytes.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.BytesCoder = exports2.DynamicBytesCoder = void 0;
    var bytes_1 = require_lib2();
    var abstract_coder_1 = require_abstract_coder();
    var DynamicBytesCoder = (
      /** @class */
      function(_super) {
        __extends(DynamicBytesCoder2, _super);
        function DynamicBytesCoder2(type, localName) {
          return _super.call(this, type, type, localName, true) || this;
        }
        DynamicBytesCoder2.prototype.defaultValue = function() {
          return "0x";
        };
        DynamicBytesCoder2.prototype.encode = function(writer, value) {
          value = (0, bytes_1.arrayify)(value);
          var length = writer.writeValue(value.length);
          length += writer.writeBytes(value);
          return length;
        };
        DynamicBytesCoder2.prototype.decode = function(reader) {
          return reader.readBytes(reader.readValue().toNumber(), true);
        };
        return DynamicBytesCoder2;
      }(abstract_coder_1.Coder)
    );
    exports2.DynamicBytesCoder = DynamicBytesCoder;
    var BytesCoder = (
      /** @class */
      function(_super) {
        __extends(BytesCoder2, _super);
        function BytesCoder2(localName) {
          return _super.call(this, "bytes", localName) || this;
        }
        BytesCoder2.prototype.decode = function(reader) {
          return reader.coerce(this.name, (0, bytes_1.hexlify)(_super.prototype.decode.call(this, reader)));
        };
        return BytesCoder2;
      }(DynamicBytesCoder)
    );
    exports2.BytesCoder = BytesCoder;
  }
});

// node_modules/@ethersproject/abi/lib/coders/fixed-bytes.js
var require_fixed_bytes = __commonJS({
  "node_modules/@ethersproject/abi/lib/coders/fixed-bytes.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.FixedBytesCoder = void 0;
    var bytes_1 = require_lib2();
    var abstract_coder_1 = require_abstract_coder();
    var FixedBytesCoder = (
      /** @class */
      function(_super) {
        __extends(FixedBytesCoder2, _super);
        function FixedBytesCoder2(size, localName) {
          var _this = this;
          var name2 = "bytes" + String(size);
          _this = _super.call(this, name2, name2, localName, false) || this;
          _this.size = size;
          return _this;
        }
        FixedBytesCoder2.prototype.defaultValue = function() {
          return "0x0000000000000000000000000000000000000000000000000000000000000000".substring(0, 2 + this.size * 2);
        };
        FixedBytesCoder2.prototype.encode = function(writer, value) {
          var data = (0, bytes_1.arrayify)(value);
          if (data.length !== this.size) {
            this._throwError("incorrect data length", value);
          }
          return writer.writeBytes(data);
        };
        FixedBytesCoder2.prototype.decode = function(reader) {
          return reader.coerce(this.name, (0, bytes_1.hexlify)(reader.readBytes(this.size)));
        };
        return FixedBytesCoder2;
      }(abstract_coder_1.Coder)
    );
    exports2.FixedBytesCoder = FixedBytesCoder;
  }
});

// node_modules/@ethersproject/abi/lib/coders/null.js
var require_null = __commonJS({
  "node_modules/@ethersproject/abi/lib/coders/null.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.NullCoder = void 0;
    var abstract_coder_1 = require_abstract_coder();
    var NullCoder = (
      /** @class */
      function(_super) {
        __extends(NullCoder2, _super);
        function NullCoder2(localName) {
          return _super.call(this, "null", "", localName, false) || this;
        }
        NullCoder2.prototype.defaultValue = function() {
          return null;
        };
        NullCoder2.prototype.encode = function(writer, value) {
          if (value != null) {
            this._throwError("not null", value);
          }
          return writer.writeBytes([]);
        };
        NullCoder2.prototype.decode = function(reader) {
          reader.readBytes(0);
          return reader.coerce(this.name, null);
        };
        return NullCoder2;
      }(abstract_coder_1.Coder)
    );
    exports2.NullCoder = NullCoder;
  }
});

// node_modules/@ethersproject/constants/lib/addresses.js
var require_addresses = __commonJS({
  "node_modules/@ethersproject/constants/lib/addresses.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AddressZero = void 0;
    exports2.AddressZero = "0x0000000000000000000000000000000000000000";
  }
});

// node_modules/@ethersproject/constants/lib/bignumbers.js
var require_bignumbers = __commonJS({
  "node_modules/@ethersproject/constants/lib/bignumbers.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.MaxInt256 = exports2.MinInt256 = exports2.MaxUint256 = exports2.WeiPerEther = exports2.Two = exports2.One = exports2.Zero = exports2.NegativeOne = void 0;
    var bignumber_1 = require_lib3();
    var NegativeOne = /* @__PURE__ */ bignumber_1.BigNumber.from(-1);
    exports2.NegativeOne = NegativeOne;
    var Zero = /* @__PURE__ */ bignumber_1.BigNumber.from(0);
    exports2.Zero = Zero;
    var One = /* @__PURE__ */ bignumber_1.BigNumber.from(1);
    exports2.One = One;
    var Two = /* @__PURE__ */ bignumber_1.BigNumber.from(2);
    exports2.Two = Two;
    var WeiPerEther = /* @__PURE__ */ bignumber_1.BigNumber.from("1000000000000000000");
    exports2.WeiPerEther = WeiPerEther;
    var MaxUint256 = /* @__PURE__ */ bignumber_1.BigNumber.from("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff");
    exports2.MaxUint256 = MaxUint256;
    var MinInt256 = /* @__PURE__ */ bignumber_1.BigNumber.from("-0x8000000000000000000000000000000000000000000000000000000000000000");
    exports2.MinInt256 = MinInt256;
    var MaxInt256 = /* @__PURE__ */ bignumber_1.BigNumber.from("0x7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff");
    exports2.MaxInt256 = MaxInt256;
  }
});

// node_modules/@ethersproject/constants/lib/hashes.js
var require_hashes = __commonJS({
  "node_modules/@ethersproject/constants/lib/hashes.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.HashZero = void 0;
    exports2.HashZero = "0x0000000000000000000000000000000000000000000000000000000000000000";
  }
});

// node_modules/@ethersproject/constants/lib/strings.js
var require_strings = __commonJS({
  "node_modules/@ethersproject/constants/lib/strings.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.EtherSymbol = void 0;
    exports2.EtherSymbol = "\u039E";
  }
});

// node_modules/@ethersproject/constants/lib/index.js
var require_lib8 = __commonJS({
  "node_modules/@ethersproject/constants/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.EtherSymbol = exports2.HashZero = exports2.MaxInt256 = exports2.MinInt256 = exports2.MaxUint256 = exports2.WeiPerEther = exports2.Two = exports2.One = exports2.Zero = exports2.NegativeOne = exports2.AddressZero = void 0;
    var addresses_1 = require_addresses();
    Object.defineProperty(exports2, "AddressZero", { enumerable: true, get: function() {
      return addresses_1.AddressZero;
    } });
    var bignumbers_1 = require_bignumbers();
    Object.defineProperty(exports2, "NegativeOne", { enumerable: true, get: function() {
      return bignumbers_1.NegativeOne;
    } });
    Object.defineProperty(exports2, "Zero", { enumerable: true, get: function() {
      return bignumbers_1.Zero;
    } });
    Object.defineProperty(exports2, "One", { enumerable: true, get: function() {
      return bignumbers_1.One;
    } });
    Object.defineProperty(exports2, "Two", { enumerable: true, get: function() {
      return bignumbers_1.Two;
    } });
    Object.defineProperty(exports2, "WeiPerEther", { enumerable: true, get: function() {
      return bignumbers_1.WeiPerEther;
    } });
    Object.defineProperty(exports2, "MaxUint256", { enumerable: true, get: function() {
      return bignumbers_1.MaxUint256;
    } });
    Object.defineProperty(exports2, "MinInt256", { enumerable: true, get: function() {
      return bignumbers_1.MinInt256;
    } });
    Object.defineProperty(exports2, "MaxInt256", { enumerable: true, get: function() {
      return bignumbers_1.MaxInt256;
    } });
    var hashes_1 = require_hashes();
    Object.defineProperty(exports2, "HashZero", { enumerable: true, get: function() {
      return hashes_1.HashZero;
    } });
    var strings_1 = require_strings();
    Object.defineProperty(exports2, "EtherSymbol", { enumerable: true, get: function() {
      return strings_1.EtherSymbol;
    } });
  }
});

// node_modules/@ethersproject/abi/lib/coders/number.js
var require_number = __commonJS({
  "node_modules/@ethersproject/abi/lib/coders/number.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.NumberCoder = void 0;
    var bignumber_1 = require_lib3();
    var constants_1 = require_lib8();
    var abstract_coder_1 = require_abstract_coder();
    var NumberCoder = (
      /** @class */
      function(_super) {
        __extends(NumberCoder2, _super);
        function NumberCoder2(size, signed, localName) {
          var _this = this;
          var name2 = (signed ? "int" : "uint") + size * 8;
          _this = _super.call(this, name2, name2, localName, false) || this;
          _this.size = size;
          _this.signed = signed;
          return _this;
        }
        NumberCoder2.prototype.defaultValue = function() {
          return 0;
        };
        NumberCoder2.prototype.encode = function(writer, value) {
          var v = bignumber_1.BigNumber.from(value);
          var maxUintValue = constants_1.MaxUint256.mask(writer.wordSize * 8);
          if (this.signed) {
            var bounds = maxUintValue.mask(this.size * 8 - 1);
            if (v.gt(bounds) || v.lt(bounds.add(constants_1.One).mul(constants_1.NegativeOne))) {
              this._throwError("value out-of-bounds", value);
            }
          } else if (v.lt(constants_1.Zero) || v.gt(maxUintValue.mask(this.size * 8))) {
            this._throwError("value out-of-bounds", value);
          }
          v = v.toTwos(this.size * 8).mask(this.size * 8);
          if (this.signed) {
            v = v.fromTwos(this.size * 8).toTwos(8 * writer.wordSize);
          }
          return writer.writeValue(v);
        };
        NumberCoder2.prototype.decode = function(reader) {
          var value = reader.readValue().mask(this.size * 8);
          if (this.signed) {
            value = value.fromTwos(this.size * 8);
          }
          return reader.coerce(this.name, value);
        };
        return NumberCoder2;
      }(abstract_coder_1.Coder)
    );
    exports2.NumberCoder = NumberCoder;
  }
});

// node_modules/@ethersproject/strings/lib/_version.js
var require_version8 = __commonJS({
  "node_modules/@ethersproject/strings/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "strings/5.5.0";
  }
});

// node_modules/@ethersproject/strings/lib/utf8.js
var require_utf8 = __commonJS({
  "node_modules/@ethersproject/strings/lib/utf8.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.toUtf8CodePoints = exports2.toUtf8String = exports2._toUtf8String = exports2._toEscapedUtf8String = exports2.toUtf8Bytes = exports2.Utf8ErrorFuncs = exports2.Utf8ErrorReason = exports2.UnicodeNormalizationForm = void 0;
    var bytes_1 = require_lib2();
    var logger_1 = require_lib();
    var _version_1 = require_version8();
    var logger = new logger_1.Logger(_version_1.version);
    var UnicodeNormalizationForm;
    (function(UnicodeNormalizationForm2) {
      UnicodeNormalizationForm2["current"] = "";
      UnicodeNormalizationForm2["NFC"] = "NFC";
      UnicodeNormalizationForm2["NFD"] = "NFD";
      UnicodeNormalizationForm2["NFKC"] = "NFKC";
      UnicodeNormalizationForm2["NFKD"] = "NFKD";
    })(UnicodeNormalizationForm = exports2.UnicodeNormalizationForm || (exports2.UnicodeNormalizationForm = {}));
    var Utf8ErrorReason;
    (function(Utf8ErrorReason2) {
      Utf8ErrorReason2["UNEXPECTED_CONTINUE"] = "unexpected continuation byte";
      Utf8ErrorReason2["BAD_PREFIX"] = "bad codepoint prefix";
      Utf8ErrorReason2["OVERRUN"] = "string overrun";
      Utf8ErrorReason2["MISSING_CONTINUE"] = "missing continuation byte";
      Utf8ErrorReason2["OUT_OF_RANGE"] = "out of UTF-8 range";
      Utf8ErrorReason2["UTF16_SURROGATE"] = "UTF-16 surrogate";
      Utf8ErrorReason2["OVERLONG"] = "overlong representation";
    })(Utf8ErrorReason = exports2.Utf8ErrorReason || (exports2.Utf8ErrorReason = {}));
    function errorFunc(reason, offset, bytes, output, badCodepoint) {
      return logger.throwArgumentError("invalid codepoint at offset " + offset + "; " + reason, "bytes", bytes);
    }
    function ignoreFunc(reason, offset, bytes, output, badCodepoint) {
      if (reason === Utf8ErrorReason.BAD_PREFIX || reason === Utf8ErrorReason.UNEXPECTED_CONTINUE) {
        var i = 0;
        for (var o = offset + 1; o < bytes.length; o++) {
          if (bytes[o] >> 6 !== 2) {
            break;
          }
          i++;
        }
        return i;
      }
      if (reason === Utf8ErrorReason.OVERRUN) {
        return bytes.length - offset - 1;
      }
      return 0;
    }
    function replaceFunc(reason, offset, bytes, output, badCodepoint) {
      if (reason === Utf8ErrorReason.OVERLONG) {
        output.push(badCodepoint);
        return 0;
      }
      output.push(65533);
      return ignoreFunc(reason, offset, bytes, output, badCodepoint);
    }
    exports2.Utf8ErrorFuncs = Object.freeze({
      error: errorFunc,
      ignore: ignoreFunc,
      replace: replaceFunc
    });
    function getUtf8CodePoints(bytes, onError) {
      if (onError == null) {
        onError = exports2.Utf8ErrorFuncs.error;
      }
      bytes = (0, bytes_1.arrayify)(bytes);
      var result = [];
      var i = 0;
      while (i < bytes.length) {
        var c = bytes[i++];
        if (c >> 7 === 0) {
          result.push(c);
          continue;
        }
        var extraLength = null;
        var overlongMask = null;
        if ((c & 224) === 192) {
          extraLength = 1;
          overlongMask = 127;
        } else if ((c & 240) === 224) {
          extraLength = 2;
          overlongMask = 2047;
        } else if ((c & 248) === 240) {
          extraLength = 3;
          overlongMask = 65535;
        } else {
          if ((c & 192) === 128) {
            i += onError(Utf8ErrorReason.UNEXPECTED_CONTINUE, i - 1, bytes, result);
          } else {
            i += onError(Utf8ErrorReason.BAD_PREFIX, i - 1, bytes, result);
          }
          continue;
        }
        if (i - 1 + extraLength >= bytes.length) {
          i += onError(Utf8ErrorReason.OVERRUN, i - 1, bytes, result);
          continue;
        }
        var res = c & (1 << 8 - extraLength - 1) - 1;
        for (var j = 0; j < extraLength; j++) {
          var nextChar = bytes[i];
          if ((nextChar & 192) != 128) {
            i += onError(Utf8ErrorReason.MISSING_CONTINUE, i, bytes, result);
            res = null;
            break;
          }
          ;
          res = res << 6 | nextChar & 63;
          i++;
        }
        if (res === null) {
          continue;
        }
        if (res > 1114111) {
          i += onError(Utf8ErrorReason.OUT_OF_RANGE, i - 1 - extraLength, bytes, result, res);
          continue;
        }
        if (res >= 55296 && res <= 57343) {
          i += onError(Utf8ErrorReason.UTF16_SURROGATE, i - 1 - extraLength, bytes, result, res);
          continue;
        }
        if (res <= overlongMask) {
          i += onError(Utf8ErrorReason.OVERLONG, i - 1 - extraLength, bytes, result, res);
          continue;
        }
        result.push(res);
      }
      return result;
    }
    function toUtf8Bytes(str, form) {
      if (form === void 0) {
        form = UnicodeNormalizationForm.current;
      }
      if (form != UnicodeNormalizationForm.current) {
        logger.checkNormalize();
        str = str.normalize(form);
      }
      var result = [];
      for (var i = 0; i < str.length; i++) {
        var c = str.charCodeAt(i);
        if (c < 128) {
          result.push(c);
        } else if (c < 2048) {
          result.push(c >> 6 | 192);
          result.push(c & 63 | 128);
        } else if ((c & 64512) == 55296) {
          i++;
          var c2 = str.charCodeAt(i);
          if (i >= str.length || (c2 & 64512) !== 56320) {
            throw new Error("invalid utf-8 string");
          }
          var pair = 65536 + ((c & 1023) << 10) + (c2 & 1023);
          result.push(pair >> 18 | 240);
          result.push(pair >> 12 & 63 | 128);
          result.push(pair >> 6 & 63 | 128);
          result.push(pair & 63 | 128);
        } else {
          result.push(c >> 12 | 224);
          result.push(c >> 6 & 63 | 128);
          result.push(c & 63 | 128);
        }
      }
      return (0, bytes_1.arrayify)(result);
    }
    exports2.toUtf8Bytes = toUtf8Bytes;
    function escapeChar(value) {
      var hex = "0000" + value.toString(16);
      return "\\u" + hex.substring(hex.length - 4);
    }
    function _toEscapedUtf8String(bytes, onError) {
      return '"' + getUtf8CodePoints(bytes, onError).map(function(codePoint) {
        if (codePoint < 256) {
          switch (codePoint) {
            case 8:
              return "\\b";
            case 9:
              return "\\t";
            case 10:
              return "\\n";
            case 13:
              return "\\r";
            case 34:
              return '\\"';
            case 92:
              return "\\\\";
          }
          if (codePoint >= 32 && codePoint < 127) {
            return String.fromCharCode(codePoint);
          }
        }
        if (codePoint <= 65535) {
          return escapeChar(codePoint);
        }
        codePoint -= 65536;
        return escapeChar((codePoint >> 10 & 1023) + 55296) + escapeChar((codePoint & 1023) + 56320);
      }).join("") + '"';
    }
    exports2._toEscapedUtf8String = _toEscapedUtf8String;
    function _toUtf8String(codePoints) {
      return codePoints.map(function(codePoint) {
        if (codePoint <= 65535) {
          return String.fromCharCode(codePoint);
        }
        codePoint -= 65536;
        return String.fromCharCode((codePoint >> 10 & 1023) + 55296, (codePoint & 1023) + 56320);
      }).join("");
    }
    exports2._toUtf8String = _toUtf8String;
    function toUtf8String(bytes, onError) {
      return _toUtf8String(getUtf8CodePoints(bytes, onError));
    }
    exports2.toUtf8String = toUtf8String;
    function toUtf8CodePoints(str, form) {
      if (form === void 0) {
        form = UnicodeNormalizationForm.current;
      }
      return getUtf8CodePoints(toUtf8Bytes(str, form));
    }
    exports2.toUtf8CodePoints = toUtf8CodePoints;
  }
});

// node_modules/@ethersproject/strings/lib/bytes32.js
var require_bytes32 = __commonJS({
  "node_modules/@ethersproject/strings/lib/bytes32.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.parseBytes32String = exports2.formatBytes32String = void 0;
    var constants_1 = require_lib8();
    var bytes_1 = require_lib2();
    var utf8_1 = require_utf8();
    function formatBytes32String(text) {
      var bytes = (0, utf8_1.toUtf8Bytes)(text);
      if (bytes.length > 31) {
        throw new Error("bytes32 string must be less than 32 bytes");
      }
      return (0, bytes_1.hexlify)((0, bytes_1.concat)([bytes, constants_1.HashZero]).slice(0, 32));
    }
    exports2.formatBytes32String = formatBytes32String;
    function parseBytes32String(bytes) {
      var data = (0, bytes_1.arrayify)(bytes);
      if (data.length !== 32) {
        throw new Error("invalid bytes32 - not 32 bytes long");
      }
      if (data[31] !== 0) {
        throw new Error("invalid bytes32 string - no null terminator");
      }
      var length = 31;
      while (data[length - 1] === 0) {
        length--;
      }
      return (0, utf8_1.toUtf8String)(data.slice(0, length));
    }
    exports2.parseBytes32String = parseBytes32String;
  }
});

// node_modules/@ethersproject/strings/lib/idna.js
var require_idna = __commonJS({
  "node_modules/@ethersproject/strings/lib/idna.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.nameprep = exports2._nameprepTableC = exports2._nameprepTableB2 = exports2._nameprepTableA1 = void 0;
    var utf8_1 = require_utf8();
    function bytes2(data) {
      if (data.length % 4 !== 0) {
        throw new Error("bad data");
      }
      var result = [];
      for (var i = 0; i < data.length; i += 4) {
        result.push(parseInt(data.substring(i, i + 4), 16));
      }
      return result;
    }
    function createTable(data, func) {
      if (!func) {
        func = function(value) {
          return [parseInt(value, 16)];
        };
      }
      var lo = 0;
      var result = {};
      data.split(",").forEach(function(pair) {
        var comps = pair.split(":");
        lo += parseInt(comps[0], 16);
        result[lo] = func(comps[1]);
      });
      return result;
    }
    function createRangeTable(data) {
      var hi = 0;
      return data.split(",").map(function(v) {
        var comps = v.split("-");
        if (comps.length === 1) {
          comps[1] = "0";
        } else if (comps[1] === "") {
          comps[1] = "1";
        }
        var lo = hi + parseInt(comps[0], 16);
        hi = parseInt(comps[1], 16);
        return { l: lo, h: hi };
      });
    }
    function matchMap(value, ranges) {
      var lo = 0;
      for (var i = 0; i < ranges.length; i++) {
        var range = ranges[i];
        lo += range.l;
        if (value >= lo && value <= lo + range.h && (value - lo) % (range.d || 1) === 0) {
          if (range.e && range.e.indexOf(value - lo) !== -1) {
            continue;
          }
          return range;
        }
      }
      return null;
    }
    var Table_A_1_ranges = createRangeTable("221,13-1b,5f-,40-10,51-f,11-3,3-3,2-2,2-4,8,2,15,2d,28-8,88,48,27-,3-5,11-20,27-,8,28,3-5,12,18,b-a,1c-4,6-16,2-d,2-2,2,1b-4,17-9,8f-,10,f,1f-2,1c-34,33-14e,4,36-,13-,6-2,1a-f,4,9-,3-,17,8,2-2,5-,2,8-,3-,4-8,2-3,3,6-,16-6,2-,7-3,3-,17,8,3,3,3-,2,6-3,3-,4-a,5,2-6,10-b,4,8,2,4,17,8,3,6-,b,4,4-,2-e,2-4,b-10,4,9-,3-,17,8,3-,5-,9-2,3-,4-7,3-3,3,4-3,c-10,3,7-2,4,5-2,3,2,3-2,3-2,4-2,9,4-3,6-2,4,5-8,2-e,d-d,4,9,4,18,b,6-3,8,4,5-6,3-8,3-3,b-11,3,9,4,18,b,6-3,8,4,5-6,3-6,2,3-3,b-11,3,9,4,18,11-3,7-,4,5-8,2-7,3-3,b-11,3,13-2,19,a,2-,8-2,2-3,7,2,9-11,4-b,3b-3,1e-24,3,2-,3,2-,2-5,5,8,4,2,2-,3,e,4-,6,2,7-,b-,3-21,49,23-5,1c-3,9,25,10-,2-2f,23,6,3,8-2,5-5,1b-45,27-9,2a-,2-3,5b-4,45-4,53-5,8,40,2,5-,8,2,5-,28,2,5-,20,2,5-,8,2,5-,8,8,18,20,2,5-,8,28,14-5,1d-22,56-b,277-8,1e-2,52-e,e,8-a,18-8,15-b,e,4,3-b,5e-2,b-15,10,b-5,59-7,2b-555,9d-3,5b-5,17-,7-,27-,7-,9,2,2,2,20-,36,10,f-,7,14-,4,a,54-3,2-6,6-5,9-,1c-10,13-1d,1c-14,3c-,10-6,32-b,240-30,28-18,c-14,a0,115-,3,66-,b-76,5,5-,1d,24,2,5-2,2,8-,35-2,19,f-10,1d-3,311-37f,1b,5a-b,d7-19,d-3,41,57-,68-4,29-3,5f,29-37,2e-2,25-c,2c-2,4e-3,30,78-3,64-,20,19b7-49,51a7-59,48e-2,38-738,2ba5-5b,222f-,3c-94,8-b,6-4,1b,6,2,3,3,6d-20,16e-f,41-,37-7,2e-2,11-f,5-b,18-,b,14,5-3,6,88-,2,bf-2,7-,7-,7-,4-2,8,8-9,8-2ff,20,5-b,1c-b4,27-,27-cbb1,f7-9,28-2,b5-221,56,48,3-,2-,3-,5,d,2,5,3,42,5-,9,8,1d,5,6,2-2,8,153-3,123-3,33-27fd,a6da-5128,21f-5df,3-fffd,3-fffd,3-fffd,3-fffd,3-fffd,3-fffd,3-fffd,3-fffd,3-fffd,3-fffd,3-fffd,3,2-1d,61-ff7d");
    var Table_B_1_flags = "ad,34f,1806,180b,180c,180d,200b,200c,200d,2060,feff".split(",").map(function(v) {
      return parseInt(v, 16);
    });
    var Table_B_2_ranges = [
      { h: 25, s: 32, l: 65 },
      { h: 30, s: 32, e: [23], l: 127 },
      { h: 54, s: 1, e: [48], l: 64, d: 2 },
      { h: 14, s: 1, l: 57, d: 2 },
      { h: 44, s: 1, l: 17, d: 2 },
      { h: 10, s: 1, e: [2, 6, 8], l: 61, d: 2 },
      { h: 16, s: 1, l: 68, d: 2 },
      { h: 84, s: 1, e: [18, 24, 66], l: 19, d: 2 },
      { h: 26, s: 32, e: [17], l: 435 },
      { h: 22, s: 1, l: 71, d: 2 },
      { h: 15, s: 80, l: 40 },
      { h: 31, s: 32, l: 16 },
      { h: 32, s: 1, l: 80, d: 2 },
      { h: 52, s: 1, l: 42, d: 2 },
      { h: 12, s: 1, l: 55, d: 2 },
      { h: 40, s: 1, e: [38], l: 15, d: 2 },
      { h: 14, s: 1, l: 48, d: 2 },
      { h: 37, s: 48, l: 49 },
      { h: 148, s: 1, l: 6351, d: 2 },
      { h: 88, s: 1, l: 160, d: 2 },
      { h: 15, s: 16, l: 704 },
      { h: 25, s: 26, l: 854 },
      { h: 25, s: 32, l: 55915 },
      { h: 37, s: 40, l: 1247 },
      { h: 25, s: -119711, l: 53248 },
      { h: 25, s: -119763, l: 52 },
      { h: 25, s: -119815, l: 52 },
      { h: 25, s: -119867, e: [1, 4, 5, 7, 8, 11, 12, 17], l: 52 },
      { h: 25, s: -119919, l: 52 },
      { h: 24, s: -119971, e: [2, 7, 8, 17], l: 52 },
      { h: 24, s: -120023, e: [2, 7, 13, 15, 16, 17], l: 52 },
      { h: 25, s: -120075, l: 52 },
      { h: 25, s: -120127, l: 52 },
      { h: 25, s: -120179, l: 52 },
      { h: 25, s: -120231, l: 52 },
      { h: 25, s: -120283, l: 52 },
      { h: 25, s: -120335, l: 52 },
      { h: 24, s: -119543, e: [17], l: 56 },
      { h: 24, s: -119601, e: [17], l: 58 },
      { h: 24, s: -119659, e: [17], l: 58 },
      { h: 24, s: -119717, e: [17], l: 58 },
      { h: 24, s: -119775, e: [17], l: 58 }
    ];
    var Table_B_2_lut_abs = createTable("b5:3bc,c3:ff,7:73,2:253,5:254,3:256,1:257,5:259,1:25b,3:260,1:263,2:269,1:268,5:26f,1:272,2:275,7:280,3:283,5:288,3:28a,1:28b,5:292,3f:195,1:1bf,29:19e,125:3b9,8b:3b2,1:3b8,1:3c5,3:3c6,1:3c0,1a:3ba,1:3c1,1:3c3,2:3b8,1:3b5,1bc9:3b9,1c:1f76,1:1f77,f:1f7a,1:1f7b,d:1f78,1:1f79,1:1f7c,1:1f7d,107:63,5:25b,4:68,1:68,1:68,3:69,1:69,1:6c,3:6e,4:70,1:71,1:72,1:72,1:72,7:7a,2:3c9,2:7a,2:6b,1:e5,1:62,1:63,3:65,1:66,2:6d,b:3b3,1:3c0,6:64,1b574:3b8,1a:3c3,20:3b8,1a:3c3,20:3b8,1a:3c3,20:3b8,1a:3c3,20:3b8,1a:3c3");
    var Table_B_2_lut_rel = createTable("179:1,2:1,2:1,5:1,2:1,a:4f,a:1,8:1,2:1,2:1,3:1,5:1,3:1,4:1,2:1,3:1,4:1,8:2,1:1,2:2,1:1,2:2,27:2,195:26,2:25,1:25,1:25,2:40,2:3f,1:3f,33:1,11:-6,1:-9,1ac7:-3a,6d:-8,1:-8,1:-8,1:-8,1:-8,1:-8,1:-8,1:-8,9:-8,1:-8,1:-8,1:-8,1:-8,1:-8,b:-8,1:-8,1:-8,1:-8,1:-8,1:-8,1:-8,1:-8,9:-8,1:-8,1:-8,1:-8,1:-8,1:-8,1:-8,1:-8,9:-8,1:-8,1:-8,1:-8,1:-8,1:-8,c:-8,2:-8,2:-8,2:-8,9:-8,1:-8,1:-8,1:-8,1:-8,1:-8,1:-8,1:-8,49:-8,1:-8,1:-4a,1:-4a,d:-56,1:-56,1:-56,1:-56,d:-8,1:-8,f:-8,1:-8,3:-7");
    var Table_B_2_complex = createTable("df:00730073,51:00690307,19:02BC006E,a7:006A030C,18a:002003B9,16:03B903080301,20:03C503080301,1d7:05650582,190f:00680331,1:00740308,1:0077030A,1:0079030A,1:006102BE,b6:03C50313,2:03C503130300,2:03C503130301,2:03C503130342,2a:1F0003B9,1:1F0103B9,1:1F0203B9,1:1F0303B9,1:1F0403B9,1:1F0503B9,1:1F0603B9,1:1F0703B9,1:1F0003B9,1:1F0103B9,1:1F0203B9,1:1F0303B9,1:1F0403B9,1:1F0503B9,1:1F0603B9,1:1F0703B9,1:1F2003B9,1:1F2103B9,1:1F2203B9,1:1F2303B9,1:1F2403B9,1:1F2503B9,1:1F2603B9,1:1F2703B9,1:1F2003B9,1:1F2103B9,1:1F2203B9,1:1F2303B9,1:1F2403B9,1:1F2503B9,1:1F2603B9,1:1F2703B9,1:1F6003B9,1:1F6103B9,1:1F6203B9,1:1F6303B9,1:1F6403B9,1:1F6503B9,1:1F6603B9,1:1F6703B9,1:1F6003B9,1:1F6103B9,1:1F6203B9,1:1F6303B9,1:1F6403B9,1:1F6503B9,1:1F6603B9,1:1F6703B9,3:1F7003B9,1:03B103B9,1:03AC03B9,2:03B10342,1:03B1034203B9,5:03B103B9,6:1F7403B9,1:03B703B9,1:03AE03B9,2:03B70342,1:03B7034203B9,5:03B703B9,6:03B903080300,1:03B903080301,3:03B90342,1:03B903080342,b:03C503080300,1:03C503080301,1:03C10313,2:03C50342,1:03C503080342,b:1F7C03B9,1:03C903B9,1:03CE03B9,2:03C90342,1:03C9034203B9,5:03C903B9,ac:00720073,5b:00B00063,6:00B00066,d:006E006F,a:0073006D,1:00740065006C,1:0074006D,124f:006800700061,2:00610075,2:006F0076,b:00700061,1:006E0061,1:03BC0061,1:006D0061,1:006B0061,1:006B0062,1:006D0062,1:00670062,3:00700066,1:006E0066,1:03BC0066,4:0068007A,1:006B0068007A,1:006D0068007A,1:00670068007A,1:00740068007A,15:00700061,1:006B00700061,1:006D00700061,1:006700700061,8:00700076,1:006E0076,1:03BC0076,1:006D0076,1:006B0076,1:006D0076,1:00700077,1:006E0077,1:03BC0077,1:006D0077,1:006B0077,1:006D0077,1:006B03C9,1:006D03C9,2:00620071,3:00632215006B0067,1:0063006F002E,1:00640062,1:00670079,2:00680070,2:006B006B,1:006B006D,9:00700068,2:00700070006D,1:00700072,2:00730076,1:00770062,c723:00660066,1:00660069,1:0066006C,1:006600660069,1:00660066006C,1:00730074,1:00730074,d:05740576,1:05740565,1:0574056B,1:057E0576,1:0574056D", bytes2);
    var Table_C_ranges = createRangeTable("80-20,2a0-,39c,32,f71,18e,7f2-f,19-7,30-4,7-5,f81-b,5,a800-20ff,4d1-1f,110,fa-6,d174-7,2e84-,ffff-,ffff-,ffff-,ffff-,ffff-,ffff-,ffff-,ffff-,ffff-,ffff-,ffff-,ffff-,2,1f-5f,ff7f-20001");
    function flatten(values) {
      return values.reduce(function(accum, value) {
        value.forEach(function(value2) {
          accum.push(value2);
        });
        return accum;
      }, []);
    }
    function _nameprepTableA1(codepoint) {
      return !!matchMap(codepoint, Table_A_1_ranges);
    }
    exports2._nameprepTableA1 = _nameprepTableA1;
    function _nameprepTableB2(codepoint) {
      var range = matchMap(codepoint, Table_B_2_ranges);
      if (range) {
        return [codepoint + range.s];
      }
      var codes = Table_B_2_lut_abs[codepoint];
      if (codes) {
        return codes;
      }
      var shift = Table_B_2_lut_rel[codepoint];
      if (shift) {
        return [codepoint + shift[0]];
      }
      var complex = Table_B_2_complex[codepoint];
      if (complex) {
        return complex;
      }
      return null;
    }
    exports2._nameprepTableB2 = _nameprepTableB2;
    function _nameprepTableC(codepoint) {
      return !!matchMap(codepoint, Table_C_ranges);
    }
    exports2._nameprepTableC = _nameprepTableC;
    function nameprep(value) {
      if (value.match(/^[a-z0-9-]*$/i) && value.length <= 59) {
        return value.toLowerCase();
      }
      var codes = (0, utf8_1.toUtf8CodePoints)(value);
      codes = flatten(codes.map(function(code) {
        if (Table_B_1_flags.indexOf(code) >= 0) {
          return [];
        }
        if (code >= 65024 && code <= 65039) {
          return [];
        }
        var codesTableB2 = _nameprepTableB2(code);
        if (codesTableB2) {
          return codesTableB2;
        }
        return [code];
      }));
      codes = (0, utf8_1.toUtf8CodePoints)((0, utf8_1._toUtf8String)(codes), utf8_1.UnicodeNormalizationForm.NFKC);
      codes.forEach(function(code) {
        if (_nameprepTableC(code)) {
          throw new Error("STRINGPREP_CONTAINS_PROHIBITED");
        }
      });
      codes.forEach(function(code) {
        if (_nameprepTableA1(code)) {
          throw new Error("STRINGPREP_CONTAINS_UNASSIGNED");
        }
      });
      var name2 = (0, utf8_1._toUtf8String)(codes);
      if (name2.substring(0, 1) === "-" || name2.substring(2, 4) === "--" || name2.substring(name2.length - 1) === "-") {
        throw new Error("invalid hyphen");
      }
      if (name2.length > 63) {
        throw new Error("too long");
      }
      return name2;
    }
    exports2.nameprep = nameprep;
  }
});

// node_modules/@ethersproject/strings/lib/index.js
var require_lib9 = __commonJS({
  "node_modules/@ethersproject/strings/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.nameprep = exports2.parseBytes32String = exports2.formatBytes32String = exports2.UnicodeNormalizationForm = exports2.Utf8ErrorReason = exports2.Utf8ErrorFuncs = exports2.toUtf8String = exports2.toUtf8CodePoints = exports2.toUtf8Bytes = exports2._toEscapedUtf8String = void 0;
    var bytes32_1 = require_bytes32();
    Object.defineProperty(exports2, "formatBytes32String", { enumerable: true, get: function() {
      return bytes32_1.formatBytes32String;
    } });
    Object.defineProperty(exports2, "parseBytes32String", { enumerable: true, get: function() {
      return bytes32_1.parseBytes32String;
    } });
    var idna_1 = require_idna();
    Object.defineProperty(exports2, "nameprep", { enumerable: true, get: function() {
      return idna_1.nameprep;
    } });
    var utf8_1 = require_utf8();
    Object.defineProperty(exports2, "_toEscapedUtf8String", { enumerable: true, get: function() {
      return utf8_1._toEscapedUtf8String;
    } });
    Object.defineProperty(exports2, "toUtf8Bytes", { enumerable: true, get: function() {
      return utf8_1.toUtf8Bytes;
    } });
    Object.defineProperty(exports2, "toUtf8CodePoints", { enumerable: true, get: function() {
      return utf8_1.toUtf8CodePoints;
    } });
    Object.defineProperty(exports2, "toUtf8String", { enumerable: true, get: function() {
      return utf8_1.toUtf8String;
    } });
    Object.defineProperty(exports2, "UnicodeNormalizationForm", { enumerable: true, get: function() {
      return utf8_1.UnicodeNormalizationForm;
    } });
    Object.defineProperty(exports2, "Utf8ErrorFuncs", { enumerable: true, get: function() {
      return utf8_1.Utf8ErrorFuncs;
    } });
    Object.defineProperty(exports2, "Utf8ErrorReason", { enumerable: true, get: function() {
      return utf8_1.Utf8ErrorReason;
    } });
  }
});

// node_modules/@ethersproject/abi/lib/coders/string.js
var require_string = __commonJS({
  "node_modules/@ethersproject/abi/lib/coders/string.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.StringCoder = void 0;
    var strings_1 = require_lib9();
    var bytes_1 = require_bytes();
    var StringCoder = (
      /** @class */
      function(_super) {
        __extends(StringCoder2, _super);
        function StringCoder2(localName) {
          return _super.call(this, "string", localName) || this;
        }
        StringCoder2.prototype.defaultValue = function() {
          return "";
        };
        StringCoder2.prototype.encode = function(writer, value) {
          return _super.prototype.encode.call(this, writer, (0, strings_1.toUtf8Bytes)(value));
        };
        StringCoder2.prototype.decode = function(reader) {
          return (0, strings_1.toUtf8String)(_super.prototype.decode.call(this, reader));
        };
        return StringCoder2;
      }(bytes_1.DynamicBytesCoder)
    );
    exports2.StringCoder = StringCoder;
  }
});

// node_modules/@ethersproject/abi/lib/coders/tuple.js
var require_tuple = __commonJS({
  "node_modules/@ethersproject/abi/lib/coders/tuple.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.TupleCoder = void 0;
    var abstract_coder_1 = require_abstract_coder();
    var array_1 = require_array();
    var TupleCoder = (
      /** @class */
      function(_super) {
        __extends(TupleCoder2, _super);
        function TupleCoder2(coders, localName) {
          var _this = this;
          var dynamic = false;
          var types = [];
          coders.forEach(function(coder) {
            if (coder.dynamic) {
              dynamic = true;
            }
            types.push(coder.type);
          });
          var type = "tuple(" + types.join(",") + ")";
          _this = _super.call(this, "tuple", type, localName, dynamic) || this;
          _this.coders = coders;
          return _this;
        }
        TupleCoder2.prototype.defaultValue = function() {
          var values = [];
          this.coders.forEach(function(coder) {
            values.push(coder.defaultValue());
          });
          var uniqueNames = this.coders.reduce(function(accum, coder) {
            var name2 = coder.localName;
            if (name2) {
              if (!accum[name2]) {
                accum[name2] = 0;
              }
              accum[name2]++;
            }
            return accum;
          }, {});
          this.coders.forEach(function(coder, index) {
            var name2 = coder.localName;
            if (!name2 || uniqueNames[name2] !== 1) {
              return;
            }
            if (name2 === "length") {
              name2 = "_length";
            }
            if (values[name2] != null) {
              return;
            }
            values[name2] = values[index];
          });
          return Object.freeze(values);
        };
        TupleCoder2.prototype.encode = function(writer, value) {
          return (0, array_1.pack)(writer, this.coders, value);
        };
        TupleCoder2.prototype.decode = function(reader) {
          return reader.coerce(this.name, (0, array_1.unpack)(reader, this.coders));
        };
        return TupleCoder2;
      }(abstract_coder_1.Coder)
    );
    exports2.TupleCoder = TupleCoder;
  }
});

// node_modules/@ethersproject/abi/lib/abi-coder.js
var require_abi_coder = __commonJS({
  "node_modules/@ethersproject/abi/lib/abi-coder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.defaultAbiCoder = exports2.AbiCoder = void 0;
    var bytes_1 = require_lib2();
    var properties_1 = require_lib4();
    var logger_1 = require_lib();
    var _version_1 = require_version5();
    var logger = new logger_1.Logger(_version_1.version);
    var abstract_coder_1 = require_abstract_coder();
    var address_1 = require_address();
    var array_1 = require_array();
    var boolean_1 = require_boolean();
    var bytes_2 = require_bytes();
    var fixed_bytes_1 = require_fixed_bytes();
    var null_1 = require_null();
    var number_1 = require_number();
    var string_1 = require_string();
    var tuple_1 = require_tuple();
    var fragments_1 = require_fragments();
    var paramTypeBytes = new RegExp(/^bytes([0-9]*)$/);
    var paramTypeNumber = new RegExp(/^(u?int)([0-9]*)$/);
    var AbiCoder = (
      /** @class */
      function() {
        function AbiCoder2(coerceFunc) {
          var _newTarget = this.constructor;
          logger.checkNew(_newTarget, AbiCoder2);
          (0, properties_1.defineReadOnly)(this, "coerceFunc", coerceFunc || null);
        }
        AbiCoder2.prototype._getCoder = function(param) {
          var _this = this;
          switch (param.baseType) {
            case "address":
              return new address_1.AddressCoder(param.name);
            case "bool":
              return new boolean_1.BooleanCoder(param.name);
            case "string":
              return new string_1.StringCoder(param.name);
            case "bytes":
              return new bytes_2.BytesCoder(param.name);
            case "array":
              return new array_1.ArrayCoder(this._getCoder(param.arrayChildren), param.arrayLength, param.name);
            case "tuple":
              return new tuple_1.TupleCoder((param.components || []).map(function(component) {
                return _this._getCoder(component);
              }), param.name);
            case "":
              return new null_1.NullCoder(param.name);
          }
          var match = param.type.match(paramTypeNumber);
          if (match) {
            var size = parseInt(match[2] || "256");
            if (size === 0 || size > 256 || size % 8 !== 0) {
              logger.throwArgumentError("invalid " + match[1] + " bit length", "param", param);
            }
            return new number_1.NumberCoder(size / 8, match[1] === "int", param.name);
          }
          match = param.type.match(paramTypeBytes);
          if (match) {
            var size = parseInt(match[1]);
            if (size === 0 || size > 32) {
              logger.throwArgumentError("invalid bytes length", "param", param);
            }
            return new fixed_bytes_1.FixedBytesCoder(size, param.name);
          }
          return logger.throwArgumentError("invalid type", "type", param.type);
        };
        AbiCoder2.prototype._getWordSize = function() {
          return 32;
        };
        AbiCoder2.prototype._getReader = function(data, allowLoose) {
          return new abstract_coder_1.Reader(data, this._getWordSize(), this.coerceFunc, allowLoose);
        };
        AbiCoder2.prototype._getWriter = function() {
          return new abstract_coder_1.Writer(this._getWordSize());
        };
        AbiCoder2.prototype.getDefaultValue = function(types) {
          var _this = this;
          var coders = types.map(function(type) {
            return _this._getCoder(fragments_1.ParamType.from(type));
          });
          var coder = new tuple_1.TupleCoder(coders, "_");
          return coder.defaultValue();
        };
        AbiCoder2.prototype.encode = function(types, values) {
          var _this = this;
          if (types.length !== values.length) {
            logger.throwError("types/values length mismatch", logger_1.Logger.errors.INVALID_ARGUMENT, {
              count: { types: types.length, values: values.length },
              value: { types, values }
            });
          }
          var coders = types.map(function(type) {
            return _this._getCoder(fragments_1.ParamType.from(type));
          });
          var coder = new tuple_1.TupleCoder(coders, "_");
          var writer = this._getWriter();
          coder.encode(writer, values);
          return writer.data;
        };
        AbiCoder2.prototype.decode = function(types, data, loose) {
          var _this = this;
          var coders = types.map(function(type) {
            return _this._getCoder(fragments_1.ParamType.from(type));
          });
          var coder = new tuple_1.TupleCoder(coders, "_");
          return coder.decode(this._getReader((0, bytes_1.arrayify)(data), loose));
        };
        return AbiCoder2;
      }()
    );
    exports2.AbiCoder = AbiCoder;
    exports2.defaultAbiCoder = new AbiCoder();
  }
});

// node_modules/@ethersproject/hash/lib/id.js
var require_id = __commonJS({
  "node_modules/@ethersproject/hash/lib/id.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.id = void 0;
    var keccak256_1 = require_lib5();
    var strings_1 = require_lib9();
    function id(text) {
      return (0, keccak256_1.keccak256)((0, strings_1.toUtf8Bytes)(text));
    }
    exports2.id = id;
  }
});

// node_modules/@ethersproject/hash/lib/_version.js
var require_version9 = __commonJS({
  "node_modules/@ethersproject/hash/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "hash/5.5.0";
  }
});

// node_modules/@ethersproject/hash/lib/namehash.js
var require_namehash = __commonJS({
  "node_modules/@ethersproject/hash/lib/namehash.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.namehash = exports2.isValidName = void 0;
    var bytes_1 = require_lib2();
    var strings_1 = require_lib9();
    var keccak256_1 = require_lib5();
    var logger_1 = require_lib();
    var _version_1 = require_version9();
    var logger = new logger_1.Logger(_version_1.version);
    var Zeros = new Uint8Array(32);
    Zeros.fill(0);
    var Partition = new RegExp("^((.*)\\.)?([^.]+)$");
    function isValidName(name2) {
      try {
        var comps = name2.split(".");
        for (var i = 0; i < comps.length; i++) {
          if ((0, strings_1.nameprep)(comps[i]).length === 0) {
            throw new Error("empty");
          }
        }
        return true;
      } catch (error) {
      }
      return false;
    }
    exports2.isValidName = isValidName;
    function namehash(name2) {
      if (typeof name2 !== "string") {
        logger.throwArgumentError("invalid ENS name; not a string", "name", name2);
      }
      var current = name2;
      var result = Zeros;
      while (current.length) {
        var partition = current.match(Partition);
        if (partition == null || partition[2] === "") {
          logger.throwArgumentError("invalid ENS address; missing component", "name", name2);
        }
        var label = (0, strings_1.toUtf8Bytes)((0, strings_1.nameprep)(partition[3]));
        result = (0, keccak256_1.keccak256)((0, bytes_1.concat)([result, (0, keccak256_1.keccak256)(label)]));
        current = partition[2] || "";
      }
      return (0, bytes_1.hexlify)(result);
    }
    exports2.namehash = namehash;
  }
});

// node_modules/@ethersproject/hash/lib/message.js
var require_message = __commonJS({
  "node_modules/@ethersproject/hash/lib/message.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.hashMessage = exports2.messagePrefix = void 0;
    var bytes_1 = require_lib2();
    var keccak256_1 = require_lib5();
    var strings_1 = require_lib9();
    exports2.messagePrefix = "Ethereum Signed Message:\n";
    function hashMessage(message) {
      if (typeof message === "string") {
        message = (0, strings_1.toUtf8Bytes)(message);
      }
      return (0, keccak256_1.keccak256)((0, bytes_1.concat)([
        (0, strings_1.toUtf8Bytes)(exports2.messagePrefix),
        (0, strings_1.toUtf8Bytes)(String(message.length)),
        message
      ]));
    }
    exports2.hashMessage = hashMessage;
  }
});

// node_modules/@ethersproject/hash/lib/typed-data.js
var require_typed_data = __commonJS({
  "node_modules/@ethersproject/hash/lib/typed-data.js"(exports2) {
    "use strict";
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator = exports2 && exports2.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1) throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return { value: op[1], done: false };
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2]) _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
        if (op[0] & 5) throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
      }
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.TypedDataEncoder = void 0;
    var address_1 = require_lib7();
    var bignumber_1 = require_lib3();
    var bytes_1 = require_lib2();
    var keccak256_1 = require_lib5();
    var properties_1 = require_lib4();
    var logger_1 = require_lib();
    var _version_1 = require_version9();
    var logger = new logger_1.Logger(_version_1.version);
    var id_1 = require_id();
    var padding = new Uint8Array(32);
    padding.fill(0);
    var NegativeOne = bignumber_1.BigNumber.from(-1);
    var Zero = bignumber_1.BigNumber.from(0);
    var One = bignumber_1.BigNumber.from(1);
    var MaxUint256 = bignumber_1.BigNumber.from("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff");
    function hexPadRight(value) {
      var bytes = (0, bytes_1.arrayify)(value);
      var padOffset = bytes.length % 32;
      if (padOffset) {
        return (0, bytes_1.hexConcat)([bytes, padding.slice(padOffset)]);
      }
      return (0, bytes_1.hexlify)(bytes);
    }
    var hexTrue = (0, bytes_1.hexZeroPad)(One.toHexString(), 32);
    var hexFalse = (0, bytes_1.hexZeroPad)(Zero.toHexString(), 32);
    var domainFieldTypes = {
      name: "string",
      version: "string",
      chainId: "uint256",
      verifyingContract: "address",
      salt: "bytes32"
    };
    var domainFieldNames = [
      "name",
      "version",
      "chainId",
      "verifyingContract",
      "salt"
    ];
    function checkString(key) {
      return function(value) {
        if (typeof value !== "string") {
          logger.throwArgumentError("invalid domain value for " + JSON.stringify(key), "domain." + key, value);
        }
        return value;
      };
    }
    var domainChecks = {
      name: checkString("name"),
      version: checkString("version"),
      chainId: function(value) {
        try {
          return bignumber_1.BigNumber.from(value).toString();
        } catch (error) {
        }
        return logger.throwArgumentError('invalid domain value for "chainId"', "domain.chainId", value);
      },
      verifyingContract: function(value) {
        try {
          return (0, address_1.getAddress)(value).toLowerCase();
        } catch (error) {
        }
        return logger.throwArgumentError('invalid domain value "verifyingContract"', "domain.verifyingContract", value);
      },
      salt: function(value) {
        try {
          var bytes = (0, bytes_1.arrayify)(value);
          if (bytes.length !== 32) {
            throw new Error("bad length");
          }
          return (0, bytes_1.hexlify)(bytes);
        } catch (error) {
        }
        return logger.throwArgumentError('invalid domain value "salt"', "domain.salt", value);
      }
    };
    function getBaseEncoder(type) {
      {
        var match = type.match(/^(u?)int(\d*)$/);
        if (match) {
          var signed = match[1] === "";
          var width = parseInt(match[2] || "256");
          if (width % 8 !== 0 || width > 256 || match[2] && match[2] !== String(width)) {
            logger.throwArgumentError("invalid numeric width", "type", type);
          }
          var boundsUpper_1 = MaxUint256.mask(signed ? width - 1 : width);
          var boundsLower_1 = signed ? boundsUpper_1.add(One).mul(NegativeOne) : Zero;
          return function(value) {
            var v = bignumber_1.BigNumber.from(value);
            if (v.lt(boundsLower_1) || v.gt(boundsUpper_1)) {
              logger.throwArgumentError("value out-of-bounds for " + type, "value", value);
            }
            return (0, bytes_1.hexZeroPad)(v.toTwos(256).toHexString(), 32);
          };
        }
      }
      {
        var match = type.match(/^bytes(\d+)$/);
        if (match) {
          var width_1 = parseInt(match[1]);
          if (width_1 === 0 || width_1 > 32 || match[1] !== String(width_1)) {
            logger.throwArgumentError("invalid bytes width", "type", type);
          }
          return function(value) {
            var bytes = (0, bytes_1.arrayify)(value);
            if (bytes.length !== width_1) {
              logger.throwArgumentError("invalid length for " + type, "value", value);
            }
            return hexPadRight(value);
          };
        }
      }
      switch (type) {
        case "address":
          return function(value) {
            return (0, bytes_1.hexZeroPad)((0, address_1.getAddress)(value), 32);
          };
        case "bool":
          return function(value) {
            return !value ? hexFalse : hexTrue;
          };
        case "bytes":
          return function(value) {
            return (0, keccak256_1.keccak256)(value);
          };
        case "string":
          return function(value) {
            return (0, id_1.id)(value);
          };
      }
      return null;
    }
    function encodeType(name2, fields) {
      return name2 + "(" + fields.map(function(_a) {
        var name3 = _a.name, type = _a.type;
        return type + " " + name3;
      }).join(",") + ")";
    }
    var TypedDataEncoder = (
      /** @class */
      function() {
        function TypedDataEncoder2(types) {
          (0, properties_1.defineReadOnly)(this, "types", Object.freeze((0, properties_1.deepCopy)(types)));
          (0, properties_1.defineReadOnly)(this, "_encoderCache", {});
          (0, properties_1.defineReadOnly)(this, "_types", {});
          var links = {};
          var parents = {};
          var subtypes = {};
          Object.keys(types).forEach(function(type) {
            links[type] = {};
            parents[type] = [];
            subtypes[type] = {};
          });
          var _loop_1 = function(name_12) {
            var uniqueNames = {};
            types[name_12].forEach(function(field) {
              if (uniqueNames[field.name]) {
                logger.throwArgumentError("duplicate variable name " + JSON.stringify(field.name) + " in " + JSON.stringify(name_12), "types", types);
              }
              uniqueNames[field.name] = true;
              var baseType = field.type.match(/^([^\x5b]*)(\x5b|$)/)[1];
              if (baseType === name_12) {
                logger.throwArgumentError("circular type reference to " + JSON.stringify(baseType), "types", types);
              }
              var encoder = getBaseEncoder(baseType);
              if (encoder) {
                return;
              }
              if (!parents[baseType]) {
                logger.throwArgumentError("unknown type " + JSON.stringify(baseType), "types", types);
              }
              parents[baseType].push(name_12);
              links[name_12][baseType] = true;
            });
          };
          for (var name_1 in types) {
            _loop_1(name_1);
          }
          var primaryTypes = Object.keys(parents).filter(function(n) {
            return parents[n].length === 0;
          });
          if (primaryTypes.length === 0) {
            logger.throwArgumentError("missing primary type", "types", types);
          } else if (primaryTypes.length > 1) {
            logger.throwArgumentError("ambiguous primary types or unused types: " + primaryTypes.map(function(t) {
              return JSON.stringify(t);
            }).join(", "), "types", types);
          }
          (0, properties_1.defineReadOnly)(this, "primaryType", primaryTypes[0]);
          function checkCircular(type, found) {
            if (found[type]) {
              logger.throwArgumentError("circular type reference to " + JSON.stringify(type), "types", types);
            }
            found[type] = true;
            Object.keys(links[type]).forEach(function(child) {
              if (!parents[child]) {
                return;
              }
              checkCircular(child, found);
              Object.keys(found).forEach(function(subtype) {
                subtypes[subtype][child] = true;
              });
            });
            delete found[type];
          }
          checkCircular(this.primaryType, {});
          for (var name_2 in subtypes) {
            var st = Object.keys(subtypes[name_2]);
            st.sort();
            this._types[name_2] = encodeType(name_2, types[name_2]) + st.map(function(t) {
              return encodeType(t, types[t]);
            }).join("");
          }
        }
        TypedDataEncoder2.prototype.getEncoder = function(type) {
          var encoder = this._encoderCache[type];
          if (!encoder) {
            encoder = this._encoderCache[type] = this._getEncoder(type);
          }
          return encoder;
        };
        TypedDataEncoder2.prototype._getEncoder = function(type) {
          var _this = this;
          {
            var encoder = getBaseEncoder(type);
            if (encoder) {
              return encoder;
            }
          }
          var match = type.match(/^(.*)(\x5b(\d*)\x5d)$/);
          if (match) {
            var subtype_1 = match[1];
            var subEncoder_1 = this.getEncoder(subtype_1);
            var length_1 = parseInt(match[3]);
            return function(value) {
              if (length_1 >= 0 && value.length !== length_1) {
                logger.throwArgumentError("array length mismatch; expected length ${ arrayLength }", "value", value);
              }
              var result = value.map(subEncoder_1);
              if (_this._types[subtype_1]) {
                result = result.map(keccak256_1.keccak256);
              }
              return (0, keccak256_1.keccak256)((0, bytes_1.hexConcat)(result));
            };
          }
          var fields = this.types[type];
          if (fields) {
            var encodedType_1 = (0, id_1.id)(this._types[type]);
            return function(value) {
              var values = fields.map(function(_a) {
                var name2 = _a.name, type2 = _a.type;
                var result = _this.getEncoder(type2)(value[name2]);
                if (_this._types[type2]) {
                  return (0, keccak256_1.keccak256)(result);
                }
                return result;
              });
              values.unshift(encodedType_1);
              return (0, bytes_1.hexConcat)(values);
            };
          }
          return logger.throwArgumentError("unknown type: " + type, "type", type);
        };
        TypedDataEncoder2.prototype.encodeType = function(name2) {
          var result = this._types[name2];
          if (!result) {
            logger.throwArgumentError("unknown type: " + JSON.stringify(name2), "name", name2);
          }
          return result;
        };
        TypedDataEncoder2.prototype.encodeData = function(type, value) {
          return this.getEncoder(type)(value);
        };
        TypedDataEncoder2.prototype.hashStruct = function(name2, value) {
          return (0, keccak256_1.keccak256)(this.encodeData(name2, value));
        };
        TypedDataEncoder2.prototype.encode = function(value) {
          return this.encodeData(this.primaryType, value);
        };
        TypedDataEncoder2.prototype.hash = function(value) {
          return this.hashStruct(this.primaryType, value);
        };
        TypedDataEncoder2.prototype._visit = function(type, value, callback) {
          var _this = this;
          {
            var encoder = getBaseEncoder(type);
            if (encoder) {
              return callback(type, value);
            }
          }
          var match = type.match(/^(.*)(\x5b(\d*)\x5d)$/);
          if (match) {
            var subtype_2 = match[1];
            var length_2 = parseInt(match[3]);
            if (length_2 >= 0 && value.length !== length_2) {
              logger.throwArgumentError("array length mismatch; expected length ${ arrayLength }", "value", value);
            }
            return value.map(function(v) {
              return _this._visit(subtype_2, v, callback);
            });
          }
          var fields = this.types[type];
          if (fields) {
            return fields.reduce(function(accum, _a) {
              var name2 = _a.name, type2 = _a.type;
              accum[name2] = _this._visit(type2, value[name2], callback);
              return accum;
            }, {});
          }
          return logger.throwArgumentError("unknown type: " + type, "type", type);
        };
        TypedDataEncoder2.prototype.visit = function(value, callback) {
          return this._visit(this.primaryType, value, callback);
        };
        TypedDataEncoder2.from = function(types) {
          return new TypedDataEncoder2(types);
        };
        TypedDataEncoder2.getPrimaryType = function(types) {
          return TypedDataEncoder2.from(types).primaryType;
        };
        TypedDataEncoder2.hashStruct = function(name2, types, value) {
          return TypedDataEncoder2.from(types).hashStruct(name2, value);
        };
        TypedDataEncoder2.hashDomain = function(domain) {
          var domainFields = [];
          for (var name_3 in domain) {
            var type = domainFieldTypes[name_3];
            if (!type) {
              logger.throwArgumentError("invalid typed-data domain key: " + JSON.stringify(name_3), "domain", domain);
            }
            domainFields.push({ name: name_3, type });
          }
          domainFields.sort(function(a, b) {
            return domainFieldNames.indexOf(a.name) - domainFieldNames.indexOf(b.name);
          });
          return TypedDataEncoder2.hashStruct("EIP712Domain", { EIP712Domain: domainFields }, domain);
        };
        TypedDataEncoder2.encode = function(domain, types, value) {
          return (0, bytes_1.hexConcat)([
            "0x1901",
            TypedDataEncoder2.hashDomain(domain),
            TypedDataEncoder2.from(types).hash(value)
          ]);
        };
        TypedDataEncoder2.hash = function(domain, types, value) {
          return (0, keccak256_1.keccak256)(TypedDataEncoder2.encode(domain, types, value));
        };
        TypedDataEncoder2.resolveNames = function(domain, types, value, resolveName) {
          return __awaiter(this, void 0, void 0, function() {
            var ensCache, encoder, _a, _b, _i, name_4, _c, _d;
            return __generator(this, function(_e) {
              switch (_e.label) {
                case 0:
                  domain = (0, properties_1.shallowCopy)(domain);
                  ensCache = {};
                  if (domain.verifyingContract && !(0, bytes_1.isHexString)(domain.verifyingContract, 20)) {
                    ensCache[domain.verifyingContract] = "0x";
                  }
                  encoder = TypedDataEncoder2.from(types);
                  encoder.visit(value, function(type, value2) {
                    if (type === "address" && !(0, bytes_1.isHexString)(value2, 20)) {
                      ensCache[value2] = "0x";
                    }
                    return value2;
                  });
                  _a = [];
                  for (_b in ensCache)
                    _a.push(_b);
                  _i = 0;
                  _e.label = 1;
                case 1:
                  if (!(_i < _a.length)) return [3, 4];
                  name_4 = _a[_i];
                  _c = ensCache;
                  _d = name_4;
                  return [4, resolveName(name_4)];
                case 2:
                  _c[_d] = _e.sent();
                  _e.label = 3;
                case 3:
                  _i++;
                  return [3, 1];
                case 4:
                  if (domain.verifyingContract && ensCache[domain.verifyingContract]) {
                    domain.verifyingContract = ensCache[domain.verifyingContract];
                  }
                  value = encoder.visit(value, function(type, value2) {
                    if (type === "address" && ensCache[value2]) {
                      return ensCache[value2];
                    }
                    return value2;
                  });
                  return [2, { domain, value }];
              }
            });
          });
        };
        TypedDataEncoder2.getPayload = function(domain, types, value) {
          TypedDataEncoder2.hashDomain(domain);
          var domainValues = {};
          var domainTypes = [];
          domainFieldNames.forEach(function(name2) {
            var value2 = domain[name2];
            if (value2 == null) {
              return;
            }
            domainValues[name2] = domainChecks[name2](value2);
            domainTypes.push({ name: name2, type: domainFieldTypes[name2] });
          });
          var encoder = TypedDataEncoder2.from(types);
          var typesWithDomain = (0, properties_1.shallowCopy)(types);
          if (typesWithDomain.EIP712Domain) {
            logger.throwArgumentError("types must not contain EIP712Domain type", "types.EIP712Domain", types);
          } else {
            typesWithDomain.EIP712Domain = domainTypes;
          }
          encoder.encode(value);
          return {
            types: typesWithDomain,
            domain: domainValues,
            primaryType: encoder.primaryType,
            message: encoder.visit(value, function(type, value2) {
              if (type.match(/^bytes(\d*)/)) {
                return (0, bytes_1.hexlify)((0, bytes_1.arrayify)(value2));
              }
              if (type.match(/^u?int/)) {
                return bignumber_1.BigNumber.from(value2).toString();
              }
              switch (type) {
                case "address":
                  return value2.toLowerCase();
                case "bool":
                  return !!value2;
                case "string":
                  if (typeof value2 !== "string") {
                    logger.throwArgumentError("invalid string", "value", value2);
                  }
                  return value2;
              }
              return logger.throwArgumentError("unsupported type", "type", type);
            })
          };
        };
        return TypedDataEncoder2;
      }()
    );
    exports2.TypedDataEncoder = TypedDataEncoder;
  }
});

// node_modules/@ethersproject/hash/lib/index.js
var require_lib10 = __commonJS({
  "node_modules/@ethersproject/hash/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2._TypedDataEncoder = exports2.hashMessage = exports2.messagePrefix = exports2.isValidName = exports2.namehash = exports2.id = void 0;
    var id_1 = require_id();
    Object.defineProperty(exports2, "id", { enumerable: true, get: function() {
      return id_1.id;
    } });
    var namehash_1 = require_namehash();
    Object.defineProperty(exports2, "isValidName", { enumerable: true, get: function() {
      return namehash_1.isValidName;
    } });
    Object.defineProperty(exports2, "namehash", { enumerable: true, get: function() {
      return namehash_1.namehash;
    } });
    var message_1 = require_message();
    Object.defineProperty(exports2, "hashMessage", { enumerable: true, get: function() {
      return message_1.hashMessage;
    } });
    Object.defineProperty(exports2, "messagePrefix", { enumerable: true, get: function() {
      return message_1.messagePrefix;
    } });
    var typed_data_1 = require_typed_data();
    Object.defineProperty(exports2, "_TypedDataEncoder", { enumerable: true, get: function() {
      return typed_data_1.TypedDataEncoder;
    } });
  }
});

// node_modules/@ethersproject/abi/lib/interface.js
var require_interface = __commonJS({
  "node_modules/@ethersproject/abi/lib/interface.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Interface = exports2.Indexed = exports2.ErrorDescription = exports2.TransactionDescription = exports2.LogDescription = exports2.checkResultErrors = void 0;
    var address_1 = require_lib7();
    var bignumber_1 = require_lib3();
    var bytes_1 = require_lib2();
    var hash_1 = require_lib10();
    var keccak256_1 = require_lib5();
    var properties_1 = require_lib4();
    var abi_coder_1 = require_abi_coder();
    var abstract_coder_1 = require_abstract_coder();
    Object.defineProperty(exports2, "checkResultErrors", { enumerable: true, get: function() {
      return abstract_coder_1.checkResultErrors;
    } });
    var fragments_1 = require_fragments();
    var logger_1 = require_lib();
    var _version_1 = require_version5();
    var logger = new logger_1.Logger(_version_1.version);
    var LogDescription = (
      /** @class */
      function(_super) {
        __extends(LogDescription2, _super);
        function LogDescription2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        return LogDescription2;
      }(properties_1.Description)
    );
    exports2.LogDescription = LogDescription;
    var TransactionDescription = (
      /** @class */
      function(_super) {
        __extends(TransactionDescription2, _super);
        function TransactionDescription2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        return TransactionDescription2;
      }(properties_1.Description)
    );
    exports2.TransactionDescription = TransactionDescription;
    var ErrorDescription = (
      /** @class */
      function(_super) {
        __extends(ErrorDescription2, _super);
        function ErrorDescription2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        return ErrorDescription2;
      }(properties_1.Description)
    );
    exports2.ErrorDescription = ErrorDescription;
    var Indexed = (
      /** @class */
      function(_super) {
        __extends(Indexed2, _super);
        function Indexed2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Indexed2.isIndexed = function(value) {
          return !!(value && value._isIndexed);
        };
        return Indexed2;
      }(properties_1.Description)
    );
    exports2.Indexed = Indexed;
    var BuiltinErrors = {
      "0x08c379a0": { signature: "Error(string)", name: "Error", inputs: ["string"], reason: true },
      "0x4e487b71": { signature: "Panic(uint256)", name: "Panic", inputs: ["uint256"] }
    };
    function wrapAccessError(property, error) {
      var wrap = new Error("deferred error during ABI decoding triggered accessing " + property);
      wrap.error = error;
      return wrap;
    }
    var Interface = (
      /** @class */
      function() {
        function Interface2(fragments) {
          var _newTarget = this.constructor;
          var _this = this;
          logger.checkNew(_newTarget, Interface2);
          var abi = [];
          if (typeof fragments === "string") {
            abi = JSON.parse(fragments);
          } else {
            abi = fragments;
          }
          (0, properties_1.defineReadOnly)(this, "fragments", abi.map(function(fragment) {
            return fragments_1.Fragment.from(fragment);
          }).filter(function(fragment) {
            return fragment != null;
          }));
          (0, properties_1.defineReadOnly)(this, "_abiCoder", (0, properties_1.getStatic)(_newTarget, "getAbiCoder")());
          (0, properties_1.defineReadOnly)(this, "functions", {});
          (0, properties_1.defineReadOnly)(this, "errors", {});
          (0, properties_1.defineReadOnly)(this, "events", {});
          (0, properties_1.defineReadOnly)(this, "structs", {});
          this.fragments.forEach(function(fragment) {
            var bucket = null;
            switch (fragment.type) {
              case "constructor":
                if (_this.deploy) {
                  logger.warn("duplicate definition - constructor");
                  return;
                }
                (0, properties_1.defineReadOnly)(_this, "deploy", fragment);
                return;
              case "function":
                bucket = _this.functions;
                break;
              case "event":
                bucket = _this.events;
                break;
              case "error":
                bucket = _this.errors;
                break;
              default:
                return;
            }
            var signature = fragment.format();
            if (bucket[signature]) {
              logger.warn("duplicate definition - " + signature);
              return;
            }
            bucket[signature] = fragment;
          });
          if (!this.deploy) {
            (0, properties_1.defineReadOnly)(this, "deploy", fragments_1.ConstructorFragment.from({
              payable: false,
              type: "constructor"
            }));
          }
          (0, properties_1.defineReadOnly)(this, "_isInterface", true);
        }
        Interface2.prototype.format = function(format) {
          if (!format) {
            format = fragments_1.FormatTypes.full;
          }
          if (format === fragments_1.FormatTypes.sighash) {
            logger.throwArgumentError("interface does not support formatting sighash", "format", format);
          }
          var abi = this.fragments.map(function(fragment) {
            return fragment.format(format);
          });
          if (format === fragments_1.FormatTypes.json) {
            return JSON.stringify(abi.map(function(j) {
              return JSON.parse(j);
            }));
          }
          return abi;
        };
        Interface2.getAbiCoder = function() {
          return abi_coder_1.defaultAbiCoder;
        };
        Interface2.getAddress = function(address) {
          return (0, address_1.getAddress)(address);
        };
        Interface2.getSighash = function(fragment) {
          return (0, bytes_1.hexDataSlice)((0, hash_1.id)(fragment.format()), 0, 4);
        };
        Interface2.getEventTopic = function(eventFragment) {
          return (0, hash_1.id)(eventFragment.format());
        };
        Interface2.prototype.getFunction = function(nameOrSignatureOrSighash) {
          if ((0, bytes_1.isHexString)(nameOrSignatureOrSighash)) {
            for (var name_1 in this.functions) {
              if (nameOrSignatureOrSighash === this.getSighash(name_1)) {
                return this.functions[name_1];
              }
            }
            logger.throwArgumentError("no matching function", "sighash", nameOrSignatureOrSighash);
          }
          if (nameOrSignatureOrSighash.indexOf("(") === -1) {
            var name_2 = nameOrSignatureOrSighash.trim();
            var matching = Object.keys(this.functions).filter(function(f) {
              return f.split(
                "("
                /* fix:) */
              )[0] === name_2;
            });
            if (matching.length === 0) {
              logger.throwArgumentError("no matching function", "name", name_2);
            } else if (matching.length > 1) {
              logger.throwArgumentError("multiple matching functions", "name", name_2);
            }
            return this.functions[matching[0]];
          }
          var result = this.functions[fragments_1.FunctionFragment.fromString(nameOrSignatureOrSighash).format()];
          if (!result) {
            logger.throwArgumentError("no matching function", "signature", nameOrSignatureOrSighash);
          }
          return result;
        };
        Interface2.prototype.getEvent = function(nameOrSignatureOrTopic) {
          if ((0, bytes_1.isHexString)(nameOrSignatureOrTopic)) {
            var topichash = nameOrSignatureOrTopic.toLowerCase();
            for (var name_3 in this.events) {
              if (topichash === this.getEventTopic(name_3)) {
                return this.events[name_3];
              }
            }
            logger.throwArgumentError("no matching event", "topichash", topichash);
          }
          if (nameOrSignatureOrTopic.indexOf("(") === -1) {
            var name_4 = nameOrSignatureOrTopic.trim();
            var matching = Object.keys(this.events).filter(function(f) {
              return f.split(
                "("
                /* fix:) */
              )[0] === name_4;
            });
            if (matching.length === 0) {
              logger.throwArgumentError("no matching event", "name", name_4);
            } else if (matching.length > 1) {
              logger.throwArgumentError("multiple matching events", "name", name_4);
            }
            return this.events[matching[0]];
          }
          var result = this.events[fragments_1.EventFragment.fromString(nameOrSignatureOrTopic).format()];
          if (!result) {
            logger.throwArgumentError("no matching event", "signature", nameOrSignatureOrTopic);
          }
          return result;
        };
        Interface2.prototype.getError = function(nameOrSignatureOrSighash) {
          if ((0, bytes_1.isHexString)(nameOrSignatureOrSighash)) {
            var getSighash = (0, properties_1.getStatic)(this.constructor, "getSighash");
            for (var name_5 in this.errors) {
              var error = this.errors[name_5];
              if (nameOrSignatureOrSighash === getSighash(error)) {
                return this.errors[name_5];
              }
            }
            logger.throwArgumentError("no matching error", "sighash", nameOrSignatureOrSighash);
          }
          if (nameOrSignatureOrSighash.indexOf("(") === -1) {
            var name_6 = nameOrSignatureOrSighash.trim();
            var matching = Object.keys(this.errors).filter(function(f) {
              return f.split(
                "("
                /* fix:) */
              )[0] === name_6;
            });
            if (matching.length === 0) {
              logger.throwArgumentError("no matching error", "name", name_6);
            } else if (matching.length > 1) {
              logger.throwArgumentError("multiple matching errors", "name", name_6);
            }
            return this.errors[matching[0]];
          }
          var result = this.errors[fragments_1.FunctionFragment.fromString(nameOrSignatureOrSighash).format()];
          if (!result) {
            logger.throwArgumentError("no matching error", "signature", nameOrSignatureOrSighash);
          }
          return result;
        };
        Interface2.prototype.getSighash = function(fragment) {
          if (typeof fragment === "string") {
            try {
              fragment = this.getFunction(fragment);
            } catch (error) {
              try {
                fragment = this.getError(fragment);
              } catch (_) {
                throw error;
              }
            }
          }
          return (0, properties_1.getStatic)(this.constructor, "getSighash")(fragment);
        };
        Interface2.prototype.getEventTopic = function(eventFragment) {
          if (typeof eventFragment === "string") {
            eventFragment = this.getEvent(eventFragment);
          }
          return (0, properties_1.getStatic)(this.constructor, "getEventTopic")(eventFragment);
        };
        Interface2.prototype._decodeParams = function(params, data) {
          return this._abiCoder.decode(params, data);
        };
        Interface2.prototype._encodeParams = function(params, values) {
          return this._abiCoder.encode(params, values);
        };
        Interface2.prototype.encodeDeploy = function(values) {
          return this._encodeParams(this.deploy.inputs, values || []);
        };
        Interface2.prototype.decodeErrorResult = function(fragment, data) {
          if (typeof fragment === "string") {
            fragment = this.getError(fragment);
          }
          var bytes = (0, bytes_1.arrayify)(data);
          if ((0, bytes_1.hexlify)(bytes.slice(0, 4)) !== this.getSighash(fragment)) {
            logger.throwArgumentError("data signature does not match error " + fragment.name + ".", "data", (0, bytes_1.hexlify)(bytes));
          }
          return this._decodeParams(fragment.inputs, bytes.slice(4));
        };
        Interface2.prototype.encodeErrorResult = function(fragment, values) {
          if (typeof fragment === "string") {
            fragment = this.getError(fragment);
          }
          return (0, bytes_1.hexlify)((0, bytes_1.concat)([
            this.getSighash(fragment),
            this._encodeParams(fragment.inputs, values || [])
          ]));
        };
        Interface2.prototype.decodeFunctionData = function(functionFragment, data) {
          if (typeof functionFragment === "string") {
            functionFragment = this.getFunction(functionFragment);
          }
          var bytes = (0, bytes_1.arrayify)(data);
          if ((0, bytes_1.hexlify)(bytes.slice(0, 4)) !== this.getSighash(functionFragment)) {
            logger.throwArgumentError("data signature does not match function " + functionFragment.name + ".", "data", (0, bytes_1.hexlify)(bytes));
          }
          return this._decodeParams(functionFragment.inputs, bytes.slice(4));
        };
        Interface2.prototype.encodeFunctionData = function(functionFragment, values) {
          if (typeof functionFragment === "string") {
            functionFragment = this.getFunction(functionFragment);
          }
          return (0, bytes_1.hexlify)((0, bytes_1.concat)([
            this.getSighash(functionFragment),
            this._encodeParams(functionFragment.inputs, values || [])
          ]));
        };
        Interface2.prototype.decodeFunctionResult = function(functionFragment, data) {
          if (typeof functionFragment === "string") {
            functionFragment = this.getFunction(functionFragment);
          }
          var bytes = (0, bytes_1.arrayify)(data);
          var reason = null;
          var errorArgs = null;
          var errorName = null;
          var errorSignature = null;
          switch (bytes.length % this._abiCoder._getWordSize()) {
            case 0:
              try {
                return this._abiCoder.decode(functionFragment.outputs, bytes);
              } catch (error2) {
              }
              break;
            case 4: {
              var selector = (0, bytes_1.hexlify)(bytes.slice(0, 4));
              var builtin = BuiltinErrors[selector];
              if (builtin) {
                errorArgs = this._abiCoder.decode(builtin.inputs, bytes.slice(4));
                errorName = builtin.name;
                errorSignature = builtin.signature;
                if (builtin.reason) {
                  reason = errorArgs[0];
                }
              } else {
                try {
                  var error = this.getError(selector);
                  errorArgs = this._abiCoder.decode(error.inputs, bytes.slice(4));
                  errorName = error.name;
                  errorSignature = error.format();
                } catch (error2) {
                  console.log(error2);
                }
              }
              break;
            }
          }
          return logger.throwError("call revert exception", logger_1.Logger.errors.CALL_EXCEPTION, {
            method: functionFragment.format(),
            errorArgs,
            errorName,
            errorSignature,
            reason
          });
        };
        Interface2.prototype.encodeFunctionResult = function(functionFragment, values) {
          if (typeof functionFragment === "string") {
            functionFragment = this.getFunction(functionFragment);
          }
          return (0, bytes_1.hexlify)(this._abiCoder.encode(functionFragment.outputs, values || []));
        };
        Interface2.prototype.encodeFilterTopics = function(eventFragment, values) {
          var _this = this;
          if (typeof eventFragment === "string") {
            eventFragment = this.getEvent(eventFragment);
          }
          if (values.length > eventFragment.inputs.length) {
            logger.throwError("too many arguments for " + eventFragment.format(), logger_1.Logger.errors.UNEXPECTED_ARGUMENT, {
              argument: "values",
              value: values
            });
          }
          var topics = [];
          if (!eventFragment.anonymous) {
            topics.push(this.getEventTopic(eventFragment));
          }
          var encodeTopic = function(param, value) {
            if (param.type === "string") {
              return (0, hash_1.id)(value);
            } else if (param.type === "bytes") {
              return (0, keccak256_1.keccak256)((0, bytes_1.hexlify)(value));
            }
            if (param.type === "address") {
              _this._abiCoder.encode(["address"], [value]);
            }
            return (0, bytes_1.hexZeroPad)((0, bytes_1.hexlify)(value), 32);
          };
          values.forEach(function(value, index) {
            var param = eventFragment.inputs[index];
            if (!param.indexed) {
              if (value != null) {
                logger.throwArgumentError("cannot filter non-indexed parameters; must be null", "contract." + param.name, value);
              }
              return;
            }
            if (value == null) {
              topics.push(null);
            } else if (param.baseType === "array" || param.baseType === "tuple") {
              logger.throwArgumentError("filtering with tuples or arrays not supported", "contract." + param.name, value);
            } else if (Array.isArray(value)) {
              topics.push(value.map(function(value2) {
                return encodeTopic(param, value2);
              }));
            } else {
              topics.push(encodeTopic(param, value));
            }
          });
          while (topics.length && topics[topics.length - 1] === null) {
            topics.pop();
          }
          return topics;
        };
        Interface2.prototype.encodeEventLog = function(eventFragment, values) {
          var _this = this;
          if (typeof eventFragment === "string") {
            eventFragment = this.getEvent(eventFragment);
          }
          var topics = [];
          var dataTypes = [];
          var dataValues = [];
          if (!eventFragment.anonymous) {
            topics.push(this.getEventTopic(eventFragment));
          }
          if (values.length !== eventFragment.inputs.length) {
            logger.throwArgumentError("event arguments/values mismatch", "values", values);
          }
          eventFragment.inputs.forEach(function(param, index) {
            var value = values[index];
            if (param.indexed) {
              if (param.type === "string") {
                topics.push((0, hash_1.id)(value));
              } else if (param.type === "bytes") {
                topics.push((0, keccak256_1.keccak256)(value));
              } else if (param.baseType === "tuple" || param.baseType === "array") {
                throw new Error("not implemented");
              } else {
                topics.push(_this._abiCoder.encode([param.type], [value]));
              }
            } else {
              dataTypes.push(param);
              dataValues.push(value);
            }
          });
          return {
            data: this._abiCoder.encode(dataTypes, dataValues),
            topics
          };
        };
        Interface2.prototype.decodeEventLog = function(eventFragment, data, topics) {
          if (typeof eventFragment === "string") {
            eventFragment = this.getEvent(eventFragment);
          }
          if (topics != null && !eventFragment.anonymous) {
            var topicHash = this.getEventTopic(eventFragment);
            if (!(0, bytes_1.isHexString)(topics[0], 32) || topics[0].toLowerCase() !== topicHash) {
              logger.throwError("fragment/topic mismatch", logger_1.Logger.errors.INVALID_ARGUMENT, { argument: "topics[0]", expected: topicHash, value: topics[0] });
            }
            topics = topics.slice(1);
          }
          var indexed = [];
          var nonIndexed = [];
          var dynamic = [];
          eventFragment.inputs.forEach(function(param, index) {
            if (param.indexed) {
              if (param.type === "string" || param.type === "bytes" || param.baseType === "tuple" || param.baseType === "array") {
                indexed.push(fragments_1.ParamType.fromObject({ type: "bytes32", name: param.name }));
                dynamic.push(true);
              } else {
                indexed.push(param);
                dynamic.push(false);
              }
            } else {
              nonIndexed.push(param);
              dynamic.push(false);
            }
          });
          var resultIndexed = topics != null ? this._abiCoder.decode(indexed, (0, bytes_1.concat)(topics)) : null;
          var resultNonIndexed = this._abiCoder.decode(nonIndexed, data, true);
          var result = [];
          var nonIndexedIndex = 0, indexedIndex = 0;
          eventFragment.inputs.forEach(function(param, index) {
            if (param.indexed) {
              if (resultIndexed == null) {
                result[index] = new Indexed({ _isIndexed: true, hash: null });
              } else if (dynamic[index]) {
                result[index] = new Indexed({ _isIndexed: true, hash: resultIndexed[indexedIndex++] });
              } else {
                try {
                  result[index] = resultIndexed[indexedIndex++];
                } catch (error) {
                  result[index] = error;
                }
              }
            } else {
              try {
                result[index] = resultNonIndexed[nonIndexedIndex++];
              } catch (error) {
                result[index] = error;
              }
            }
            if (param.name && result[param.name] == null) {
              var value_1 = result[index];
              if (value_1 instanceof Error) {
                Object.defineProperty(result, param.name, {
                  enumerable: true,
                  get: function() {
                    throw wrapAccessError("property " + JSON.stringify(param.name), value_1);
                  }
                });
              } else {
                result[param.name] = value_1;
              }
            }
          });
          var _loop_1 = function(i2) {
            var value = result[i2];
            if (value instanceof Error) {
              Object.defineProperty(result, i2, {
                enumerable: true,
                get: function() {
                  throw wrapAccessError("index " + i2, value);
                }
              });
            }
          };
          for (var i = 0; i < result.length; i++) {
            _loop_1(i);
          }
          return Object.freeze(result);
        };
        Interface2.prototype.parseTransaction = function(tx) {
          var fragment = this.getFunction(tx.data.substring(0, 10).toLowerCase());
          if (!fragment) {
            return null;
          }
          return new TransactionDescription({
            args: this._abiCoder.decode(fragment.inputs, "0x" + tx.data.substring(10)),
            functionFragment: fragment,
            name: fragment.name,
            signature: fragment.format(),
            sighash: this.getSighash(fragment),
            value: bignumber_1.BigNumber.from(tx.value || "0")
          });
        };
        Interface2.prototype.parseLog = function(log) {
          var fragment = this.getEvent(log.topics[0]);
          if (!fragment || fragment.anonymous) {
            return null;
          }
          return new LogDescription({
            eventFragment: fragment,
            name: fragment.name,
            signature: fragment.format(),
            topic: this.getEventTopic(fragment),
            args: this.decodeEventLog(fragment, log.data, log.topics)
          });
        };
        Interface2.prototype.parseError = function(data) {
          var hexData = (0, bytes_1.hexlify)(data);
          var fragment = this.getError(hexData.substring(0, 10).toLowerCase());
          if (!fragment) {
            return null;
          }
          return new ErrorDescription({
            args: this._abiCoder.decode(fragment.inputs, "0x" + hexData.substring(10)),
            errorFragment: fragment,
            name: fragment.name,
            signature: fragment.format(),
            sighash: this.getSighash(fragment)
          });
        };
        Interface2.isInterface = function(value) {
          return !!(value && value._isInterface);
        };
        return Interface2;
      }()
    );
    exports2.Interface = Interface;
  }
});

// node_modules/@ethersproject/abi/lib/index.js
var require_lib11 = __commonJS({
  "node_modules/@ethersproject/abi/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.TransactionDescription = exports2.LogDescription = exports2.checkResultErrors = exports2.Indexed = exports2.Interface = exports2.defaultAbiCoder = exports2.AbiCoder = exports2.FormatTypes = exports2.ParamType = exports2.FunctionFragment = exports2.Fragment = exports2.EventFragment = exports2.ErrorFragment = exports2.ConstructorFragment = void 0;
    var fragments_1 = require_fragments();
    Object.defineProperty(exports2, "ConstructorFragment", { enumerable: true, get: function() {
      return fragments_1.ConstructorFragment;
    } });
    Object.defineProperty(exports2, "ErrorFragment", { enumerable: true, get: function() {
      return fragments_1.ErrorFragment;
    } });
    Object.defineProperty(exports2, "EventFragment", { enumerable: true, get: function() {
      return fragments_1.EventFragment;
    } });
    Object.defineProperty(exports2, "FormatTypes", { enumerable: true, get: function() {
      return fragments_1.FormatTypes;
    } });
    Object.defineProperty(exports2, "Fragment", { enumerable: true, get: function() {
      return fragments_1.Fragment;
    } });
    Object.defineProperty(exports2, "FunctionFragment", { enumerable: true, get: function() {
      return fragments_1.FunctionFragment;
    } });
    Object.defineProperty(exports2, "ParamType", { enumerable: true, get: function() {
      return fragments_1.ParamType;
    } });
    var abi_coder_1 = require_abi_coder();
    Object.defineProperty(exports2, "AbiCoder", { enumerable: true, get: function() {
      return abi_coder_1.AbiCoder;
    } });
    Object.defineProperty(exports2, "defaultAbiCoder", { enumerable: true, get: function() {
      return abi_coder_1.defaultAbiCoder;
    } });
    var interface_1 = require_interface();
    Object.defineProperty(exports2, "checkResultErrors", { enumerable: true, get: function() {
      return interface_1.checkResultErrors;
    } });
    Object.defineProperty(exports2, "Indexed", { enumerable: true, get: function() {
      return interface_1.Indexed;
    } });
    Object.defineProperty(exports2, "Interface", { enumerable: true, get: function() {
      return interface_1.Interface;
    } });
    Object.defineProperty(exports2, "LogDescription", { enumerable: true, get: function() {
      return interface_1.LogDescription;
    } });
    Object.defineProperty(exports2, "TransactionDescription", { enumerable: true, get: function() {
      return interface_1.TransactionDescription;
    } });
  }
});

// node_modules/@ethersproject/abstract-provider/lib/_version.js
var require_version10 = __commonJS({
  "node_modules/@ethersproject/abstract-provider/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "abstract-provider/5.5.1";
  }
});

// node_modules/@ethersproject/abstract-provider/lib/index.js
var require_lib12 = __commonJS({
  "node_modules/@ethersproject/abstract-provider/lib/index.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator = exports2 && exports2.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1) throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return { value: op[1], done: false };
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2]) _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
        if (op[0] & 5) throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
      }
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Provider = exports2.TransactionOrderForkEvent = exports2.TransactionForkEvent = exports2.BlockForkEvent = exports2.ForkEvent = void 0;
    var bignumber_1 = require_lib3();
    var bytes_1 = require_lib2();
    var properties_1 = require_lib4();
    var logger_1 = require_lib();
    var _version_1 = require_version10();
    var logger = new logger_1.Logger(_version_1.version);
    var ForkEvent = (
      /** @class */
      function(_super) {
        __extends(ForkEvent2, _super);
        function ForkEvent2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        ForkEvent2.isForkEvent = function(value) {
          return !!(value && value._isForkEvent);
        };
        return ForkEvent2;
      }(properties_1.Description)
    );
    exports2.ForkEvent = ForkEvent;
    var BlockForkEvent = (
      /** @class */
      function(_super) {
        __extends(BlockForkEvent2, _super);
        function BlockForkEvent2(blockHash, expiry) {
          var _this = this;
          if (!(0, bytes_1.isHexString)(blockHash, 32)) {
            logger.throwArgumentError("invalid blockHash", "blockHash", blockHash);
          }
          _this = _super.call(this, {
            _isForkEvent: true,
            _isBlockForkEvent: true,
            expiry: expiry || 0,
            blockHash
          }) || this;
          return _this;
        }
        return BlockForkEvent2;
      }(ForkEvent)
    );
    exports2.BlockForkEvent = BlockForkEvent;
    var TransactionForkEvent = (
      /** @class */
      function(_super) {
        __extends(TransactionForkEvent2, _super);
        function TransactionForkEvent2(hash, expiry) {
          var _this = this;
          if (!(0, bytes_1.isHexString)(hash, 32)) {
            logger.throwArgumentError("invalid transaction hash", "hash", hash);
          }
          _this = _super.call(this, {
            _isForkEvent: true,
            _isTransactionForkEvent: true,
            expiry: expiry || 0,
            hash
          }) || this;
          return _this;
        }
        return TransactionForkEvent2;
      }(ForkEvent)
    );
    exports2.TransactionForkEvent = TransactionForkEvent;
    var TransactionOrderForkEvent = (
      /** @class */
      function(_super) {
        __extends(TransactionOrderForkEvent2, _super);
        function TransactionOrderForkEvent2(beforeHash, afterHash, expiry) {
          var _this = this;
          if (!(0, bytes_1.isHexString)(beforeHash, 32)) {
            logger.throwArgumentError("invalid transaction hash", "beforeHash", beforeHash);
          }
          if (!(0, bytes_1.isHexString)(afterHash, 32)) {
            logger.throwArgumentError("invalid transaction hash", "afterHash", afterHash);
          }
          _this = _super.call(this, {
            _isForkEvent: true,
            _isTransactionOrderForkEvent: true,
            expiry: expiry || 0,
            beforeHash,
            afterHash
          }) || this;
          return _this;
        }
        return TransactionOrderForkEvent2;
      }(ForkEvent)
    );
    exports2.TransactionOrderForkEvent = TransactionOrderForkEvent;
    var Provider = (
      /** @class */
      function() {
        function Provider2() {
          var _newTarget = this.constructor;
          logger.checkAbstract(_newTarget, Provider2);
          (0, properties_1.defineReadOnly)(this, "_isProvider", true);
        }
        Provider2.prototype.getFeeData = function() {
          return __awaiter(this, void 0, void 0, function() {
            var _a, block, gasPrice, maxFeePerGas, maxPriorityFeePerGas;
            return __generator(this, function(_b) {
              switch (_b.label) {
                case 0:
                  return [4, (0, properties_1.resolveProperties)({
                    block: this.getBlock("latest"),
                    gasPrice: this.getGasPrice().catch(function(error) {
                      return null;
                    })
                  })];
                case 1:
                  _a = _b.sent(), block = _a.block, gasPrice = _a.gasPrice;
                  maxFeePerGas = null, maxPriorityFeePerGas = null;
                  if (block && block.baseFeePerGas) {
                    maxPriorityFeePerGas = bignumber_1.BigNumber.from("2500000000");
                    maxFeePerGas = block.baseFeePerGas.mul(2).add(maxPriorityFeePerGas);
                  }
                  return [2, { maxFeePerGas, maxPriorityFeePerGas, gasPrice }];
              }
            });
          });
        };
        Provider2.prototype.addListener = function(eventName, listener) {
          return this.on(eventName, listener);
        };
        Provider2.prototype.removeListener = function(eventName, listener) {
          return this.off(eventName, listener);
        };
        Provider2.isProvider = function(value) {
          return !!(value && value._isProvider);
        };
        return Provider2;
      }()
    );
    exports2.Provider = Provider;
  }
});

// node_modules/@ethersproject/abstract-signer/lib/_version.js
var require_version11 = __commonJS({
  "node_modules/@ethersproject/abstract-signer/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "abstract-signer/5.5.0";
  }
});

// node_modules/@ethersproject/abstract-signer/lib/index.js
var require_lib13 = __commonJS({
  "node_modules/@ethersproject/abstract-signer/lib/index.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator = exports2 && exports2.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1) throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return { value: op[1], done: false };
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2]) _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
        if (op[0] & 5) throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
      }
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.VoidSigner = exports2.Signer = void 0;
    var properties_1 = require_lib4();
    var logger_1 = require_lib();
    var _version_1 = require_version11();
    var logger = new logger_1.Logger(_version_1.version);
    var allowedTransactionKeys = [
      "accessList",
      "chainId",
      "customData",
      "data",
      "from",
      "gasLimit",
      "gasPrice",
      "maxFeePerGas",
      "maxPriorityFeePerGas",
      "nonce",
      "to",
      "type",
      "value"
    ];
    var forwardErrors = [
      logger_1.Logger.errors.INSUFFICIENT_FUNDS,
      logger_1.Logger.errors.NONCE_EXPIRED,
      logger_1.Logger.errors.REPLACEMENT_UNDERPRICED
    ];
    var Signer = (
      /** @class */
      function() {
        function Signer2() {
          var _newTarget = this.constructor;
          logger.checkAbstract(_newTarget, Signer2);
          (0, properties_1.defineReadOnly)(this, "_isSigner", true);
        }
        Signer2.prototype.getBalance = function(blockTag) {
          return __awaiter(this, void 0, void 0, function() {
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  this._checkProvider("getBalance");
                  return [4, this.provider.getBalance(this.getAddress(), blockTag)];
                case 1:
                  return [2, _a.sent()];
              }
            });
          });
        };
        Signer2.prototype.getTransactionCount = function(blockTag) {
          return __awaiter(this, void 0, void 0, function() {
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  this._checkProvider("getTransactionCount");
                  return [4, this.provider.getTransactionCount(this.getAddress(), blockTag)];
                case 1:
                  return [2, _a.sent()];
              }
            });
          });
        };
        Signer2.prototype.estimateGas = function(transaction) {
          return __awaiter(this, void 0, void 0, function() {
            var tx;
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  this._checkProvider("estimateGas");
                  return [4, (0, properties_1.resolveProperties)(this.checkTransaction(transaction))];
                case 1:
                  tx = _a.sent();
                  return [4, this.provider.estimateGas(tx)];
                case 2:
                  return [2, _a.sent()];
              }
            });
          });
        };
        Signer2.prototype.call = function(transaction, blockTag) {
          return __awaiter(this, void 0, void 0, function() {
            var tx;
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  this._checkProvider("call");
                  return [4, (0, properties_1.resolveProperties)(this.checkTransaction(transaction))];
                case 1:
                  tx = _a.sent();
                  return [4, this.provider.call(tx, blockTag)];
                case 2:
                  return [2, _a.sent()];
              }
            });
          });
        };
        Signer2.prototype.sendTransaction = function(transaction) {
          return __awaiter(this, void 0, void 0, function() {
            var tx, signedTx;
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  this._checkProvider("sendTransaction");
                  return [4, this.populateTransaction(transaction)];
                case 1:
                  tx = _a.sent();
                  return [4, this.signTransaction(tx)];
                case 2:
                  signedTx = _a.sent();
                  return [4, this.provider.sendTransaction(signedTx)];
                case 3:
                  return [2, _a.sent()];
              }
            });
          });
        };
        Signer2.prototype.getChainId = function() {
          return __awaiter(this, void 0, void 0, function() {
            var network;
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  this._checkProvider("getChainId");
                  return [4, this.provider.getNetwork()];
                case 1:
                  network = _a.sent();
                  return [2, network.chainId];
              }
            });
          });
        };
        Signer2.prototype.getGasPrice = function() {
          return __awaiter(this, void 0, void 0, function() {
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  this._checkProvider("getGasPrice");
                  return [4, this.provider.getGasPrice()];
                case 1:
                  return [2, _a.sent()];
              }
            });
          });
        };
        Signer2.prototype.getFeeData = function() {
          return __awaiter(this, void 0, void 0, function() {
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  this._checkProvider("getFeeData");
                  return [4, this.provider.getFeeData()];
                case 1:
                  return [2, _a.sent()];
              }
            });
          });
        };
        Signer2.prototype.resolveName = function(name2) {
          return __awaiter(this, void 0, void 0, function() {
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  this._checkProvider("resolveName");
                  return [4, this.provider.resolveName(name2)];
                case 1:
                  return [2, _a.sent()];
              }
            });
          });
        };
        Signer2.prototype.checkTransaction = function(transaction) {
          for (var key in transaction) {
            if (allowedTransactionKeys.indexOf(key) === -1) {
              logger.throwArgumentError("invalid transaction key: " + key, "transaction", transaction);
            }
          }
          var tx = (0, properties_1.shallowCopy)(transaction);
          if (tx.from == null) {
            tx.from = this.getAddress();
          } else {
            tx.from = Promise.all([
              Promise.resolve(tx.from),
              this.getAddress()
            ]).then(function(result) {
              if (result[0].toLowerCase() !== result[1].toLowerCase()) {
                logger.throwArgumentError("from address mismatch", "transaction", transaction);
              }
              return result[0];
            });
          }
          return tx;
        };
        Signer2.prototype.populateTransaction = function(transaction) {
          return __awaiter(this, void 0, void 0, function() {
            var tx, hasEip1559, feeData, gasPrice;
            var _this = this;
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  return [4, (0, properties_1.resolveProperties)(this.checkTransaction(transaction))];
                case 1:
                  tx = _a.sent();
                  if (tx.to != null) {
                    tx.to = Promise.resolve(tx.to).then(function(to) {
                      return __awaiter(_this, void 0, void 0, function() {
                        var address;
                        return __generator(this, function(_a2) {
                          switch (_a2.label) {
                            case 0:
                              if (to == null) {
                                return [2, null];
                              }
                              return [4, this.resolveName(to)];
                            case 1:
                              address = _a2.sent();
                              if (address == null) {
                                logger.throwArgumentError("provided ENS name resolves to null", "tx.to", to);
                              }
                              return [2, address];
                          }
                        });
                      });
                    });
                    tx.to.catch(function(error) {
                    });
                  }
                  hasEip1559 = tx.maxFeePerGas != null || tx.maxPriorityFeePerGas != null;
                  if (tx.gasPrice != null && (tx.type === 2 || hasEip1559)) {
                    logger.throwArgumentError("eip-1559 transaction do not support gasPrice", "transaction", transaction);
                  } else if ((tx.type === 0 || tx.type === 1) && hasEip1559) {
                    logger.throwArgumentError("pre-eip-1559 transaction do not support maxFeePerGas/maxPriorityFeePerGas", "transaction", transaction);
                  }
                  if (!((tx.type === 2 || tx.type == null) && (tx.maxFeePerGas != null && tx.maxPriorityFeePerGas != null))) return [3, 2];
                  tx.type = 2;
                  return [3, 5];
                case 2:
                  if (!(tx.type === 0 || tx.type === 1)) return [3, 3];
                  if (tx.gasPrice == null) {
                    tx.gasPrice = this.getGasPrice();
                  }
                  return [3, 5];
                case 3:
                  return [4, this.getFeeData()];
                case 4:
                  feeData = _a.sent();
                  if (tx.type == null) {
                    if (feeData.maxFeePerGas != null && feeData.maxPriorityFeePerGas != null) {
                      tx.type = 2;
                      if (tx.gasPrice != null) {
                        gasPrice = tx.gasPrice;
                        delete tx.gasPrice;
                        tx.maxFeePerGas = gasPrice;
                        tx.maxPriorityFeePerGas = gasPrice;
                      } else {
                        if (tx.maxFeePerGas == null) {
                          tx.maxFeePerGas = feeData.maxFeePerGas;
                        }
                        if (tx.maxPriorityFeePerGas == null) {
                          tx.maxPriorityFeePerGas = feeData.maxPriorityFeePerGas;
                        }
                      }
                    } else if (feeData.gasPrice != null) {
                      if (hasEip1559) {
                        logger.throwError("network does not support EIP-1559", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
                          operation: "populateTransaction"
                        });
                      }
                      if (tx.gasPrice == null) {
                        tx.gasPrice = feeData.gasPrice;
                      }
                      tx.type = 0;
                    } else {
                      logger.throwError("failed to get consistent fee data", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
                        operation: "signer.getFeeData"
                      });
                    }
                  } else if (tx.type === 2) {
                    if (tx.maxFeePerGas == null) {
                      tx.maxFeePerGas = feeData.maxFeePerGas;
                    }
                    if (tx.maxPriorityFeePerGas == null) {
                      tx.maxPriorityFeePerGas = feeData.maxPriorityFeePerGas;
                    }
                  }
                  _a.label = 5;
                case 5:
                  if (tx.nonce == null) {
                    tx.nonce = this.getTransactionCount("pending");
                  }
                  if (tx.gasLimit == null) {
                    tx.gasLimit = this.estimateGas(tx).catch(function(error) {
                      if (forwardErrors.indexOf(error.code) >= 0) {
                        throw error;
                      }
                      return logger.throwError("cannot estimate gas; transaction may fail or may require manual gas limit", logger_1.Logger.errors.UNPREDICTABLE_GAS_LIMIT, {
                        error,
                        tx
                      });
                    });
                  }
                  if (tx.chainId == null) {
                    tx.chainId = this.getChainId();
                  } else {
                    tx.chainId = Promise.all([
                      Promise.resolve(tx.chainId),
                      this.getChainId()
                    ]).then(function(results) {
                      if (results[1] !== 0 && results[0] !== results[1]) {
                        logger.throwArgumentError("chainId address mismatch", "transaction", transaction);
                      }
                      return results[0];
                    });
                  }
                  return [4, (0, properties_1.resolveProperties)(tx)];
                case 6:
                  return [2, _a.sent()];
              }
            });
          });
        };
        Signer2.prototype._checkProvider = function(operation) {
          if (!this.provider) {
            logger.throwError("missing provider", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
              operation: operation || "_checkProvider"
            });
          }
        };
        Signer2.isSigner = function(value) {
          return !!(value && value._isSigner);
        };
        return Signer2;
      }()
    );
    exports2.Signer = Signer;
    var VoidSigner = (
      /** @class */
      function(_super) {
        __extends(VoidSigner2, _super);
        function VoidSigner2(address, provider) {
          var _newTarget = this.constructor;
          var _this = this;
          logger.checkNew(_newTarget, VoidSigner2);
          _this = _super.call(this) || this;
          (0, properties_1.defineReadOnly)(_this, "address", address);
          (0, properties_1.defineReadOnly)(_this, "provider", provider || null);
          return _this;
        }
        VoidSigner2.prototype.getAddress = function() {
          return Promise.resolve(this.address);
        };
        VoidSigner2.prototype._fail = function(message, operation) {
          return Promise.resolve().then(function() {
            logger.throwError(message, logger_1.Logger.errors.UNSUPPORTED_OPERATION, { operation });
          });
        };
        VoidSigner2.prototype.signMessage = function(message) {
          return this._fail("VoidSigner cannot sign messages", "signMessage");
        };
        VoidSigner2.prototype.signTransaction = function(transaction) {
          return this._fail("VoidSigner cannot sign transactions", "signTransaction");
        };
        VoidSigner2.prototype._signTypedData = function(domain, types, value) {
          return this._fail("VoidSigner cannot sign typed data", "signTypedData");
        };
        VoidSigner2.prototype.connect = function(provider) {
          return new VoidSigner2(this.address, provider);
        };
        return VoidSigner2;
      }(Signer)
    );
    exports2.VoidSigner = VoidSigner;
  }
});

// node_modules/elliptic/package.json
var require_package = __commonJS({
  "node_modules/elliptic/package.json"(exports2, module2) {
    module2.exports = {
      name: "elliptic",
      version: "6.5.4",
      description: "EC cryptography",
      main: "lib/elliptic.js",
      files: [
        "lib"
      ],
      scripts: {
        lint: "eslint lib test",
        "lint:fix": "npm run lint -- --fix",
        unit: "istanbul test _mocha --reporter=spec test/index.js",
        test: "npm run lint && npm run unit",
        version: "grunt dist && git add dist/"
      },
      repository: {
        type: "git",
        url: "git@github.com:indutny/elliptic"
      },
      keywords: [
        "EC",
        "Elliptic",
        "curve",
        "Cryptography"
      ],
      author: "Fedor Indutny <fedor@indutny.com>",
      license: "MIT",
      bugs: {
        url: "https://github.com/indutny/elliptic/issues"
      },
      homepage: "https://github.com/indutny/elliptic",
      devDependencies: {
        brfs: "^2.0.2",
        coveralls: "^3.1.0",
        eslint: "^7.6.0",
        grunt: "^1.2.1",
        "grunt-browserify": "^5.3.0",
        "grunt-cli": "^1.3.2",
        "grunt-contrib-connect": "^3.0.0",
        "grunt-contrib-copy": "^1.0.0",
        "grunt-contrib-uglify": "^5.0.0",
        "grunt-mocha-istanbul": "^5.0.2",
        "grunt-saucelabs": "^9.0.1",
        istanbul: "^0.4.5",
        mocha: "^8.0.1"
      },
      dependencies: {
        "bn.js": "^4.11.9",
        brorand: "^1.1.0",
        "hash.js": "^1.0.0",
        "hmac-drbg": "^1.0.1",
        inherits: "^2.0.4",
        "minimalistic-assert": "^1.0.1",
        "minimalistic-crypto-utils": "^1.0.1"
      }
    };
  }
});

// node_modules/minimalistic-assert/index.js
var require_minimalistic_assert = __commonJS({
  "node_modules/minimalistic-assert/index.js"(exports2, module2) {
    module2.exports = assert;
    function assert(val, msg) {
      if (!val)
        throw new Error(msg || "Assertion failed");
    }
    assert.equal = function assertEqual(l, r, msg) {
      if (l != r)
        throw new Error(msg || "Assertion failed: " + l + " != " + r);
    };
  }
});

// node_modules/minimalistic-crypto-utils/lib/utils.js
var require_utils = __commonJS({
  "node_modules/minimalistic-crypto-utils/lib/utils.js"(exports2) {
    "use strict";
    var utils = exports2;
    function toArray(msg, enc) {
      if (Array.isArray(msg))
        return msg.slice();
      if (!msg)
        return [];
      var res = [];
      if (typeof msg !== "string") {
        for (var i = 0; i < msg.length; i++)
          res[i] = msg[i] | 0;
        return res;
      }
      if (enc === "hex") {
        msg = msg.replace(/[^a-z0-9]+/ig, "");
        if (msg.length % 2 !== 0)
          msg = "0" + msg;
        for (var i = 0; i < msg.length; i += 2)
          res.push(parseInt(msg[i] + msg[i + 1], 16));
      } else {
        for (var i = 0; i < msg.length; i++) {
          var c = msg.charCodeAt(i);
          var hi = c >> 8;
          var lo = c & 255;
          if (hi)
            res.push(hi, lo);
          else
            res.push(lo);
        }
      }
      return res;
    }
    utils.toArray = toArray;
    function zero2(word) {
      if (word.length === 1)
        return "0" + word;
      else
        return word;
    }
    utils.zero2 = zero2;
    function toHex(msg) {
      var res = "";
      for (var i = 0; i < msg.length; i++)
        res += zero2(msg[i].toString(16));
      return res;
    }
    utils.toHex = toHex;
    utils.encode = function encode(arr, enc) {
      if (enc === "hex")
        return toHex(arr);
      else
        return arr;
    };
  }
});

// node_modules/elliptic/lib/elliptic/utils.js
var require_utils2 = __commonJS({
  "node_modules/elliptic/lib/elliptic/utils.js"(exports2) {
    "use strict";
    var utils = exports2;
    var BN = require_bn();
    var minAssert = require_minimalistic_assert();
    var minUtils = require_utils();
    utils.assert = minAssert;
    utils.toArray = minUtils.toArray;
    utils.zero2 = minUtils.zero2;
    utils.toHex = minUtils.toHex;
    utils.encode = minUtils.encode;
    function getNAF(num, w, bits) {
      var naf = new Array(Math.max(num.bitLength(), bits) + 1);
      naf.fill(0);
      var ws = 1 << w + 1;
      var k = num.clone();
      for (var i = 0; i < naf.length; i++) {
        var z;
        var mod = k.andln(ws - 1);
        if (k.isOdd()) {
          if (mod > (ws >> 1) - 1)
            z = (ws >> 1) - mod;
          else
            z = mod;
          k.isubn(z);
        } else {
          z = 0;
        }
        naf[i] = z;
        k.iushrn(1);
      }
      return naf;
    }
    utils.getNAF = getNAF;
    function getJSF(k1, k2) {
      var jsf = [
        [],
        []
      ];
      k1 = k1.clone();
      k2 = k2.clone();
      var d1 = 0;
      var d2 = 0;
      var m8;
      while (k1.cmpn(-d1) > 0 || k2.cmpn(-d2) > 0) {
        var m14 = k1.andln(3) + d1 & 3;
        var m24 = k2.andln(3) + d2 & 3;
        if (m14 === 3)
          m14 = -1;
        if (m24 === 3)
          m24 = -1;
        var u1;
        if ((m14 & 1) === 0) {
          u1 = 0;
        } else {
          m8 = k1.andln(7) + d1 & 7;
          if ((m8 === 3 || m8 === 5) && m24 === 2)
            u1 = -m14;
          else
            u1 = m14;
        }
        jsf[0].push(u1);
        var u2;
        if ((m24 & 1) === 0) {
          u2 = 0;
        } else {
          m8 = k2.andln(7) + d2 & 7;
          if ((m8 === 3 || m8 === 5) && m14 === 2)
            u2 = -m24;
          else
            u2 = m24;
        }
        jsf[1].push(u2);
        if (2 * d1 === u1 + 1)
          d1 = 1 - d1;
        if (2 * d2 === u2 + 1)
          d2 = 1 - d2;
        k1.iushrn(1);
        k2.iushrn(1);
      }
      return jsf;
    }
    utils.getJSF = getJSF;
    function cachedProperty(obj, name2, computer) {
      var key = "_" + name2;
      obj.prototype[name2] = function cachedProperty2() {
        return this[key] !== void 0 ? this[key] : this[key] = computer.call(this);
      };
    }
    utils.cachedProperty = cachedProperty;
    function parseBytes(bytes) {
      return typeof bytes === "string" ? utils.toArray(bytes, "hex") : bytes;
    }
    utils.parseBytes = parseBytes;
    function intFromLE(bytes) {
      return new BN(bytes, "hex", "le");
    }
    utils.intFromLE = intFromLE;
  }
});

// node_modules/brorand/index.js
var require_brorand = __commonJS({
  "node_modules/brorand/index.js"(exports2, module2) {
    var r;
    module2.exports = function rand(len) {
      if (!r)
        r = new Rand(null);
      return r.generate(len);
    };
    function Rand(rand) {
      this.rand = rand;
    }
    module2.exports.Rand = Rand;
    Rand.prototype.generate = function generate(len) {
      return this._rand(len);
    };
    Rand.prototype._rand = function _rand(n) {
      if (this.rand.getBytes)
        return this.rand.getBytes(n);
      var res = new Uint8Array(n);
      for (var i = 0; i < res.length; i++)
        res[i] = this.rand.getByte();
      return res;
    };
    if (typeof self === "object") {
      if (self.crypto && self.crypto.getRandomValues) {
        Rand.prototype._rand = function _rand(n) {
          var arr = new Uint8Array(n);
          self.crypto.getRandomValues(arr);
          return arr;
        };
      } else if (self.msCrypto && self.msCrypto.getRandomValues) {
        Rand.prototype._rand = function _rand(n) {
          var arr = new Uint8Array(n);
          self.msCrypto.getRandomValues(arr);
          return arr;
        };
      } else if (typeof window === "object") {
        Rand.prototype._rand = function() {
          throw new Error("Not implemented yet");
        };
      }
    } else {
      try {
        crypto2 = require("crypto");
        if (typeof crypto2.randomBytes !== "function")
          throw new Error("Not supported");
        Rand.prototype._rand = function _rand(n) {
          return crypto2.randomBytes(n);
        };
      } catch (e) {
      }
    }
    var crypto2;
  }
});

// node_modules/elliptic/lib/elliptic/curve/base.js
var require_base = __commonJS({
  "node_modules/elliptic/lib/elliptic/curve/base.js"(exports2, module2) {
    "use strict";
    var BN = require_bn();
    var utils = require_utils2();
    var getNAF = utils.getNAF;
    var getJSF = utils.getJSF;
    var assert = utils.assert;
    function BaseCurve(type, conf) {
      this.type = type;
      this.p = new BN(conf.p, 16);
      this.red = conf.prime ? BN.red(conf.prime) : BN.mont(this.p);
      this.zero = new BN(0).toRed(this.red);
      this.one = new BN(1).toRed(this.red);
      this.two = new BN(2).toRed(this.red);
      this.n = conf.n && new BN(conf.n, 16);
      this.g = conf.g && this.pointFromJSON(conf.g, conf.gRed);
      this._wnafT1 = new Array(4);
      this._wnafT2 = new Array(4);
      this._wnafT3 = new Array(4);
      this._wnafT4 = new Array(4);
      this._bitLength = this.n ? this.n.bitLength() : 0;
      var adjustCount = this.n && this.p.div(this.n);
      if (!adjustCount || adjustCount.cmpn(100) > 0) {
        this.redN = null;
      } else {
        this._maxwellTrick = true;
        this.redN = this.n.toRed(this.red);
      }
    }
    module2.exports = BaseCurve;
    BaseCurve.prototype.point = function point() {
      throw new Error("Not implemented");
    };
    BaseCurve.prototype.validate = function validate() {
      throw new Error("Not implemented");
    };
    BaseCurve.prototype._fixedNafMul = function _fixedNafMul(p, k) {
      assert(p.precomputed);
      var doubles = p._getDoubles();
      var naf = getNAF(k, 1, this._bitLength);
      var I = (1 << doubles.step + 1) - (doubles.step % 2 === 0 ? 2 : 1);
      I /= 3;
      var repr = [];
      var j;
      var nafW;
      for (j = 0; j < naf.length; j += doubles.step) {
        nafW = 0;
        for (var l = j + doubles.step - 1; l >= j; l--)
          nafW = (nafW << 1) + naf[l];
        repr.push(nafW);
      }
      var a = this.jpoint(null, null, null);
      var b = this.jpoint(null, null, null);
      for (var i = I; i > 0; i--) {
        for (j = 0; j < repr.length; j++) {
          nafW = repr[j];
          if (nafW === i)
            b = b.mixedAdd(doubles.points[j]);
          else if (nafW === -i)
            b = b.mixedAdd(doubles.points[j].neg());
        }
        a = a.add(b);
      }
      return a.toP();
    };
    BaseCurve.prototype._wnafMul = function _wnafMul(p, k) {
      var w = 4;
      var nafPoints = p._getNAFPoints(w);
      w = nafPoints.wnd;
      var wnd = nafPoints.points;
      var naf = getNAF(k, w, this._bitLength);
      var acc = this.jpoint(null, null, null);
      for (var i = naf.length - 1; i >= 0; i--) {
        for (var l = 0; i >= 0 && naf[i] === 0; i--)
          l++;
        if (i >= 0)
          l++;
        acc = acc.dblp(l);
        if (i < 0)
          break;
        var z = naf[i];
        assert(z !== 0);
        if (p.type === "affine") {
          if (z > 0)
            acc = acc.mixedAdd(wnd[z - 1 >> 1]);
          else
            acc = acc.mixedAdd(wnd[-z - 1 >> 1].neg());
        } else {
          if (z > 0)
            acc = acc.add(wnd[z - 1 >> 1]);
          else
            acc = acc.add(wnd[-z - 1 >> 1].neg());
        }
      }
      return p.type === "affine" ? acc.toP() : acc;
    };
    BaseCurve.prototype._wnafMulAdd = function _wnafMulAdd(defW, points, coeffs, len, jacobianResult) {
      var wndWidth = this._wnafT1;
      var wnd = this._wnafT2;
      var naf = this._wnafT3;
      var max = 0;
      var i;
      var j;
      var p;
      for (i = 0; i < len; i++) {
        p = points[i];
        var nafPoints = p._getNAFPoints(defW);
        wndWidth[i] = nafPoints.wnd;
        wnd[i] = nafPoints.points;
      }
      for (i = len - 1; i >= 1; i -= 2) {
        var a = i - 1;
        var b = i;
        if (wndWidth[a] !== 1 || wndWidth[b] !== 1) {
          naf[a] = getNAF(coeffs[a], wndWidth[a], this._bitLength);
          naf[b] = getNAF(coeffs[b], wndWidth[b], this._bitLength);
          max = Math.max(naf[a].length, max);
          max = Math.max(naf[b].length, max);
          continue;
        }
        var comb = [
          points[a],
          /* 1 */
          null,
          /* 3 */
          null,
          /* 5 */
          points[b]
          /* 7 */
        ];
        if (points[a].y.cmp(points[b].y) === 0) {
          comb[1] = points[a].add(points[b]);
          comb[2] = points[a].toJ().mixedAdd(points[b].neg());
        } else if (points[a].y.cmp(points[b].y.redNeg()) === 0) {
          comb[1] = points[a].toJ().mixedAdd(points[b]);
          comb[2] = points[a].add(points[b].neg());
        } else {
          comb[1] = points[a].toJ().mixedAdd(points[b]);
          comb[2] = points[a].toJ().mixedAdd(points[b].neg());
        }
        var index = [
          -3,
          /* -1 -1 */
          -1,
          /* -1 0 */
          -5,
          /* -1 1 */
          -7,
          /* 0 -1 */
          0,
          /* 0 0 */
          7,
          /* 0 1 */
          5,
          /* 1 -1 */
          1,
          /* 1 0 */
          3
          /* 1 1 */
        ];
        var jsf = getJSF(coeffs[a], coeffs[b]);
        max = Math.max(jsf[0].length, max);
        naf[a] = new Array(max);
        naf[b] = new Array(max);
        for (j = 0; j < max; j++) {
          var ja = jsf[0][j] | 0;
          var jb = jsf[1][j] | 0;
          naf[a][j] = index[(ja + 1) * 3 + (jb + 1)];
          naf[b][j] = 0;
          wnd[a] = comb;
        }
      }
      var acc = this.jpoint(null, null, null);
      var tmp = this._wnafT4;
      for (i = max; i >= 0; i--) {
        var k = 0;
        while (i >= 0) {
          var zero = true;
          for (j = 0; j < len; j++) {
            tmp[j] = naf[j][i] | 0;
            if (tmp[j] !== 0)
              zero = false;
          }
          if (!zero)
            break;
          k++;
          i--;
        }
        if (i >= 0)
          k++;
        acc = acc.dblp(k);
        if (i < 0)
          break;
        for (j = 0; j < len; j++) {
          var z = tmp[j];
          p;
          if (z === 0)
            continue;
          else if (z > 0)
            p = wnd[j][z - 1 >> 1];
          else if (z < 0)
            p = wnd[j][-z - 1 >> 1].neg();
          if (p.type === "affine")
            acc = acc.mixedAdd(p);
          else
            acc = acc.add(p);
        }
      }
      for (i = 0; i < len; i++)
        wnd[i] = null;
      if (jacobianResult)
        return acc;
      else
        return acc.toP();
    };
    function BasePoint(curve, type) {
      this.curve = curve;
      this.type = type;
      this.precomputed = null;
    }
    BaseCurve.BasePoint = BasePoint;
    BasePoint.prototype.eq = function eq() {
      throw new Error("Not implemented");
    };
    BasePoint.prototype.validate = function validate() {
      return this.curve.validate(this);
    };
    BaseCurve.prototype.decodePoint = function decodePoint(bytes, enc) {
      bytes = utils.toArray(bytes, enc);
      var len = this.p.byteLength();
      if ((bytes[0] === 4 || bytes[0] === 6 || bytes[0] === 7) && bytes.length - 1 === 2 * len) {
        if (bytes[0] === 6)
          assert(bytes[bytes.length - 1] % 2 === 0);
        else if (bytes[0] === 7)
          assert(bytes[bytes.length - 1] % 2 === 1);
        var res = this.point(
          bytes.slice(1, 1 + len),
          bytes.slice(1 + len, 1 + 2 * len)
        );
        return res;
      } else if ((bytes[0] === 2 || bytes[0] === 3) && bytes.length - 1 === len) {
        return this.pointFromX(bytes.slice(1, 1 + len), bytes[0] === 3);
      }
      throw new Error("Unknown point format");
    };
    BasePoint.prototype.encodeCompressed = function encodeCompressed(enc) {
      return this.encode(enc, true);
    };
    BasePoint.prototype._encode = function _encode(compact) {
      var len = this.curve.p.byteLength();
      var x = this.getX().toArray("be", len);
      if (compact)
        return [this.getY().isEven() ? 2 : 3].concat(x);
      return [4].concat(x, this.getY().toArray("be", len));
    };
    BasePoint.prototype.encode = function encode(enc, compact) {
      return utils.encode(this._encode(compact), enc);
    };
    BasePoint.prototype.precompute = function precompute(power) {
      if (this.precomputed)
        return this;
      var precomputed = {
        doubles: null,
        naf: null,
        beta: null
      };
      precomputed.naf = this._getNAFPoints(8);
      precomputed.doubles = this._getDoubles(4, power);
      precomputed.beta = this._getBeta();
      this.precomputed = precomputed;
      return this;
    };
    BasePoint.prototype._hasDoubles = function _hasDoubles(k) {
      if (!this.precomputed)
        return false;
      var doubles = this.precomputed.doubles;
      if (!doubles)
        return false;
      return doubles.points.length >= Math.ceil((k.bitLength() + 1) / doubles.step);
    };
    BasePoint.prototype._getDoubles = function _getDoubles(step, power) {
      if (this.precomputed && this.precomputed.doubles)
        return this.precomputed.doubles;
      var doubles = [this];
      var acc = this;
      for (var i = 0; i < power; i += step) {
        for (var j = 0; j < step; j++)
          acc = acc.dbl();
        doubles.push(acc);
      }
      return {
        step,
        points: doubles
      };
    };
    BasePoint.prototype._getNAFPoints = function _getNAFPoints(wnd) {
      if (this.precomputed && this.precomputed.naf)
        return this.precomputed.naf;
      var res = [this];
      var max = (1 << wnd) - 1;
      var dbl = max === 1 ? null : this.dbl();
      for (var i = 1; i < max; i++)
        res[i] = res[i - 1].add(dbl);
      return {
        wnd,
        points: res
      };
    };
    BasePoint.prototype._getBeta = function _getBeta() {
      return null;
    };
    BasePoint.prototype.dblp = function dblp(k) {
      var r = this;
      for (var i = 0; i < k; i++)
        r = r.dbl();
      return r;
    };
  }
});

// node_modules/inherits/inherits_browser.js
var require_inherits_browser = __commonJS({
  "node_modules/inherits/inherits_browser.js"(exports2, module2) {
    if (typeof Object.create === "function") {
      module2.exports = function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          ctor.prototype = Object.create(superCtor.prototype, {
            constructor: {
              value: ctor,
              enumerable: false,
              writable: true,
              configurable: true
            }
          });
        }
      };
    } else {
      module2.exports = function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          var TempCtor = function() {
          };
          TempCtor.prototype = superCtor.prototype;
          ctor.prototype = new TempCtor();
          ctor.prototype.constructor = ctor;
        }
      };
    }
  }
});

// node_modules/inherits/inherits.js
var require_inherits = __commonJS({
  "node_modules/inherits/inherits.js"(exports2, module2) {
    try {
      util = require("util");
      if (typeof util.inherits !== "function") throw "";
      module2.exports = util.inherits;
    } catch (e) {
      module2.exports = require_inherits_browser();
    }
    var util;
  }
});

// node_modules/elliptic/lib/elliptic/curve/short.js
var require_short = __commonJS({
  "node_modules/elliptic/lib/elliptic/curve/short.js"(exports2, module2) {
    "use strict";
    var utils = require_utils2();
    var BN = require_bn();
    var inherits = require_inherits();
    var Base = require_base();
    var assert = utils.assert;
    function ShortCurve(conf) {
      Base.call(this, "short", conf);
      this.a = new BN(conf.a, 16).toRed(this.red);
      this.b = new BN(conf.b, 16).toRed(this.red);
      this.tinv = this.two.redInvm();
      this.zeroA = this.a.fromRed().cmpn(0) === 0;
      this.threeA = this.a.fromRed().sub(this.p).cmpn(-3) === 0;
      this.endo = this._getEndomorphism(conf);
      this._endoWnafT1 = new Array(4);
      this._endoWnafT2 = new Array(4);
    }
    inherits(ShortCurve, Base);
    module2.exports = ShortCurve;
    ShortCurve.prototype._getEndomorphism = function _getEndomorphism(conf) {
      if (!this.zeroA || !this.g || !this.n || this.p.modn(3) !== 1)
        return;
      var beta;
      var lambda;
      if (conf.beta) {
        beta = new BN(conf.beta, 16).toRed(this.red);
      } else {
        var betas = this._getEndoRoots(this.p);
        beta = betas[0].cmp(betas[1]) < 0 ? betas[0] : betas[1];
        beta = beta.toRed(this.red);
      }
      if (conf.lambda) {
        lambda = new BN(conf.lambda, 16);
      } else {
        var lambdas = this._getEndoRoots(this.n);
        if (this.g.mul(lambdas[0]).x.cmp(this.g.x.redMul(beta)) === 0) {
          lambda = lambdas[0];
        } else {
          lambda = lambdas[1];
          assert(this.g.mul(lambda).x.cmp(this.g.x.redMul(beta)) === 0);
        }
      }
      var basis;
      if (conf.basis) {
        basis = conf.basis.map(function(vec) {
          return {
            a: new BN(vec.a, 16),
            b: new BN(vec.b, 16)
          };
        });
      } else {
        basis = this._getEndoBasis(lambda);
      }
      return {
        beta,
        lambda,
        basis
      };
    };
    ShortCurve.prototype._getEndoRoots = function _getEndoRoots(num) {
      var red = num === this.p ? this.red : BN.mont(num);
      var tinv = new BN(2).toRed(red).redInvm();
      var ntinv = tinv.redNeg();
      var s = new BN(3).toRed(red).redNeg().redSqrt().redMul(tinv);
      var l1 = ntinv.redAdd(s).fromRed();
      var l2 = ntinv.redSub(s).fromRed();
      return [l1, l2];
    };
    ShortCurve.prototype._getEndoBasis = function _getEndoBasis(lambda) {
      var aprxSqrt = this.n.ushrn(Math.floor(this.n.bitLength() / 2));
      var u = lambda;
      var v = this.n.clone();
      var x1 = new BN(1);
      var y1 = new BN(0);
      var x2 = new BN(0);
      var y2 = new BN(1);
      var a0;
      var b0;
      var a1;
      var b1;
      var a2;
      var b2;
      var prevR;
      var i = 0;
      var r;
      var x;
      while (u.cmpn(0) !== 0) {
        var q = v.div(u);
        r = v.sub(q.mul(u));
        x = x2.sub(q.mul(x1));
        var y = y2.sub(q.mul(y1));
        if (!a1 && r.cmp(aprxSqrt) < 0) {
          a0 = prevR.neg();
          b0 = x1;
          a1 = r.neg();
          b1 = x;
        } else if (a1 && ++i === 2) {
          break;
        }
        prevR = r;
        v = u;
        u = r;
        x2 = x1;
        x1 = x;
        y2 = y1;
        y1 = y;
      }
      a2 = r.neg();
      b2 = x;
      var len1 = a1.sqr().add(b1.sqr());
      var len2 = a2.sqr().add(b2.sqr());
      if (len2.cmp(len1) >= 0) {
        a2 = a0;
        b2 = b0;
      }
      if (a1.negative) {
        a1 = a1.neg();
        b1 = b1.neg();
      }
      if (a2.negative) {
        a2 = a2.neg();
        b2 = b2.neg();
      }
      return [
        { a: a1, b: b1 },
        { a: a2, b: b2 }
      ];
    };
    ShortCurve.prototype._endoSplit = function _endoSplit(k) {
      var basis = this.endo.basis;
      var v1 = basis[0];
      var v2 = basis[1];
      var c1 = v2.b.mul(k).divRound(this.n);
      var c2 = v1.b.neg().mul(k).divRound(this.n);
      var p1 = c1.mul(v1.a);
      var p2 = c2.mul(v2.a);
      var q1 = c1.mul(v1.b);
      var q2 = c2.mul(v2.b);
      var k1 = k.sub(p1).sub(p2);
      var k2 = q1.add(q2).neg();
      return { k1, k2 };
    };
    ShortCurve.prototype.pointFromX = function pointFromX(x, odd) {
      x = new BN(x, 16);
      if (!x.red)
        x = x.toRed(this.red);
      var y2 = x.redSqr().redMul(x).redIAdd(x.redMul(this.a)).redIAdd(this.b);
      var y = y2.redSqrt();
      if (y.redSqr().redSub(y2).cmp(this.zero) !== 0)
        throw new Error("invalid point");
      var isOdd = y.fromRed().isOdd();
      if (odd && !isOdd || !odd && isOdd)
        y = y.redNeg();
      return this.point(x, y);
    };
    ShortCurve.prototype.validate = function validate(point) {
      if (point.inf)
        return true;
      var x = point.x;
      var y = point.y;
      var ax = this.a.redMul(x);
      var rhs = x.redSqr().redMul(x).redIAdd(ax).redIAdd(this.b);
      return y.redSqr().redISub(rhs).cmpn(0) === 0;
    };
    ShortCurve.prototype._endoWnafMulAdd = function _endoWnafMulAdd(points, coeffs, jacobianResult) {
      var npoints = this._endoWnafT1;
      var ncoeffs = this._endoWnafT2;
      for (var i = 0; i < points.length; i++) {
        var split = this._endoSplit(coeffs[i]);
        var p = points[i];
        var beta = p._getBeta();
        if (split.k1.negative) {
          split.k1.ineg();
          p = p.neg(true);
        }
        if (split.k2.negative) {
          split.k2.ineg();
          beta = beta.neg(true);
        }
        npoints[i * 2] = p;
        npoints[i * 2 + 1] = beta;
        ncoeffs[i * 2] = split.k1;
        ncoeffs[i * 2 + 1] = split.k2;
      }
      var res = this._wnafMulAdd(1, npoints, ncoeffs, i * 2, jacobianResult);
      for (var j = 0; j < i * 2; j++) {
        npoints[j] = null;
        ncoeffs[j] = null;
      }
      return res;
    };
    function Point(curve, x, y, isRed) {
      Base.BasePoint.call(this, curve, "affine");
      if (x === null && y === null) {
        this.x = null;
        this.y = null;
        this.inf = true;
      } else {
        this.x = new BN(x, 16);
        this.y = new BN(y, 16);
        if (isRed) {
          this.x.forceRed(this.curve.red);
          this.y.forceRed(this.curve.red);
        }
        if (!this.x.red)
          this.x = this.x.toRed(this.curve.red);
        if (!this.y.red)
          this.y = this.y.toRed(this.curve.red);
        this.inf = false;
      }
    }
    inherits(Point, Base.BasePoint);
    ShortCurve.prototype.point = function point(x, y, isRed) {
      return new Point(this, x, y, isRed);
    };
    ShortCurve.prototype.pointFromJSON = function pointFromJSON(obj, red) {
      return Point.fromJSON(this, obj, red);
    };
    Point.prototype._getBeta = function _getBeta() {
      if (!this.curve.endo)
        return;
      var pre = this.precomputed;
      if (pre && pre.beta)
        return pre.beta;
      var beta = this.curve.point(this.x.redMul(this.curve.endo.beta), this.y);
      if (pre) {
        var curve = this.curve;
        var endoMul = function(p) {
          return curve.point(p.x.redMul(curve.endo.beta), p.y);
        };
        pre.beta = beta;
        beta.precomputed = {
          beta: null,
          naf: pre.naf && {
            wnd: pre.naf.wnd,
            points: pre.naf.points.map(endoMul)
          },
          doubles: pre.doubles && {
            step: pre.doubles.step,
            points: pre.doubles.points.map(endoMul)
          }
        };
      }
      return beta;
    };
    Point.prototype.toJSON = function toJSON() {
      if (!this.precomputed)
        return [this.x, this.y];
      return [this.x, this.y, this.precomputed && {
        doubles: this.precomputed.doubles && {
          step: this.precomputed.doubles.step,
          points: this.precomputed.doubles.points.slice(1)
        },
        naf: this.precomputed.naf && {
          wnd: this.precomputed.naf.wnd,
          points: this.precomputed.naf.points.slice(1)
        }
      }];
    };
    Point.fromJSON = function fromJSON(curve, obj, red) {
      if (typeof obj === "string")
        obj = JSON.parse(obj);
      var res = curve.point(obj[0], obj[1], red);
      if (!obj[2])
        return res;
      function obj2point(obj2) {
        return curve.point(obj2[0], obj2[1], red);
      }
      var pre = obj[2];
      res.precomputed = {
        beta: null,
        doubles: pre.doubles && {
          step: pre.doubles.step,
          points: [res].concat(pre.doubles.points.map(obj2point))
        },
        naf: pre.naf && {
          wnd: pre.naf.wnd,
          points: [res].concat(pre.naf.points.map(obj2point))
        }
      };
      return res;
    };
    Point.prototype.inspect = function inspect() {
      if (this.isInfinity())
        return "<EC Point Infinity>";
      return "<EC Point x: " + this.x.fromRed().toString(16, 2) + " y: " + this.y.fromRed().toString(16, 2) + ">";
    };
    Point.prototype.isInfinity = function isInfinity() {
      return this.inf;
    };
    Point.prototype.add = function add(p) {
      if (this.inf)
        return p;
      if (p.inf)
        return this;
      if (this.eq(p))
        return this.dbl();
      if (this.neg().eq(p))
        return this.curve.point(null, null);
      if (this.x.cmp(p.x) === 0)
        return this.curve.point(null, null);
      var c = this.y.redSub(p.y);
      if (c.cmpn(0) !== 0)
        c = c.redMul(this.x.redSub(p.x).redInvm());
      var nx = c.redSqr().redISub(this.x).redISub(p.x);
      var ny = c.redMul(this.x.redSub(nx)).redISub(this.y);
      return this.curve.point(nx, ny);
    };
    Point.prototype.dbl = function dbl() {
      if (this.inf)
        return this;
      var ys1 = this.y.redAdd(this.y);
      if (ys1.cmpn(0) === 0)
        return this.curve.point(null, null);
      var a = this.curve.a;
      var x2 = this.x.redSqr();
      var dyinv = ys1.redInvm();
      var c = x2.redAdd(x2).redIAdd(x2).redIAdd(a).redMul(dyinv);
      var nx = c.redSqr().redISub(this.x.redAdd(this.x));
      var ny = c.redMul(this.x.redSub(nx)).redISub(this.y);
      return this.curve.point(nx, ny);
    };
    Point.prototype.getX = function getX() {
      return this.x.fromRed();
    };
    Point.prototype.getY = function getY() {
      return this.y.fromRed();
    };
    Point.prototype.mul = function mul(k) {
      k = new BN(k, 16);
      if (this.isInfinity())
        return this;
      else if (this._hasDoubles(k))
        return this.curve._fixedNafMul(this, k);
      else if (this.curve.endo)
        return this.curve._endoWnafMulAdd([this], [k]);
      else
        return this.curve._wnafMul(this, k);
    };
    Point.prototype.mulAdd = function mulAdd(k1, p2, k2) {
      var points = [this, p2];
      var coeffs = [k1, k2];
      if (this.curve.endo)
        return this.curve._endoWnafMulAdd(points, coeffs);
      else
        return this.curve._wnafMulAdd(1, points, coeffs, 2);
    };
    Point.prototype.jmulAdd = function jmulAdd(k1, p2, k2) {
      var points = [this, p2];
      var coeffs = [k1, k2];
      if (this.curve.endo)
        return this.curve._endoWnafMulAdd(points, coeffs, true);
      else
        return this.curve._wnafMulAdd(1, points, coeffs, 2, true);
    };
    Point.prototype.eq = function eq(p) {
      return this === p || this.inf === p.inf && (this.inf || this.x.cmp(p.x) === 0 && this.y.cmp(p.y) === 0);
    };
    Point.prototype.neg = function neg(_precompute) {
      if (this.inf)
        return this;
      var res = this.curve.point(this.x, this.y.redNeg());
      if (_precompute && this.precomputed) {
        var pre = this.precomputed;
        var negate = function(p) {
          return p.neg();
        };
        res.precomputed = {
          naf: pre.naf && {
            wnd: pre.naf.wnd,
            points: pre.naf.points.map(negate)
          },
          doubles: pre.doubles && {
            step: pre.doubles.step,
            points: pre.doubles.points.map(negate)
          }
        };
      }
      return res;
    };
    Point.prototype.toJ = function toJ() {
      if (this.inf)
        return this.curve.jpoint(null, null, null);
      var res = this.curve.jpoint(this.x, this.y, this.curve.one);
      return res;
    };
    function JPoint(curve, x, y, z) {
      Base.BasePoint.call(this, curve, "jacobian");
      if (x === null && y === null && z === null) {
        this.x = this.curve.one;
        this.y = this.curve.one;
        this.z = new BN(0);
      } else {
        this.x = new BN(x, 16);
        this.y = new BN(y, 16);
        this.z = new BN(z, 16);
      }
      if (!this.x.red)
        this.x = this.x.toRed(this.curve.red);
      if (!this.y.red)
        this.y = this.y.toRed(this.curve.red);
      if (!this.z.red)
        this.z = this.z.toRed(this.curve.red);
      this.zOne = this.z === this.curve.one;
    }
    inherits(JPoint, Base.BasePoint);
    ShortCurve.prototype.jpoint = function jpoint(x, y, z) {
      return new JPoint(this, x, y, z);
    };
    JPoint.prototype.toP = function toP() {
      if (this.isInfinity())
        return this.curve.point(null, null);
      var zinv = this.z.redInvm();
      var zinv2 = zinv.redSqr();
      var ax = this.x.redMul(zinv2);
      var ay = this.y.redMul(zinv2).redMul(zinv);
      return this.curve.point(ax, ay);
    };
    JPoint.prototype.neg = function neg() {
      return this.curve.jpoint(this.x, this.y.redNeg(), this.z);
    };
    JPoint.prototype.add = function add(p) {
      if (this.isInfinity())
        return p;
      if (p.isInfinity())
        return this;
      var pz2 = p.z.redSqr();
      var z2 = this.z.redSqr();
      var u1 = this.x.redMul(pz2);
      var u2 = p.x.redMul(z2);
      var s1 = this.y.redMul(pz2.redMul(p.z));
      var s2 = p.y.redMul(z2.redMul(this.z));
      var h = u1.redSub(u2);
      var r = s1.redSub(s2);
      if (h.cmpn(0) === 0) {
        if (r.cmpn(0) !== 0)
          return this.curve.jpoint(null, null, null);
        else
          return this.dbl();
      }
      var h2 = h.redSqr();
      var h3 = h2.redMul(h);
      var v = u1.redMul(h2);
      var nx = r.redSqr().redIAdd(h3).redISub(v).redISub(v);
      var ny = r.redMul(v.redISub(nx)).redISub(s1.redMul(h3));
      var nz = this.z.redMul(p.z).redMul(h);
      return this.curve.jpoint(nx, ny, nz);
    };
    JPoint.prototype.mixedAdd = function mixedAdd(p) {
      if (this.isInfinity())
        return p.toJ();
      if (p.isInfinity())
        return this;
      var z2 = this.z.redSqr();
      var u1 = this.x;
      var u2 = p.x.redMul(z2);
      var s1 = this.y;
      var s2 = p.y.redMul(z2).redMul(this.z);
      var h = u1.redSub(u2);
      var r = s1.redSub(s2);
      if (h.cmpn(0) === 0) {
        if (r.cmpn(0) !== 0)
          return this.curve.jpoint(null, null, null);
        else
          return this.dbl();
      }
      var h2 = h.redSqr();
      var h3 = h2.redMul(h);
      var v = u1.redMul(h2);
      var nx = r.redSqr().redIAdd(h3).redISub(v).redISub(v);
      var ny = r.redMul(v.redISub(nx)).redISub(s1.redMul(h3));
      var nz = this.z.redMul(h);
      return this.curve.jpoint(nx, ny, nz);
    };
    JPoint.prototype.dblp = function dblp(pow) {
      if (pow === 0)
        return this;
      if (this.isInfinity())
        return this;
      if (!pow)
        return this.dbl();
      var i;
      if (this.curve.zeroA || this.curve.threeA) {
        var r = this;
        for (i = 0; i < pow; i++)
          r = r.dbl();
        return r;
      }
      var a = this.curve.a;
      var tinv = this.curve.tinv;
      var jx = this.x;
      var jy = this.y;
      var jz = this.z;
      var jz4 = jz.redSqr().redSqr();
      var jyd = jy.redAdd(jy);
      for (i = 0; i < pow; i++) {
        var jx2 = jx.redSqr();
        var jyd2 = jyd.redSqr();
        var jyd4 = jyd2.redSqr();
        var c = jx2.redAdd(jx2).redIAdd(jx2).redIAdd(a.redMul(jz4));
        var t1 = jx.redMul(jyd2);
        var nx = c.redSqr().redISub(t1.redAdd(t1));
        var t2 = t1.redISub(nx);
        var dny = c.redMul(t2);
        dny = dny.redIAdd(dny).redISub(jyd4);
        var nz = jyd.redMul(jz);
        if (i + 1 < pow)
          jz4 = jz4.redMul(jyd4);
        jx = nx;
        jz = nz;
        jyd = dny;
      }
      return this.curve.jpoint(jx, jyd.redMul(tinv), jz);
    };
    JPoint.prototype.dbl = function dbl() {
      if (this.isInfinity())
        return this;
      if (this.curve.zeroA)
        return this._zeroDbl();
      else if (this.curve.threeA)
        return this._threeDbl();
      else
        return this._dbl();
    };
    JPoint.prototype._zeroDbl = function _zeroDbl() {
      var nx;
      var ny;
      var nz;
      if (this.zOne) {
        var xx = this.x.redSqr();
        var yy = this.y.redSqr();
        var yyyy = yy.redSqr();
        var s = this.x.redAdd(yy).redSqr().redISub(xx).redISub(yyyy);
        s = s.redIAdd(s);
        var m = xx.redAdd(xx).redIAdd(xx);
        var t = m.redSqr().redISub(s).redISub(s);
        var yyyy8 = yyyy.redIAdd(yyyy);
        yyyy8 = yyyy8.redIAdd(yyyy8);
        yyyy8 = yyyy8.redIAdd(yyyy8);
        nx = t;
        ny = m.redMul(s.redISub(t)).redISub(yyyy8);
        nz = this.y.redAdd(this.y);
      } else {
        var a = this.x.redSqr();
        var b = this.y.redSqr();
        var c = b.redSqr();
        var d = this.x.redAdd(b).redSqr().redISub(a).redISub(c);
        d = d.redIAdd(d);
        var e = a.redAdd(a).redIAdd(a);
        var f = e.redSqr();
        var c8 = c.redIAdd(c);
        c8 = c8.redIAdd(c8);
        c8 = c8.redIAdd(c8);
        nx = f.redISub(d).redISub(d);
        ny = e.redMul(d.redISub(nx)).redISub(c8);
        nz = this.y.redMul(this.z);
        nz = nz.redIAdd(nz);
      }
      return this.curve.jpoint(nx, ny, nz);
    };
    JPoint.prototype._threeDbl = function _threeDbl() {
      var nx;
      var ny;
      var nz;
      if (this.zOne) {
        var xx = this.x.redSqr();
        var yy = this.y.redSqr();
        var yyyy = yy.redSqr();
        var s = this.x.redAdd(yy).redSqr().redISub(xx).redISub(yyyy);
        s = s.redIAdd(s);
        var m = xx.redAdd(xx).redIAdd(xx).redIAdd(this.curve.a);
        var t = m.redSqr().redISub(s).redISub(s);
        nx = t;
        var yyyy8 = yyyy.redIAdd(yyyy);
        yyyy8 = yyyy8.redIAdd(yyyy8);
        yyyy8 = yyyy8.redIAdd(yyyy8);
        ny = m.redMul(s.redISub(t)).redISub(yyyy8);
        nz = this.y.redAdd(this.y);
      } else {
        var delta = this.z.redSqr();
        var gamma = this.y.redSqr();
        var beta = this.x.redMul(gamma);
        var alpha = this.x.redSub(delta).redMul(this.x.redAdd(delta));
        alpha = alpha.redAdd(alpha).redIAdd(alpha);
        var beta4 = beta.redIAdd(beta);
        beta4 = beta4.redIAdd(beta4);
        var beta8 = beta4.redAdd(beta4);
        nx = alpha.redSqr().redISub(beta8);
        nz = this.y.redAdd(this.z).redSqr().redISub(gamma).redISub(delta);
        var ggamma8 = gamma.redSqr();
        ggamma8 = ggamma8.redIAdd(ggamma8);
        ggamma8 = ggamma8.redIAdd(ggamma8);
        ggamma8 = ggamma8.redIAdd(ggamma8);
        ny = alpha.redMul(beta4.redISub(nx)).redISub(ggamma8);
      }
      return this.curve.jpoint(nx, ny, nz);
    };
    JPoint.prototype._dbl = function _dbl() {
      var a = this.curve.a;
      var jx = this.x;
      var jy = this.y;
      var jz = this.z;
      var jz4 = jz.redSqr().redSqr();
      var jx2 = jx.redSqr();
      var jy2 = jy.redSqr();
      var c = jx2.redAdd(jx2).redIAdd(jx2).redIAdd(a.redMul(jz4));
      var jxd4 = jx.redAdd(jx);
      jxd4 = jxd4.redIAdd(jxd4);
      var t1 = jxd4.redMul(jy2);
      var nx = c.redSqr().redISub(t1.redAdd(t1));
      var t2 = t1.redISub(nx);
      var jyd8 = jy2.redSqr();
      jyd8 = jyd8.redIAdd(jyd8);
      jyd8 = jyd8.redIAdd(jyd8);
      jyd8 = jyd8.redIAdd(jyd8);
      var ny = c.redMul(t2).redISub(jyd8);
      var nz = jy.redAdd(jy).redMul(jz);
      return this.curve.jpoint(nx, ny, nz);
    };
    JPoint.prototype.trpl = function trpl() {
      if (!this.curve.zeroA)
        return this.dbl().add(this);
      var xx = this.x.redSqr();
      var yy = this.y.redSqr();
      var zz = this.z.redSqr();
      var yyyy = yy.redSqr();
      var m = xx.redAdd(xx).redIAdd(xx);
      var mm = m.redSqr();
      var e = this.x.redAdd(yy).redSqr().redISub(xx).redISub(yyyy);
      e = e.redIAdd(e);
      e = e.redAdd(e).redIAdd(e);
      e = e.redISub(mm);
      var ee = e.redSqr();
      var t = yyyy.redIAdd(yyyy);
      t = t.redIAdd(t);
      t = t.redIAdd(t);
      t = t.redIAdd(t);
      var u = m.redIAdd(e).redSqr().redISub(mm).redISub(ee).redISub(t);
      var yyu4 = yy.redMul(u);
      yyu4 = yyu4.redIAdd(yyu4);
      yyu4 = yyu4.redIAdd(yyu4);
      var nx = this.x.redMul(ee).redISub(yyu4);
      nx = nx.redIAdd(nx);
      nx = nx.redIAdd(nx);
      var ny = this.y.redMul(u.redMul(t.redISub(u)).redISub(e.redMul(ee)));
      ny = ny.redIAdd(ny);
      ny = ny.redIAdd(ny);
      ny = ny.redIAdd(ny);
      var nz = this.z.redAdd(e).redSqr().redISub(zz).redISub(ee);
      return this.curve.jpoint(nx, ny, nz);
    };
    JPoint.prototype.mul = function mul(k, kbase) {
      k = new BN(k, kbase);
      return this.curve._wnafMul(this, k);
    };
    JPoint.prototype.eq = function eq(p) {
      if (p.type === "affine")
        return this.eq(p.toJ());
      if (this === p)
        return true;
      var z2 = this.z.redSqr();
      var pz2 = p.z.redSqr();
      if (this.x.redMul(pz2).redISub(p.x.redMul(z2)).cmpn(0) !== 0)
        return false;
      var z3 = z2.redMul(this.z);
      var pz3 = pz2.redMul(p.z);
      return this.y.redMul(pz3).redISub(p.y.redMul(z3)).cmpn(0) === 0;
    };
    JPoint.prototype.eqXToP = function eqXToP(x) {
      var zs = this.z.redSqr();
      var rx = x.toRed(this.curve.red).redMul(zs);
      if (this.x.cmp(rx) === 0)
        return true;
      var xc = x.clone();
      var t = this.curve.redN.redMul(zs);
      for (; ; ) {
        xc.iadd(this.curve.n);
        if (xc.cmp(this.curve.p) >= 0)
          return false;
        rx.redIAdd(t);
        if (this.x.cmp(rx) === 0)
          return true;
      }
    };
    JPoint.prototype.inspect = function inspect() {
      if (this.isInfinity())
        return "<EC JPoint Infinity>";
      return "<EC JPoint x: " + this.x.toString(16, 2) + " y: " + this.y.toString(16, 2) + " z: " + this.z.toString(16, 2) + ">";
    };
    JPoint.prototype.isInfinity = function isInfinity() {
      return this.z.cmpn(0) === 0;
    };
  }
});

// node_modules/elliptic/lib/elliptic/curve/mont.js
var require_mont = __commonJS({
  "node_modules/elliptic/lib/elliptic/curve/mont.js"(exports2, module2) {
    "use strict";
    var BN = require_bn();
    var inherits = require_inherits();
    var Base = require_base();
    var utils = require_utils2();
    function MontCurve(conf) {
      Base.call(this, "mont", conf);
      this.a = new BN(conf.a, 16).toRed(this.red);
      this.b = new BN(conf.b, 16).toRed(this.red);
      this.i4 = new BN(4).toRed(this.red).redInvm();
      this.two = new BN(2).toRed(this.red);
      this.a24 = this.i4.redMul(this.a.redAdd(this.two));
    }
    inherits(MontCurve, Base);
    module2.exports = MontCurve;
    MontCurve.prototype.validate = function validate(point) {
      var x = point.normalize().x;
      var x2 = x.redSqr();
      var rhs = x2.redMul(x).redAdd(x2.redMul(this.a)).redAdd(x);
      var y = rhs.redSqrt();
      return y.redSqr().cmp(rhs) === 0;
    };
    function Point(curve, x, z) {
      Base.BasePoint.call(this, curve, "projective");
      if (x === null && z === null) {
        this.x = this.curve.one;
        this.z = this.curve.zero;
      } else {
        this.x = new BN(x, 16);
        this.z = new BN(z, 16);
        if (!this.x.red)
          this.x = this.x.toRed(this.curve.red);
        if (!this.z.red)
          this.z = this.z.toRed(this.curve.red);
      }
    }
    inherits(Point, Base.BasePoint);
    MontCurve.prototype.decodePoint = function decodePoint(bytes, enc) {
      return this.point(utils.toArray(bytes, enc), 1);
    };
    MontCurve.prototype.point = function point(x, z) {
      return new Point(this, x, z);
    };
    MontCurve.prototype.pointFromJSON = function pointFromJSON(obj) {
      return Point.fromJSON(this, obj);
    };
    Point.prototype.precompute = function precompute() {
    };
    Point.prototype._encode = function _encode() {
      return this.getX().toArray("be", this.curve.p.byteLength());
    };
    Point.fromJSON = function fromJSON(curve, obj) {
      return new Point(curve, obj[0], obj[1] || curve.one);
    };
    Point.prototype.inspect = function inspect() {
      if (this.isInfinity())
        return "<EC Point Infinity>";
      return "<EC Point x: " + this.x.fromRed().toString(16, 2) + " z: " + this.z.fromRed().toString(16, 2) + ">";
    };
    Point.prototype.isInfinity = function isInfinity() {
      return this.z.cmpn(0) === 0;
    };
    Point.prototype.dbl = function dbl() {
      var a = this.x.redAdd(this.z);
      var aa = a.redSqr();
      var b = this.x.redSub(this.z);
      var bb = b.redSqr();
      var c = aa.redSub(bb);
      var nx = aa.redMul(bb);
      var nz = c.redMul(bb.redAdd(this.curve.a24.redMul(c)));
      return this.curve.point(nx, nz);
    };
    Point.prototype.add = function add() {
      throw new Error("Not supported on Montgomery curve");
    };
    Point.prototype.diffAdd = function diffAdd(p, diff) {
      var a = this.x.redAdd(this.z);
      var b = this.x.redSub(this.z);
      var c = p.x.redAdd(p.z);
      var d = p.x.redSub(p.z);
      var da = d.redMul(a);
      var cb = c.redMul(b);
      var nx = diff.z.redMul(da.redAdd(cb).redSqr());
      var nz = diff.x.redMul(da.redISub(cb).redSqr());
      return this.curve.point(nx, nz);
    };
    Point.prototype.mul = function mul(k) {
      var t = k.clone();
      var a = this;
      var b = this.curve.point(null, null);
      var c = this;
      for (var bits = []; t.cmpn(0) !== 0; t.iushrn(1))
        bits.push(t.andln(1));
      for (var i = bits.length - 1; i >= 0; i--) {
        if (bits[i] === 0) {
          a = a.diffAdd(b, c);
          b = b.dbl();
        } else {
          b = a.diffAdd(b, c);
          a = a.dbl();
        }
      }
      return b;
    };
    Point.prototype.mulAdd = function mulAdd() {
      throw new Error("Not supported on Montgomery curve");
    };
    Point.prototype.jumlAdd = function jumlAdd() {
      throw new Error("Not supported on Montgomery curve");
    };
    Point.prototype.eq = function eq(other) {
      return this.getX().cmp(other.getX()) === 0;
    };
    Point.prototype.normalize = function normalize() {
      this.x = this.x.redMul(this.z.redInvm());
      this.z = this.curve.one;
      return this;
    };
    Point.prototype.getX = function getX() {
      this.normalize();
      return this.x.fromRed();
    };
  }
});

// node_modules/elliptic/lib/elliptic/curve/edwards.js
var require_edwards = __commonJS({
  "node_modules/elliptic/lib/elliptic/curve/edwards.js"(exports2, module2) {
    "use strict";
    var utils = require_utils2();
    var BN = require_bn();
    var inherits = require_inherits();
    var Base = require_base();
    var assert = utils.assert;
    function EdwardsCurve(conf) {
      this.twisted = (conf.a | 0) !== 1;
      this.mOneA = this.twisted && (conf.a | 0) === -1;
      this.extended = this.mOneA;
      Base.call(this, "edwards", conf);
      this.a = new BN(conf.a, 16).umod(this.red.m);
      this.a = this.a.toRed(this.red);
      this.c = new BN(conf.c, 16).toRed(this.red);
      this.c2 = this.c.redSqr();
      this.d = new BN(conf.d, 16).toRed(this.red);
      this.dd = this.d.redAdd(this.d);
      assert(!this.twisted || this.c.fromRed().cmpn(1) === 0);
      this.oneC = (conf.c | 0) === 1;
    }
    inherits(EdwardsCurve, Base);
    module2.exports = EdwardsCurve;
    EdwardsCurve.prototype._mulA = function _mulA(num) {
      if (this.mOneA)
        return num.redNeg();
      else
        return this.a.redMul(num);
    };
    EdwardsCurve.prototype._mulC = function _mulC(num) {
      if (this.oneC)
        return num;
      else
        return this.c.redMul(num);
    };
    EdwardsCurve.prototype.jpoint = function jpoint(x, y, z, t) {
      return this.point(x, y, z, t);
    };
    EdwardsCurve.prototype.pointFromX = function pointFromX(x, odd) {
      x = new BN(x, 16);
      if (!x.red)
        x = x.toRed(this.red);
      var x2 = x.redSqr();
      var rhs = this.c2.redSub(this.a.redMul(x2));
      var lhs = this.one.redSub(this.c2.redMul(this.d).redMul(x2));
      var y2 = rhs.redMul(lhs.redInvm());
      var y = y2.redSqrt();
      if (y.redSqr().redSub(y2).cmp(this.zero) !== 0)
        throw new Error("invalid point");
      var isOdd = y.fromRed().isOdd();
      if (odd && !isOdd || !odd && isOdd)
        y = y.redNeg();
      return this.point(x, y);
    };
    EdwardsCurve.prototype.pointFromY = function pointFromY(y, odd) {
      y = new BN(y, 16);
      if (!y.red)
        y = y.toRed(this.red);
      var y2 = y.redSqr();
      var lhs = y2.redSub(this.c2);
      var rhs = y2.redMul(this.d).redMul(this.c2).redSub(this.a);
      var x2 = lhs.redMul(rhs.redInvm());
      if (x2.cmp(this.zero) === 0) {
        if (odd)
          throw new Error("invalid point");
        else
          return this.point(this.zero, y);
      }
      var x = x2.redSqrt();
      if (x.redSqr().redSub(x2).cmp(this.zero) !== 0)
        throw new Error("invalid point");
      if (x.fromRed().isOdd() !== odd)
        x = x.redNeg();
      return this.point(x, y);
    };
    EdwardsCurve.prototype.validate = function validate(point) {
      if (point.isInfinity())
        return true;
      point.normalize();
      var x2 = point.x.redSqr();
      var y2 = point.y.redSqr();
      var lhs = x2.redMul(this.a).redAdd(y2);
      var rhs = this.c2.redMul(this.one.redAdd(this.d.redMul(x2).redMul(y2)));
      return lhs.cmp(rhs) === 0;
    };
    function Point(curve, x, y, z, t) {
      Base.BasePoint.call(this, curve, "projective");
      if (x === null && y === null && z === null) {
        this.x = this.curve.zero;
        this.y = this.curve.one;
        this.z = this.curve.one;
        this.t = this.curve.zero;
        this.zOne = true;
      } else {
        this.x = new BN(x, 16);
        this.y = new BN(y, 16);
        this.z = z ? new BN(z, 16) : this.curve.one;
        this.t = t && new BN(t, 16);
        if (!this.x.red)
          this.x = this.x.toRed(this.curve.red);
        if (!this.y.red)
          this.y = this.y.toRed(this.curve.red);
        if (!this.z.red)
          this.z = this.z.toRed(this.curve.red);
        if (this.t && !this.t.red)
          this.t = this.t.toRed(this.curve.red);
        this.zOne = this.z === this.curve.one;
        if (this.curve.extended && !this.t) {
          this.t = this.x.redMul(this.y);
          if (!this.zOne)
            this.t = this.t.redMul(this.z.redInvm());
        }
      }
    }
    inherits(Point, Base.BasePoint);
    EdwardsCurve.prototype.pointFromJSON = function pointFromJSON(obj) {
      return Point.fromJSON(this, obj);
    };
    EdwardsCurve.prototype.point = function point(x, y, z, t) {
      return new Point(this, x, y, z, t);
    };
    Point.fromJSON = function fromJSON(curve, obj) {
      return new Point(curve, obj[0], obj[1], obj[2]);
    };
    Point.prototype.inspect = function inspect() {
      if (this.isInfinity())
        return "<EC Point Infinity>";
      return "<EC Point x: " + this.x.fromRed().toString(16, 2) + " y: " + this.y.fromRed().toString(16, 2) + " z: " + this.z.fromRed().toString(16, 2) + ">";
    };
    Point.prototype.isInfinity = function isInfinity() {
      return this.x.cmpn(0) === 0 && (this.y.cmp(this.z) === 0 || this.zOne && this.y.cmp(this.curve.c) === 0);
    };
    Point.prototype._extDbl = function _extDbl() {
      var a = this.x.redSqr();
      var b = this.y.redSqr();
      var c = this.z.redSqr();
      c = c.redIAdd(c);
      var d = this.curve._mulA(a);
      var e = this.x.redAdd(this.y).redSqr().redISub(a).redISub(b);
      var g = d.redAdd(b);
      var f = g.redSub(c);
      var h = d.redSub(b);
      var nx = e.redMul(f);
      var ny = g.redMul(h);
      var nt = e.redMul(h);
      var nz = f.redMul(g);
      return this.curve.point(nx, ny, nz, nt);
    };
    Point.prototype._projDbl = function _projDbl() {
      var b = this.x.redAdd(this.y).redSqr();
      var c = this.x.redSqr();
      var d = this.y.redSqr();
      var nx;
      var ny;
      var nz;
      var e;
      var h;
      var j;
      if (this.curve.twisted) {
        e = this.curve._mulA(c);
        var f = e.redAdd(d);
        if (this.zOne) {
          nx = b.redSub(c).redSub(d).redMul(f.redSub(this.curve.two));
          ny = f.redMul(e.redSub(d));
          nz = f.redSqr().redSub(f).redSub(f);
        } else {
          h = this.z.redSqr();
          j = f.redSub(h).redISub(h);
          nx = b.redSub(c).redISub(d).redMul(j);
          ny = f.redMul(e.redSub(d));
          nz = f.redMul(j);
        }
      } else {
        e = c.redAdd(d);
        h = this.curve._mulC(this.z).redSqr();
        j = e.redSub(h).redSub(h);
        nx = this.curve._mulC(b.redISub(e)).redMul(j);
        ny = this.curve._mulC(e).redMul(c.redISub(d));
        nz = e.redMul(j);
      }
      return this.curve.point(nx, ny, nz);
    };
    Point.prototype.dbl = function dbl() {
      if (this.isInfinity())
        return this;
      if (this.curve.extended)
        return this._extDbl();
      else
        return this._projDbl();
    };
    Point.prototype._extAdd = function _extAdd(p) {
      var a = this.y.redSub(this.x).redMul(p.y.redSub(p.x));
      var b = this.y.redAdd(this.x).redMul(p.y.redAdd(p.x));
      var c = this.t.redMul(this.curve.dd).redMul(p.t);
      var d = this.z.redMul(p.z.redAdd(p.z));
      var e = b.redSub(a);
      var f = d.redSub(c);
      var g = d.redAdd(c);
      var h = b.redAdd(a);
      var nx = e.redMul(f);
      var ny = g.redMul(h);
      var nt = e.redMul(h);
      var nz = f.redMul(g);
      return this.curve.point(nx, ny, nz, nt);
    };
    Point.prototype._projAdd = function _projAdd(p) {
      var a = this.z.redMul(p.z);
      var b = a.redSqr();
      var c = this.x.redMul(p.x);
      var d = this.y.redMul(p.y);
      var e = this.curve.d.redMul(c).redMul(d);
      var f = b.redSub(e);
      var g = b.redAdd(e);
      var tmp = this.x.redAdd(this.y).redMul(p.x.redAdd(p.y)).redISub(c).redISub(d);
      var nx = a.redMul(f).redMul(tmp);
      var ny;
      var nz;
      if (this.curve.twisted) {
        ny = a.redMul(g).redMul(d.redSub(this.curve._mulA(c)));
        nz = f.redMul(g);
      } else {
        ny = a.redMul(g).redMul(d.redSub(c));
        nz = this.curve._mulC(f).redMul(g);
      }
      return this.curve.point(nx, ny, nz);
    };
    Point.prototype.add = function add(p) {
      if (this.isInfinity())
        return p;
      if (p.isInfinity())
        return this;
      if (this.curve.extended)
        return this._extAdd(p);
      else
        return this._projAdd(p);
    };
    Point.prototype.mul = function mul(k) {
      if (this._hasDoubles(k))
        return this.curve._fixedNafMul(this, k);
      else
        return this.curve._wnafMul(this, k);
    };
    Point.prototype.mulAdd = function mulAdd(k1, p, k2) {
      return this.curve._wnafMulAdd(1, [this, p], [k1, k2], 2, false);
    };
    Point.prototype.jmulAdd = function jmulAdd(k1, p, k2) {
      return this.curve._wnafMulAdd(1, [this, p], [k1, k2], 2, true);
    };
    Point.prototype.normalize = function normalize() {
      if (this.zOne)
        return this;
      var zi = this.z.redInvm();
      this.x = this.x.redMul(zi);
      this.y = this.y.redMul(zi);
      if (this.t)
        this.t = this.t.redMul(zi);
      this.z = this.curve.one;
      this.zOne = true;
      return this;
    };
    Point.prototype.neg = function neg() {
      return this.curve.point(
        this.x.redNeg(),
        this.y,
        this.z,
        this.t && this.t.redNeg()
      );
    };
    Point.prototype.getX = function getX() {
      this.normalize();
      return this.x.fromRed();
    };
    Point.prototype.getY = function getY() {
      this.normalize();
      return this.y.fromRed();
    };
    Point.prototype.eq = function eq(other) {
      return this === other || this.getX().cmp(other.getX()) === 0 && this.getY().cmp(other.getY()) === 0;
    };
    Point.prototype.eqXToP = function eqXToP(x) {
      var rx = x.toRed(this.curve.red).redMul(this.z);
      if (this.x.cmp(rx) === 0)
        return true;
      var xc = x.clone();
      var t = this.curve.redN.redMul(this.z);
      for (; ; ) {
        xc.iadd(this.curve.n);
        if (xc.cmp(this.curve.p) >= 0)
          return false;
        rx.redIAdd(t);
        if (this.x.cmp(rx) === 0)
          return true;
      }
    };
    Point.prototype.toP = Point.prototype.normalize;
    Point.prototype.mixedAdd = Point.prototype.add;
  }
});

// node_modules/elliptic/lib/elliptic/curve/index.js
var require_curve = __commonJS({
  "node_modules/elliptic/lib/elliptic/curve/index.js"(exports2) {
    "use strict";
    var curve = exports2;
    curve.base = require_base();
    curve.short = require_short();
    curve.mont = require_mont();
    curve.edwards = require_edwards();
  }
});

// node_modules/hash.js/lib/hash/utils.js
var require_utils3 = __commonJS({
  "node_modules/hash.js/lib/hash/utils.js"(exports2) {
    "use strict";
    var assert = require_minimalistic_assert();
    var inherits = require_inherits();
    exports2.inherits = inherits;
    function isSurrogatePair(msg, i) {
      if ((msg.charCodeAt(i) & 64512) !== 55296) {
        return false;
      }
      if (i < 0 || i + 1 >= msg.length) {
        return false;
      }
      return (msg.charCodeAt(i + 1) & 64512) === 56320;
    }
    function toArray(msg, enc) {
      if (Array.isArray(msg))
        return msg.slice();
      if (!msg)
        return [];
      var res = [];
      if (typeof msg === "string") {
        if (!enc) {
          var p = 0;
          for (var i = 0; i < msg.length; i++) {
            var c = msg.charCodeAt(i);
            if (c < 128) {
              res[p++] = c;
            } else if (c < 2048) {
              res[p++] = c >> 6 | 192;
              res[p++] = c & 63 | 128;
            } else if (isSurrogatePair(msg, i)) {
              c = 65536 + ((c & 1023) << 10) + (msg.charCodeAt(++i) & 1023);
              res[p++] = c >> 18 | 240;
              res[p++] = c >> 12 & 63 | 128;
              res[p++] = c >> 6 & 63 | 128;
              res[p++] = c & 63 | 128;
            } else {
              res[p++] = c >> 12 | 224;
              res[p++] = c >> 6 & 63 | 128;
              res[p++] = c & 63 | 128;
            }
          }
        } else if (enc === "hex") {
          msg = msg.replace(/[^a-z0-9]+/ig, "");
          if (msg.length % 2 !== 0)
            msg = "0" + msg;
          for (i = 0; i < msg.length; i += 2)
            res.push(parseInt(msg[i] + msg[i + 1], 16));
        }
      } else {
        for (i = 0; i < msg.length; i++)
          res[i] = msg[i] | 0;
      }
      return res;
    }
    exports2.toArray = toArray;
    function toHex(msg) {
      var res = "";
      for (var i = 0; i < msg.length; i++)
        res += zero2(msg[i].toString(16));
      return res;
    }
    exports2.toHex = toHex;
    function htonl(w) {
      var res = w >>> 24 | w >>> 8 & 65280 | w << 8 & 16711680 | (w & 255) << 24;
      return res >>> 0;
    }
    exports2.htonl = htonl;
    function toHex32(msg, endian) {
      var res = "";
      for (var i = 0; i < msg.length; i++) {
        var w = msg[i];
        if (endian === "little")
          w = htonl(w);
        res += zero8(w.toString(16));
      }
      return res;
    }
    exports2.toHex32 = toHex32;
    function zero2(word) {
      if (word.length === 1)
        return "0" + word;
      else
        return word;
    }
    exports2.zero2 = zero2;
    function zero8(word) {
      if (word.length === 7)
        return "0" + word;
      else if (word.length === 6)
        return "00" + word;
      else if (word.length === 5)
        return "000" + word;
      else if (word.length === 4)
        return "0000" + word;
      else if (word.length === 3)
        return "00000" + word;
      else if (word.length === 2)
        return "000000" + word;
      else if (word.length === 1)
        return "0000000" + word;
      else
        return word;
    }
    exports2.zero8 = zero8;
    function join32(msg, start, end, endian) {
      var len = end - start;
      assert(len % 4 === 0);
      var res = new Array(len / 4);
      for (var i = 0, k = start; i < res.length; i++, k += 4) {
        var w;
        if (endian === "big")
          w = msg[k] << 24 | msg[k + 1] << 16 | msg[k + 2] << 8 | msg[k + 3];
        else
          w = msg[k + 3] << 24 | msg[k + 2] << 16 | msg[k + 1] << 8 | msg[k];
        res[i] = w >>> 0;
      }
      return res;
    }
    exports2.join32 = join32;
    function split32(msg, endian) {
      var res = new Array(msg.length * 4);
      for (var i = 0, k = 0; i < msg.length; i++, k += 4) {
        var m = msg[i];
        if (endian === "big") {
          res[k] = m >>> 24;
          res[k + 1] = m >>> 16 & 255;
          res[k + 2] = m >>> 8 & 255;
          res[k + 3] = m & 255;
        } else {
          res[k + 3] = m >>> 24;
          res[k + 2] = m >>> 16 & 255;
          res[k + 1] = m >>> 8 & 255;
          res[k] = m & 255;
        }
      }
      return res;
    }
    exports2.split32 = split32;
    function rotr32(w, b) {
      return w >>> b | w << 32 - b;
    }
    exports2.rotr32 = rotr32;
    function rotl32(w, b) {
      return w << b | w >>> 32 - b;
    }
    exports2.rotl32 = rotl32;
    function sum32(a, b) {
      return a + b >>> 0;
    }
    exports2.sum32 = sum32;
    function sum32_3(a, b, c) {
      return a + b + c >>> 0;
    }
    exports2.sum32_3 = sum32_3;
    function sum32_4(a, b, c, d) {
      return a + b + c + d >>> 0;
    }
    exports2.sum32_4 = sum32_4;
    function sum32_5(a, b, c, d, e) {
      return a + b + c + d + e >>> 0;
    }
    exports2.sum32_5 = sum32_5;
    function sum64(buf, pos, ah, al) {
      var bh = buf[pos];
      var bl = buf[pos + 1];
      var lo = al + bl >>> 0;
      var hi = (lo < al ? 1 : 0) + ah + bh;
      buf[pos] = hi >>> 0;
      buf[pos + 1] = lo;
    }
    exports2.sum64 = sum64;
    function sum64_hi(ah, al, bh, bl) {
      var lo = al + bl >>> 0;
      var hi = (lo < al ? 1 : 0) + ah + bh;
      return hi >>> 0;
    }
    exports2.sum64_hi = sum64_hi;
    function sum64_lo(ah, al, bh, bl) {
      var lo = al + bl;
      return lo >>> 0;
    }
    exports2.sum64_lo = sum64_lo;
    function sum64_4_hi(ah, al, bh, bl, ch, cl, dh, dl) {
      var carry = 0;
      var lo = al;
      lo = lo + bl >>> 0;
      carry += lo < al ? 1 : 0;
      lo = lo + cl >>> 0;
      carry += lo < cl ? 1 : 0;
      lo = lo + dl >>> 0;
      carry += lo < dl ? 1 : 0;
      var hi = ah + bh + ch + dh + carry;
      return hi >>> 0;
    }
    exports2.sum64_4_hi = sum64_4_hi;
    function sum64_4_lo(ah, al, bh, bl, ch, cl, dh, dl) {
      var lo = al + bl + cl + dl;
      return lo >>> 0;
    }
    exports2.sum64_4_lo = sum64_4_lo;
    function sum64_5_hi(ah, al, bh, bl, ch, cl, dh, dl, eh, el) {
      var carry = 0;
      var lo = al;
      lo = lo + bl >>> 0;
      carry += lo < al ? 1 : 0;
      lo = lo + cl >>> 0;
      carry += lo < cl ? 1 : 0;
      lo = lo + dl >>> 0;
      carry += lo < dl ? 1 : 0;
      lo = lo + el >>> 0;
      carry += lo < el ? 1 : 0;
      var hi = ah + bh + ch + dh + eh + carry;
      return hi >>> 0;
    }
    exports2.sum64_5_hi = sum64_5_hi;
    function sum64_5_lo(ah, al, bh, bl, ch, cl, dh, dl, eh, el) {
      var lo = al + bl + cl + dl + el;
      return lo >>> 0;
    }
    exports2.sum64_5_lo = sum64_5_lo;
    function rotr64_hi(ah, al, num) {
      var r = al << 32 - num | ah >>> num;
      return r >>> 0;
    }
    exports2.rotr64_hi = rotr64_hi;
    function rotr64_lo(ah, al, num) {
      var r = ah << 32 - num | al >>> num;
      return r >>> 0;
    }
    exports2.rotr64_lo = rotr64_lo;
    function shr64_hi(ah, al, num) {
      return ah >>> num;
    }
    exports2.shr64_hi = shr64_hi;
    function shr64_lo(ah, al, num) {
      var r = ah << 32 - num | al >>> num;
      return r >>> 0;
    }
    exports2.shr64_lo = shr64_lo;
  }
});

// node_modules/hash.js/lib/hash/common.js
var require_common = __commonJS({
  "node_modules/hash.js/lib/hash/common.js"(exports2) {
    "use strict";
    var utils = require_utils3();
    var assert = require_minimalistic_assert();
    function BlockHash() {
      this.pending = null;
      this.pendingTotal = 0;
      this.blockSize = this.constructor.blockSize;
      this.outSize = this.constructor.outSize;
      this.hmacStrength = this.constructor.hmacStrength;
      this.padLength = this.constructor.padLength / 8;
      this.endian = "big";
      this._delta8 = this.blockSize / 8;
      this._delta32 = this.blockSize / 32;
    }
    exports2.BlockHash = BlockHash;
    BlockHash.prototype.update = function update(msg, enc) {
      msg = utils.toArray(msg, enc);
      if (!this.pending)
        this.pending = msg;
      else
        this.pending = this.pending.concat(msg);
      this.pendingTotal += msg.length;
      if (this.pending.length >= this._delta8) {
        msg = this.pending;
        var r = msg.length % this._delta8;
        this.pending = msg.slice(msg.length - r, msg.length);
        if (this.pending.length === 0)
          this.pending = null;
        msg = utils.join32(msg, 0, msg.length - r, this.endian);
        for (var i = 0; i < msg.length; i += this._delta32)
          this._update(msg, i, i + this._delta32);
      }
      return this;
    };
    BlockHash.prototype.digest = function digest(enc) {
      this.update(this._pad());
      assert(this.pending === null);
      return this._digest(enc);
    };
    BlockHash.prototype._pad = function pad() {
      var len = this.pendingTotal;
      var bytes = this._delta8;
      var k = bytes - (len + this.padLength) % bytes;
      var res = new Array(k + this.padLength);
      res[0] = 128;
      for (var i = 1; i < k; i++)
        res[i] = 0;
      len <<= 3;
      if (this.endian === "big") {
        for (var t = 8; t < this.padLength; t++)
          res[i++] = 0;
        res[i++] = 0;
        res[i++] = 0;
        res[i++] = 0;
        res[i++] = 0;
        res[i++] = len >>> 24 & 255;
        res[i++] = len >>> 16 & 255;
        res[i++] = len >>> 8 & 255;
        res[i++] = len & 255;
      } else {
        res[i++] = len & 255;
        res[i++] = len >>> 8 & 255;
        res[i++] = len >>> 16 & 255;
        res[i++] = len >>> 24 & 255;
        res[i++] = 0;
        res[i++] = 0;
        res[i++] = 0;
        res[i++] = 0;
        for (t = 8; t < this.padLength; t++)
          res[i++] = 0;
      }
      return res;
    };
  }
});

// node_modules/hash.js/lib/hash/sha/common.js
var require_common2 = __commonJS({
  "node_modules/hash.js/lib/hash/sha/common.js"(exports2) {
    "use strict";
    var utils = require_utils3();
    var rotr32 = utils.rotr32;
    function ft_1(s, x, y, z) {
      if (s === 0)
        return ch32(x, y, z);
      if (s === 1 || s === 3)
        return p32(x, y, z);
      if (s === 2)
        return maj32(x, y, z);
    }
    exports2.ft_1 = ft_1;
    function ch32(x, y, z) {
      return x & y ^ ~x & z;
    }
    exports2.ch32 = ch32;
    function maj32(x, y, z) {
      return x & y ^ x & z ^ y & z;
    }
    exports2.maj32 = maj32;
    function p32(x, y, z) {
      return x ^ y ^ z;
    }
    exports2.p32 = p32;
    function s0_256(x) {
      return rotr32(x, 2) ^ rotr32(x, 13) ^ rotr32(x, 22);
    }
    exports2.s0_256 = s0_256;
    function s1_256(x) {
      return rotr32(x, 6) ^ rotr32(x, 11) ^ rotr32(x, 25);
    }
    exports2.s1_256 = s1_256;
    function g0_256(x) {
      return rotr32(x, 7) ^ rotr32(x, 18) ^ x >>> 3;
    }
    exports2.g0_256 = g0_256;
    function g1_256(x) {
      return rotr32(x, 17) ^ rotr32(x, 19) ^ x >>> 10;
    }
    exports2.g1_256 = g1_256;
  }
});

// node_modules/hash.js/lib/hash/sha/1.js
var require__ = __commonJS({
  "node_modules/hash.js/lib/hash/sha/1.js"(exports2, module2) {
    "use strict";
    var utils = require_utils3();
    var common = require_common();
    var shaCommon = require_common2();
    var rotl32 = utils.rotl32;
    var sum32 = utils.sum32;
    var sum32_5 = utils.sum32_5;
    var ft_1 = shaCommon.ft_1;
    var BlockHash = common.BlockHash;
    var sha1_K = [
      1518500249,
      1859775393,
      2400959708,
      3395469782
    ];
    function SHA1() {
      if (!(this instanceof SHA1))
        return new SHA1();
      BlockHash.call(this);
      this.h = [
        1732584193,
        4023233417,
        2562383102,
        271733878,
        3285377520
      ];
      this.W = new Array(80);
    }
    utils.inherits(SHA1, BlockHash);
    module2.exports = SHA1;
    SHA1.blockSize = 512;
    SHA1.outSize = 160;
    SHA1.hmacStrength = 80;
    SHA1.padLength = 64;
    SHA1.prototype._update = function _update(msg, start) {
      var W = this.W;
      for (var i = 0; i < 16; i++)
        W[i] = msg[start + i];
      for (; i < W.length; i++)
        W[i] = rotl32(W[i - 3] ^ W[i - 8] ^ W[i - 14] ^ W[i - 16], 1);
      var a = this.h[0];
      var b = this.h[1];
      var c = this.h[2];
      var d = this.h[3];
      var e = this.h[4];
      for (i = 0; i < W.length; i++) {
        var s = ~~(i / 20);
        var t = sum32_5(rotl32(a, 5), ft_1(s, b, c, d), e, W[i], sha1_K[s]);
        e = d;
        d = c;
        c = rotl32(b, 30);
        b = a;
        a = t;
      }
      this.h[0] = sum32(this.h[0], a);
      this.h[1] = sum32(this.h[1], b);
      this.h[2] = sum32(this.h[2], c);
      this.h[3] = sum32(this.h[3], d);
      this.h[4] = sum32(this.h[4], e);
    };
    SHA1.prototype._digest = function digest(enc) {
      if (enc === "hex")
        return utils.toHex32(this.h, "big");
      else
        return utils.split32(this.h, "big");
    };
  }
});

// node_modules/hash.js/lib/hash/sha/256.js
var require__2 = __commonJS({
  "node_modules/hash.js/lib/hash/sha/256.js"(exports2, module2) {
    "use strict";
    var utils = require_utils3();
    var common = require_common();
    var shaCommon = require_common2();
    var assert = require_minimalistic_assert();
    var sum32 = utils.sum32;
    var sum32_4 = utils.sum32_4;
    var sum32_5 = utils.sum32_5;
    var ch32 = shaCommon.ch32;
    var maj32 = shaCommon.maj32;
    var s0_256 = shaCommon.s0_256;
    var s1_256 = shaCommon.s1_256;
    var g0_256 = shaCommon.g0_256;
    var g1_256 = shaCommon.g1_256;
    var BlockHash = common.BlockHash;
    var sha256_K = [
      1116352408,
      1899447441,
      3049323471,
      3921009573,
      961987163,
      1508970993,
      2453635748,
      2870763221,
      3624381080,
      310598401,
      607225278,
      1426881987,
      1925078388,
      2162078206,
      2614888103,
      3248222580,
      3835390401,
      4022224774,
      264347078,
      604807628,
      770255983,
      1249150122,
      1555081692,
      1996064986,
      2554220882,
      2821834349,
      2952996808,
      3210313671,
      3336571891,
      3584528711,
      113926993,
      338241895,
      666307205,
      773529912,
      1294757372,
      1396182291,
      1695183700,
      1986661051,
      2177026350,
      2456956037,
      2730485921,
      2820302411,
      3259730800,
      3345764771,
      3516065817,
      3600352804,
      4094571909,
      275423344,
      430227734,
      506948616,
      659060556,
      883997877,
      958139571,
      1322822218,
      1537002063,
      1747873779,
      1955562222,
      2024104815,
      2227730452,
      2361852424,
      2428436474,
      2756734187,
      3204031479,
      3329325298
    ];
    function SHA256() {
      if (!(this instanceof SHA256))
        return new SHA256();
      BlockHash.call(this);
      this.h = [
        1779033703,
        3144134277,
        1013904242,
        2773480762,
        1359893119,
        2600822924,
        528734635,
        1541459225
      ];
      this.k = sha256_K;
      this.W = new Array(64);
    }
    utils.inherits(SHA256, BlockHash);
    module2.exports = SHA256;
    SHA256.blockSize = 512;
    SHA256.outSize = 256;
    SHA256.hmacStrength = 192;
    SHA256.padLength = 64;
    SHA256.prototype._update = function _update(msg, start) {
      var W = this.W;
      for (var i = 0; i < 16; i++)
        W[i] = msg[start + i];
      for (; i < W.length; i++)
        W[i] = sum32_4(g1_256(W[i - 2]), W[i - 7], g0_256(W[i - 15]), W[i - 16]);
      var a = this.h[0];
      var b = this.h[1];
      var c = this.h[2];
      var d = this.h[3];
      var e = this.h[4];
      var f = this.h[5];
      var g = this.h[6];
      var h = this.h[7];
      assert(this.k.length === W.length);
      for (i = 0; i < W.length; i++) {
        var T1 = sum32_5(h, s1_256(e), ch32(e, f, g), this.k[i], W[i]);
        var T2 = sum32(s0_256(a), maj32(a, b, c));
        h = g;
        g = f;
        f = e;
        e = sum32(d, T1);
        d = c;
        c = b;
        b = a;
        a = sum32(T1, T2);
      }
      this.h[0] = sum32(this.h[0], a);
      this.h[1] = sum32(this.h[1], b);
      this.h[2] = sum32(this.h[2], c);
      this.h[3] = sum32(this.h[3], d);
      this.h[4] = sum32(this.h[4], e);
      this.h[5] = sum32(this.h[5], f);
      this.h[6] = sum32(this.h[6], g);
      this.h[7] = sum32(this.h[7], h);
    };
    SHA256.prototype._digest = function digest(enc) {
      if (enc === "hex")
        return utils.toHex32(this.h, "big");
      else
        return utils.split32(this.h, "big");
    };
  }
});

// node_modules/hash.js/lib/hash/sha/224.js
var require__3 = __commonJS({
  "node_modules/hash.js/lib/hash/sha/224.js"(exports2, module2) {
    "use strict";
    var utils = require_utils3();
    var SHA256 = require__2();
    function SHA224() {
      if (!(this instanceof SHA224))
        return new SHA224();
      SHA256.call(this);
      this.h = [
        3238371032,
        914150663,
        812702999,
        4144912697,
        4290775857,
        1750603025,
        1694076839,
        3204075428
      ];
    }
    utils.inherits(SHA224, SHA256);
    module2.exports = SHA224;
    SHA224.blockSize = 512;
    SHA224.outSize = 224;
    SHA224.hmacStrength = 192;
    SHA224.padLength = 64;
    SHA224.prototype._digest = function digest(enc) {
      if (enc === "hex")
        return utils.toHex32(this.h.slice(0, 7), "big");
      else
        return utils.split32(this.h.slice(0, 7), "big");
    };
  }
});

// node_modules/hash.js/lib/hash/sha/512.js
var require__4 = __commonJS({
  "node_modules/hash.js/lib/hash/sha/512.js"(exports2, module2) {
    "use strict";
    var utils = require_utils3();
    var common = require_common();
    var assert = require_minimalistic_assert();
    var rotr64_hi = utils.rotr64_hi;
    var rotr64_lo = utils.rotr64_lo;
    var shr64_hi = utils.shr64_hi;
    var shr64_lo = utils.shr64_lo;
    var sum64 = utils.sum64;
    var sum64_hi = utils.sum64_hi;
    var sum64_lo = utils.sum64_lo;
    var sum64_4_hi = utils.sum64_4_hi;
    var sum64_4_lo = utils.sum64_4_lo;
    var sum64_5_hi = utils.sum64_5_hi;
    var sum64_5_lo = utils.sum64_5_lo;
    var BlockHash = common.BlockHash;
    var sha512_K = [
      1116352408,
      3609767458,
      1899447441,
      602891725,
      3049323471,
      3964484399,
      3921009573,
      2173295548,
      961987163,
      4081628472,
      1508970993,
      3053834265,
      2453635748,
      2937671579,
      2870763221,
      3664609560,
      3624381080,
      2734883394,
      310598401,
      1164996542,
      607225278,
      1323610764,
      1426881987,
      3590304994,
      1925078388,
      4068182383,
      2162078206,
      991336113,
      2614888103,
      633803317,
      3248222580,
      3479774868,
      3835390401,
      2666613458,
      4022224774,
      944711139,
      264347078,
      2341262773,
      604807628,
      2007800933,
      770255983,
      1495990901,
      1249150122,
      1856431235,
      1555081692,
      3175218132,
      1996064986,
      2198950837,
      2554220882,
      3999719339,
      2821834349,
      766784016,
      2952996808,
      2566594879,
      3210313671,
      3203337956,
      3336571891,
      1034457026,
      3584528711,
      2466948901,
      113926993,
      3758326383,
      338241895,
      168717936,
      666307205,
      1188179964,
      773529912,
      1546045734,
      1294757372,
      1522805485,
      1396182291,
      2643833823,
      1695183700,
      2343527390,
      1986661051,
      1014477480,
      2177026350,
      1206759142,
      2456956037,
      344077627,
      2730485921,
      1290863460,
      2820302411,
      3158454273,
      3259730800,
      3505952657,
      3345764771,
      106217008,
      3516065817,
      3606008344,
      3600352804,
      1432725776,
      4094571909,
      1467031594,
      275423344,
      851169720,
      430227734,
      3100823752,
      506948616,
      1363258195,
      659060556,
      3750685593,
      883997877,
      3785050280,
      958139571,
      3318307427,
      1322822218,
      3812723403,
      1537002063,
      2003034995,
      1747873779,
      3602036899,
      1955562222,
      1575990012,
      2024104815,
      1125592928,
      2227730452,
      2716904306,
      2361852424,
      442776044,
      2428436474,
      593698344,
      2756734187,
      3733110249,
      3204031479,
      2999351573,
      3329325298,
      3815920427,
      3391569614,
      3928383900,
      3515267271,
      566280711,
      3940187606,
      3454069534,
      4118630271,
      4000239992,
      116418474,
      1914138554,
      174292421,
      2731055270,
      289380356,
      3203993006,
      460393269,
      320620315,
      685471733,
      587496836,
      852142971,
      1086792851,
      1017036298,
      365543100,
      1126000580,
      2618297676,
      1288033470,
      3409855158,
      1501505948,
      4234509866,
      1607167915,
      987167468,
      1816402316,
      1246189591
    ];
    function SHA512() {
      if (!(this instanceof SHA512))
        return new SHA512();
      BlockHash.call(this);
      this.h = [
        1779033703,
        4089235720,
        3144134277,
        2227873595,
        1013904242,
        4271175723,
        2773480762,
        1595750129,
        1359893119,
        2917565137,
        2600822924,
        725511199,
        528734635,
        4215389547,
        1541459225,
        327033209
      ];
      this.k = sha512_K;
      this.W = new Array(160);
    }
    utils.inherits(SHA512, BlockHash);
    module2.exports = SHA512;
    SHA512.blockSize = 1024;
    SHA512.outSize = 512;
    SHA512.hmacStrength = 192;
    SHA512.padLength = 128;
    SHA512.prototype._prepareBlock = function _prepareBlock(msg, start) {
      var W = this.W;
      for (var i = 0; i < 32; i++)
        W[i] = msg[start + i];
      for (; i < W.length; i += 2) {
        var c0_hi = g1_512_hi(W[i - 4], W[i - 3]);
        var c0_lo = g1_512_lo(W[i - 4], W[i - 3]);
        var c1_hi = W[i - 14];
        var c1_lo = W[i - 13];
        var c2_hi = g0_512_hi(W[i - 30], W[i - 29]);
        var c2_lo = g0_512_lo(W[i - 30], W[i - 29]);
        var c3_hi = W[i - 32];
        var c3_lo = W[i - 31];
        W[i] = sum64_4_hi(
          c0_hi,
          c0_lo,
          c1_hi,
          c1_lo,
          c2_hi,
          c2_lo,
          c3_hi,
          c3_lo
        );
        W[i + 1] = sum64_4_lo(
          c0_hi,
          c0_lo,
          c1_hi,
          c1_lo,
          c2_hi,
          c2_lo,
          c3_hi,
          c3_lo
        );
      }
    };
    SHA512.prototype._update = function _update(msg, start) {
      this._prepareBlock(msg, start);
      var W = this.W;
      var ah = this.h[0];
      var al = this.h[1];
      var bh = this.h[2];
      var bl = this.h[3];
      var ch = this.h[4];
      var cl = this.h[5];
      var dh = this.h[6];
      var dl = this.h[7];
      var eh = this.h[8];
      var el = this.h[9];
      var fh = this.h[10];
      var fl = this.h[11];
      var gh = this.h[12];
      var gl = this.h[13];
      var hh = this.h[14];
      var hl = this.h[15];
      assert(this.k.length === W.length);
      for (var i = 0; i < W.length; i += 2) {
        var c0_hi = hh;
        var c0_lo = hl;
        var c1_hi = s1_512_hi(eh, el);
        var c1_lo = s1_512_lo(eh, el);
        var c2_hi = ch64_hi(eh, el, fh, fl, gh, gl);
        var c2_lo = ch64_lo(eh, el, fh, fl, gh, gl);
        var c3_hi = this.k[i];
        var c3_lo = this.k[i + 1];
        var c4_hi = W[i];
        var c4_lo = W[i + 1];
        var T1_hi = sum64_5_hi(
          c0_hi,
          c0_lo,
          c1_hi,
          c1_lo,
          c2_hi,
          c2_lo,
          c3_hi,
          c3_lo,
          c4_hi,
          c4_lo
        );
        var T1_lo = sum64_5_lo(
          c0_hi,
          c0_lo,
          c1_hi,
          c1_lo,
          c2_hi,
          c2_lo,
          c3_hi,
          c3_lo,
          c4_hi,
          c4_lo
        );
        c0_hi = s0_512_hi(ah, al);
        c0_lo = s0_512_lo(ah, al);
        c1_hi = maj64_hi(ah, al, bh, bl, ch, cl);
        c1_lo = maj64_lo(ah, al, bh, bl, ch, cl);
        var T2_hi = sum64_hi(c0_hi, c0_lo, c1_hi, c1_lo);
        var T2_lo = sum64_lo(c0_hi, c0_lo, c1_hi, c1_lo);
        hh = gh;
        hl = gl;
        gh = fh;
        gl = fl;
        fh = eh;
        fl = el;
        eh = sum64_hi(dh, dl, T1_hi, T1_lo);
        el = sum64_lo(dl, dl, T1_hi, T1_lo);
        dh = ch;
        dl = cl;
        ch = bh;
        cl = bl;
        bh = ah;
        bl = al;
        ah = sum64_hi(T1_hi, T1_lo, T2_hi, T2_lo);
        al = sum64_lo(T1_hi, T1_lo, T2_hi, T2_lo);
      }
      sum64(this.h, 0, ah, al);
      sum64(this.h, 2, bh, bl);
      sum64(this.h, 4, ch, cl);
      sum64(this.h, 6, dh, dl);
      sum64(this.h, 8, eh, el);
      sum64(this.h, 10, fh, fl);
      sum64(this.h, 12, gh, gl);
      sum64(this.h, 14, hh, hl);
    };
    SHA512.prototype._digest = function digest(enc) {
      if (enc === "hex")
        return utils.toHex32(this.h, "big");
      else
        return utils.split32(this.h, "big");
    };
    function ch64_hi(xh, xl, yh, yl, zh) {
      var r = xh & yh ^ ~xh & zh;
      if (r < 0)
        r += 4294967296;
      return r;
    }
    function ch64_lo(xh, xl, yh, yl, zh, zl) {
      var r = xl & yl ^ ~xl & zl;
      if (r < 0)
        r += 4294967296;
      return r;
    }
    function maj64_hi(xh, xl, yh, yl, zh) {
      var r = xh & yh ^ xh & zh ^ yh & zh;
      if (r < 0)
        r += 4294967296;
      return r;
    }
    function maj64_lo(xh, xl, yh, yl, zh, zl) {
      var r = xl & yl ^ xl & zl ^ yl & zl;
      if (r < 0)
        r += 4294967296;
      return r;
    }
    function s0_512_hi(xh, xl) {
      var c0_hi = rotr64_hi(xh, xl, 28);
      var c1_hi = rotr64_hi(xl, xh, 2);
      var c2_hi = rotr64_hi(xl, xh, 7);
      var r = c0_hi ^ c1_hi ^ c2_hi;
      if (r < 0)
        r += 4294967296;
      return r;
    }
    function s0_512_lo(xh, xl) {
      var c0_lo = rotr64_lo(xh, xl, 28);
      var c1_lo = rotr64_lo(xl, xh, 2);
      var c2_lo = rotr64_lo(xl, xh, 7);
      var r = c0_lo ^ c1_lo ^ c2_lo;
      if (r < 0)
        r += 4294967296;
      return r;
    }
    function s1_512_hi(xh, xl) {
      var c0_hi = rotr64_hi(xh, xl, 14);
      var c1_hi = rotr64_hi(xh, xl, 18);
      var c2_hi = rotr64_hi(xl, xh, 9);
      var r = c0_hi ^ c1_hi ^ c2_hi;
      if (r < 0)
        r += 4294967296;
      return r;
    }
    function s1_512_lo(xh, xl) {
      var c0_lo = rotr64_lo(xh, xl, 14);
      var c1_lo = rotr64_lo(xh, xl, 18);
      var c2_lo = rotr64_lo(xl, xh, 9);
      var r = c0_lo ^ c1_lo ^ c2_lo;
      if (r < 0)
        r += 4294967296;
      return r;
    }
    function g0_512_hi(xh, xl) {
      var c0_hi = rotr64_hi(xh, xl, 1);
      var c1_hi = rotr64_hi(xh, xl, 8);
      var c2_hi = shr64_hi(xh, xl, 7);
      var r = c0_hi ^ c1_hi ^ c2_hi;
      if (r < 0)
        r += 4294967296;
      return r;
    }
    function g0_512_lo(xh, xl) {
      var c0_lo = rotr64_lo(xh, xl, 1);
      var c1_lo = rotr64_lo(xh, xl, 8);
      var c2_lo = shr64_lo(xh, xl, 7);
      var r = c0_lo ^ c1_lo ^ c2_lo;
      if (r < 0)
        r += 4294967296;
      return r;
    }
    function g1_512_hi(xh, xl) {
      var c0_hi = rotr64_hi(xh, xl, 19);
      var c1_hi = rotr64_hi(xl, xh, 29);
      var c2_hi = shr64_hi(xh, xl, 6);
      var r = c0_hi ^ c1_hi ^ c2_hi;
      if (r < 0)
        r += 4294967296;
      return r;
    }
    function g1_512_lo(xh, xl) {
      var c0_lo = rotr64_lo(xh, xl, 19);
      var c1_lo = rotr64_lo(xl, xh, 29);
      var c2_lo = shr64_lo(xh, xl, 6);
      var r = c0_lo ^ c1_lo ^ c2_lo;
      if (r < 0)
        r += 4294967296;
      return r;
    }
  }
});

// node_modules/hash.js/lib/hash/sha/384.js
var require__5 = __commonJS({
  "node_modules/hash.js/lib/hash/sha/384.js"(exports2, module2) {
    "use strict";
    var utils = require_utils3();
    var SHA512 = require__4();
    function SHA384() {
      if (!(this instanceof SHA384))
        return new SHA384();
      SHA512.call(this);
      this.h = [
        3418070365,
        3238371032,
        1654270250,
        914150663,
        2438529370,
        812702999,
        355462360,
        4144912697,
        1731405415,
        4290775857,
        2394180231,
        1750603025,
        3675008525,
        1694076839,
        1203062813,
        3204075428
      ];
    }
    utils.inherits(SHA384, SHA512);
    module2.exports = SHA384;
    SHA384.blockSize = 1024;
    SHA384.outSize = 384;
    SHA384.hmacStrength = 192;
    SHA384.padLength = 128;
    SHA384.prototype._digest = function digest(enc) {
      if (enc === "hex")
        return utils.toHex32(this.h.slice(0, 12), "big");
      else
        return utils.split32(this.h.slice(0, 12), "big");
    };
  }
});

// node_modules/hash.js/lib/hash/sha.js
var require_sha = __commonJS({
  "node_modules/hash.js/lib/hash/sha.js"(exports2) {
    "use strict";
    exports2.sha1 = require__();
    exports2.sha224 = require__3();
    exports2.sha256 = require__2();
    exports2.sha384 = require__5();
    exports2.sha512 = require__4();
  }
});

// node_modules/hash.js/lib/hash/ripemd.js
var require_ripemd = __commonJS({
  "node_modules/hash.js/lib/hash/ripemd.js"(exports2) {
    "use strict";
    var utils = require_utils3();
    var common = require_common();
    var rotl32 = utils.rotl32;
    var sum32 = utils.sum32;
    var sum32_3 = utils.sum32_3;
    var sum32_4 = utils.sum32_4;
    var BlockHash = common.BlockHash;
    function RIPEMD160() {
      if (!(this instanceof RIPEMD160))
        return new RIPEMD160();
      BlockHash.call(this);
      this.h = [1732584193, 4023233417, 2562383102, 271733878, 3285377520];
      this.endian = "little";
    }
    utils.inherits(RIPEMD160, BlockHash);
    exports2.ripemd160 = RIPEMD160;
    RIPEMD160.blockSize = 512;
    RIPEMD160.outSize = 160;
    RIPEMD160.hmacStrength = 192;
    RIPEMD160.padLength = 64;
    RIPEMD160.prototype._update = function update(msg, start) {
      var A = this.h[0];
      var B = this.h[1];
      var C = this.h[2];
      var D = this.h[3];
      var E = this.h[4];
      var Ah = A;
      var Bh = B;
      var Ch = C;
      var Dh = D;
      var Eh = E;
      for (var j = 0; j < 80; j++) {
        var T = sum32(
          rotl32(
            sum32_4(A, f(j, B, C, D), msg[r[j] + start], K(j)),
            s[j]
          ),
          E
        );
        A = E;
        E = D;
        D = rotl32(C, 10);
        C = B;
        B = T;
        T = sum32(
          rotl32(
            sum32_4(Ah, f(79 - j, Bh, Ch, Dh), msg[rh[j] + start], Kh(j)),
            sh[j]
          ),
          Eh
        );
        Ah = Eh;
        Eh = Dh;
        Dh = rotl32(Ch, 10);
        Ch = Bh;
        Bh = T;
      }
      T = sum32_3(this.h[1], C, Dh);
      this.h[1] = sum32_3(this.h[2], D, Eh);
      this.h[2] = sum32_3(this.h[3], E, Ah);
      this.h[3] = sum32_3(this.h[4], A, Bh);
      this.h[4] = sum32_3(this.h[0], B, Ch);
      this.h[0] = T;
    };
    RIPEMD160.prototype._digest = function digest(enc) {
      if (enc === "hex")
        return utils.toHex32(this.h, "little");
      else
        return utils.split32(this.h, "little");
    };
    function f(j, x, y, z) {
      if (j <= 15)
        return x ^ y ^ z;
      else if (j <= 31)
        return x & y | ~x & z;
      else if (j <= 47)
        return (x | ~y) ^ z;
      else if (j <= 63)
        return x & z | y & ~z;
      else
        return x ^ (y | ~z);
    }
    function K(j) {
      if (j <= 15)
        return 0;
      else if (j <= 31)
        return 1518500249;
      else if (j <= 47)
        return 1859775393;
      else if (j <= 63)
        return 2400959708;
      else
        return 2840853838;
    }
    function Kh(j) {
      if (j <= 15)
        return 1352829926;
      else if (j <= 31)
        return 1548603684;
      else if (j <= 47)
        return 1836072691;
      else if (j <= 63)
        return 2053994217;
      else
        return 0;
    }
    var r = [
      0,
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      8,
      9,
      10,
      11,
      12,
      13,
      14,
      15,
      7,
      4,
      13,
      1,
      10,
      6,
      15,
      3,
      12,
      0,
      9,
      5,
      2,
      14,
      11,
      8,
      3,
      10,
      14,
      4,
      9,
      15,
      8,
      1,
      2,
      7,
      0,
      6,
      13,
      11,
      5,
      12,
      1,
      9,
      11,
      10,
      0,
      8,
      12,
      4,
      13,
      3,
      7,
      15,
      14,
      5,
      6,
      2,
      4,
      0,
      5,
      9,
      7,
      12,
      2,
      10,
      14,
      1,
      3,
      8,
      11,
      6,
      15,
      13
    ];
    var rh = [
      5,
      14,
      7,
      0,
      9,
      2,
      11,
      4,
      13,
      6,
      15,
      8,
      1,
      10,
      3,
      12,
      6,
      11,
      3,
      7,
      0,
      13,
      5,
      10,
      14,
      15,
      8,
      12,
      4,
      9,
      1,
      2,
      15,
      5,
      1,
      3,
      7,
      14,
      6,
      9,
      11,
      8,
      12,
      2,
      10,
      0,
      4,
      13,
      8,
      6,
      4,
      1,
      3,
      11,
      15,
      0,
      5,
      12,
      2,
      13,
      9,
      7,
      10,
      14,
      12,
      15,
      10,
      4,
      1,
      5,
      8,
      7,
      6,
      2,
      13,
      14,
      0,
      3,
      9,
      11
    ];
    var s = [
      11,
      14,
      15,
      12,
      5,
      8,
      7,
      9,
      11,
      13,
      14,
      15,
      6,
      7,
      9,
      8,
      7,
      6,
      8,
      13,
      11,
      9,
      7,
      15,
      7,
      12,
      15,
      9,
      11,
      7,
      13,
      12,
      11,
      13,
      6,
      7,
      14,
      9,
      13,
      15,
      14,
      8,
      13,
      6,
      5,
      12,
      7,
      5,
      11,
      12,
      14,
      15,
      14,
      15,
      9,
      8,
      9,
      14,
      5,
      6,
      8,
      6,
      5,
      12,
      9,
      15,
      5,
      11,
      6,
      8,
      13,
      12,
      5,
      12,
      13,
      14,
      11,
      8,
      5,
      6
    ];
    var sh = [
      8,
      9,
      9,
      11,
      13,
      15,
      15,
      5,
      7,
      7,
      8,
      11,
      14,
      14,
      12,
      6,
      9,
      13,
      15,
      7,
      12,
      8,
      9,
      11,
      7,
      7,
      12,
      7,
      6,
      15,
      13,
      11,
      9,
      7,
      15,
      11,
      8,
      6,
      6,
      14,
      12,
      13,
      5,
      14,
      13,
      13,
      7,
      5,
      15,
      5,
      8,
      11,
      14,
      14,
      6,
      14,
      6,
      9,
      12,
      9,
      12,
      5,
      15,
      8,
      8,
      5,
      12,
      9,
      12,
      5,
      14,
      6,
      8,
      13,
      6,
      5,
      15,
      13,
      11,
      11
    ];
  }
});

// node_modules/hash.js/lib/hash/hmac.js
var require_hmac = __commonJS({
  "node_modules/hash.js/lib/hash/hmac.js"(exports2, module2) {
    "use strict";
    var utils = require_utils3();
    var assert = require_minimalistic_assert();
    function Hmac(hash, key, enc) {
      if (!(this instanceof Hmac))
        return new Hmac(hash, key, enc);
      this.Hash = hash;
      this.blockSize = hash.blockSize / 8;
      this.outSize = hash.outSize / 8;
      this.inner = null;
      this.outer = null;
      this._init(utils.toArray(key, enc));
    }
    module2.exports = Hmac;
    Hmac.prototype._init = function init(key) {
      if (key.length > this.blockSize)
        key = new this.Hash().update(key).digest();
      assert(key.length <= this.blockSize);
      for (var i = key.length; i < this.blockSize; i++)
        key.push(0);
      for (i = 0; i < key.length; i++)
        key[i] ^= 54;
      this.inner = new this.Hash().update(key);
      for (i = 0; i < key.length; i++)
        key[i] ^= 106;
      this.outer = new this.Hash().update(key);
    };
    Hmac.prototype.update = function update(msg, enc) {
      this.inner.update(msg, enc);
      return this;
    };
    Hmac.prototype.digest = function digest(enc) {
      this.outer.update(this.inner.digest());
      return this.outer.digest(enc);
    };
  }
});

// node_modules/hash.js/lib/hash.js
var require_hash = __commonJS({
  "node_modules/hash.js/lib/hash.js"(exports2) {
    var hash = exports2;
    hash.utils = require_utils3();
    hash.common = require_common();
    hash.sha = require_sha();
    hash.ripemd = require_ripemd();
    hash.hmac = require_hmac();
    hash.sha1 = hash.sha.sha1;
    hash.sha256 = hash.sha.sha256;
    hash.sha224 = hash.sha.sha224;
    hash.sha384 = hash.sha.sha384;
    hash.sha512 = hash.sha.sha512;
    hash.ripemd160 = hash.ripemd.ripemd160;
  }
});

// node_modules/elliptic/lib/elliptic/precomputed/secp256k1.js
var require_secp256k1 = __commonJS({
  "node_modules/elliptic/lib/elliptic/precomputed/secp256k1.js"(exports2, module2) {
    module2.exports = {
      doubles: {
        step: 4,
        points: [
          [
            "e60fce93b59e9ec53011aabc21c23e97b2a31369b87a5ae9c44ee89e2a6dec0a",
            "f7e3507399e595929db99f34f57937101296891e44d23f0be1f32cce69616821"
          ],
          [
            "8282263212c609d9ea2a6e3e172de238d8c39cabd5ac1ca10646e23fd5f51508",
            "11f8a8098557dfe45e8256e830b60ace62d613ac2f7b17bed31b6eaff6e26caf"
          ],
          [
            "175e159f728b865a72f99cc6c6fc846de0b93833fd2222ed73fce5b551e5b739",
            "d3506e0d9e3c79eba4ef97a51ff71f5eacb5955add24345c6efa6ffee9fed695"
          ],
          [
            "363d90d447b00c9c99ceac05b6262ee053441c7e55552ffe526bad8f83ff4640",
            "4e273adfc732221953b445397f3363145b9a89008199ecb62003c7f3bee9de9"
          ],
          [
            "8b4b5f165df3c2be8c6244b5b745638843e4a781a15bcd1b69f79a55dffdf80c",
            "4aad0a6f68d308b4b3fbd7813ab0da04f9e336546162ee56b3eff0c65fd4fd36"
          ],
          [
            "723cbaa6e5db996d6bf771c00bd548c7b700dbffa6c0e77bcb6115925232fcda",
            "96e867b5595cc498a921137488824d6e2660a0653779494801dc069d9eb39f5f"
          ],
          [
            "eebfa4d493bebf98ba5feec812c2d3b50947961237a919839a533eca0e7dd7fa",
            "5d9a8ca3970ef0f269ee7edaf178089d9ae4cdc3a711f712ddfd4fdae1de8999"
          ],
          [
            "100f44da696e71672791d0a09b7bde459f1215a29b3c03bfefd7835b39a48db0",
            "cdd9e13192a00b772ec8f3300c090666b7ff4a18ff5195ac0fbd5cd62bc65a09"
          ],
          [
            "e1031be262c7ed1b1dc9227a4a04c017a77f8d4464f3b3852c8acde6e534fd2d",
            "9d7061928940405e6bb6a4176597535af292dd419e1ced79a44f18f29456a00d"
          ],
          [
            "feea6cae46d55b530ac2839f143bd7ec5cf8b266a41d6af52d5e688d9094696d",
            "e57c6b6c97dce1bab06e4e12bf3ecd5c981c8957cc41442d3155debf18090088"
          ],
          [
            "da67a91d91049cdcb367be4be6ffca3cfeed657d808583de33fa978bc1ec6cb1",
            "9bacaa35481642bc41f463f7ec9780e5dec7adc508f740a17e9ea8e27a68be1d"
          ],
          [
            "53904faa0b334cdda6e000935ef22151ec08d0f7bb11069f57545ccc1a37b7c0",
            "5bc087d0bc80106d88c9eccac20d3c1c13999981e14434699dcb096b022771c8"
          ],
          [
            "8e7bcd0bd35983a7719cca7764ca906779b53a043a9b8bcaeff959f43ad86047",
            "10b7770b2a3da4b3940310420ca9514579e88e2e47fd68b3ea10047e8460372a"
          ],
          [
            "385eed34c1cdff21e6d0818689b81bde71a7f4f18397e6690a841e1599c43862",
            "283bebc3e8ea23f56701de19e9ebf4576b304eec2086dc8cc0458fe5542e5453"
          ],
          [
            "6f9d9b803ecf191637c73a4413dfa180fddf84a5947fbc9c606ed86c3fac3a7",
            "7c80c68e603059ba69b8e2a30e45c4d47ea4dd2f5c281002d86890603a842160"
          ],
          [
            "3322d401243c4e2582a2147c104d6ecbf774d163db0f5e5313b7e0e742d0e6bd",
            "56e70797e9664ef5bfb019bc4ddaf9b72805f63ea2873af624f3a2e96c28b2a0"
          ],
          [
            "85672c7d2de0b7da2bd1770d89665868741b3f9af7643397721d74d28134ab83",
            "7c481b9b5b43b2eb6374049bfa62c2e5e77f17fcc5298f44c8e3094f790313a6"
          ],
          [
            "948bf809b1988a46b06c9f1919413b10f9226c60f668832ffd959af60c82a0a",
            "53a562856dcb6646dc6b74c5d1c3418c6d4dff08c97cd2bed4cb7f88d8c8e589"
          ],
          [
            "6260ce7f461801c34f067ce0f02873a8f1b0e44dfc69752accecd819f38fd8e8",
            "bc2da82b6fa5b571a7f09049776a1ef7ecd292238051c198c1a84e95b2b4ae17"
          ],
          [
            "e5037de0afc1d8d43d8348414bbf4103043ec8f575bfdc432953cc8d2037fa2d",
            "4571534baa94d3b5f9f98d09fb990bddbd5f5b03ec481f10e0e5dc841d755bda"
          ],
          [
            "e06372b0f4a207adf5ea905e8f1771b4e7e8dbd1c6a6c5b725866a0ae4fce725",
            "7a908974bce18cfe12a27bb2ad5a488cd7484a7787104870b27034f94eee31dd"
          ],
          [
            "213c7a715cd5d45358d0bbf9dc0ce02204b10bdde2a3f58540ad6908d0559754",
            "4b6dad0b5ae462507013ad06245ba190bb4850f5f36a7eeddff2c27534b458f2"
          ],
          [
            "4e7c272a7af4b34e8dbb9352a5419a87e2838c70adc62cddf0cc3a3b08fbd53c",
            "17749c766c9d0b18e16fd09f6def681b530b9614bff7dd33e0b3941817dcaae6"
          ],
          [
            "fea74e3dbe778b1b10f238ad61686aa5c76e3db2be43057632427e2840fb27b6",
            "6e0568db9b0b13297cf674deccb6af93126b596b973f7b77701d3db7f23cb96f"
          ],
          [
            "76e64113f677cf0e10a2570d599968d31544e179b760432952c02a4417bdde39",
            "c90ddf8dee4e95cf577066d70681f0d35e2a33d2b56d2032b4b1752d1901ac01"
          ],
          [
            "c738c56b03b2abe1e8281baa743f8f9a8f7cc643df26cbee3ab150242bcbb891",
            "893fb578951ad2537f718f2eacbfbbbb82314eef7880cfe917e735d9699a84c3"
          ],
          [
            "d895626548b65b81e264c7637c972877d1d72e5f3a925014372e9f6588f6c14b",
            "febfaa38f2bc7eae728ec60818c340eb03428d632bb067e179363ed75d7d991f"
          ],
          [
            "b8da94032a957518eb0f6433571e8761ceffc73693e84edd49150a564f676e03",
            "2804dfa44805a1e4d7c99cc9762808b092cc584d95ff3b511488e4e74efdf6e7"
          ],
          [
            "e80fea14441fb33a7d8adab9475d7fab2019effb5156a792f1a11778e3c0df5d",
            "eed1de7f638e00771e89768ca3ca94472d155e80af322ea9fcb4291b6ac9ec78"
          ],
          [
            "a301697bdfcd704313ba48e51d567543f2a182031efd6915ddc07bbcc4e16070",
            "7370f91cfb67e4f5081809fa25d40f9b1735dbf7c0a11a130c0d1a041e177ea1"
          ],
          [
            "90ad85b389d6b936463f9d0512678de208cc330b11307fffab7ac63e3fb04ed4",
            "e507a3620a38261affdcbd9427222b839aefabe1582894d991d4d48cb6ef150"
          ],
          [
            "8f68b9d2f63b5f339239c1ad981f162ee88c5678723ea3351b7b444c9ec4c0da",
            "662a9f2dba063986de1d90c2b6be215dbbea2cfe95510bfdf23cbf79501fff82"
          ],
          [
            "e4f3fb0176af85d65ff99ff9198c36091f48e86503681e3e6686fd5053231e11",
            "1e63633ad0ef4f1c1661a6d0ea02b7286cc7e74ec951d1c9822c38576feb73bc"
          ],
          [
            "8c00fa9b18ebf331eb961537a45a4266c7034f2f0d4e1d0716fb6eae20eae29e",
            "efa47267fea521a1a9dc343a3736c974c2fadafa81e36c54e7d2a4c66702414b"
          ],
          [
            "e7a26ce69dd4829f3e10cec0a9e98ed3143d084f308b92c0997fddfc60cb3e41",
            "2a758e300fa7984b471b006a1aafbb18d0a6b2c0420e83e20e8a9421cf2cfd51"
          ],
          [
            "b6459e0ee3662ec8d23540c223bcbdc571cbcb967d79424f3cf29eb3de6b80ef",
            "67c876d06f3e06de1dadf16e5661db3c4b3ae6d48e35b2ff30bf0b61a71ba45"
          ],
          [
            "d68a80c8280bb840793234aa118f06231d6f1fc67e73c5a5deda0f5b496943e8",
            "db8ba9fff4b586d00c4b1f9177b0e28b5b0e7b8f7845295a294c84266b133120"
          ],
          [
            "324aed7df65c804252dc0270907a30b09612aeb973449cea4095980fc28d3d5d",
            "648a365774b61f2ff130c0c35aec1f4f19213b0c7e332843967224af96ab7c84"
          ],
          [
            "4df9c14919cde61f6d51dfdbe5fee5dceec4143ba8d1ca888e8bd373fd054c96",
            "35ec51092d8728050974c23a1d85d4b5d506cdc288490192ebac06cad10d5d"
          ],
          [
            "9c3919a84a474870faed8a9c1cc66021523489054d7f0308cbfc99c8ac1f98cd",
            "ddb84f0f4a4ddd57584f044bf260e641905326f76c64c8e6be7e5e03d4fc599d"
          ],
          [
            "6057170b1dd12fdf8de05f281d8e06bb91e1493a8b91d4cc5a21382120a959e5",
            "9a1af0b26a6a4807add9a2daf71df262465152bc3ee24c65e899be932385a2a8"
          ],
          [
            "a576df8e23a08411421439a4518da31880cef0fba7d4df12b1a6973eecb94266",
            "40a6bf20e76640b2c92b97afe58cd82c432e10a7f514d9f3ee8be11ae1b28ec8"
          ],
          [
            "7778a78c28dec3e30a05fe9629de8c38bb30d1f5cf9a3a208f763889be58ad71",
            "34626d9ab5a5b22ff7098e12f2ff580087b38411ff24ac563b513fc1fd9f43ac"
          ],
          [
            "928955ee637a84463729fd30e7afd2ed5f96274e5ad7e5cb09eda9c06d903ac",
            "c25621003d3f42a827b78a13093a95eeac3d26efa8a8d83fc5180e935bcd091f"
          ],
          [
            "85d0fef3ec6db109399064f3a0e3b2855645b4a907ad354527aae75163d82751",
            "1f03648413a38c0be29d496e582cf5663e8751e96877331582c237a24eb1f962"
          ],
          [
            "ff2b0dce97eece97c1c9b6041798b85dfdfb6d8882da20308f5404824526087e",
            "493d13fef524ba188af4c4dc54d07936c7b7ed6fb90e2ceb2c951e01f0c29907"
          ],
          [
            "827fbbe4b1e880ea9ed2b2e6301b212b57f1ee148cd6dd28780e5e2cf856e241",
            "c60f9c923c727b0b71bef2c67d1d12687ff7a63186903166d605b68baec293ec"
          ],
          [
            "eaa649f21f51bdbae7be4ae34ce6e5217a58fdce7f47f9aa7f3b58fa2120e2b3",
            "be3279ed5bbbb03ac69a80f89879aa5a01a6b965f13f7e59d47a5305ba5ad93d"
          ],
          [
            "e4a42d43c5cf169d9391df6decf42ee541b6d8f0c9a137401e23632dda34d24f",
            "4d9f92e716d1c73526fc99ccfb8ad34ce886eedfa8d8e4f13a7f7131deba9414"
          ],
          [
            "1ec80fef360cbdd954160fadab352b6b92b53576a88fea4947173b9d4300bf19",
            "aeefe93756b5340d2f3a4958a7abbf5e0146e77f6295a07b671cdc1cc107cefd"
          ],
          [
            "146a778c04670c2f91b00af4680dfa8bce3490717d58ba889ddb5928366642be",
            "b318e0ec3354028add669827f9d4b2870aaa971d2f7e5ed1d0b297483d83efd0"
          ],
          [
            "fa50c0f61d22e5f07e3acebb1aa07b128d0012209a28b9776d76a8793180eef9",
            "6b84c6922397eba9b72cd2872281a68a5e683293a57a213b38cd8d7d3f4f2811"
          ],
          [
            "da1d61d0ca721a11b1a5bf6b7d88e8421a288ab5d5bba5220e53d32b5f067ec2",
            "8157f55a7c99306c79c0766161c91e2966a73899d279b48a655fba0f1ad836f1"
          ],
          [
            "a8e282ff0c9706907215ff98e8fd416615311de0446f1e062a73b0610d064e13",
            "7f97355b8db81c09abfb7f3c5b2515888b679a3e50dd6bd6cef7c73111f4cc0c"
          ],
          [
            "174a53b9c9a285872d39e56e6913cab15d59b1fa512508c022f382de8319497c",
            "ccc9dc37abfc9c1657b4155f2c47f9e6646b3a1d8cb9854383da13ac079afa73"
          ],
          [
            "959396981943785c3d3e57edf5018cdbe039e730e4918b3d884fdff09475b7ba",
            "2e7e552888c331dd8ba0386a4b9cd6849c653f64c8709385e9b8abf87524f2fd"
          ],
          [
            "d2a63a50ae401e56d645a1153b109a8fcca0a43d561fba2dbb51340c9d82b151",
            "e82d86fb6443fcb7565aee58b2948220a70f750af484ca52d4142174dcf89405"
          ],
          [
            "64587e2335471eb890ee7896d7cfdc866bacbdbd3839317b3436f9b45617e073",
            "d99fcdd5bf6902e2ae96dd6447c299a185b90a39133aeab358299e5e9faf6589"
          ],
          [
            "8481bde0e4e4d885b3a546d3e549de042f0aa6cea250e7fd358d6c86dd45e458",
            "38ee7b8cba5404dd84a25bf39cecb2ca900a79c42b262e556d64b1b59779057e"
          ],
          [
            "13464a57a78102aa62b6979ae817f4637ffcfed3c4b1ce30bcd6303f6caf666b",
            "69be159004614580ef7e433453ccb0ca48f300a81d0942e13f495a907f6ecc27"
          ],
          [
            "bc4a9df5b713fe2e9aef430bcc1dc97a0cd9ccede2f28588cada3a0d2d83f366",
            "d3a81ca6e785c06383937adf4b798caa6e8a9fbfa547b16d758d666581f33c1"
          ],
          [
            "8c28a97bf8298bc0d23d8c749452a32e694b65e30a9472a3954ab30fe5324caa",
            "40a30463a3305193378fedf31f7cc0eb7ae784f0451cb9459e71dc73cbef9482"
          ],
          [
            "8ea9666139527a8c1dd94ce4f071fd23c8b350c5a4bb33748c4ba111faccae0",
            "620efabbc8ee2782e24e7c0cfb95c5d735b783be9cf0f8e955af34a30e62b945"
          ],
          [
            "dd3625faef5ba06074669716bbd3788d89bdde815959968092f76cc4eb9a9787",
            "7a188fa3520e30d461da2501045731ca941461982883395937f68d00c644a573"
          ],
          [
            "f710d79d9eb962297e4f6232b40e8f7feb2bc63814614d692c12de752408221e",
            "ea98e67232d3b3295d3b535532115ccac8612c721851617526ae47a9c77bfc82"
          ]
        ]
      },
      naf: {
        wnd: 7,
        points: [
          [
            "f9308a019258c31049344f85f89d5229b531c845836f99b08601f113bce036f9",
            "388f7b0f632de8140fe337e62a37f3566500a99934c2231b6cb9fd7584b8e672"
          ],
          [
            "2f8bde4d1a07209355b4a7250a5c5128e88b84bddc619ab7cba8d569b240efe4",
            "d8ac222636e5e3d6d4dba9dda6c9c426f788271bab0d6840dca87d3aa6ac62d6"
          ],
          [
            "5cbdf0646e5db4eaa398f365f2ea7a0e3d419b7e0330e39ce92bddedcac4f9bc",
            "6aebca40ba255960a3178d6d861a54dba813d0b813fde7b5a5082628087264da"
          ],
          [
            "acd484e2f0c7f65309ad178a9f559abde09796974c57e714c35f110dfc27ccbe",
            "cc338921b0a7d9fd64380971763b61e9add888a4375f8e0f05cc262ac64f9c37"
          ],
          [
            "774ae7f858a9411e5ef4246b70c65aac5649980be5c17891bbec17895da008cb",
            "d984a032eb6b5e190243dd56d7b7b365372db1e2dff9d6a8301d74c9c953c61b"
          ],
          [
            "f28773c2d975288bc7d1d205c3748651b075fbc6610e58cddeeddf8f19405aa8",
            "ab0902e8d880a89758212eb65cdaf473a1a06da521fa91f29b5cb52db03ed81"
          ],
          [
            "d7924d4f7d43ea965a465ae3095ff41131e5946f3c85f79e44adbcf8e27e080e",
            "581e2872a86c72a683842ec228cc6defea40af2bd896d3a5c504dc9ff6a26b58"
          ],
          [
            "defdea4cdb677750a420fee807eacf21eb9898ae79b9768766e4faa04a2d4a34",
            "4211ab0694635168e997b0ead2a93daeced1f4a04a95c0f6cfb199f69e56eb77"
          ],
          [
            "2b4ea0a797a443d293ef5cff444f4979f06acfebd7e86d277475656138385b6c",
            "85e89bc037945d93b343083b5a1c86131a01f60c50269763b570c854e5c09b7a"
          ],
          [
            "352bbf4a4cdd12564f93fa332ce333301d9ad40271f8107181340aef25be59d5",
            "321eb4075348f534d59c18259dda3e1f4a1b3b2e71b1039c67bd3d8bcf81998c"
          ],
          [
            "2fa2104d6b38d11b0230010559879124e42ab8dfeff5ff29dc9cdadd4ecacc3f",
            "2de1068295dd865b64569335bd5dd80181d70ecfc882648423ba76b532b7d67"
          ],
          [
            "9248279b09b4d68dab21a9b066edda83263c3d84e09572e269ca0cd7f5453714",
            "73016f7bf234aade5d1aa71bdea2b1ff3fc0de2a887912ffe54a32ce97cb3402"
          ],
          [
            "daed4f2be3a8bf278e70132fb0beb7522f570e144bf615c07e996d443dee8729",
            "a69dce4a7d6c98e8d4a1aca87ef8d7003f83c230f3afa726ab40e52290be1c55"
          ],
          [
            "c44d12c7065d812e8acf28d7cbb19f9011ecd9e9fdf281b0e6a3b5e87d22e7db",
            "2119a460ce326cdc76c45926c982fdac0e106e861edf61c5a039063f0e0e6482"
          ],
          [
            "6a245bf6dc698504c89a20cfded60853152b695336c28063b61c65cbd269e6b4",
            "e022cf42c2bd4a708b3f5126f16a24ad8b33ba48d0423b6efd5e6348100d8a82"
          ],
          [
            "1697ffa6fd9de627c077e3d2fe541084ce13300b0bec1146f95ae57f0d0bd6a5",
            "b9c398f186806f5d27561506e4557433a2cf15009e498ae7adee9d63d01b2396"
          ],
          [
            "605bdb019981718b986d0f07e834cb0d9deb8360ffb7f61df982345ef27a7479",
            "2972d2de4f8d20681a78d93ec96fe23c26bfae84fb14db43b01e1e9056b8c49"
          ],
          [
            "62d14dab4150bf497402fdc45a215e10dcb01c354959b10cfe31c7e9d87ff33d",
            "80fc06bd8cc5b01098088a1950eed0db01aa132967ab472235f5642483b25eaf"
          ],
          [
            "80c60ad0040f27dade5b4b06c408e56b2c50e9f56b9b8b425e555c2f86308b6f",
            "1c38303f1cc5c30f26e66bad7fe72f70a65eed4cbe7024eb1aa01f56430bd57a"
          ],
          [
            "7a9375ad6167ad54aa74c6348cc54d344cc5dc9487d847049d5eabb0fa03c8fb",
            "d0e3fa9eca8726909559e0d79269046bdc59ea10c70ce2b02d499ec224dc7f7"
          ],
          [
            "d528ecd9b696b54c907a9ed045447a79bb408ec39b68df504bb51f459bc3ffc9",
            "eecf41253136e5f99966f21881fd656ebc4345405c520dbc063465b521409933"
          ],
          [
            "49370a4b5f43412ea25f514e8ecdad05266115e4a7ecb1387231808f8b45963",
            "758f3f41afd6ed428b3081b0512fd62a54c3f3afbb5b6764b653052a12949c9a"
          ],
          [
            "77f230936ee88cbbd73df930d64702ef881d811e0e1498e2f1c13eb1fc345d74",
            "958ef42a7886b6400a08266e9ba1b37896c95330d97077cbbe8eb3c7671c60d6"
          ],
          [
            "f2dac991cc4ce4b9ea44887e5c7c0bce58c80074ab9d4dbaeb28531b7739f530",
            "e0dedc9b3b2f8dad4da1f32dec2531df9eb5fbeb0598e4fd1a117dba703a3c37"
          ],
          [
            "463b3d9f662621fb1b4be8fbbe2520125a216cdfc9dae3debcba4850c690d45b",
            "5ed430d78c296c3543114306dd8622d7c622e27c970a1de31cb377b01af7307e"
          ],
          [
            "f16f804244e46e2a09232d4aff3b59976b98fac14328a2d1a32496b49998f247",
            "cedabd9b82203f7e13d206fcdf4e33d92a6c53c26e5cce26d6579962c4e31df6"
          ],
          [
            "caf754272dc84563b0352b7a14311af55d245315ace27c65369e15f7151d41d1",
            "cb474660ef35f5f2a41b643fa5e460575f4fa9b7962232a5c32f908318a04476"
          ],
          [
            "2600ca4b282cb986f85d0f1709979d8b44a09c07cb86d7c124497bc86f082120",
            "4119b88753c15bd6a693b03fcddbb45d5ac6be74ab5f0ef44b0be9475a7e4b40"
          ],
          [
            "7635ca72d7e8432c338ec53cd12220bc01c48685e24f7dc8c602a7746998e435",
            "91b649609489d613d1d5e590f78e6d74ecfc061d57048bad9e76f302c5b9c61"
          ],
          [
            "754e3239f325570cdbbf4a87deee8a66b7f2b33479d468fbc1a50743bf56cc18",
            "673fb86e5bda30fb3cd0ed304ea49a023ee33d0197a695d0c5d98093c536683"
          ],
          [
            "e3e6bd1071a1e96aff57859c82d570f0330800661d1c952f9fe2694691d9b9e8",
            "59c9e0bba394e76f40c0aa58379a3cb6a5a2283993e90c4167002af4920e37f5"
          ],
          [
            "186b483d056a033826ae73d88f732985c4ccb1f32ba35f4b4cc47fdcf04aa6eb",
            "3b952d32c67cf77e2e17446e204180ab21fb8090895138b4a4a797f86e80888b"
          ],
          [
            "df9d70a6b9876ce544c98561f4be4f725442e6d2b737d9c91a8321724ce0963f",
            "55eb2dafd84d6ccd5f862b785dc39d4ab157222720ef9da217b8c45cf2ba2417"
          ],
          [
            "5edd5cc23c51e87a497ca815d5dce0f8ab52554f849ed8995de64c5f34ce7143",
            "efae9c8dbc14130661e8cec030c89ad0c13c66c0d17a2905cdc706ab7399a868"
          ],
          [
            "290798c2b6476830da12fe02287e9e777aa3fba1c355b17a722d362f84614fba",
            "e38da76dcd440621988d00bcf79af25d5b29c094db2a23146d003afd41943e7a"
          ],
          [
            "af3c423a95d9f5b3054754efa150ac39cd29552fe360257362dfdecef4053b45",
            "f98a3fd831eb2b749a93b0e6f35cfb40c8cd5aa667a15581bc2feded498fd9c6"
          ],
          [
            "766dbb24d134e745cccaa28c99bf274906bb66b26dcf98df8d2fed50d884249a",
            "744b1152eacbe5e38dcc887980da38b897584a65fa06cedd2c924f97cbac5996"
          ],
          [
            "59dbf46f8c94759ba21277c33784f41645f7b44f6c596a58ce92e666191abe3e",
            "c534ad44175fbc300f4ea6ce648309a042ce739a7919798cd85e216c4a307f6e"
          ],
          [
            "f13ada95103c4537305e691e74e9a4a8dd647e711a95e73cb62dc6018cfd87b8",
            "e13817b44ee14de663bf4bc808341f326949e21a6a75c2570778419bdaf5733d"
          ],
          [
            "7754b4fa0e8aced06d4167a2c59cca4cda1869c06ebadfb6488550015a88522c",
            "30e93e864e669d82224b967c3020b8fa8d1e4e350b6cbcc537a48b57841163a2"
          ],
          [
            "948dcadf5990e048aa3874d46abef9d701858f95de8041d2a6828c99e2262519",
            "e491a42537f6e597d5d28a3224b1bc25df9154efbd2ef1d2cbba2cae5347d57e"
          ],
          [
            "7962414450c76c1689c7b48f8202ec37fb224cf5ac0bfa1570328a8a3d7c77ab",
            "100b610ec4ffb4760d5c1fc133ef6f6b12507a051f04ac5760afa5b29db83437"
          ],
          [
            "3514087834964b54b15b160644d915485a16977225b8847bb0dd085137ec47ca",
            "ef0afbb2056205448e1652c48e8127fc6039e77c15c2378b7e7d15a0de293311"
          ],
          [
            "d3cc30ad6b483e4bc79ce2c9dd8bc54993e947eb8df787b442943d3f7b527eaf",
            "8b378a22d827278d89c5e9be8f9508ae3c2ad46290358630afb34db04eede0a4"
          ],
          [
            "1624d84780732860ce1c78fcbfefe08b2b29823db913f6493975ba0ff4847610",
            "68651cf9b6da903e0914448c6cd9d4ca896878f5282be4c8cc06e2a404078575"
          ],
          [
            "733ce80da955a8a26902c95633e62a985192474b5af207da6df7b4fd5fc61cd4",
            "f5435a2bd2badf7d485a4d8b8db9fcce3e1ef8e0201e4578c54673bc1dc5ea1d"
          ],
          [
            "15d9441254945064cf1a1c33bbd3b49f8966c5092171e699ef258dfab81c045c",
            "d56eb30b69463e7234f5137b73b84177434800bacebfc685fc37bbe9efe4070d"
          ],
          [
            "a1d0fcf2ec9de675b612136e5ce70d271c21417c9d2b8aaaac138599d0717940",
            "edd77f50bcb5a3cab2e90737309667f2641462a54070f3d519212d39c197a629"
          ],
          [
            "e22fbe15c0af8ccc5780c0735f84dbe9a790badee8245c06c7ca37331cb36980",
            "a855babad5cd60c88b430a69f53a1a7a38289154964799be43d06d77d31da06"
          ],
          [
            "311091dd9860e8e20ee13473c1155f5f69635e394704eaa74009452246cfa9b3",
            "66db656f87d1f04fffd1f04788c06830871ec5a64feee685bd80f0b1286d8374"
          ],
          [
            "34c1fd04d301be89b31c0442d3e6ac24883928b45a9340781867d4232ec2dbdf",
            "9414685e97b1b5954bd46f730174136d57f1ceeb487443dc5321857ba73abee"
          ],
          [
            "f219ea5d6b54701c1c14de5b557eb42a8d13f3abbcd08affcc2a5e6b049b8d63",
            "4cb95957e83d40b0f73af4544cccf6b1f4b08d3c07b27fb8d8c2962a400766d1"
          ],
          [
            "d7b8740f74a8fbaab1f683db8f45de26543a5490bca627087236912469a0b448",
            "fa77968128d9c92ee1010f337ad4717eff15db5ed3c049b3411e0315eaa4593b"
          ],
          [
            "32d31c222f8f6f0ef86f7c98d3a3335ead5bcd32abdd94289fe4d3091aa824bf",
            "5f3032f5892156e39ccd3d7915b9e1da2e6dac9e6f26e961118d14b8462e1661"
          ],
          [
            "7461f371914ab32671045a155d9831ea8793d77cd59592c4340f86cbc18347b5",
            "8ec0ba238b96bec0cbdddcae0aa442542eee1ff50c986ea6b39847b3cc092ff6"
          ],
          [
            "ee079adb1df1860074356a25aa38206a6d716b2c3e67453d287698bad7b2b2d6",
            "8dc2412aafe3be5c4c5f37e0ecc5f9f6a446989af04c4e25ebaac479ec1c8c1e"
          ],
          [
            "16ec93e447ec83f0467b18302ee620f7e65de331874c9dc72bfd8616ba9da6b5",
            "5e4631150e62fb40d0e8c2a7ca5804a39d58186a50e497139626778e25b0674d"
          ],
          [
            "eaa5f980c245f6f038978290afa70b6bd8855897f98b6aa485b96065d537bd99",
            "f65f5d3e292c2e0819a528391c994624d784869d7e6ea67fb18041024edc07dc"
          ],
          [
            "78c9407544ac132692ee1910a02439958ae04877151342ea96c4b6b35a49f51",
            "f3e0319169eb9b85d5404795539a5e68fa1fbd583c064d2462b675f194a3ddb4"
          ],
          [
            "494f4be219a1a77016dcd838431aea0001cdc8ae7a6fc688726578d9702857a5",
            "42242a969283a5f339ba7f075e36ba2af925ce30d767ed6e55f4b031880d562c"
          ],
          [
            "a598a8030da6d86c6bc7f2f5144ea549d28211ea58faa70ebf4c1e665c1fe9b5",
            "204b5d6f84822c307e4b4a7140737aec23fc63b65b35f86a10026dbd2d864e6b"
          ],
          [
            "c41916365abb2b5d09192f5f2dbeafec208f020f12570a184dbadc3e58595997",
            "4f14351d0087efa49d245b328984989d5caf9450f34bfc0ed16e96b58fa9913"
          ],
          [
            "841d6063a586fa475a724604da03bc5b92a2e0d2e0a36acfe4c73a5514742881",
            "73867f59c0659e81904f9a1c7543698e62562d6744c169ce7a36de01a8d6154"
          ],
          [
            "5e95bb399a6971d376026947f89bde2f282b33810928be4ded112ac4d70e20d5",
            "39f23f366809085beebfc71181313775a99c9aed7d8ba38b161384c746012865"
          ],
          [
            "36e4641a53948fd476c39f8a99fd974e5ec07564b5315d8bf99471bca0ef2f66",
            "d2424b1b1abe4eb8164227b085c9aa9456ea13493fd563e06fd51cf5694c78fc"
          ],
          [
            "336581ea7bfbbb290c191a2f507a41cf5643842170e914faeab27c2c579f726",
            "ead12168595fe1be99252129b6e56b3391f7ab1410cd1e0ef3dcdcabd2fda224"
          ],
          [
            "8ab89816dadfd6b6a1f2634fcf00ec8403781025ed6890c4849742706bd43ede",
            "6fdcef09f2f6d0a044e654aef624136f503d459c3e89845858a47a9129cdd24e"
          ],
          [
            "1e33f1a746c9c5778133344d9299fcaa20b0938e8acff2544bb40284b8c5fb94",
            "60660257dd11b3aa9c8ed618d24edff2306d320f1d03010e33a7d2057f3b3b6"
          ],
          [
            "85b7c1dcb3cec1b7ee7f30ded79dd20a0ed1f4cc18cbcfcfa410361fd8f08f31",
            "3d98a9cdd026dd43f39048f25a8847f4fcafad1895d7a633c6fed3c35e999511"
          ],
          [
            "29df9fbd8d9e46509275f4b125d6d45d7fbe9a3b878a7af872a2800661ac5f51",
            "b4c4fe99c775a606e2d8862179139ffda61dc861c019e55cd2876eb2a27d84b"
          ],
          [
            "a0b1cae06b0a847a3fea6e671aaf8adfdfe58ca2f768105c8082b2e449fce252",
            "ae434102edde0958ec4b19d917a6a28e6b72da1834aff0e650f049503a296cf2"
          ],
          [
            "4e8ceafb9b3e9a136dc7ff67e840295b499dfb3b2133e4ba113f2e4c0e121e5",
            "cf2174118c8b6d7a4b48f6d534ce5c79422c086a63460502b827ce62a326683c"
          ],
          [
            "d24a44e047e19b6f5afb81c7ca2f69080a5076689a010919f42725c2b789a33b",
            "6fb8d5591b466f8fc63db50f1c0f1c69013f996887b8244d2cdec417afea8fa3"
          ],
          [
            "ea01606a7a6c9cdd249fdfcfacb99584001edd28abbab77b5104e98e8e3b35d4",
            "322af4908c7312b0cfbfe369f7a7b3cdb7d4494bc2823700cfd652188a3ea98d"
          ],
          [
            "af8addbf2b661c8a6c6328655eb96651252007d8c5ea31be4ad196de8ce2131f",
            "6749e67c029b85f52a034eafd096836b2520818680e26ac8f3dfbcdb71749700"
          ],
          [
            "e3ae1974566ca06cc516d47e0fb165a674a3dabcfca15e722f0e3450f45889",
            "2aeabe7e4531510116217f07bf4d07300de97e4874f81f533420a72eeb0bd6a4"
          ],
          [
            "591ee355313d99721cf6993ffed1e3e301993ff3ed258802075ea8ced397e246",
            "b0ea558a113c30bea60fc4775460c7901ff0b053d25ca2bdeee98f1a4be5d196"
          ],
          [
            "11396d55fda54c49f19aa97318d8da61fa8584e47b084945077cf03255b52984",
            "998c74a8cd45ac01289d5833a7beb4744ff536b01b257be4c5767bea93ea57a4"
          ],
          [
            "3c5d2a1ba39c5a1790000738c9e0c40b8dcdfd5468754b6405540157e017aa7a",
            "b2284279995a34e2f9d4de7396fc18b80f9b8b9fdd270f6661f79ca4c81bd257"
          ],
          [
            "cc8704b8a60a0defa3a99a7299f2e9c3fbc395afb04ac078425ef8a1793cc030",
            "bdd46039feed17881d1e0862db347f8cf395b74fc4bcdc4e940b74e3ac1f1b13"
          ],
          [
            "c533e4f7ea8555aacd9777ac5cad29b97dd4defccc53ee7ea204119b2889b197",
            "6f0a256bc5efdf429a2fb6242f1a43a2d9b925bb4a4b3a26bb8e0f45eb596096"
          ],
          [
            "c14f8f2ccb27d6f109f6d08d03cc96a69ba8c34eec07bbcf566d48e33da6593",
            "c359d6923bb398f7fd4473e16fe1c28475b740dd098075e6c0e8649113dc3a38"
          ],
          [
            "a6cbc3046bc6a450bac24789fa17115a4c9739ed75f8f21ce441f72e0b90e6ef",
            "21ae7f4680e889bb130619e2c0f95a360ceb573c70603139862afd617fa9b9f"
          ],
          [
            "347d6d9a02c48927ebfb86c1359b1caf130a3c0267d11ce6344b39f99d43cc38",
            "60ea7f61a353524d1c987f6ecec92f086d565ab687870cb12689ff1e31c74448"
          ],
          [
            "da6545d2181db8d983f7dcb375ef5866d47c67b1bf31c8cf855ef7437b72656a",
            "49b96715ab6878a79e78f07ce5680c5d6673051b4935bd897fea824b77dc208a"
          ],
          [
            "c40747cc9d012cb1a13b8148309c6de7ec25d6945d657146b9d5994b8feb1111",
            "5ca560753be2a12fc6de6caf2cb489565db936156b9514e1bb5e83037e0fa2d4"
          ],
          [
            "4e42c8ec82c99798ccf3a610be870e78338c7f713348bd34c8203ef4037f3502",
            "7571d74ee5e0fb92a7a8b33a07783341a5492144cc54bcc40a94473693606437"
          ],
          [
            "3775ab7089bc6af823aba2e1af70b236d251cadb0c86743287522a1b3b0dedea",
            "be52d107bcfa09d8bcb9736a828cfa7fac8db17bf7a76a2c42ad961409018cf7"
          ],
          [
            "cee31cbf7e34ec379d94fb814d3d775ad954595d1314ba8846959e3e82f74e26",
            "8fd64a14c06b589c26b947ae2bcf6bfa0149ef0be14ed4d80f448a01c43b1c6d"
          ],
          [
            "b4f9eaea09b6917619f6ea6a4eb5464efddb58fd45b1ebefcdc1a01d08b47986",
            "39e5c9925b5a54b07433a4f18c61726f8bb131c012ca542eb24a8ac07200682a"
          ],
          [
            "d4263dfc3d2df923a0179a48966d30ce84e2515afc3dccc1b77907792ebcc60e",
            "62dfaf07a0f78feb30e30d6295853ce189e127760ad6cf7fae164e122a208d54"
          ],
          [
            "48457524820fa65a4f8d35eb6930857c0032acc0a4a2de422233eeda897612c4",
            "25a748ab367979d98733c38a1fa1c2e7dc6cc07db2d60a9ae7a76aaa49bd0f77"
          ],
          [
            "dfeeef1881101f2cb11644f3a2afdfc2045e19919152923f367a1767c11cceda",
            "ecfb7056cf1de042f9420bab396793c0c390bde74b4bbdff16a83ae09a9a7517"
          ],
          [
            "6d7ef6b17543f8373c573f44e1f389835d89bcbc6062ced36c82df83b8fae859",
            "cd450ec335438986dfefa10c57fea9bcc521a0959b2d80bbf74b190dca712d10"
          ],
          [
            "e75605d59102a5a2684500d3b991f2e3f3c88b93225547035af25af66e04541f",
            "f5c54754a8f71ee540b9b48728473e314f729ac5308b06938360990e2bfad125"
          ],
          [
            "eb98660f4c4dfaa06a2be453d5020bc99a0c2e60abe388457dd43fefb1ed620c",
            "6cb9a8876d9cb8520609af3add26cd20a0a7cd8a9411131ce85f44100099223e"
          ],
          [
            "13e87b027d8514d35939f2e6892b19922154596941888336dc3563e3b8dba942",
            "fef5a3c68059a6dec5d624114bf1e91aac2b9da568d6abeb2570d55646b8adf1"
          ],
          [
            "ee163026e9fd6fe017c38f06a5be6fc125424b371ce2708e7bf4491691e5764a",
            "1acb250f255dd61c43d94ccc670d0f58f49ae3fa15b96623e5430da0ad6c62b2"
          ],
          [
            "b268f5ef9ad51e4d78de3a750c2dc89b1e626d43505867999932e5db33af3d80",
            "5f310d4b3c99b9ebb19f77d41c1dee018cf0d34fd4191614003e945a1216e423"
          ],
          [
            "ff07f3118a9df035e9fad85eb6c7bfe42b02f01ca99ceea3bf7ffdba93c4750d",
            "438136d603e858a3a5c440c38eccbaddc1d2942114e2eddd4740d098ced1f0d8"
          ],
          [
            "8d8b9855c7c052a34146fd20ffb658bea4b9f69e0d825ebec16e8c3ce2b526a1",
            "cdb559eedc2d79f926baf44fb84ea4d44bcf50fee51d7ceb30e2e7f463036758"
          ],
          [
            "52db0b5384dfbf05bfa9d472d7ae26dfe4b851ceca91b1eba54263180da32b63",
            "c3b997d050ee5d423ebaf66a6db9f57b3180c902875679de924b69d84a7b375"
          ],
          [
            "e62f9490d3d51da6395efd24e80919cc7d0f29c3f3fa48c6fff543becbd43352",
            "6d89ad7ba4876b0b22c2ca280c682862f342c8591f1daf5170e07bfd9ccafa7d"
          ],
          [
            "7f30ea2476b399b4957509c88f77d0191afa2ff5cb7b14fd6d8e7d65aaab1193",
            "ca5ef7d4b231c94c3b15389a5f6311e9daff7bb67b103e9880ef4bff637acaec"
          ],
          [
            "5098ff1e1d9f14fb46a210fada6c903fef0fb7b4a1dd1d9ac60a0361800b7a00",
            "9731141d81fc8f8084d37c6e7542006b3ee1b40d60dfe5362a5b132fd17ddc0"
          ],
          [
            "32b78c7de9ee512a72895be6b9cbefa6e2f3c4ccce445c96b9f2c81e2778ad58",
            "ee1849f513df71e32efc3896ee28260c73bb80547ae2275ba497237794c8753c"
          ],
          [
            "e2cb74fddc8e9fbcd076eef2a7c72b0ce37d50f08269dfc074b581550547a4f7",
            "d3aa2ed71c9dd2247a62df062736eb0baddea9e36122d2be8641abcb005cc4a4"
          ],
          [
            "8438447566d4d7bedadc299496ab357426009a35f235cb141be0d99cd10ae3a8",
            "c4e1020916980a4da5d01ac5e6ad330734ef0d7906631c4f2390426b2edd791f"
          ],
          [
            "4162d488b89402039b584c6fc6c308870587d9c46f660b878ab65c82c711d67e",
            "67163e903236289f776f22c25fb8a3afc1732f2b84b4e95dbda47ae5a0852649"
          ],
          [
            "3fad3fa84caf0f34f0f89bfd2dcf54fc175d767aec3e50684f3ba4a4bf5f683d",
            "cd1bc7cb6cc407bb2f0ca647c718a730cf71872e7d0d2a53fa20efcdfe61826"
          ],
          [
            "674f2600a3007a00568c1a7ce05d0816c1fb84bf1370798f1c69532faeb1a86b",
            "299d21f9413f33b3edf43b257004580b70db57da0b182259e09eecc69e0d38a5"
          ],
          [
            "d32f4da54ade74abb81b815ad1fb3b263d82d6c692714bcff87d29bd5ee9f08f",
            "f9429e738b8e53b968e99016c059707782e14f4535359d582fc416910b3eea87"
          ],
          [
            "30e4e670435385556e593657135845d36fbb6931f72b08cb1ed954f1e3ce3ff6",
            "462f9bce619898638499350113bbc9b10a878d35da70740dc695a559eb88db7b"
          ],
          [
            "be2062003c51cc3004682904330e4dee7f3dcd10b01e580bf1971b04d4cad297",
            "62188bc49d61e5428573d48a74e1c655b1c61090905682a0d5558ed72dccb9bc"
          ],
          [
            "93144423ace3451ed29e0fb9ac2af211cb6e84a601df5993c419859fff5df04a",
            "7c10dfb164c3425f5c71a3f9d7992038f1065224f72bb9d1d902a6d13037b47c"
          ],
          [
            "b015f8044f5fcbdcf21ca26d6c34fb8197829205c7b7d2a7cb66418c157b112c",
            "ab8c1e086d04e813744a655b2df8d5f83b3cdc6faa3088c1d3aea1454e3a1d5f"
          ],
          [
            "d5e9e1da649d97d89e4868117a465a3a4f8a18de57a140d36b3f2af341a21b52",
            "4cb04437f391ed73111a13cc1d4dd0db1693465c2240480d8955e8592f27447a"
          ],
          [
            "d3ae41047dd7ca065dbf8ed77b992439983005cd72e16d6f996a5316d36966bb",
            "bd1aeb21ad22ebb22a10f0303417c6d964f8cdd7df0aca614b10dc14d125ac46"
          ],
          [
            "463e2763d885f958fc66cdd22800f0a487197d0a82e377b49f80af87c897b065",
            "bfefacdb0e5d0fd7df3a311a94de062b26b80c61fbc97508b79992671ef7ca7f"
          ],
          [
            "7985fdfd127c0567c6f53ec1bb63ec3158e597c40bfe747c83cddfc910641917",
            "603c12daf3d9862ef2b25fe1de289aed24ed291e0ec6708703a5bd567f32ed03"
          ],
          [
            "74a1ad6b5f76e39db2dd249410eac7f99e74c59cb83d2d0ed5ff1543da7703e9",
            "cc6157ef18c9c63cd6193d83631bbea0093e0968942e8c33d5737fd790e0db08"
          ],
          [
            "30682a50703375f602d416664ba19b7fc9bab42c72747463a71d0896b22f6da3",
            "553e04f6b018b4fa6c8f39e7f311d3176290d0e0f19ca73f17714d9977a22ff8"
          ],
          [
            "9e2158f0d7c0d5f26c3791efefa79597654e7a2b2464f52b1ee6c1347769ef57",
            "712fcdd1b9053f09003a3481fa7762e9ffd7c8ef35a38509e2fbf2629008373"
          ],
          [
            "176e26989a43c9cfeba4029c202538c28172e566e3c4fce7322857f3be327d66",
            "ed8cc9d04b29eb877d270b4878dc43c19aefd31f4eee09ee7b47834c1fa4b1c3"
          ],
          [
            "75d46efea3771e6e68abb89a13ad747ecf1892393dfc4f1b7004788c50374da8",
            "9852390a99507679fd0b86fd2b39a868d7efc22151346e1a3ca4726586a6bed8"
          ],
          [
            "809a20c67d64900ffb698c4c825f6d5f2310fb0451c869345b7319f645605721",
            "9e994980d9917e22b76b061927fa04143d096ccc54963e6a5ebfa5f3f8e286c1"
          ],
          [
            "1b38903a43f7f114ed4500b4eac7083fdefece1cf29c63528d563446f972c180",
            "4036edc931a60ae889353f77fd53de4a2708b26b6f5da72ad3394119daf408f9"
          ]
        ]
      }
    };
  }
});

// node_modules/elliptic/lib/elliptic/curves.js
var require_curves = __commonJS({
  "node_modules/elliptic/lib/elliptic/curves.js"(exports2) {
    "use strict";
    var curves = exports2;
    var hash = require_hash();
    var curve = require_curve();
    var utils = require_utils2();
    var assert = utils.assert;
    function PresetCurve(options) {
      if (options.type === "short")
        this.curve = new curve.short(options);
      else if (options.type === "edwards")
        this.curve = new curve.edwards(options);
      else
        this.curve = new curve.mont(options);
      this.g = this.curve.g;
      this.n = this.curve.n;
      this.hash = options.hash;
      assert(this.g.validate(), "Invalid curve");
      assert(this.g.mul(this.n).isInfinity(), "Invalid curve, G*N != O");
    }
    curves.PresetCurve = PresetCurve;
    function defineCurve(name2, options) {
      Object.defineProperty(curves, name2, {
        configurable: true,
        enumerable: true,
        get: function() {
          var curve2 = new PresetCurve(options);
          Object.defineProperty(curves, name2, {
            configurable: true,
            enumerable: true,
            value: curve2
          });
          return curve2;
        }
      });
    }
    defineCurve("p192", {
      type: "short",
      prime: "p192",
      p: "ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff",
      a: "ffffffff ffffffff ffffffff fffffffe ffffffff fffffffc",
      b: "64210519 e59c80e7 0fa7e9ab 72243049 feb8deec c146b9b1",
      n: "ffffffff ffffffff ffffffff 99def836 146bc9b1 b4d22831",
      hash: hash.sha256,
      gRed: false,
      g: [
        "188da80e b03090f6 7cbf20eb 43a18800 f4ff0afd 82ff1012",
        "07192b95 ffc8da78 631011ed 6b24cdd5 73f977a1 1e794811"
      ]
    });
    defineCurve("p224", {
      type: "short",
      prime: "p224",
      p: "ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001",
      a: "ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff fffffffe",
      b: "b4050a85 0c04b3ab f5413256 5044b0b7 d7bfd8ba 270b3943 2355ffb4",
      n: "ffffffff ffffffff ffffffff ffff16a2 e0b8f03e 13dd2945 5c5c2a3d",
      hash: hash.sha256,
      gRed: false,
      g: [
        "b70e0cbd 6bb4bf7f 321390b9 4a03c1d3 56c21122 343280d6 115c1d21",
        "bd376388 b5f723fb 4c22dfe6 cd4375a0 5a074764 44d58199 85007e34"
      ]
    });
    defineCurve("p256", {
      type: "short",
      prime: null,
      p: "ffffffff 00000001 00000000 00000000 00000000 ffffffff ffffffff ffffffff",
      a: "ffffffff 00000001 00000000 00000000 00000000 ffffffff ffffffff fffffffc",
      b: "5ac635d8 aa3a93e7 b3ebbd55 769886bc 651d06b0 cc53b0f6 3bce3c3e 27d2604b",
      n: "ffffffff 00000000 ffffffff ffffffff bce6faad a7179e84 f3b9cac2 fc632551",
      hash: hash.sha256,
      gRed: false,
      g: [
        "6b17d1f2 e12c4247 f8bce6e5 63a440f2 77037d81 2deb33a0 f4a13945 d898c296",
        "4fe342e2 fe1a7f9b 8ee7eb4a 7c0f9e16 2bce3357 6b315ece cbb64068 37bf51f5"
      ]
    });
    defineCurve("p384", {
      type: "short",
      prime: null,
      p: "ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe ffffffff 00000000 00000000 ffffffff",
      a: "ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe ffffffff 00000000 00000000 fffffffc",
      b: "b3312fa7 e23ee7e4 988e056b e3f82d19 181d9c6e fe814112 0314088f 5013875a c656398d 8a2ed19d 2a85c8ed d3ec2aef",
      n: "ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff c7634d81 f4372ddf 581a0db2 48b0a77a ecec196a ccc52973",
      hash: hash.sha384,
      gRed: false,
      g: [
        "aa87ca22 be8b0537 8eb1c71e f320ad74 6e1d3b62 8ba79b98 59f741e0 82542a38 5502f25d bf55296c 3a545e38 72760ab7",
        "3617de4a 96262c6f 5d9e98bf 9292dc29 f8f41dbd 289a147c e9da3113 b5f0b8c0 0a60b1ce 1d7e819d 7a431d7c 90ea0e5f"
      ]
    });
    defineCurve("p521", {
      type: "short",
      prime: null,
      p: "000001ff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff",
      a: "000001ff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffc",
      b: "00000051 953eb961 8e1c9a1f 929a21a0 b68540ee a2da725b 99b315f3 b8b48991 8ef109e1 56193951 ec7e937b 1652c0bd 3bb1bf07 3573df88 3d2c34f1 ef451fd4 6b503f00",
      n: "000001ff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffa 51868783 bf2f966b 7fcc0148 f709a5d0 3bb5c9b8 899c47ae bb6fb71e 91386409",
      hash: hash.sha512,
      gRed: false,
      g: [
        "000000c6 858e06b7 0404e9cd 9e3ecb66 2395b442 9c648139 053fb521 f828af60 6b4d3dba a14b5e77 efe75928 fe1dc127 a2ffa8de 3348b3c1 856a429b f97e7e31 c2e5bd66",
        "00000118 39296a78 9a3bc004 5c8a5fb4 2c7d1bd9 98f54449 579b4468 17afbd17 273e662c 97ee7299 5ef42640 c550b901 3fad0761 353c7086 a272c240 88be9476 9fd16650"
      ]
    });
    defineCurve("curve25519", {
      type: "mont",
      prime: "p25519",
      p: "7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed",
      a: "76d06",
      b: "1",
      n: "1000000000000000 0000000000000000 14def9dea2f79cd6 5812631a5cf5d3ed",
      hash: hash.sha256,
      gRed: false,
      g: [
        "9"
      ]
    });
    defineCurve("ed25519", {
      type: "edwards",
      prime: "p25519",
      p: "7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed",
      a: "-1",
      c: "1",
      // -121665 * (121666^(-1)) (mod P)
      d: "52036cee2b6ffe73 8cc740797779e898 00700a4d4141d8ab 75eb4dca135978a3",
      n: "1000000000000000 0000000000000000 14def9dea2f79cd6 5812631a5cf5d3ed",
      hash: hash.sha256,
      gRed: false,
      g: [
        "216936d3cd6e53fec0a4e231fdd6dc5c692cc7609525a7b2c9562d608f25d51a",
        // 4/5
        "6666666666666666666666666666666666666666666666666666666666666658"
      ]
    });
    var pre;
    try {
      pre = require_secp256k1();
    } catch (e) {
      pre = void 0;
    }
    defineCurve("secp256k1", {
      type: "short",
      prime: "k256",
      p: "ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f",
      a: "0",
      b: "7",
      n: "ffffffff ffffffff ffffffff fffffffe baaedce6 af48a03b bfd25e8c d0364141",
      h: "1",
      hash: hash.sha256,
      // Precomputed endomorphism
      beta: "7ae96a2b657c07106e64479eac3434e99cf0497512f58995c1396c28719501ee",
      lambda: "5363ad4cc05c30e0a5261c028812645a122e22ea20816678df02967c1b23bd72",
      basis: [
        {
          a: "3086d221a7d46bcde86c90e49284eb15",
          b: "-e4437ed6010e88286f547fa90abfe4c3"
        },
        {
          a: "114ca50f7a8e2f3f657c1108d9d44cfd8",
          b: "3086d221a7d46bcde86c90e49284eb15"
        }
      ],
      gRed: false,
      g: [
        "79be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798",
        "483ada7726a3c4655da4fbfc0e1108a8fd17b448a68554199c47d08ffb10d4b8",
        pre
      ]
    });
  }
});

// node_modules/hmac-drbg/lib/hmac-drbg.js
var require_hmac_drbg = __commonJS({
  "node_modules/hmac-drbg/lib/hmac-drbg.js"(exports2, module2) {
    "use strict";
    var hash = require_hash();
    var utils = require_utils();
    var assert = require_minimalistic_assert();
    function HmacDRBG(options) {
      if (!(this instanceof HmacDRBG))
        return new HmacDRBG(options);
      this.hash = options.hash;
      this.predResist = !!options.predResist;
      this.outLen = this.hash.outSize;
      this.minEntropy = options.minEntropy || this.hash.hmacStrength;
      this._reseed = null;
      this.reseedInterval = null;
      this.K = null;
      this.V = null;
      var entropy = utils.toArray(options.entropy, options.entropyEnc || "hex");
      var nonce = utils.toArray(options.nonce, options.nonceEnc || "hex");
      var pers = utils.toArray(options.pers, options.persEnc || "hex");
      assert(
        entropy.length >= this.minEntropy / 8,
        "Not enough entropy. Minimum is: " + this.minEntropy + " bits"
      );
      this._init(entropy, nonce, pers);
    }
    module2.exports = HmacDRBG;
    HmacDRBG.prototype._init = function init(entropy, nonce, pers) {
      var seed = entropy.concat(nonce).concat(pers);
      this.K = new Array(this.outLen / 8);
      this.V = new Array(this.outLen / 8);
      for (var i = 0; i < this.V.length; i++) {
        this.K[i] = 0;
        this.V[i] = 1;
      }
      this._update(seed);
      this._reseed = 1;
      this.reseedInterval = 281474976710656;
    };
    HmacDRBG.prototype._hmac = function hmac() {
      return new hash.hmac(this.hash, this.K);
    };
    HmacDRBG.prototype._update = function update(seed) {
      var kmac = this._hmac().update(this.V).update([0]);
      if (seed)
        kmac = kmac.update(seed);
      this.K = kmac.digest();
      this.V = this._hmac().update(this.V).digest();
      if (!seed)
        return;
      this.K = this._hmac().update(this.V).update([1]).update(seed).digest();
      this.V = this._hmac().update(this.V).digest();
    };
    HmacDRBG.prototype.reseed = function reseed(entropy, entropyEnc, add, addEnc) {
      if (typeof entropyEnc !== "string") {
        addEnc = add;
        add = entropyEnc;
        entropyEnc = null;
      }
      entropy = utils.toArray(entropy, entropyEnc);
      add = utils.toArray(add, addEnc);
      assert(
        entropy.length >= this.minEntropy / 8,
        "Not enough entropy. Minimum is: " + this.minEntropy + " bits"
      );
      this._update(entropy.concat(add || []));
      this._reseed = 1;
    };
    HmacDRBG.prototype.generate = function generate(len, enc, add, addEnc) {
      if (this._reseed > this.reseedInterval)
        throw new Error("Reseed is required");
      if (typeof enc !== "string") {
        addEnc = add;
        add = enc;
        enc = null;
      }
      if (add) {
        add = utils.toArray(add, addEnc || "hex");
        this._update(add);
      }
      var temp = [];
      while (temp.length < len) {
        this.V = this._hmac().update(this.V).digest();
        temp = temp.concat(this.V);
      }
      var res = temp.slice(0, len);
      this._update(add);
      this._reseed++;
      return utils.encode(res, enc);
    };
  }
});

// node_modules/elliptic/lib/elliptic/ec/key.js
var require_key = __commonJS({
  "node_modules/elliptic/lib/elliptic/ec/key.js"(exports2, module2) {
    "use strict";
    var BN = require_bn();
    var utils = require_utils2();
    var assert = utils.assert;
    function KeyPair(ec, options) {
      this.ec = ec;
      this.priv = null;
      this.pub = null;
      if (options.priv)
        this._importPrivate(options.priv, options.privEnc);
      if (options.pub)
        this._importPublic(options.pub, options.pubEnc);
    }
    module2.exports = KeyPair;
    KeyPair.fromPublic = function fromPublic(ec, pub, enc) {
      if (pub instanceof KeyPair)
        return pub;
      return new KeyPair(ec, {
        pub,
        pubEnc: enc
      });
    };
    KeyPair.fromPrivate = function fromPrivate(ec, priv, enc) {
      if (priv instanceof KeyPair)
        return priv;
      return new KeyPair(ec, {
        priv,
        privEnc: enc
      });
    };
    KeyPair.prototype.validate = function validate() {
      var pub = this.getPublic();
      if (pub.isInfinity())
        return { result: false, reason: "Invalid public key" };
      if (!pub.validate())
        return { result: false, reason: "Public key is not a point" };
      if (!pub.mul(this.ec.curve.n).isInfinity())
        return { result: false, reason: "Public key * N != O" };
      return { result: true, reason: null };
    };
    KeyPair.prototype.getPublic = function getPublic(compact, enc) {
      if (typeof compact === "string") {
        enc = compact;
        compact = null;
      }
      if (!this.pub)
        this.pub = this.ec.g.mul(this.priv);
      if (!enc)
        return this.pub;
      return this.pub.encode(enc, compact);
    };
    KeyPair.prototype.getPrivate = function getPrivate(enc) {
      if (enc === "hex")
        return this.priv.toString(16, 2);
      else
        return this.priv;
    };
    KeyPair.prototype._importPrivate = function _importPrivate(key, enc) {
      this.priv = new BN(key, enc || 16);
      this.priv = this.priv.umod(this.ec.curve.n);
    };
    KeyPair.prototype._importPublic = function _importPublic(key, enc) {
      if (key.x || key.y) {
        if (this.ec.curve.type === "mont") {
          assert(key.x, "Need x coordinate");
        } else if (this.ec.curve.type === "short" || this.ec.curve.type === "edwards") {
          assert(key.x && key.y, "Need both x and y coordinate");
        }
        this.pub = this.ec.curve.point(key.x, key.y);
        return;
      }
      this.pub = this.ec.curve.decodePoint(key, enc);
    };
    KeyPair.prototype.derive = function derive(pub) {
      if (!pub.validate()) {
        assert(pub.validate(), "public point not validated");
      }
      return pub.mul(this.priv).getX();
    };
    KeyPair.prototype.sign = function sign(msg, enc, options) {
      return this.ec.sign(msg, this, enc, options);
    };
    KeyPair.prototype.verify = function verify(msg, signature) {
      return this.ec.verify(msg, signature, this);
    };
    KeyPair.prototype.inspect = function inspect() {
      return "<Key priv: " + (this.priv && this.priv.toString(16, 2)) + " pub: " + (this.pub && this.pub.inspect()) + " >";
    };
  }
});

// node_modules/elliptic/lib/elliptic/ec/signature.js
var require_signature = __commonJS({
  "node_modules/elliptic/lib/elliptic/ec/signature.js"(exports2, module2) {
    "use strict";
    var BN = require_bn();
    var utils = require_utils2();
    var assert = utils.assert;
    function Signature(options, enc) {
      if (options instanceof Signature)
        return options;
      if (this._importDER(options, enc))
        return;
      assert(options.r && options.s, "Signature without r or s");
      this.r = new BN(options.r, 16);
      this.s = new BN(options.s, 16);
      if (options.recoveryParam === void 0)
        this.recoveryParam = null;
      else
        this.recoveryParam = options.recoveryParam;
    }
    module2.exports = Signature;
    function Position() {
      this.place = 0;
    }
    function getLength(buf, p) {
      var initial = buf[p.place++];
      if (!(initial & 128)) {
        return initial;
      }
      var octetLen = initial & 15;
      if (octetLen === 0 || octetLen > 4) {
        return false;
      }
      var val = 0;
      for (var i = 0, off = p.place; i < octetLen; i++, off++) {
        val <<= 8;
        val |= buf[off];
        val >>>= 0;
      }
      if (val <= 127) {
        return false;
      }
      p.place = off;
      return val;
    }
    function rmPadding(buf) {
      var i = 0;
      var len = buf.length - 1;
      while (!buf[i] && !(buf[i + 1] & 128) && i < len) {
        i++;
      }
      if (i === 0) {
        return buf;
      }
      return buf.slice(i);
    }
    Signature.prototype._importDER = function _importDER(data, enc) {
      data = utils.toArray(data, enc);
      var p = new Position();
      if (data[p.place++] !== 48) {
        return false;
      }
      var len = getLength(data, p);
      if (len === false) {
        return false;
      }
      if (len + p.place !== data.length) {
        return false;
      }
      if (data[p.place++] !== 2) {
        return false;
      }
      var rlen = getLength(data, p);
      if (rlen === false) {
        return false;
      }
      var r = data.slice(p.place, rlen + p.place);
      p.place += rlen;
      if (data[p.place++] !== 2) {
        return false;
      }
      var slen = getLength(data, p);
      if (slen === false) {
        return false;
      }
      if (data.length !== slen + p.place) {
        return false;
      }
      var s = data.slice(p.place, slen + p.place);
      if (r[0] === 0) {
        if (r[1] & 128) {
          r = r.slice(1);
        } else {
          return false;
        }
      }
      if (s[0] === 0) {
        if (s[1] & 128) {
          s = s.slice(1);
        } else {
          return false;
        }
      }
      this.r = new BN(r);
      this.s = new BN(s);
      this.recoveryParam = null;
      return true;
    };
    function constructLength(arr, len) {
      if (len < 128) {
        arr.push(len);
        return;
      }
      var octets = 1 + (Math.log(len) / Math.LN2 >>> 3);
      arr.push(octets | 128);
      while (--octets) {
        arr.push(len >>> (octets << 3) & 255);
      }
      arr.push(len);
    }
    Signature.prototype.toDER = function toDER(enc) {
      var r = this.r.toArray();
      var s = this.s.toArray();
      if (r[0] & 128)
        r = [0].concat(r);
      if (s[0] & 128)
        s = [0].concat(s);
      r = rmPadding(r);
      s = rmPadding(s);
      while (!s[0] && !(s[1] & 128)) {
        s = s.slice(1);
      }
      var arr = [2];
      constructLength(arr, r.length);
      arr = arr.concat(r);
      arr.push(2);
      constructLength(arr, s.length);
      var backHalf = arr.concat(s);
      var res = [48];
      constructLength(res, backHalf.length);
      res = res.concat(backHalf);
      return utils.encode(res, enc);
    };
  }
});

// node_modules/elliptic/lib/elliptic/ec/index.js
var require_ec = __commonJS({
  "node_modules/elliptic/lib/elliptic/ec/index.js"(exports2, module2) {
    "use strict";
    var BN = require_bn();
    var HmacDRBG = require_hmac_drbg();
    var utils = require_utils2();
    var curves = require_curves();
    var rand = require_brorand();
    var assert = utils.assert;
    var KeyPair = require_key();
    var Signature = require_signature();
    function EC(options) {
      if (!(this instanceof EC))
        return new EC(options);
      if (typeof options === "string") {
        assert(
          Object.prototype.hasOwnProperty.call(curves, options),
          "Unknown curve " + options
        );
        options = curves[options];
      }
      if (options instanceof curves.PresetCurve)
        options = { curve: options };
      this.curve = options.curve.curve;
      this.n = this.curve.n;
      this.nh = this.n.ushrn(1);
      this.g = this.curve.g;
      this.g = options.curve.g;
      this.g.precompute(options.curve.n.bitLength() + 1);
      this.hash = options.hash || options.curve.hash;
    }
    module2.exports = EC;
    EC.prototype.keyPair = function keyPair(options) {
      return new KeyPair(this, options);
    };
    EC.prototype.keyFromPrivate = function keyFromPrivate(priv, enc) {
      return KeyPair.fromPrivate(this, priv, enc);
    };
    EC.prototype.keyFromPublic = function keyFromPublic(pub, enc) {
      return KeyPair.fromPublic(this, pub, enc);
    };
    EC.prototype.genKeyPair = function genKeyPair(options) {
      if (!options)
        options = {};
      var drbg = new HmacDRBG({
        hash: this.hash,
        pers: options.pers,
        persEnc: options.persEnc || "utf8",
        entropy: options.entropy || rand(this.hash.hmacStrength),
        entropyEnc: options.entropy && options.entropyEnc || "utf8",
        nonce: this.n.toArray()
      });
      var bytes = this.n.byteLength();
      var ns2 = this.n.sub(new BN(2));
      for (; ; ) {
        var priv = new BN(drbg.generate(bytes));
        if (priv.cmp(ns2) > 0)
          continue;
        priv.iaddn(1);
        return this.keyFromPrivate(priv);
      }
    };
    EC.prototype._truncateToN = function _truncateToN(msg, truncOnly) {
      var delta = msg.byteLength() * 8 - this.n.bitLength();
      if (delta > 0)
        msg = msg.ushrn(delta);
      if (!truncOnly && msg.cmp(this.n) >= 0)
        return msg.sub(this.n);
      else
        return msg;
    };
    EC.prototype.sign = function sign(msg, key, enc, options) {
      if (typeof enc === "object") {
        options = enc;
        enc = null;
      }
      if (!options)
        options = {};
      key = this.keyFromPrivate(key, enc);
      msg = this._truncateToN(new BN(msg, 16));
      var bytes = this.n.byteLength();
      var bkey = key.getPrivate().toArray("be", bytes);
      var nonce = msg.toArray("be", bytes);
      var drbg = new HmacDRBG({
        hash: this.hash,
        entropy: bkey,
        nonce,
        pers: options.pers,
        persEnc: options.persEnc || "utf8"
      });
      var ns1 = this.n.sub(new BN(1));
      for (var iter = 0; ; iter++) {
        var k = options.k ? options.k(iter) : new BN(drbg.generate(this.n.byteLength()));
        k = this._truncateToN(k, true);
        if (k.cmpn(1) <= 0 || k.cmp(ns1) >= 0)
          continue;
        var kp = this.g.mul(k);
        if (kp.isInfinity())
          continue;
        var kpX = kp.getX();
        var r = kpX.umod(this.n);
        if (r.cmpn(0) === 0)
          continue;
        var s = k.invm(this.n).mul(r.mul(key.getPrivate()).iadd(msg));
        s = s.umod(this.n);
        if (s.cmpn(0) === 0)
          continue;
        var recoveryParam = (kp.getY().isOdd() ? 1 : 0) | (kpX.cmp(r) !== 0 ? 2 : 0);
        if (options.canonical && s.cmp(this.nh) > 0) {
          s = this.n.sub(s);
          recoveryParam ^= 1;
        }
        return new Signature({ r, s, recoveryParam });
      }
    };
    EC.prototype.verify = function verify(msg, signature, key, enc) {
      msg = this._truncateToN(new BN(msg, 16));
      key = this.keyFromPublic(key, enc);
      signature = new Signature(signature, "hex");
      var r = signature.r;
      var s = signature.s;
      if (r.cmpn(1) < 0 || r.cmp(this.n) >= 0)
        return false;
      if (s.cmpn(1) < 0 || s.cmp(this.n) >= 0)
        return false;
      var sinv = s.invm(this.n);
      var u1 = sinv.mul(msg).umod(this.n);
      var u2 = sinv.mul(r).umod(this.n);
      var p;
      if (!this.curve._maxwellTrick) {
        p = this.g.mulAdd(u1, key.getPublic(), u2);
        if (p.isInfinity())
          return false;
        return p.getX().umod(this.n).cmp(r) === 0;
      }
      p = this.g.jmulAdd(u1, key.getPublic(), u2);
      if (p.isInfinity())
        return false;
      return p.eqXToP(r);
    };
    EC.prototype.recoverPubKey = function(msg, signature, j, enc) {
      assert((3 & j) === j, "The recovery param is more than two bits");
      signature = new Signature(signature, enc);
      var n = this.n;
      var e = new BN(msg);
      var r = signature.r;
      var s = signature.s;
      var isYOdd = j & 1;
      var isSecondKey = j >> 1;
      if (r.cmp(this.curve.p.umod(this.curve.n)) >= 0 && isSecondKey)
        throw new Error("Unable to find sencond key candinate");
      if (isSecondKey)
        r = this.curve.pointFromX(r.add(this.curve.n), isYOdd);
      else
        r = this.curve.pointFromX(r, isYOdd);
      var rInv = signature.r.invm(n);
      var s1 = n.sub(e).mul(rInv).umod(n);
      var s2 = s.mul(rInv).umod(n);
      return this.g.mulAdd(s1, r, s2);
    };
    EC.prototype.getKeyRecoveryParam = function(e, signature, Q, enc) {
      signature = new Signature(signature, enc);
      if (signature.recoveryParam !== null)
        return signature.recoveryParam;
      for (var i = 0; i < 4; i++) {
        var Qprime;
        try {
          Qprime = this.recoverPubKey(e, signature, i);
        } catch (e2) {
          continue;
        }
        if (Qprime.eq(Q))
          return i;
      }
      throw new Error("Unable to find valid recovery factor");
    };
  }
});

// node_modules/elliptic/lib/elliptic/eddsa/key.js
var require_key2 = __commonJS({
  "node_modules/elliptic/lib/elliptic/eddsa/key.js"(exports2, module2) {
    "use strict";
    var utils = require_utils2();
    var assert = utils.assert;
    var parseBytes = utils.parseBytes;
    var cachedProperty = utils.cachedProperty;
    function KeyPair(eddsa, params) {
      this.eddsa = eddsa;
      this._secret = parseBytes(params.secret);
      if (eddsa.isPoint(params.pub))
        this._pub = params.pub;
      else
        this._pubBytes = parseBytes(params.pub);
    }
    KeyPair.fromPublic = function fromPublic(eddsa, pub) {
      if (pub instanceof KeyPair)
        return pub;
      return new KeyPair(eddsa, { pub });
    };
    KeyPair.fromSecret = function fromSecret(eddsa, secret) {
      if (secret instanceof KeyPair)
        return secret;
      return new KeyPair(eddsa, { secret });
    };
    KeyPair.prototype.secret = function secret() {
      return this._secret;
    };
    cachedProperty(KeyPair, "pubBytes", function pubBytes() {
      return this.eddsa.encodePoint(this.pub());
    });
    cachedProperty(KeyPair, "pub", function pub() {
      if (this._pubBytes)
        return this.eddsa.decodePoint(this._pubBytes);
      return this.eddsa.g.mul(this.priv());
    });
    cachedProperty(KeyPair, "privBytes", function privBytes() {
      var eddsa = this.eddsa;
      var hash = this.hash();
      var lastIx = eddsa.encodingLength - 1;
      var a = hash.slice(0, eddsa.encodingLength);
      a[0] &= 248;
      a[lastIx] &= 127;
      a[lastIx] |= 64;
      return a;
    });
    cachedProperty(KeyPair, "priv", function priv() {
      return this.eddsa.decodeInt(this.privBytes());
    });
    cachedProperty(KeyPair, "hash", function hash() {
      return this.eddsa.hash().update(this.secret()).digest();
    });
    cachedProperty(KeyPair, "messagePrefix", function messagePrefix() {
      return this.hash().slice(this.eddsa.encodingLength);
    });
    KeyPair.prototype.sign = function sign(message) {
      assert(this._secret, "KeyPair can only verify");
      return this.eddsa.sign(message, this);
    };
    KeyPair.prototype.verify = function verify(message, sig) {
      return this.eddsa.verify(message, sig, this);
    };
    KeyPair.prototype.getSecret = function getSecret(enc) {
      assert(this._secret, "KeyPair is public only");
      return utils.encode(this.secret(), enc);
    };
    KeyPair.prototype.getPublic = function getPublic(enc) {
      return utils.encode(this.pubBytes(), enc);
    };
    module2.exports = KeyPair;
  }
});

// node_modules/elliptic/lib/elliptic/eddsa/signature.js
var require_signature2 = __commonJS({
  "node_modules/elliptic/lib/elliptic/eddsa/signature.js"(exports2, module2) {
    "use strict";
    var BN = require_bn();
    var utils = require_utils2();
    var assert = utils.assert;
    var cachedProperty = utils.cachedProperty;
    var parseBytes = utils.parseBytes;
    function Signature(eddsa, sig) {
      this.eddsa = eddsa;
      if (typeof sig !== "object")
        sig = parseBytes(sig);
      if (Array.isArray(sig)) {
        sig = {
          R: sig.slice(0, eddsa.encodingLength),
          S: sig.slice(eddsa.encodingLength)
        };
      }
      assert(sig.R && sig.S, "Signature without R or S");
      if (eddsa.isPoint(sig.R))
        this._R = sig.R;
      if (sig.S instanceof BN)
        this._S = sig.S;
      this._Rencoded = Array.isArray(sig.R) ? sig.R : sig.Rencoded;
      this._Sencoded = Array.isArray(sig.S) ? sig.S : sig.Sencoded;
    }
    cachedProperty(Signature, "S", function S() {
      return this.eddsa.decodeInt(this.Sencoded());
    });
    cachedProperty(Signature, "R", function R() {
      return this.eddsa.decodePoint(this.Rencoded());
    });
    cachedProperty(Signature, "Rencoded", function Rencoded() {
      return this.eddsa.encodePoint(this.R());
    });
    cachedProperty(Signature, "Sencoded", function Sencoded() {
      return this.eddsa.encodeInt(this.S());
    });
    Signature.prototype.toBytes = function toBytes() {
      return this.Rencoded().concat(this.Sencoded());
    };
    Signature.prototype.toHex = function toHex() {
      return utils.encode(this.toBytes(), "hex").toUpperCase();
    };
    module2.exports = Signature;
  }
});

// node_modules/elliptic/lib/elliptic/eddsa/index.js
var require_eddsa = __commonJS({
  "node_modules/elliptic/lib/elliptic/eddsa/index.js"(exports2, module2) {
    "use strict";
    var hash = require_hash();
    var curves = require_curves();
    var utils = require_utils2();
    var assert = utils.assert;
    var parseBytes = utils.parseBytes;
    var KeyPair = require_key2();
    var Signature = require_signature2();
    function EDDSA(curve) {
      assert(curve === "ed25519", "only tested with ed25519 so far");
      if (!(this instanceof EDDSA))
        return new EDDSA(curve);
      curve = curves[curve].curve;
      this.curve = curve;
      this.g = curve.g;
      this.g.precompute(curve.n.bitLength() + 1);
      this.pointClass = curve.point().constructor;
      this.encodingLength = Math.ceil(curve.n.bitLength() / 8);
      this.hash = hash.sha512;
    }
    module2.exports = EDDSA;
    EDDSA.prototype.sign = function sign(message, secret) {
      message = parseBytes(message);
      var key = this.keyFromSecret(secret);
      var r = this.hashInt(key.messagePrefix(), message);
      var R = this.g.mul(r);
      var Rencoded = this.encodePoint(R);
      var s_ = this.hashInt(Rencoded, key.pubBytes(), message).mul(key.priv());
      var S = r.add(s_).umod(this.curve.n);
      return this.makeSignature({ R, S, Rencoded });
    };
    EDDSA.prototype.verify = function verify(message, sig, pub) {
      message = parseBytes(message);
      sig = this.makeSignature(sig);
      var key = this.keyFromPublic(pub);
      var h = this.hashInt(sig.Rencoded(), key.pubBytes(), message);
      var SG = this.g.mul(sig.S());
      var RplusAh = sig.R().add(key.pub().mul(h));
      return RplusAh.eq(SG);
    };
    EDDSA.prototype.hashInt = function hashInt() {
      var hash2 = this.hash();
      for (var i = 0; i < arguments.length; i++)
        hash2.update(arguments[i]);
      return utils.intFromLE(hash2.digest()).umod(this.curve.n);
    };
    EDDSA.prototype.keyFromPublic = function keyFromPublic(pub) {
      return KeyPair.fromPublic(this, pub);
    };
    EDDSA.prototype.keyFromSecret = function keyFromSecret(secret) {
      return KeyPair.fromSecret(this, secret);
    };
    EDDSA.prototype.makeSignature = function makeSignature(sig) {
      if (sig instanceof Signature)
        return sig;
      return new Signature(this, sig);
    };
    EDDSA.prototype.encodePoint = function encodePoint(point) {
      var enc = point.getY().toArray("le", this.encodingLength);
      enc[this.encodingLength - 1] |= point.getX().isOdd() ? 128 : 0;
      return enc;
    };
    EDDSA.prototype.decodePoint = function decodePoint(bytes) {
      bytes = utils.parseBytes(bytes);
      var lastIx = bytes.length - 1;
      var normed = bytes.slice(0, lastIx).concat(bytes[lastIx] & ~128);
      var xIsOdd = (bytes[lastIx] & 128) !== 0;
      var y = utils.intFromLE(normed);
      return this.curve.pointFromY(y, xIsOdd);
    };
    EDDSA.prototype.encodeInt = function encodeInt(num) {
      return num.toArray("le", this.encodingLength);
    };
    EDDSA.prototype.decodeInt = function decodeInt(bytes) {
      return utils.intFromLE(bytes);
    };
    EDDSA.prototype.isPoint = function isPoint(val) {
      return val instanceof this.pointClass;
    };
  }
});

// node_modules/elliptic/lib/elliptic.js
var require_elliptic = __commonJS({
  "node_modules/elliptic/lib/elliptic.js"(exports2) {
    "use strict";
    var elliptic = exports2;
    elliptic.version = require_package().version;
    elliptic.utils = require_utils2();
    elliptic.rand = require_brorand();
    elliptic.curve = require_curve();
    elliptic.curves = require_curves();
    elliptic.ec = require_ec();
    elliptic.eddsa = require_eddsa();
  }
});

// node_modules/@ethersproject/signing-key/lib/elliptic.js
var require_elliptic2 = __commonJS({
  "node_modules/@ethersproject/signing-key/lib/elliptic.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.EC = void 0;
    var elliptic_1 = __importDefault(require_elliptic());
    var EC = elliptic_1.default.ec;
    exports2.EC = EC;
  }
});

// node_modules/@ethersproject/signing-key/lib/_version.js
var require_version12 = __commonJS({
  "node_modules/@ethersproject/signing-key/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "signing-key/5.5.0";
  }
});

// node_modules/@ethersproject/signing-key/lib/index.js
var require_lib14 = __commonJS({
  "node_modules/@ethersproject/signing-key/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.computePublicKey = exports2.recoverPublicKey = exports2.SigningKey = void 0;
    var elliptic_1 = require_elliptic2();
    var bytes_1 = require_lib2();
    var properties_1 = require_lib4();
    var logger_1 = require_lib();
    var _version_1 = require_version12();
    var logger = new logger_1.Logger(_version_1.version);
    var _curve = null;
    function getCurve() {
      if (!_curve) {
        _curve = new elliptic_1.EC("secp256k1");
      }
      return _curve;
    }
    var SigningKey = (
      /** @class */
      function() {
        function SigningKey2(privateKey) {
          (0, properties_1.defineReadOnly)(this, "curve", "secp256k1");
          (0, properties_1.defineReadOnly)(this, "privateKey", (0, bytes_1.hexlify)(privateKey));
          var keyPair = getCurve().keyFromPrivate((0, bytes_1.arrayify)(this.privateKey));
          (0, properties_1.defineReadOnly)(this, "publicKey", "0x" + keyPair.getPublic(false, "hex"));
          (0, properties_1.defineReadOnly)(this, "compressedPublicKey", "0x" + keyPair.getPublic(true, "hex"));
          (0, properties_1.defineReadOnly)(this, "_isSigningKey", true);
        }
        SigningKey2.prototype._addPoint = function(other) {
          var p0 = getCurve().keyFromPublic((0, bytes_1.arrayify)(this.publicKey));
          var p1 = getCurve().keyFromPublic((0, bytes_1.arrayify)(other));
          return "0x" + p0.pub.add(p1.pub).encodeCompressed("hex");
        };
        SigningKey2.prototype.signDigest = function(digest) {
          var keyPair = getCurve().keyFromPrivate((0, bytes_1.arrayify)(this.privateKey));
          var digestBytes = (0, bytes_1.arrayify)(digest);
          if (digestBytes.length !== 32) {
            logger.throwArgumentError("bad digest length", "digest", digest);
          }
          var signature = keyPair.sign(digestBytes, { canonical: true });
          return (0, bytes_1.splitSignature)({
            recoveryParam: signature.recoveryParam,
            r: (0, bytes_1.hexZeroPad)("0x" + signature.r.toString(16), 32),
            s: (0, bytes_1.hexZeroPad)("0x" + signature.s.toString(16), 32)
          });
        };
        SigningKey2.prototype.computeSharedSecret = function(otherKey) {
          var keyPair = getCurve().keyFromPrivate((0, bytes_1.arrayify)(this.privateKey));
          var otherKeyPair = getCurve().keyFromPublic((0, bytes_1.arrayify)(computePublicKey(otherKey)));
          return (0, bytes_1.hexZeroPad)("0x" + keyPair.derive(otherKeyPair.getPublic()).toString(16), 32);
        };
        SigningKey2.isSigningKey = function(value) {
          return !!(value && value._isSigningKey);
        };
        return SigningKey2;
      }()
    );
    exports2.SigningKey = SigningKey;
    function recoverPublicKey(digest, signature) {
      var sig = (0, bytes_1.splitSignature)(signature);
      var rs = { r: (0, bytes_1.arrayify)(sig.r), s: (0, bytes_1.arrayify)(sig.s) };
      return "0x" + getCurve().recoverPubKey((0, bytes_1.arrayify)(digest), rs, sig.recoveryParam).encode("hex", false);
    }
    exports2.recoverPublicKey = recoverPublicKey;
    function computePublicKey(key, compressed) {
      var bytes = (0, bytes_1.arrayify)(key);
      if (bytes.length === 32) {
        var signingKey = new SigningKey(bytes);
        if (compressed) {
          return "0x" + getCurve().keyFromPrivate(bytes).getPublic(true, "hex");
        }
        return signingKey.publicKey;
      } else if (bytes.length === 33) {
        if (compressed) {
          return (0, bytes_1.hexlify)(bytes);
        }
        return "0x" + getCurve().keyFromPublic(bytes).getPublic(false, "hex");
      } else if (bytes.length === 65) {
        if (!compressed) {
          return (0, bytes_1.hexlify)(bytes);
        }
        return "0x" + getCurve().keyFromPublic(bytes).getPublic(true, "hex");
      }
      return logger.throwArgumentError("invalid public or private key", "key", "[REDACTED]");
    }
    exports2.computePublicKey = computePublicKey;
  }
});

// node_modules/@ethersproject/transactions/lib/_version.js
var require_version13 = __commonJS({
  "node_modules/@ethersproject/transactions/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "transactions/5.5.0";
  }
});

// node_modules/@ethersproject/transactions/lib/index.js
var require_lib15 = __commonJS({
  "node_modules/@ethersproject/transactions/lib/index.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.parse = exports2.serialize = exports2.accessListify = exports2.recoverAddress = exports2.computeAddress = exports2.TransactionTypes = void 0;
    var address_1 = require_lib7();
    var bignumber_1 = require_lib3();
    var bytes_1 = require_lib2();
    var constants_1 = require_lib8();
    var keccak256_1 = require_lib5();
    var properties_1 = require_lib4();
    var RLP = __importStar(require_lib6());
    var signing_key_1 = require_lib14();
    var logger_1 = require_lib();
    var _version_1 = require_version13();
    var logger = new logger_1.Logger(_version_1.version);
    var TransactionTypes;
    (function(TransactionTypes2) {
      TransactionTypes2[TransactionTypes2["legacy"] = 0] = "legacy";
      TransactionTypes2[TransactionTypes2["eip2930"] = 1] = "eip2930";
      TransactionTypes2[TransactionTypes2["eip1559"] = 2] = "eip1559";
    })(TransactionTypes = exports2.TransactionTypes || (exports2.TransactionTypes = {}));
    function handleAddress(value) {
      if (value === "0x") {
        return null;
      }
      return (0, address_1.getAddress)(value);
    }
    function handleNumber(value) {
      if (value === "0x") {
        return constants_1.Zero;
      }
      return bignumber_1.BigNumber.from(value);
    }
    var transactionFields = [
      { name: "nonce", maxLength: 32, numeric: true },
      { name: "gasPrice", maxLength: 32, numeric: true },
      { name: "gasLimit", maxLength: 32, numeric: true },
      { name: "to", length: 20 },
      { name: "value", maxLength: 32, numeric: true },
      { name: "data" }
    ];
    var allowedTransactionKeys = {
      chainId: true,
      data: true,
      gasLimit: true,
      gasPrice: true,
      nonce: true,
      to: true,
      type: true,
      value: true
    };
    function computeAddress(key) {
      var publicKey = (0, signing_key_1.computePublicKey)(key);
      return (0, address_1.getAddress)((0, bytes_1.hexDataSlice)((0, keccak256_1.keccak256)((0, bytes_1.hexDataSlice)(publicKey, 1)), 12));
    }
    exports2.computeAddress = computeAddress;
    function recoverAddress(digest, signature) {
      return computeAddress((0, signing_key_1.recoverPublicKey)((0, bytes_1.arrayify)(digest), signature));
    }
    exports2.recoverAddress = recoverAddress;
    function formatNumber(value, name2) {
      var result = (0, bytes_1.stripZeros)(bignumber_1.BigNumber.from(value).toHexString());
      if (result.length > 32) {
        logger.throwArgumentError("invalid length for " + name2, "transaction:" + name2, value);
      }
      return result;
    }
    function accessSetify(addr, storageKeys) {
      return {
        address: (0, address_1.getAddress)(addr),
        storageKeys: (storageKeys || []).map(function(storageKey, index) {
          if ((0, bytes_1.hexDataLength)(storageKey) !== 32) {
            logger.throwArgumentError("invalid access list storageKey", "accessList[" + addr + ":" + index + "]", storageKey);
          }
          return storageKey.toLowerCase();
        })
      };
    }
    function accessListify(value) {
      if (Array.isArray(value)) {
        return value.map(function(set, index) {
          if (Array.isArray(set)) {
            if (set.length > 2) {
              logger.throwArgumentError("access list expected to be [ address, storageKeys[] ]", "value[" + index + "]", set);
            }
            return accessSetify(set[0], set[1]);
          }
          return accessSetify(set.address, set.storageKeys);
        });
      }
      var result = Object.keys(value).map(function(addr) {
        var storageKeys = value[addr].reduce(function(accum, storageKey) {
          accum[storageKey] = true;
          return accum;
        }, {});
        return accessSetify(addr, Object.keys(storageKeys).sort());
      });
      result.sort(function(a, b) {
        return a.address.localeCompare(b.address);
      });
      return result;
    }
    exports2.accessListify = accessListify;
    function formatAccessList(value) {
      return accessListify(value).map(function(set) {
        return [set.address, set.storageKeys];
      });
    }
    function _serializeEip1559(transaction, signature) {
      if (transaction.gasPrice != null) {
        var gasPrice = bignumber_1.BigNumber.from(transaction.gasPrice);
        var maxFeePerGas = bignumber_1.BigNumber.from(transaction.maxFeePerGas || 0);
        if (!gasPrice.eq(maxFeePerGas)) {
          logger.throwArgumentError("mismatch EIP-1559 gasPrice != maxFeePerGas", "tx", {
            gasPrice,
            maxFeePerGas
          });
        }
      }
      var fields = [
        formatNumber(transaction.chainId || 0, "chainId"),
        formatNumber(transaction.nonce || 0, "nonce"),
        formatNumber(transaction.maxPriorityFeePerGas || 0, "maxPriorityFeePerGas"),
        formatNumber(transaction.maxFeePerGas || 0, "maxFeePerGas"),
        formatNumber(transaction.gasLimit || 0, "gasLimit"),
        transaction.to != null ? (0, address_1.getAddress)(transaction.to) : "0x",
        formatNumber(transaction.value || 0, "value"),
        transaction.data || "0x",
        formatAccessList(transaction.accessList || [])
      ];
      if (signature) {
        var sig = (0, bytes_1.splitSignature)(signature);
        fields.push(formatNumber(sig.recoveryParam, "recoveryParam"));
        fields.push((0, bytes_1.stripZeros)(sig.r));
        fields.push((0, bytes_1.stripZeros)(sig.s));
      }
      return (0, bytes_1.hexConcat)(["0x02", RLP.encode(fields)]);
    }
    function _serializeEip2930(transaction, signature) {
      var fields = [
        formatNumber(transaction.chainId || 0, "chainId"),
        formatNumber(transaction.nonce || 0, "nonce"),
        formatNumber(transaction.gasPrice || 0, "gasPrice"),
        formatNumber(transaction.gasLimit || 0, "gasLimit"),
        transaction.to != null ? (0, address_1.getAddress)(transaction.to) : "0x",
        formatNumber(transaction.value || 0, "value"),
        transaction.data || "0x",
        formatAccessList(transaction.accessList || [])
      ];
      if (signature) {
        var sig = (0, bytes_1.splitSignature)(signature);
        fields.push(formatNumber(sig.recoveryParam, "recoveryParam"));
        fields.push((0, bytes_1.stripZeros)(sig.r));
        fields.push((0, bytes_1.stripZeros)(sig.s));
      }
      return (0, bytes_1.hexConcat)(["0x01", RLP.encode(fields)]);
    }
    function _serialize(transaction, signature) {
      (0, properties_1.checkProperties)(transaction, allowedTransactionKeys);
      var raw = [];
      transactionFields.forEach(function(fieldInfo) {
        var value = transaction[fieldInfo.name] || [];
        var options = {};
        if (fieldInfo.numeric) {
          options.hexPad = "left";
        }
        value = (0, bytes_1.arrayify)((0, bytes_1.hexlify)(value, options));
        if (fieldInfo.length && value.length !== fieldInfo.length && value.length > 0) {
          logger.throwArgumentError("invalid length for " + fieldInfo.name, "transaction:" + fieldInfo.name, value);
        }
        if (fieldInfo.maxLength) {
          value = (0, bytes_1.stripZeros)(value);
          if (value.length > fieldInfo.maxLength) {
            logger.throwArgumentError("invalid length for " + fieldInfo.name, "transaction:" + fieldInfo.name, value);
          }
        }
        raw.push((0, bytes_1.hexlify)(value));
      });
      var chainId = 0;
      if (transaction.chainId != null) {
        chainId = transaction.chainId;
        if (typeof chainId !== "number") {
          logger.throwArgumentError("invalid transaction.chainId", "transaction", transaction);
        }
      } else if (signature && !(0, bytes_1.isBytesLike)(signature) && signature.v > 28) {
        chainId = Math.floor((signature.v - 35) / 2);
      }
      if (chainId !== 0) {
        raw.push((0, bytes_1.hexlify)(chainId));
        raw.push("0x");
        raw.push("0x");
      }
      if (!signature) {
        return RLP.encode(raw);
      }
      var sig = (0, bytes_1.splitSignature)(signature);
      var v = 27 + sig.recoveryParam;
      if (chainId !== 0) {
        raw.pop();
        raw.pop();
        raw.pop();
        v += chainId * 2 + 8;
        if (sig.v > 28 && sig.v !== v) {
          logger.throwArgumentError("transaction.chainId/signature.v mismatch", "signature", signature);
        }
      } else if (sig.v !== v) {
        logger.throwArgumentError("transaction.chainId/signature.v mismatch", "signature", signature);
      }
      raw.push((0, bytes_1.hexlify)(v));
      raw.push((0, bytes_1.stripZeros)((0, bytes_1.arrayify)(sig.r)));
      raw.push((0, bytes_1.stripZeros)((0, bytes_1.arrayify)(sig.s)));
      return RLP.encode(raw);
    }
    function serialize(transaction, signature) {
      if (transaction.type == null || transaction.type === 0) {
        if (transaction.accessList != null) {
          logger.throwArgumentError("untyped transactions do not support accessList; include type: 1", "transaction", transaction);
        }
        return _serialize(transaction, signature);
      }
      switch (transaction.type) {
        case 1:
          return _serializeEip2930(transaction, signature);
        case 2:
          return _serializeEip1559(transaction, signature);
        default:
          break;
      }
      return logger.throwError("unsupported transaction type: " + transaction.type, logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
        operation: "serializeTransaction",
        transactionType: transaction.type
      });
    }
    exports2.serialize = serialize;
    function _parseEipSignature(tx, fields, serialize2) {
      try {
        var recid = handleNumber(fields[0]).toNumber();
        if (recid !== 0 && recid !== 1) {
          throw new Error("bad recid");
        }
        tx.v = recid;
      } catch (error) {
        logger.throwArgumentError("invalid v for transaction type: 1", "v", fields[0]);
      }
      tx.r = (0, bytes_1.hexZeroPad)(fields[1], 32);
      tx.s = (0, bytes_1.hexZeroPad)(fields[2], 32);
      try {
        var digest = (0, keccak256_1.keccak256)(serialize2(tx));
        tx.from = recoverAddress(digest, { r: tx.r, s: tx.s, recoveryParam: tx.v });
      } catch (error) {
        console.log(error);
      }
    }
    function _parseEip1559(payload) {
      var transaction = RLP.decode(payload.slice(1));
      if (transaction.length !== 9 && transaction.length !== 12) {
        logger.throwArgumentError("invalid component count for transaction type: 2", "payload", (0, bytes_1.hexlify)(payload));
      }
      var maxPriorityFeePerGas = handleNumber(transaction[2]);
      var maxFeePerGas = handleNumber(transaction[3]);
      var tx = {
        type: 2,
        chainId: handleNumber(transaction[0]).toNumber(),
        nonce: handleNumber(transaction[1]).toNumber(),
        maxPriorityFeePerGas,
        maxFeePerGas,
        gasPrice: null,
        gasLimit: handleNumber(transaction[4]),
        to: handleAddress(transaction[5]),
        value: handleNumber(transaction[6]),
        data: transaction[7],
        accessList: accessListify(transaction[8])
      };
      if (transaction.length === 9) {
        return tx;
      }
      tx.hash = (0, keccak256_1.keccak256)(payload);
      _parseEipSignature(tx, transaction.slice(9), _serializeEip1559);
      return tx;
    }
    function _parseEip2930(payload) {
      var transaction = RLP.decode(payload.slice(1));
      if (transaction.length !== 8 && transaction.length !== 11) {
        logger.throwArgumentError("invalid component count for transaction type: 1", "payload", (0, bytes_1.hexlify)(payload));
      }
      var tx = {
        type: 1,
        chainId: handleNumber(transaction[0]).toNumber(),
        nonce: handleNumber(transaction[1]).toNumber(),
        gasPrice: handleNumber(transaction[2]),
        gasLimit: handleNumber(transaction[3]),
        to: handleAddress(transaction[4]),
        value: handleNumber(transaction[5]),
        data: transaction[6],
        accessList: accessListify(transaction[7])
      };
      if (transaction.length === 8) {
        return tx;
      }
      tx.hash = (0, keccak256_1.keccak256)(payload);
      _parseEipSignature(tx, transaction.slice(8), _serializeEip2930);
      return tx;
    }
    function _parse(rawTransaction) {
      var transaction = RLP.decode(rawTransaction);
      if (transaction.length !== 9 && transaction.length !== 6) {
        logger.throwArgumentError("invalid raw transaction", "rawTransaction", rawTransaction);
      }
      var tx = {
        nonce: handleNumber(transaction[0]).toNumber(),
        gasPrice: handleNumber(transaction[1]),
        gasLimit: handleNumber(transaction[2]),
        to: handleAddress(transaction[3]),
        value: handleNumber(transaction[4]),
        data: transaction[5],
        chainId: 0
      };
      if (transaction.length === 6) {
        return tx;
      }
      try {
        tx.v = bignumber_1.BigNumber.from(transaction[6]).toNumber();
      } catch (error) {
        console.log(error);
        return tx;
      }
      tx.r = (0, bytes_1.hexZeroPad)(transaction[7], 32);
      tx.s = (0, bytes_1.hexZeroPad)(transaction[8], 32);
      if (bignumber_1.BigNumber.from(tx.r).isZero() && bignumber_1.BigNumber.from(tx.s).isZero()) {
        tx.chainId = tx.v;
        tx.v = 0;
      } else {
        tx.chainId = Math.floor((tx.v - 35) / 2);
        if (tx.chainId < 0) {
          tx.chainId = 0;
        }
        var recoveryParam = tx.v - 27;
        var raw = transaction.slice(0, 6);
        if (tx.chainId !== 0) {
          raw.push((0, bytes_1.hexlify)(tx.chainId));
          raw.push("0x");
          raw.push("0x");
          recoveryParam -= tx.chainId * 2 + 8;
        }
        var digest = (0, keccak256_1.keccak256)(RLP.encode(raw));
        try {
          tx.from = recoverAddress(digest, { r: (0, bytes_1.hexlify)(tx.r), s: (0, bytes_1.hexlify)(tx.s), recoveryParam });
        } catch (error) {
          console.log(error);
        }
        tx.hash = (0, keccak256_1.keccak256)(rawTransaction);
      }
      tx.type = null;
      return tx;
    }
    function parse(rawTransaction) {
      var payload = (0, bytes_1.arrayify)(rawTransaction);
      if (payload[0] > 127) {
        return _parse(payload);
      }
      switch (payload[0]) {
        case 1:
          return _parseEip2930(payload);
        case 2:
          return _parseEip1559(payload);
        default:
          break;
      }
      return logger.throwError("unsupported transaction type: " + payload[0], logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
        operation: "parseTransaction",
        transactionType: payload[0]
      });
    }
    exports2.parse = parse;
  }
});

// node_modules/@ethersproject/contracts/lib/_version.js
var require_version14 = __commonJS({
  "node_modules/@ethersproject/contracts/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "contracts/5.5.0";
  }
});

// node_modules/@ethersproject/contracts/lib/index.js
var require_lib16 = __commonJS({
  "node_modules/@ethersproject/contracts/lib/index.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator = exports2 && exports2.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1) throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return { value: op[1], done: false };
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2]) _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
        if (op[0] & 5) throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
      }
    };
    var __spreadArray = exports2 && exports2.__spreadArray || function(to, from, pack) {
      if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
          if (!ar) ar = Array.prototype.slice.call(from, 0, i);
          ar[i] = from[i];
        }
      }
      return to.concat(ar || Array.prototype.slice.call(from));
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ContractFactory = exports2.Contract = exports2.BaseContract = void 0;
    var abi_1 = require_lib11();
    var abstract_provider_1 = require_lib12();
    var abstract_signer_1 = require_lib13();
    var address_1 = require_lib7();
    var bignumber_1 = require_lib3();
    var bytes_1 = require_lib2();
    var properties_1 = require_lib4();
    var transactions_1 = require_lib15();
    var logger_1 = require_lib();
    var _version_1 = require_version14();
    var logger = new logger_1.Logger(_version_1.version);
    var allowedTransactionKeys = {
      chainId: true,
      data: true,
      from: true,
      gasLimit: true,
      gasPrice: true,
      nonce: true,
      to: true,
      value: true,
      type: true,
      accessList: true,
      maxFeePerGas: true,
      maxPriorityFeePerGas: true,
      customData: true
    };
    function resolveName(resolver, nameOrPromise) {
      return __awaiter(this, void 0, void 0, function() {
        var name2, address;
        return __generator(this, function(_a) {
          switch (_a.label) {
            case 0:
              return [4, nameOrPromise];
            case 1:
              name2 = _a.sent();
              if (typeof name2 !== "string") {
                logger.throwArgumentError("invalid address or ENS name", "name", name2);
              }
              try {
                return [2, (0, address_1.getAddress)(name2)];
              } catch (error) {
              }
              if (!resolver) {
                logger.throwError("a provider or signer is needed to resolve ENS names", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
                  operation: "resolveName"
                });
              }
              return [4, resolver.resolveName(name2)];
            case 2:
              address = _a.sent();
              if (address == null) {
                logger.throwArgumentError("resolver or addr is not configured for ENS name", "name", name2);
              }
              return [2, address];
          }
        });
      });
    }
    function resolveAddresses(resolver, value, paramType) {
      return __awaiter(this, void 0, void 0, function() {
        return __generator(this, function(_a) {
          switch (_a.label) {
            case 0:
              if (!Array.isArray(paramType)) return [3, 2];
              return [4, Promise.all(paramType.map(function(paramType2, index) {
                return resolveAddresses(resolver, Array.isArray(value) ? value[index] : value[paramType2.name], paramType2);
              }))];
            case 1:
              return [2, _a.sent()];
            case 2:
              if (!(paramType.type === "address")) return [3, 4];
              return [4, resolveName(resolver, value)];
            case 3:
              return [2, _a.sent()];
            case 4:
              if (!(paramType.type === "tuple")) return [3, 6];
              return [4, resolveAddresses(resolver, value, paramType.components)];
            case 5:
              return [2, _a.sent()];
            case 6:
              if (!(paramType.baseType === "array")) return [3, 8];
              if (!Array.isArray(value)) {
                return [2, Promise.reject(logger.makeError("invalid value for array", logger_1.Logger.errors.INVALID_ARGUMENT, {
                  argument: "value",
                  value
                }))];
              }
              return [4, Promise.all(value.map(function(v) {
                return resolveAddresses(resolver, v, paramType.arrayChildren);
              }))];
            case 7:
              return [2, _a.sent()];
            case 8:
              return [2, value];
          }
        });
      });
    }
    function populateTransaction(contract, fragment, args) {
      return __awaiter(this, void 0, void 0, function() {
        var overrides, resolved, data, tx, ro, intrinsic, bytes, i, roValue, leftovers;
        var _this = this;
        return __generator(this, function(_a) {
          switch (_a.label) {
            case 0:
              overrides = {};
              if (args.length === fragment.inputs.length + 1 && typeof args[args.length - 1] === "object") {
                overrides = (0, properties_1.shallowCopy)(args.pop());
              }
              logger.checkArgumentCount(args.length, fragment.inputs.length, "passed to contract");
              if (contract.signer) {
                if (overrides.from) {
                  overrides.from = (0, properties_1.resolveProperties)({
                    override: resolveName(contract.signer, overrides.from),
                    signer: contract.signer.getAddress()
                  }).then(function(check) {
                    return __awaiter(_this, void 0, void 0, function() {
                      return __generator(this, function(_a2) {
                        if ((0, address_1.getAddress)(check.signer) !== check.override) {
                          logger.throwError("Contract with a Signer cannot override from", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
                            operation: "overrides.from"
                          });
                        }
                        return [2, check.override];
                      });
                    });
                  });
                } else {
                  overrides.from = contract.signer.getAddress();
                }
              } else if (overrides.from) {
                overrides.from = resolveName(contract.provider, overrides.from);
              }
              return [4, (0, properties_1.resolveProperties)({
                args: resolveAddresses(contract.signer || contract.provider, args, fragment.inputs),
                address: contract.resolvedAddress,
                overrides: (0, properties_1.resolveProperties)(overrides) || {}
              })];
            case 1:
              resolved = _a.sent();
              data = contract.interface.encodeFunctionData(fragment, resolved.args);
              tx = {
                data,
                to: resolved.address
              };
              ro = resolved.overrides;
              if (ro.nonce != null) {
                tx.nonce = bignumber_1.BigNumber.from(ro.nonce).toNumber();
              }
              if (ro.gasLimit != null) {
                tx.gasLimit = bignumber_1.BigNumber.from(ro.gasLimit);
              }
              if (ro.gasPrice != null) {
                tx.gasPrice = bignumber_1.BigNumber.from(ro.gasPrice);
              }
              if (ro.maxFeePerGas != null) {
                tx.maxFeePerGas = bignumber_1.BigNumber.from(ro.maxFeePerGas);
              }
              if (ro.maxPriorityFeePerGas != null) {
                tx.maxPriorityFeePerGas = bignumber_1.BigNumber.from(ro.maxPriorityFeePerGas);
              }
              if (ro.from != null) {
                tx.from = ro.from;
              }
              if (ro.type != null) {
                tx.type = ro.type;
              }
              if (ro.accessList != null) {
                tx.accessList = (0, transactions_1.accessListify)(ro.accessList);
              }
              if (tx.gasLimit == null && fragment.gas != null) {
                intrinsic = 21e3;
                bytes = (0, bytes_1.arrayify)(data);
                for (i = 0; i < bytes.length; i++) {
                  intrinsic += 4;
                  if (bytes[i]) {
                    intrinsic += 64;
                  }
                }
                tx.gasLimit = bignumber_1.BigNumber.from(fragment.gas).add(intrinsic);
              }
              if (ro.value) {
                roValue = bignumber_1.BigNumber.from(ro.value);
                if (!roValue.isZero() && !fragment.payable) {
                  logger.throwError("non-payable method cannot override value", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
                    operation: "overrides.value",
                    value: overrides.value
                  });
                }
                tx.value = roValue;
              }
              if (ro.customData) {
                tx.customData = (0, properties_1.shallowCopy)(ro.customData);
              }
              delete overrides.nonce;
              delete overrides.gasLimit;
              delete overrides.gasPrice;
              delete overrides.from;
              delete overrides.value;
              delete overrides.type;
              delete overrides.accessList;
              delete overrides.maxFeePerGas;
              delete overrides.maxPriorityFeePerGas;
              delete overrides.customData;
              leftovers = Object.keys(overrides).filter(function(key) {
                return overrides[key] != null;
              });
              if (leftovers.length) {
                logger.throwError("cannot override " + leftovers.map(function(l) {
                  return JSON.stringify(l);
                }).join(","), logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
                  operation: "overrides",
                  overrides: leftovers
                });
              }
              return [2, tx];
          }
        });
      });
    }
    function buildPopulate(contract, fragment) {
      return function() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          args[_i] = arguments[_i];
        }
        return populateTransaction(contract, fragment, args);
      };
    }
    function buildEstimate(contract, fragment) {
      var signerOrProvider = contract.signer || contract.provider;
      return function() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          args[_i] = arguments[_i];
        }
        return __awaiter(this, void 0, void 0, function() {
          var tx;
          return __generator(this, function(_a) {
            switch (_a.label) {
              case 0:
                if (!signerOrProvider) {
                  logger.throwError("estimate require a provider or signer", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
                    operation: "estimateGas"
                  });
                }
                return [4, populateTransaction(contract, fragment, args)];
              case 1:
                tx = _a.sent();
                return [4, signerOrProvider.estimateGas(tx)];
              case 2:
                return [2, _a.sent()];
            }
          });
        });
      };
    }
    function addContractWait(contract, tx) {
      var wait = tx.wait.bind(tx);
      tx.wait = function(confirmations) {
        return wait(confirmations).then(function(receipt) {
          receipt.events = receipt.logs.map(function(log) {
            var event = (0, properties_1.deepCopy)(log);
            var parsed = null;
            try {
              parsed = contract.interface.parseLog(log);
            } catch (e) {
            }
            if (parsed) {
              event.args = parsed.args;
              event.decode = function(data, topics) {
                return contract.interface.decodeEventLog(parsed.eventFragment, data, topics);
              };
              event.event = parsed.name;
              event.eventSignature = parsed.signature;
            }
            event.removeListener = function() {
              return contract.provider;
            };
            event.getBlock = function() {
              return contract.provider.getBlock(receipt.blockHash);
            };
            event.getTransaction = function() {
              return contract.provider.getTransaction(receipt.transactionHash);
            };
            event.getTransactionReceipt = function() {
              return Promise.resolve(receipt);
            };
            return event;
          });
          return receipt;
        });
      };
    }
    function buildCall(contract, fragment, collapseSimple) {
      var signerOrProvider = contract.signer || contract.provider;
      return function() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          args[_i] = arguments[_i];
        }
        return __awaiter(this, void 0, void 0, function() {
          var blockTag, overrides, tx, result, value;
          return __generator(this, function(_a) {
            switch (_a.label) {
              case 0:
                blockTag = void 0;
                if (!(args.length === fragment.inputs.length + 1 && typeof args[args.length - 1] === "object")) return [3, 3];
                overrides = (0, properties_1.shallowCopy)(args.pop());
                if (!(overrides.blockTag != null)) return [3, 2];
                return [4, overrides.blockTag];
              case 1:
                blockTag = _a.sent();
                _a.label = 2;
              case 2:
                delete overrides.blockTag;
                args.push(overrides);
                _a.label = 3;
              case 3:
                if (!(contract.deployTransaction != null)) return [3, 5];
                return [4, contract._deployed(blockTag)];
              case 4:
                _a.sent();
                _a.label = 5;
              case 5:
                return [4, populateTransaction(contract, fragment, args)];
              case 6:
                tx = _a.sent();
                return [4, signerOrProvider.call(tx, blockTag)];
              case 7:
                result = _a.sent();
                try {
                  value = contract.interface.decodeFunctionResult(fragment, result);
                  if (collapseSimple && fragment.outputs.length === 1) {
                    value = value[0];
                  }
                  return [2, value];
                } catch (error) {
                  if (error.code === logger_1.Logger.errors.CALL_EXCEPTION) {
                    error.address = contract.address;
                    error.args = args;
                    error.transaction = tx;
                  }
                  throw error;
                }
                return [
                  2
                  /*return*/
                ];
            }
          });
        });
      };
    }
    function buildSend(contract, fragment) {
      return function() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          args[_i] = arguments[_i];
        }
        return __awaiter(this, void 0, void 0, function() {
          var txRequest, tx;
          return __generator(this, function(_a) {
            switch (_a.label) {
              case 0:
                if (!contract.signer) {
                  logger.throwError("sending a transaction requires a signer", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
                    operation: "sendTransaction"
                  });
                }
                if (!(contract.deployTransaction != null)) return [3, 2];
                return [4, contract._deployed()];
              case 1:
                _a.sent();
                _a.label = 2;
              case 2:
                return [4, populateTransaction(contract, fragment, args)];
              case 3:
                txRequest = _a.sent();
                return [4, contract.signer.sendTransaction(txRequest)];
              case 4:
                tx = _a.sent();
                addContractWait(contract, tx);
                return [2, tx];
            }
          });
        });
      };
    }
    function buildDefault(contract, fragment, collapseSimple) {
      if (fragment.constant) {
        return buildCall(contract, fragment, collapseSimple);
      }
      return buildSend(contract, fragment);
    }
    function getEventTag(filter) {
      if (filter.address && (filter.topics == null || filter.topics.length === 0)) {
        return "*";
      }
      return (filter.address || "*") + "@" + (filter.topics ? filter.topics.map(function(topic) {
        if (Array.isArray(topic)) {
          return topic.join("|");
        }
        return topic;
      }).join(":") : "");
    }
    var RunningEvent = (
      /** @class */
      function() {
        function RunningEvent2(tag, filter) {
          (0, properties_1.defineReadOnly)(this, "tag", tag);
          (0, properties_1.defineReadOnly)(this, "filter", filter);
          this._listeners = [];
        }
        RunningEvent2.prototype.addListener = function(listener, once) {
          this._listeners.push({ listener, once });
        };
        RunningEvent2.prototype.removeListener = function(listener) {
          var done = false;
          this._listeners = this._listeners.filter(function(item) {
            if (done || item.listener !== listener) {
              return true;
            }
            done = true;
            return false;
          });
        };
        RunningEvent2.prototype.removeAllListeners = function() {
          this._listeners = [];
        };
        RunningEvent2.prototype.listeners = function() {
          return this._listeners.map(function(i) {
            return i.listener;
          });
        };
        RunningEvent2.prototype.listenerCount = function() {
          return this._listeners.length;
        };
        RunningEvent2.prototype.run = function(args) {
          var _this = this;
          var listenerCount = this.listenerCount();
          this._listeners = this._listeners.filter(function(item) {
            var argsCopy = args.slice();
            setTimeout(function() {
              item.listener.apply(_this, argsCopy);
            }, 0);
            return !item.once;
          });
          return listenerCount;
        };
        RunningEvent2.prototype.prepareEvent = function(event) {
        };
        RunningEvent2.prototype.getEmit = function(event) {
          return [event];
        };
        return RunningEvent2;
      }()
    );
    var ErrorRunningEvent = (
      /** @class */
      function(_super) {
        __extends(ErrorRunningEvent2, _super);
        function ErrorRunningEvent2() {
          return _super.call(this, "error", null) || this;
        }
        return ErrorRunningEvent2;
      }(RunningEvent)
    );
    var FragmentRunningEvent = (
      /** @class */
      function(_super) {
        __extends(FragmentRunningEvent2, _super);
        function FragmentRunningEvent2(address, contractInterface, fragment, topics) {
          var _this = this;
          var filter = {
            address
          };
          var topic = contractInterface.getEventTopic(fragment);
          if (topics) {
            if (topic !== topics[0]) {
              logger.throwArgumentError("topic mismatch", "topics", topics);
            }
            filter.topics = topics.slice();
          } else {
            filter.topics = [topic];
          }
          _this = _super.call(this, getEventTag(filter), filter) || this;
          (0, properties_1.defineReadOnly)(_this, "address", address);
          (0, properties_1.defineReadOnly)(_this, "interface", contractInterface);
          (0, properties_1.defineReadOnly)(_this, "fragment", fragment);
          return _this;
        }
        FragmentRunningEvent2.prototype.prepareEvent = function(event) {
          var _this = this;
          _super.prototype.prepareEvent.call(this, event);
          event.event = this.fragment.name;
          event.eventSignature = this.fragment.format();
          event.decode = function(data, topics) {
            return _this.interface.decodeEventLog(_this.fragment, data, topics);
          };
          try {
            event.args = this.interface.decodeEventLog(this.fragment, event.data, event.topics);
          } catch (error) {
            event.args = null;
            event.decodeError = error;
          }
        };
        FragmentRunningEvent2.prototype.getEmit = function(event) {
          var errors = (0, abi_1.checkResultErrors)(event.args);
          if (errors.length) {
            throw errors[0].error;
          }
          var args = (event.args || []).slice();
          args.push(event);
          return args;
        };
        return FragmentRunningEvent2;
      }(RunningEvent)
    );
    var WildcardRunningEvent = (
      /** @class */
      function(_super) {
        __extends(WildcardRunningEvent2, _super);
        function WildcardRunningEvent2(address, contractInterface) {
          var _this = _super.call(this, "*", { address }) || this;
          (0, properties_1.defineReadOnly)(_this, "address", address);
          (0, properties_1.defineReadOnly)(_this, "interface", contractInterface);
          return _this;
        }
        WildcardRunningEvent2.prototype.prepareEvent = function(event) {
          var _this = this;
          _super.prototype.prepareEvent.call(this, event);
          try {
            var parsed_1 = this.interface.parseLog(event);
            event.event = parsed_1.name;
            event.eventSignature = parsed_1.signature;
            event.decode = function(data, topics) {
              return _this.interface.decodeEventLog(parsed_1.eventFragment, data, topics);
            };
            event.args = parsed_1.args;
          } catch (error) {
          }
        };
        return WildcardRunningEvent2;
      }(RunningEvent)
    );
    var BaseContract = (
      /** @class */
      function() {
        function BaseContract2(addressOrName, contractInterface, signerOrProvider) {
          var _newTarget = this.constructor;
          var _this = this;
          logger.checkNew(_newTarget, Contract);
          (0, properties_1.defineReadOnly)(this, "interface", (0, properties_1.getStatic)(_newTarget, "getInterface")(contractInterface));
          if (signerOrProvider == null) {
            (0, properties_1.defineReadOnly)(this, "provider", null);
            (0, properties_1.defineReadOnly)(this, "signer", null);
          } else if (abstract_signer_1.Signer.isSigner(signerOrProvider)) {
            (0, properties_1.defineReadOnly)(this, "provider", signerOrProvider.provider || null);
            (0, properties_1.defineReadOnly)(this, "signer", signerOrProvider);
          } else if (abstract_provider_1.Provider.isProvider(signerOrProvider)) {
            (0, properties_1.defineReadOnly)(this, "provider", signerOrProvider);
            (0, properties_1.defineReadOnly)(this, "signer", null);
          } else {
            logger.throwArgumentError("invalid signer or provider", "signerOrProvider", signerOrProvider);
          }
          (0, properties_1.defineReadOnly)(this, "callStatic", {});
          (0, properties_1.defineReadOnly)(this, "estimateGas", {});
          (0, properties_1.defineReadOnly)(this, "functions", {});
          (0, properties_1.defineReadOnly)(this, "populateTransaction", {});
          (0, properties_1.defineReadOnly)(this, "filters", {});
          {
            var uniqueFilters_1 = {};
            Object.keys(this.interface.events).forEach(function(eventSignature) {
              var event = _this.interface.events[eventSignature];
              (0, properties_1.defineReadOnly)(_this.filters, eventSignature, function() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                  args[_i] = arguments[_i];
                }
                return {
                  address: _this.address,
                  topics: _this.interface.encodeFilterTopics(event, args)
                };
              });
              if (!uniqueFilters_1[event.name]) {
                uniqueFilters_1[event.name] = [];
              }
              uniqueFilters_1[event.name].push(eventSignature);
            });
            Object.keys(uniqueFilters_1).forEach(function(name2) {
              var filters = uniqueFilters_1[name2];
              if (filters.length === 1) {
                (0, properties_1.defineReadOnly)(_this.filters, name2, _this.filters[filters[0]]);
              } else {
                logger.warn("Duplicate definition of " + name2 + " (" + filters.join(", ") + ")");
              }
            });
          }
          (0, properties_1.defineReadOnly)(this, "_runningEvents", {});
          (0, properties_1.defineReadOnly)(this, "_wrappedEmits", {});
          if (addressOrName == null) {
            logger.throwArgumentError("invalid contract address or ENS name", "addressOrName", addressOrName);
          }
          (0, properties_1.defineReadOnly)(this, "address", addressOrName);
          if (this.provider) {
            (0, properties_1.defineReadOnly)(this, "resolvedAddress", resolveName(this.provider, addressOrName));
          } else {
            try {
              (0, properties_1.defineReadOnly)(this, "resolvedAddress", Promise.resolve((0, address_1.getAddress)(addressOrName)));
            } catch (error) {
              logger.throwError("provider is required to use ENS name as contract address", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
                operation: "new Contract"
              });
            }
          }
          var uniqueNames = {};
          var uniqueSignatures = {};
          Object.keys(this.interface.functions).forEach(function(signature) {
            var fragment = _this.interface.functions[signature];
            if (uniqueSignatures[signature]) {
              logger.warn("Duplicate ABI entry for " + JSON.stringify(signature));
              return;
            }
            uniqueSignatures[signature] = true;
            {
              var name_1 = fragment.name;
              if (!uniqueNames["%" + name_1]) {
                uniqueNames["%" + name_1] = [];
              }
              uniqueNames["%" + name_1].push(signature);
            }
            if (_this[signature] == null) {
              (0, properties_1.defineReadOnly)(_this, signature, buildDefault(_this, fragment, true));
            }
            if (_this.functions[signature] == null) {
              (0, properties_1.defineReadOnly)(_this.functions, signature, buildDefault(_this, fragment, false));
            }
            if (_this.callStatic[signature] == null) {
              (0, properties_1.defineReadOnly)(_this.callStatic, signature, buildCall(_this, fragment, true));
            }
            if (_this.populateTransaction[signature] == null) {
              (0, properties_1.defineReadOnly)(_this.populateTransaction, signature, buildPopulate(_this, fragment));
            }
            if (_this.estimateGas[signature] == null) {
              (0, properties_1.defineReadOnly)(_this.estimateGas, signature, buildEstimate(_this, fragment));
            }
          });
          Object.keys(uniqueNames).forEach(function(name2) {
            var signatures = uniqueNames[name2];
            if (signatures.length > 1) {
              return;
            }
            name2 = name2.substring(1);
            var signature = signatures[0];
            try {
              if (_this[name2] == null) {
                (0, properties_1.defineReadOnly)(_this, name2, _this[signature]);
              }
            } catch (e) {
            }
            if (_this.functions[name2] == null) {
              (0, properties_1.defineReadOnly)(_this.functions, name2, _this.functions[signature]);
            }
            if (_this.callStatic[name2] == null) {
              (0, properties_1.defineReadOnly)(_this.callStatic, name2, _this.callStatic[signature]);
            }
            if (_this.populateTransaction[name2] == null) {
              (0, properties_1.defineReadOnly)(_this.populateTransaction, name2, _this.populateTransaction[signature]);
            }
            if (_this.estimateGas[name2] == null) {
              (0, properties_1.defineReadOnly)(_this.estimateGas, name2, _this.estimateGas[signature]);
            }
          });
        }
        BaseContract2.getContractAddress = function(transaction) {
          return (0, address_1.getContractAddress)(transaction);
        };
        BaseContract2.getInterface = function(contractInterface) {
          if (abi_1.Interface.isInterface(contractInterface)) {
            return contractInterface;
          }
          return new abi_1.Interface(contractInterface);
        };
        BaseContract2.prototype.deployed = function() {
          return this._deployed();
        };
        BaseContract2.prototype._deployed = function(blockTag) {
          var _this = this;
          if (!this._deployedPromise) {
            if (this.deployTransaction) {
              this._deployedPromise = this.deployTransaction.wait().then(function() {
                return _this;
              });
            } else {
              this._deployedPromise = this.provider.getCode(this.address, blockTag).then(function(code) {
                if (code === "0x") {
                  logger.throwError("contract not deployed", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
                    contractAddress: _this.address,
                    operation: "getDeployed"
                  });
                }
                return _this;
              });
            }
          }
          return this._deployedPromise;
        };
        BaseContract2.prototype.fallback = function(overrides) {
          var _this = this;
          if (!this.signer) {
            logger.throwError("sending a transactions require a signer", logger_1.Logger.errors.UNSUPPORTED_OPERATION, { operation: "sendTransaction(fallback)" });
          }
          var tx = (0, properties_1.shallowCopy)(overrides || {});
          ["from", "to"].forEach(function(key) {
            if (tx[key] == null) {
              return;
            }
            logger.throwError("cannot override " + key, logger_1.Logger.errors.UNSUPPORTED_OPERATION, { operation: key });
          });
          tx.to = this.resolvedAddress;
          return this.deployed().then(function() {
            return _this.signer.sendTransaction(tx);
          });
        };
        BaseContract2.prototype.connect = function(signerOrProvider) {
          if (typeof signerOrProvider === "string") {
            signerOrProvider = new abstract_signer_1.VoidSigner(signerOrProvider, this.provider);
          }
          var contract = new this.constructor(this.address, this.interface, signerOrProvider);
          if (this.deployTransaction) {
            (0, properties_1.defineReadOnly)(contract, "deployTransaction", this.deployTransaction);
          }
          return contract;
        };
        BaseContract2.prototype.attach = function(addressOrName) {
          return new this.constructor(addressOrName, this.interface, this.signer || this.provider);
        };
        BaseContract2.isIndexed = function(value) {
          return abi_1.Indexed.isIndexed(value);
        };
        BaseContract2.prototype._normalizeRunningEvent = function(runningEvent) {
          if (this._runningEvents[runningEvent.tag]) {
            return this._runningEvents[runningEvent.tag];
          }
          return runningEvent;
        };
        BaseContract2.prototype._getRunningEvent = function(eventName) {
          if (typeof eventName === "string") {
            if (eventName === "error") {
              return this._normalizeRunningEvent(new ErrorRunningEvent());
            }
            if (eventName === "event") {
              return this._normalizeRunningEvent(new RunningEvent("event", null));
            }
            if (eventName === "*") {
              return this._normalizeRunningEvent(new WildcardRunningEvent(this.address, this.interface));
            }
            var fragment = this.interface.getEvent(eventName);
            return this._normalizeRunningEvent(new FragmentRunningEvent(this.address, this.interface, fragment));
          }
          if (eventName.topics && eventName.topics.length > 0) {
            try {
              var topic = eventName.topics[0];
              if (typeof topic !== "string") {
                throw new Error("invalid topic");
              }
              var fragment = this.interface.getEvent(topic);
              return this._normalizeRunningEvent(new FragmentRunningEvent(this.address, this.interface, fragment, eventName.topics));
            } catch (error) {
            }
            var filter = {
              address: this.address,
              topics: eventName.topics
            };
            return this._normalizeRunningEvent(new RunningEvent(getEventTag(filter), filter));
          }
          return this._normalizeRunningEvent(new WildcardRunningEvent(this.address, this.interface));
        };
        BaseContract2.prototype._checkRunningEvents = function(runningEvent) {
          if (runningEvent.listenerCount() === 0) {
            delete this._runningEvents[runningEvent.tag];
            var emit = this._wrappedEmits[runningEvent.tag];
            if (emit && runningEvent.filter) {
              this.provider.off(runningEvent.filter, emit);
              delete this._wrappedEmits[runningEvent.tag];
            }
          }
        };
        BaseContract2.prototype._wrapEvent = function(runningEvent, log, listener) {
          var _this = this;
          var event = (0, properties_1.deepCopy)(log);
          event.removeListener = function() {
            if (!listener) {
              return;
            }
            runningEvent.removeListener(listener);
            _this._checkRunningEvents(runningEvent);
          };
          event.getBlock = function() {
            return _this.provider.getBlock(log.blockHash);
          };
          event.getTransaction = function() {
            return _this.provider.getTransaction(log.transactionHash);
          };
          event.getTransactionReceipt = function() {
            return _this.provider.getTransactionReceipt(log.transactionHash);
          };
          runningEvent.prepareEvent(event);
          return event;
        };
        BaseContract2.prototype._addEventListener = function(runningEvent, listener, once) {
          var _this = this;
          if (!this.provider) {
            logger.throwError("events require a provider or a signer with a provider", logger_1.Logger.errors.UNSUPPORTED_OPERATION, { operation: "once" });
          }
          runningEvent.addListener(listener, once);
          this._runningEvents[runningEvent.tag] = runningEvent;
          if (!this._wrappedEmits[runningEvent.tag]) {
            var wrappedEmit = function(log) {
              var event = _this._wrapEvent(runningEvent, log, listener);
              if (event.decodeError == null) {
                try {
                  var args = runningEvent.getEmit(event);
                  _this.emit.apply(_this, __spreadArray([runningEvent.filter], args, false));
                } catch (error) {
                  event.decodeError = error.error;
                }
              }
              if (runningEvent.filter != null) {
                _this.emit("event", event);
              }
              if (event.decodeError != null) {
                _this.emit("error", event.decodeError, event);
              }
            };
            this._wrappedEmits[runningEvent.tag] = wrappedEmit;
            if (runningEvent.filter != null) {
              this.provider.on(runningEvent.filter, wrappedEmit);
            }
          }
        };
        BaseContract2.prototype.queryFilter = function(event, fromBlockOrBlockhash, toBlock) {
          var _this = this;
          var runningEvent = this._getRunningEvent(event);
          var filter = (0, properties_1.shallowCopy)(runningEvent.filter);
          if (typeof fromBlockOrBlockhash === "string" && (0, bytes_1.isHexString)(fromBlockOrBlockhash, 32)) {
            if (toBlock != null) {
              logger.throwArgumentError("cannot specify toBlock with blockhash", "toBlock", toBlock);
            }
            filter.blockHash = fromBlockOrBlockhash;
          } else {
            filter.fromBlock = fromBlockOrBlockhash != null ? fromBlockOrBlockhash : 0;
            filter.toBlock = toBlock != null ? toBlock : "latest";
          }
          return this.provider.getLogs(filter).then(function(logs) {
            return logs.map(function(log) {
              return _this._wrapEvent(runningEvent, log, null);
            });
          });
        };
        BaseContract2.prototype.on = function(event, listener) {
          this._addEventListener(this._getRunningEvent(event), listener, false);
          return this;
        };
        BaseContract2.prototype.once = function(event, listener) {
          this._addEventListener(this._getRunningEvent(event), listener, true);
          return this;
        };
        BaseContract2.prototype.emit = function(eventName) {
          var args = [];
          for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
          }
          if (!this.provider) {
            return false;
          }
          var runningEvent = this._getRunningEvent(eventName);
          var result = runningEvent.run(args) > 0;
          this._checkRunningEvents(runningEvent);
          return result;
        };
        BaseContract2.prototype.listenerCount = function(eventName) {
          var _this = this;
          if (!this.provider) {
            return 0;
          }
          if (eventName == null) {
            return Object.keys(this._runningEvents).reduce(function(accum, key) {
              return accum + _this._runningEvents[key].listenerCount();
            }, 0);
          }
          return this._getRunningEvent(eventName).listenerCount();
        };
        BaseContract2.prototype.listeners = function(eventName) {
          if (!this.provider) {
            return [];
          }
          if (eventName == null) {
            var result_1 = [];
            for (var tag in this._runningEvents) {
              this._runningEvents[tag].listeners().forEach(function(listener) {
                result_1.push(listener);
              });
            }
            return result_1;
          }
          return this._getRunningEvent(eventName).listeners();
        };
        BaseContract2.prototype.removeAllListeners = function(eventName) {
          if (!this.provider) {
            return this;
          }
          if (eventName == null) {
            for (var tag in this._runningEvents) {
              var runningEvent_1 = this._runningEvents[tag];
              runningEvent_1.removeAllListeners();
              this._checkRunningEvents(runningEvent_1);
            }
            return this;
          }
          var runningEvent = this._getRunningEvent(eventName);
          runningEvent.removeAllListeners();
          this._checkRunningEvents(runningEvent);
          return this;
        };
        BaseContract2.prototype.off = function(eventName, listener) {
          if (!this.provider) {
            return this;
          }
          var runningEvent = this._getRunningEvent(eventName);
          runningEvent.removeListener(listener);
          this._checkRunningEvents(runningEvent);
          return this;
        };
        BaseContract2.prototype.removeListener = function(eventName, listener) {
          return this.off(eventName, listener);
        };
        return BaseContract2;
      }()
    );
    exports2.BaseContract = BaseContract;
    var Contract = (
      /** @class */
      function(_super) {
        __extends(Contract2, _super);
        function Contract2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        return Contract2;
      }(BaseContract)
    );
    exports2.Contract = Contract;
    var ContractFactory = (
      /** @class */
      function() {
        function ContractFactory2(contractInterface, bytecode, signer) {
          var _newTarget = this.constructor;
          var bytecodeHex = null;
          if (typeof bytecode === "string") {
            bytecodeHex = bytecode;
          } else if ((0, bytes_1.isBytes)(bytecode)) {
            bytecodeHex = (0, bytes_1.hexlify)(bytecode);
          } else if (bytecode && typeof bytecode.object === "string") {
            bytecodeHex = bytecode.object;
          } else {
            bytecodeHex = "!";
          }
          if (bytecodeHex.substring(0, 2) !== "0x") {
            bytecodeHex = "0x" + bytecodeHex;
          }
          if (!(0, bytes_1.isHexString)(bytecodeHex) || bytecodeHex.length % 2) {
            logger.throwArgumentError("invalid bytecode", "bytecode", bytecode);
          }
          if (signer && !abstract_signer_1.Signer.isSigner(signer)) {
            logger.throwArgumentError("invalid signer", "signer", signer);
          }
          (0, properties_1.defineReadOnly)(this, "bytecode", bytecodeHex);
          (0, properties_1.defineReadOnly)(this, "interface", (0, properties_1.getStatic)(_newTarget, "getInterface")(contractInterface));
          (0, properties_1.defineReadOnly)(this, "signer", signer || null);
        }
        ContractFactory2.prototype.getDeployTransaction = function() {
          var args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
          }
          var tx = {};
          if (args.length === this.interface.deploy.inputs.length + 1 && typeof args[args.length - 1] === "object") {
            tx = (0, properties_1.shallowCopy)(args.pop());
            for (var key in tx) {
              if (!allowedTransactionKeys[key]) {
                throw new Error("unknown transaction override " + key);
              }
            }
          }
          ["data", "from", "to"].forEach(function(key2) {
            if (tx[key2] == null) {
              return;
            }
            logger.throwError("cannot override " + key2, logger_1.Logger.errors.UNSUPPORTED_OPERATION, { operation: key2 });
          });
          if (tx.value) {
            var value = bignumber_1.BigNumber.from(tx.value);
            if (!value.isZero() && !this.interface.deploy.payable) {
              logger.throwError("non-payable constructor cannot override value", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
                operation: "overrides.value",
                value: tx.value
              });
            }
          }
          logger.checkArgumentCount(args.length, this.interface.deploy.inputs.length, " in Contract constructor");
          tx.data = (0, bytes_1.hexlify)((0, bytes_1.concat)([
            this.bytecode,
            this.interface.encodeDeploy(args)
          ]));
          return tx;
        };
        ContractFactory2.prototype.deploy = function() {
          var args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
          }
          return __awaiter(this, void 0, void 0, function() {
            var overrides, params, unsignedTx, tx, address, contract;
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  overrides = {};
                  if (args.length === this.interface.deploy.inputs.length + 1) {
                    overrides = args.pop();
                  }
                  logger.checkArgumentCount(args.length, this.interface.deploy.inputs.length, " in Contract constructor");
                  return [4, resolveAddresses(this.signer, args, this.interface.deploy.inputs)];
                case 1:
                  params = _a.sent();
                  params.push(overrides);
                  unsignedTx = this.getDeployTransaction.apply(this, params);
                  return [4, this.signer.sendTransaction(unsignedTx)];
                case 2:
                  tx = _a.sent();
                  address = (0, properties_1.getStatic)(this.constructor, "getContractAddress")(tx);
                  contract = (0, properties_1.getStatic)(this.constructor, "getContract")(address, this.interface, this.signer);
                  addContractWait(contract, tx);
                  (0, properties_1.defineReadOnly)(contract, "deployTransaction", tx);
                  return [2, contract];
              }
            });
          });
        };
        ContractFactory2.prototype.attach = function(address) {
          return this.constructor.getContract(address, this.interface, this.signer);
        };
        ContractFactory2.prototype.connect = function(signer) {
          return new this.constructor(this.interface, this.bytecode, signer);
        };
        ContractFactory2.fromSolidity = function(compilerOutput, signer) {
          if (compilerOutput == null) {
            logger.throwError("missing compiler output", logger_1.Logger.errors.MISSING_ARGUMENT, { argument: "compilerOutput" });
          }
          if (typeof compilerOutput === "string") {
            compilerOutput = JSON.parse(compilerOutput);
          }
          var abi = compilerOutput.abi;
          var bytecode = null;
          if (compilerOutput.bytecode) {
            bytecode = compilerOutput.bytecode;
          } else if (compilerOutput.evm && compilerOutput.evm.bytecode) {
            bytecode = compilerOutput.evm.bytecode;
          }
          return new this(abi, bytecode, signer);
        };
        ContractFactory2.getInterface = function(contractInterface) {
          return Contract.getInterface(contractInterface);
        };
        ContractFactory2.getContractAddress = function(tx) {
          return (0, address_1.getContractAddress)(tx);
        };
        ContractFactory2.getContract = function(address, contractInterface, signer) {
          return new Contract(address, contractInterface, signer);
        };
        return ContractFactory2;
      }()
    );
    exports2.ContractFactory = ContractFactory;
  }
});

// node_modules/@ethersproject/basex/lib/index.js
var require_lib17 = __commonJS({
  "node_modules/@ethersproject/basex/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Base58 = exports2.Base32 = exports2.BaseX = void 0;
    var bytes_1 = require_lib2();
    var properties_1 = require_lib4();
    var BaseX = (
      /** @class */
      function() {
        function BaseX2(alphabet) {
          (0, properties_1.defineReadOnly)(this, "alphabet", alphabet);
          (0, properties_1.defineReadOnly)(this, "base", alphabet.length);
          (0, properties_1.defineReadOnly)(this, "_alphabetMap", {});
          (0, properties_1.defineReadOnly)(this, "_leader", alphabet.charAt(0));
          for (var i = 0; i < alphabet.length; i++) {
            this._alphabetMap[alphabet.charAt(i)] = i;
          }
        }
        BaseX2.prototype.encode = function(value) {
          var source = (0, bytes_1.arrayify)(value);
          if (source.length === 0) {
            return "";
          }
          var digits = [0];
          for (var i = 0; i < source.length; ++i) {
            var carry = source[i];
            for (var j = 0; j < digits.length; ++j) {
              carry += digits[j] << 8;
              digits[j] = carry % this.base;
              carry = carry / this.base | 0;
            }
            while (carry > 0) {
              digits.push(carry % this.base);
              carry = carry / this.base | 0;
            }
          }
          var string = "";
          for (var k = 0; source[k] === 0 && k < source.length - 1; ++k) {
            string += this._leader;
          }
          for (var q = digits.length - 1; q >= 0; --q) {
            string += this.alphabet[digits[q]];
          }
          return string;
        };
        BaseX2.prototype.decode = function(value) {
          if (typeof value !== "string") {
            throw new TypeError("Expected String");
          }
          var bytes = [];
          if (value.length === 0) {
            return new Uint8Array(bytes);
          }
          bytes.push(0);
          for (var i = 0; i < value.length; i++) {
            var byte = this._alphabetMap[value[i]];
            if (byte === void 0) {
              throw new Error("Non-base" + this.base + " character");
            }
            var carry = byte;
            for (var j = 0; j < bytes.length; ++j) {
              carry += bytes[j] * this.base;
              bytes[j] = carry & 255;
              carry >>= 8;
            }
            while (carry > 0) {
              bytes.push(carry & 255);
              carry >>= 8;
            }
          }
          for (var k = 0; value[k] === this._leader && k < value.length - 1; ++k) {
            bytes.push(0);
          }
          return (0, bytes_1.arrayify)(new Uint8Array(bytes.reverse()));
        };
        return BaseX2;
      }()
    );
    exports2.BaseX = BaseX;
    var Base32 = new BaseX("abcdefghijklmnopqrstuvwxyz234567");
    exports2.Base32 = Base32;
    var Base58 = new BaseX("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz");
    exports2.Base58 = Base58;
  }
});

// node_modules/@ethersproject/pbkdf2/lib/pbkdf2.js
var require_pbkdf2 = __commonJS({
  "node_modules/@ethersproject/pbkdf2/lib/pbkdf2.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.pbkdf2 = void 0;
    var crypto_1 = require("crypto");
    var bytes_1 = require_lib2();
    function bufferify(value) {
      return Buffer.from((0, bytes_1.arrayify)(value));
    }
    function pbkdf2(password, salt, iterations, keylen, hashAlgorithm) {
      return (0, bytes_1.hexlify)((0, crypto_1.pbkdf2Sync)(bufferify(password), bufferify(salt), iterations, keylen, hashAlgorithm));
    }
    exports2.pbkdf2 = pbkdf2;
  }
});

// node_modules/@ethersproject/pbkdf2/lib/index.js
var require_lib18 = __commonJS({
  "node_modules/@ethersproject/pbkdf2/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.pbkdf2 = void 0;
    var pbkdf2_1 = require_pbkdf2();
    Object.defineProperty(exports2, "pbkdf2", { enumerable: true, get: function() {
      return pbkdf2_1.pbkdf2;
    } });
  }
});

// node_modules/@ethersproject/sha2/lib/types.js
var require_types = __commonJS({
  "node_modules/@ethersproject/sha2/lib/types.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SupportedAlgorithm = void 0;
    var SupportedAlgorithm;
    (function(SupportedAlgorithm2) {
      SupportedAlgorithm2["sha256"] = "sha256";
      SupportedAlgorithm2["sha512"] = "sha512";
    })(SupportedAlgorithm = exports2.SupportedAlgorithm || (exports2.SupportedAlgorithm = {}));
  }
});

// node_modules/@ethersproject/sha2/lib/_version.js
var require_version15 = __commonJS({
  "node_modules/@ethersproject/sha2/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "sha2/5.5.0";
  }
});

// node_modules/@ethersproject/sha2/lib/sha2.js
var require_sha2 = __commonJS({
  "node_modules/@ethersproject/sha2/lib/sha2.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.computeHmac = exports2.sha512 = exports2.sha256 = exports2.ripemd160 = void 0;
    var crypto_1 = require("crypto");
    var bytes_1 = require_lib2();
    var types_1 = require_types();
    var logger_1 = require_lib();
    var _version_1 = require_version15();
    var logger = new logger_1.Logger(_version_1.version);
    function ripemd160(data) {
      return "0x" + (0, crypto_1.createHash)("ripemd160").update(Buffer.from((0, bytes_1.arrayify)(data))).digest("hex");
    }
    exports2.ripemd160 = ripemd160;
    function sha256(data) {
      return "0x" + (0, crypto_1.createHash)("sha256").update(Buffer.from((0, bytes_1.arrayify)(data))).digest("hex");
    }
    exports2.sha256 = sha256;
    function sha512(data) {
      return "0x" + (0, crypto_1.createHash)("sha512").update(Buffer.from((0, bytes_1.arrayify)(data))).digest("hex");
    }
    exports2.sha512 = sha512;
    function computeHmac(algorithm, key, data) {
      if (!types_1.SupportedAlgorithm[algorithm]) {
        logger.throwError("unsupported algorithm - " + algorithm, logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
          operation: "computeHmac",
          algorithm
        });
      }
      return "0x" + (0, crypto_1.createHmac)(algorithm, Buffer.from((0, bytes_1.arrayify)(key))).update(Buffer.from((0, bytes_1.arrayify)(data))).digest("hex");
    }
    exports2.computeHmac = computeHmac;
  }
});

// node_modules/@ethersproject/sha2/lib/index.js
var require_lib19 = __commonJS({
  "node_modules/@ethersproject/sha2/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SupportedAlgorithm = exports2.sha512 = exports2.sha256 = exports2.ripemd160 = exports2.computeHmac = void 0;
    var sha2_1 = require_sha2();
    Object.defineProperty(exports2, "computeHmac", { enumerable: true, get: function() {
      return sha2_1.computeHmac;
    } });
    Object.defineProperty(exports2, "ripemd160", { enumerable: true, get: function() {
      return sha2_1.ripemd160;
    } });
    Object.defineProperty(exports2, "sha256", { enumerable: true, get: function() {
      return sha2_1.sha256;
    } });
    Object.defineProperty(exports2, "sha512", { enumerable: true, get: function() {
      return sha2_1.sha512;
    } });
    var types_1 = require_types();
    Object.defineProperty(exports2, "SupportedAlgorithm", { enumerable: true, get: function() {
      return types_1.SupportedAlgorithm;
    } });
  }
});

// node_modules/@ethersproject/wordlists/lib/_version.js
var require_version16 = __commonJS({
  "node_modules/@ethersproject/wordlists/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "wordlists/5.5.0";
  }
});

// node_modules/@ethersproject/wordlists/lib/wordlist.js
var require_wordlist = __commonJS({
  "node_modules/@ethersproject/wordlists/lib/wordlist.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Wordlist = exports2.logger = void 0;
    var exportWordlist = false;
    var hash_1 = require_lib10();
    var properties_1 = require_lib4();
    var logger_1 = require_lib();
    var _version_1 = require_version16();
    exports2.logger = new logger_1.Logger(_version_1.version);
    var Wordlist = (
      /** @class */
      function() {
        function Wordlist2(locale) {
          var _newTarget = this.constructor;
          exports2.logger.checkAbstract(_newTarget, Wordlist2);
          (0, properties_1.defineReadOnly)(this, "locale", locale);
        }
        Wordlist2.prototype.split = function(mnemonic) {
          return mnemonic.toLowerCase().split(/ +/g);
        };
        Wordlist2.prototype.join = function(words) {
          return words.join(" ");
        };
        Wordlist2.check = function(wordlist) {
          var words = [];
          for (var i = 0; i < 2048; i++) {
            var word = wordlist.getWord(i);
            if (i !== wordlist.getWordIndex(word)) {
              return "0x";
            }
            words.push(word);
          }
          return (0, hash_1.id)(words.join("\n") + "\n");
        };
        Wordlist2.register = function(lang, name2) {
          if (!name2) {
            name2 = lang.locale;
          }
          if (exportWordlist) {
            try {
              var anyGlobal = window;
              if (anyGlobal._ethers && anyGlobal._ethers.wordlists) {
                if (!anyGlobal._ethers.wordlists[name2]) {
                  (0, properties_1.defineReadOnly)(anyGlobal._ethers.wordlists, name2, lang);
                }
              }
            } catch (error) {
            }
          }
        };
        return Wordlist2;
      }()
    );
    exports2.Wordlist = Wordlist;
  }
});

// node_modules/@ethersproject/wordlists/lib/lang-cz.js
var require_lang_cz = __commonJS({
  "node_modules/@ethersproject/wordlists/lib/lang-cz.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.langCz = void 0;
    var wordlist_1 = require_wordlist();
    var words = "AbdikaceAbecedaAdresaAgreseAkceAktovkaAlejAlkoholAmputaceAnanasAndulkaAnekdotaAnketaAntikaAnulovatArchaAroganceAsfaltAsistentAspiraceAstmaAstronomAtlasAtletikaAtolAutobusAzylBabkaBachorBacilBaculkaBadatelBagetaBagrBahnoBakterieBaladaBaletkaBalkonBalonekBalvanBalzaBambusBankomatBarbarBaretBarmanBarokoBarvaBaterkaBatohBavlnaBazalkaBazilikaBazukaBednaBeranBesedaBestieBetonBezinkaBezmocBeztakBicyklBidloBiftekBikinyBilanceBiografBiologBitvaBizonBlahobytBlatouchBlechaBleduleBleskBlikatBliznaBlokovatBlouditBludBobekBobrBodlinaBodnoutBohatostBojkotBojovatBokorysBolestBorecBoroviceBotaBoubelBouchatBoudaBouleBouratBoxerBradavkaBramboraBrankaBratrBreptaBriketaBrkoBrlohBronzBroskevBrunetkaBrusinkaBrzdaBrzyBublinaBubnovatBuchtaBuditelBudkaBudovaBufetBujarostBukviceBuldokBulvaBundaBunkrBurzaButikBuvolBuzolaBydletBylinaBytovkaBzukotCapartCarevnaCedrCeduleCejchCejnCelaCelerCelkemCelniceCeninaCennostCenovkaCentrumCenzorCestopisCetkaChalupaChapadloCharitaChataChechtatChemieChichotChirurgChladChlebaChlubitChmelChmuraChobotChocholChodbaCholeraChomoutChopitChorobaChovChrapotChrlitChrtChrupChtivostChudinaChutnatChvatChvilkaChvostChybaChystatChytitCibuleCigaretaCihelnaCihlaCinkotCirkusCisternaCitaceCitrusCizinecCizostClonaCokolivCouvatCtitelCtnostCudnostCuketaCukrCupotCvaknoutCvalCvikCvrkotCyklistaDalekoDarebaDatelDatumDceraDebataDechovkaDecibelDeficitDeflaceDeklDekretDemokratDepreseDerbyDeskaDetektivDikobrazDiktovatDiodaDiplomDiskDisplejDivadloDivochDlahaDlouhoDluhopisDnesDobroDobytekDocentDochutitDodnesDohledDohodaDohraDojemDojniceDokladDokolaDoktorDokumentDolarDolevaDolinaDomaDominantDomluvitDomovDonutitDopadDopisDoplnitDoposudDoprovodDopustitDorazitDorostDortDosahDoslovDostatekDosudDosytaDotazDotekDotknoutDoufatDoutnatDovozceDozaduDoznatDozorceDrahotaDrakDramatikDravecDrazeDrdolDrobnostDrogerieDrozdDrsnostDrtitDrzostDubenDuchovnoDudekDuhaDuhovkaDusitDusnoDutostDvojiceDvorecDynamitEkologEkonomieElektronElipsaEmailEmiseEmoceEmpatieEpizodaEpochaEpopejEposEsejEsenceEskortaEskymoEtiketaEuforieEvoluceExekuceExkurzeExpediceExplozeExportExtraktFackaFajfkaFakultaFanatikFantazieFarmacieFavoritFazoleFederaceFejetonFenkaFialkaFigurantFilozofFiltrFinanceFintaFixaceFjordFlanelFlirtFlotilaFondFosforFotbalFotkaFotonFrakceFreskaFrontaFukarFunkceFyzikaGalejeGarantGenetikaGeologGilotinaGlazuraGlejtGolemGolfistaGotikaGrafGramofonGranuleGrepGrilGrogGroteskaGumaHadiceHadrHalaHalenkaHanbaHanopisHarfaHarpunaHavranHebkostHejkalHejnoHejtmanHektarHelmaHematomHerecHernaHesloHezkyHistorikHladovkaHlasivkyHlavaHledatHlenHlodavecHlohHloupostHltatHlubinaHluchotaHmatHmotaHmyzHnisHnojivoHnoutHoblinaHobojHochHodinyHodlatHodnotaHodovatHojnostHokejHolinkaHolkaHolubHomoleHonitbaHonoraceHoralHordaHorizontHorkoHorlivecHormonHorninaHoroskopHorstvoHospodaHostinaHotovostHoubaHoufHoupatHouskaHovorHradbaHraniceHravostHrazdaHrbolekHrdinaHrdloHrdostHrnekHrobkaHromadaHrotHroudaHrozenHrstkaHrubostHryzatHubenostHubnoutHudbaHukotHumrHusitaHustotaHvozdHybnostHydrantHygienaHymnaHysterikIdylkaIhnedIkonaIluzeImunitaInfekceInflaceInkasoInovaceInspekceInternetInvalidaInvestorInzerceIronieJablkoJachtaJahodaJakmileJakostJalovecJantarJarmarkJaroJasanJasnoJatkaJavorJazykJedinecJedleJednatelJehlanJekotJelenJelitoJemnostJenomJepiceJeseterJevitJezdecJezeroJinakJindyJinochJiskraJistotaJitrniceJizvaJmenovatJogurtJurtaKabaretKabelKabinetKachnaKadetKadidloKahanKajakKajutaKakaoKaktusKalamitaKalhotyKalibrKalnostKameraKamkolivKamnaKanibalKanoeKantorKapalinaKapelaKapitolaKapkaKapleKapotaKaprKapustaKapybaraKaramelKarotkaKartonKasaKatalogKatedraKauceKauzaKavalecKazajkaKazetaKazivostKdekolivKdesiKedlubenKempKeramikaKinoKlacekKladivoKlamKlapotKlasikaKlaunKlecKlenbaKlepatKlesnoutKlidKlimaKlisnaKloboukKlokanKlopaKloubKlubovnaKlusatKluzkostKmenKmitatKmotrKnihaKnotKoaliceKoberecKobkaKoblihaKobylaKocourKohoutKojenecKokosKoktejlKolapsKoledaKolizeKoloKomandoKometaKomikKomnataKomoraKompasKomunitaKonatKonceptKondiceKonecKonfeseKongresKoninaKonkursKontaktKonzervaKopanecKopieKopnoutKoprovkaKorbelKorektorKormidloKoroptevKorpusKorunaKorytoKorzetKosatecKostkaKotelKotletaKotoulKoukatKoupelnaKousekKouzloKovbojKozaKozorohKrabiceKrachKrajinaKralovatKrasopisKravataKreditKrejcarKresbaKrevetaKriketKritikKrizeKrkavecKrmelecKrmivoKrocanKrokKronikaKropitKroupaKrovkaKrtekKruhadloKrupiceKrutostKrvinkaKrychleKryptaKrystalKrytKudlankaKufrKujnostKuklaKulajdaKulichKulkaKulometKulturaKunaKupodivuKurtKurzorKutilKvalitaKvasinkaKvestorKynologKyselinaKytaraKyticeKytkaKytovecKyvadloLabradorLachtanLadnostLaikLakomecLamelaLampaLanovkaLasiceLasoLasturaLatinkaLavinaLebkaLeckdyLedenLedniceLedovkaLedvinaLegendaLegieLegraceLehceLehkostLehnoutLektvarLenochodLentilkaLepenkaLepidloLetadloLetecLetmoLetokruhLevhartLevitaceLevobokLibraLichotkaLidojedLidskostLihovinaLijavecLilekLimetkaLinieLinkaLinoleumListopadLitinaLitovatLobistaLodivodLogikaLogopedLokalitaLoketLomcovatLopataLopuchLordLososLotrLoudalLouhLoukaLouskatLovecLstivostLucernaLuciferLumpLuskLustraceLviceLyraLyrikaLysinaMadamMadloMagistrMahagonMajetekMajitelMajoritaMakakMakoviceMakrelaMalbaMalinaMalovatMalviceMaminkaMandleMankoMarnostMasakrMaskotMasopustMaticeMatrikaMaturitaMazanecMazivoMazlitMazurkaMdlobaMechanikMeditaceMedovinaMelasaMelounMentolkaMetlaMetodaMetrMezeraMigraceMihnoutMihuleMikinaMikrofonMilenecMilimetrMilostMimikaMincovnaMinibarMinometMinulostMiskaMistrMixovatMladostMlhaMlhovinaMlokMlsatMluvitMnichMnohemMobilMocnostModelkaModlitbaMohylaMokroMolekulaMomentkaMonarchaMonoklMonstrumMontovatMonzunMosazMoskytMostMotivaceMotorkaMotykaMouchaMoudrostMozaikaMozekMozolMramorMravenecMrkevMrtvolaMrzetMrzutostMstitelMudrcMuflonMulatMumieMuniceMusetMutaceMuzeumMuzikantMyslivecMzdaNabouratNachytatNadaceNadbytekNadhozNadobroNadpisNahlasNahnatNahodileNahraditNaivitaNajednouNajistoNajmoutNaklonitNakonecNakrmitNalevoNamazatNamluvitNanometrNaokoNaopakNaostroNapadatNapevnoNaplnitNapnoutNaposledNaprostoNaroditNarubyNarychloNasaditNasekatNaslepoNastatNatolikNavenekNavrchNavzdoryNazvatNebeNechatNeckyNedalekoNedbatNeduhNegaceNehetNehodaNejenNejprveNeklidNelibostNemilostNemocNeochotaNeonkaNepokojNerostNervNesmyslNesouladNetvorNeuronNevinaNezvykleNicotaNijakNikamNikdyNiklNikterakNitroNoclehNohaviceNominaceNoraNorekNositelNosnostNouzeNovinyNovotaNozdraNudaNudleNugetNutitNutnostNutrieNymfaObalObarvitObavaObdivObecObehnatObejmoutObezitaObhajobaObilniceObjasnitObjektObklopitOblastOblekOblibaOblohaObludaObnosObohatitObojekOboutObrazecObrnaObrubaObrysObsahObsluhaObstaratObuvObvazObvinitObvodObvykleObyvatelObzorOcasOcelOcenitOchladitOchotaOchranaOcitnoutOdbojOdbytOdchodOdcizitOdebratOdeslatOdevzdatOdezvaOdhadceOdhoditOdjetOdjinudOdkazOdkoupitOdlivOdlukaOdmlkaOdolnostOdpadOdpisOdploutOdporOdpustitOdpykatOdrazkaOdsouditOdstupOdsunOdtokOdtudOdvahaOdvetaOdvolatOdvracetOdznakOfinaOfsajdOhlasOhniskoOhradaOhrozitOhryzekOkapOkeniceOklikaOknoOkouzlitOkovyOkrasaOkresOkrsekOkruhOkupantOkurkaOkusitOlejninaOlizovatOmakOmeletaOmezitOmladinaOmlouvatOmluvaOmylOnehdyOpakovatOpasekOperaceOpiceOpilostOpisovatOporaOpoziceOpravduOprotiOrbitalOrchestrOrgieOrliceOrlojOrtelOsadaOschnoutOsikaOsivoOslavaOslepitOslnitOslovitOsnovaOsobaOsolitOspalecOstenOstrahaOstudaOstychOsvojitOteplitOtiskOtopOtrhatOtrlostOtrokOtrubyOtvorOvanoutOvarOvesOvlivnitOvoceOxidOzdobaPachatelPacientPadouchPahorekPaktPalandaPalecPalivoPalubaPamfletPamlsekPanenkaPanikaPannaPanovatPanstvoPantoflePaprikaParketaParodiePartaParukaParybaPasekaPasivitaPastelkaPatentPatronaPavoukPaznehtPazourekPeckaPedagogPejsekPekloPelotonPenaltaPendrekPenzePeriskopPeroPestrostPetardaPeticePetrolejPevninaPexesoPianistaPihaPijavicePiklePiknikPilinaPilnostPilulkaPinzetaPipetaPisatelPistolePitevnaPivnicePivovarPlacentaPlakatPlamenPlanetaPlastikaPlatitPlavidloPlazPlechPlemenoPlentaPlesPletivoPlevelPlivatPlnitPlnoPlochaPlodinaPlombaPloutPlukPlynPobavitPobytPochodPocitPoctivecPodatPodcenitPodepsatPodhledPodivitPodkladPodmanitPodnikPodobaPodporaPodrazPodstataPodvodPodzimPoeziePohankaPohnutkaPohovorPohromaPohybPointaPojistkaPojmoutPokazitPoklesPokojPokrokPokutaPokynPolednePolibekPolknoutPolohaPolynomPomaluPominoutPomlkaPomocPomstaPomysletPonechatPonorkaPonurostPopadatPopelPopisekPoplachPoprositPopsatPopudPoradcePorcePorodPoruchaPoryvPosaditPosedPosilaPoskokPoslanecPosouditPospoluPostavaPosudekPosypPotahPotkanPotleskPotomekPotravaPotupaPotvoraPoukazPoutoPouzdroPovahaPovidlaPovlakPovozPovrchPovstatPovykPovzdechPozdravPozemekPoznatekPozorPozvatPracovatPrahoryPraktikaPralesPraotecPraporekPrasePravdaPrincipPrknoProbuditProcentoProdejProfeseProhraProjektProlomitPromilePronikatPropadProrokProsbaProtonProutekProvazPrskavkaPrstenPrudkostPrutPrvekPrvohoryPsanecPsovodPstruhPtactvoPubertaPuchPudlPukavecPuklinaPukrlePultPumpaPuncPupenPusaPusinkaPustinaPutovatPutykaPyramidaPyskPytelRacekRachotRadiaceRadniceRadonRaftRagbyRaketaRakovinaRamenoRampouchRandeRarachRaritaRasovnaRastrRatolestRazanceRazidloReagovatReakceReceptRedaktorReferentReflexRejnokReklamaRekordRekrutRektorReputaceRevizeRevmaRevolverRezervaRiskovatRizikoRobotikaRodokmenRohovkaRokleRokokoRomanetoRopovodRopuchaRorejsRosolRostlinaRotmistrRotopedRotundaRoubenkaRouchoRoupRouraRovinaRovniceRozborRozchodRozdatRozeznatRozhodceRozinkaRozjezdRozkazRozlohaRozmarRozpadRozruchRozsahRoztokRozumRozvodRubrikaRuchadloRukaviceRukopisRybaRybolovRychlostRydloRypadloRytinaRyzostSadistaSahatSakoSamecSamizdatSamotaSanitkaSardinkaSasankaSatelitSazbaSazeniceSborSchovatSebrankaSeceseSedadloSedimentSedloSehnatSejmoutSekeraSektaSekundaSekvojeSemenoSenoServisSesaditSeshoraSeskokSeslatSestraSesuvSesypatSetbaSetinaSetkatSetnoutSetrvatSeverSeznamShodaShrnoutSifonSilniceSirkaSirotekSirupSituaceSkafandrSkaliskoSkanzenSkautSkeptikSkicaSkladbaSkleniceSkloSkluzSkobaSkokanSkoroSkriptaSkrzSkupinaSkvostSkvrnaSlabikaSladidloSlaninaSlastSlavnostSledovatSlepecSlevaSlezinaSlibSlinaSlizniceSlonSloupekSlovoSluchSluhaSlunceSlupkaSlzaSmaragdSmetanaSmilstvoSmlouvaSmogSmradSmrkSmrtkaSmutekSmyslSnadSnahaSnobSobotaSochaSodovkaSokolSopkaSotvaSoubojSoucitSoudceSouhlasSouladSoumrakSoupravaSousedSoutokSouvisetSpalovnaSpasitelSpisSplavSpodekSpojenecSpoluSponzorSpornostSpoustaSprchaSpustitSrandaSrazSrdceSrnaSrnecSrovnatSrpenSrstSrubStaniceStarostaStatikaStavbaStehnoStezkaStodolaStolekStopaStornoStoupatStrachStresStrhnoutStromStrunaStudnaStupniceStvolStykSubjektSubtropySucharSudostSuknoSundatSunoutSurikataSurovinaSvahSvalstvoSvetrSvatbaSvazekSvisleSvitekSvobodaSvodidloSvorkaSvrabSykavkaSykotSynekSynovecSypatSypkostSyrovostSyselSytostTabletkaTabuleTahounTajemnoTajfunTajgaTajitTajnostTaktikaTamhleTamponTancovatTanecTankerTapetaTaveninaTazatelTechnikaTehdyTekutinaTelefonTemnotaTendenceTenistaTenorTeplotaTepnaTeprveTerapieTermoskaTextilTichoTiskopisTitulekTkadlecTkaninaTlapkaTleskatTlukotTlupaTmelToaletaTopinkaTopolTorzoTouhaToulecTradiceTraktorTrampTrasaTraverzaTrefitTrestTrezorTrhavinaTrhlinaTrochuTrojiceTroskaTroubaTrpceTrpitelTrpkostTrubecTruchlitTruhliceTrusTrvatTudyTuhnoutTuhostTundraTuristaTurnajTuzemskoTvarohTvorbaTvrdostTvrzTygrTykevUbohostUbozeUbratUbrousekUbrusUbytovnaUchoUctivostUdivitUhraditUjednatUjistitUjmoutUkazatelUklidnitUklonitUkotvitUkrojitUliceUlitaUlovitUmyvadloUnavitUniformaUniknoutUpadnoutUplatnitUplynoutUpoutatUpravitUranUrazitUsednoutUsilovatUsmrtitUsnadnitUsnoutUsouditUstlatUstrnoutUtahovatUtkatUtlumitUtonoutUtopenecUtrousitUvalitUvolnitUvozovkaUzdravitUzelUzeninaUzlinaUznatVagonValchaValounVanaVandalVanilkaVaranVarhanyVarovatVcelkuVchodVdovaVedroVegetaceVejceVelbloudVeletrhVelitelVelmocVelrybaVenkovVerandaVerzeVeselkaVeskrzeVesniceVespoduVestaVeterinaVeverkaVibraceVichrVideohraVidinaVidleVilaViniceVisetVitalitaVizeVizitkaVjezdVkladVkusVlajkaVlakVlasecVlevoVlhkostVlivVlnovkaVloupatVnucovatVnukVodaVodivostVodoznakVodstvoVojenskyVojnaVojskoVolantVolbaVolitVolnoVoskovkaVozidloVozovnaVpravoVrabecVracetVrahVrataVrbaVrcholekVrhatVrstvaVrtuleVsaditVstoupitVstupVtipVybavitVybratVychovatVydatVydraVyfotitVyhledatVyhnoutVyhoditVyhraditVyhubitVyjasnitVyjetVyjmoutVyklopitVykonatVylekatVymazatVymezitVymizetVymysletVynechatVynikatVynutitVypadatVyplatitVypravitVypustitVyrazitVyrovnatVyrvatVyslovitVysokoVystavitVysunoutVysypatVytasitVytesatVytratitVyvinoutVyvolatVyvrhelVyzdobitVyznatVzaduVzbuditVzchopitVzdorVzduchVzdychatVzestupVzhledemVzkazVzlykatVznikVzorekVzpouraVztahVztekXylofonZabratZabydletZachovatZadarmoZadusitZafoukatZahltitZahoditZahradaZahynoutZajatecZajetZajistitZaklepatZakoupitZalepitZamezitZamotatZamysletZanechatZanikatZaplatitZapojitZapsatZarazitZastavitZasunoutZatajitZatemnitZatknoutZaujmoutZavalitZaveletZavinitZavolatZavrtatZazvonitZbavitZbrusuZbudovatZbytekZdalekaZdarmaZdatnostZdivoZdobitZdrojZdvihZdymadloZeleninaZemanZeminaZeptatZezaduZezdolaZhatitZhltnoutZhlubokaZhotovitZhrubaZimaZimniceZjemnitZklamatZkoumatZkratkaZkumavkaZlatoZlehkaZlobaZlomZlostZlozvykZmapovatZmarZmatekZmijeZmizetZmocnitZmodratZmrzlinaZmutovatZnakZnalostZnamenatZnovuZobrazitZotavitZoubekZoufaleZploditZpomalitZpravaZprostitZprudkaZprvuZradaZranitZrcadloZrnitostZrnoZrovnaZrychlitZrzavostZtichaZtratitZubovinaZubrZvednoutZvenkuZveselaZvonZvratZvukovodZvyk";
    var wordlist = null;
    function loadWords(lang) {
      if (wordlist != null) {
        return;
      }
      wordlist = words.replace(/([A-Z])/g, " $1").toLowerCase().substring(1).split(" ");
      if (wordlist_1.Wordlist.check(lang) !== "0x25f44555f4af25b51a711136e1c7d6e50ce9f8917d39d6b1f076b2bb4d2fac1a") {
        wordlist = null;
        throw new Error("BIP39 Wordlist for en (English) FAILED");
      }
    }
    var LangCz = (
      /** @class */
      function(_super) {
        __extends(LangCz2, _super);
        function LangCz2() {
          return _super.call(this, "cz") || this;
        }
        LangCz2.prototype.getWord = function(index) {
          loadWords(this);
          return wordlist[index];
        };
        LangCz2.prototype.getWordIndex = function(word) {
          loadWords(this);
          return wordlist.indexOf(word);
        };
        return LangCz2;
      }(wordlist_1.Wordlist)
    );
    var langCz = new LangCz();
    exports2.langCz = langCz;
    wordlist_1.Wordlist.register(langCz);
  }
});

// node_modules/@ethersproject/wordlists/lib/lang-en.js
var require_lang_en = __commonJS({
  "node_modules/@ethersproject/wordlists/lib/lang-en.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.langEn = void 0;
    var wordlist_1 = require_wordlist();
    var words = "AbandonAbilityAbleAboutAboveAbsentAbsorbAbstractAbsurdAbuseAccessAccidentAccountAccuseAchieveAcidAcousticAcquireAcrossActActionActorActressActualAdaptAddAddictAddressAdjustAdmitAdultAdvanceAdviceAerobicAffairAffordAfraidAgainAgeAgentAgreeAheadAimAirAirportAisleAlarmAlbumAlcoholAlertAlienAllAlleyAllowAlmostAloneAlphaAlreadyAlsoAlterAlwaysAmateurAmazingAmongAmountAmusedAnalystAnchorAncientAngerAngleAngryAnimalAnkleAnnounceAnnualAnotherAnswerAntennaAntiqueAnxietyAnyApartApologyAppearAppleApproveAprilArchArcticAreaArenaArgueArmArmedArmorArmyAroundArrangeArrestArriveArrowArtArtefactArtistArtworkAskAspectAssaultAssetAssistAssumeAsthmaAthleteAtomAttackAttendAttitudeAttractAuctionAuditAugustAuntAuthorAutoAutumnAverageAvocadoAvoidAwakeAwareAwayAwesomeAwfulAwkwardAxisBabyBachelorBaconBadgeBagBalanceBalconyBallBambooBananaBannerBarBarelyBargainBarrelBaseBasicBasketBattleBeachBeanBeautyBecauseBecomeBeefBeforeBeginBehaveBehindBelieveBelowBeltBenchBenefitBestBetrayBetterBetweenBeyondBicycleBidBikeBindBiologyBirdBirthBitterBlackBladeBlameBlanketBlastBleakBlessBlindBloodBlossomBlouseBlueBlurBlushBoardBoatBodyBoilBombBoneBonusBookBoostBorderBoringBorrowBossBottomBounceBoxBoyBracketBrainBrandBrassBraveBreadBreezeBrickBridgeBriefBrightBringBriskBroccoliBrokenBronzeBroomBrotherBrownBrushBubbleBuddyBudgetBuffaloBuildBulbBulkBulletBundleBunkerBurdenBurgerBurstBusBusinessBusyButterBuyerBuzzCabbageCabinCableCactusCageCakeCallCalmCameraCampCanCanalCancelCandyCannonCanoeCanvasCanyonCapableCapitalCaptainCarCarbonCardCargoCarpetCarryCartCaseCashCasinoCastleCasualCatCatalogCatchCategoryCattleCaughtCauseCautionCaveCeilingCeleryCementCensusCenturyCerealCertainChairChalkChampionChangeChaosChapterChargeChaseChatCheapCheckCheeseChefCherryChestChickenChiefChildChimneyChoiceChooseChronicChuckleChunkChurnCigarCinnamonCircleCitizenCityCivilClaimClapClarifyClawClayCleanClerkCleverClickClientCliffClimbClinicClipClockClogCloseClothCloudClownClubClumpClusterClutchCoachCoastCoconutCodeCoffeeCoilCoinCollectColorColumnCombineComeComfortComicCommonCompanyConcertConductConfirmCongressConnectConsiderControlConvinceCookCoolCopperCopyCoralCoreCornCorrectCostCottonCouchCountryCoupleCourseCousinCoverCoyoteCrackCradleCraftCramCraneCrashCraterCrawlCrazyCreamCreditCreekCrewCricketCrimeCrispCriticCropCrossCrouchCrowdCrucialCruelCruiseCrumbleCrunchCrushCryCrystalCubeCultureCupCupboardCuriousCurrentCurtainCurveCushionCustomCuteCycleDadDamageDampDanceDangerDaringDashDaughterDawnDayDealDebateDebrisDecadeDecemberDecideDeclineDecorateDecreaseDeerDefenseDefineDefyDegreeDelayDeliverDemandDemiseDenialDentistDenyDepartDependDepositDepthDeputyDeriveDescribeDesertDesignDeskDespairDestroyDetailDetectDevelopDeviceDevoteDiagramDialDiamondDiaryDiceDieselDietDifferDigitalDignityDilemmaDinnerDinosaurDirectDirtDisagreeDiscoverDiseaseDishDismissDisorderDisplayDistanceDivertDivideDivorceDizzyDoctorDocumentDogDollDolphinDomainDonateDonkeyDonorDoorDoseDoubleDoveDraftDragonDramaDrasticDrawDreamDressDriftDrillDrinkDripDriveDropDrumDryDuckDumbDuneDuringDustDutchDutyDwarfDynamicEagerEagleEarlyEarnEarthEasilyEastEasyEchoEcologyEconomyEdgeEditEducateEffortEggEightEitherElbowElderElectricElegantElementElephantElevatorEliteElseEmbarkEmbodyEmbraceEmergeEmotionEmployEmpowerEmptyEnableEnactEndEndlessEndorseEnemyEnergyEnforceEngageEngineEnhanceEnjoyEnlistEnoughEnrichEnrollEnsureEnterEntireEntryEnvelopeEpisodeEqualEquipEraEraseErodeErosionErrorEruptEscapeEssayEssenceEstateEternalEthicsEvidenceEvilEvokeEvolveExactExampleExcessExchangeExciteExcludeExcuseExecuteExerciseExhaustExhibitExileExistExitExoticExpandExpectExpireExplainExposeExpressExtendExtraEyeEyebrowFabricFaceFacultyFadeFaintFaithFallFalseFameFamilyFamousFanFancyFantasyFarmFashionFatFatalFatherFatigueFaultFavoriteFeatureFebruaryFederalFeeFeedFeelFemaleFenceFestivalFetchFeverFewFiberFictionFieldFigureFileFilmFilterFinalFindFineFingerFinishFireFirmFirstFiscalFishFitFitnessFixFlagFlameFlashFlatFlavorFleeFlightFlipFloatFlockFloorFlowerFluidFlushFlyFoamFocusFogFoilFoldFollowFoodFootForceForestForgetForkFortuneForumForwardFossilFosterFoundFoxFragileFrameFrequentFreshFriendFringeFrogFrontFrostFrownFrozenFruitFuelFunFunnyFurnaceFuryFutureGadgetGainGalaxyGalleryGameGapGarageGarbageGardenGarlicGarmentGasGaspGateGatherGaugeGazeGeneralGeniusGenreGentleGenuineGestureGhostGiantGiftGiggleGingerGiraffeGirlGiveGladGlanceGlareGlassGlideGlimpseGlobeGloomGloryGloveGlowGlueGoatGoddessGoldGoodGooseGorillaGospelGossipGovernGownGrabGraceGrainGrantGrapeGrassGravityGreatGreenGridGriefGritGroceryGroupGrowGruntGuardGuessGuideGuiltGuitarGunGymHabitHairHalfHammerHamsterHandHappyHarborHardHarshHarvestHatHaveHawkHazardHeadHealthHeartHeavyHedgehogHeightHelloHelmetHelpHenHeroHiddenHighHillHintHipHireHistoryHobbyHockeyHoldHoleHolidayHollowHomeHoneyHoodHopeHornHorrorHorseHospitalHostHotelHourHoverHubHugeHumanHumbleHumorHundredHungryHuntHurdleHurryHurtHusbandHybridIceIconIdeaIdentifyIdleIgnoreIllIllegalIllnessImageImitateImmenseImmuneImpactImposeImproveImpulseInchIncludeIncomeIncreaseIndexIndicateIndoorIndustryInfantInflictInformInhaleInheritInitialInjectInjuryInmateInnerInnocentInputInquiryInsaneInsectInsideInspireInstallIntactInterestIntoInvestInviteInvolveIronIslandIsolateIssueItemIvoryJacketJaguarJarJazzJealousJeansJellyJewelJobJoinJokeJourneyJoyJudgeJuiceJumpJungleJuniorJunkJustKangarooKeenKeepKetchupKeyKickKidKidneyKindKingdomKissKitKitchenKiteKittenKiwiKneeKnifeKnockKnowLabLabelLaborLadderLadyLakeLampLanguageLaptopLargeLaterLatinLaughLaundryLavaLawLawnLawsuitLayerLazyLeaderLeafLearnLeaveLectureLeftLegLegalLegendLeisureLemonLendLengthLensLeopardLessonLetterLevelLiarLibertyLibraryLicenseLifeLiftLightLikeLimbLimitLinkLionLiquidListLittleLiveLizardLoadLoanLobsterLocalLockLogicLonelyLongLoopLotteryLoudLoungeLoveLoyalLuckyLuggageLumberLunarLunchLuxuryLyricsMachineMadMagicMagnetMaidMailMainMajorMakeMammalManManageMandateMangoMansionManualMapleMarbleMarchMarginMarineMarketMarriageMaskMassMasterMatchMaterialMathMatrixMatterMaximumMazeMeadowMeanMeasureMeatMechanicMedalMediaMelodyMeltMemberMemoryMentionMenuMercyMergeMeritMerryMeshMessageMetalMethodMiddleMidnightMilkMillionMimicMindMinimumMinorMinuteMiracleMirrorMiseryMissMistakeMixMixedMixtureMobileModelModifyMomMomentMonitorMonkeyMonsterMonthMoonMoralMoreMorningMosquitoMotherMotionMotorMountainMouseMoveMovieMuchMuffinMuleMultiplyMuscleMuseumMushroomMusicMustMutualMyselfMysteryMythNaiveNameNapkinNarrowNastyNationNatureNearNeckNeedNegativeNeglectNeitherNephewNerveNestNetNetworkNeutralNeverNewsNextNiceNightNobleNoiseNomineeNoodleNormalNorthNoseNotableNoteNothingNoticeNovelNowNuclearNumberNurseNutOakObeyObjectObligeObscureObserveObtainObviousOccurOceanOctoberOdorOffOfferOfficeOftenOilOkayOldOliveOlympicOmitOnceOneOnionOnlineOnlyOpenOperaOpinionOpposeOptionOrangeOrbitOrchardOrderOrdinaryOrganOrientOriginalOrphanOstrichOtherOutdoorOuterOutputOutsideOvalOvenOverOwnOwnerOxygenOysterOzonePactPaddlePagePairPalacePalmPandaPanelPanicPantherPaperParadeParentParkParrotPartyPassPatchPathPatientPatrolPatternPausePavePaymentPeacePeanutPearPeasantPelicanPenPenaltyPencilPeoplePepperPerfectPermitPersonPetPhonePhotoPhrasePhysicalPianoPicnicPicturePiecePigPigeonPillPilotPinkPioneerPipePistolPitchPizzaPlacePlanetPlasticPlatePlayPleasePledgePluckPlugPlungePoemPoetPointPolarPolePolicePondPonyPoolPopularPortionPositionPossiblePostPotatoPotteryPovertyPowderPowerPracticePraisePredictPreferPreparePresentPrettyPreventPricePridePrimaryPrintPriorityPrisonPrivatePrizeProblemProcessProduceProfitProgramProjectPromoteProofPropertyProsperProtectProudProvidePublicPuddingPullPulpPulsePumpkinPunchPupilPuppyPurchasePurityPurposePursePushPutPuzzlePyramidQualityQuantumQuarterQuestionQuickQuitQuizQuoteRabbitRaccoonRaceRackRadarRadioRailRainRaiseRallyRampRanchRandomRangeRapidRareRateRatherRavenRawRazorReadyRealReasonRebelRebuildRecallReceiveRecipeRecordRecycleReduceReflectReformRefuseRegionRegretRegularRejectRelaxReleaseReliefRelyRemainRememberRemindRemoveRenderRenewRentReopenRepairRepeatReplaceReportRequireRescueResembleResistResourceResponseResultRetireRetreatReturnReunionRevealReviewRewardRhythmRibRibbonRiceRichRideRidgeRifleRightRigidRingRiotRippleRiskRitualRivalRiverRoadRoastRobotRobustRocketRomanceRoofRookieRoomRoseRotateRoughRoundRouteRoyalRubberRudeRugRuleRunRunwayRuralSadSaddleSadnessSafeSailSaladSalmonSalonSaltSaluteSameSampleSandSatisfySatoshiSauceSausageSaveSayScaleScanScareScatterSceneSchemeSchoolScienceScissorsScorpionScoutScrapScreenScriptScrubSeaSearchSeasonSeatSecondSecretSectionSecuritySeedSeekSegmentSelectSellSeminarSeniorSenseSentenceSeriesServiceSessionSettleSetupSevenShadowShaftShallowShareShedShellSheriffShieldShiftShineShipShiverShockShoeShootShopShortShoulderShoveShrimpShrugShuffleShySiblingSickSideSiegeSightSignSilentSilkSillySilverSimilarSimpleSinceSingSirenSisterSituateSixSizeSkateSketchSkiSkillSkinSkirtSkullSlabSlamSleepSlenderSliceSlideSlightSlimSloganSlotSlowSlushSmallSmartSmileSmokeSmoothSnackSnakeSnapSniffSnowSoapSoccerSocialSockSodaSoftSolarSoldierSolidSolutionSolveSomeoneSongSoonSorrySortSoulSoundSoupSourceSouthSpaceSpareSpatialSpawnSpeakSpecialSpeedSpellSpendSphereSpiceSpiderSpikeSpinSpiritSplitSpoilSponsorSpoonSportSpotSpraySpreadSpringSpySquareSqueezeSquirrelStableStadiumStaffStageStairsStampStandStartStateStaySteakSteelStemStepStereoStickStillStingStockStomachStoneStoolStoryStoveStrategyStreetStrikeStrongStruggleStudentStuffStumbleStyleSubjectSubmitSubwaySuccessSuchSuddenSufferSugarSuggestSuitSummerSunSunnySunsetSuperSupplySupremeSureSurfaceSurgeSurpriseSurroundSurveySuspectSustainSwallowSwampSwapSwarmSwearSweetSwiftSwimSwingSwitchSwordSymbolSymptomSyrupSystemTableTackleTagTailTalentTalkTankTapeTargetTaskTasteTattooTaxiTeachTeamTellTenTenantTennisTentTermTestTextThankThatThemeThenTheoryThereTheyThingThisThoughtThreeThriveThrowThumbThunderTicketTideTigerTiltTimberTimeTinyTipTiredTissueTitleToastTobaccoTodayToddlerToeTogetherToiletTokenTomatoTomorrowToneTongueTonightToolToothTopTopicToppleTorchTornadoTortoiseTossTotalTouristTowardTowerTownToyTrackTradeTrafficTragicTrainTransferTrapTrashTravelTrayTreatTreeTrendTrialTribeTrickTriggerTrimTripTrophyTroubleTruckTrueTrulyTrumpetTrustTruthTryTubeTuitionTumbleTunaTunnelTurkeyTurnTurtleTwelveTwentyTwiceTwinTwistTwoTypeTypicalUglyUmbrellaUnableUnawareUncleUncoverUnderUndoUnfairUnfoldUnhappyUniformUniqueUnitUniverseUnknownUnlockUntilUnusualUnveilUpdateUpgradeUpholdUponUpperUpsetUrbanUrgeUsageUseUsedUsefulUselessUsualUtilityVacantVacuumVagueValidValleyValveVanVanishVaporVariousVastVaultVehicleVelvetVendorVentureVenueVerbVerifyVersionVeryVesselVeteranViableVibrantViciousVictoryVideoViewVillageVintageViolinVirtualVirusVisaVisitVisualVitalVividVocalVoiceVoidVolcanoVolumeVoteVoyageWageWagonWaitWalkWallWalnutWantWarfareWarmWarriorWashWaspWasteWaterWaveWayWealthWeaponWearWeaselWeatherWebWeddingWeekendWeirdWelcomeWestWetWhaleWhatWheatWheelWhenWhereWhipWhisperWideWidthWifeWildWillWinWindowWineWingWinkWinnerWinterWireWisdomWiseWishWitnessWolfWomanWonderWoodWoolWordWorkWorldWorryWorthWrapWreckWrestleWristWriteWrongYardYearYellowYouYoungYouthZebraZeroZoneZoo";
    var wordlist = null;
    function loadWords(lang) {
      if (wordlist != null) {
        return;
      }
      wordlist = words.replace(/([A-Z])/g, " $1").toLowerCase().substring(1).split(" ");
      if (wordlist_1.Wordlist.check(lang) !== "0x3c8acc1e7b08d8e76f9fda015ef48dc8c710a73cb7e0f77b2c18a9b5a7adde60") {
        wordlist = null;
        throw new Error("BIP39 Wordlist for en (English) FAILED");
      }
    }
    var LangEn = (
      /** @class */
      function(_super) {
        __extends(LangEn2, _super);
        function LangEn2() {
          return _super.call(this, "en") || this;
        }
        LangEn2.prototype.getWord = function(index) {
          loadWords(this);
          return wordlist[index];
        };
        LangEn2.prototype.getWordIndex = function(word) {
          loadWords(this);
          return wordlist.indexOf(word);
        };
        return LangEn2;
      }(wordlist_1.Wordlist)
    );
    var langEn = new LangEn();
    exports2.langEn = langEn;
    wordlist_1.Wordlist.register(langEn);
  }
});

// node_modules/@ethersproject/wordlists/lib/lang-es.js
var require_lang_es = __commonJS({
  "node_modules/@ethersproject/wordlists/lib/lang-es.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.langEs = void 0;
    var strings_1 = require_lib9();
    var wordlist_1 = require_wordlist();
    var words = "A/bacoAbdomenAbejaAbiertoAbogadoAbonoAbortoAbrazoAbrirAbueloAbusoAcabarAcademiaAccesoAccio/nAceiteAcelgaAcentoAceptarA/cidoAclararAcne/AcogerAcosoActivoActoActrizActuarAcudirAcuerdoAcusarAdictoAdmitirAdoptarAdornoAduanaAdultoAe/reoAfectarAficio/nAfinarAfirmarA/gilAgitarAgoni/aAgostoAgotarAgregarAgrioAguaAgudoA/guilaAgujaAhogoAhorroAireAislarAjedrezAjenoAjusteAlacra/nAlambreAlarmaAlbaA/lbumAlcaldeAldeaAlegreAlejarAlertaAletaAlfilerAlgaAlgodo/nAliadoAlientoAlivioAlmaAlmejaAlmi/barAltarAltezaAltivoAltoAlturaAlumnoAlzarAmableAmanteAmapolaAmargoAmasarA/mbarA/mbitoAmenoAmigoAmistadAmorAmparoAmplioAnchoAncianoAnclaAndarAnde/nAnemiaA/nguloAnilloA/nimoAni/sAnotarAntenaAntiguoAntojoAnualAnularAnuncioA~adirA~ejoA~oApagarAparatoApetitoApioAplicarApodoAporteApoyoAprenderAprobarApuestaApuroAradoAra~aArarA/rbitroA/rbolArbustoArchivoArcoArderArdillaArduoA/reaA/ridoAriesArmoni/aArne/sAromaArpaArpo/nArregloArrozArrugaArteArtistaAsaAsadoAsaltoAscensoAsegurarAseoAsesorAsientoAsiloAsistirAsnoAsombroA/speroAstillaAstroAstutoAsumirAsuntoAtajoAtaqueAtarAtentoAteoA/ticoAtletaA/tomoAtraerAtrozAtu/nAudazAudioAugeAulaAumentoAusenteAutorAvalAvanceAvaroAveAvellanaAvenaAvestruzAvio/nAvisoAyerAyudaAyunoAzafra/nAzarAzoteAzu/carAzufreAzulBabaBaborBacheBahi/aBaileBajarBalanzaBalco/nBaldeBambu/BancoBandaBa~oBarbaBarcoBarnizBarroBa/sculaBasto/nBasuraBatallaBateri/aBatirBatutaBau/lBazarBebe/BebidaBelloBesarBesoBestiaBichoBienBingoBlancoBloqueBlusaBoaBobinaBoboBocaBocinaBodaBodegaBoinaBolaBoleroBolsaBombaBondadBonitoBonoBonsa/iBordeBorrarBosqueBoteBoti/nBo/vedaBozalBravoBrazoBrechaBreveBrilloBrincoBrisaBrocaBromaBronceBroteBrujaBruscoBrutoBuceoBucleBuenoBueyBufandaBufo/nBu/hoBuitreBultoBurbujaBurlaBurroBuscarButacaBuzo/nCaballoCabezaCabinaCabraCacaoCada/verCadenaCaerCafe/Cai/daCaima/nCajaCajo/nCalCalamarCalcioCaldoCalidadCalleCalmaCalorCalvoCamaCambioCamelloCaminoCampoCa/ncerCandilCanelaCanguroCanicaCantoCa~aCa~o/nCaobaCaosCapazCapita/nCapoteCaptarCapuchaCaraCarbo/nCa/rcelCaretaCargaCari~oCarneCarpetaCarroCartaCasaCascoCaseroCaspaCastorCatorceCatreCaudalCausaCazoCebollaCederCedroCeldaCe/lebreCelosoCe/lulaCementoCenizaCentroCercaCerdoCerezaCeroCerrarCertezaCe/spedCetroChacalChalecoChampu/ChanclaChapaCharlaChicoChisteChivoChoqueChozaChuletaChuparCiclo/nCiegoCieloCienCiertoCifraCigarroCimaCincoCineCintaCipre/sCircoCiruelaCisneCitaCiudadClamorClanClaroClaseClaveClienteClimaCli/nicaCobreCoccio/nCochinoCocinaCocoCo/digoCodoCofreCogerCoheteCoji/nCojoColaColchaColegioColgarColinaCollarColmoColumnaCombateComerComidaCo/modoCompraCondeConejoCongaConocerConsejoContarCopaCopiaCorazo/nCorbataCorchoCordo/nCoronaCorrerCoserCosmosCostaCra/neoCra/terCrearCrecerCrei/doCremaCri/aCrimenCriptaCrisisCromoCro/nicaCroquetaCrudoCruzCuadroCuartoCuatroCuboCubrirCucharaCuelloCuentoCuerdaCuestaCuevaCuidarCulebraCulpaCultoCumbreCumplirCunaCunetaCuotaCupo/nCu/pulaCurarCuriosoCursoCurvaCutisDamaDanzaDarDardoDa/tilDeberDe/bilDe/cadaDecirDedoDefensaDefinirDejarDelfi/nDelgadoDelitoDemoraDensoDentalDeporteDerechoDerrotaDesayunoDeseoDesfileDesnudoDestinoDesvi/oDetalleDetenerDeudaDi/aDiabloDiademaDiamanteDianaDiarioDibujoDictarDienteDietaDiezDifi/cilDignoDilemaDiluirDineroDirectoDirigirDiscoDise~oDisfrazDivaDivinoDobleDoceDolorDomingoDonDonarDoradoDormirDorsoDosDosisDrago/nDrogaDuchaDudaDueloDue~oDulceDu/oDuqueDurarDurezaDuroE/banoEbrioEcharEcoEcuadorEdadEdicio/nEdificioEditorEducarEfectoEficazEjeEjemploElefanteElegirElementoElevarElipseE/liteElixirElogioEludirEmbudoEmitirEmocio/nEmpateEmpe~oEmpleoEmpresaEnanoEncargoEnchufeEnci/aEnemigoEneroEnfadoEnfermoEnga~oEnigmaEnlaceEnormeEnredoEnsayoEnse~arEnteroEntrarEnvaseEnvi/oE/pocaEquipoErizoEscalaEscenaEscolarEscribirEscudoEsenciaEsferaEsfuerzoEspadaEspejoEspi/aEsposaEspumaEsqui/EstarEsteEstiloEstufaEtapaEternoE/ticaEtniaEvadirEvaluarEventoEvitarExactoExamenExcesoExcusaExentoExigirExilioExistirE/xitoExpertoExplicarExponerExtremoFa/bricaFa/bulaFachadaFa/cilFactorFaenaFajaFaldaFalloFalsoFaltarFamaFamiliaFamosoFarao/nFarmaciaFarolFarsaFaseFatigaFaunaFavorFaxFebreroFechaFelizFeoFeriaFerozFe/rtilFervorFesti/nFiableFianzaFiarFibraFiccio/nFichaFideoFiebreFielFieraFiestaFiguraFijarFijoFilaFileteFilialFiltroFinFincaFingirFinitoFirmaFlacoFlautaFlechaFlorFlotaFluirFlujoFlu/orFobiaFocaFogataFogo/nFolioFolletoFondoFormaForroFortunaForzarFosaFotoFracasoFra/gilFranjaFraseFraudeFrei/rFrenoFresaFri/oFritoFrutaFuegoFuenteFuerzaFugaFumarFuncio/nFundaFurgo/nFuriaFusilFu/tbolFuturoGacelaGafasGaitaGajoGalaGaleri/aGalloGambaGanarGanchoGangaGansoGarajeGarzaGasolinaGastarGatoGavila/nGemeloGemirGenGe/neroGenioGenteGeranioGerenteGermenGestoGiganteGimnasioGirarGiroGlaciarGloboGloriaGolGolfoGolosoGolpeGomaGordoGorilaGorraGotaGoteoGozarGradaGra/ficoGranoGrasaGratisGraveGrietaGrilloGripeGrisGritoGrosorGru/aGruesoGrumoGrupoGuanteGuapoGuardiaGuerraGui/aGui~oGuionGuisoGuitarraGusanoGustarHaberHa/bilHablarHacerHachaHadaHallarHamacaHarinaHazHaza~aHebillaHebraHechoHeladoHelioHembraHerirHermanoHe/roeHervirHieloHierroHi/gadoHigieneHijoHimnoHistoriaHocicoHogarHogueraHojaHombreHongoHonorHonraHoraHormigaHornoHostilHoyoHuecoHuelgaHuertaHuesoHuevoHuidaHuirHumanoHu/medoHumildeHumoHundirHuraca/nHurtoIconoIdealIdiomaI/doloIglesiaIglu/IgualIlegalIlusio/nImagenIma/nImitarImparImperioImponerImpulsoIncapazI/ndiceInerteInfielInformeIngenioInicioInmensoInmuneInnatoInsectoInstanteIntere/sI/ntimoIntuirInu/tilInviernoIraIrisIroni/aIslaIsloteJabali/Jabo/nJamo/nJarabeJardi/nJarraJaulaJazmi/nJefeJeringaJineteJornadaJorobaJovenJoyaJuergaJuevesJuezJugadorJugoJugueteJuicioJuncoJunglaJunioJuntarJu/piterJurarJustoJuvenilJuzgarKiloKoalaLabioLacioLacraLadoLadro/nLagartoLa/grimaLagunaLaicoLamerLa/minaLa/mparaLanaLanchaLangostaLanzaLa/pizLargoLarvaLa/stimaLataLa/texLatirLaurelLavarLazoLealLeccio/nLecheLectorLeerLegio/nLegumbreLejanoLenguaLentoLe~aLeo/nLeopardoLesio/nLetalLetraLeveLeyendaLibertadLibroLicorLi/derLidiarLienzoLigaLigeroLimaLi/miteLimo/nLimpioLinceLindoLi/neaLingoteLinoLinternaLi/quidoLisoListaLiteraLitioLitroLlagaLlamaLlantoLlaveLlegarLlenarLlevarLlorarLloverLluviaLoboLocio/nLocoLocuraLo/gicaLogroLombrizLomoLonjaLoteLuchaLucirLugarLujoLunaLunesLupaLustroLutoLuzMacetaMachoMaderaMadreMaduroMaestroMafiaMagiaMagoMai/zMaldadMaletaMallaMaloMama/MamboMamutMancoMandoManejarMangaManiqui/ManjarManoMansoMantaMa~anaMapaMa/quinaMarMarcoMareaMarfilMargenMaridoMa/rmolMarro/nMartesMarzoMasaMa/scaraMasivoMatarMateriaMatizMatrizMa/ximoMayorMazorcaMechaMedallaMedioMe/dulaMejillaMejorMelenaMelo/nMemoriaMenorMensajeMenteMenu/MercadoMerengueMe/ritoMesMeso/nMetaMeterMe/todoMetroMezclaMiedoMielMiembroMigaMilMilagroMilitarMillo/nMimoMinaMineroMi/nimoMinutoMiopeMirarMisaMiseriaMisilMismoMitadMitoMochilaMocio/nModaModeloMohoMojarMoldeMolerMolinoMomentoMomiaMonarcaMonedaMonjaMontoMo~oMoradaMorderMorenoMorirMorroMorsaMortalMoscaMostrarMotivoMoverMo/vilMozoMuchoMudarMuebleMuelaMuerteMuestraMugreMujerMulaMuletaMultaMundoMu~ecaMuralMuroMu/sculoMuseoMusgoMu/sicaMusloNa/carNacio/nNadarNaipeNaranjaNarizNarrarNasalNatalNativoNaturalNa/useaNavalNaveNavidadNecioNe/ctarNegarNegocioNegroNeo/nNervioNetoNeutroNevarNeveraNichoNidoNieblaNietoNi~ezNi~oNi/tidoNivelNoblezaNocheNo/minaNoriaNormaNorteNotaNoticiaNovatoNovelaNovioNubeNucaNu/cleoNudilloNudoNueraNueveNuezNuloNu/meroNutriaOasisObesoObispoObjetoObraObreroObservarObtenerObvioOcaOcasoOce/anoOchentaOchoOcioOcreOctavoOctubreOcultoOcuparOcurrirOdiarOdioOdiseaOesteOfensaOfertaOficioOfrecerOgroOi/doOi/rOjoOlaOleadaOlfatoOlivoOllaOlmoOlorOlvidoOmbligoOndaOnzaOpacoOpcio/nO/peraOpinarOponerOptarO/pticaOpuestoOracio/nOradorOralO/rbitaOrcaOrdenOrejaO/rganoOrgi/aOrgulloOrienteOrigenOrillaOroOrquestaOrugaOsadi/aOscuroOseznoOsoOstraOto~oOtroOvejaO/vuloO/xidoOxi/genoOyenteOzonoPactoPadrePaellaPa/ginaPagoPai/sPa/jaroPalabraPalcoPaletaPa/lidoPalmaPalomaPalparPanPanalPa/nicoPanteraPa~ueloPapa/PapelPapillaPaquetePararParcelaParedParirParoPa/rpadoParquePa/rrafoPartePasarPaseoPasio/nPasoPastaPataPatioPatriaPausaPautaPavoPayasoPeato/nPecadoPeceraPechoPedalPedirPegarPeinePelarPelda~oPeleaPeligroPellejoPeloPelucaPenaPensarPe~o/nPeo/nPeorPepinoPeque~oPeraPerchaPerderPerezaPerfilPericoPerlaPermisoPerroPersonaPesaPescaPe/simoPesta~aPe/taloPetro/leoPezPezu~aPicarPicho/nPiePiedraPiernaPiezaPijamaPilarPilotoPimientaPinoPintorPinzaPi~aPiojoPipaPirataPisarPiscinaPisoPistaPito/nPizcaPlacaPlanPlataPlayaPlazaPleitoPlenoPlomoPlumaPluralPobrePocoPoderPodioPoemaPoesi/aPoetaPolenPolici/aPolloPolvoPomadaPomeloPomoPompaPonerPorcio/nPortalPosadaPoseerPosiblePostePotenciaPotroPozoPradoPrecozPreguntaPremioPrensaPresoPrevioPrimoPri/ncipePrisio/nPrivarProaProbarProcesoProductoProezaProfesorProgramaProlePromesaProntoPropioPro/ximoPruebaPu/blicoPucheroPudorPuebloPuertaPuestoPulgaPulirPulmo/nPulpoPulsoPumaPuntoPu~alPu~oPupaPupilaPure/QuedarQuejaQuemarQuererQuesoQuietoQui/micaQuinceQuitarRa/banoRabiaRaboRacio/nRadicalRai/zRamaRampaRanchoRangoRapazRa/pidoRaptoRasgoRaspaRatoRayoRazaRazo/nReaccio/nRealidadReba~oReboteRecaerRecetaRechazoRecogerRecreoRectoRecursoRedRedondoReducirReflejoReformaRefra/nRefugioRegaloRegirReglaRegresoRehe/nReinoRei/rRejaRelatoRelevoRelieveRellenoRelojRemarRemedioRemoRencorRendirRentaRepartoRepetirReposoReptilResRescateResinaRespetoRestoResumenRetiroRetornoRetratoReunirReve/sRevistaReyRezarRicoRiegoRiendaRiesgoRifaRi/gidoRigorRinco/nRi~o/nRi/oRiquezaRisaRitmoRitoRizoRobleRoceRociarRodarRodeoRodillaRoerRojizoRojoRomeroRomperRonRoncoRondaRopaRoperoRosaRoscaRostroRotarRubi/RuborRudoRuedaRugirRuidoRuinaRuletaRuloRumboRumorRupturaRutaRutinaSa/badoSaberSabioSableSacarSagazSagradoSalaSaldoSaleroSalirSalmo/nSalo/nSalsaSaltoSaludSalvarSambaSancio/nSandi/aSanearSangreSanidadSanoSantoSapoSaqueSardinaSarte/nSastreSata/nSaunaSaxofo/nSeccio/nSecoSecretoSectaSedSeguirSeisSelloSelvaSemanaSemillaSendaSensorSe~alSe~orSepararSepiaSequi/aSerSerieSermo/nServirSesentaSesio/nSetaSetentaSeveroSexoSextoSidraSiestaSieteSigloSignoSi/labaSilbarSilencioSillaSi/mboloSimioSirenaSistemaSitioSituarSobreSocioSodioSolSolapaSoldadoSoledadSo/lidoSoltarSolucio/nSombraSondeoSonidoSonoroSonrisaSopaSoplarSoporteSordoSorpresaSorteoSoste/nSo/tanoSuaveSubirSucesoSudorSuegraSueloSue~oSuerteSufrirSujetoSulta/nSumarSuperarSuplirSuponerSupremoSurSurcoSure~oSurgirSustoSutilTabacoTabiqueTablaTabu/TacoTactoTajoTalarTalcoTalentoTallaTalo/nTama~oTamborTangoTanqueTapaTapeteTapiaTapo/nTaquillaTardeTareaTarifaTarjetaTarotTarroTartaTatuajeTauroTazaTazo/nTeatroTechoTeclaTe/cnicaTejadoTejerTejidoTelaTele/fonoTemaTemorTemploTenazTenderTenerTenisTensoTeori/aTerapiaTercoTe/rminoTernuraTerrorTesisTesoroTestigoTeteraTextoTezTibioTiburo/nTiempoTiendaTierraTiesoTigreTijeraTildeTimbreTi/midoTimoTintaTi/oTi/picoTipoTiraTiro/nTita/nTi/tereTi/tuloTizaToallaTobilloTocarTocinoTodoTogaToldoTomarTonoTontoToparTopeToqueTo/raxToreroTormentaTorneoToroTorpedoTorreTorsoTortugaTosToscoToserTo/xicoTrabajoTractorTraerTra/ficoTragoTrajeTramoTranceTratoTraumaTrazarTre/bolTreguaTreintaTrenTreparTresTribuTrigoTripaTristeTriunfoTrofeoTrompaTroncoTropaTroteTrozoTrucoTruenoTrufaTuberi/aTuboTuertoTumbaTumorTu/nelTu/nicaTurbinaTurismoTurnoTutorUbicarU/lceraUmbralUnidadUnirUniversoUnoUntarU~aUrbanoUrbeUrgenteUrnaUsarUsuarioU/tilUtopi/aUvaVacaVaci/oVacunaVagarVagoVainaVajillaValeVa/lidoValleValorVa/lvulaVampiroVaraVariarVaro/nVasoVecinoVectorVehi/culoVeinteVejezVelaVeleroVelozVenaVencerVendaVenenoVengarVenirVentaVenusVerVeranoVerboVerdeVeredaVerjaVersoVerterVi/aViajeVibrarVicioVi/ctimaVidaVi/deoVidrioViejoViernesVigorVilVillaVinagreVinoVi~edoVioli/nViralVirgoVirtudVisorVi/speraVistaVitaminaViudoVivazViveroVivirVivoVolca/nVolumenVolverVorazVotarVotoVozVueloVulgarYacerYateYeguaYemaYernoYesoYodoYogaYogurZafiroZanjaZapatoZarzaZonaZorroZumoZurdo";
    var lookup = {};
    var wordlist = null;
    function dropDiacritic(word) {
      wordlist_1.logger.checkNormalize();
      return (0, strings_1.toUtf8String)(Array.prototype.filter.call((0, strings_1.toUtf8Bytes)(word.normalize("NFD").toLowerCase()), function(c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 123;
      }));
    }
    function expand(word) {
      var output = [];
      Array.prototype.forEach.call((0, strings_1.toUtf8Bytes)(word), function(c) {
        if (c === 47) {
          output.push(204);
          output.push(129);
        } else if (c === 126) {
          output.push(110);
          output.push(204);
          output.push(131);
        } else {
          output.push(c);
        }
      });
      return (0, strings_1.toUtf8String)(output);
    }
    function loadWords(lang) {
      if (wordlist != null) {
        return;
      }
      wordlist = words.replace(/([A-Z])/g, " $1").toLowerCase().substring(1).split(" ").map(function(w) {
        return expand(w);
      });
      wordlist.forEach(function(word, index) {
        lookup[dropDiacritic(word)] = index;
      });
      if (wordlist_1.Wordlist.check(lang) !== "0xf74fb7092aeacdfbf8959557de22098da512207fb9f109cb526994938cf40300") {
        wordlist = null;
        throw new Error("BIP39 Wordlist for es (Spanish) FAILED");
      }
    }
    var LangEs = (
      /** @class */
      function(_super) {
        __extends(LangEs2, _super);
        function LangEs2() {
          return _super.call(this, "es") || this;
        }
        LangEs2.prototype.getWord = function(index) {
          loadWords(this);
          return wordlist[index];
        };
        LangEs2.prototype.getWordIndex = function(word) {
          loadWords(this);
          return lookup[dropDiacritic(word)];
        };
        return LangEs2;
      }(wordlist_1.Wordlist)
    );
    var langEs = new LangEs();
    exports2.langEs = langEs;
    wordlist_1.Wordlist.register(langEs);
  }
});

// node_modules/@ethersproject/wordlists/lib/lang-fr.js
var require_lang_fr = __commonJS({
  "node_modules/@ethersproject/wordlists/lib/lang-fr.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.langFr = void 0;
    var strings_1 = require_lib9();
    var wordlist_1 = require_wordlist();
    var words = "AbaisserAbandonAbdiquerAbeilleAbolirAborderAboutirAboyerAbrasifAbreuverAbriterAbrogerAbruptAbsenceAbsoluAbsurdeAbusifAbyssalAcade/mieAcajouAcarienAccablerAccepterAcclamerAccoladeAccrocheAccuserAcerbeAchatAcheterAcidulerAcierAcompteAcque/rirAcronymeActeurActifActuelAdepteAde/quatAdhe/sifAdjectifAdjugerAdmettreAdmirerAdopterAdorerAdoucirAdresseAdroitAdulteAdverbeAe/rerAe/ronefAffaireAffecterAfficheAffreuxAffublerAgacerAgencerAgileAgiterAgraferAgre/ableAgrumeAiderAiguilleAilierAimableAisanceAjouterAjusterAlarmerAlchimieAlerteAlge-breAlgueAlie/nerAlimentAlle/gerAlliageAllouerAllumerAlourdirAlpagaAltesseAlve/oleAmateurAmbiguAmbreAme/nagerAmertumeAmidonAmiralAmorcerAmourAmovibleAmphibieAmpleurAmusantAnalyseAnaphoreAnarchieAnatomieAncienAne/antirAngleAngoisseAnguleuxAnimalAnnexerAnnonceAnnuelAnodinAnomalieAnonymeAnormalAntenneAntidoteAnxieuxApaiserApe/ritifAplanirApologieAppareilAppelerApporterAppuyerAquariumAqueducArbitreArbusteArdeurArdoiseArgentArlequinArmatureArmementArmoireArmureArpenterArracherArriverArroserArsenicArte/rielArticleAspectAsphalteAspirerAssautAsservirAssietteAssocierAssurerAsticotAstreAstuceAtelierAtomeAtriumAtroceAttaqueAttentifAttirerAttraperAubaineAubergeAudaceAudibleAugurerAuroreAutomneAutrucheAvalerAvancerAvariceAvenirAverseAveugleAviateurAvideAvionAviserAvoineAvouerAvrilAxialAxiomeBadgeBafouerBagageBaguetteBaignadeBalancerBalconBaleineBalisageBambinBancaireBandageBanlieueBannie-reBanquierBarbierBarilBaronBarqueBarrageBassinBastionBatailleBateauBatterieBaudrierBavarderBeletteBe/lierBeloteBe/ne/ficeBerceauBergerBerlineBermudaBesaceBesogneBe/tailBeurreBiberonBicycleBiduleBijouBilanBilingueBillardBinaireBiologieBiopsieBiotypeBiscuitBisonBistouriBitumeBizarreBlafardBlagueBlanchirBlessantBlinderBlondBloquerBlousonBobardBobineBoireBoiserBolideBonbonBondirBonheurBonifierBonusBordureBorneBotteBoucleBoueuxBougieBoulonBouquinBourseBoussoleBoutiqueBoxeurBrancheBrasierBraveBrebisBre-cheBreuvageBricolerBrigadeBrillantBriocheBriqueBrochureBroderBronzerBrousseBroyeurBrumeBrusqueBrutalBruyantBuffleBuissonBulletinBureauBurinBustierButinerButoirBuvableBuvetteCabanonCabineCachetteCadeauCadreCafe/ineCaillouCaissonCalculerCalepinCalibreCalmerCalomnieCalvaireCamaradeCame/raCamionCampagneCanalCanetonCanonCantineCanularCapableCaporalCapriceCapsuleCapterCapucheCarabineCarboneCaresserCaribouCarnageCarotteCarreauCartonCascadeCasierCasqueCassureCauserCautionCavalierCaverneCaviarCe/dilleCeintureCe/lesteCelluleCendrierCensurerCentralCercleCe/re/bralCeriseCernerCerveauCesserChagrinChaiseChaleurChambreChanceChapitreCharbonChasseurChatonChaussonChavirerChemiseChenilleChe/quierChercherChevalChienChiffreChignonChime-reChiotChlorureChocolatChoisirChoseChouetteChromeChuteCigareCigogneCimenterCine/maCintrerCirculerCirerCirqueCiterneCitoyenCitronCivilClaironClameurClaquerClasseClavierClientClignerClimatClivageClocheClonageCloporteCobaltCobraCocasseCocotierCoderCodifierCoffreCognerCohe/sionCoifferCoincerCole-reColibriCollineColmaterColonelCombatCome/dieCommandeCompactConcertConduireConfierCongelerConnoterConsonneContactConvexeCopainCopieCorailCorbeauCordageCornicheCorpusCorrectCorte-geCosmiqueCostumeCotonCoudeCoupureCourageCouteauCouvrirCoyoteCrabeCrainteCravateCrayonCre/atureCre/diterCre/meuxCreuserCrevetteCriblerCrierCristalCrite-reCroireCroquerCrotaleCrucialCruelCrypterCubiqueCueillirCuille-reCuisineCuivreCulminerCultiverCumulerCupideCuratifCurseurCyanureCycleCylindreCyniqueDaignerDamierDangerDanseurDauphinDe/battreDe/biterDe/borderDe/briderDe/butantDe/calerDe/cembreDe/chirerDe/ciderDe/clarerDe/corerDe/crireDe/cuplerDe/daleDe/ductifDe/esseDe/fensifDe/filerDe/frayerDe/gagerDe/givrerDe/glutirDe/graferDe/jeunerDe/liceDe/logerDemanderDemeurerDe/molirDe/nicherDe/nouerDentelleDe/nuderDe/partDe/penserDe/phaserDe/placerDe/poserDe/rangerDe/roberDe/sastreDescenteDe/sertDe/signerDe/sobe/irDessinerDestrierDe/tacherDe/testerDe/tourerDe/tresseDevancerDevenirDevinerDevoirDiableDialogueDiamantDicterDiffe/rerDige/rerDigitalDigneDiluerDimancheDiminuerDioxydeDirectifDirigerDiscuterDisposerDissiperDistanceDivertirDiviserDocileDocteurDogmeDoigtDomaineDomicileDompterDonateurDonjonDonnerDopamineDortoirDorureDosageDoseurDossierDotationDouanierDoubleDouceurDouterDoyenDragonDraperDresserDribblerDroitureDuperieDuplexeDurableDurcirDynastieE/blouirE/carterE/charpeE/chelleE/clairerE/clipseE/cloreE/cluseE/coleE/conomieE/corceE/couterE/craserE/cre/merE/crivainE/crouE/cumeE/cureuilE/difierE/duquerEffacerEffectifEffigieEffortEffrayerEffusionE/galiserE/garerE/jecterE/laborerE/largirE/lectronE/le/gantE/le/phantE/le-veE/ligibleE/litismeE/logeE/luciderE/luderEmballerEmbellirEmbryonE/meraudeE/missionEmmenerE/motionE/mouvoirEmpereurEmployerEmporterEmpriseE/mulsionEncadrerEnche-reEnclaveEncocheEndiguerEndosserEndroitEnduireE/nergieEnfanceEnfermerEnfouirEngagerEnginEngloberE/nigmeEnjamberEnjeuEnleverEnnemiEnnuyeuxEnrichirEnrobageEnseigneEntasserEntendreEntierEntourerEntraverE/nume/rerEnvahirEnviableEnvoyerEnzymeE/olienE/paissirE/pargneE/patantE/pauleE/picerieE/pide/mieE/pierE/pilogueE/pineE/pisodeE/pitapheE/poqueE/preuveE/prouverE/puisantE/querreE/quipeE/rigerE/rosionErreurE/ruptionEscalierEspadonEspe-ceEspie-gleEspoirEspritEsquiverEssayerEssenceEssieuEssorerEstimeEstomacEstradeE/tage-reE/talerE/tancheE/tatiqueE/teindreE/tendoirE/ternelE/thanolE/thiqueEthnieE/tirerE/tofferE/toileE/tonnantE/tourdirE/trangeE/troitE/tudeEuphorieE/valuerE/vasionE/ventailE/videnceE/viterE/volutifE/voquerExactExage/rerExaucerExcellerExcitantExclusifExcuseExe/cuterExempleExercerExhalerExhorterExigenceExilerExisterExotiqueExpe/dierExplorerExposerExprimerExquisExtensifExtraireExulterFableFabuleuxFacetteFacileFactureFaiblirFalaiseFameuxFamilleFarceurFarfeluFarineFaroucheFascinerFatalFatigueFauconFautifFaveurFavoriFe/brileFe/conderFe/de/rerFe/linFemmeFe/murFendoirFe/odalFermerFe/roceFerveurFestivalFeuilleFeutreFe/vrierFiascoFicelerFictifFide-leFigureFilatureFiletageFilie-reFilleulFilmerFilouFiltrerFinancerFinirFioleFirmeFissureFixerFlairerFlammeFlasqueFlatteurFle/auFle-cheFleurFlexionFloconFloreFluctuerFluideFluvialFolieFonderieFongibleFontaineForcerForgeronFormulerFortuneFossileFoudreFouge-reFouillerFoulureFourmiFragileFraiseFranchirFrapperFrayeurFre/gateFreinerFrelonFre/mirFre/ne/sieFre-reFriableFrictionFrissonFrivoleFroidFromageFrontalFrotterFruitFugitifFuiteFureurFurieuxFurtifFusionFuturGagnerGalaxieGalerieGambaderGarantirGardienGarnirGarrigueGazelleGazonGe/antGe/latineGe/luleGendarmeGe/ne/ralGe/nieGenouGentilGe/ologieGe/ome-treGe/raniumGermeGestuelGeyserGibierGiclerGirafeGivreGlaceGlaiveGlisserGlobeGloireGlorieuxGolfeurGommeGonflerGorgeGorilleGoudronGouffreGoulotGoupilleGourmandGoutteGraduelGraffitiGraineGrandGrappinGratuitGravirGrenatGriffureGrillerGrimperGrognerGronderGrotteGroupeGrugerGrutierGruye-reGue/pardGuerrierGuideGuimauveGuitareGustatifGymnasteGyrostatHabitudeHachoirHalteHameauHangarHannetonHaricotHarmonieHarponHasardHe/liumHe/matomeHerbeHe/rissonHermineHe/ronHe/siterHeureuxHibernerHibouHilarantHistoireHiverHomardHommageHomoge-neHonneurHonorerHonteuxHordeHorizonHorlogeHormoneHorribleHouleuxHousseHublotHuileuxHumainHumbleHumideHumourHurlerHydromelHygie-neHymneHypnoseIdylleIgnorerIguaneIlliciteIllusionImageImbiberImiterImmenseImmobileImmuableImpactImpe/rialImplorerImposerImprimerImputerIncarnerIncendieIncidentInclinerIncoloreIndexerIndiceInductifIne/ditIneptieInexactInfiniInfligerInformerInfusionInge/rerInhalerInhiberInjecterInjureInnocentInoculerInonderInscrireInsecteInsigneInsoliteInspirerInstinctInsulterIntactIntenseIntimeIntrigueIntuitifInutileInvasionInventerInviterInvoquerIroniqueIrradierIrre/elIrriterIsolerIvoireIvresseJaguarJaillirJambeJanvierJardinJaugerJauneJavelotJetableJetonJeudiJeunesseJoindreJoncherJonglerJoueurJouissifJournalJovialJoyauJoyeuxJubilerJugementJuniorJuponJuristeJusticeJuteuxJuve/nileKayakKimonoKiosqueLabelLabialLabourerLace/rerLactoseLaguneLaineLaisserLaitierLambeauLamelleLampeLanceurLangageLanterneLapinLargeurLarmeLaurierLavaboLavoirLectureLe/galLe/gerLe/gumeLessiveLettreLevierLexiqueLe/zardLiasseLibe/rerLibreLicenceLicorneLie-geLie-vreLigatureLigoterLigueLimerLimiteLimonadeLimpideLine/aireLingotLionceauLiquideLisie-reListerLithiumLitigeLittoralLivreurLogiqueLointainLoisirLombricLoterieLouerLourdLoutreLouveLoyalLubieLucideLucratifLueurLugubreLuisantLumie-reLunaireLundiLuronLutterLuxueuxMachineMagasinMagentaMagiqueMaigreMaillonMaintienMairieMaisonMajorerMalaxerMale/ficeMalheurMaliceMalletteMammouthMandaterManiableManquantManteauManuelMarathonMarbreMarchandMardiMaritimeMarqueurMarronMartelerMascotteMassifMate/rielMatie-reMatraqueMaudireMaussadeMauveMaximalMe/chantMe/connuMe/dailleMe/decinMe/diterMe/duseMeilleurMe/langeMe/lodieMembreMe/moireMenacerMenerMenhirMensongeMentorMercrediMe/riteMerleMessagerMesureMe/talMe/te/oreMe/thodeMe/tierMeubleMiaulerMicrobeMietteMignonMigrerMilieuMillionMimiqueMinceMine/ralMinimalMinorerMinuteMiracleMiroiterMissileMixteMobileModerneMoelleuxMondialMoniteurMonnaieMonotoneMonstreMontagneMonumentMoqueurMorceauMorsureMortierMoteurMotifMoucheMoufleMoulinMoussonMoutonMouvantMultipleMunitionMurailleMure-neMurmureMuscleMuse/umMusicienMutationMuterMutuelMyriadeMyrtilleMyste-reMythiqueNageurNappeNarquoisNarrerNatationNationNatureNaufrageNautiqueNavireNe/buleuxNectarNe/fasteNe/gationNe/gligerNe/gocierNeigeNerveuxNettoyerNeuroneNeutronNeveuNicheNickelNitrateNiveauNobleNocifNocturneNoirceurNoisetteNomadeNombreuxNommerNormatifNotableNotifierNotoireNourrirNouveauNovateurNovembreNoviceNuageNuancerNuireNuisibleNume/roNuptialNuqueNutritifObe/irObjectifObligerObscurObserverObstacleObtenirObturerOccasionOccuperOce/anOctobreOctroyerOctuplerOculaireOdeurOdorantOffenserOfficierOffrirOgiveOiseauOisillonOlfactifOlivierOmbrageOmettreOnctueuxOndulerOne/reuxOniriqueOpaleOpaqueOpe/rerOpinionOpportunOpprimerOpterOptiqueOrageuxOrangeOrbiteOrdonnerOreilleOrganeOrgueilOrificeOrnementOrqueOrtieOscillerOsmoseOssatureOtarieOuraganOursonOutilOutragerOuvrageOvationOxydeOxyge-neOzonePaisiblePalacePalmare-sPalourdePalperPanachePandaPangolinPaniquerPanneauPanoramaPantalonPapayePapierPapoterPapyrusParadoxeParcelleParesseParfumerParlerParoleParrainParsemerPartagerParureParvenirPassionPaste-quePaternelPatiencePatronPavillonPavoiserPayerPaysagePeignePeintrePelagePe/licanPellePelousePeluchePendulePe/ne/trerPe/niblePensifPe/nuriePe/pitePe/plumPerdrixPerforerPe/riodePermuterPerplexePersilPertePeserPe/talePetitPe/trirPeuplePharaonPhobiePhoquePhotonPhrasePhysiquePianoPicturalPie-cePierrePieuvrePilotePinceauPipettePiquerPiroguePiscinePistonPivoterPixelPizzaPlacardPlafondPlaisirPlanerPlaquePlastronPlateauPleurerPlexusPliagePlombPlongerPluiePlumagePochettePoe/siePoe-tePointePoirierPoissonPoivrePolairePolicierPollenPolygonePommadePompierPonctuelPonde/rerPoneyPortiquePositionPosse/derPosturePotagerPoteauPotionPoucePoulainPoumonPourprePoussinPouvoirPrairiePratiquePre/cieuxPre/direPre/fixePre/ludePre/nomPre/sencePre/textePre/voirPrimitifPrincePrisonPriverProble-meProce/derProdigeProfondProgre-sProieProjeterProloguePromenerPropreProspe-reProte/gerProuesseProverbePrudencePruneauPsychosePublicPuceronPuiserPulpePulsarPunaisePunitifPupitrePurifierPuzzlePyramideQuasarQuerelleQuestionQuie/tudeQuitterQuotientRacineRaconterRadieuxRagondinRaideurRaisinRalentirRallongeRamasserRapideRasageRatisserRavagerRavinRayonnerRe/actifRe/agirRe/aliserRe/animerRecevoirRe/citerRe/clamerRe/colterRecruterReculerRecyclerRe/digerRedouterRefaireRe/flexeRe/formerRefrainRefugeRe/galienRe/gionRe/glageRe/gulierRe/ite/rerRejeterRejouerRelatifReleverReliefRemarqueReme-deRemiseRemonterRemplirRemuerRenardRenfortReniflerRenoncerRentrerRenvoiReplierReporterRepriseReptileRequinRe/serveRe/sineuxRe/soudreRespectResterRe/sultatRe/tablirRetenirRe/ticuleRetomberRetracerRe/unionRe/ussirRevancheRevivreRe/volteRe/vulsifRichesseRideauRieurRigideRigolerRincerRiposterRisibleRisqueRituelRivalRivie-reRocheuxRomanceRompreRonceRondinRoseauRosierRotatifRotorRotuleRougeRouilleRouleauRoutineRoyaumeRubanRubisRucheRuelleRugueuxRuinerRuisseauRuserRustiqueRythmeSablerSaboterSabreSacocheSafariSagesseSaisirSaladeSaliveSalonSaluerSamediSanctionSanglierSarcasmeSardineSaturerSaugrenuSaumonSauterSauvageSavantSavonnerScalpelScandaleSce/le/ratSce/narioSceptreSche/maScienceScinderScoreScrutinSculpterSe/anceSe/cableSe/cherSecouerSe/cre/terSe/datifSe/duireSeigneurSe/jourSe/lectifSemaineSemblerSemenceSe/minalSe/nateurSensibleSentenceSe/parerSe/quenceSereinSergentSe/rieuxSerrureSe/rumServiceSe/sameSe/virSevrageSextupleSide/ralSie-cleSie/gerSifflerSigleSignalSilenceSiliciumSimpleSince-reSinistreSiphonSiropSismiqueSituerSkierSocialSocleSodiumSoigneuxSoldatSoleilSolitudeSolubleSombreSommeilSomnolerSondeSongeurSonnetteSonoreSorcierSortirSosieSottiseSoucieuxSoudureSouffleSouleverSoupapeSourceSoutirerSouvenirSpacieuxSpatialSpe/cialSphe-reSpiralStableStationSternumStimulusStipulerStrictStudieuxStupeurStylisteSublimeSubstratSubtilSubvenirSucce-sSucreSuffixeSugge/rerSuiveurSulfateSuperbeSupplierSurfaceSuricateSurmenerSurpriseSursautSurvieSuspectSyllabeSymboleSyme/trieSynapseSyntaxeSyste-meTabacTablierTactileTaillerTalentTalismanTalonnerTambourTamiserTangibleTapisTaquinerTarderTarifTartineTasseTatamiTatouageTaupeTaureauTaxerTe/moinTemporelTenailleTendreTeneurTenirTensionTerminerTerneTerribleTe/tineTexteThe-meThe/orieThe/rapieThoraxTibiaTie-deTimideTirelireTiroirTissuTitaneTitreTituberTobogganTole/rantTomateToniqueTonneauToponymeTorcheTordreTornadeTorpilleTorrentTorseTortueTotemToucherTournageTousserToxineTractionTraficTragiqueTrahirTrainTrancherTravailTre-fleTremperTre/sorTreuilTriageTribunalTricoterTrilogieTriompheTriplerTriturerTrivialTromboneTroncTropicalTroupeauTuileTulipeTumulteTunnelTurbineTuteurTutoyerTuyauTympanTyphonTypiqueTyranUbuesqueUltimeUltrasonUnanimeUnifierUnionUniqueUnitaireUniversUraniumUrbainUrticantUsageUsineUsuelUsureUtileUtopieVacarmeVaccinVagabondVagueVaillantVaincreVaisseauValableValiseVallonValveVampireVanilleVapeurVarierVaseuxVassalVasteVecteurVedetteVe/ge/talVe/hiculeVeinardVe/loceVendrediVe/ne/rerVengerVenimeuxVentouseVerdureVe/rinVernirVerrouVerserVertuVestonVe/te/ranVe/tusteVexantVexerViaducViandeVictoireVidangeVide/oVignetteVigueurVilainVillageVinaigreViolonVipe-reVirementVirtuoseVirusVisageViseurVisionVisqueuxVisuelVitalVitesseViticoleVitrineVivaceVivipareVocationVoguerVoileVoisinVoitureVolailleVolcanVoltigerVolumeVoraceVortexVoterVouloirVoyageVoyelleWagonXe/nonYachtZe-breZe/nithZesteZoologie";
    var wordlist = null;
    var lookup = {};
    function dropDiacritic(word) {
      wordlist_1.logger.checkNormalize();
      return (0, strings_1.toUtf8String)(Array.prototype.filter.call((0, strings_1.toUtf8Bytes)(word.normalize("NFD").toLowerCase()), function(c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 123;
      }));
    }
    function expand(word) {
      var output = [];
      Array.prototype.forEach.call((0, strings_1.toUtf8Bytes)(word), function(c) {
        if (c === 47) {
          output.push(204);
          output.push(129);
        } else if (c === 45) {
          output.push(204);
          output.push(128);
        } else {
          output.push(c);
        }
      });
      return (0, strings_1.toUtf8String)(output);
    }
    function loadWords(lang) {
      if (wordlist != null) {
        return;
      }
      wordlist = words.replace(/([A-Z])/g, " $1").toLowerCase().substring(1).split(" ").map(function(w) {
        return expand(w);
      });
      wordlist.forEach(function(word, index) {
        lookup[dropDiacritic(word)] = index;
      });
      if (wordlist_1.Wordlist.check(lang) !== "0x51deb7ae009149dc61a6bd18a918eb7ac78d2775726c68e598b92d002519b045") {
        wordlist = null;
        throw new Error("BIP39 Wordlist for fr (French) FAILED");
      }
    }
    var LangFr = (
      /** @class */
      function(_super) {
        __extends(LangFr2, _super);
        function LangFr2() {
          return _super.call(this, "fr") || this;
        }
        LangFr2.prototype.getWord = function(index) {
          loadWords(this);
          return wordlist[index];
        };
        LangFr2.prototype.getWordIndex = function(word) {
          loadWords(this);
          return lookup[dropDiacritic(word)];
        };
        return LangFr2;
      }(wordlist_1.Wordlist)
    );
    var langFr = new LangFr();
    exports2.langFr = langFr;
    wordlist_1.Wordlist.register(langFr);
  }
});

// node_modules/@ethersproject/wordlists/lib/lang-ja.js
var require_lang_ja = __commonJS({
  "node_modules/@ethersproject/wordlists/lib/lang-ja.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.langJa = void 0;
    var bytes_1 = require_lib2();
    var strings_1 = require_lib9();
    var wordlist_1 = require_wordlist();
    var data = [
      // 4-kana words
      "AQRASRAGBAGUAIRAHBAghAURAdBAdcAnoAMEAFBAFCBKFBQRBSFBCXBCDBCHBGFBEQBpBBpQBIkBHNBeOBgFBVCBhBBhNBmOBmRBiHBiFBUFBZDBvFBsXBkFBlcBjYBwDBMBBTBBTRBWBBWXXaQXaRXQWXSRXCFXYBXpHXOQXHRXhRXuRXmXXbRXlXXwDXTRXrCXWQXWGaBWaKcaYgasFadQalmaMBacAKaRKKBKKXKKjKQRKDRKCYKCRKIDKeVKHcKlXKjHKrYNAHNBWNaRNKcNIBNIONmXNsXNdXNnBNMBNRBNrXNWDNWMNFOQABQAHQBrQXBQXFQaRQKXQKDQKOQKFQNBQNDQQgQCXQCDQGBQGDQGdQYXQpBQpQQpHQLXQHuQgBQhBQhCQuFQmXQiDQUFQZDQsFQdRQkHQbRQlOQlmQPDQjDQwXQMBQMDQcFQTBQTHQrDDXQDNFDGBDGQDGRDpFDhFDmXDZXDbRDMYDRdDTRDrXSAhSBCSBrSGQSEQSHBSVRShYShkSyQSuFSiBSdcSoESocSlmSMBSFBSFKSFNSFdSFcCByCaRCKcCSBCSRCCrCGbCEHCYXCpBCpQCIBCIHCeNCgBCgFCVECVcCmkCmwCZXCZFCdRClOClmClFCjDCjdCnXCwBCwXCcRCFQCFjGXhGNhGDEGDMGCDGCHGIFGgBGVXGVEGVRGmXGsXGdYGoSGbRGnXGwXGwDGWRGFNGFLGFOGFdGFkEABEBDEBFEXOEaBEKSENBENDEYXEIgEIkEgBEgQEgHEhFEudEuFEiBEiHEiFEZDEvBEsXEsFEdXEdREkFEbBEbRElFEPCEfkEFNYAEYAhYBNYQdYDXYSRYCEYYoYgQYgRYuRYmCYZTYdBYbEYlXYjQYRbYWRpKXpQopQnpSFpCXpIBpISphNpdBpdRpbRpcZpFBpFNpFDpFopFrLADLBuLXQLXcLaFLCXLEhLpBLpFLHXLeVLhILdHLdRLoDLbRLrXIABIBQIBCIBsIBoIBMIBRIXaIaRIKYIKRINBINuICDIGBIIDIIkIgRIxFIyQIiHIdRIbYIbRIlHIwRIMYIcRIRVITRIFBIFNIFQOABOAFOBQOaFONBONMOQFOSFOCDOGBOEQOpBOLXOIBOIFOgQOgFOyQOycOmXOsXOdIOkHOMEOMkOWWHBNHXNHXWHNXHDuHDRHSuHSRHHoHhkHmRHdRHkQHlcHlRHwBHWcgAEgAggAkgBNgBQgBEgXOgYcgLXgHjgyQgiBgsFgdagMYgWSgFQgFEVBTVXEVKBVKNVKDVKYVKRVNBVNYVDBVDxVSBVSRVCjVGNVLXVIFVhBVhcVsXVdRVbRVlRhBYhKYhDYhGShxWhmNhdahdkhbRhjohMXhTRxAXxXSxKBxNBxEQxeNxeQxhXxsFxdbxlHxjcxFBxFNxFQxFOxFoyNYyYoybcyMYuBQuBRuBruDMuCouHBudQukkuoBulVuMXuFEmCYmCRmpRmeDmiMmjdmTFmFQiADiBOiaRiKRiNBiNRiSFiGkiGFiERipRiLFiIFihYibHijBijEiMXiWBiFBiFCUBQUXFUaRUNDUNcUNRUNFUDBUSHUCDUGBUGFUEqULNULoUIRUeEUeYUgBUhFUuRUiFUsXUdFUkHUbBUjSUjYUwXUMDUcHURdUTBUrBUrXUrQZAFZXZZaRZKFZNBZQFZCXZGBZYdZpBZLDZIFZHXZHNZeQZVRZVFZmXZiBZvFZdFZkFZbHZbFZwXZcCZcRZRBvBQvBGvBLvBWvCovMYsAFsBDsaRsKFsNFsDrsSHsSFsCXsCRsEBsEHsEfspBsLBsLDsIgsIRseGsbRsFBsFQsFSdNBdSRdCVdGHdYDdHcdVbdySduDdsXdlRdwXdWYdWcdWRkBMkXOkaRkNIkNFkSFkCFkYBkpRkeNkgBkhVkmXksFklVkMBkWDkFNoBNoaQoaFoNBoNXoNaoNEoSRoEroYXoYCoYbopRopFomXojkowXorFbBEbEIbdBbjYlaRlDElMXlFDjKjjSRjGBjYBjYkjpRjLXjIBjOFjeVjbRjwBnXQnSHnpFnLXnINnMBnTRwXBwXNwXYwNFwQFwSBwGFwLXwLDweNwgBwuHwjDwnXMBXMpFMIBMeNMTHcaQcNBcDHcSFcCXcpBcLXcLDcgFcuFcnXcwXccDcTQcrFTQErXNrCHrpFrgFrbFrTHrFcWNYWNbWEHWMXWTR",
      // 5-kana words
      "ABGHABIJAEAVAYJQALZJAIaRAHNXAHdcAHbRAZJMAZJRAZTRAdVJAklmAbcNAjdRAMnRAMWYAWpRAWgRAFgBAFhBAFdcBNJBBNJDBQKBBQhcBQlmBDEJBYJkBYJTBpNBBpJFBIJBBIJDBIcABOKXBOEJBOVJBOiJBOZJBepBBeLXBeIFBegBBgGJBVJXBuocBiJRBUJQBlXVBlITBwNFBMYVBcqXBTlmBWNFBWiJBWnRBFGHBFwXXKGJXNJBXNZJXDTTXSHSXSVRXSlHXCJDXGQJXEhXXYQJXYbRXOfXXeNcXVJFXhQJXhEJXdTRXjdXXMhBXcQTXRGBXTEBXTnQXFCXXFOFXFgFaBaFaBNJaBCJaBpBaBwXaNJKaNJDaQIBaDpRaEPDaHMFamDJalEJaMZJaFaFaFNBaFQJaFLDaFVHKBCYKBEBKBHDKXaFKXGdKXEJKXpHKXIBKXZDKXwXKKwLKNacKNYJKNJoKNWcKDGdKDTRKChXKGaRKGhBKGbRKEBTKEaRKEPTKLMDKLWRKOHDKVJcKdBcKlIBKlOPKFSBKFEPKFpFNBNJNJBQNBGHNBEPNBHXNBgFNBVXNBZDNBsXNBwXNNaRNNJDNNJENNJkNDCJNDVDNGJRNJiDNZJNNsCJNJFNNFSBNFCXNFEPNFLXNFIFQJBFQCaRQJEQQLJDQLJFQIaRQOqXQHaFQHHQQVJXQVJDQhNJQmEIQZJFQsJXQJrFQWbRDJABDBYJDXNFDXCXDXLXDXZDDXsJDQqXDSJFDJCXDEPkDEqXDYmQDpSJDOCkDOGQDHEIDVJDDuDuDWEBDJFgSBNDSBSFSBGHSBIBSBTQSKVYSJQNSJQiSJCXSEqXSJYVSIiJSOMYSHAHSHaQSeCFSepQSegBSHdHSHrFShSJSJuHSJUFSkNRSrSrSWEBSFaHSJFQSFCXSFGDSFYXSFODSFgBSFVXSFhBSFxFSFkFSFbBSFMFCADdCJXBCXaFCXKFCXNFCXCXCXGBCXEJCXYBCXLDCXIBCXOPCXHXCXgBCXhBCXiBCXlDCXcHCJNBCJNFCDCJCDGBCDVXCDhBCDiDCDJdCCmNCpJFCIaRCOqXCHCHCHZJCViJCuCuCmddCJiFCdNBCdHhClEJCnUJCreSCWlgCWTRCFBFCFNBCFYBCFVFCFhFCFdSCFTBCFWDGBNBGBQFGJBCGBEqGBpBGBgQGNBEGNJYGNkOGNJRGDUFGJpQGHaBGJeNGJeEGVBlGVKjGiJDGvJHGsVJGkEBGMIJGWjNGFBFGFCXGFGBGFYXGFpBGFMFEASJEAWpEJNFECJVEIXSEIQJEOqXEOcFEeNcEHEJEHlFEJgFEhlmEmDJEmZJEiMBEUqXEoSREPBFEPXFEPKFEPSFEPEFEPpFEPLXEPIBEJPdEPcFEPTBEJnXEqlHEMpREFCXEFODEFcFYASJYJAFYBaBYBVXYXpFYDhBYCJBYJGFYYbRYeNcYJeVYiIJYZJcYvJgYvJRYJsXYsJFYMYMYreVpBNHpBEJpBwXpQxFpYEJpeNDpJeDpeSFpeCHpHUJpHbBpHcHpmUJpiiJpUJrpsJuplITpFaBpFQqpFGBpFEfpFYBpFpBpFLJpFIDpFgBpFVXpFyQpFuFpFlFpFjDpFnXpFwXpJFMpFTBLXCJLXEFLXhFLXUJLXbFLalmLNJBLSJQLCLCLGJBLLDJLHaFLeNFLeSHLeCXLepFLhaRLZsJLsJDLsJrLocaLlLlLMdbLFNBLFSBLFEHLFkFIBBFIBXFIBaQIBKXIBSFIBpHIBLXIBgBIBhBIBuHIBmXIBiFIBZXIBvFIBbFIBjQIBwXIBWFIKTRIQUJIDGFICjQIYSRIINXIJeCIVaRImEkIZJFIvJRIsJXIdCJIJoRIbBQIjYBIcqXITFVIreVIFKFIFSFIFCJIFGFIFLDIFIBIJFOIFgBIFVXIJFhIFxFIFmXIFdHIFbBIJFrIJFWOBGBOQfXOOKjOUqXOfXBOqXEOcqXORVJOFIBOFlDHBIOHXiFHNTRHCJXHIaRHHJDHHEJHVbRHZJYHbIBHRsJHRkDHWlmgBKFgBSBgBCDgBGHgBpBgBIBgBVJgBuBgBvFgKDTgQVXgDUJgGSJgOqXgmUMgZIJgTUJgWIEgFBFgFNBgFDJgFSFgFGBgFYXgJFOgFgQgFVXgFhBgFbHgJFWVJABVQKcVDgFVOfXVeDFVhaRVmGdViJYVMaRVFNHhBNDhBCXhBEqhBpFhBLXhNJBhSJRheVXhhKEhxlmhZIJhdBQhkIJhbMNhMUJhMZJxNJgxQUJxDEkxDdFxSJRxplmxeSBxeCXxeGFxeYXxepQxegBxWVcxFEQxFLXxFIBxFgBxFxDxFZtxFdcxFbBxFwXyDJXyDlcuASJuDJpuDIBuCpJuGSJuIJFueEFuZIJusJXudWEuoIBuWGJuFBcuFKEuFNFuFQFuFDJuFGJuFVJuFUtuFdHuFTBmBYJmNJYmQhkmLJDmLJomIdXmiJYmvJRmsJRmklmmMBymMuCmclmmcnQiJABiJBNiJBDiBSFiBCJiBEFiBYBiBpFiBLXiBTHiJNciDEfiCZJiECJiJEqiOkHiHKFieNDiHJQieQcieDHieSFieCXieGFieEFieIHiegFihUJixNoioNXiFaBiFKFiFNDiFEPiFYXitFOitFHiFgBiFVEiFmXiFitiFbBiFMFiFrFUCXQUIoQUIJcUHQJUeCEUHwXUUJDUUqXUdWcUcqXUrnQUFNDUFSHUFCFUFEfUFLXUtFOZBXOZXSBZXpFZXVXZEQJZEJkZpDJZOqXZeNHZeCDZUqXZFBQZFEHZFLXvBAFvBKFvBCXvBEPvBpHvBIDvBgFvBuHvQNJvFNFvFGBvFIBvJFcsXCDsXLXsXsXsXlFsXcHsQqXsJQFsEqXseIFsFEHsFjDdBxOdNpRdNJRdEJbdpJRdhZJdnSJdrjNdFNJdFQHdFhNkNJDkYaRkHNRkHSRkVbRkuMRkjSJkcqDoSJFoEiJoYZJoOfXohEBoMGQocqXbBAFbBXFbBaFbBNDbBGBbBLXbBTBbBWDbGJYbIJHbFQqbFpQlDgQlOrFlVJRjGEBjZJRnXvJnXbBnEfHnOPDngJRnxfXnUJWwXEJwNpJwDpBwEfXwrEBMDCJMDGHMDIJMLJDcQGDcQpHcqXccqNFcqCXcFCJRBSBRBGBRBEJRBpQTBNFTBQJTBpBTBVXTFABTFSBTFCFTFGBTFMDrXCJrXLDrDNJrEfHrFQJrFitWNjdWNTR",
      // 6-kana words
      "AKLJMANOPFASNJIAEJWXAYJNRAIIbRAIcdaAeEfDAgidRAdjNYAMYEJAMIbRAFNJBAFpJFBBIJYBDZJFBSiJhBGdEBBEJfXBEJqXBEJWRBpaUJBLXrXBIYJMBOcfXBeEfFBestXBjNJRBcDJOBFEqXXNvJRXDMBhXCJNYXOAWpXONJWXHDEBXeIaRXhYJDXZJSJXMDJOXcASJXFVJXaBQqXaBZJFasXdQaFSJQaFEfXaFpJHaFOqXKBNSRKXvJBKQJhXKEJQJKEJGFKINJBKIJjNKgJNSKVElmKVhEBKiJGFKlBgJKjnUJKwsJYKMFIJKFNJDKFIJFKFOfXNJBSFNJBCXNBpJFNJBvQNJBMBNJLJXNJOqXNJeCXNJeGFNdsJCNbTKFNwXUJQNFEPQDiJcQDMSJQSFpBQGMQJQJeOcQyCJEQUJEBQJFBrQFEJqDXDJFDJXpBDJXIMDGiJhDIJGRDJeYcDHrDJDVXgFDkAWpDkIgRDjDEqDMvJRDJFNFDJFIBSKclmSJQOFSJQVHSJQjDSJGJBSJGJFSECJoSHEJqSJHTBSJVJDSViJYSZJNBSJsJDSFSJFSFEfXSJFLXCBUJVCJXSBCJXpBCXVJXCJXsXCJXdFCJNJHCLIJgCHiJFCVNJMChCJhCUHEJCsJTRCJdYcCoQJCCFEfXCFIJgCFUJxCFstFGJBaQGJBIDGQJqXGYJNRGJHKFGeQqDGHEJFGJeLXGHIiJGHdBlGUJEBGkIJTGFQPDGJFEqEAGegEJIJBEJVJXEhQJTEiJNcEJZJFEJoEqEjDEqEPDsXEPGJBEPOqXEPeQFEfDiDEJfEFEfepQEfMiJEqXNBEqDIDEqeSFEqVJXEMvJRYXNJDYXEJHYKVJcYYJEBYJeEcYJUqXYFpJFYFstXpAZJMpBSJFpNBNFpeQPDpHLJDpHIJFpHgJFpeitFpHZJFpJFADpFSJFpJFCJpFOqXpFitBpJFZJLXIJFLIJgRLVNJWLVHJMLwNpJLFGJBLFLJDLFOqXLJFUJIBDJXIBGJBIJBYQIJBIBIBOqXIBcqDIEGJFILNJTIIJEBIOiJhIJeNBIJeIBIhiJIIWoTRIJFAHIJFpBIJFuHIFUtFIJFTHOSBYJOEcqXOHEJqOvBpFOkVJrObBVJOncqDOcNJkHhNJRHuHJuHdMhBgBUqXgBsJXgONJBgHNJDgHHJQgJeitgHsJXgJyNagyDJBgZJDrgsVJQgkEJNgkjSJgJFAHgFCJDgFZtMVJXNFVXQfXVJXDJVXoQJVQVJQVDEfXVDvJHVEqNFVeQfXVHpJFVHxfXVVJSRVVmaRVlIJOhCXVJhHjYkhxCJVhWVUJhWiJcxBNJIxeEqDxfXBFxcFEPxFSJFxFYJXyBDQJydaUJyFOPDuYCJYuLvJRuHLJXuZJLDuFOPDuFZJHuFcqXmKHJdmCQJcmOsVJiJAGFitLCFieOfXiestXiZJMEikNJQirXzFiFQqXiFIJFiFZJFiFvtFUHpJFUteIcUteOcUVCJkUhdHcUbEJEUJqXQUMNJhURjYkUFitFZDGJHZJIxDZJVJXZJFDJZJFpQvBNJBvBSJFvJxBrseQqDsVFVJdFLJDkEJNBkmNJYkFLJDoQJOPoGsJRoEAHBoEJfFbBQqDbBZJHbFVJXlFIJBjYIrXjeitcjjCEBjWMNBwXQfXwXOaFwDsJXwCJTRwrCZJMDNJQcDDJFcqDOPRYiJFTBsJXTQIJBTFEfXTFLJDrXEJFrEJXMrFZJFWEJdEWYTlm",
      // 7-kana words
      "ABCDEFACNJTRAMBDJdAcNJVXBLNJEBXSIdWRXErNJkXYDJMBXZJCJaXMNJaYKKVJKcKDEJqXKDcNJhKVJrNYKbgJVXKFVJSBNBYBwDNJeQfXNJeEqXNhGJWENJFiJRQlIJbEQJfXxDQqXcfXQFNDEJQFwXUJDYcnUJDJIBgQDIUJTRDJFEqDSJQSJFSJQIJFSOPeZtSJFZJHCJXQfXCTDEqFGJBSJFGJBOfXGJBcqXGJHNJDGJRLiJEJfXEqEJFEJPEFpBEJYJBZJFYBwXUJYiJMEBYJZJyTYTONJXpQMFXFpeGIDdpJFstXpJFcPDLBVSJRLHQJqXLJFZJFIJBNJDIJBUqXIBkFDJIJEJPTIYJGWRIJeQPDIJeEfHIJFsJXOqGDSFHXEJqXgJCsJCgGQJqXgdQYJEgFMFNBgJFcqDVJwXUJVJFZJchIgJCCxOEJqXxOwXUJyDJBVRuscisciJBiJBieUtqXiJFDJkiFsJXQUGEZJcUJFsJXZtXIrXZDZJDrZJFNJDZJFstXvJFQqXvJFCJEsJXQJqkhkNGBbDJdTRbYJMEBlDwXUJMEFiJFcfXNJDRcNJWMTBLJXC",
      // 8-kana words
      "BraFUtHBFSJFdbNBLJXVJQoYJNEBSJBEJfHSJHwXUJCJdAZJMGjaFVJXEJPNJBlEJfFiJFpFbFEJqIJBVJCrIBdHiJhOPFChvJVJZJNJWxGFNIFLueIBQJqUHEJfUFstOZJDrlXEASJRlXVJXSFwVJNJWD",
      // 9-kana words
      "QJEJNNJDQJEJIBSFQJEJxegBQJEJfHEPSJBmXEJFSJCDEJqXLXNJFQqXIcQsFNJFIFEJqXUJgFsJXIJBUJEJfHNFvJxEqXNJnXUJFQqD",
      // 10-kana words
      "IJBEJqXZJ"
    ];
    var mapping = "~~AzB~X~a~KN~Q~D~S~C~G~E~Y~p~L~I~O~eH~g~V~hxyumi~~U~~Z~~v~~s~~dkoblPjfnqwMcRTr~W~~~F~~~~~Jt";
    var wordlist = null;
    function hex(word) {
      return (0, bytes_1.hexlify)((0, strings_1.toUtf8Bytes)(word));
    }
    var KiYoKu = "0xe3818de38284e3818f";
    var KyoKu = "0xe3818de38283e3818f";
    function loadWords(lang) {
      if (wordlist !== null) {
        return;
      }
      wordlist = [];
      var transform = {};
      transform[(0, strings_1.toUtf8String)([227, 130, 154])] = false;
      transform[(0, strings_1.toUtf8String)([227, 130, 153])] = false;
      transform[(0, strings_1.toUtf8String)([227, 130, 133])] = (0, strings_1.toUtf8String)([227, 130, 134]);
      transform[(0, strings_1.toUtf8String)([227, 129, 163])] = (0, strings_1.toUtf8String)([227, 129, 164]);
      transform[(0, strings_1.toUtf8String)([227, 130, 131])] = (0, strings_1.toUtf8String)([227, 130, 132]);
      transform[(0, strings_1.toUtf8String)([227, 130, 135])] = (0, strings_1.toUtf8String)([227, 130, 136]);
      function normalize(word2) {
        var result = "";
        for (var i2 = 0; i2 < word2.length; i2++) {
          var kana = word2[i2];
          var target = transform[kana];
          if (target === false) {
            continue;
          }
          if (target) {
            kana = target;
          }
          result += kana;
        }
        return result;
      }
      function sortJapanese(a, b) {
        a = normalize(a);
        b = normalize(b);
        if (a < b) {
          return -1;
        }
        if (a > b) {
          return 1;
        }
        return 0;
      }
      for (var length_1 = 3; length_1 <= 9; length_1++) {
        var d = data[length_1 - 3];
        for (var offset = 0; offset < d.length; offset += length_1) {
          var word = [];
          for (var i = 0; i < length_1; i++) {
            var k = mapping.indexOf(d[offset + i]);
            word.push(227);
            word.push(k & 64 ? 130 : 129);
            word.push((k & 63) + 128);
          }
          wordlist.push((0, strings_1.toUtf8String)(word));
        }
      }
      wordlist.sort(sortJapanese);
      if (hex(wordlist[442]) === KiYoKu && hex(wordlist[443]) === KyoKu) {
        var tmp = wordlist[442];
        wordlist[442] = wordlist[443];
        wordlist[443] = tmp;
      }
      if (wordlist_1.Wordlist.check(lang) !== "0xcb36b09e6baa935787fd762ce65e80b0c6a8dabdfbc3a7f86ac0e2c4fd111600") {
        wordlist = null;
        throw new Error("BIP39 Wordlist for ja (Japanese) FAILED");
      }
    }
    var LangJa = (
      /** @class */
      function(_super) {
        __extends(LangJa2, _super);
        function LangJa2() {
          return _super.call(this, "ja") || this;
        }
        LangJa2.prototype.getWord = function(index) {
          loadWords(this);
          return wordlist[index];
        };
        LangJa2.prototype.getWordIndex = function(word) {
          loadWords(this);
          return wordlist.indexOf(word);
        };
        LangJa2.prototype.split = function(mnemonic) {
          wordlist_1.logger.checkNormalize();
          return mnemonic.split(/(?:\u3000| )+/g);
        };
        LangJa2.prototype.join = function(words) {
          return words.join("\u3000");
        };
        return LangJa2;
      }(wordlist_1.Wordlist)
    );
    var langJa = new LangJa();
    exports2.langJa = langJa;
    wordlist_1.Wordlist.register(langJa);
  }
});

// node_modules/@ethersproject/wordlists/lib/lang-ko.js
var require_lang_ko = __commonJS({
  "node_modules/@ethersproject/wordlists/lib/lang-ko.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.langKo = void 0;
    var strings_1 = require_lib9();
    var wordlist_1 = require_wordlist();
    var data = [
      "OYAa",
      "ATAZoATBl3ATCTrATCl8ATDloATGg3ATHT8ATJT8ATJl3ATLlvATLn4ATMT8ATMX8ATMboATMgoAToLbAToMTATrHgATvHnAT3AnAT3JbAT3MTAT8DbAT8JTAT8LmAT8MYAT8MbAT#LnAUHT8AUHZvAUJXrAUJX8AULnrAXJnvAXLUoAXLgvAXMn6AXRg3AXrMbAX3JTAX3QbAYLn3AZLgvAZrSUAZvAcAZ8AaAZ8AbAZ8AnAZ8HnAZ8LgAZ8MYAZ8MgAZ8OnAaAboAaDTrAaFTrAaJTrAaJboAaLVoAaMXvAaOl8AaSeoAbAUoAbAg8AbAl4AbGnrAbMT8AbMXrAbMn4AbQb8AbSV8AbvRlAb8AUAb8AnAb8HgAb8JTAb8NTAb8RbAcGboAcLnvAcMT8AcMX8AcSToAcrAaAcrFnAc8AbAc8MgAfGgrAfHboAfJnvAfLV8AfLkoAfMT8AfMnoAfQb8AfScrAfSgrAgAZ8AgFl3AgGX8AgHZvAgHgrAgJXoAgJX8AgJboAgLZoAgLn4AgOX8AgoATAgoAnAgoCUAgoJgAgoLXAgoMYAgoSeAgrDUAgrJTAhrFnAhrLjAhrQgAjAgoAjJnrAkMX8AkOnoAlCTvAlCV8AlClvAlFg4AlFl6AlFn3AloSnAlrAXAlrAfAlrFUAlrFbAlrGgAlrOXAlvKnAlvMTAl3AbAl3MnAnATrAnAcrAnCZ3AnCl8AnDg8AnFboAnFl3AnHX4AnHbrAnHgrAnIl3AnJgvAnLXoAnLX4AnLbrAnLgrAnLhrAnMXoAnMgrAnOn3AnSbrAnSeoAnvLnAn3OnCTGgvCTSlvCTvAUCTvKnCTvNTCT3CZCT3GUCT3MTCT8HnCUCZrCULf8CULnvCU3HnCU3JUCY6NUCbDb8CbFZoCbLnrCboOTCboScCbrFnCbvLnCb8AgCb8HgCb$LnCkLfoClBn3CloDUDTHT8DTLl3DTSU8DTrAaDTrLXDTrLjDTrOYDTrOgDTvFXDTvFnDT3HUDT3LfDUCT9DUDT4DUFVoDUFV8DUFkoDUGgrDUJnrDULl8DUMT8DUMXrDUMX4DUMg8DUOUoDUOgvDUOg8DUSToDUSZ8DbDXoDbDgoDbGT8DbJn3DbLg3DbLn4DbMXrDbMg8DbOToDboJXGTClvGTDT8GTFZrGTLVoGTLlvGTLl3GTMg8GTOTvGTSlrGToCUGTrDgGTrJYGTrScGTtLnGTvAnGTvQgGUCZrGUDTvGUFZoGUHXrGULnvGUMT8GUoMgGXoLnGXrMXGXrMnGXvFnGYLnvGZOnvGZvOnGZ8LaGZ8LmGbAl3GbDYvGbDlrGbHX3GbJl4GbLV8GbLn3GbMn4GboJTGboRfGbvFUGb3GUGb4JnGgDX3GgFl$GgJlrGgLX6GgLZoGgLf8GgOXoGgrAgGgrJXGgrMYGgrScGgvATGgvOYGnAgoGnJgvGnLZoGnLg3GnLnrGnQn8GnSbrGnrMgHTClvHTDToHTFT3HTQT8HToJTHToJgHTrDUHTrMnHTvFYHTvRfHT8MnHT8SUHUAZ8HUBb4HUDTvHUoMYHXFl6HXJX6HXQlrHXrAUHXrMnHXrSbHXvFYHXvKXHX3LjHX3MeHYvQlHZrScHZvDbHbAcrHbFT3HbFl3HbJT8HbLTrHbMT8HbMXrHbMbrHbQb8HbSX3HboDbHboJTHbrFUHbrHgHbrJTHb8JTHb8MnHb8QgHgAlrHgDT3HgGgrHgHgrHgJTrHgJT8HgLX@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",
      "ATLnDlATrAZoATrJX4ATrMT8ATrMX4ATrRTrATvDl8ATvJUoATvMl8AT3AToAT3MX8AT8CT3AT8DT8AT8HZrAT8HgoAUAgFnAUCTFnAXoMX8AXrAT8AXrGgvAXrJXvAXrOgoAXvLl3AZvAgoAZvFbrAZvJXoAZvJl8AZvJn3AZvMX8AZvSbrAZ8FZoAZ8LZ8AZ8MU8AZ8OTvAZ8SV8AZ8SX3AbAgFZAboJnoAbvGboAb8ATrAb8AZoAb8AgrAb8Al4Ab8Db8Ab8JnoAb8LX4Ab8LZrAb8LhrAb8MT8Ab8OUoAb8Qb8Ab8ST8AcrAUoAcrAc8AcrCZ3AcrFT3AcrFZrAcrJl4AcrJn3AcrMX3AcrOTvAc8AZ8Ac8MT8AfAcJXAgoFn4AgoGgvAgoGnrAgoLc8AgoMXoAgrLnrAkrSZ8AlFXCTAloHboAlrHbrAlrLhrAlrLkoAl3CZrAl3LUoAl3LZrAnrAl4AnrMT8An3HT4BT3IToBX4MnvBb!Ln$CTGXMnCToLZ4CTrHT8CT3JTrCT3RZrCT#GTvCU6GgvCU8Db8CU8GZrCU8HT8CboLl3CbrGgrCbrMU8Cb8DT3Cb8GnrCb8LX4Cb8MT8Cb8ObrCgrGgvCgrKX4Cl8FZoDTrAbvDTrDboDTrGT6DTrJgrDTrMX3DTrRZrDTrRg8DTvAVvDTvFZoDT3DT8DT3Ln3DT4HZrDT4MT8DT8AlrDT8MT8DUAkGbDUDbJnDYLnQlDbDUOYDbMTAnDbMXSnDboAT3DboFn4DboLnvDj6JTrGTCgFTGTGgFnGTJTMnGTLnPlGToJT8GTrCT3GTrLVoGTrLnvGTrMX3GTrMboGTvKl3GZClFnGZrDT3GZ8DTrGZ8FZ8GZ8MXvGZ8On8GZ8ST3GbCnQXGbMbFnGboFboGboJg3GboMXoGb3JTvGb3JboGb3Mn6Gb3Qb8GgDXLjGgMnAUGgrDloGgrHX4GgrSToGgvAXrGgvAZvGgvFbrGgvLl3GgvMnvGnDnLXGnrATrGnrMboGnuLl3HTATMnHTAgCnHTCTCTHTrGTvHTrHTvHTrJX8HTrLl8HTrMT8HTrMgoHTrOTrHTuOn3HTvAZrHTvDTvHTvGboHTvJU8HTvLl3HTvMXrHTvQb4HT4GT6HT4JT8HT4Jb#HT8Al3HT8GZrHT8GgrHT8HX4HT8Jb8HT8JnoHT8LTrHT8LgvHT8SToHT8SV8HUoJUoHUoJX8HUoLnrHXrLZoHXvAl3HX3LnrHX4FkvHX4LhrHX4MXoHX4OnoHZrAZ8HZrDb8HZrGZ8HZrJnrHZvGZ8HZvLnvHZ8JnvHZ8LhrHbCXJlHbMTAnHboJl4HbpLl3HbrJX8HbrLnrHbrMnvHbvRYrHgoSTrHgrFV8HgrGZ8HgrJXoHgrRnvHgvBb!HgvGTrHgvHX4HgvHn!HgvLTrHgvSU8HnDnLbHnFbJbHnvDn8Hn6GgvHn!BTvJTCTLnJTQgFnJTrAnvJTrLX4JTrOUoJTvFn3JTvLnrJTvNToJT3AgoJT3Jn4JT3LhvJT3ObrJT8AcrJT8Al3JT8JT8JT8JnoJT8LX4JT8LnrJT8MX3JT8Rg3JT8Sc8JUoBTvJU8AToJU8GZ8JU8GgvJU8JTrJU8JXrJU8JnrJU8LnvJU8ScvJXHnJlJXrGgvJXrJU8JXrLhrJXrMT8JXrMXrJXrQUoJXvCTvJXvGZ8JXvGgrJXvQT8JX8Ab8JX8DT8JX8GZ8JX8HZvJX8LnrJX8MT8JX8MXoJX8MnvJX8ST3JYGnCTJbAkGbJbCTAnJbLTAcJboDT3JboLb6JbrAnvJbrCn3JbrDl8JbrGboJbrIZoJbrJnvJbrMnvJbrQb4Jb8RZrJeAbAnJgJnFbJgScAnJgrATrJgvHZ8JgvMn4JlJlFbJlLiQXJlLjOnJlRbOlJlvNXoJlvRl3Jl4AcrJl8AUoJl8MnrJnFnMlJnHgGbJnoDT8JnoFV8JnoGgvJnoIT8JnoQToJnoRg3JnrCZ3JnrGgrJnrHTvJnrLf8JnrOX8JnvAT3JnvFZoJnvGT8JnvJl4JnvMT8JnvMX8JnvOXrJnvPX6JnvSX3JnvSZrJn3MT8Jn3MX8Jn3RTrLTATKnLTJnLTLTMXKnLTRTQlLToGb8LTrAZ8LTrCZ8LTrDb8LTrHT8LT3PX6LT4FZoLT$CTvLT$GgrLUvHX3LVoATrLVoAgoLVoJboLVoMX3LVoRg3LV8CZ3LV8FZoLV8GTvLXrDXoLXrFbrLXvAgvLXvFlrLXvLl3LXvRn6LX4Mb8LX8GT8LYCXMnLYrMnrLZoSTvLZrAZvLZrAloLZrFToLZrJXvLZrJboLZrJl4LZrLnrLZrMT8LZrOgvLZrRnvLZrST4LZvMX8LZvSlvLZ8AgoLZ8CT3LZ8JT8LZ8LV8LZ8LZoLZ8Lg8LZ8SV8LZ8SbrLZ$HT8LZ$Mn4La6CTvLbFbMnLbRYFTLbSnFZLboJT8LbrAT9LbrGb3LbrQb8LcrJX8LcrMXrLerHTvLerJbrLerNboLgrDb8LgrGZ8LgrHTrLgrMXrLgrSU8LgvJTrLgvLl3Lg6Ll3LhrLnrLhrMT8LhvAl4LiLnQXLkoAgrLkoJT8LkoJn4LlrSU8Ll3FZoLl3HTrLl3JX8Ll3JnoLl3LToLmLeFbLnDUFbLnLVAnLnrATrLnrAZoLnrAb8LnrAlrLnrGgvLnrJU8LnrLZrLnrLhrLnrMb8LnrOXrLnrSZ8LnvAb4LnvDTrLnvDl8LnvHTrLnvHbrLnvJT8LnvJU8LnvJbrLnvLhvLnvMX8LnvMb8LnvNnoLnvSU8Ln3Al3Ln4FZoLn4GT6Ln4JgvLn4LhrLn4MT8Ln4SToMToCZrMToJX8MToLX4MToLf8MToRg3MTrEloMTvGb6MT3BTrMT3Lb6MT8AcrMT8AgrMT8GZrMT8JnoMT8LnrMT8MX3MUOUAnMXAbFnMXoAloMXoJX8MXoLf8MXoLl8MXrAb8MXrDTvMXrGT8MXrGgrMXrHTrMXrLf8MXrMU8MXrOXvMXrQb8MXvGT8MXvHTrMXvLVoMX3AX3MX3Jn3MX3LhrMX3MX3MX4AlrMX4OboMX8GTvMX8GZrMX8GgrMX8JT8MX8JX8MX8LhrMX8MT8MYDUFbMYMgDbMbGnFfMbvLX4MbvLl3Mb8Mb8Mb8ST4MgGXCnMg8ATrMg8AgoMg8CZrMg8DTrMg8DboMg8HTrMg8JgrMg8LT8MloJXoMl8AhrMl8JT8MnLgAUMnoJXrMnoLX4MnoLhrMnoMT8MnrAl4MnrDb8MnrOTvMnrOgvMnrQb8MnrSU8MnvGgrMnvHZ8Mn3MToMn4DTrMn4LTrMn4Mg8NnBXAnOTFTFnOToAToOTrGgvOTrJX8OT3JXoOT6MTrOT8GgrOT8HTpOT8MToOUoHT8OUoJT8OUoLn3OXrAgoOXrDg8OXrMT8OXvSToOX6CTvOX8CZrOX8OgrOb6HgvOb8AToOb8MT8OcvLZ8OgvAlrOgvHTvOgvJTrOgvJnrOgvLZrOgvLn4OgvMT8OgvRTrOg8AZoOg8DbvOnrOXoOnvJn4OnvLhvOnvRTrOn3GgoOn3JnvOn6JbvOn8OTrPTGYFTPbBnFnPbGnDnPgDYQTPlrAnvPlrETvPlrLnvPlrMXvPlvFX4QTMTAnQTrJU8QYCnJlQYJlQlQbGTQbQb8JnrQb8LZoQb8LnvQb8MT8Qb8Ml8Qb8ST4QloAl4QloHZvQloJX8QloMn8QnJZOlRTrAZvRTrDTrRTvJn4RTvLhvRT4Jb8RZrAZrRZ8AkrRZ8JU8RZ8LV8RZ8LnvRbJlQXRg3GboRg3MnvRg8AZ8Rg8JboRg8Jl4RnLTCbRnvFl3RnvQb8SToAl4SToCZrSToFZoSToHXrSToJU8SToJgvSToJl4SToLhrSToMX3STrAlvSTrCT9STrCgrSTrGgrSTrHXrSTrHboSTrJnoSTrNboSTvLnrST4AZoST8Ab8ST8JT8SUoJn3SU6HZ#SU6JTvSU8Db8SU8HboSU8LgrSV8JT8SZrAcrSZrAl3SZrJT8SZrJnvSZrMT8SZvLUoSZ4FZoSZ8JnoSZ8RZrScoLnrScoMT8ScoMX8ScrAT4ScrAZ8ScrLZ8ScrLkvScvDb8ScvLf8ScvNToSgrFZrShvKnrSloHUoSloLnrSlrMXoSl8HgrSmrJUoSn3BX6",
      "ATFlOn3ATLgrDYAT4MTAnAT8LTMnAYJnRTrAbGgJnrAbLV8LnAbvNTAnAeFbLg3AgOYMXoAlQbFboAnDboAfAnJgoJTBToDgAnBUJbAl3BboDUAnCTDlvLnCTFTrSnCYoQTLnDTwAbAnDUDTrSnDUHgHgrDX8LXFnDbJXAcrETvLTLnGTFTQbrGTMnGToGT3DUFbGUJlPX3GbQg8LnGboJbFnGb3GgAYGgAg8ScGgMbAXrGgvAbAnGnJTLnvGnvATFgHTDT6ATHTrDlJnHYLnMn8HZrSbJTHZ8LTFnHbFTJUoHgSeMT8HgrLjAnHgvAbAnHlFUrDlHnDgvAnHnHTFT3HnQTGnrJTAaMXvJTGbCn3JTOgrAnJXvAXMnJbMg8SnJbMnRg3Jb8LTMnJnAl3OnJnGYrQlJnJlQY3LTDlCn3LTJjLg3LTLgvFXLTMg3GTLV8HUOgLXFZLg3LXNXrMnLX8QXFnLX9AlMYLYLXPXrLZAbJU8LZDUJU8LZMXrSnLZ$AgFnLaPXrDULbFYrMnLbMn8LXLboJgJgLeFbLg3LgLZrSnLgOYAgoLhrRnJlLkCTrSnLkOnLhrLnFX%AYLnFZoJXLnHTvJbLnLloAbMTATLf8MTHgJn3MTMXrAXMT3MTFnMUITvFnMXFX%AYMXMXvFbMXrFTDbMYAcMX3MbLf8SnMb8JbFnMgMXrMTMgvAXFnMgvGgCmMnAloSnMnFnJTrOXvMXSnOX8HTMnObJT8ScObLZFl3ObMXCZoPTLgrQXPUFnoQXPU3RXJlPX3RkQXPbrJXQlPlrJbFnQUAhrDbQXGnCXvQYLnHlvQbLfLnvRTOgvJbRXJYrQlRYLnrQlRbLnrQlRlFT8JlRlFnrQXSTClCn3STHTrAnSTLZQlrSTMnGTrSToHgGbSTrGTDnSTvGXCnST3HgFbSU3HXAXSbAnJn3SbFT8LnScLfLnv",
      "AT3JgJX8AT8FZoSnAT8JgFV8AT8LhrDbAZ8JT8DbAb8GgLhrAb8SkLnvAe8MT8SnAlMYJXLVAl3GYDTvAl3LfLnvBUDTvLl3CTOn3HTrCT3DUGgrCU8MT8AbCbFTrJUoCgrDb8MTDTLV8JX8DTLnLXQlDT8LZrSnDUQb8FZ8DUST4JnvDb8ScOUoDj6GbJl4GTLfCYMlGToAXvFnGboAXvLnGgAcrJn3GgvFnSToGnLf8JnvGn#HTDToHTLnFXJlHTvATFToHTvHTDToHTvMTAgoHT3STClvHT4AlFl6HT8HTDToHUoDgJTrHUoScMX3HbRZrMXoHboJg8LTHgDb8JTrHgMToLf8HgvLnLnoHnHn3HT4Hn6MgvAnJTJU8ScvJT3AaQT8JT8HTrAnJXrRg8AnJbAloMXoJbrATFToJbvMnoSnJgDb6GgvJgDb8MXoJgSX3JU8JguATFToJlPYLnQlJlQkDnLbJlQlFYJlJl8Lf8OTJnCTFnLbJnLTHXMnJnLXGXCnJnoFfRg3JnrMYRg3Jn3HgFl3KT8Dg8LnLTRlFnPTLTvPbLbvLVoSbrCZLXMY6HT3LXNU7DlrLXNXDTATLX8DX8LnLZDb8JU8LZMnoLhrLZSToJU8LZrLaLnrLZvJn3SnLZ8LhrSnLaJnoMT8LbFlrHTvLbrFTLnrLbvATLlvLb6OTFn3LcLnJZOlLeAT6Mn4LeJT3ObrLg6LXFlrLhrJg8LnLhvDlPX4LhvLfLnvLj6JTFT3LnFbrMXoLnQluCTvLnrQXCY6LnvLfLnvLnvMgLnvLnvSeLf8MTMbrJn3MT3JgST3MT8AnATrMT8LULnrMUMToCZrMUScvLf8MXoDT8SnMX6ATFToMX8AXMT8MX8FkMT8MX8HTrDUMX8ScoSnMYJT6CTvMgAcrMXoMg8SToAfMlvAXLg3MnFl3AnvOT3AnFl3OUoATHT8OU3RnLXrOXrOXrSnObPbvFn6Og8HgrSnOg8OX8DbPTvAgoJgPU3RYLnrPXrDnJZrPb8CTGgvPlrLTDlvPlvFUJnoQUvFXrQlQeMnoAl3QlrQlrSnRTFTrJUoSTDlLiLXSTFg6HT3STJgoMn4STrFTJTrSTrLZFl3ST4FnMXoSUrDlHUoScvHTvSnSfLkvMXo",
      "AUoAcrMXoAZ8HboAg8AbOg6ATFgAg8AloMXoAl3AT8JTrAl8MX8MXoCT3SToJU8Cl8Db8MXoDT8HgrATrDboOT8MXoGTOTrATMnGT8LhrAZ8GnvFnGnQXHToGgvAcrHTvAXvLl3HbrAZoMXoHgBlFXLg3HgMnFXrSnHgrSb8JUoHn6HT8LgvITvATrJUoJUoLZrRnvJU8HT8Jb8JXvFX8QT8JXvLToJTrJYrQnGnQXJgrJnoATrJnoJU8ScvJnvMnvMXoLTCTLgrJXLTJlRTvQlLbRnJlQYvLbrMb8LnvLbvFn3RnoLdCVSTGZrLeSTvGXCnLg3MnoLn3MToLlrETvMT8SToAl3MbrDU6GTvMb8LX4LhrPlrLXGXCnSToLf8Rg3STrDb8LTrSTvLTHXMnSb3RYLnMnSgOg6ATFg",
      "HUDlGnrQXrJTrHgLnrAcJYMb8DULc8LTvFgGnCk3Mg8JbAnLX4QYvFYHnMXrRUoJnGnvFnRlvFTJlQnoSTrBXHXrLYSUJgLfoMT8Se8DTrHbDb",
      "AbDl8SToJU8An3RbAb8ST8DUSTrGnrAgoLbFU6Db8LTrMg8AaHT8Jb8ObDl8SToJU8Pb3RlvFYoJl"
    ];
    var codes = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*";
    function getHangul(code) {
      if (code >= 40) {
        code = code + 168 - 40;
      } else if (code >= 19) {
        code = code + 97 - 19;
      }
      return (0, strings_1.toUtf8String)([225, (code >> 6) + 132, (code & 63) + 128]);
    }
    var wordlist = null;
    function loadWords(lang) {
      if (wordlist != null) {
        return;
      }
      wordlist = [];
      data.forEach(function(data2, length) {
        length += 4;
        for (var i = 0; i < data2.length; i += length) {
          var word = "";
          for (var j = 0; j < length; j++) {
            word += getHangul(codes.indexOf(data2[i + j]));
          }
          wordlist.push(word);
        }
      });
      wordlist.sort();
      if (wordlist_1.Wordlist.check(lang) !== "0xf9eddeace9c5d3da9c93cf7d3cd38f6a13ed3affb933259ae865714e8a3ae71a") {
        wordlist = null;
        throw new Error("BIP39 Wordlist for ko (Korean) FAILED");
      }
    }
    var LangKo = (
      /** @class */
      function(_super) {
        __extends(LangKo2, _super);
        function LangKo2() {
          return _super.call(this, "ko") || this;
        }
        LangKo2.prototype.getWord = function(index) {
          loadWords(this);
          return wordlist[index];
        };
        LangKo2.prototype.getWordIndex = function(word) {
          loadWords(this);
          return wordlist.indexOf(word);
        };
        return LangKo2;
      }(wordlist_1.Wordlist)
    );
    var langKo = new LangKo();
    exports2.langKo = langKo;
    wordlist_1.Wordlist.register(langKo);
  }
});

// node_modules/@ethersproject/wordlists/lib/lang-it.js
var require_lang_it = __commonJS({
  "node_modules/@ethersproject/wordlists/lib/lang-it.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.langIt = void 0;
    var wordlist_1 = require_wordlist();
    var words = "AbacoAbbaglioAbbinatoAbeteAbissoAbolireAbrasivoAbrogatoAccadereAccennoAccusatoAcetoneAchilleAcidoAcquaAcreAcrilicoAcrobataAcutoAdagioAddebitoAddomeAdeguatoAderireAdipeAdottareAdulareAffabileAffettoAffissoAffrantoAforismaAfosoAfricanoAgaveAgenteAgevoleAggancioAgireAgitareAgonismoAgricoloAgrumetoAguzzoAlabardaAlatoAlbatroAlberatoAlboAlbumeAlceAlcolicoAlettoneAlfaAlgebraAlianteAlibiAlimentoAllagatoAllegroAllievoAllodolaAllusivoAlmenoAlogenoAlpacaAlpestreAltalenaAlternoAlticcioAltroveAlunnoAlveoloAlzareAmalgamaAmanitaAmarenaAmbitoAmbratoAmebaAmericaAmetistaAmicoAmmassoAmmendaAmmirareAmmonitoAmoreAmpioAmpliareAmuletoAnacardoAnagrafeAnalistaAnarchiaAnatraAncaAncellaAncoraAndareAndreaAnelloAngeloAngolareAngustoAnimaAnnegareAnnidatoAnnoAnnuncioAnonimoAnticipoAnziApaticoAperturaApodeApparireAppetitoAppoggioApprodoAppuntoAprileArabicaArachideAragostaAraldicaArancioAraturaArazzoArbitroArchivioArditoArenileArgentoArgineArgutoAriaArmoniaArneseArredatoArringaArrostoArsenicoArsoArteficeArzilloAsciuttoAscoltoAsepsiAsetticoAsfaltoAsinoAsolaAspiratoAsproAssaggioAsseAssolutoAssurdoAstaAstenutoAsticeAstrattoAtavicoAteismoAtomicoAtonoAttesaAttivareAttornoAttritoAttualeAusilioAustriaAutistaAutonomoAutunnoAvanzatoAvereAvvenireAvvisoAvvolgereAzioneAzotoAzzimoAzzurroBabeleBaccanoBacinoBacoBadessaBadilataBagnatoBaitaBalconeBaldoBalenaBallataBalzanoBambinoBandireBaraondaBarbaroBarcaBaritonoBarlumeBaroccoBasilicoBassoBatostaBattutoBauleBavaBavosaBeccoBeffaBelgioBelvaBendaBenevoleBenignoBenzinaBereBerlinaBetaBibitaBiciBidoneBifidoBigaBilanciaBimboBinocoloBiologoBipedeBipolareBirbanteBirraBiscottoBisestoBisnonnoBisonteBisturiBizzarroBlandoBlattaBollitoBonificoBordoBoscoBotanicoBottinoBozzoloBraccioBradipoBramaBrancaBravuraBretellaBrevettoBrezzaBrigliaBrillanteBrindareBroccoloBrodoBronzinaBrulloBrunoBubboneBucaBudinoBuffoneBuioBulboBuonoBurloneBurrascaBussolaBustaCadettoCaducoCalamaroCalcoloCalesseCalibroCalmoCaloriaCambusaCamerataCamiciaCamminoCamolaCampaleCanapaCandelaCaneCaninoCanottoCantinaCapaceCapelloCapitoloCapogiroCapperoCapraCapsulaCarapaceCarcassaCardoCarismaCarovanaCarrettoCartolinaCasaccioCascataCasermaCasoCassoneCastelloCasualeCatastaCatenaCatrameCautoCavilloCedibileCedrataCefaloCelebreCellulareCenaCenoneCentesimoCeramicaCercareCertoCerumeCervelloCesoiaCespoCetoChelaChiaroChiccaChiedereChimeraChinaChirurgoChitarraCiaoCiclismoCifrareCignoCilindroCiottoloCircaCirrosiCitricoCittadinoCiuffoCivettaCivileClassicoClinicaCloroCoccoCodardoCodiceCoerenteCognomeCollareColmatoColoreColposoColtivatoColzaComaCometaCommandoComodoComputerComuneConcisoCondurreConfermaCongelareConiugeConnessoConoscereConsumoContinuoConvegnoCopertoCopioneCoppiaCopricapoCorazzaCordataCoricatoCorniceCorollaCorpoCorredoCorsiaCorteseCosmicoCostanteCotturaCovatoCratereCravattaCreatoCredereCremosoCrescitaCretaCricetoCrinaleCrisiCriticoCroceCronacaCrostataCrucialeCruscaCucireCuculoCuginoCullatoCupolaCuratoreCursoreCurvoCuscinoCustodeDadoDainoDalmataDamerinoDanielaDannosoDanzareDatatoDavantiDavveroDebuttoDecennioDecisoDeclinoDecolloDecretoDedicatoDefinitoDeformeDegnoDelegareDelfinoDelirioDeltaDemenzaDenotatoDentroDepositoDerapataDerivareDerogaDescrittoDesertoDesiderioDesumereDetersivoDevotoDiametroDicembreDiedroDifesoDiffusoDigerireDigitaleDiluvioDinamicoDinnanziDipintoDiplomaDipoloDiradareDireDirottoDirupoDisagioDiscretoDisfareDisgeloDispostoDistanzaDisumanoDitoDivanoDiveltoDividereDivoratoDobloneDocenteDoganaleDogmaDolceDomatoDomenicaDominareDondoloDonoDormireDoteDottoreDovutoDozzinaDragoDruidoDubbioDubitareDucaleDunaDuomoDupliceDuraturoEbanoEccessoEccoEclissiEconomiaEderaEdicolaEdileEditoriaEducareEgemoniaEgliEgoismoEgregioElaboratoElargireEleganteElencatoElettoElevareElficoElicaElmoElsaElusoEmanatoEmblemaEmessoEmiroEmotivoEmozioneEmpiricoEmuloEndemicoEnduroEnergiaEnfasiEnotecaEntrareEnzimaEpatiteEpilogoEpisodioEpocaleEppureEquatoreErarioErbaErbosoEredeEremitaErigereErmeticoEroeErosivoErranteEsagonoEsameEsanimeEsaudireEscaEsempioEsercitoEsibitoEsigenteEsistereEsitoEsofagoEsortatoEsosoEspansoEspressoEssenzaEssoEstesoEstimareEstoniaEstrosoEsultareEtilicoEtnicoEtruscoEttoEuclideoEuropaEvasoEvidenzaEvitatoEvolutoEvvivaFabbricaFaccendaFachiroFalcoFamigliaFanaleFanfaraFangoFantasmaFareFarfallaFarinosoFarmacoFasciaFastosoFasulloFaticareFatoFavolosoFebbreFecolaFedeFegatoFelpaFeltroFemminaFendereFenomenoFermentoFerroFertileFessuraFestivoFettaFeudoFiabaFiduciaFifaFiguratoFiloFinanzaFinestraFinireFioreFiscaleFisicoFiumeFlaconeFlamencoFleboFlemmaFloridoFluenteFluoroFobicoFocacciaFocosoFoderatoFoglioFolataFolcloreFolgoreFondenteFoneticoFoniaFontanaForbitoForchettaForestaFormicaFornaioForoFortezzaForzareFosfatoFossoFracassoFranaFrassinoFratelloFreccettaFrenataFrescoFrigoFrollinoFrondeFrugaleFruttaFucilataFucsiaFuggenteFulmineFulvoFumanteFumettoFumosoFuneFunzioneFuocoFurboFurgoneFuroreFusoFutileGabbianoGaffeGalateoGallinaGaloppoGamberoGammaGaranziaGarboGarofanoGarzoneGasdottoGasolioGastricoGattoGaudioGazeboGazzellaGecoGelatinaGelsoGemelloGemmatoGeneGenitoreGennaioGenotipoGergoGhepardoGhiaccioGhisaGialloGildaGineproGiocareGioielloGiornoGioveGiratoGironeGittataGiudizioGiuratoGiustoGlobuloGlutineGnomoGobbaGolfGomitoGommoneGonfioGonnaGovernoGracileGradoGraficoGrammoGrandeGrattareGravosoGraziaGrecaGreggeGrifoneGrigioGrinzaGrottaGruppoGuadagnoGuaioGuantoGuardareGufoGuidareIbernatoIconaIdenticoIdillioIdoloIdraIdricoIdrogenoIgieneIgnaroIgnoratoIlareIllesoIllogicoIlludereImballoImbevutoImboccoImbutoImmaneImmersoImmolatoImpaccoImpetoImpiegoImportoImprontaInalareInarcareInattivoIncantoIncendioInchinoIncisivoInclusoIncontroIncrocioIncuboIndagineIndiaIndoleIneditoInfattiInfilareInflittoIngaggioIngegnoIngleseIngordoIngrossoInnescoInodoreInoltrareInondatoInsanoInsettoInsiemeInsonniaInsulinaIntasatoInteroIntonacoIntuitoInumidireInvalidoInveceInvitoIperboleIpnoticoIpotesiIppicaIrideIrlandaIronicoIrrigatoIrrorareIsolatoIsotopoIstericoIstitutoIstriceItaliaIterareLabbroLabirintoLaccaLaceratoLacrimaLacunaLaddoveLagoLampoLancettaLanternaLardosoLargaLaringeLastraLatenzaLatinoLattugaLavagnaLavoroLegaleLeggeroLemboLentezzaLenzaLeoneLepreLesivoLessatoLestoLetteraleLevaLevigatoLiberoLidoLievitoLillaLimaturaLimitareLimpidoLineareLinguaLiquidoLiraLiricaLiscaLiteLitigioLivreaLocandaLodeLogicaLombareLondraLongevoLoquaceLorenzoLotoLotteriaLuceLucidatoLumacaLuminosoLungoLupoLuppoloLusingaLussoLuttoMacabroMacchinaMaceroMacinatoMadamaMagicoMagliaMagneteMagroMaiolicaMalafedeMalgradoMalintesoMalsanoMaltoMalumoreManaManciaMandorlaMangiareManifestoMannaroManovraMansardaMantideManubrioMappaMaratonaMarcireMarettaMarmoMarsupioMascheraMassaiaMastinoMaterassoMatricolaMattoneMaturoMazurcaMeandroMeccanicoMecenateMedesimoMeditareMegaMelassaMelisMelodiaMeningeMenoMensolaMercurioMerendaMerloMeschinoMeseMessereMestoloMetalloMetodoMettereMiagolareMicaMicelioMicheleMicroboMidolloMieleMiglioreMilanoMiliteMimosaMineraleMiniMinoreMirinoMirtilloMiscelaMissivaMistoMisurareMitezzaMitigareMitraMittenteMnemonicoModelloModificaModuloMoganoMogioMoleMolossoMonasteroMoncoMondinaMonetarioMonileMonotonoMonsoneMontatoMonvisoMoraMordereMorsicatoMostroMotivatoMotosegaMottoMovenzaMovimentoMozzoMuccaMucosaMuffaMughettoMugnaioMulattoMulinelloMultiploMummiaMuntoMuovereMuraleMusaMuscoloMusicaMutevoleMutoNababboNaftaNanometroNarcisoNariceNarratoNascereNastrareNaturaleNauticaNaviglioNebulosaNecrosiNegativoNegozioNemmenoNeofitaNerettoNervoNessunoNettunoNeutraleNeveNevroticoNicchiaNinfaNitidoNobileNocivoNodoNomeNominaNordicoNormaleNorvegeseNostranoNotareNotiziaNotturnoNovellaNucleoNullaNumeroNuovoNutrireNuvolaNuzialeOasiObbedireObbligoObeliscoOblioOboloObsoletoOccasioneOcchioOccidenteOccorrereOccultareOcraOculatoOdiernoOdorareOffertaOffrireOffuscatoOggettoOggiOgnunoOlandeseOlfattoOliatoOlivaOlogrammaOltreOmaggioOmbelicoOmbraOmegaOmissioneOndosoOnereOniceOnnivoroOnorevoleOntaOperatoOpinioneOppostoOracoloOrafoOrdineOrecchinoOreficeOrfanoOrganicoOrigineOrizzonteOrmaOrmeggioOrnativoOrologioOrrendoOrribileOrtensiaOrticaOrzataOrzoOsareOscurareOsmosiOspedaleOspiteOssaOssidareOstacoloOsteOtiteOtreOttagonoOttimoOttobreOvaleOvestOvinoOviparoOvocitoOvunqueOvviareOzioPacchettoPacePacificoPadellaPadronePaesePagaPaginaPalazzinaPalesarePallidoPaloPaludePandoroPannelloPaoloPaonazzoPapricaParabolaParcellaParerePargoloPariParlatoParolaPartireParvenzaParzialePassivoPasticcaPataccaPatologiaPattumePavonePeccatoPedalarePedonalePeggioPelosoPenarePendicePenisolaPennutoPenombraPensarePentolaPepePepitaPerbenePercorsoPerdonatoPerforarePergamenaPeriodoPermessoPernoPerplessoPersuasoPertugioPervasoPesatorePesistaPesoPestiferoPetaloPettinePetulantePezzoPiacerePiantaPiattinoPiccinoPicozzaPiegaPietraPifferoPigiamaPigolioPigroPilaPiliferoPillolaPilotaPimpantePinetaPinnaPinoloPioggiaPiomboPiramidePireticoPiritePirolisiPitonePizzicoPlaceboPlanarePlasmaPlatanoPlenarioPochezzaPoderosoPodismoPoesiaPoggiarePolentaPoligonoPollicePolmonitePolpettaPolsoPoltronaPolverePomicePomodoroPontePopolosoPorfidoPorosoPorporaPorrePortataPosaPositivoPossessoPostulatoPotassioPoterePranzoPrassiPraticaPreclusoPredicaPrefissoPregiatoPrelievoPremerePrenotarePreparatoPresenzaPretestoPrevalsoPrimaPrincipePrivatoProblemaProcuraProdurreProfumoProgettoProlungaPromessaPronomePropostaProrogaProtesoProvaPrudentePrugnaPruritoPsichePubblicoPudicaPugilatoPugnoPulcePulitoPulsantePuntarePupazzoPupillaPuroQuadroQualcosaQuasiQuerelaQuotaRaccoltoRaddoppioRadicaleRadunatoRafficaRagazzoRagioneRagnoRamarroRamingoRamoRandagioRantolareRapatoRapinaRappresoRasaturaRaschiatoRasenteRassegnaRastrelloRataRavvedutoRealeRecepireRecintoReclutaReconditoRecuperoRedditoRedimereRegalatoRegistroRegolaRegressoRelazioneRemareRemotoRennaReplicaReprimereReputareResaResidenteResponsoRestauroReteRetinaRetoricaRettificaRevocatoRiassuntoRibadireRibelleRibrezzoRicaricaRiccoRicevereRiciclatoRicordoRicredutoRidicoloRidurreRifasareRiflessoRiformaRifugioRigareRigettatoRighelloRilassatoRilevatoRimanereRimbalzoRimedioRimorchioRinascitaRincaroRinforzoRinnovoRinomatoRinsavitoRintoccoRinunciaRinvenireRiparatoRipetutoRipienoRiportareRipresaRipulireRisataRischioRiservaRisibileRisoRispettoRistoroRisultatoRisvoltoRitardoRitegnoRitmicoRitrovoRiunioneRivaRiversoRivincitaRivoltoRizomaRobaRoboticoRobustoRocciaRocoRodaggioRodereRoditoreRogitoRollioRomanticoRompereRonzioRosolareRospoRotanteRotondoRotulaRovescioRubizzoRubricaRugaRullinoRumineRumorosoRuoloRupeRussareRusticoSabatoSabbiareSabotatoSagomaSalassoSaldaturaSalgemmaSalivareSalmoneSaloneSaltareSalutoSalvoSapereSapidoSaporitoSaracenoSarcasmoSartoSassosoSatelliteSatiraSatolloSaturnoSavanaSavioSaziatoSbadiglioSbalzoSbancatoSbarraSbattereSbavareSbendareSbirciareSbloccatoSbocciatoSbrinareSbruffoneSbuffareScabrosoScadenzaScalaScambiareScandaloScapolaScarsoScatenareScavatoSceltoScenicoScettroSchedaSchienaSciarpaScienzaScindereScippoSciroppoScivoloSclerareScodellaScolpitoScompartoSconfortoScoprireScortaScossoneScozzeseScribaScrollareScrutinioScuderiaScultoreScuolaScuroScusareSdebitareSdoganareSeccaturaSecondoSedanoSeggiolaSegnalatoSegregatoSeguitoSelciatoSelettivoSellaSelvaggioSemaforoSembrareSemeSeminatoSempreSensoSentireSepoltoSequenzaSerataSerbatoSerenoSerioSerpenteSerraglioServireSestinaSetolaSettimanaSfaceloSfaldareSfamatoSfarzosoSfaticatoSferaSfidaSfilatoSfingeSfocatoSfoderareSfogoSfoltireSforzatoSfrattoSfruttatoSfuggitoSfumareSfusoSgabelloSgarbatoSgonfiareSgorbioSgrassatoSguardoSibiloSiccomeSierraSiglaSignoreSilenzioSillabaSimboloSimpaticoSimulatoSinfoniaSingoloSinistroSinoSintesiSinusoideSiparioSismaSistoleSituatoSlittaSlogaturaSlovenoSmarritoSmemoratoSmentitoSmeraldoSmilzoSmontareSmottatoSmussatoSnellireSnervatoSnodoSobbalzoSobrioSoccorsoSocialeSodaleSoffittoSognoSoldatoSolenneSolidoSollazzoSoloSolubileSolventeSomaticoSommaSondaSonettoSonniferoSopireSoppesoSopraSorgereSorpassoSorrisoSorsoSorteggioSorvolatoSospiroSostaSottileSpadaSpallaSpargereSpatolaSpaventoSpazzolaSpecieSpedireSpegnereSpelaturaSperanzaSpessoreSpettraleSpezzatoSpiaSpigolosoSpillatoSpinosoSpiraleSplendidoSportivoSposoSprangaSprecareSpronatoSpruzzoSpuntinoSquilloSradicareSrotolatoStabileStaccoStaffaStagnareStampatoStantioStarnutoStaseraStatutoSteloSteppaSterzoStilettoStimaStirpeStivaleStizzosoStonatoStoricoStrappoStregatoStriduloStrozzareStruttoStuccareStufoStupendoSubentroSuccosoSudoreSuggeritoSugoSultanoSuonareSuperboSupportoSurgelatoSurrogatoSussurroSuturaSvagareSvedeseSveglioSvelareSvenutoSveziaSviluppoSvistaSvizzeraSvoltaSvuotareTabaccoTabulatoTacciareTaciturnoTaleTalismanoTamponeTanninoTaraTardivoTargatoTariffaTarpareTartarugaTastoTatticoTavernaTavolataTazzaTecaTecnicoTelefonoTemerarioTempoTemutoTendoneTeneroTensioneTentacoloTeoremaTermeTerrazzoTerzettoTesiTesseratoTestatoTetroTettoiaTifareTigellaTimbroTintoTipicoTipografoTiraggioTiroTitanioTitoloTitubanteTizioTizzoneToccareTollerareToltoTombolaTomoTonfoTonsillaTopazioTopologiaToppaTorbaTornareTorroneTortoraToscanoTossireTostaturaTotanoTraboccoTracheaTrafilaTragediaTralcioTramontoTransitoTrapanoTrarreTraslocoTrattatoTraveTrecciaTremolioTrespoloTributoTrichecoTrifoglioTrilloTrinceaTrioTristezzaTrituratoTrivellaTrombaTronoTroppoTrottolaTrovareTruccatoTubaturaTuffatoTulipanoTumultoTunisiaTurbareTurchinoTutaTutelaUbicatoUccelloUccisoreUdireUditivoUffaUfficioUgualeUlisseUltimatoUmanoUmileUmorismoUncinettoUngereUnghereseUnicornoUnificatoUnisonoUnitarioUnteUovoUpupaUraganoUrgenzaUrloUsanzaUsatoUscitoUsignoloUsuraioUtensileUtilizzoUtopiaVacanteVaccinatoVagabondoVagliatoValangaValgoValicoVallettaValorosoValutareValvolaVampataVangareVanitosoVanoVantaggioVanveraVaporeVaranoVarcatoVarianteVascaVedettaVedovaVedutoVegetaleVeicoloVelcroVelinaVellutoVeloceVenatoVendemmiaVentoVeraceVerbaleVergognaVerificaVeroVerrucaVerticaleVescicaVessilloVestaleVeteranoVetrinaVetustoViandanteVibranteVicendaVichingoVicinanzaVidimareVigiliaVignetoVigoreVileVillanoViminiVincitoreViolaViperaVirgolaVirologoVirulentoViscosoVisioneVispoVissutoVisuraVitaVitelloVittimaVivandaVividoViziareVoceVogaVolatileVolereVolpeVoragineVulcanoZampognaZannaZappatoZatteraZavorraZefiroZelanteZeloZenzeroZerbinoZibettoZincoZirconeZittoZollaZoticoZuccheroZufoloZuluZuppa";
    var wordlist = null;
    function loadWords(lang) {
      if (wordlist != null) {
        return;
      }
      wordlist = words.replace(/([A-Z])/g, " $1").toLowerCase().substring(1).split(" ");
      if (wordlist_1.Wordlist.check(lang) !== "0x5c1362d88fd4cf614a96f3234941d29f7d37c08c5292fde03bf62c2db6ff7620") {
        wordlist = null;
        throw new Error("BIP39 Wordlist for it (Italian) FAILED");
      }
    }
    var LangIt = (
      /** @class */
      function(_super) {
        __extends(LangIt2, _super);
        function LangIt2() {
          return _super.call(this, "it") || this;
        }
        LangIt2.prototype.getWord = function(index) {
          loadWords(this);
          return wordlist[index];
        };
        LangIt2.prototype.getWordIndex = function(word) {
          loadWords(this);
          return wordlist.indexOf(word);
        };
        return LangIt2;
      }(wordlist_1.Wordlist)
    );
    var langIt = new LangIt();
    exports2.langIt = langIt;
    wordlist_1.Wordlist.register(langIt);
  }
});

// node_modules/@ethersproject/wordlists/lib/lang-zh.js
var require_lang_zh = __commonJS({
  "node_modules/@ethersproject/wordlists/lib/lang-zh.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.langZhTw = exports2.langZhCn = void 0;
    var strings_1 = require_lib9();
    var wordlist_1 = require_wordlist();
    var data = "}aE#4A=Yv&co#4N#6G=cJ&SM#66|/Z#4t&kn~46#4K~4q%b9=IR#7l,mB#7W_X2*dl}Uo~7s}Uf&Iw#9c&cw~6O&H6&wx&IG%v5=IQ~8a&Pv#47$PR&50%Ko&QM&3l#5f,D9#4L|/H&tQ;v0~6n]nN<di,AM=W5%QO&ka&ua,hM^tm=zV=JA=wR&+X]7P&NB#4J#5L|/b[dA}tJ<Do&6m&u2[U1&Kb.HM&mC=w0&MW<rY,Hq#6M}QG,13&wP}Jp]Ow%ue&Kg<HP<D9~4k~9T&I2_c6$9T#9/[C5~7O~4a=cs&O7=KK=An&l9$6U$8A&uD&QI|/Y&bg}Ux&F2#6b}E2&JN&kW&kp=U/&bb=Xl<Cj}k+~5J#6L&5z&9i}b4&Fo,ho(X0_g3~4O$Fz&QE<HN=Ww]6/%GF-Vw=tj&/D&PN#9g=YO}cL&Of&PI~5I&Ip=vU=IW#9G;0o-wU}ss&QR<BT&R9=tk$PY_dh&Pq-yh]7T,nj.Xu=EP&76=cI&Fs*Xg}z7$Gb&+I=DF,AF=cA}rL#7j=Dz&3y<Aa$52=PQ}b0(iY$Fa}oL&xV#6U=ec=WZ,xh%RY<dp#9N&Fl&44=WH*A7=sh&TB&8P=07;u+&PK}uh}J5#72)V/=xC,AB$k0&f6;1E|+5=1B,3v]6n&wR%b+&xx]7f=Ol}fl;+D^wG]7E;nB;uh^Ir&l5=JL,nS=cf=g5;u6|/Q$Gc=MH%Hg#5d%M6^86=U+$Gz,l/,ir^5y&Ba&/F-IY&FI&be%IZ#77&PW_Nu$kE(Yf&NX]7Z,Jy&FJ(Xo&Nz#/d=y7&MX<Ag}Z+;nE]Dt(iG#4D=13&Pj~4c%v8&Zo%OL&/X#4W<HR&ie~6J_1O(Y2=y5=Ad*cv_eB#6k&PX:BU#7A;uk&Ft&Fx_dD=U2;vB=U5=4F}+O&GN.HH:9s=b0%NV(jO&IH=JT}Z9=VZ<Af,Kx^4m&uJ%c6,6r;9m#+L}cf%Kh&F3~4H=vP}bu,Hz|++,1w]nv}k6;uu$jw*Kl*WX&uM[x7&Fr[m7$NO&QN]hu=JN}nR^8g#/h(ps|KC;vd}xz=V0}p6&FD$G1#7K<bG_4p~8g&cf;u4=tl}+k%5/}fz;uw<cA=u1}gU}VM=LJ=eX&+L&Pr#4U}p2:nC,2K]7H:jF&9x}uX#9O=MB<fz~8X~5m&4D&kN&u5%E/(h7(ZF&VG<de(qM|/e-Wt=3x(a+,/R]f/&ND$Ro&nU}0g=KA%kH&NK$Ke<dS}cB&IX~5g$TN]6m=Uv,Is&Py=Ef%Kz#+/%bi&+A<F4$OG&4C&FL#9V<Zk=2I_eE&6c]nw&kq$HG}y+&A8$P3}OH=XP]70%IS(AJ_gH%GZ&tY&AZ=vb~6y&/r=VI=Wv<Zi=fl=xf&eL}c8}OL=MJ=g8$F7=YT}9u=0+^xC}JH&nL^N0~4T]K2,Cy%OC#6s;vG(AC^xe^cG&MF}Br#9P;wD-7h$O/&xA}Fn^PC]6i]7G&8V$Qs;vl(TB~73~4l<mW&6V=2y&uY&+3)aP}XF;LP&kx$wU=t7;uy<FN&lz)7E=Oo*Y+;wI}9q}le;J6&Ri&4t&Qr#8B=cb&vG=J5|Ql(h5<Yy~4+}QD,Lx=wn%K/&RK=dO&Pw,Q9=co%4u;9u}g0@6a^4I%b0=zo|/c&tX=dQ=OS#+b=yz_AB&wB&Pm=W9$HP_gR=62=AO=ti=hI,oA&jr&dH=tm&b6$P2(x8=zi;nG~7F;05]0n[Ix&3m}rg=Xp=cd&uz]7t;97=cN;vV<jf&FF&F1=6Q&Ik*Kk&P4,2z=fQ]7D&3u,H0=d/}Uw<ZN<7R}Kv;0f$H7,MD]7n$F0#88~9Z%da=by;+T#/u=VF&fO&kr^kf<AB]sU,I5$Ng&Pz;0i&QD&vM=Yl:BM;nJ_xJ]U7&Kf&30,3f|Z9*dC)je_jA&Q4&Kp$NH(Yz#6S&Id%Ib=KX,AD=KV%dP}tW&Pk^+E_Ni=cq,3R}VZ(Si=b+}rv;0j}rZ]uA,/w(Sx&Jv$w9&4d&wE,NJ$Gy=J/]Ls#7k<ZQ<Y/&uj]Ov$PM;v3,2F&+u:up=On&3e,Jv;90=J+&Qm]6q}bK#+d~8Y(h2]hA;99&AS=I/}qB&dQ}yJ-VM}Vl&ui,iB&G3|Dc]7d=eQ%dX%JC_1L~4d^NP;vJ&/1)ZI#7N]9X[bQ&PL=0L(UZ,Lm&kc&IR}n7(iR<AQ<dg=33=vN}ft}au]7I,Ba=x9=dR~6R&Tq=Xi,3d$Nr&Bc}DI&ku&vf]Dn,/F&iD,Ll&Nw=0y&I7=Ls=/A&tU=Qe}Ua&uk&+F=g4=gh=Vj#+1&Qn}Uy*44#5F,Pc&Rz*Xn=oh=5W;0n_Nf(iE<Y7=vr=Zu]oz#5Z%mI=kN=Bv_Jp(T2;vt_Ml<FS&uI=L/&6P]64$M7}86<bo%QX(SI%IY&VK=Al&Ux;vv;ut*E/%uh<ZE|O3,M2(yc]yu=Wk&tp:Ex}hr,Cl&WE)+Z=8U}I2_4Q,hA_si=iw=OM=tM=yZ%Ia=U7;wT}b+;uo=Za}yS!5x}HD}fb#5O_dA;Nv%uB(yB;01(Sf}Fk;v7}Pt#8v<mZ#7L,/r&Pl~4w&f5=Ph$Fw_LF&8m,bL=yJ&BH}p/*Jn}tU~5Q;wB(h6]Df]8p^+B;E4&Wc=d+;Ea&bw$8C&FN,DM=Yf}mP~5w=fT#6V=mC=Fi=AV}jB&AN}lW}aH#/D)dZ;hl;vE}/7,CJ;31&w8,hj%u9_Js=jJ&4M~8k=TN&eC}nL&uc-wi&lX}dj=Mv=e2#6u=cr$uq$6G]8W}Jb:nm=Yg<b3(UA;vX&6n&xF=KT,jC,De&R8&oY=Zv&oB]7/=Z2&Oa}bf,hh(4h^tZ&72&Nx;D2&xL~5h~40)ZG)h+=OJ&RA]Bv$yB=Oq=df,AQ%Jn}OJ;11,3z&Tl&tj;v+^Hv,Dh(id=s+]7N&N3)9Q~8f,S4=uW=w4&uX,LX&3d]CJ&yp&8x<b2_do&lP=y/<cy_dG=Oi=7R(VH(lt_1T,Iq_AA;12^6T%k6#8K[B1{oO<AU[Bt;1b$9S&Ps<8T=St{bY,jB(Zp&63&Uv$9V,PM]6v&Af}zW[bW_oq}sm}nB&Kq&gC&ff_eq_2m&5F&TI}rf}Gf;Zr_z9;ER&jk}iz_sn<BN~+n&vo=Vi%97|ZR=Wc,WE&6t]6z%85(ly#84=KY)6m_5/=aX,N3}Tm&he&6K]tR_B2-I3;u/&hU&lH<AP=iB&IA=XL;/5&Nh=wv<BH#79=vS=zl<AA=0X_RG}Bw&9p$NW,AX&kP_Lp&/Z(Tc]Mu}hs#6I}5B&cI<bq&H9#6m=K9}vH(Y1(Y0#4B&w6,/9&gG<bE,/O=zb}I4_l8<B/;wL%Qo<HO[Mq=XX}0v&BP&F4(mG}0i}nm,EC=9u{I3,xG&/9=JY*DK&hR)BX=EI=cx=b/{6k}yX%A+&wa}Xb=la;wi^lL;0t}jo&Qb=xg=XB}iO<qo{bR=NV&8f=a0&Jy;0v=uK)HK;vN#6h&jB(h/%ud&NI%wY.X7=Pt}Cu-uL&Gs_hl%mH,tm]78=Lb^Q0#7Y=1u<Bt&+Q=Co_RH,w3;1e}ux<aU;ui}U3&Q5%bt]63&UQ|0l&uL}O7&3o,AV&dm|Nj(Xt*5+(Uu&Hh(p7(UF=VR=Bp^Jl&Hd[ix)9/=Iq]C8<67]66}mB%6f}bb}JI]8T$HA}db=YM&pa=2J}tS&Y0=PS&y4=cX$6E,hX,XP&nR;04,FQ&l0&Vm_Dv#5Y~8Z=Bi%MA]6x=JO:+p,Az&9q,Hj~6/}SD=K1:EJ}nA;Qo#/E]9R,Ie&6X%W3]61&v4=xX_MC=0q;06(Xq=fs}IG}Dv=0l}o7$iZ;9v&LH&DP-7a&OY,SZ,Kz,Cv&dh=fx|Nh,F/~7q=XF&w+;9n&Gw;0h}Z7<7O&JK(S7&LS<AD<ac=wo<Dt&zw%4B=4v#8P;9o~6p*vV=Tm,Or&I6=1q}nY=P0=gq&Bl&Uu,Ch%yb}UY=zh}dh}rl(T4_xk(YA#8R*xH,IN}Jn]7V}C4&Ty}j3]7p=cL=3h&wW%Qv<Z3=f0&RI&+S(ic_zq}oN&/Y=z1;Td=LW=0e=OI(Vc,+b^ju(UL;0r:Za%8v=Rp=zw&58&73&wK}qX]6y&8E)a2}WR=wP^ur&nQ<cH}Re=Aq&wk}Q0&+q=PP,Gc|/d^k5,Fw]8Y}Pg]p3=ju=ed}r5_yf&Cs]7z$/G<Cm&Jp&54_1G_gP_Ll}JZ;0u]k8_7k(Sg]65{9i=LN&Sx&WK,iW&fD&Lk{9a}Em-9c#8N&io=sy]8d&nT&IK(lx#7/$lW(Td<s8~49,3o<7Y=MW(T+_Jr&Wd,iL}Ct=xh&5V;v4&8n%Kx=iF&l2_0B{B+,If(J0,Lv;u8=Kx-vB=HC&vS=Z6&fU&vE^xK;3D=4h=MR#45:Jw;0d}iw=LU}I5=I0]gB*im,K9}GU,1k_4U&Tt=Vs(iX&lU(TF#7y,ZO}oA&m5#5P}PN}Uz=hM<B1&FB<aG,e6~7T<tP(UQ_ZT=wu&F8)aQ]iN,1r_Lo&/g:CD}84{J1_Ki&Na&3n$jz&FE=dc;uv;va}in}ll=fv(h1&3h}fp=Cy}BM(+E~8m}lo%v7=hC(T6$cj=BQ=Bw(DR,2j=Ks,NS|F+;00=fU=70}Mb(YU;+G&m7&hr=Sk%Co]t+(X5_Jw}0r}gC(AS-IP&QK<Z2#8Q$WC]WX}T2&pG_Ka,HC=R4&/N;Z+;ch(C7,D4$3p_Mk&B2$8D=n9%Ky#5z(CT&QJ#7B]DC]gW}nf~5M;Iw#80}Tc_1F#4Z-aC}Hl=ph=fz,/3=aW}JM}nn;DG;vm}wn,4P}T3;wx&RG$u+}zK=0b;+J_Ek{re<aZ=AS}yY#5D]7q,Cp}xN=VP*2C}GZ}aG~+m_Cs=OY#6r]6g<GS}LC(UB=3A=Bo}Jy<c4}Is;1P<AG}Op<Z1}ld}nS=1Z,yM&95&98=CJ(4t:2L$Hk=Zo}Vc;+I}np&N1}9y=iv}CO*7p=jL)px]tb^zh&GS&Vl%v/;vR=14=zJ&49|/f]hF}WG;03=8P}o/&Gg&rp;DB,Kv}Ji&Pb;aA^ll(4j%yt}+K$Ht#4y&hY]7Y<F1,eN}bG(Uh%6Z]t5%G7;+F_RE;it}tL=LS&Da=Xx(S+(4f=8G=yI}cJ}WP=37=jS}pX}hd)fp<A8=Jt~+o$HJ=M6}iX=g9}CS=dv=Cj(mP%Kd,xq|+9&LD(4/=Xm&QP=Lc}LX&fL;+K=Op(lu=Qs.qC:+e&L+=Jj#8w;SL]7S(b+#4I=c1&nG_Lf&uH;+R)ZV<bV%B/,TE&0H&Jq&Ah%OF&Ss(p2,Wv&I3=Wl}Vq;1L&lJ#9b_1H=8r=b8=JH(SZ=hD=J2#7U,/U#/X~6P,FU<eL=jx,mG=hG=CE&PU=Se(qX&LY=X6=y4&tk&QQ&tf=4g&xI}W+&mZ=Dc#7w}Lg;DA;wQ_Kb(cJ=hR%yX&Yb,hw{bX_4X;EP;1W_2M}Uc=b5(YF,CM&Tp^OJ{DD]6s=vF=Yo~8q}XH}Fu%P5(SJ=Qt;MO]s8<F3&B3&8T(Ul-BS*dw&dR<87}/8]62$PZ]Lx<Au}9Q]7c=ja=KR,Go,Us&v6(qk}pG&G2=ev^GM%w4&H4]7F&dv]J6}Ew:9w=sj-ZL}Ym$+h(Ut(Um~4n=Xs(U7%eE=Qc_JR<CA#6t<Fv|/I,IS,EG<F2(Xy$/n<Fa(h9}+9_2o&N4#7X<Zq|+f_Dp=dt&na,Ca=NJ)jY=8C=YG=s6&Q+<DO}D3=xB&R1(lw;Qn<bF(Cu|/B}HV=SS&n7,10&u0]Dm%A6^4Q=WR(TD=Xo<GH,Rj(l8)bP&n/=LM&CF,F5&ml=PJ;0k=LG=tq,Rh,D6@4i=1p&+9=YC%er_Mh;nI;0q=Fw]80=xq=FM$Gv;v6&nc;wK%H2&Kj;vs,AA=YP,66}bI(qR~5U=6q~4b$Ni=K5.X3$So&Iu(p+]8G=Cf=RY(TS_O3(iH&57=fE=Dg_Do#9z#7H;FK{qd_2k%JR}en&gh_z8;Rx}9p<cN_Ne,DO;LN_7o~/p=NF=5Y}gN<ce<C1,QE]Wv=3u<BC}GK]yq}DY&u/_hj=II(pz&rC,jV&+Z}ut=NQ;Cg-SR_ZS,+o=u/;Oy_RK_QF(Fx&xP}Wr&TA,Uh&g1=yr{ax[VF$Pg(YB;Ox=Vy;+W(Sp}XV%dd&33(l/]l4#4Y}OE=6c=bw(A7&9t%wd&N/&mo,JH&Qe)fm=Ao}fu=tH";
    var deltaData = "FAZDC6BALcLZCA+GBARCW8wNCcDDZ8LVFBOqqDUiou+M42TFAyERXFb7EjhP+vmBFpFrUpfDV2F7eB+eCltCHJFWLFCED+pWTojEIHFXc3aFn4F68zqjEuKidS1QBVPDEhE7NA4mhMF7oThD49ot3FgtzHFCK0acW1x8DH1EmLoIlrWFBLE+y5+NA3Cx65wJHTaEZVaK1mWAmPGxgYCdxwOjTDIt/faOEhTl1vqNsKtJCOhJWuio2g07KLZEQsFBUpNtwEByBgxFslFheFbiEPvi61msDvApxCzB6rBCzox7joYA5UdDc+Cb4FSgIabpXFAj3bjkmFAxCZE+mD/SFf/0ELecYCt3nLoxC6WEZf2tKDB4oZvrEmqFkKk7BwILA7gtYBpsTq//D4jD0F0wEB9pyQ1BD5Ba0oYHDI+sbDFhvrHXdDHfgFEIJLi5r8qercNFBgFLC4bo5ERJtamWBDFy73KCEb6M8VpmEt330ygCTK58EIIFkYgF84gtGA9Uyh3m68iVrFbWFbcbqiCYHZ9J1jeRPbL8yswhMiDbhEhdNoSwFbZrLT740ABEqgCkO8J1BLd1VhKKR4sD1yUo0z+FF59Mvg71CFbyEhbHSFBKEIKyoQNgQppq9T0KAqePu0ZFGrXOHdKJqkoTFhYvpDNyuuznrN84thJbsCoO6Cu6Xlvntvy0QYuAExQEYtTUBf3CoCqwgGFZ4u1HJFzDVwEy3cjcpV4QvsPaBC3rCGyCF23o4K3pp2gberGgFEJEHo4nHICtyKH2ZqyxhN05KBBJIQlKh/Oujv/DH32VrlqFdIFC7Fz9Ct4kaqFME0UETLprnN9kfy+kFmtQBB0+5CFu0N9Ij8l/VvJDh2oq3hT6EzjTHKFN7ZjZwoTsAZ4Exsko6Fpa6WC+sduz8jyrLpegTv2h1EBeYpLpm2czQW0KoCcS0bCVXCmuWJDBjN1nQNLdF58SFJ0h7i3pC3oEOKy/FjBklL70XvBEEIWp2yZ04xObzAWDDJG7f+DbqBEA7LyiR95j7MDVdDViz2RE5vWlBMv5e4+VfhP3aXNPhvLSynb9O2x4uFBV+3jqu6d5pCG28/sETByvmu/+IJ0L3wb4rj9DNOLBF6XPIODr4L19U9RRofAG6Nxydi8Bki8BhGJbBAJKzbJxkZSlF9Q2Cu8oKqggB9hBArwLLqEBWEtFowy8XK8bEyw9snT+BeyFk1ZCSrdmgfEwFePTgCjELBEnIbjaDDPJm36rG9pztcEzT8dGk23SBhXBB1H4z+OWze0ooFzz8pDBYFvp9j9tvFByf9y4EFdVnz026CGR5qMr7fxMHN8UUdlyJAzlTBDRC28k+L4FB8078ljyD91tUj1ocnTs8vdEf7znbzm+GIjEZnoZE5rnLL700Xc7yHfz05nWxy03vBB9YGHYOWxgMQGBCR24CVYNE1hpfKxN0zKnfJDmmMgMmBWqNbjfSyFCBWSCGCgR8yFXiHyEj+VtD1FB3FpC1zI0kFbzifiKTLm9yq5zFmur+q8FHqjoOBWsBPiDbnCC2ErunV6cJ6TygXFYHYp7MKN9RUlSIS8/xBAGYLzeqUnBF4QbsTuUkUqGs6CaiDWKWjQK9EJkjpkTmNCPYXL";
    var wordlist = {
      zh_cn: null,
      zh_tw: null
    };
    var Checks = {
      zh_cn: "0x17bcc4d8547e5a7135e365d1ab443aaae95e76d8230c2782c67305d4f21497a1",
      zh_tw: "0x51e720e90c7b87bec1d70eb6e74a21a449bd3ec9c020b01d3a40ed991b60ce5d"
    };
    var codes = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    var style = "~!@#$%^&*_-=[]{}|;:,.()<>?";
    function loadWords(lang) {
      if (wordlist[lang.locale] !== null) {
        return;
      }
      wordlist[lang.locale] = [];
      var deltaOffset = 0;
      for (var i = 0; i < 2048; i++) {
        var s = style.indexOf(data[i * 3]);
        var bytes = [
          228 + (s >> 2),
          128 + codes.indexOf(data[i * 3 + 1]),
          128 + codes.indexOf(data[i * 3 + 2])
        ];
        if (lang.locale === "zh_tw") {
          var common = s % 4;
          for (var i_1 = common; i_1 < 3; i_1++) {
            bytes[i_1] = codes.indexOf(deltaData[deltaOffset++]) + (i_1 == 0 ? 228 : 128);
          }
        }
        wordlist[lang.locale].push((0, strings_1.toUtf8String)(bytes));
      }
      if (wordlist_1.Wordlist.check(lang) !== Checks[lang.locale]) {
        wordlist[lang.locale] = null;
        throw new Error("BIP39 Wordlist for " + lang.locale + " (Chinese) FAILED");
      }
    }
    var LangZh = (
      /** @class */
      function(_super) {
        __extends(LangZh2, _super);
        function LangZh2(country) {
          return _super.call(this, "zh_" + country) || this;
        }
        LangZh2.prototype.getWord = function(index) {
          loadWords(this);
          return wordlist[this.locale][index];
        };
        LangZh2.prototype.getWordIndex = function(word) {
          loadWords(this);
          return wordlist[this.locale].indexOf(word);
        };
        LangZh2.prototype.split = function(mnemonic) {
          mnemonic = mnemonic.replace(/(?:\u3000| )+/g, "");
          return mnemonic.split("");
        };
        return LangZh2;
      }(wordlist_1.Wordlist)
    );
    var langZhCn = new LangZh("cn");
    exports2.langZhCn = langZhCn;
    wordlist_1.Wordlist.register(langZhCn);
    wordlist_1.Wordlist.register(langZhCn, "zh");
    var langZhTw = new LangZh("tw");
    exports2.langZhTw = langZhTw;
    wordlist_1.Wordlist.register(langZhTw);
  }
});

// node_modules/@ethersproject/wordlists/lib/wordlists.js
var require_wordlists = __commonJS({
  "node_modules/@ethersproject/wordlists/lib/wordlists.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.wordlists = void 0;
    var lang_cz_1 = require_lang_cz();
    var lang_en_1 = require_lang_en();
    var lang_es_1 = require_lang_es();
    var lang_fr_1 = require_lang_fr();
    var lang_ja_1 = require_lang_ja();
    var lang_ko_1 = require_lang_ko();
    var lang_it_1 = require_lang_it();
    var lang_zh_1 = require_lang_zh();
    exports2.wordlists = {
      cz: lang_cz_1.langCz,
      en: lang_en_1.langEn,
      es: lang_es_1.langEs,
      fr: lang_fr_1.langFr,
      it: lang_it_1.langIt,
      ja: lang_ja_1.langJa,
      ko: lang_ko_1.langKo,
      zh: lang_zh_1.langZhCn,
      zh_cn: lang_zh_1.langZhCn,
      zh_tw: lang_zh_1.langZhTw
    };
  }
});

// node_modules/@ethersproject/wordlists/lib/index.js
var require_lib20 = __commonJS({
  "node_modules/@ethersproject/wordlists/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.wordlists = exports2.Wordlist = exports2.logger = void 0;
    var wordlist_1 = require_wordlist();
    Object.defineProperty(exports2, "logger", { enumerable: true, get: function() {
      return wordlist_1.logger;
    } });
    Object.defineProperty(exports2, "Wordlist", { enumerable: true, get: function() {
      return wordlist_1.Wordlist;
    } });
    var wordlists_1 = require_wordlists();
    Object.defineProperty(exports2, "wordlists", { enumerable: true, get: function() {
      return wordlists_1.wordlists;
    } });
  }
});

// node_modules/@ethersproject/hdnode/lib/_version.js
var require_version17 = __commonJS({
  "node_modules/@ethersproject/hdnode/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "hdnode/5.5.0";
  }
});

// node_modules/@ethersproject/hdnode/lib/index.js
var require_lib21 = __commonJS({
  "node_modules/@ethersproject/hdnode/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getAccountPath = exports2.isValidMnemonic = exports2.entropyToMnemonic = exports2.mnemonicToEntropy = exports2.mnemonicToSeed = exports2.HDNode = exports2.defaultPath = void 0;
    var basex_1 = require_lib17();
    var bytes_1 = require_lib2();
    var bignumber_1 = require_lib3();
    var strings_1 = require_lib9();
    var pbkdf2_1 = require_lib18();
    var properties_1 = require_lib4();
    var signing_key_1 = require_lib14();
    var sha2_1 = require_lib19();
    var transactions_1 = require_lib15();
    var wordlists_1 = require_lib20();
    var logger_1 = require_lib();
    var _version_1 = require_version17();
    var logger = new logger_1.Logger(_version_1.version);
    var N = bignumber_1.BigNumber.from("0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141");
    var MasterSecret = (0, strings_1.toUtf8Bytes)("Bitcoin seed");
    var HardenedBit = 2147483648;
    function getUpperMask(bits) {
      return (1 << bits) - 1 << 8 - bits;
    }
    function getLowerMask(bits) {
      return (1 << bits) - 1;
    }
    function bytes32(value) {
      return (0, bytes_1.hexZeroPad)((0, bytes_1.hexlify)(value), 32);
    }
    function base58check(data) {
      return basex_1.Base58.encode((0, bytes_1.concat)([data, (0, bytes_1.hexDataSlice)((0, sha2_1.sha256)((0, sha2_1.sha256)(data)), 0, 4)]));
    }
    function getWordlist(wordlist) {
      if (wordlist == null) {
        return wordlists_1.wordlists["en"];
      }
      if (typeof wordlist === "string") {
        var words = wordlists_1.wordlists[wordlist];
        if (words == null) {
          logger.throwArgumentError("unknown locale", "wordlist", wordlist);
        }
        return words;
      }
      return wordlist;
    }
    var _constructorGuard = {};
    exports2.defaultPath = "m/44'/60'/0'/0/0";
    var HDNode = (
      /** @class */
      function() {
        function HDNode2(constructorGuard, privateKey, publicKey, parentFingerprint, chainCode, index, depth, mnemonicOrPath) {
          var _newTarget = this.constructor;
          logger.checkNew(_newTarget, HDNode2);
          if (constructorGuard !== _constructorGuard) {
            throw new Error("HDNode constructor cannot be called directly");
          }
          if (privateKey) {
            var signingKey = new signing_key_1.SigningKey(privateKey);
            (0, properties_1.defineReadOnly)(this, "privateKey", signingKey.privateKey);
            (0, properties_1.defineReadOnly)(this, "publicKey", signingKey.compressedPublicKey);
          } else {
            (0, properties_1.defineReadOnly)(this, "privateKey", null);
            (0, properties_1.defineReadOnly)(this, "publicKey", (0, bytes_1.hexlify)(publicKey));
          }
          (0, properties_1.defineReadOnly)(this, "parentFingerprint", parentFingerprint);
          (0, properties_1.defineReadOnly)(this, "fingerprint", (0, bytes_1.hexDataSlice)((0, sha2_1.ripemd160)((0, sha2_1.sha256)(this.publicKey)), 0, 4));
          (0, properties_1.defineReadOnly)(this, "address", (0, transactions_1.computeAddress)(this.publicKey));
          (0, properties_1.defineReadOnly)(this, "chainCode", chainCode);
          (0, properties_1.defineReadOnly)(this, "index", index);
          (0, properties_1.defineReadOnly)(this, "depth", depth);
          if (mnemonicOrPath == null) {
            (0, properties_1.defineReadOnly)(this, "mnemonic", null);
            (0, properties_1.defineReadOnly)(this, "path", null);
          } else if (typeof mnemonicOrPath === "string") {
            (0, properties_1.defineReadOnly)(this, "mnemonic", null);
            (0, properties_1.defineReadOnly)(this, "path", mnemonicOrPath);
          } else {
            (0, properties_1.defineReadOnly)(this, "mnemonic", mnemonicOrPath);
            (0, properties_1.defineReadOnly)(this, "path", mnemonicOrPath.path);
          }
        }
        Object.defineProperty(HDNode2.prototype, "extendedKey", {
          get: function() {
            if (this.depth >= 256) {
              throw new Error("Depth too large!");
            }
            return base58check((0, bytes_1.concat)([
              this.privateKey != null ? "0x0488ADE4" : "0x0488B21E",
              (0, bytes_1.hexlify)(this.depth),
              this.parentFingerprint,
              (0, bytes_1.hexZeroPad)((0, bytes_1.hexlify)(this.index), 4),
              this.chainCode,
              this.privateKey != null ? (0, bytes_1.concat)(["0x00", this.privateKey]) : this.publicKey
            ]));
          },
          enumerable: false,
          configurable: true
        });
        HDNode2.prototype.neuter = function() {
          return new HDNode2(_constructorGuard, null, this.publicKey, this.parentFingerprint, this.chainCode, this.index, this.depth, this.path);
        };
        HDNode2.prototype._derive = function(index) {
          if (index > 4294967295) {
            throw new Error("invalid index - " + String(index));
          }
          var path = this.path;
          if (path) {
            path += "/" + (index & ~HardenedBit);
          }
          var data = new Uint8Array(37);
          if (index & HardenedBit) {
            if (!this.privateKey) {
              throw new Error("cannot derive child of neutered node");
            }
            data.set((0, bytes_1.arrayify)(this.privateKey), 1);
            if (path) {
              path += "'";
            }
          } else {
            data.set((0, bytes_1.arrayify)(this.publicKey));
          }
          for (var i = 24; i >= 0; i -= 8) {
            data[33 + (i >> 3)] = index >> 24 - i & 255;
          }
          var I = (0, bytes_1.arrayify)((0, sha2_1.computeHmac)(sha2_1.SupportedAlgorithm.sha512, this.chainCode, data));
          var IL = I.slice(0, 32);
          var IR = I.slice(32);
          var ki = null;
          var Ki = null;
          if (this.privateKey) {
            ki = bytes32(bignumber_1.BigNumber.from(IL).add(this.privateKey).mod(N));
          } else {
            var ek = new signing_key_1.SigningKey((0, bytes_1.hexlify)(IL));
            Ki = ek._addPoint(this.publicKey);
          }
          var mnemonicOrPath = path;
          var srcMnemonic = this.mnemonic;
          if (srcMnemonic) {
            mnemonicOrPath = Object.freeze({
              phrase: srcMnemonic.phrase,
              path,
              locale: srcMnemonic.locale || "en"
            });
          }
          return new HDNode2(_constructorGuard, ki, Ki, this.fingerprint, bytes32(IR), index, this.depth + 1, mnemonicOrPath);
        };
        HDNode2.prototype.derivePath = function(path) {
          var components = path.split("/");
          if (components.length === 0 || components[0] === "m" && this.depth !== 0) {
            throw new Error("invalid path - " + path);
          }
          if (components[0] === "m") {
            components.shift();
          }
          var result = this;
          for (var i = 0; i < components.length; i++) {
            var component = components[i];
            if (component.match(/^[0-9]+'$/)) {
              var index = parseInt(component.substring(0, component.length - 1));
              if (index >= HardenedBit) {
                throw new Error("invalid path index - " + component);
              }
              result = result._derive(HardenedBit + index);
            } else if (component.match(/^[0-9]+$/)) {
              var index = parseInt(component);
              if (index >= HardenedBit) {
                throw new Error("invalid path index - " + component);
              }
              result = result._derive(index);
            } else {
              throw new Error("invalid path component - " + component);
            }
          }
          return result;
        };
        HDNode2._fromSeed = function(seed, mnemonic) {
          var seedArray = (0, bytes_1.arrayify)(seed);
          if (seedArray.length < 16 || seedArray.length > 64) {
            throw new Error("invalid seed");
          }
          var I = (0, bytes_1.arrayify)((0, sha2_1.computeHmac)(sha2_1.SupportedAlgorithm.sha512, MasterSecret, seedArray));
          return new HDNode2(_constructorGuard, bytes32(I.slice(0, 32)), null, "0x00000000", bytes32(I.slice(32)), 0, 0, mnemonic);
        };
        HDNode2.fromMnemonic = function(mnemonic, password, wordlist) {
          wordlist = getWordlist(wordlist);
          mnemonic = entropyToMnemonic(mnemonicToEntropy(mnemonic, wordlist), wordlist);
          return HDNode2._fromSeed(mnemonicToSeed(mnemonic, password), {
            phrase: mnemonic,
            path: "m",
            locale: wordlist.locale
          });
        };
        HDNode2.fromSeed = function(seed) {
          return HDNode2._fromSeed(seed, null);
        };
        HDNode2.fromExtendedKey = function(extendedKey) {
          var bytes = basex_1.Base58.decode(extendedKey);
          if (bytes.length !== 82 || base58check(bytes.slice(0, 78)) !== extendedKey) {
            logger.throwArgumentError("invalid extended key", "extendedKey", "[REDACTED]");
          }
          var depth = bytes[4];
          var parentFingerprint = (0, bytes_1.hexlify)(bytes.slice(5, 9));
          var index = parseInt((0, bytes_1.hexlify)(bytes.slice(9, 13)).substring(2), 16);
          var chainCode = (0, bytes_1.hexlify)(bytes.slice(13, 45));
          var key = bytes.slice(45, 78);
          switch ((0, bytes_1.hexlify)(bytes.slice(0, 4))) {
            case "0x0488b21e":
            case "0x043587cf":
              return new HDNode2(_constructorGuard, null, (0, bytes_1.hexlify)(key), parentFingerprint, chainCode, index, depth, null);
            case "0x0488ade4":
            case "0x04358394 ":
              if (key[0] !== 0) {
                break;
              }
              return new HDNode2(_constructorGuard, (0, bytes_1.hexlify)(key.slice(1)), null, parentFingerprint, chainCode, index, depth, null);
          }
          return logger.throwArgumentError("invalid extended key", "extendedKey", "[REDACTED]");
        };
        return HDNode2;
      }()
    );
    exports2.HDNode = HDNode;
    function mnemonicToSeed(mnemonic, password) {
      if (!password) {
        password = "";
      }
      var salt = (0, strings_1.toUtf8Bytes)("mnemonic" + password, strings_1.UnicodeNormalizationForm.NFKD);
      return (0, pbkdf2_1.pbkdf2)((0, strings_1.toUtf8Bytes)(mnemonic, strings_1.UnicodeNormalizationForm.NFKD), salt, 2048, 64, "sha512");
    }
    exports2.mnemonicToSeed = mnemonicToSeed;
    function mnemonicToEntropy(mnemonic, wordlist) {
      wordlist = getWordlist(wordlist);
      logger.checkNormalize();
      var words = wordlist.split(mnemonic);
      if (words.length % 3 !== 0) {
        throw new Error("invalid mnemonic");
      }
      var entropy = (0, bytes_1.arrayify)(new Uint8Array(Math.ceil(11 * words.length / 8)));
      var offset = 0;
      for (var i = 0; i < words.length; i++) {
        var index = wordlist.getWordIndex(words[i].normalize("NFKD"));
        if (index === -1) {
          throw new Error("invalid mnemonic");
        }
        for (var bit = 0; bit < 11; bit++) {
          if (index & 1 << 10 - bit) {
            entropy[offset >> 3] |= 1 << 7 - offset % 8;
          }
          offset++;
        }
      }
      var entropyBits = 32 * words.length / 3;
      var checksumBits = words.length / 3;
      var checksumMask = getUpperMask(checksumBits);
      var checksum = (0, bytes_1.arrayify)((0, sha2_1.sha256)(entropy.slice(0, entropyBits / 8)))[0] & checksumMask;
      if (checksum !== (entropy[entropy.length - 1] & checksumMask)) {
        throw new Error("invalid checksum");
      }
      return (0, bytes_1.hexlify)(entropy.slice(0, entropyBits / 8));
    }
    exports2.mnemonicToEntropy = mnemonicToEntropy;
    function entropyToMnemonic(entropy, wordlist) {
      wordlist = getWordlist(wordlist);
      entropy = (0, bytes_1.arrayify)(entropy);
      if (entropy.length % 4 !== 0 || entropy.length < 16 || entropy.length > 32) {
        throw new Error("invalid entropy");
      }
      var indices = [0];
      var remainingBits = 11;
      for (var i = 0; i < entropy.length; i++) {
        if (remainingBits > 8) {
          indices[indices.length - 1] <<= 8;
          indices[indices.length - 1] |= entropy[i];
          remainingBits -= 8;
        } else {
          indices[indices.length - 1] <<= remainingBits;
          indices[indices.length - 1] |= entropy[i] >> 8 - remainingBits;
          indices.push(entropy[i] & getLowerMask(8 - remainingBits));
          remainingBits += 3;
        }
      }
      var checksumBits = entropy.length / 4;
      var checksum = (0, bytes_1.arrayify)((0, sha2_1.sha256)(entropy))[0] & getUpperMask(checksumBits);
      indices[indices.length - 1] <<= checksumBits;
      indices[indices.length - 1] |= checksum >> 8 - checksumBits;
      return wordlist.join(indices.map(function(index) {
        return wordlist.getWord(index);
      }));
    }
    exports2.entropyToMnemonic = entropyToMnemonic;
    function isValidMnemonic(mnemonic, wordlist) {
      try {
        mnemonicToEntropy(mnemonic, wordlist);
        return true;
      } catch (error) {
      }
      return false;
    }
    exports2.isValidMnemonic = isValidMnemonic;
    function getAccountPath(index) {
      if (typeof index !== "number" || index < 0 || index >= HardenedBit || index % 1) {
        logger.throwArgumentError("invalid account index", "index", index);
      }
      return "m/44'/60'/" + index + "'/0/0";
    }
    exports2.getAccountPath = getAccountPath;
  }
});

// node_modules/@ethersproject/random/lib/random.js
var require_random = __commonJS({
  "node_modules/@ethersproject/random/lib/random.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.randomBytes = void 0;
    var crypto_1 = require("crypto");
    var bytes_1 = require_lib2();
    function randomBytes(length) {
      return (0, bytes_1.arrayify)((0, crypto_1.randomBytes)(length));
    }
    exports2.randomBytes = randomBytes;
  }
});

// node_modules/@ethersproject/random/lib/shuffle.js
var require_shuffle = __commonJS({
  "node_modules/@ethersproject/random/lib/shuffle.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.shuffled = void 0;
    function shuffled(array) {
      array = array.slice();
      for (var i = array.length - 1; i > 0; i--) {
        var j = Math.floor(Math.random() * (i + 1));
        var tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
      }
      return array;
    }
    exports2.shuffled = shuffled;
  }
});

// node_modules/@ethersproject/random/lib/index.js
var require_lib22 = __commonJS({
  "node_modules/@ethersproject/random/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.shuffled = exports2.randomBytes = void 0;
    var random_1 = require_random();
    Object.defineProperty(exports2, "randomBytes", { enumerable: true, get: function() {
      return random_1.randomBytes;
    } });
    var shuffle_1 = require_shuffle();
    Object.defineProperty(exports2, "shuffled", { enumerable: true, get: function() {
      return shuffle_1.shuffled;
    } });
  }
});

// node_modules/aes-js/index.js
var require_aes_js = __commonJS({
  "node_modules/aes-js/index.js"(exports2, module2) {
    "use strict";
    (function(root) {
      function checkInt(value) {
        return parseInt(value) === value;
      }
      function checkInts(arrayish) {
        if (!checkInt(arrayish.length)) {
          return false;
        }
        for (var i = 0; i < arrayish.length; i++) {
          if (!checkInt(arrayish[i]) || arrayish[i] < 0 || arrayish[i] > 255) {
            return false;
          }
        }
        return true;
      }
      function coerceArray(arg, copy) {
        if (arg.buffer && ArrayBuffer.isView(arg) && arg.name === "Uint8Array") {
          if (copy) {
            if (arg.slice) {
              arg = arg.slice();
            } else {
              arg = Array.prototype.slice.call(arg);
            }
          }
          return arg;
        }
        if (Array.isArray(arg)) {
          if (!checkInts(arg)) {
            throw new Error("Array contains invalid value: " + arg);
          }
          return new Uint8Array(arg);
        }
        if (checkInt(arg.length) && checkInts(arg)) {
          return new Uint8Array(arg);
        }
        throw new Error("unsupported array-like object");
      }
      function createArray(length) {
        return new Uint8Array(length);
      }
      function copyArray(sourceArray, targetArray, targetStart, sourceStart, sourceEnd) {
        if (sourceStart != null || sourceEnd != null) {
          if (sourceArray.slice) {
            sourceArray = sourceArray.slice(sourceStart, sourceEnd);
          } else {
            sourceArray = Array.prototype.slice.call(sourceArray, sourceStart, sourceEnd);
          }
        }
        targetArray.set(sourceArray, targetStart);
      }
      var convertUtf8 = /* @__PURE__ */ function() {
        function toBytes(text) {
          var result = [], i = 0;
          text = encodeURI(text);
          while (i < text.length) {
            var c = text.charCodeAt(i++);
            if (c === 37) {
              result.push(parseInt(text.substr(i, 2), 16));
              i += 2;
            } else {
              result.push(c);
            }
          }
          return coerceArray(result);
        }
        function fromBytes(bytes) {
          var result = [], i = 0;
          while (i < bytes.length) {
            var c = bytes[i];
            if (c < 128) {
              result.push(String.fromCharCode(c));
              i++;
            } else if (c > 191 && c < 224) {
              result.push(String.fromCharCode((c & 31) << 6 | bytes[i + 1] & 63));
              i += 2;
            } else {
              result.push(String.fromCharCode((c & 15) << 12 | (bytes[i + 1] & 63) << 6 | bytes[i + 2] & 63));
              i += 3;
            }
          }
          return result.join("");
        }
        return {
          toBytes,
          fromBytes
        };
      }();
      var convertHex = /* @__PURE__ */ function() {
        function toBytes(text) {
          var result = [];
          for (var i = 0; i < text.length; i += 2) {
            result.push(parseInt(text.substr(i, 2), 16));
          }
          return result;
        }
        var Hex = "0123456789abcdef";
        function fromBytes(bytes) {
          var result = [];
          for (var i = 0; i < bytes.length; i++) {
            var v = bytes[i];
            result.push(Hex[(v & 240) >> 4] + Hex[v & 15]);
          }
          return result.join("");
        }
        return {
          toBytes,
          fromBytes
        };
      }();
      var numberOfRounds = { 16: 10, 24: 12, 32: 14 };
      var rcon = [1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145];
      var S = [99, 124, 119, 123, 242, 107, 111, 197, 48, 1, 103, 43, 254, 215, 171, 118, 202, 130, 201, 125, 250, 89, 71, 240, 173, 212, 162, 175, 156, 164, 114, 192, 183, 253, 147, 38, 54, 63, 247, 204, 52, 165, 229, 241, 113, 216, 49, 21, 4, 199, 35, 195, 24, 150, 5, 154, 7, 18, 128, 226, 235, 39, 178, 117, 9, 131, 44, 26, 27, 110, 90, 160, 82, 59, 214, 179, 41, 227, 47, 132, 83, 209, 0, 237, 32, 252, 177, 91, 106, 203, 190, 57, 74, 76, 88, 207, 208, 239, 170, 251, 67, 77, 51, 133, 69, 249, 2, 127, 80, 60, 159, 168, 81, 163, 64, 143, 146, 157, 56, 245, 188, 182, 218, 33, 16, 255, 243, 210, 205, 12, 19, 236, 95, 151, 68, 23, 196, 167, 126, 61, 100, 93, 25, 115, 96, 129, 79, 220, 34, 42, 144, 136, 70, 238, 184, 20, 222, 94, 11, 219, 224, 50, 58, 10, 73, 6, 36, 92, 194, 211, 172, 98, 145, 149, 228, 121, 231, 200, 55, 109, 141, 213, 78, 169, 108, 86, 244, 234, 101, 122, 174, 8, 186, 120, 37, 46, 28, 166, 180, 198, 232, 221, 116, 31, 75, 189, 139, 138, 112, 62, 181, 102, 72, 3, 246, 14, 97, 53, 87, 185, 134, 193, 29, 158, 225, 248, 152, 17, 105, 217, 142, 148, 155, 30, 135, 233, 206, 85, 40, 223, 140, 161, 137, 13, 191, 230, 66, 104, 65, 153, 45, 15, 176, 84, 187, 22];
      var Si = [82, 9, 106, 213, 48, 54, 165, 56, 191, 64, 163, 158, 129, 243, 215, 251, 124, 227, 57, 130, 155, 47, 255, 135, 52, 142, 67, 68, 196, 222, 233, 203, 84, 123, 148, 50, 166, 194, 35, 61, 238, 76, 149, 11, 66, 250, 195, 78, 8, 46, 161, 102, 40, 217, 36, 178, 118, 91, 162, 73, 109, 139, 209, 37, 114, 248, 246, 100, 134, 104, 152, 22, 212, 164, 92, 204, 93, 101, 182, 146, 108, 112, 72, 80, 253, 237, 185, 218, 94, 21, 70, 87, 167, 141, 157, 132, 144, 216, 171, 0, 140, 188, 211, 10, 247, 228, 88, 5, 184, 179, 69, 6, 208, 44, 30, 143, 202, 63, 15, 2, 193, 175, 189, 3, 1, 19, 138, 107, 58, 145, 17, 65, 79, 103, 220, 234, 151, 242, 207, 206, 240, 180, 230, 115, 150, 172, 116, 34, 231, 173, 53, 133, 226, 249, 55, 232, 28, 117, 223, 110, 71, 241, 26, 113, 29, 41, 197, 137, 111, 183, 98, 14, 170, 24, 190, 27, 252, 86, 62, 75, 198, 210, 121, 32, 154, 219, 192, 254, 120, 205, 90, 244, 31, 221, 168, 51, 136, 7, 199, 49, 177, 18, 16, 89, 39, 128, 236, 95, 96, 81, 127, 169, 25, 181, 74, 13, 45, 229, 122, 159, 147, 201, 156, 239, 160, 224, 59, 77, 174, 42, 245, 176, 200, 235, 187, 60, 131, 83, 153, 97, 23, 43, 4, 126, 186, 119, 214, 38, 225, 105, 20, 99, 85, 33, 12, 125];
      var T1 = [3328402341, 4168907908, 4000806809, 4135287693, 4294111757, 3597364157, 3731845041, 2445657428, 1613770832, 33620227, 3462883241, 1445669757, 3892248089, 3050821474, 1303096294, 3967186586, 2412431941, 528646813, 2311702848, 4202528135, 4026202645, 2992200171, 2387036105, 4226871307, 1101901292, 3017069671, 1604494077, 1169141738, 597466303, 1403299063, 3832705686, 2613100635, 1974974402, 3791519004, 1033081774, 1277568618, 1815492186, 2118074177, 4126668546, 2211236943, 1748251740, 1369810420, 3521504564, 4193382664, 3799085459, 2883115123, 1647391059, 706024767, 134480908, 2512897874, 1176707941, 2646852446, 806885416, 932615841, 168101135, 798661301, 235341577, 605164086, 461406363, 3756188221, 3454790438, 1311188841, 2142417613, 3933566367, 302582043, 495158174, 1479289972, 874125870, 907746093, 3698224818, 3025820398, 1537253627, 2756858614, 1983593293, 3084310113, 2108928974, 1378429307, 3722699582, 1580150641, 327451799, 2790478837, 3117535592, 0, 3253595436, 1075847264, 3825007647, 2041688520, 3059440621, 3563743934, 2378943302, 1740553945, 1916352843, 2487896798, 2555137236, 2958579944, 2244988746, 3151024235, 3320835882, 1336584933, 3992714006, 2252555205, 2588757463, 1714631509, 293963156, 2319795663, 3925473552, 67240454, 4269768577, 2689618160, 2017213508, 631218106, 1269344483, 2723238387, 1571005438, 2151694528, 93294474, 1066570413, 563977660, 1882732616, 4059428100, 1673313503, 2008463041, 2950355573, 1109467491, 537923632, 3858759450, 4260623118, 3218264685, 2177748300, 403442708, 638784309, 3287084079, 3193921505, 899127202, 2286175436, 773265209, 2479146071, 1437050866, 4236148354, 2050833735, 3362022572, 3126681063, 840505643, 3866325909, 3227541664, 427917720, 2655997905, 2749160575, 1143087718, 1412049534, 999329963, 193497219, 2353415882, 3354324521, 1807268051, 672404540, 2816401017, 3160301282, 369822493, 2916866934, 3688947771, 1681011286, 1949973070, 336202270, 2454276571, 201721354, 1210328172, 3093060836, 2680341085, 3184776046, 1135389935, 3294782118, 965841320, 831886756, 3554993207, 4068047243, 3588745010, 2345191491, 1849112409, 3664604599, 26054028, 2983581028, 2622377682, 1235855840, 3630984372, 2891339514, 4092916743, 3488279077, 3395642799, 4101667470, 1202630377, 268961816, 1874508501, 4034427016, 1243948399, 1546530418, 941366308, 1470539505, 1941222599, 2546386513, 3421038627, 2715671932, 3899946140, 1042226977, 2521517021, 1639824860, 227249030, 260737669, 3765465232, 2084453954, 1907733956, 3429263018, 2420656344, 100860677, 4160157185, 470683154, 3261161891, 1781871967, 2924959737, 1773779408, 394692241, 2579611992, 974986535, 664706745, 3655459128, 3958962195, 731420851, 571543859, 3530123707, 2849626480, 126783113, 865375399, 765172662, 1008606754, 361203602, 3387549984, 2278477385, 2857719295, 1344809080, 2782912378, 59542671, 1503764984, 160008576, 437062935, 1707065306, 3622233649, 2218934982, 3496503480, 2185314755, 697932208, 1512910199, 504303377, 2075177163, 2824099068, 1841019862, 739644986];
      var T2 = [2781242211, 2230877308, 2582542199, 2381740923, 234877682, 3184946027, 2984144751, 1418839493, 1348481072, 50462977, 2848876391, 2102799147, 434634494, 1656084439, 3863849899, 2599188086, 1167051466, 2636087938, 1082771913, 2281340285, 368048890, 3954334041, 3381544775, 201060592, 3963727277, 1739838676, 4250903202, 3930435503, 3206782108, 4149453988, 2531553906, 1536934080, 3262494647, 484572669, 2923271059, 1783375398, 1517041206, 1098792767, 49674231, 1334037708, 1550332980, 4098991525, 886171109, 150598129, 2481090929, 1940642008, 1398944049, 1059722517, 201851908, 1385547719, 1699095331, 1587397571, 674240536, 2704774806, 252314885, 3039795866, 151914247, 908333586, 2602270848, 1038082786, 651029483, 1766729511, 3447698098, 2682942837, 454166793, 2652734339, 1951935532, 775166490, 758520603, 3000790638, 4004797018, 4217086112, 4137964114, 1299594043, 1639438038, 3464344499, 2068982057, 1054729187, 1901997871, 2534638724, 4121318227, 1757008337, 0, 750906861, 1614815264, 535035132, 3363418545, 3988151131, 3201591914, 1183697867, 3647454910, 1265776953, 3734260298, 3566750796, 3903871064, 1250283471, 1807470800, 717615087, 3847203498, 384695291, 3313910595, 3617213773, 1432761139, 2484176261, 3481945413, 283769337, 100925954, 2180939647, 4037038160, 1148730428, 3123027871, 3813386408, 4087501137, 4267549603, 3229630528, 2315620239, 2906624658, 3156319645, 1215313976, 82966005, 3747855548, 3245848246, 1974459098, 1665278241, 807407632, 451280895, 251524083, 1841287890, 1283575245, 337120268, 891687699, 801369324, 3787349855, 2721421207, 3431482436, 959321879, 1469301956, 4065699751, 2197585534, 1199193405, 2898814052, 3887750493, 724703513, 2514908019, 2696962144, 2551808385, 3516813135, 2141445340, 1715741218, 2119445034, 2872807568, 2198571144, 3398190662, 700968686, 3547052216, 1009259540, 2041044702, 3803995742, 487983883, 1991105499, 1004265696, 1449407026, 1316239930, 504629770, 3683797321, 168560134, 1816667172, 3837287516, 1570751170, 1857934291, 4014189740, 2797888098, 2822345105, 2754712981, 936633572, 2347923833, 852879335, 1133234376, 1500395319, 3084545389, 2348912013, 1689376213, 3533459022, 3762923945, 3034082412, 4205598294, 133428468, 634383082, 2949277029, 2398386810, 3913789102, 403703816, 3580869306, 2297460856, 1867130149, 1918643758, 607656988, 4049053350, 3346248884, 1368901318, 600565992, 2090982877, 2632479860, 557719327, 3717614411, 3697393085, 2249034635, 2232388234, 2430627952, 1115438654, 3295786421, 2865522278, 3633334344, 84280067, 33027830, 303828494, 2747425121, 1600795957, 4188952407, 3496589753, 2434238086, 1486471617, 658119965, 3106381470, 953803233, 334231800, 3005978776, 857870609, 3151128937, 1890179545, 2298973838, 2805175444, 3056442267, 574365214, 2450884487, 550103529, 1233637070, 4289353045, 2018519080, 2057691103, 2399374476, 4166623649, 2148108681, 387583245, 3664101311, 836232934, 3330556482, 3100665960, 3280093505, 2955516313, 2002398509, 287182607, 3413881008, 4238890068, 3597515707, 975967766];
      var T3 = [1671808611, 2089089148, 2006576759, 2072901243, 4061003762, 1807603307, 1873927791, 3310653893, 810573872, 16974337, 1739181671, 729634347, 4263110654, 3613570519, 2883997099, 1989864566, 3393556426, 2191335298, 3376449993, 2106063485, 4195741690, 1508618841, 1204391495, 4027317232, 2917941677, 3563566036, 2734514082, 2951366063, 2629772188, 2767672228, 1922491506, 3227229120, 3082974647, 4246528509, 2477669779, 644500518, 911895606, 1061256767, 4144166391, 3427763148, 878471220, 2784252325, 3845444069, 4043897329, 1905517169, 3631459288, 827548209, 356461077, 67897348, 3344078279, 593839651, 3277757891, 405286936, 2527147926, 84871685, 2595565466, 118033927, 305538066, 2157648768, 3795705826, 3945188843, 661212711, 2999812018, 1973414517, 152769033, 2208177539, 745822252, 439235610, 455947803, 1857215598, 1525593178, 2700827552, 1391895634, 994932283, 3596728278, 3016654259, 695947817, 3812548067, 795958831, 2224493444, 1408607827, 3513301457, 0, 3979133421, 543178784, 4229948412, 2982705585, 1542305371, 1790891114, 3410398667, 3201918910, 961245753, 1256100938, 1289001036, 1491644504, 3477767631, 3496721360, 4012557807, 2867154858, 4212583931, 1137018435, 1305975373, 861234739, 2241073541, 1171229253, 4178635257, 33948674, 2139225727, 1357946960, 1011120188, 2679776671, 2833468328, 1374921297, 2751356323, 1086357568, 2408187279, 2460827538, 2646352285, 944271416, 4110742005, 3168756668, 3066132406, 3665145818, 560153121, 271589392, 4279952895, 4077846003, 3530407890, 3444343245, 202643468, 322250259, 3962553324, 1608629855, 2543990167, 1154254916, 389623319, 3294073796, 2817676711, 2122513534, 1028094525, 1689045092, 1575467613, 422261273, 1939203699, 1621147744, 2174228865, 1339137615, 3699352540, 577127458, 712922154, 2427141008, 2290289544, 1187679302, 3995715566, 3100863416, 339486740, 3732514782, 1591917662, 186455563, 3681988059, 3762019296, 844522546, 978220090, 169743370, 1239126601, 101321734, 611076132, 1558493276, 3260915650, 3547250131, 2901361580, 1655096418, 2443721105, 2510565781, 3828863972, 2039214713, 3878868455, 3359869896, 928607799, 1840765549, 2374762893, 3580146133, 1322425422, 2850048425, 1823791212, 1459268694, 4094161908, 3928346602, 1706019429, 2056189050, 2934523822, 135794696, 3134549946, 2022240376, 628050469, 779246638, 472135708, 2800834470, 3032970164, 3327236038, 3894660072, 3715932637, 1956440180, 522272287, 1272813131, 3185336765, 2340818315, 2323976074, 1888542832, 1044544574, 3049550261, 1722469478, 1222152264, 50660867, 4127324150, 236067854, 1638122081, 895445557, 1475980887, 3117443513, 2257655686, 3243809217, 489110045, 2662934430, 3778599393, 4162055160, 2561878936, 288563729, 1773916777, 3648039385, 2391345038, 2493985684, 2612407707, 505560094, 2274497927, 3911240169, 3460925390, 1442818645, 678973480, 3749357023, 2358182796, 2717407649, 2306869641, 219617805, 3218761151, 3862026214, 1120306242, 1756942440, 1103331905, 2578459033, 762796589, 252780047, 2966125488, 1425844308, 3151392187, 372911126];
      var T4 = [1667474886, 2088535288, 2004326894, 2071694838, 4075949567, 1802223062, 1869591006, 3318043793, 808472672, 16843522, 1734846926, 724270422, 4278065639, 3621216949, 2880169549, 1987484396, 3402253711, 2189597983, 3385409673, 2105378810, 4210693615, 1499065266, 1195886990, 4042263547, 2913856577, 3570689971, 2728590687, 2947541573, 2627518243, 2762274643, 1920112356, 3233831835, 3082273397, 4261223649, 2475929149, 640051788, 909531756, 1061110142, 4160160501, 3435941763, 875846760, 2779116625, 3857003729, 4059105529, 1903268834, 3638064043, 825316194, 353713962, 67374088, 3351728789, 589522246, 3284360861, 404236336, 2526454071, 84217610, 2593830191, 117901582, 303183396, 2155911963, 3806477791, 3958056653, 656894286, 2998062463, 1970642922, 151591698, 2206440989, 741110872, 437923380, 454765878, 1852748508, 1515908788, 2694904667, 1381168804, 993742198, 3604373943, 3014905469, 690584402, 3823320797, 791638366, 2223281939, 1398011302, 3520161977, 0, 3991743681, 538992704, 4244381667, 2981218425, 1532751286, 1785380564, 3419096717, 3200178535, 960056178, 1246420628, 1280103576, 1482221744, 3486468741, 3503319995, 4025428677, 2863326543, 4227536621, 1128514950, 1296947098, 859002214, 2240123921, 1162203018, 4193849577, 33687044, 2139062782, 1347481760, 1010582648, 2678045221, 2829640523, 1364325282, 2745433693, 1077985408, 2408548869, 2459086143, 2644360225, 943212656, 4126475505, 3166494563, 3065430391, 3671750063, 555836226, 269496352, 4294908645, 4092792573, 3537006015, 3452783745, 202118168, 320025894, 3974901699, 1600119230, 2543297077, 1145359496, 387397934, 3301201811, 2812801621, 2122220284, 1027426170, 1684319432, 1566435258, 421079858, 1936954854, 1616945344, 2172753945, 1330631070, 3705438115, 572679748, 707427924, 2425400123, 2290647819, 1179044492, 4008585671, 3099120491, 336870440, 3739122087, 1583276732, 185277718, 3688593069, 3772791771, 842159716, 976899700, 168435220, 1229577106, 101059084, 606366792, 1549591736, 3267517855, 3553849021, 2897014595, 1650632388, 2442242105, 2509612081, 3840161747, 2038008818, 3890688725, 3368567691, 926374254, 1835907034, 2374863873, 3587531953, 1313788572, 2846482505, 1819063512, 1448540844, 4109633523, 3941213647, 1701162954, 2054852340, 2930698567, 134748176, 3132806511, 2021165296, 623210314, 774795868, 471606328, 2795958615, 3031746419, 3334885783, 3907527627, 3722280097, 1953799400, 522133822, 1263263126, 3183336545, 2341176845, 2324333839, 1886425312, 1044267644, 3048588401, 1718004428, 1212733584, 50529542, 4143317495, 235803164, 1633788866, 892690282, 1465383342, 3115962473, 2256965911, 3250673817, 488449850, 2661202215, 3789633753, 4177007595, 2560144171, 286339874, 1768537042, 3654906025, 2391705863, 2492770099, 2610673197, 505291324, 2273808917, 3924369609, 3469625735, 1431699370, 673740880, 3755965093, 2358021891, 2711746649, 2307489801, 218961690, 3217021541, 3873845719, 1111672452, 1751693520, 1094828930, 2576986153, 757954394, 252645662, 2964376443, 1414855848, 3149649517, 370555436];
      var T5 = [1374988112, 2118214995, 437757123, 975658646, 1001089995, 530400753, 2902087851, 1273168787, 540080725, 2910219766, 2295101073, 4110568485, 1340463100, 3307916247, 641025152, 3043140495, 3736164937, 632953703, 1172967064, 1576976609, 3274667266, 2169303058, 2370213795, 1809054150, 59727847, 361929877, 3211623147, 2505202138, 3569255213, 1484005843, 1239443753, 2395588676, 1975683434, 4102977912, 2572697195, 666464733, 3202437046, 4035489047, 3374361702, 2110667444, 1675577880, 3843699074, 2538681184, 1649639237, 2976151520, 3144396420, 4269907996, 4178062228, 1883793496, 2403728665, 2497604743, 1383856311, 2876494627, 1917518562, 3810496343, 1716890410, 3001755655, 800440835, 2261089178, 3543599269, 807962610, 599762354, 33778362, 3977675356, 2328828971, 2809771154, 4077384432, 1315562145, 1708848333, 101039829, 3509871135, 3299278474, 875451293, 2733856160, 92987698, 2767645557, 193195065, 1080094634, 1584504582, 3178106961, 1042385657, 2531067453, 3711829422, 1306967366, 2438237621, 1908694277, 67556463, 1615861247, 429456164, 3602770327, 2302690252, 1742315127, 2968011453, 126454664, 3877198648, 2043211483, 2709260871, 2084704233, 4169408201, 0, 159417987, 841739592, 504459436, 1817866830, 4245618683, 260388950, 1034867998, 908933415, 168810852, 1750902305, 2606453969, 607530554, 202008497, 2472011535, 3035535058, 463180190, 2160117071, 1641816226, 1517767529, 470948374, 3801332234, 3231722213, 1008918595, 303765277, 235474187, 4069246893, 766945465, 337553864, 1475418501, 2943682380, 4003061179, 2743034109, 4144047775, 1551037884, 1147550661, 1543208500, 2336434550, 3408119516, 3069049960, 3102011747, 3610369226, 1113818384, 328671808, 2227573024, 2236228733, 3535486456, 2935566865, 3341394285, 496906059, 3702665459, 226906860, 2009195472, 733156972, 2842737049, 294930682, 1206477858, 2835123396, 2700099354, 1451044056, 573804783, 2269728455, 3644379585, 2362090238, 2564033334, 2801107407, 2776292904, 3669462566, 1068351396, 742039012, 1350078989, 1784663195, 1417561698, 4136440770, 2430122216, 775550814, 2193862645, 2673705150, 1775276924, 1876241833, 3475313331, 3366754619, 270040487, 3902563182, 3678124923, 3441850377, 1851332852, 3969562369, 2203032232, 3868552805, 2868897406, 566021896, 4011190502, 3135740889, 1248802510, 3936291284, 699432150, 832877231, 708780849, 3332740144, 899835584, 1951317047, 4236429990, 3767586992, 866637845, 4043610186, 1106041591, 2144161806, 395441711, 1984812685, 1139781709, 3433712980, 3835036895, 2664543715, 1282050075, 3240894392, 1181045119, 2640243204, 25965917, 4203181171, 4211818798, 3009879386, 2463879762, 3910161971, 1842759443, 2597806476, 933301370, 1509430414, 3943906441, 3467192302, 3076639029, 3776767469, 2051518780, 2631065433, 1441952575, 404016761, 1942435775, 1408749034, 1610459739, 3745345300, 2017778566, 3400528769, 3110650942, 941896748, 3265478751, 371049330, 3168937228, 675039627, 4279080257, 967311729, 135050206, 3635733660, 1683407248, 2076935265, 3576870512, 1215061108, 3501741890];
      var T6 = [1347548327, 1400783205, 3273267108, 2520393566, 3409685355, 4045380933, 2880240216, 2471224067, 1428173050, 4138563181, 2441661558, 636813900, 4233094615, 3620022987, 2149987652, 2411029155, 1239331162, 1730525723, 2554718734, 3781033664, 46346101, 310463728, 2743944855, 3328955385, 3875770207, 2501218972, 3955191162, 3667219033, 768917123, 3545789473, 692707433, 1150208456, 1786102409, 2029293177, 1805211710, 3710368113, 3065962831, 401639597, 1724457132, 3028143674, 409198410, 2196052529, 1620529459, 1164071807, 3769721975, 2226875310, 486441376, 2499348523, 1483753576, 428819965, 2274680428, 3075636216, 598438867, 3799141122, 1474502543, 711349675, 129166120, 53458370, 2592523643, 2782082824, 4063242375, 2988687269, 3120694122, 1559041666, 730517276, 2460449204, 4042459122, 2706270690, 3446004468, 3573941694, 533804130, 2328143614, 2637442643, 2695033685, 839224033, 1973745387, 957055980, 2856345839, 106852767, 1371368976, 4181598602, 1033297158, 2933734917, 1179510461, 3046200461, 91341917, 1862534868, 4284502037, 605657339, 2547432937, 3431546947, 2003294622, 3182487618, 2282195339, 954669403, 3682191598, 1201765386, 3917234703, 3388507166, 0, 2198438022, 1211247597, 2887651696, 1315723890, 4227665663, 1443857720, 507358933, 657861945, 1678381017, 560487590, 3516619604, 975451694, 2970356327, 261314535, 3535072918, 2652609425, 1333838021, 2724322336, 1767536459, 370938394, 182621114, 3854606378, 1128014560, 487725847, 185469197, 2918353863, 3106780840, 3356761769, 2237133081, 1286567175, 3152976349, 4255350624, 2683765030, 3160175349, 3309594171, 878443390, 1988838185, 3704300486, 1756818940, 1673061617, 3403100636, 272786309, 1075025698, 545572369, 2105887268, 4174560061, 296679730, 1841768865, 1260232239, 4091327024, 3960309330, 3497509347, 1814803222, 2578018489, 4195456072, 575138148, 3299409036, 446754879, 3629546796, 4011996048, 3347532110, 3252238545, 4270639778, 915985419, 3483825537, 681933534, 651868046, 2755636671, 3828103837, 223377554, 2607439820, 1649704518, 3270937875, 3901806776, 1580087799, 4118987695, 3198115200, 2087309459, 2842678573, 3016697106, 1003007129, 2802849917, 1860738147, 2077965243, 164439672, 4100872472, 32283319, 2827177882, 1709610350, 2125135846, 136428751, 3874428392, 3652904859, 3460984630, 3572145929, 3593056380, 2939266226, 824852259, 818324884, 3224740454, 930369212, 2801566410, 2967507152, 355706840, 1257309336, 4148292826, 243256656, 790073846, 2373340630, 1296297904, 1422699085, 3756299780, 3818836405, 457992840, 3099667487, 2135319889, 77422314, 1560382517, 1945798516, 788204353, 1521706781, 1385356242, 870912086, 325965383, 2358957921, 2050466060, 2388260884, 2313884476, 4006521127, 901210569, 3990953189, 1014646705, 1503449823, 1062597235, 2031621326, 3212035895, 3931371469, 1533017514, 350174575, 2256028891, 2177544179, 1052338372, 741876788, 1606591296, 1914052035, 213705253, 2334669897, 1107234197, 1899603969, 3725069491, 2631447780, 2422494913, 1635502980, 1893020342, 1950903388, 1120974935];
      var T7 = [2807058932, 1699970625, 2764249623, 1586903591, 1808481195, 1173430173, 1487645946, 59984867, 4199882800, 1844882806, 1989249228, 1277555970, 3623636965, 3419915562, 1149249077, 2744104290, 1514790577, 459744698, 244860394, 3235995134, 1963115311, 4027744588, 2544078150, 4190530515, 1608975247, 2627016082, 2062270317, 1507497298, 2200818878, 567498868, 1764313568, 3359936201, 2305455554, 2037970062, 1047239e3, 1910319033, 1337376481, 2904027272, 2892417312, 984907214, 1243112415, 830661914, 861968209, 2135253587, 2011214180, 2927934315, 2686254721, 731183368, 1750626376, 4246310725, 1820824798, 4172763771, 3542330227, 48394827, 2404901663, 2871682645, 671593195, 3254988725, 2073724613, 145085239, 2280796200, 2779915199, 1790575107, 2187128086, 472615631, 3029510009, 4075877127, 3802222185, 4107101658, 3201631749, 1646252340, 4270507174, 1402811438, 1436590835, 3778151818, 3950355702, 3963161475, 4020912224, 2667994737, 273792366, 2331590177, 104699613, 95345982, 3175501286, 2377486676, 1560637892, 3564045318, 369057872, 4213447064, 3919042237, 1137477952, 2658625497, 1119727848, 2340947849, 1530455833, 4007360968, 172466556, 266959938, 516552836, 0, 2256734592, 3980931627, 1890328081, 1917742170, 4294704398, 945164165, 3575528878, 958871085, 3647212047, 2787207260, 1423022939, 775562294, 1739656202, 3876557655, 2530391278, 2443058075, 3310321856, 547512796, 1265195639, 437656594, 3121275539, 719700128, 3762502690, 387781147, 218828297, 3350065803, 2830708150, 2848461854, 428169201, 122466165, 3720081049, 1627235199, 648017665, 4122762354, 1002783846, 2117360635, 695634755, 3336358691, 4234721005, 4049844452, 3704280881, 2232435299, 574624663, 287343814, 612205898, 1039717051, 840019705, 2708326185, 793451934, 821288114, 1391201670, 3822090177, 376187827, 3113855344, 1224348052, 1679968233, 2361698556, 1058709744, 752375421, 2431590963, 1321699145, 3519142200, 2734591178, 188127444, 2177869557, 3727205754, 2384911031, 3215212461, 2648976442, 2450346104, 3432737375, 1180849278, 331544205, 3102249176, 4150144569, 2952102595, 2159976285, 2474404304, 766078933, 313773861, 2570832044, 2108100632, 1668212892, 3145456443, 2013908262, 418672217, 3070356634, 2594734927, 1852171925, 3867060991, 3473416636, 3907448597, 2614737639, 919489135, 164948639, 2094410160, 2997825956, 590424639, 2486224549, 1723872674, 3157750862, 3399941250, 3501252752, 3625268135, 2555048196, 3673637356, 1343127501, 4130281361, 3599595085, 2957853679, 1297403050, 81781910, 3051593425, 2283490410, 532201772, 1367295589, 3926170974, 895287692, 1953757831, 1093597963, 492483431, 3528626907, 1446242576, 1192455638, 1636604631, 209336225, 344873464, 1015671571, 669961897, 3375740769, 3857572124, 2973530695, 3747192018, 1933530610, 3464042516, 935293895, 3454686199, 2858115069, 1863638845, 3683022916, 4085369519, 3292445032, 875313188, 1080017571, 3279033885, 621591778, 1233856572, 2504130317, 24197544, 3017672716, 3835484340, 3247465558, 2220981195, 3060847922, 1551124588, 1463996600];
      var T8 = [4104605777, 1097159550, 396673818, 660510266, 2875968315, 2638606623, 4200115116, 3808662347, 821712160, 1986918061, 3430322568, 38544885, 3856137295, 718002117, 893681702, 1654886325, 2975484382, 3122358053, 3926825029, 4274053469, 796197571, 1290801793, 1184342925, 3556361835, 2405426947, 2459735317, 1836772287, 1381620373, 3196267988, 1948373848, 3764988233, 3385345166, 3263785589, 2390325492, 1480485785, 3111247143, 3780097726, 2293045232, 548169417, 3459953789, 3746175075, 439452389, 1362321559, 1400849762, 1685577905, 1806599355, 2174754046, 137073913, 1214797936, 1174215055, 3731654548, 2079897426, 1943217067, 1258480242, 529487843, 1437280870, 3945269170, 3049390895, 3313212038, 923313619, 679998e3, 3215307299, 57326082, 377642221, 3474729866, 2041877159, 133361907, 1776460110, 3673476453, 96392454, 878845905, 2801699524, 777231668, 4082475170, 2330014213, 4142626212, 2213296395, 1626319424, 1906247262, 1846563261, 562755902, 3708173718, 1040559837, 3871163981, 1418573201, 3294430577, 114585348, 1343618912, 2566595609, 3186202582, 1078185097, 3651041127, 3896688048, 2307622919, 425408743, 3371096953, 2081048481, 1108339068, 2216610296, 0, 2156299017, 736970802, 292596766, 1517440620, 251657213, 2235061775, 2933202493, 758720310, 265905162, 1554391400, 1532285339, 908999204, 174567692, 1474760595, 4002861748, 2610011675, 3234156416, 3693126241, 2001430874, 303699484, 2478443234, 2687165888, 585122620, 454499602, 151849742, 2345119218, 3064510765, 514443284, 4044981591, 1963412655, 2581445614, 2137062819, 19308535, 1928707164, 1715193156, 4219352155, 1126790795, 600235211, 3992742070, 3841024952, 836553431, 1669664834, 2535604243, 3323011204, 1243905413, 3141400786, 4180808110, 698445255, 2653899549, 2989552604, 2253581325, 3252932727, 3004591147, 1891211689, 2487810577, 3915653703, 4237083816, 4030667424, 2100090966, 865136418, 1229899655, 953270745, 3399679628, 3557504664, 4118925222, 2061379749, 3079546586, 2915017791, 983426092, 2022837584, 1607244650, 2118541908, 2366882550, 3635996816, 972512814, 3283088770, 1568718495, 3499326569, 3576539503, 621982671, 2895723464, 410887952, 2623762152, 1002142683, 645401037, 1494807662, 2595684844, 1335535747, 2507040230, 4293295786, 3167684641, 367585007, 3885750714, 1865862730, 2668221674, 2960971305, 2763173681, 1059270954, 2777952454, 2724642869, 1320957812, 2194319100, 2429595872, 2815956275, 77089521, 3973773121, 3444575871, 2448830231, 1305906550, 4021308739, 2857194700, 2516901860, 3518358430, 1787304780, 740276417, 1699839814, 1592394909, 2352307457, 2272556026, 188821243, 1729977011, 3687994002, 274084841, 3594982253, 3613494426, 2701949495, 4162096729, 322734571, 2837966542, 1640576439, 484830689, 1202797690, 3537852828, 4067639125, 349075736, 3342319475, 4157467219, 4255800159, 1030690015, 1155237496, 2951971274, 1757691577, 607398968, 2738905026, 499347990, 3794078908, 1011452712, 227885567, 2818666809, 213114376, 3034881240, 1455525988, 3414450555, 850817237, 1817998408, 3092726480];
      var U1 = [0, 235474187, 470948374, 303765277, 941896748, 908933415, 607530554, 708780849, 1883793496, 2118214995, 1817866830, 1649639237, 1215061108, 1181045119, 1417561698, 1517767529, 3767586992, 4003061179, 4236429990, 4069246893, 3635733660, 3602770327, 3299278474, 3400528769, 2430122216, 2664543715, 2362090238, 2193862645, 2835123396, 2801107407, 3035535058, 3135740889, 3678124923, 3576870512, 3341394285, 3374361702, 3810496343, 3977675356, 4279080257, 4043610186, 2876494627, 2776292904, 3076639029, 3110650942, 2472011535, 2640243204, 2403728665, 2169303058, 1001089995, 899835584, 666464733, 699432150, 59727847, 226906860, 530400753, 294930682, 1273168787, 1172967064, 1475418501, 1509430414, 1942435775, 2110667444, 1876241833, 1641816226, 2910219766, 2743034109, 2976151520, 3211623147, 2505202138, 2606453969, 2302690252, 2269728455, 3711829422, 3543599269, 3240894392, 3475313331, 3843699074, 3943906441, 4178062228, 4144047775, 1306967366, 1139781709, 1374988112, 1610459739, 1975683434, 2076935265, 1775276924, 1742315127, 1034867998, 866637845, 566021896, 800440835, 92987698, 193195065, 429456164, 395441711, 1984812685, 2017778566, 1784663195, 1683407248, 1315562145, 1080094634, 1383856311, 1551037884, 101039829, 135050206, 437757123, 337553864, 1042385657, 807962610, 573804783, 742039012, 2531067453, 2564033334, 2328828971, 2227573024, 2935566865, 2700099354, 3001755655, 3168937228, 3868552805, 3902563182, 4203181171, 4102977912, 3736164937, 3501741890, 3265478751, 3433712980, 1106041591, 1340463100, 1576976609, 1408749034, 2043211483, 2009195472, 1708848333, 1809054150, 832877231, 1068351396, 766945465, 599762354, 159417987, 126454664, 361929877, 463180190, 2709260871, 2943682380, 3178106961, 3009879386, 2572697195, 2538681184, 2236228733, 2336434550, 3509871135, 3745345300, 3441850377, 3274667266, 3910161971, 3877198648, 4110568485, 4211818798, 2597806476, 2497604743, 2261089178, 2295101073, 2733856160, 2902087851, 3202437046, 2968011453, 3936291284, 3835036895, 4136440770, 4169408201, 3535486456, 3702665459, 3467192302, 3231722213, 2051518780, 1951317047, 1716890410, 1750902305, 1113818384, 1282050075, 1584504582, 1350078989, 168810852, 67556463, 371049330, 404016761, 841739592, 1008918595, 775550814, 540080725, 3969562369, 3801332234, 4035489047, 4269907996, 3569255213, 3669462566, 3366754619, 3332740144, 2631065433, 2463879762, 2160117071, 2395588676, 2767645557, 2868897406, 3102011747, 3069049960, 202008497, 33778362, 270040487, 504459436, 875451293, 975658646, 675039627, 641025152, 2084704233, 1917518562, 1615861247, 1851332852, 1147550661, 1248802510, 1484005843, 1451044056, 933301370, 967311729, 733156972, 632953703, 260388950, 25965917, 328671808, 496906059, 1206477858, 1239443753, 1543208500, 1441952575, 2144161806, 1908694277, 1675577880, 1842759443, 3610369226, 3644379585, 3408119516, 3307916247, 4011190502, 3776767469, 4077384432, 4245618683, 2809771154, 2842737049, 3144396420, 3043140495, 2673705150, 2438237621, 2203032232, 2370213795];
      var U2 = [0, 185469197, 370938394, 487725847, 741876788, 657861945, 975451694, 824852259, 1483753576, 1400783205, 1315723890, 1164071807, 1950903388, 2135319889, 1649704518, 1767536459, 2967507152, 3152976349, 2801566410, 2918353863, 2631447780, 2547432937, 2328143614, 2177544179, 3901806776, 3818836405, 4270639778, 4118987695, 3299409036, 3483825537, 3535072918, 3652904859, 2077965243, 1893020342, 1841768865, 1724457132, 1474502543, 1559041666, 1107234197, 1257309336, 598438867, 681933534, 901210569, 1052338372, 261314535, 77422314, 428819965, 310463728, 3409685355, 3224740454, 3710368113, 3593056380, 3875770207, 3960309330, 4045380933, 4195456072, 2471224067, 2554718734, 2237133081, 2388260884, 3212035895, 3028143674, 2842678573, 2724322336, 4138563181, 4255350624, 3769721975, 3955191162, 3667219033, 3516619604, 3431546947, 3347532110, 2933734917, 2782082824, 3099667487, 3016697106, 2196052529, 2313884476, 2499348523, 2683765030, 1179510461, 1296297904, 1347548327, 1533017514, 1786102409, 1635502980, 2087309459, 2003294622, 507358933, 355706840, 136428751, 53458370, 839224033, 957055980, 605657339, 790073846, 2373340630, 2256028891, 2607439820, 2422494913, 2706270690, 2856345839, 3075636216, 3160175349, 3573941694, 3725069491, 3273267108, 3356761769, 4181598602, 4063242375, 4011996048, 3828103837, 1033297158, 915985419, 730517276, 545572369, 296679730, 446754879, 129166120, 213705253, 1709610350, 1860738147, 1945798516, 2029293177, 1239331162, 1120974935, 1606591296, 1422699085, 4148292826, 4233094615, 3781033664, 3931371469, 3682191598, 3497509347, 3446004468, 3328955385, 2939266226, 2755636671, 3106780840, 2988687269, 2198438022, 2282195339, 2501218972, 2652609425, 1201765386, 1286567175, 1371368976, 1521706781, 1805211710, 1620529459, 2105887268, 1988838185, 533804130, 350174575, 164439672, 46346101, 870912086, 954669403, 636813900, 788204353, 2358957921, 2274680428, 2592523643, 2441661558, 2695033685, 2880240216, 3065962831, 3182487618, 3572145929, 3756299780, 3270937875, 3388507166, 4174560061, 4091327024, 4006521127, 3854606378, 1014646705, 930369212, 711349675, 560487590, 272786309, 457992840, 106852767, 223377554, 1678381017, 1862534868, 1914052035, 2031621326, 1211247597, 1128014560, 1580087799, 1428173050, 32283319, 182621114, 401639597, 486441376, 768917123, 651868046, 1003007129, 818324884, 1503449823, 1385356242, 1333838021, 1150208456, 1973745387, 2125135846, 1673061617, 1756818940, 2970356327, 3120694122, 2802849917, 2887651696, 2637442643, 2520393566, 2334669897, 2149987652, 3917234703, 3799141122, 4284502037, 4100872472, 3309594171, 3460984630, 3545789473, 3629546796, 2050466060, 1899603969, 1814803222, 1730525723, 1443857720, 1560382517, 1075025698, 1260232239, 575138148, 692707433, 878443390, 1062597235, 243256656, 91341917, 409198410, 325965383, 3403100636, 3252238545, 3704300486, 3620022987, 3874428392, 3990953189, 4042459122, 4227665663, 2460449204, 2578018489, 2226875310, 2411029155, 3198115200, 3046200461, 2827177882, 2743944855];
      var U3 = [0, 218828297, 437656594, 387781147, 875313188, 958871085, 775562294, 590424639, 1750626376, 1699970625, 1917742170, 2135253587, 1551124588, 1367295589, 1180849278, 1265195639, 3501252752, 3720081049, 3399941250, 3350065803, 3835484340, 3919042237, 4270507174, 4085369519, 3102249176, 3051593425, 2734591178, 2952102595, 2361698556, 2177869557, 2530391278, 2614737639, 3145456443, 3060847922, 2708326185, 2892417312, 2404901663, 2187128086, 2504130317, 2555048196, 3542330227, 3727205754, 3375740769, 3292445032, 3876557655, 3926170974, 4246310725, 4027744588, 1808481195, 1723872674, 1910319033, 2094410160, 1608975247, 1391201670, 1173430173, 1224348052, 59984867, 244860394, 428169201, 344873464, 935293895, 984907214, 766078933, 547512796, 1844882806, 1627235199, 2011214180, 2062270317, 1507497298, 1423022939, 1137477952, 1321699145, 95345982, 145085239, 532201772, 313773861, 830661914, 1015671571, 731183368, 648017665, 3175501286, 2957853679, 2807058932, 2858115069, 2305455554, 2220981195, 2474404304, 2658625497, 3575528878, 3625268135, 3473416636, 3254988725, 3778151818, 3963161475, 4213447064, 4130281361, 3599595085, 3683022916, 3432737375, 3247465558, 3802222185, 4020912224, 4172763771, 4122762354, 3201631749, 3017672716, 2764249623, 2848461854, 2331590177, 2280796200, 2431590963, 2648976442, 104699613, 188127444, 472615631, 287343814, 840019705, 1058709744, 671593195, 621591778, 1852171925, 1668212892, 1953757831, 2037970062, 1514790577, 1463996600, 1080017571, 1297403050, 3673637356, 3623636965, 3235995134, 3454686199, 4007360968, 3822090177, 4107101658, 4190530515, 2997825956, 3215212461, 2830708150, 2779915199, 2256734592, 2340947849, 2627016082, 2443058075, 172466556, 122466165, 273792366, 492483431, 1047239e3, 861968209, 612205898, 695634755, 1646252340, 1863638845, 2013908262, 1963115311, 1446242576, 1530455833, 1277555970, 1093597963, 1636604631, 1820824798, 2073724613, 1989249228, 1436590835, 1487645946, 1337376481, 1119727848, 164948639, 81781910, 331544205, 516552836, 1039717051, 821288114, 669961897, 719700128, 2973530695, 3157750862, 2871682645, 2787207260, 2232435299, 2283490410, 2667994737, 2450346104, 3647212047, 3564045318, 3279033885, 3464042516, 3980931627, 3762502690, 4150144569, 4199882800, 3070356634, 3121275539, 2904027272, 2686254721, 2200818878, 2384911031, 2570832044, 2486224549, 3747192018, 3528626907, 3310321856, 3359936201, 3950355702, 3867060991, 4049844452, 4234721005, 1739656202, 1790575107, 2108100632, 1890328081, 1402811438, 1586903591, 1233856572, 1149249077, 266959938, 48394827, 369057872, 418672217, 1002783846, 919489135, 567498868, 752375421, 209336225, 24197544, 376187827, 459744698, 945164165, 895287692, 574624663, 793451934, 1679968233, 1764313568, 2117360635, 1933530610, 1343127501, 1560637892, 1243112415, 1192455638, 3704280881, 3519142200, 3336358691, 3419915562, 3907448597, 3857572124, 4075877127, 4294704398, 3029510009, 3113855344, 2927934315, 2744104290, 2159976285, 2377486676, 2594734927, 2544078150];
      var U4 = [0, 151849742, 303699484, 454499602, 607398968, 758720310, 908999204, 1059270954, 1214797936, 1097159550, 1517440620, 1400849762, 1817998408, 1699839814, 2118541908, 2001430874, 2429595872, 2581445614, 2194319100, 2345119218, 3034881240, 3186202582, 2801699524, 2951971274, 3635996816, 3518358430, 3399679628, 3283088770, 4237083816, 4118925222, 4002861748, 3885750714, 1002142683, 850817237, 698445255, 548169417, 529487843, 377642221, 227885567, 77089521, 1943217067, 2061379749, 1640576439, 1757691577, 1474760595, 1592394909, 1174215055, 1290801793, 2875968315, 2724642869, 3111247143, 2960971305, 2405426947, 2253581325, 2638606623, 2487810577, 3808662347, 3926825029, 4044981591, 4162096729, 3342319475, 3459953789, 3576539503, 3693126241, 1986918061, 2137062819, 1685577905, 1836772287, 1381620373, 1532285339, 1078185097, 1229899655, 1040559837, 923313619, 740276417, 621982671, 439452389, 322734571, 137073913, 19308535, 3871163981, 4021308739, 4104605777, 4255800159, 3263785589, 3414450555, 3499326569, 3651041127, 2933202493, 2815956275, 3167684641, 3049390895, 2330014213, 2213296395, 2566595609, 2448830231, 1305906550, 1155237496, 1607244650, 1455525988, 1776460110, 1626319424, 2079897426, 1928707164, 96392454, 213114376, 396673818, 514443284, 562755902, 679998e3, 865136418, 983426092, 3708173718, 3557504664, 3474729866, 3323011204, 4180808110, 4030667424, 3945269170, 3794078908, 2507040230, 2623762152, 2272556026, 2390325492, 2975484382, 3092726480, 2738905026, 2857194700, 3973773121, 3856137295, 4274053469, 4157467219, 3371096953, 3252932727, 3673476453, 3556361835, 2763173681, 2915017791, 3064510765, 3215307299, 2156299017, 2307622919, 2459735317, 2610011675, 2081048481, 1963412655, 1846563261, 1729977011, 1480485785, 1362321559, 1243905413, 1126790795, 878845905, 1030690015, 645401037, 796197571, 274084841, 425408743, 38544885, 188821243, 3613494426, 3731654548, 3313212038, 3430322568, 4082475170, 4200115116, 3780097726, 3896688048, 2668221674, 2516901860, 2366882550, 2216610296, 3141400786, 2989552604, 2837966542, 2687165888, 1202797690, 1320957812, 1437280870, 1554391400, 1669664834, 1787304780, 1906247262, 2022837584, 265905162, 114585348, 499347990, 349075736, 736970802, 585122620, 972512814, 821712160, 2595684844, 2478443234, 2293045232, 2174754046, 3196267988, 3079546586, 2895723464, 2777952454, 3537852828, 3687994002, 3234156416, 3385345166, 4142626212, 4293295786, 3841024952, 3992742070, 174567692, 57326082, 410887952, 292596766, 777231668, 660510266, 1011452712, 893681702, 1108339068, 1258480242, 1343618912, 1494807662, 1715193156, 1865862730, 1948373848, 2100090966, 2701949495, 2818666809, 3004591147, 3122358053, 2235061775, 2352307457, 2535604243, 2653899549, 3915653703, 3764988233, 4219352155, 4067639125, 3444575871, 3294430577, 3746175075, 3594982253, 836553431, 953270745, 600235211, 718002117, 367585007, 484830689, 133361907, 251657213, 2041877159, 1891211689, 1806599355, 1654886325, 1568718495, 1418573201, 1335535747, 1184342925];
      function convertToInt32(bytes) {
        var result = [];
        for (var i = 0; i < bytes.length; i += 4) {
          result.push(
            bytes[i] << 24 | bytes[i + 1] << 16 | bytes[i + 2] << 8 | bytes[i + 3]
          );
        }
        return result;
      }
      var AES = function(key) {
        if (!(this instanceof AES)) {
          throw Error("AES must be instanitated with `new`");
        }
        Object.defineProperty(this, "key", {
          value: coerceArray(key, true)
        });
        this._prepare();
      };
      AES.prototype._prepare = function() {
        var rounds = numberOfRounds[this.key.length];
        if (rounds == null) {
          throw new Error("invalid key size (must be 16, 24 or 32 bytes)");
        }
        this._Ke = [];
        this._Kd = [];
        for (var i = 0; i <= rounds; i++) {
          this._Ke.push([0, 0, 0, 0]);
          this._Kd.push([0, 0, 0, 0]);
        }
        var roundKeyCount = (rounds + 1) * 4;
        var KC = this.key.length / 4;
        var tk = convertToInt32(this.key);
        var index;
        for (var i = 0; i < KC; i++) {
          index = i >> 2;
          this._Ke[index][i % 4] = tk[i];
          this._Kd[rounds - index][i % 4] = tk[i];
        }
        var rconpointer = 0;
        var t = KC, tt;
        while (t < roundKeyCount) {
          tt = tk[KC - 1];
          tk[0] ^= S[tt >> 16 & 255] << 24 ^ S[tt >> 8 & 255] << 16 ^ S[tt & 255] << 8 ^ S[tt >> 24 & 255] ^ rcon[rconpointer] << 24;
          rconpointer += 1;
          if (KC != 8) {
            for (var i = 1; i < KC; i++) {
              tk[i] ^= tk[i - 1];
            }
          } else {
            for (var i = 1; i < KC / 2; i++) {
              tk[i] ^= tk[i - 1];
            }
            tt = tk[KC / 2 - 1];
            tk[KC / 2] ^= S[tt & 255] ^ S[tt >> 8 & 255] << 8 ^ S[tt >> 16 & 255] << 16 ^ S[tt >> 24 & 255] << 24;
            for (var i = KC / 2 + 1; i < KC; i++) {
              tk[i] ^= tk[i - 1];
            }
          }
          var i = 0, r, c;
          while (i < KC && t < roundKeyCount) {
            r = t >> 2;
            c = t % 4;
            this._Ke[r][c] = tk[i];
            this._Kd[rounds - r][c] = tk[i++];
            t++;
          }
        }
        for (var r = 1; r < rounds; r++) {
          for (var c = 0; c < 4; c++) {
            tt = this._Kd[r][c];
            this._Kd[r][c] = U1[tt >> 24 & 255] ^ U2[tt >> 16 & 255] ^ U3[tt >> 8 & 255] ^ U4[tt & 255];
          }
        }
      };
      AES.prototype.encrypt = function(plaintext) {
        if (plaintext.length != 16) {
          throw new Error("invalid plaintext size (must be 16 bytes)");
        }
        var rounds = this._Ke.length - 1;
        var a = [0, 0, 0, 0];
        var t = convertToInt32(plaintext);
        for (var i = 0; i < 4; i++) {
          t[i] ^= this._Ke[0][i];
        }
        for (var r = 1; r < rounds; r++) {
          for (var i = 0; i < 4; i++) {
            a[i] = T1[t[i] >> 24 & 255] ^ T2[t[(i + 1) % 4] >> 16 & 255] ^ T3[t[(i + 2) % 4] >> 8 & 255] ^ T4[t[(i + 3) % 4] & 255] ^ this._Ke[r][i];
          }
          t = a.slice();
        }
        var result = createArray(16), tt;
        for (var i = 0; i < 4; i++) {
          tt = this._Ke[rounds][i];
          result[4 * i] = (S[t[i] >> 24 & 255] ^ tt >> 24) & 255;
          result[4 * i + 1] = (S[t[(i + 1) % 4] >> 16 & 255] ^ tt >> 16) & 255;
          result[4 * i + 2] = (S[t[(i + 2) % 4] >> 8 & 255] ^ tt >> 8) & 255;
          result[4 * i + 3] = (S[t[(i + 3) % 4] & 255] ^ tt) & 255;
        }
        return result;
      };
      AES.prototype.decrypt = function(ciphertext) {
        if (ciphertext.length != 16) {
          throw new Error("invalid ciphertext size (must be 16 bytes)");
        }
        var rounds = this._Kd.length - 1;
        var a = [0, 0, 0, 0];
        var t = convertToInt32(ciphertext);
        for (var i = 0; i < 4; i++) {
          t[i] ^= this._Kd[0][i];
        }
        for (var r = 1; r < rounds; r++) {
          for (var i = 0; i < 4; i++) {
            a[i] = T5[t[i] >> 24 & 255] ^ T6[t[(i + 3) % 4] >> 16 & 255] ^ T7[t[(i + 2) % 4] >> 8 & 255] ^ T8[t[(i + 1) % 4] & 255] ^ this._Kd[r][i];
          }
          t = a.slice();
        }
        var result = createArray(16), tt;
        for (var i = 0; i < 4; i++) {
          tt = this._Kd[rounds][i];
          result[4 * i] = (Si[t[i] >> 24 & 255] ^ tt >> 24) & 255;
          result[4 * i + 1] = (Si[t[(i + 3) % 4] >> 16 & 255] ^ tt >> 16) & 255;
          result[4 * i + 2] = (Si[t[(i + 2) % 4] >> 8 & 255] ^ tt >> 8) & 255;
          result[4 * i + 3] = (Si[t[(i + 1) % 4] & 255] ^ tt) & 255;
        }
        return result;
      };
      var ModeOfOperationECB = function(key) {
        if (!(this instanceof ModeOfOperationECB)) {
          throw Error("AES must be instanitated with `new`");
        }
        this.description = "Electronic Code Block";
        this.name = "ecb";
        this._aes = new AES(key);
      };
      ModeOfOperationECB.prototype.encrypt = function(plaintext) {
        plaintext = coerceArray(plaintext);
        if (plaintext.length % 16 !== 0) {
          throw new Error("invalid plaintext size (must be multiple of 16 bytes)");
        }
        var ciphertext = createArray(plaintext.length);
        var block = createArray(16);
        for (var i = 0; i < plaintext.length; i += 16) {
          copyArray(plaintext, block, 0, i, i + 16);
          block = this._aes.encrypt(block);
          copyArray(block, ciphertext, i);
        }
        return ciphertext;
      };
      ModeOfOperationECB.prototype.decrypt = function(ciphertext) {
        ciphertext = coerceArray(ciphertext);
        if (ciphertext.length % 16 !== 0) {
          throw new Error("invalid ciphertext size (must be multiple of 16 bytes)");
        }
        var plaintext = createArray(ciphertext.length);
        var block = createArray(16);
        for (var i = 0; i < ciphertext.length; i += 16) {
          copyArray(ciphertext, block, 0, i, i + 16);
          block = this._aes.decrypt(block);
          copyArray(block, plaintext, i);
        }
        return plaintext;
      };
      var ModeOfOperationCBC = function(key, iv) {
        if (!(this instanceof ModeOfOperationCBC)) {
          throw Error("AES must be instanitated with `new`");
        }
        this.description = "Cipher Block Chaining";
        this.name = "cbc";
        if (!iv) {
          iv = createArray(16);
        } else if (iv.length != 16) {
          throw new Error("invalid initialation vector size (must be 16 bytes)");
        }
        this._lastCipherblock = coerceArray(iv, true);
        this._aes = new AES(key);
      };
      ModeOfOperationCBC.prototype.encrypt = function(plaintext) {
        plaintext = coerceArray(plaintext);
        if (plaintext.length % 16 !== 0) {
          throw new Error("invalid plaintext size (must be multiple of 16 bytes)");
        }
        var ciphertext = createArray(plaintext.length);
        var block = createArray(16);
        for (var i = 0; i < plaintext.length; i += 16) {
          copyArray(plaintext, block, 0, i, i + 16);
          for (var j = 0; j < 16; j++) {
            block[j] ^= this._lastCipherblock[j];
          }
          this._lastCipherblock = this._aes.encrypt(block);
          copyArray(this._lastCipherblock, ciphertext, i);
        }
        return ciphertext;
      };
      ModeOfOperationCBC.prototype.decrypt = function(ciphertext) {
        ciphertext = coerceArray(ciphertext);
        if (ciphertext.length % 16 !== 0) {
          throw new Error("invalid ciphertext size (must be multiple of 16 bytes)");
        }
        var plaintext = createArray(ciphertext.length);
        var block = createArray(16);
        for (var i = 0; i < ciphertext.length; i += 16) {
          copyArray(ciphertext, block, 0, i, i + 16);
          block = this._aes.decrypt(block);
          for (var j = 0; j < 16; j++) {
            plaintext[i + j] = block[j] ^ this._lastCipherblock[j];
          }
          copyArray(ciphertext, this._lastCipherblock, 0, i, i + 16);
        }
        return plaintext;
      };
      var ModeOfOperationCFB = function(key, iv, segmentSize) {
        if (!(this instanceof ModeOfOperationCFB)) {
          throw Error("AES must be instanitated with `new`");
        }
        this.description = "Cipher Feedback";
        this.name = "cfb";
        if (!iv) {
          iv = createArray(16);
        } else if (iv.length != 16) {
          throw new Error("invalid initialation vector size (must be 16 size)");
        }
        if (!segmentSize) {
          segmentSize = 1;
        }
        this.segmentSize = segmentSize;
        this._shiftRegister = coerceArray(iv, true);
        this._aes = new AES(key);
      };
      ModeOfOperationCFB.prototype.encrypt = function(plaintext) {
        if (plaintext.length % this.segmentSize != 0) {
          throw new Error("invalid plaintext size (must be segmentSize bytes)");
        }
        var encrypted = coerceArray(plaintext, true);
        var xorSegment;
        for (var i = 0; i < encrypted.length; i += this.segmentSize) {
          xorSegment = this._aes.encrypt(this._shiftRegister);
          for (var j = 0; j < this.segmentSize; j++) {
            encrypted[i + j] ^= xorSegment[j];
          }
          copyArray(this._shiftRegister, this._shiftRegister, 0, this.segmentSize);
          copyArray(encrypted, this._shiftRegister, 16 - this.segmentSize, i, i + this.segmentSize);
        }
        return encrypted;
      };
      ModeOfOperationCFB.prototype.decrypt = function(ciphertext) {
        if (ciphertext.length % this.segmentSize != 0) {
          throw new Error("invalid ciphertext size (must be segmentSize bytes)");
        }
        var plaintext = coerceArray(ciphertext, true);
        var xorSegment;
        for (var i = 0; i < plaintext.length; i += this.segmentSize) {
          xorSegment = this._aes.encrypt(this._shiftRegister);
          for (var j = 0; j < this.segmentSize; j++) {
            plaintext[i + j] ^= xorSegment[j];
          }
          copyArray(this._shiftRegister, this._shiftRegister, 0, this.segmentSize);
          copyArray(ciphertext, this._shiftRegister, 16 - this.segmentSize, i, i + this.segmentSize);
        }
        return plaintext;
      };
      var ModeOfOperationOFB = function(key, iv) {
        if (!(this instanceof ModeOfOperationOFB)) {
          throw Error("AES must be instanitated with `new`");
        }
        this.description = "Output Feedback";
        this.name = "ofb";
        if (!iv) {
          iv = createArray(16);
        } else if (iv.length != 16) {
          throw new Error("invalid initialation vector size (must be 16 bytes)");
        }
        this._lastPrecipher = coerceArray(iv, true);
        this._lastPrecipherIndex = 16;
        this._aes = new AES(key);
      };
      ModeOfOperationOFB.prototype.encrypt = function(plaintext) {
        var encrypted = coerceArray(plaintext, true);
        for (var i = 0; i < encrypted.length; i++) {
          if (this._lastPrecipherIndex === 16) {
            this._lastPrecipher = this._aes.encrypt(this._lastPrecipher);
            this._lastPrecipherIndex = 0;
          }
          encrypted[i] ^= this._lastPrecipher[this._lastPrecipherIndex++];
        }
        return encrypted;
      };
      ModeOfOperationOFB.prototype.decrypt = ModeOfOperationOFB.prototype.encrypt;
      var Counter = function(initialValue) {
        if (!(this instanceof Counter)) {
          throw Error("Counter must be instanitated with `new`");
        }
        if (initialValue !== 0 && !initialValue) {
          initialValue = 1;
        }
        if (typeof initialValue === "number") {
          this._counter = createArray(16);
          this.setValue(initialValue);
        } else {
          this.setBytes(initialValue);
        }
      };
      Counter.prototype.setValue = function(value) {
        if (typeof value !== "number" || parseInt(value) != value) {
          throw new Error("invalid counter value (must be an integer)");
        }
        for (var index = 15; index >= 0; --index) {
          this._counter[index] = value % 256;
          value = value >> 8;
        }
      };
      Counter.prototype.setBytes = function(bytes) {
        bytes = coerceArray(bytes, true);
        if (bytes.length != 16) {
          throw new Error("invalid counter bytes size (must be 16 bytes)");
        }
        this._counter = bytes;
      };
      Counter.prototype.increment = function() {
        for (var i = 15; i >= 0; i--) {
          if (this._counter[i] === 255) {
            this._counter[i] = 0;
          } else {
            this._counter[i]++;
            break;
          }
        }
      };
      var ModeOfOperationCTR = function(key, counter) {
        if (!(this instanceof ModeOfOperationCTR)) {
          throw Error("AES must be instanitated with `new`");
        }
        this.description = "Counter";
        this.name = "ctr";
        if (!(counter instanceof Counter)) {
          counter = new Counter(counter);
        }
        this._counter = counter;
        this._remainingCounter = null;
        this._remainingCounterIndex = 16;
        this._aes = new AES(key);
      };
      ModeOfOperationCTR.prototype.encrypt = function(plaintext) {
        var encrypted = coerceArray(plaintext, true);
        for (var i = 0; i < encrypted.length; i++) {
          if (this._remainingCounterIndex === 16) {
            this._remainingCounter = this._aes.encrypt(this._counter._counter);
            this._remainingCounterIndex = 0;
            this._counter.increment();
          }
          encrypted[i] ^= this._remainingCounter[this._remainingCounterIndex++];
        }
        return encrypted;
      };
      ModeOfOperationCTR.prototype.decrypt = ModeOfOperationCTR.prototype.encrypt;
      function pkcs7pad(data) {
        data = coerceArray(data, true);
        var padder = 16 - data.length % 16;
        var result = createArray(data.length + padder);
        copyArray(data, result);
        for (var i = data.length; i < result.length; i++) {
          result[i] = padder;
        }
        return result;
      }
      function pkcs7strip(data) {
        data = coerceArray(data, true);
        if (data.length < 16) {
          throw new Error("PKCS#7 invalid length");
        }
        var padder = data[data.length - 1];
        if (padder > 16) {
          throw new Error("PKCS#7 padding byte out of range");
        }
        var length = data.length - padder;
        for (var i = 0; i < padder; i++) {
          if (data[length + i] !== padder) {
            throw new Error("PKCS#7 invalid padding byte");
          }
        }
        var result = createArray(length);
        copyArray(data, result, 0, 0, length);
        return result;
      }
      var aesjs = {
        AES,
        Counter,
        ModeOfOperation: {
          ecb: ModeOfOperationECB,
          cbc: ModeOfOperationCBC,
          cfb: ModeOfOperationCFB,
          ofb: ModeOfOperationOFB,
          ctr: ModeOfOperationCTR
        },
        utils: {
          hex: convertHex,
          utf8: convertUtf8
        },
        padding: {
          pkcs7: {
            pad: pkcs7pad,
            strip: pkcs7strip
          }
        },
        _arrayTest: {
          coerceArray,
          createArray,
          copyArray
        }
      };
      if (typeof exports2 !== "undefined") {
        module2.exports = aesjs;
      } else if (typeof define === "function" && define.amd) {
        define(aesjs);
      } else {
        if (root.aesjs) {
          aesjs._aesjs = root.aesjs;
        }
        root.aesjs = aesjs;
      }
    })(exports2);
  }
});

// node_modules/@ethersproject/json-wallets/lib/_version.js
var require_version18 = __commonJS({
  "node_modules/@ethersproject/json-wallets/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "json-wallets/5.5.0";
  }
});

// node_modules/@ethersproject/json-wallets/lib/utils.js
var require_utils4 = __commonJS({
  "node_modules/@ethersproject/json-wallets/lib/utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.uuidV4 = exports2.searchPath = exports2.getPassword = exports2.zpad = exports2.looseArrayify = void 0;
    var bytes_1 = require_lib2();
    var strings_1 = require_lib9();
    function looseArrayify(hexString) {
      if (typeof hexString === "string" && hexString.substring(0, 2) !== "0x") {
        hexString = "0x" + hexString;
      }
      return (0, bytes_1.arrayify)(hexString);
    }
    exports2.looseArrayify = looseArrayify;
    function zpad(value, length) {
      value = String(value);
      while (value.length < length) {
        value = "0" + value;
      }
      return value;
    }
    exports2.zpad = zpad;
    function getPassword(password) {
      if (typeof password === "string") {
        return (0, strings_1.toUtf8Bytes)(password, strings_1.UnicodeNormalizationForm.NFKC);
      }
      return (0, bytes_1.arrayify)(password);
    }
    exports2.getPassword = getPassword;
    function searchPath(object, path) {
      var currentChild = object;
      var comps = path.toLowerCase().split("/");
      for (var i = 0; i < comps.length; i++) {
        var matchingChild = null;
        for (var key in currentChild) {
          if (key.toLowerCase() === comps[i]) {
            matchingChild = currentChild[key];
            break;
          }
        }
        if (matchingChild === null) {
          return null;
        }
        currentChild = matchingChild;
      }
      return currentChild;
    }
    exports2.searchPath = searchPath;
    function uuidV4(randomBytes) {
      var bytes = (0, bytes_1.arrayify)(randomBytes);
      bytes[6] = bytes[6] & 15 | 64;
      bytes[8] = bytes[8] & 63 | 128;
      var value = (0, bytes_1.hexlify)(bytes);
      return [
        value.substring(2, 10),
        value.substring(10, 14),
        value.substring(14, 18),
        value.substring(18, 22),
        value.substring(22, 34)
      ].join("-");
    }
    exports2.uuidV4 = uuidV4;
  }
});

// node_modules/@ethersproject/json-wallets/lib/crowdsale.js
var require_crowdsale = __commonJS({
  "node_modules/@ethersproject/json-wallets/lib/crowdsale.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.decrypt = exports2.CrowdsaleAccount = void 0;
    var aes_js_1 = __importDefault(require_aes_js());
    var address_1 = require_lib7();
    var bytes_1 = require_lib2();
    var keccak256_1 = require_lib5();
    var pbkdf2_1 = require_lib18();
    var strings_1 = require_lib9();
    var properties_1 = require_lib4();
    var logger_1 = require_lib();
    var _version_1 = require_version18();
    var logger = new logger_1.Logger(_version_1.version);
    var utils_1 = require_utils4();
    var CrowdsaleAccount = (
      /** @class */
      function(_super) {
        __extends(CrowdsaleAccount2, _super);
        function CrowdsaleAccount2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        CrowdsaleAccount2.prototype.isCrowdsaleAccount = function(value) {
          return !!(value && value._isCrowdsaleAccount);
        };
        return CrowdsaleAccount2;
      }(properties_1.Description)
    );
    exports2.CrowdsaleAccount = CrowdsaleAccount;
    function decrypt(json, password) {
      var data = JSON.parse(json);
      password = (0, utils_1.getPassword)(password);
      var ethaddr = (0, address_1.getAddress)((0, utils_1.searchPath)(data, "ethaddr"));
      var encseed = (0, utils_1.looseArrayify)((0, utils_1.searchPath)(data, "encseed"));
      if (!encseed || encseed.length % 16 !== 0) {
        logger.throwArgumentError("invalid encseed", "json", json);
      }
      var key = (0, bytes_1.arrayify)((0, pbkdf2_1.pbkdf2)(password, password, 2e3, 32, "sha256")).slice(0, 16);
      var iv = encseed.slice(0, 16);
      var encryptedSeed = encseed.slice(16);
      var aesCbc = new aes_js_1.default.ModeOfOperation.cbc(key, iv);
      var seed = aes_js_1.default.padding.pkcs7.strip((0, bytes_1.arrayify)(aesCbc.decrypt(encryptedSeed)));
      var seedHex = "";
      for (var i = 0; i < seed.length; i++) {
        seedHex += String.fromCharCode(seed[i]);
      }
      var seedHexBytes = (0, strings_1.toUtf8Bytes)(seedHex);
      var privateKey = (0, keccak256_1.keccak256)(seedHexBytes);
      return new CrowdsaleAccount({
        _isCrowdsaleAccount: true,
        address: ethaddr,
        privateKey
      });
    }
    exports2.decrypt = decrypt;
  }
});

// node_modules/@ethersproject/json-wallets/lib/inspect.js
var require_inspect = __commonJS({
  "node_modules/@ethersproject/json-wallets/lib/inspect.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getJsonWalletAddress = exports2.isKeystoreWallet = exports2.isCrowdsaleWallet = void 0;
    var address_1 = require_lib7();
    function isCrowdsaleWallet(json) {
      var data = null;
      try {
        data = JSON.parse(json);
      } catch (error) {
        return false;
      }
      return data.encseed && data.ethaddr;
    }
    exports2.isCrowdsaleWallet = isCrowdsaleWallet;
    function isKeystoreWallet(json) {
      var data = null;
      try {
        data = JSON.parse(json);
      } catch (error) {
        return false;
      }
      if (!data.version || parseInt(data.version) !== data.version || parseInt(data.version) !== 3) {
        return false;
      }
      return true;
    }
    exports2.isKeystoreWallet = isKeystoreWallet;
    function getJsonWalletAddress(json) {
      if (isCrowdsaleWallet(json)) {
        try {
          return (0, address_1.getAddress)(JSON.parse(json).ethaddr);
        } catch (error) {
          return null;
        }
      }
      if (isKeystoreWallet(json)) {
        try {
          return (0, address_1.getAddress)(JSON.parse(json).address);
        } catch (error) {
          return null;
        }
      }
      return null;
    }
    exports2.getJsonWalletAddress = getJsonWalletAddress;
  }
});

// node_modules/scrypt-js/scrypt.js
var require_scrypt = __commonJS({
  "node_modules/scrypt-js/scrypt.js"(exports2, module2) {
    "use strict";
    (function(root) {
      const MAX_VALUE = 2147483647;
      function SHA256(m) {
        const K = new Uint32Array([
          1116352408,
          1899447441,
          3049323471,
          3921009573,
          961987163,
          1508970993,
          2453635748,
          2870763221,
          3624381080,
          310598401,
          607225278,
          1426881987,
          1925078388,
          2162078206,
          2614888103,
          3248222580,
          3835390401,
          4022224774,
          264347078,
          604807628,
          770255983,
          1249150122,
          1555081692,
          1996064986,
          2554220882,
          2821834349,
          2952996808,
          3210313671,
          3336571891,
          3584528711,
          113926993,
          338241895,
          666307205,
          773529912,
          1294757372,
          1396182291,
          1695183700,
          1986661051,
          2177026350,
          2456956037,
          2730485921,
          2820302411,
          3259730800,
          3345764771,
          3516065817,
          3600352804,
          4094571909,
          275423344,
          430227734,
          506948616,
          659060556,
          883997877,
          958139571,
          1322822218,
          1537002063,
          1747873779,
          1955562222,
          2024104815,
          2227730452,
          2361852424,
          2428436474,
          2756734187,
          3204031479,
          3329325298
        ]);
        let h0 = 1779033703, h1 = 3144134277, h2 = 1013904242, h3 = 2773480762;
        let h4 = 1359893119, h5 = 2600822924, h6 = 528734635, h7 = 1541459225;
        const w = new Uint32Array(64);
        function blocks(p2) {
          let off = 0, len = p2.length;
          while (len >= 64) {
            let a = h0, b = h1, c = h2, d = h3, e = h4, f = h5, g = h6, h = h7, u, i2, j, t1, t2;
            for (i2 = 0; i2 < 16; i2++) {
              j = off + i2 * 4;
              w[i2] = (p2[j] & 255) << 24 | (p2[j + 1] & 255) << 16 | (p2[j + 2] & 255) << 8 | p2[j + 3] & 255;
            }
            for (i2 = 16; i2 < 64; i2++) {
              u = w[i2 - 2];
              t1 = (u >>> 17 | u << 32 - 17) ^ (u >>> 19 | u << 32 - 19) ^ u >>> 10;
              u = w[i2 - 15];
              t2 = (u >>> 7 | u << 32 - 7) ^ (u >>> 18 | u << 32 - 18) ^ u >>> 3;
              w[i2] = (t1 + w[i2 - 7] | 0) + (t2 + w[i2 - 16] | 0) | 0;
            }
            for (i2 = 0; i2 < 64; i2++) {
              t1 = (((e >>> 6 | e << 32 - 6) ^ (e >>> 11 | e << 32 - 11) ^ (e >>> 25 | e << 32 - 25)) + (e & f ^ ~e & g) | 0) + (h + (K[i2] + w[i2] | 0) | 0) | 0;
              t2 = ((a >>> 2 | a << 32 - 2) ^ (a >>> 13 | a << 32 - 13) ^ (a >>> 22 | a << 32 - 22)) + (a & b ^ a & c ^ b & c) | 0;
              h = g;
              g = f;
              f = e;
              e = d + t1 | 0;
              d = c;
              c = b;
              b = a;
              a = t1 + t2 | 0;
            }
            h0 = h0 + a | 0;
            h1 = h1 + b | 0;
            h2 = h2 + c | 0;
            h3 = h3 + d | 0;
            h4 = h4 + e | 0;
            h5 = h5 + f | 0;
            h6 = h6 + g | 0;
            h7 = h7 + h | 0;
            off += 64;
            len -= 64;
          }
        }
        blocks(m);
        let i, bytesLeft = m.length % 64, bitLenHi = m.length / 536870912 | 0, bitLenLo = m.length << 3, numZeros = bytesLeft < 56 ? 56 : 120, p = m.slice(m.length - bytesLeft, m.length);
        p.push(128);
        for (i = bytesLeft + 1; i < numZeros; i++) {
          p.push(0);
        }
        p.push(bitLenHi >>> 24 & 255);
        p.push(bitLenHi >>> 16 & 255);
        p.push(bitLenHi >>> 8 & 255);
        p.push(bitLenHi >>> 0 & 255);
        p.push(bitLenLo >>> 24 & 255);
        p.push(bitLenLo >>> 16 & 255);
        p.push(bitLenLo >>> 8 & 255);
        p.push(bitLenLo >>> 0 & 255);
        blocks(p);
        return [
          h0 >>> 24 & 255,
          h0 >>> 16 & 255,
          h0 >>> 8 & 255,
          h0 >>> 0 & 255,
          h1 >>> 24 & 255,
          h1 >>> 16 & 255,
          h1 >>> 8 & 255,
          h1 >>> 0 & 255,
          h2 >>> 24 & 255,
          h2 >>> 16 & 255,
          h2 >>> 8 & 255,
          h2 >>> 0 & 255,
          h3 >>> 24 & 255,
          h3 >>> 16 & 255,
          h3 >>> 8 & 255,
          h3 >>> 0 & 255,
          h4 >>> 24 & 255,
          h4 >>> 16 & 255,
          h4 >>> 8 & 255,
          h4 >>> 0 & 255,
          h5 >>> 24 & 255,
          h5 >>> 16 & 255,
          h5 >>> 8 & 255,
          h5 >>> 0 & 255,
          h6 >>> 24 & 255,
          h6 >>> 16 & 255,
          h6 >>> 8 & 255,
          h6 >>> 0 & 255,
          h7 >>> 24 & 255,
          h7 >>> 16 & 255,
          h7 >>> 8 & 255,
          h7 >>> 0 & 255
        ];
      }
      function PBKDF2_HMAC_SHA256_OneIter(password, salt, dkLen) {
        password = password.length <= 64 ? password : SHA256(password);
        const innerLen = 64 + salt.length + 4;
        const inner = new Array(innerLen);
        const outerKey = new Array(64);
        let i;
        let dk = [];
        for (i = 0; i < 64; i++) {
          inner[i] = 54;
        }
        for (i = 0; i < password.length; i++) {
          inner[i] ^= password[i];
        }
        for (i = 0; i < salt.length; i++) {
          inner[64 + i] = salt[i];
        }
        for (i = innerLen - 4; i < innerLen; i++) {
          inner[i] = 0;
        }
        for (i = 0; i < 64; i++) outerKey[i] = 92;
        for (i = 0; i < password.length; i++) outerKey[i] ^= password[i];
        function incrementCounter() {
          for (let i2 = innerLen - 1; i2 >= innerLen - 4; i2--) {
            inner[i2]++;
            if (inner[i2] <= 255) return;
            inner[i2] = 0;
          }
        }
        while (dkLen >= 32) {
          incrementCounter();
          dk = dk.concat(SHA256(outerKey.concat(SHA256(inner))));
          dkLen -= 32;
        }
        if (dkLen > 0) {
          incrementCounter();
          dk = dk.concat(SHA256(outerKey.concat(SHA256(inner))).slice(0, dkLen));
        }
        return dk;
      }
      function blockmix_salsa8(BY, Yi, r, x, _X) {
        let i;
        arraycopy(BY, (2 * r - 1) * 16, _X, 0, 16);
        for (i = 0; i < 2 * r; i++) {
          blockxor(BY, i * 16, _X, 16);
          salsa20_8(_X, x);
          arraycopy(_X, 0, BY, Yi + i * 16, 16);
        }
        for (i = 0; i < r; i++) {
          arraycopy(BY, Yi + i * 2 * 16, BY, i * 16, 16);
        }
        for (i = 0; i < r; i++) {
          arraycopy(BY, Yi + (i * 2 + 1) * 16, BY, (i + r) * 16, 16);
        }
      }
      function R(a, b) {
        return a << b | a >>> 32 - b;
      }
      function salsa20_8(B, x) {
        arraycopy(B, 0, x, 0, 16);
        for (let i = 8; i > 0; i -= 2) {
          x[4] ^= R(x[0] + x[12], 7);
          x[8] ^= R(x[4] + x[0], 9);
          x[12] ^= R(x[8] + x[4], 13);
          x[0] ^= R(x[12] + x[8], 18);
          x[9] ^= R(x[5] + x[1], 7);
          x[13] ^= R(x[9] + x[5], 9);
          x[1] ^= R(x[13] + x[9], 13);
          x[5] ^= R(x[1] + x[13], 18);
          x[14] ^= R(x[10] + x[6], 7);
          x[2] ^= R(x[14] + x[10], 9);
          x[6] ^= R(x[2] + x[14], 13);
          x[10] ^= R(x[6] + x[2], 18);
          x[3] ^= R(x[15] + x[11], 7);
          x[7] ^= R(x[3] + x[15], 9);
          x[11] ^= R(x[7] + x[3], 13);
          x[15] ^= R(x[11] + x[7], 18);
          x[1] ^= R(x[0] + x[3], 7);
          x[2] ^= R(x[1] + x[0], 9);
          x[3] ^= R(x[2] + x[1], 13);
          x[0] ^= R(x[3] + x[2], 18);
          x[6] ^= R(x[5] + x[4], 7);
          x[7] ^= R(x[6] + x[5], 9);
          x[4] ^= R(x[7] + x[6], 13);
          x[5] ^= R(x[4] + x[7], 18);
          x[11] ^= R(x[10] + x[9], 7);
          x[8] ^= R(x[11] + x[10], 9);
          x[9] ^= R(x[8] + x[11], 13);
          x[10] ^= R(x[9] + x[8], 18);
          x[12] ^= R(x[15] + x[14], 7);
          x[13] ^= R(x[12] + x[15], 9);
          x[14] ^= R(x[13] + x[12], 13);
          x[15] ^= R(x[14] + x[13], 18);
        }
        for (let i = 0; i < 16; ++i) {
          B[i] += x[i];
        }
      }
      function blockxor(S, Si, D, len) {
        for (let i = 0; i < len; i++) {
          D[i] ^= S[Si + i];
        }
      }
      function arraycopy(src, srcPos, dest, destPos, length) {
        while (length--) {
          dest[destPos++] = src[srcPos++];
        }
      }
      function checkBufferish(o) {
        if (!o || typeof o.length !== "number") {
          return false;
        }
        for (let i = 0; i < o.length; i++) {
          const v = o[i];
          if (typeof v !== "number" || v % 1 || v < 0 || v >= 256) {
            return false;
          }
        }
        return true;
      }
      function ensureInteger(value, name2) {
        if (typeof value !== "number" || value % 1) {
          throw new Error("invalid " + name2);
        }
        return value;
      }
      function _scrypt(password, salt, N, r, p, dkLen, callback) {
        N = ensureInteger(N, "N");
        r = ensureInteger(r, "r");
        p = ensureInteger(p, "p");
        dkLen = ensureInteger(dkLen, "dkLen");
        if (N === 0 || (N & N - 1) !== 0) {
          throw new Error("N must be power of 2");
        }
        if (N > MAX_VALUE / 128 / r) {
          throw new Error("N too large");
        }
        if (r > MAX_VALUE / 128 / p) {
          throw new Error("r too large");
        }
        if (!checkBufferish(password)) {
          throw new Error("password must be an array or buffer");
        }
        password = Array.prototype.slice.call(password);
        if (!checkBufferish(salt)) {
          throw new Error("salt must be an array or buffer");
        }
        salt = Array.prototype.slice.call(salt);
        let b = PBKDF2_HMAC_SHA256_OneIter(password, salt, p * 128 * r);
        const B = new Uint32Array(p * 32 * r);
        for (let i = 0; i < B.length; i++) {
          const j = i * 4;
          B[i] = (b[j + 3] & 255) << 24 | (b[j + 2] & 255) << 16 | (b[j + 1] & 255) << 8 | (b[j + 0] & 255) << 0;
        }
        const XY = new Uint32Array(64 * r);
        const V = new Uint32Array(32 * r * N);
        const Yi = 32 * r;
        const x = new Uint32Array(16);
        const _X = new Uint32Array(16);
        const totalOps = p * N * 2;
        let currentOp = 0;
        let lastPercent10 = null;
        let stop = false;
        let state = 0;
        let i0 = 0, i1;
        let Bi;
        const limit = callback ? parseInt(1e3 / r) : 4294967295;
        const nextTick = typeof setImmediate !== "undefined" ? setImmediate : setTimeout;
        const incrementalSMix = function() {
          if (stop) {
            return callback(new Error("cancelled"), currentOp / totalOps);
          }
          let steps;
          switch (state) {
            case 0:
              Bi = i0 * 32 * r;
              arraycopy(B, Bi, XY, 0, Yi);
              state = 1;
              i1 = 0;
            case 1:
              steps = N - i1;
              if (steps > limit) {
                steps = limit;
              }
              for (let i = 0; i < steps; i++) {
                arraycopy(XY, 0, V, (i1 + i) * Yi, Yi);
                blockmix_salsa8(XY, Yi, r, x, _X);
              }
              i1 += steps;
              currentOp += steps;
              if (callback) {
                const percent10 = parseInt(1e3 * currentOp / totalOps);
                if (percent10 !== lastPercent10) {
                  stop = callback(null, currentOp / totalOps);
                  if (stop) {
                    break;
                  }
                  lastPercent10 = percent10;
                }
              }
              if (i1 < N) {
                break;
              }
              i1 = 0;
              state = 2;
            case 2:
              steps = N - i1;
              if (steps > limit) {
                steps = limit;
              }
              for (let i = 0; i < steps; i++) {
                const offset = (2 * r - 1) * 16;
                const j = XY[offset] & N - 1;
                blockxor(V, j * Yi, XY, Yi);
                blockmix_salsa8(XY, Yi, r, x, _X);
              }
              i1 += steps;
              currentOp += steps;
              if (callback) {
                const percent10 = parseInt(1e3 * currentOp / totalOps);
                if (percent10 !== lastPercent10) {
                  stop = callback(null, currentOp / totalOps);
                  if (stop) {
                    break;
                  }
                  lastPercent10 = percent10;
                }
              }
              if (i1 < N) {
                break;
              }
              arraycopy(XY, 0, B, Bi, Yi);
              i0++;
              if (i0 < p) {
                state = 0;
                break;
              }
              b = [];
              for (let i = 0; i < B.length; i++) {
                b.push(B[i] >> 0 & 255);
                b.push(B[i] >> 8 & 255);
                b.push(B[i] >> 16 & 255);
                b.push(B[i] >> 24 & 255);
              }
              const derivedKey = PBKDF2_HMAC_SHA256_OneIter(password, b, dkLen);
              if (callback) {
                callback(null, 1, derivedKey);
              }
              return derivedKey;
          }
          if (callback) {
            nextTick(incrementalSMix);
          }
        };
        if (!callback) {
          while (true) {
            const derivedKey = incrementalSMix();
            if (derivedKey != void 0) {
              return derivedKey;
            }
          }
        }
        incrementalSMix();
      }
      const lib = {
        scrypt: function(password, salt, N, r, p, dkLen, progressCallback) {
          return new Promise(function(resolve, reject) {
            let lastProgress = 0;
            if (progressCallback) {
              progressCallback(0);
            }
            _scrypt(password, salt, N, r, p, dkLen, function(error, progress, key) {
              if (error) {
                reject(error);
              } else if (key) {
                if (progressCallback && lastProgress !== 1) {
                  progressCallback(1);
                }
                resolve(new Uint8Array(key));
              } else if (progressCallback && progress !== lastProgress) {
                lastProgress = progress;
                return progressCallback(progress);
              }
            });
          });
        },
        syncScrypt: function(password, salt, N, r, p, dkLen) {
          return new Uint8Array(_scrypt(password, salt, N, r, p, dkLen));
        }
      };
      if (typeof exports2 !== "undefined") {
        module2.exports = lib;
      } else if (typeof define === "function" && define.amd) {
        define(lib);
      } else if (root) {
        if (root.scrypt) {
          root._scrypt = root.scrypt;
        }
        root.scrypt = lib;
      }
    })(exports2);
  }
});

// node_modules/@ethersproject/json-wallets/lib/keystore.js
var require_keystore = __commonJS({
  "node_modules/@ethersproject/json-wallets/lib/keystore.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator = exports2 && exports2.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1) throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return { value: op[1], done: false };
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2]) _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
        if (op[0] & 5) throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
      }
    };
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.encrypt = exports2.decrypt = exports2.decryptSync = exports2.KeystoreAccount = void 0;
    var aes_js_1 = __importDefault(require_aes_js());
    var scrypt_js_1 = __importDefault(require_scrypt());
    var address_1 = require_lib7();
    var bytes_1 = require_lib2();
    var hdnode_1 = require_lib21();
    var keccak256_1 = require_lib5();
    var pbkdf2_1 = require_lib18();
    var random_1 = require_lib22();
    var properties_1 = require_lib4();
    var transactions_1 = require_lib15();
    var utils_1 = require_utils4();
    var logger_1 = require_lib();
    var _version_1 = require_version18();
    var logger = new logger_1.Logger(_version_1.version);
    function hasMnemonic(value) {
      return value != null && value.mnemonic && value.mnemonic.phrase;
    }
    var KeystoreAccount = (
      /** @class */
      function(_super) {
        __extends(KeystoreAccount2, _super);
        function KeystoreAccount2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        KeystoreAccount2.prototype.isKeystoreAccount = function(value) {
          return !!(value && value._isKeystoreAccount);
        };
        return KeystoreAccount2;
      }(properties_1.Description)
    );
    exports2.KeystoreAccount = KeystoreAccount;
    function _decrypt(data, key, ciphertext) {
      var cipher = (0, utils_1.searchPath)(data, "crypto/cipher");
      if (cipher === "aes-128-ctr") {
        var iv = (0, utils_1.looseArrayify)((0, utils_1.searchPath)(data, "crypto/cipherparams/iv"));
        var counter = new aes_js_1.default.Counter(iv);
        var aesCtr = new aes_js_1.default.ModeOfOperation.ctr(key, counter);
        return (0, bytes_1.arrayify)(aesCtr.decrypt(ciphertext));
      }
      return null;
    }
    function _getAccount(data, key) {
      var ciphertext = (0, utils_1.looseArrayify)((0, utils_1.searchPath)(data, "crypto/ciphertext"));
      var computedMAC = (0, bytes_1.hexlify)((0, keccak256_1.keccak256)((0, bytes_1.concat)([key.slice(16, 32), ciphertext]))).substring(2);
      if (computedMAC !== (0, utils_1.searchPath)(data, "crypto/mac").toLowerCase()) {
        throw new Error("invalid password");
      }
      var privateKey = _decrypt(data, key.slice(0, 16), ciphertext);
      if (!privateKey) {
        logger.throwError("unsupported cipher", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
          operation: "decrypt"
        });
      }
      var mnemonicKey = key.slice(32, 64);
      var address = (0, transactions_1.computeAddress)(privateKey);
      if (data.address) {
        var check = data.address.toLowerCase();
        if (check.substring(0, 2) !== "0x") {
          check = "0x" + check;
        }
        if ((0, address_1.getAddress)(check) !== address) {
          throw new Error("address mismatch");
        }
      }
      var account = {
        _isKeystoreAccount: true,
        address,
        privateKey: (0, bytes_1.hexlify)(privateKey)
      };
      if ((0, utils_1.searchPath)(data, "x-ethers/version") === "0.1") {
        var mnemonicCiphertext = (0, utils_1.looseArrayify)((0, utils_1.searchPath)(data, "x-ethers/mnemonicCiphertext"));
        var mnemonicIv = (0, utils_1.looseArrayify)((0, utils_1.searchPath)(data, "x-ethers/mnemonicCounter"));
        var mnemonicCounter = new aes_js_1.default.Counter(mnemonicIv);
        var mnemonicAesCtr = new aes_js_1.default.ModeOfOperation.ctr(mnemonicKey, mnemonicCounter);
        var path = (0, utils_1.searchPath)(data, "x-ethers/path") || hdnode_1.defaultPath;
        var locale = (0, utils_1.searchPath)(data, "x-ethers/locale") || "en";
        var entropy = (0, bytes_1.arrayify)(mnemonicAesCtr.decrypt(mnemonicCiphertext));
        try {
          var mnemonic = (0, hdnode_1.entropyToMnemonic)(entropy, locale);
          var node = hdnode_1.HDNode.fromMnemonic(mnemonic, null, locale).derivePath(path);
          if (node.privateKey != account.privateKey) {
            throw new Error("mnemonic mismatch");
          }
          account.mnemonic = node.mnemonic;
        } catch (error) {
          if (error.code !== logger_1.Logger.errors.INVALID_ARGUMENT || error.argument !== "wordlist") {
            throw error;
          }
        }
      }
      return new KeystoreAccount(account);
    }
    function pbkdf2Sync(passwordBytes, salt, count, dkLen, prfFunc) {
      return (0, bytes_1.arrayify)((0, pbkdf2_1.pbkdf2)(passwordBytes, salt, count, dkLen, prfFunc));
    }
    function pbkdf2(passwordBytes, salt, count, dkLen, prfFunc) {
      return Promise.resolve(pbkdf2Sync(passwordBytes, salt, count, dkLen, prfFunc));
    }
    function _computeKdfKey(data, password, pbkdf2Func, scryptFunc, progressCallback) {
      var passwordBytes = (0, utils_1.getPassword)(password);
      var kdf = (0, utils_1.searchPath)(data, "crypto/kdf");
      if (kdf && typeof kdf === "string") {
        var throwError = function(name2, value) {
          return logger.throwArgumentError("invalid key-derivation function parameters", name2, value);
        };
        if (kdf.toLowerCase() === "scrypt") {
          var salt = (0, utils_1.looseArrayify)((0, utils_1.searchPath)(data, "crypto/kdfparams/salt"));
          var N = parseInt((0, utils_1.searchPath)(data, "crypto/kdfparams/n"));
          var r = parseInt((0, utils_1.searchPath)(data, "crypto/kdfparams/r"));
          var p = parseInt((0, utils_1.searchPath)(data, "crypto/kdfparams/p"));
          if (!N || !r || !p) {
            throwError("kdf", kdf);
          }
          if ((N & N - 1) !== 0) {
            throwError("N", N);
          }
          var dkLen = parseInt((0, utils_1.searchPath)(data, "crypto/kdfparams/dklen"));
          if (dkLen !== 32) {
            throwError("dklen", dkLen);
          }
          return scryptFunc(passwordBytes, salt, N, r, p, 64, progressCallback);
        } else if (kdf.toLowerCase() === "pbkdf2") {
          var salt = (0, utils_1.looseArrayify)((0, utils_1.searchPath)(data, "crypto/kdfparams/salt"));
          var prfFunc = null;
          var prf = (0, utils_1.searchPath)(data, "crypto/kdfparams/prf");
          if (prf === "hmac-sha256") {
            prfFunc = "sha256";
          } else if (prf === "hmac-sha512") {
            prfFunc = "sha512";
          } else {
            throwError("prf", prf);
          }
          var count = parseInt((0, utils_1.searchPath)(data, "crypto/kdfparams/c"));
          var dkLen = parseInt((0, utils_1.searchPath)(data, "crypto/kdfparams/dklen"));
          if (dkLen !== 32) {
            throwError("dklen", dkLen);
          }
          return pbkdf2Func(passwordBytes, salt, count, dkLen, prfFunc);
        }
      }
      return logger.throwArgumentError("unsupported key-derivation function", "kdf", kdf);
    }
    function decryptSync(json, password) {
      var data = JSON.parse(json);
      var key = _computeKdfKey(data, password, pbkdf2Sync, scrypt_js_1.default.syncScrypt);
      return _getAccount(data, key);
    }
    exports2.decryptSync = decryptSync;
    function decrypt(json, password, progressCallback) {
      return __awaiter(this, void 0, void 0, function() {
        var data, key;
        return __generator(this, function(_a) {
          switch (_a.label) {
            case 0:
              data = JSON.parse(json);
              return [4, _computeKdfKey(data, password, pbkdf2, scrypt_js_1.default.scrypt, progressCallback)];
            case 1:
              key = _a.sent();
              return [2, _getAccount(data, key)];
          }
        });
      });
    }
    exports2.decrypt = decrypt;
    function encrypt(account, password, options, progressCallback) {
      try {
        if ((0, address_1.getAddress)(account.address) !== (0, transactions_1.computeAddress)(account.privateKey)) {
          throw new Error("address/privateKey mismatch");
        }
        if (hasMnemonic(account)) {
          var mnemonic = account.mnemonic;
          var node = hdnode_1.HDNode.fromMnemonic(mnemonic.phrase, null, mnemonic.locale).derivePath(mnemonic.path || hdnode_1.defaultPath);
          if (node.privateKey != account.privateKey) {
            throw new Error("mnemonic mismatch");
          }
        }
      } catch (e) {
        return Promise.reject(e);
      }
      if (typeof options === "function" && !progressCallback) {
        progressCallback = options;
        options = {};
      }
      if (!options) {
        options = {};
      }
      var privateKey = (0, bytes_1.arrayify)(account.privateKey);
      var passwordBytes = (0, utils_1.getPassword)(password);
      var entropy = null;
      var path = null;
      var locale = null;
      if (hasMnemonic(account)) {
        var srcMnemonic = account.mnemonic;
        entropy = (0, bytes_1.arrayify)((0, hdnode_1.mnemonicToEntropy)(srcMnemonic.phrase, srcMnemonic.locale || "en"));
        path = srcMnemonic.path || hdnode_1.defaultPath;
        locale = srcMnemonic.locale || "en";
      }
      var client = options.client;
      if (!client) {
        client = "ethers.js";
      }
      var salt = null;
      if (options.salt) {
        salt = (0, bytes_1.arrayify)(options.salt);
      } else {
        salt = (0, random_1.randomBytes)(32);
        ;
      }
      var iv = null;
      if (options.iv) {
        iv = (0, bytes_1.arrayify)(options.iv);
        if (iv.length !== 16) {
          throw new Error("invalid iv");
        }
      } else {
        iv = (0, random_1.randomBytes)(16);
      }
      var uuidRandom = null;
      if (options.uuid) {
        uuidRandom = (0, bytes_1.arrayify)(options.uuid);
        if (uuidRandom.length !== 16) {
          throw new Error("invalid uuid");
        }
      } else {
        uuidRandom = (0, random_1.randomBytes)(16);
      }
      var N = 1 << 17, r = 8, p = 1;
      if (options.scrypt) {
        if (options.scrypt.N) {
          N = options.scrypt.N;
        }
        if (options.scrypt.r) {
          r = options.scrypt.r;
        }
        if (options.scrypt.p) {
          p = options.scrypt.p;
        }
      }
      return scrypt_js_1.default.scrypt(passwordBytes, salt, N, r, p, 64, progressCallback).then(function(key) {
        key = (0, bytes_1.arrayify)(key);
        var derivedKey = key.slice(0, 16);
        var macPrefix = key.slice(16, 32);
        var mnemonicKey = key.slice(32, 64);
        var counter = new aes_js_1.default.Counter(iv);
        var aesCtr = new aes_js_1.default.ModeOfOperation.ctr(derivedKey, counter);
        var ciphertext = (0, bytes_1.arrayify)(aesCtr.encrypt(privateKey));
        var mac = (0, keccak256_1.keccak256)((0, bytes_1.concat)([macPrefix, ciphertext]));
        var data = {
          address: account.address.substring(2).toLowerCase(),
          id: (0, utils_1.uuidV4)(uuidRandom),
          version: 3,
          Crypto: {
            cipher: "aes-128-ctr",
            cipherparams: {
              iv: (0, bytes_1.hexlify)(iv).substring(2)
            },
            ciphertext: (0, bytes_1.hexlify)(ciphertext).substring(2),
            kdf: "scrypt",
            kdfparams: {
              salt: (0, bytes_1.hexlify)(salt).substring(2),
              n: N,
              dklen: 32,
              p,
              r
            },
            mac: mac.substring(2)
          }
        };
        if (entropy) {
          var mnemonicIv = (0, random_1.randomBytes)(16);
          var mnemonicCounter = new aes_js_1.default.Counter(mnemonicIv);
          var mnemonicAesCtr = new aes_js_1.default.ModeOfOperation.ctr(mnemonicKey, mnemonicCounter);
          var mnemonicCiphertext = (0, bytes_1.arrayify)(mnemonicAesCtr.encrypt(entropy));
          var now = /* @__PURE__ */ new Date();
          var timestamp = now.getUTCFullYear() + "-" + (0, utils_1.zpad)(now.getUTCMonth() + 1, 2) + "-" + (0, utils_1.zpad)(now.getUTCDate(), 2) + "T" + (0, utils_1.zpad)(now.getUTCHours(), 2) + "-" + (0, utils_1.zpad)(now.getUTCMinutes(), 2) + "-" + (0, utils_1.zpad)(now.getUTCSeconds(), 2) + ".0Z";
          data["x-ethers"] = {
            client,
            gethFilename: "UTC--" + timestamp + "--" + data.address,
            mnemonicCounter: (0, bytes_1.hexlify)(mnemonicIv).substring(2),
            mnemonicCiphertext: (0, bytes_1.hexlify)(mnemonicCiphertext).substring(2),
            path,
            locale,
            version: "0.1"
          };
        }
        return JSON.stringify(data);
      });
    }
    exports2.encrypt = encrypt;
  }
});

// node_modules/@ethersproject/json-wallets/lib/index.js
var require_lib23 = __commonJS({
  "node_modules/@ethersproject/json-wallets/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.decryptJsonWalletSync = exports2.decryptJsonWallet = exports2.getJsonWalletAddress = exports2.isKeystoreWallet = exports2.isCrowdsaleWallet = exports2.encryptKeystore = exports2.decryptKeystoreSync = exports2.decryptKeystore = exports2.decryptCrowdsale = void 0;
    var crowdsale_1 = require_crowdsale();
    Object.defineProperty(exports2, "decryptCrowdsale", { enumerable: true, get: function() {
      return crowdsale_1.decrypt;
    } });
    var inspect_1 = require_inspect();
    Object.defineProperty(exports2, "getJsonWalletAddress", { enumerable: true, get: function() {
      return inspect_1.getJsonWalletAddress;
    } });
    Object.defineProperty(exports2, "isCrowdsaleWallet", { enumerable: true, get: function() {
      return inspect_1.isCrowdsaleWallet;
    } });
    Object.defineProperty(exports2, "isKeystoreWallet", { enumerable: true, get: function() {
      return inspect_1.isKeystoreWallet;
    } });
    var keystore_1 = require_keystore();
    Object.defineProperty(exports2, "decryptKeystore", { enumerable: true, get: function() {
      return keystore_1.decrypt;
    } });
    Object.defineProperty(exports2, "decryptKeystoreSync", { enumerable: true, get: function() {
      return keystore_1.decryptSync;
    } });
    Object.defineProperty(exports2, "encryptKeystore", { enumerable: true, get: function() {
      return keystore_1.encrypt;
    } });
    function decryptJsonWallet(json, password, progressCallback) {
      if ((0, inspect_1.isCrowdsaleWallet)(json)) {
        if (progressCallback) {
          progressCallback(0);
        }
        var account = (0, crowdsale_1.decrypt)(json, password);
        if (progressCallback) {
          progressCallback(1);
        }
        return Promise.resolve(account);
      }
      if ((0, inspect_1.isKeystoreWallet)(json)) {
        return (0, keystore_1.decrypt)(json, password, progressCallback);
      }
      return Promise.reject(new Error("invalid JSON wallet"));
    }
    exports2.decryptJsonWallet = decryptJsonWallet;
    function decryptJsonWalletSync(json, password) {
      if ((0, inspect_1.isCrowdsaleWallet)(json)) {
        return (0, crowdsale_1.decrypt)(json, password);
      }
      if ((0, inspect_1.isKeystoreWallet)(json)) {
        return (0, keystore_1.decryptSync)(json, password);
      }
      throw new Error("invalid JSON wallet");
    }
    exports2.decryptJsonWalletSync = decryptJsonWalletSync;
  }
});

// node_modules/@ethersproject/wallet/lib/_version.js
var require_version19 = __commonJS({
  "node_modules/@ethersproject/wallet/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "wallet/5.5.0";
  }
});

// node_modules/@ethersproject/wallet/lib/index.js
var require_lib24 = __commonJS({
  "node_modules/@ethersproject/wallet/lib/index.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator = exports2 && exports2.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1) throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return { value: op[1], done: false };
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2]) _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
        if (op[0] & 5) throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
      }
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.verifyTypedData = exports2.verifyMessage = exports2.Wallet = void 0;
    var address_1 = require_lib7();
    var abstract_provider_1 = require_lib12();
    var abstract_signer_1 = require_lib13();
    var bytes_1 = require_lib2();
    var hash_1 = require_lib10();
    var hdnode_1 = require_lib21();
    var keccak256_1 = require_lib5();
    var properties_1 = require_lib4();
    var random_1 = require_lib22();
    var signing_key_1 = require_lib14();
    var json_wallets_1 = require_lib23();
    var transactions_1 = require_lib15();
    var logger_1 = require_lib();
    var _version_1 = require_version19();
    var logger = new logger_1.Logger(_version_1.version);
    function isAccount(value) {
      return value != null && (0, bytes_1.isHexString)(value.privateKey, 32) && value.address != null;
    }
    function hasMnemonic(value) {
      var mnemonic = value.mnemonic;
      return mnemonic && mnemonic.phrase;
    }
    var Wallet = (
      /** @class */
      function(_super) {
        __extends(Wallet2, _super);
        function Wallet2(privateKey, provider) {
          var _newTarget = this.constructor;
          var _this = this;
          logger.checkNew(_newTarget, Wallet2);
          _this = _super.call(this) || this;
          if (isAccount(privateKey)) {
            var signingKey_1 = new signing_key_1.SigningKey(privateKey.privateKey);
            (0, properties_1.defineReadOnly)(_this, "_signingKey", function() {
              return signingKey_1;
            });
            (0, properties_1.defineReadOnly)(_this, "address", (0, transactions_1.computeAddress)(_this.publicKey));
            if (_this.address !== (0, address_1.getAddress)(privateKey.address)) {
              logger.throwArgumentError("privateKey/address mismatch", "privateKey", "[REDACTED]");
            }
            if (hasMnemonic(privateKey)) {
              var srcMnemonic_1 = privateKey.mnemonic;
              (0, properties_1.defineReadOnly)(_this, "_mnemonic", function() {
                return {
                  phrase: srcMnemonic_1.phrase,
                  path: srcMnemonic_1.path || hdnode_1.defaultPath,
                  locale: srcMnemonic_1.locale || "en"
                };
              });
              var mnemonic = _this.mnemonic;
              var node = hdnode_1.HDNode.fromMnemonic(mnemonic.phrase, null, mnemonic.locale).derivePath(mnemonic.path);
              if ((0, transactions_1.computeAddress)(node.privateKey) !== _this.address) {
                logger.throwArgumentError("mnemonic/address mismatch", "privateKey", "[REDACTED]");
              }
            } else {
              (0, properties_1.defineReadOnly)(_this, "_mnemonic", function() {
                return null;
              });
            }
          } else {
            if (signing_key_1.SigningKey.isSigningKey(privateKey)) {
              if (privateKey.curve !== "secp256k1") {
                logger.throwArgumentError("unsupported curve; must be secp256k1", "privateKey", "[REDACTED]");
              }
              (0, properties_1.defineReadOnly)(_this, "_signingKey", function() {
                return privateKey;
              });
            } else {
              if (typeof privateKey === "string") {
                if (privateKey.match(/^[0-9a-f]*$/i) && privateKey.length === 64) {
                  privateKey = "0x" + privateKey;
                }
              }
              var signingKey_2 = new signing_key_1.SigningKey(privateKey);
              (0, properties_1.defineReadOnly)(_this, "_signingKey", function() {
                return signingKey_2;
              });
            }
            (0, properties_1.defineReadOnly)(_this, "_mnemonic", function() {
              return null;
            });
            (0, properties_1.defineReadOnly)(_this, "address", (0, transactions_1.computeAddress)(_this.publicKey));
          }
          if (provider && !abstract_provider_1.Provider.isProvider(provider)) {
            logger.throwArgumentError("invalid provider", "provider", provider);
          }
          (0, properties_1.defineReadOnly)(_this, "provider", provider || null);
          return _this;
        }
        Object.defineProperty(Wallet2.prototype, "mnemonic", {
          get: function() {
            return this._mnemonic();
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(Wallet2.prototype, "privateKey", {
          get: function() {
            return this._signingKey().privateKey;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(Wallet2.prototype, "publicKey", {
          get: function() {
            return this._signingKey().publicKey;
          },
          enumerable: false,
          configurable: true
        });
        Wallet2.prototype.getAddress = function() {
          return Promise.resolve(this.address);
        };
        Wallet2.prototype.connect = function(provider) {
          return new Wallet2(this, provider);
        };
        Wallet2.prototype.signTransaction = function(transaction) {
          var _this = this;
          return (0, properties_1.resolveProperties)(transaction).then(function(tx) {
            if (tx.from != null) {
              if ((0, address_1.getAddress)(tx.from) !== _this.address) {
                logger.throwArgumentError("transaction from address mismatch", "transaction.from", transaction.from);
              }
              delete tx.from;
            }
            var signature = _this._signingKey().signDigest((0, keccak256_1.keccak256)((0, transactions_1.serialize)(tx)));
            return (0, transactions_1.serialize)(tx, signature);
          });
        };
        Wallet2.prototype.signMessage = function(message) {
          return __awaiter(this, void 0, void 0, function() {
            return __generator(this, function(_a) {
              return [2, (0, bytes_1.joinSignature)(this._signingKey().signDigest((0, hash_1.hashMessage)(message)))];
            });
          });
        };
        Wallet2.prototype._signTypedData = function(domain, types, value) {
          return __awaiter(this, void 0, void 0, function() {
            var populated;
            var _this = this;
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  return [4, hash_1._TypedDataEncoder.resolveNames(domain, types, value, function(name2) {
                    if (_this.provider == null) {
                      logger.throwError("cannot resolve ENS names without a provider", logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
                        operation: "resolveName",
                        value: name2
                      });
                    }
                    return _this.provider.resolveName(name2);
                  })];
                case 1:
                  populated = _a.sent();
                  return [2, (0, bytes_1.joinSignature)(this._signingKey().signDigest(hash_1._TypedDataEncoder.hash(populated.domain, types, populated.value)))];
              }
            });
          });
        };
        Wallet2.prototype.encrypt = function(password, options, progressCallback) {
          if (typeof options === "function" && !progressCallback) {
            progressCallback = options;
            options = {};
          }
          if (progressCallback && typeof progressCallback !== "function") {
            throw new Error("invalid callback");
          }
          if (!options) {
            options = {};
          }
          return (0, json_wallets_1.encryptKeystore)(this, password, options, progressCallback);
        };
        Wallet2.createRandom = function(options) {
          var entropy = (0, random_1.randomBytes)(16);
          if (!options) {
            options = {};
          }
          if (options.extraEntropy) {
            entropy = (0, bytes_1.arrayify)((0, bytes_1.hexDataSlice)((0, keccak256_1.keccak256)((0, bytes_1.concat)([entropy, options.extraEntropy])), 0, 16));
          }
          var mnemonic = (0, hdnode_1.entropyToMnemonic)(entropy, options.locale);
          return Wallet2.fromMnemonic(mnemonic, options.path, options.locale);
        };
        Wallet2.fromEncryptedJson = function(json, password, progressCallback) {
          return (0, json_wallets_1.decryptJsonWallet)(json, password, progressCallback).then(function(account) {
            return new Wallet2(account);
          });
        };
        Wallet2.fromEncryptedJsonSync = function(json, password) {
          return new Wallet2((0, json_wallets_1.decryptJsonWalletSync)(json, password));
        };
        Wallet2.fromMnemonic = function(mnemonic, path, wordlist) {
          if (!path) {
            path = hdnode_1.defaultPath;
          }
          return new Wallet2(hdnode_1.HDNode.fromMnemonic(mnemonic, null, wordlist).derivePath(path));
        };
        return Wallet2;
      }(abstract_signer_1.Signer)
    );
    exports2.Wallet = Wallet;
    function verifyMessage(message, signature) {
      return (0, transactions_1.recoverAddress)((0, hash_1.hashMessage)(message), signature);
    }
    exports2.verifyMessage = verifyMessage;
    function verifyTypedData(domain, types, value, signature) {
      return (0, transactions_1.recoverAddress)(hash_1._TypedDataEncoder.hash(domain, types, value), signature);
    }
    exports2.verifyTypedData = verifyTypedData;
  }
});

// node_modules/@ethersproject/networks/lib/_version.js
var require_version20 = __commonJS({
  "node_modules/@ethersproject/networks/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "networks/5.5.1";
  }
});

// node_modules/@ethersproject/networks/lib/index.js
var require_lib25 = __commonJS({
  "node_modules/@ethersproject/networks/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getNetwork = void 0;
    var logger_1 = require_lib();
    var _version_1 = require_version20();
    var logger = new logger_1.Logger(_version_1.version);
    function isRenetworkable(value) {
      return value && typeof value.renetwork === "function";
    }
    function ethDefaultProvider(network) {
      var func = function(providers, options) {
        if (options == null) {
          options = {};
        }
        var providerList = [];
        if (providers.InfuraProvider) {
          try {
            providerList.push(new providers.InfuraProvider(network, options.infura));
          } catch (error) {
          }
        }
        if (providers.EtherscanProvider) {
          try {
            providerList.push(new providers.EtherscanProvider(network, options.etherscan));
          } catch (error) {
          }
        }
        if (providers.AlchemyProvider) {
          try {
            providerList.push(new providers.AlchemyProvider(network, options.alchemy));
          } catch (error) {
          }
        }
        if (providers.PocketProvider) {
          var skip = ["goerli", "ropsten", "rinkeby"];
          try {
            var provider = new providers.PocketProvider(network);
            if (provider.network && skip.indexOf(provider.network.name) === -1) {
              providerList.push(provider);
            }
          } catch (error) {
          }
        }
        if (providers.CloudflareProvider) {
          try {
            providerList.push(new providers.CloudflareProvider(network));
          } catch (error) {
          }
        }
        if (providerList.length === 0) {
          return null;
        }
        if (providers.FallbackProvider) {
          var quorum = 1;
          if (options.quorum != null) {
            quorum = options.quorum;
          } else if (network === "homestead") {
            quorum = 2;
          }
          return new providers.FallbackProvider(providerList, quorum);
        }
        return providerList[0];
      };
      func.renetwork = function(network2) {
        return ethDefaultProvider(network2);
      };
      return func;
    }
    function etcDefaultProvider(url, network) {
      var func = function(providers, options) {
        if (providers.JsonRpcProvider) {
          return new providers.JsonRpcProvider(url, network);
        }
        return null;
      };
      func.renetwork = function(network2) {
        return etcDefaultProvider(url, network2);
      };
      return func;
    }
    var homestead = {
      chainId: 1,
      ensAddress: "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e",
      name: "homestead",
      _defaultProvider: ethDefaultProvider("homestead")
    };
    var ropsten = {
      chainId: 3,
      ensAddress: "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e",
      name: "ropsten",
      _defaultProvider: ethDefaultProvider("ropsten")
    };
    var classicMordor = {
      chainId: 63,
      name: "classicMordor",
      _defaultProvider: etcDefaultProvider("https://www.ethercluster.com/mordor", "classicMordor")
    };
    var networks = {
      unspecified: { chainId: 0, name: "unspecified" },
      homestead,
      mainnet: homestead,
      morden: { chainId: 2, name: "morden" },
      ropsten,
      testnet: ropsten,
      rinkeby: {
        chainId: 4,
        ensAddress: "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e",
        name: "rinkeby",
        _defaultProvider: ethDefaultProvider("rinkeby")
      },
      kovan: {
        chainId: 42,
        name: "kovan",
        _defaultProvider: ethDefaultProvider("kovan")
      },
      goerli: {
        chainId: 5,
        ensAddress: "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e",
        name: "goerli",
        _defaultProvider: ethDefaultProvider("goerli")
      },
      // ETC (See: #351)
      classic: {
        chainId: 61,
        name: "classic",
        _defaultProvider: etcDefaultProvider("https://www.ethercluster.com/etc", "classic")
      },
      classicMorden: { chainId: 62, name: "classicMorden" },
      classicMordor,
      classicTestnet: classicMordor,
      classicKotti: {
        chainId: 6,
        name: "classicKotti",
        _defaultProvider: etcDefaultProvider("https://www.ethercluster.com/kotti", "classicKotti")
      },
      xdai: { chainId: 100, name: "xdai" },
      matic: { chainId: 137, name: "matic" },
      maticmum: { chainId: 80001, name: "maticmum" },
      optimism: { chainId: 10, name: "optimism" },
      "optimism-kovan": { chainId: 69, name: "optimism-kovan" },
      "optimism-goerli": { chainId: 420, name: "optimism-goerli" },
      arbitrum: { chainId: 42161, name: "arbitrum" },
      "arbitrum-rinkeby": { chainId: 421611, name: "arbitrum-rinkeby" },
      bnb: { chainId: 56, name: "bnb" },
      bnbt: { chainId: 97, name: "bnbt" }
    };
    function getNetwork(network) {
      if (network == null) {
        return null;
      }
      if (typeof network === "number") {
        for (var name_1 in networks) {
          var standard_1 = networks[name_1];
          if (standard_1.chainId === network) {
            return {
              name: standard_1.name,
              chainId: standard_1.chainId,
              ensAddress: standard_1.ensAddress || null,
              _defaultProvider: standard_1._defaultProvider || null
            };
          }
        }
        return {
          chainId: network,
          name: "unknown"
        };
      }
      if (typeof network === "string") {
        var standard_2 = networks[network];
        if (standard_2 == null) {
          return null;
        }
        return {
          name: standard_2.name,
          chainId: standard_2.chainId,
          ensAddress: standard_2.ensAddress,
          _defaultProvider: standard_2._defaultProvider || null
        };
      }
      var standard = networks[network.name];
      if (!standard) {
        if (typeof network.chainId !== "number") {
          logger.throwArgumentError("invalid network chainId", "network", network);
        }
        return network;
      }
      if (network.chainId !== 0 && network.chainId !== standard.chainId) {
        logger.throwArgumentError("network chainId mismatch", "network", network);
      }
      var defaultProvider = network._defaultProvider || null;
      if (defaultProvider == null && standard._defaultProvider) {
        if (isRenetworkable(standard._defaultProvider)) {
          defaultProvider = standard._defaultProvider.renetwork(network);
        } else {
          defaultProvider = standard._defaultProvider;
        }
      }
      return {
        name: network.name,
        chainId: standard.chainId,
        ensAddress: network.ensAddress || standard.ensAddress || null,
        _defaultProvider: defaultProvider
      };
    }
    exports2.getNetwork = getNetwork;
  }
});

// node_modules/@ethersproject/base64/lib/base64.js
var require_base64 = __commonJS({
  "node_modules/@ethersproject/base64/lib/base64.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.encode = exports2.decode = void 0;
    var bytes_1 = require_lib2();
    function decode(textData) {
      return (0, bytes_1.arrayify)(new Uint8Array(Buffer.from(textData, "base64")));
    }
    exports2.decode = decode;
    function encode(data) {
      return Buffer.from((0, bytes_1.arrayify)(data)).toString("base64");
    }
    exports2.encode = encode;
  }
});

// node_modules/@ethersproject/base64/lib/index.js
var require_lib26 = __commonJS({
  "node_modules/@ethersproject/base64/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.encode = exports2.decode = void 0;
    var base64_1 = require_base64();
    Object.defineProperty(exports2, "decode", { enumerable: true, get: function() {
      return base64_1.decode;
    } });
    Object.defineProperty(exports2, "encode", { enumerable: true, get: function() {
      return base64_1.encode;
    } });
  }
});

// node_modules/@ethersproject/web/lib/_version.js
var require_version21 = __commonJS({
  "node_modules/@ethersproject/web/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "web/5.5.1";
  }
});

// node_modules/@ethersproject/web/lib/geturl.js
var require_geturl = __commonJS({
  "node_modules/@ethersproject/web/lib/geturl.js"(exports2) {
    "use strict";
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator = exports2 && exports2.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1) throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return { value: op[1], done: false };
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2]) _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
        if (op[0] & 5) throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
      }
    };
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getUrl = void 0;
    var http_1 = __importDefault(require("http"));
    var https_1 = __importDefault(require("https"));
    var zlib_1 = require("zlib");
    var url_1 = require("url");
    var bytes_1 = require_lib2();
    var properties_1 = require_lib4();
    var logger_1 = require_lib();
    var _version_1 = require_version21();
    var logger = new logger_1.Logger(_version_1.version);
    function getResponse(request) {
      return new Promise(function(resolve, reject) {
        request.once("response", function(resp) {
          var response = {
            statusCode: resp.statusCode,
            statusMessage: resp.statusMessage,
            headers: Object.keys(resp.headers).reduce(function(accum, name2) {
              var value = resp.headers[name2];
              if (Array.isArray(value)) {
                value = value.join(", ");
              }
              accum[name2] = value;
              return accum;
            }, {}),
            body: null
          };
          resp.on("data", function(chunk) {
            if (response.body == null) {
              response.body = new Uint8Array(0);
            }
            response.body = (0, bytes_1.concat)([response.body, chunk]);
          });
          resp.on("end", function() {
            if (response.headers["content-encoding"] === "gzip") {
              response.body = (0, bytes_1.arrayify)((0, zlib_1.gunzipSync)(response.body));
            }
            resolve(response);
          });
          resp.on("error", function(error) {
            error.response = response;
            reject(error);
          });
        });
        request.on("error", function(error) {
          reject(error);
        });
      });
    }
    function nonnull(value) {
      if (value == null) {
        return "";
      }
      return value;
    }
    function getUrl(href, options) {
      return __awaiter(this, void 0, void 0, function() {
        var url, request, req, response;
        return __generator(this, function(_a) {
          switch (_a.label) {
            case 0:
              if (options == null) {
                options = {};
              }
              url = (0, url_1.parse)(href);
              request = {
                protocol: nonnull(url.protocol),
                hostname: nonnull(url.hostname),
                port: nonnull(url.port),
                path: nonnull(url.pathname) + nonnull(url.search),
                method: options.method || "GET",
                headers: (0, properties_1.shallowCopy)(options.headers || {})
              };
              if (options.allowGzip) {
                request.headers["accept-encoding"] = "gzip";
              }
              req = null;
              switch (nonnull(url.protocol)) {
                case "http:":
                  req = http_1.default.request(request);
                  break;
                case "https:":
                  req = https_1.default.request(request);
                  break;
                default:
                  logger.throwError("unsupported protocol " + url.protocol, logger_1.Logger.errors.UNSUPPORTED_OPERATION, {
                    protocol: url.protocol,
                    operation: "request"
                  });
              }
              if (options.body) {
                req.write(Buffer.from(options.body));
              }
              req.end();
              return [4, getResponse(req)];
            case 1:
              response = _a.sent();
              return [2, response];
          }
        });
      });
    }
    exports2.getUrl = getUrl;
  }
});

// node_modules/@ethersproject/web/lib/index.js
var require_lib27 = __commonJS({
  "node_modules/@ethersproject/web/lib/index.js"(exports2) {
    "use strict";
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator = exports2 && exports2.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1) throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return { value: op[1], done: false };
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2]) _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
        if (op[0] & 5) throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
      }
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.poll = exports2.fetchJson = exports2._fetchData = void 0;
    var base64_1 = require_lib26();
    var bytes_1 = require_lib2();
    var properties_1 = require_lib4();
    var strings_1 = require_lib9();
    var logger_1 = require_lib();
    var _version_1 = require_version21();
    var logger = new logger_1.Logger(_version_1.version);
    var geturl_1 = require_geturl();
    function staller(duration) {
      return new Promise(function(resolve) {
        setTimeout(resolve, duration);
      });
    }
    function bodyify(value, type) {
      if (value == null) {
        return null;
      }
      if (typeof value === "string") {
        return value;
      }
      if ((0, bytes_1.isBytesLike)(value)) {
        if (type && (type.split("/")[0] === "text" || type.split(";")[0].trim() === "application/json")) {
          try {
            return (0, strings_1.toUtf8String)(value);
          } catch (error) {
          }
          ;
        }
        return (0, bytes_1.hexlify)(value);
      }
      return value;
    }
    function _fetchData(connection, body, processFunc) {
      var attemptLimit = typeof connection === "object" && connection.throttleLimit != null ? connection.throttleLimit : 12;
      logger.assertArgument(attemptLimit > 0 && attemptLimit % 1 === 0, "invalid connection throttle limit", "connection.throttleLimit", attemptLimit);
      var throttleCallback = typeof connection === "object" ? connection.throttleCallback : null;
      var throttleSlotInterval = typeof connection === "object" && typeof connection.throttleSlotInterval === "number" ? connection.throttleSlotInterval : 100;
      logger.assertArgument(throttleSlotInterval > 0 && throttleSlotInterval % 1 === 0, "invalid connection throttle slot interval", "connection.throttleSlotInterval", throttleSlotInterval);
      var headers = {};
      var url = null;
      var options = {
        method: "GET"
      };
      var allow304 = false;
      var timeout = 2 * 60 * 1e3;
      if (typeof connection === "string") {
        url = connection;
      } else if (typeof connection === "object") {
        if (connection == null || connection.url == null) {
          logger.throwArgumentError("missing URL", "connection.url", connection);
        }
        url = connection.url;
        if (typeof connection.timeout === "number" && connection.timeout > 0) {
          timeout = connection.timeout;
        }
        if (connection.headers) {
          for (var key in connection.headers) {
            headers[key.toLowerCase()] = { key, value: String(connection.headers[key]) };
            if (["if-none-match", "if-modified-since"].indexOf(key.toLowerCase()) >= 0) {
              allow304 = true;
            }
          }
        }
        options.allowGzip = !!connection.allowGzip;
        if (connection.user != null && connection.password != null) {
          if (url.substring(0, 6) !== "https:" && connection.allowInsecureAuthentication !== true) {
            logger.throwError("basic authentication requires a secure https url", logger_1.Logger.errors.INVALID_ARGUMENT, { argument: "url", url, user: connection.user, password: "[REDACTED]" });
          }
          var authorization = connection.user + ":" + connection.password;
          headers["authorization"] = {
            key: "Authorization",
            value: "Basic " + (0, base64_1.encode)((0, strings_1.toUtf8Bytes)(authorization))
          };
        }
      }
      var reData = new RegExp("^data:([a-z0-9-]+/[a-z0-9-]+);base64,(.*)$", "i");
      var dataMatch = url ? url.match(reData) : null;
      if (dataMatch) {
        try {
          var response = {
            statusCode: 200,
            statusMessage: "OK",
            headers: { "content-type": dataMatch[1] },
            body: (0, base64_1.decode)(dataMatch[2])
          };
          var result = response.body;
          if (processFunc) {
            result = processFunc(response.body, response);
          }
          return Promise.resolve(result);
        } catch (error) {
          logger.throwError("processing response error", logger_1.Logger.errors.SERVER_ERROR, {
            body: bodyify(dataMatch[1], dataMatch[2]),
            error,
            requestBody: null,
            requestMethod: "GET",
            url
          });
        }
      }
      if (body) {
        options.method = "POST";
        options.body = body;
        if (headers["content-type"] == null) {
          headers["content-type"] = { key: "Content-Type", value: "application/octet-stream" };
        }
        if (headers["content-length"] == null) {
          headers["content-length"] = { key: "Content-Length", value: String(body.length) };
        }
      }
      var flatHeaders = {};
      Object.keys(headers).forEach(function(key2) {
        var header = headers[key2];
        flatHeaders[header.key] = header.value;
      });
      options.headers = flatHeaders;
      var runningTimeout = function() {
        var timer = null;
        var promise = new Promise(function(resolve, reject) {
          if (timeout) {
            timer = setTimeout(function() {
              if (timer == null) {
                return;
              }
              timer = null;
              reject(logger.makeError("timeout", logger_1.Logger.errors.TIMEOUT, {
                requestBody: bodyify(options.body, flatHeaders["content-type"]),
                requestMethod: options.method,
                timeout,
                url
              }));
            }, timeout);
          }
        });
        var cancel = function() {
          if (timer == null) {
            return;
          }
          clearTimeout(timer);
          timer = null;
        };
        return { promise, cancel };
      }();
      var runningFetch = function() {
        return __awaiter(this, void 0, void 0, function() {
          var attempt, response2, location_1, tryAgain, stall, retryAfter, error_1, body_1, result2, error_2, tryAgain, timeout_1;
          return __generator(this, function(_a) {
            switch (_a.label) {
              case 0:
                attempt = 0;
                _a.label = 1;
              case 1:
                if (!(attempt < attemptLimit)) return [3, 20];
                response2 = null;
                _a.label = 2;
              case 2:
                _a.trys.push([2, 9, , 10]);
                return [4, (0, geturl_1.getUrl)(url, options)];
              case 3:
                response2 = _a.sent();
                if (!(attempt < attemptLimit)) return [3, 8];
                if (!(response2.statusCode === 301 || response2.statusCode === 302)) return [3, 4];
                location_1 = response2.headers.location || "";
                if (options.method === "GET" && location_1.match(/^https:/)) {
                  url = response2.headers.location;
                  return [3, 19];
                }
                return [3, 8];
              case 4:
                if (!(response2.statusCode === 429)) return [3, 8];
                tryAgain = true;
                if (!throttleCallback) return [3, 6];
                return [4, throttleCallback(attempt, url)];
              case 5:
                tryAgain = _a.sent();
                _a.label = 6;
              case 6:
                if (!tryAgain) return [3, 8];
                stall = 0;
                retryAfter = response2.headers["retry-after"];
                if (typeof retryAfter === "string" && retryAfter.match(/^[1-9][0-9]*$/)) {
                  stall = parseInt(retryAfter) * 1e3;
                } else {
                  stall = throttleSlotInterval * parseInt(String(Math.random() * Math.pow(2, attempt)));
                }
                return [4, staller(stall)];
              case 7:
                _a.sent();
                return [3, 19];
              case 8:
                return [3, 10];
              case 9:
                error_1 = _a.sent();
                response2 = error_1.response;
                if (response2 == null) {
                  runningTimeout.cancel();
                  logger.throwError("missing response", logger_1.Logger.errors.SERVER_ERROR, {
                    requestBody: bodyify(options.body, flatHeaders["content-type"]),
                    requestMethod: options.method,
                    serverError: error_1,
                    url
                  });
                }
                return [3, 10];
              case 10:
                body_1 = response2.body;
                if (allow304 && response2.statusCode === 304) {
                  body_1 = null;
                } else if (response2.statusCode < 200 || response2.statusCode >= 300) {
                  runningTimeout.cancel();
                  logger.throwError("bad response", logger_1.Logger.errors.SERVER_ERROR, {
                    status: response2.statusCode,
                    headers: response2.headers,
                    body: bodyify(body_1, response2.headers ? response2.headers["content-type"] : null),
                    requestBody: bodyify(options.body, flatHeaders["content-type"]),
                    requestMethod: options.method,
                    url
                  });
                }
                if (!processFunc) return [3, 18];
                _a.label = 11;
              case 11:
                _a.trys.push([11, 13, , 18]);
                return [4, processFunc(body_1, response2)];
              case 12:
                result2 = _a.sent();
                runningTimeout.cancel();
                return [2, result2];
              case 13:
                error_2 = _a.sent();
                if (!(error_2.throttleRetry && attempt < attemptLimit)) return [3, 17];
                tryAgain = true;
                if (!throttleCallback) return [3, 15];
                return [4, throttleCallback(attempt, url)];
              case 14:
                tryAgain = _a.sent();
                _a.label = 15;
              case 15:
                if (!tryAgain) return [3, 17];
                timeout_1 = throttleSlotInterval * parseInt(String(Math.random() * Math.pow(2, attempt)));
                return [4, staller(timeout_1)];
              case 16:
                _a.sent();
                return [3, 19];
              case 17:
                runningTimeout.cancel();
                logger.throwError("processing response error", logger_1.Logger.errors.SERVER_ERROR, {
                  body: bodyify(body_1, response2.headers ? response2.headers["content-type"] : null),
                  error: error_2,
                  requestBody: bodyify(options.body, flatHeaders["content-type"]),
                  requestMethod: options.method,
                  url
                });
                return [3, 18];
              case 18:
                runningTimeout.cancel();
                return [2, body_1];
              case 19:
                attempt++;
                return [3, 1];
              case 20:
                return [2, logger.throwError("failed response", logger_1.Logger.errors.SERVER_ERROR, {
                  requestBody: bodyify(options.body, flatHeaders["content-type"]),
                  requestMethod: options.method,
                  url
                })];
            }
          });
        });
      }();
      return Promise.race([runningTimeout.promise, runningFetch]);
    }
    exports2._fetchData = _fetchData;
    function fetchJson(connection, json, processFunc) {
      var processJsonFunc = function(value, response) {
        var result = null;
        if (value != null) {
          try {
            result = JSON.parse((0, strings_1.toUtf8String)(value));
          } catch (error) {
            logger.throwError("invalid JSON", logger_1.Logger.errors.SERVER_ERROR, {
              body: value,
              error
            });
          }
        }
        if (processFunc) {
          result = processFunc(result, response);
        }
        return result;
      };
      var body = null;
      if (json != null) {
        body = (0, strings_1.toUtf8Bytes)(json);
        var updated = typeof connection === "string" ? { url: connection } : (0, properties_1.shallowCopy)(connection);
        if (updated.headers) {
          var hasContentType = Object.keys(updated.headers).filter(function(k) {
            return k.toLowerCase() === "content-type";
          }).length !== 0;
          if (!hasContentType) {
            updated.headers = (0, properties_1.shallowCopy)(updated.headers);
            updated.headers["content-type"] = "application/json";
          }
        } else {
          updated.headers = { "content-type": "application/json" };
        }
        connection = updated;
      }
      return _fetchData(connection, body, processJsonFunc);
    }
    exports2.fetchJson = fetchJson;
    function poll(func, options) {
      if (!options) {
        options = {};
      }
      options = (0, properties_1.shallowCopy)(options);
      if (options.floor == null) {
        options.floor = 0;
      }
      if (options.ceiling == null) {
        options.ceiling = 1e4;
      }
      if (options.interval == null) {
        options.interval = 250;
      }
      return new Promise(function(resolve, reject) {
        var timer = null;
        var done = false;
        var cancel = function() {
          if (done) {
            return false;
          }
          done = true;
          if (timer) {
            clearTimeout(timer);
          }
          return true;
        };
        if (options.timeout) {
          timer = setTimeout(function() {
            if (cancel()) {
              reject(new Error("timeout"));
            }
          }, options.timeout);
        }
        var retryLimit = options.retryLimit;
        var attempt = 0;
        function check() {
          return func().then(function(result) {
            if (result !== void 0) {
              if (cancel()) {
                resolve(result);
              }
            } else if (options.oncePoll) {
              options.oncePoll.once("poll", check);
            } else if (options.onceBlock) {
              options.onceBlock.once("block", check);
            } else if (!done) {
              attempt++;
              if (attempt > retryLimit) {
                if (cancel()) {
                  reject(new Error("retry limit reached"));
                }
                return;
              }
              var timeout = options.interval * parseInt(String(Math.random() * Math.pow(2, attempt)));
              if (timeout < options.floor) {
                timeout = options.floor;
              }
              if (timeout > options.ceiling) {
                timeout = options.ceiling;
              }
              setTimeout(check, timeout);
            }
            return null;
          }, function(error) {
            if (cancel()) {
              reject(error);
            }
          });
        }
        check();
      });
    }
    exports2.poll = poll;
  }
});

// node_modules/bech32/index.js
var require_bech32 = __commonJS({
  "node_modules/bech32/index.js"(exports2, module2) {
    "use strict";
    var ALPHABET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    var ALPHABET_MAP = {};
    for (z = 0; z < ALPHABET.length; z++) {
      x = ALPHABET.charAt(z);
      if (ALPHABET_MAP[x] !== void 0) throw new TypeError(x + " is ambiguous");
      ALPHABET_MAP[x] = z;
    }
    var x;
    var z;
    function polymodStep(pre) {
      var b = pre >> 25;
      return (pre & 33554431) << 5 ^ -(b >> 0 & 1) & 996825010 ^ -(b >> 1 & 1) & 642813549 ^ -(b >> 2 & 1) & 513874426 ^ -(b >> 3 & 1) & 1027748829 ^ -(b >> 4 & 1) & 705979059;
    }
    function prefixChk(prefix) {
      var chk = 1;
      for (var i = 0; i < prefix.length; ++i) {
        var c = prefix.charCodeAt(i);
        if (c < 33 || c > 126) return "Invalid prefix (" + prefix + ")";
        chk = polymodStep(chk) ^ c >> 5;
      }
      chk = polymodStep(chk);
      for (i = 0; i < prefix.length; ++i) {
        var v = prefix.charCodeAt(i);
        chk = polymodStep(chk) ^ v & 31;
      }
      return chk;
    }
    function encode(prefix, words, LIMIT) {
      LIMIT = LIMIT || 90;
      if (prefix.length + 7 + words.length > LIMIT) throw new TypeError("Exceeds length limit");
      prefix = prefix.toLowerCase();
      var chk = prefixChk(prefix);
      if (typeof chk === "string") throw new Error(chk);
      var result = prefix + "1";
      for (var i = 0; i < words.length; ++i) {
        var x2 = words[i];
        if (x2 >> 5 !== 0) throw new Error("Non 5-bit word");
        chk = polymodStep(chk) ^ x2;
        result += ALPHABET.charAt(x2);
      }
      for (i = 0; i < 6; ++i) {
        chk = polymodStep(chk);
      }
      chk ^= 1;
      for (i = 0; i < 6; ++i) {
        var v = chk >> (5 - i) * 5 & 31;
        result += ALPHABET.charAt(v);
      }
      return result;
    }
    function __decode(str, LIMIT) {
      LIMIT = LIMIT || 90;
      if (str.length < 8) return str + " too short";
      if (str.length > LIMIT) return "Exceeds length limit";
      var lowered = str.toLowerCase();
      var uppered = str.toUpperCase();
      if (str !== lowered && str !== uppered) return "Mixed-case string " + str;
      str = lowered;
      var split = str.lastIndexOf("1");
      if (split === -1) return "No separator character for " + str;
      if (split === 0) return "Missing prefix for " + str;
      var prefix = str.slice(0, split);
      var wordChars = str.slice(split + 1);
      if (wordChars.length < 6) return "Data too short";
      var chk = prefixChk(prefix);
      if (typeof chk === "string") return chk;
      var words = [];
      for (var i = 0; i < wordChars.length; ++i) {
        var c = wordChars.charAt(i);
        var v = ALPHABET_MAP[c];
        if (v === void 0) return "Unknown character " + c;
        chk = polymodStep(chk) ^ v;
        if (i + 6 >= wordChars.length) continue;
        words.push(v);
      }
      if (chk !== 1) return "Invalid checksum for " + str;
      return { prefix, words };
    }
    function decodeUnsafe() {
      var res = __decode.apply(null, arguments);
      if (typeof res === "object") return res;
    }
    function decode(str) {
      var res = __decode.apply(null, arguments);
      if (typeof res === "object") return res;
      throw new Error(res);
    }
    function convert(data, inBits, outBits, pad) {
      var value = 0;
      var bits = 0;
      var maxV = (1 << outBits) - 1;
      var result = [];
      for (var i = 0; i < data.length; ++i) {
        value = value << inBits | data[i];
        bits += inBits;
        while (bits >= outBits) {
          bits -= outBits;
          result.push(value >> bits & maxV);
        }
      }
      if (pad) {
        if (bits > 0) {
          result.push(value << outBits - bits & maxV);
        }
      } else {
        if (bits >= inBits) return "Excess padding";
        if (value << outBits - bits & maxV) return "Non-zero padding";
      }
      return result;
    }
    function toWordsUnsafe(bytes) {
      var res = convert(bytes, 8, 5, true);
      if (Array.isArray(res)) return res;
    }
    function toWords(bytes) {
      var res = convert(bytes, 8, 5, true);
      if (Array.isArray(res)) return res;
      throw new Error(res);
    }
    function fromWordsUnsafe(words) {
      var res = convert(words, 5, 8, false);
      if (Array.isArray(res)) return res;
    }
    function fromWords(words) {
      var res = convert(words, 5, 8, false);
      if (Array.isArray(res)) return res;
      throw new Error(res);
    }
    module2.exports = {
      decodeUnsafe,
      decode,
      encode,
      toWordsUnsafe,
      toWords,
      fromWordsUnsafe,
      fromWords
    };
  }
});

// node_modules/@ethersproject/providers/lib/_version.js
var require_version22 = __commonJS({
  "node_modules/@ethersproject/providers/lib/_version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "providers/5.5.1";
  }
});

// node_modules/@ethersproject/providers/lib/formatter.js
var require_formatter = __commonJS({
  "node_modules/@ethersproject/providers/lib/formatter.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.showThrottleMessage = exports2.isCommunityResource = exports2.isCommunityResourcable = exports2.Formatter = void 0;
    var address_1 = require_lib7();
    var bignumber_1 = require_lib3();
    var bytes_1 = require_lib2();
    var constants_1 = require_lib8();
    var properties_1 = require_lib4();
    var transactions_1 = require_lib15();
    var logger_1 = require_lib();
    var _version_1 = require_version22();
    var logger = new logger_1.Logger(_version_1.version);
    var Formatter = (
      /** @class */
      function() {
        function Formatter2() {
          var _newTarget = this.constructor;
          logger.checkNew(_newTarget, Formatter2);
          this.formats = this.getDefaultFormats();
        }
        Formatter2.prototype.getDefaultFormats = function() {
          var _this = this;
          var formats = {};
          var address = this.address.bind(this);
          var bigNumber = this.bigNumber.bind(this);
          var blockTag = this.blockTag.bind(this);
          var data = this.data.bind(this);
          var hash = this.hash.bind(this);
          var hex = this.hex.bind(this);
          var number = this.number.bind(this);
          var type = this.type.bind(this);
          var strictData = function(v) {
            return _this.data(v, true);
          };
          formats.transaction = {
            hash,
            type,
            accessList: Formatter2.allowNull(this.accessList.bind(this), null),
            blockHash: Formatter2.allowNull(hash, null),
            blockNumber: Formatter2.allowNull(number, null),
            transactionIndex: Formatter2.allowNull(number, null),
            confirmations: Formatter2.allowNull(number, null),
            from: address,
            // either (gasPrice) or (maxPriorityFeePerGas + maxFeePerGas)
            // must be set
            gasPrice: Formatter2.allowNull(bigNumber),
            maxPriorityFeePerGas: Formatter2.allowNull(bigNumber),
            maxFeePerGas: Formatter2.allowNull(bigNumber),
            gasLimit: bigNumber,
            to: Formatter2.allowNull(address, null),
            value: bigNumber,
            nonce: number,
            data,
            r: Formatter2.allowNull(this.uint256),
            s: Formatter2.allowNull(this.uint256),
            v: Formatter2.allowNull(number),
            creates: Formatter2.allowNull(address, null),
            raw: Formatter2.allowNull(data)
          };
          formats.transactionRequest = {
            from: Formatter2.allowNull(address),
            nonce: Formatter2.allowNull(number),
            gasLimit: Formatter2.allowNull(bigNumber),
            gasPrice: Formatter2.allowNull(bigNumber),
            maxPriorityFeePerGas: Formatter2.allowNull(bigNumber),
            maxFeePerGas: Formatter2.allowNull(bigNumber),
            to: Formatter2.allowNull(address),
            value: Formatter2.allowNull(bigNumber),
            data: Formatter2.allowNull(strictData),
            type: Formatter2.allowNull(number),
            accessList: Formatter2.allowNull(this.accessList.bind(this), null)
          };
          formats.receiptLog = {
            transactionIndex: number,
            blockNumber: number,
            transactionHash: hash,
            address,
            topics: Formatter2.arrayOf(hash),
            data,
            logIndex: number,
            blockHash: hash
          };
          formats.receipt = {
            to: Formatter2.allowNull(this.address, null),
            from: Formatter2.allowNull(this.address, null),
            contractAddress: Formatter2.allowNull(address, null),
            transactionIndex: number,
            // should be allowNull(hash), but broken-EIP-658 support is handled in receipt
            root: Formatter2.allowNull(hex),
            gasUsed: bigNumber,
            logsBloom: Formatter2.allowNull(data),
            blockHash: hash,
            transactionHash: hash,
            logs: Formatter2.arrayOf(this.receiptLog.bind(this)),
            blockNumber: number,
            confirmations: Formatter2.allowNull(number, null),
            cumulativeGasUsed: bigNumber,
            effectiveGasPrice: Formatter2.allowNull(bigNumber),
            status: Formatter2.allowNull(number),
            type
          };
          formats.block = {
            hash,
            parentHash: hash,
            number,
            timestamp: number,
            nonce: Formatter2.allowNull(hex),
            difficulty: this.difficulty.bind(this),
            gasLimit: bigNumber,
            gasUsed: bigNumber,
            miner: address,
            extraData: data,
            transactions: Formatter2.allowNull(Formatter2.arrayOf(hash)),
            baseFeePerGas: Formatter2.allowNull(bigNumber)
          };
          formats.blockWithTransactions = (0, properties_1.shallowCopy)(formats.block);
          formats.blockWithTransactions.transactions = Formatter2.allowNull(Formatter2.arrayOf(this.transactionResponse.bind(this)));
          formats.filter = {
            fromBlock: Formatter2.allowNull(blockTag, void 0),
            toBlock: Formatter2.allowNull(blockTag, void 0),
            blockHash: Formatter2.allowNull(hash, void 0),
            address: Formatter2.allowNull(address, void 0),
            topics: Formatter2.allowNull(this.topics.bind(this), void 0)
          };
          formats.filterLog = {
            blockNumber: Formatter2.allowNull(number),
            blockHash: Formatter2.allowNull(hash),
            transactionIndex: number,
            removed: Formatter2.allowNull(this.boolean.bind(this)),
            address,
            data: Formatter2.allowFalsish(data, "0x"),
            topics: Formatter2.arrayOf(hash),
            transactionHash: hash,
            logIndex: number
          };
          return formats;
        };
        Formatter2.prototype.accessList = function(accessList) {
          return (0, transactions_1.accessListify)(accessList || []);
        };
        Formatter2.prototype.number = function(number) {
          if (number === "0x") {
            return 0;
          }
          return bignumber_1.BigNumber.from(number).toNumber();
        };
        Formatter2.prototype.type = function(number) {
          if (number === "0x" || number == null) {
            return 0;
          }
          return bignumber_1.BigNumber.from(number).toNumber();
        };
        Formatter2.prototype.bigNumber = function(value) {
          return bignumber_1.BigNumber.from(value);
        };
        Formatter2.prototype.boolean = function(value) {
          if (typeof value === "boolean") {
            return value;
          }
          if (typeof value === "string") {
            value = value.toLowerCase();
            if (value === "true") {
              return true;
            }
            if (value === "false") {
              return false;
            }
          }
          throw new Error("invalid boolean - " + value);
        };
        Formatter2.prototype.hex = function(value, strict) {
          if (typeof value === "string") {
            if (!strict && value.substring(0, 2) !== "0x") {
              value = "0x" + value;
            }
            if ((0, bytes_1.isHexString)(value)) {
              return value.toLowerCase();
            }
          }
          return logger.throwArgumentError("invalid hash", "value", value);
        };
        Formatter2.prototype.data = function(value, strict) {
          var result = this.hex(value, strict);
          if (result.length % 2 !== 0) {
            throw new Error("invalid data; odd-length - " + value);
          }
          return result;
        };
        Formatter2.prototype.address = function(value) {
          return (0, address_1.getAddress)(value);
        };
        Formatter2.prototype.callAddress = function(value) {
          if (!(0, bytes_1.isHexString)(value, 32)) {
            return null;
          }
          var address = (0, address_1.getAddress)((0, bytes_1.hexDataSlice)(value, 12));
          return address === constants_1.AddressZero ? null : address;
        };
        Formatter2.prototype.contractAddress = function(value) {
          return (0, address_1.getContractAddress)(value);
        };
        Formatter2.prototype.blockTag = function(blockTag) {
          if (blockTag == null) {
            return "latest";
          }
          if (blockTag === "earliest") {
            return "0x0";
          }
          if (blockTag === "latest" || blockTag === "pending") {
            return blockTag;
          }
          if (typeof blockTag === "number" || (0, bytes_1.isHexString)(blockTag)) {
            return (0, bytes_1.hexValue)(blockTag);
          }
          throw new Error("invalid blockTag");
        };
        Formatter2.prototype.hash = function(value, strict) {
          var result = this.hex(value, strict);
          if ((0, bytes_1.hexDataLength)(result) !== 32) {
            return logger.throwArgumentError("invalid hash", "value", value);
          }
          return result;
        };
        Formatter2.prototype.difficulty = function(value) {
          if (value == null) {
            return null;
          }
          var v = bignumber_1.BigNumber.from(value);
          try {
            return v.toNumber();
          } catch (error) {
          }
          return null;
        };
        Formatter2.prototype.uint256 = function(value) {
          if (!(0, bytes_1.isHexString)(value)) {
            throw new Error("invalid uint256");
          }
          return (0, bytes_1.hexZeroPad)(value, 32);
        };
        Formatter2.prototype._block = function(value, format) {
          if (value.author != null && value.miner == null) {
            value.miner = value.author;
          }
          var difficulty = value._difficulty != null ? value._difficulty : value.difficulty;
          var result = Formatter2.check(format, value);
          result._difficulty = difficulty == null ? null : bignumber_1.BigNumber.from(difficulty);
          return result;
        };
        Formatter2.prototype.block = function(value) {
          return this._block(value, this.formats.block);
        };
        Formatter2.prototype.blockWithTransactions = function(value) {
          return this._block(value, this.formats.blockWithTransactions);
        };
        Formatter2.prototype.transactionRequest = function(value) {
          return Formatter2.check(this.formats.transactionRequest, value);
        };
        Formatter2.prototype.transactionResponse = function(transaction) {
          if (transaction.gas != null && transaction.gasLimit == null) {
            transaction.gasLimit = transaction.gas;
          }
          if (transaction.to && bignumber_1.BigNumber.from(transaction.to).isZero()) {
            transaction.to = "0x0000000000000000000000000000000000000000";
          }
          if (transaction.input != null && transaction.data == null) {
            transaction.data = transaction.input;
          }
          if (transaction.to == null && transaction.creates == null) {
            transaction.creates = this.contractAddress(transaction);
          }
          if ((transaction.type === 1 || transaction.type === 2) && transaction.accessList == null) {
            transaction.accessList = [];
          }
          var result = Formatter2.check(this.formats.transaction, transaction);
          if (transaction.chainId != null) {
            var chainId = transaction.chainId;
            if ((0, bytes_1.isHexString)(chainId)) {
              chainId = bignumber_1.BigNumber.from(chainId).toNumber();
            }
            result.chainId = chainId;
          } else {
            var chainId = transaction.networkId;
            if (chainId == null && result.v == null) {
              chainId = transaction.chainId;
            }
            if ((0, bytes_1.isHexString)(chainId)) {
              chainId = bignumber_1.BigNumber.from(chainId).toNumber();
            }
            if (typeof chainId !== "number" && result.v != null) {
              chainId = (result.v - 35) / 2;
              if (chainId < 0) {
                chainId = 0;
              }
              chainId = parseInt(chainId);
            }
            if (typeof chainId !== "number") {
              chainId = 0;
            }
            result.chainId = chainId;
          }
          if (result.blockHash && result.blockHash.replace(/0/g, "") === "x") {
            result.blockHash = null;
          }
          return result;
        };
        Formatter2.prototype.transaction = function(value) {
          return (0, transactions_1.parse)(value);
        };
        Formatter2.prototype.receiptLog = function(value) {
          return Formatter2.check(this.formats.receiptLog, value);
        };
        Formatter2.prototype.receipt = function(value) {
          var result = Formatter2.check(this.formats.receipt, value);
          if (result.root != null) {
            if (result.root.length <= 4) {
              var value_1 = bignumber_1.BigNumber.from(result.root).toNumber();
              if (value_1 === 0 || value_1 === 1) {
                if (result.status != null && result.status !== value_1) {
                  logger.throwArgumentError("alt-root-status/status mismatch", "value", { root: result.root, status: result.status });
                }
                result.status = value_1;
                delete result.root;
              } else {
                logger.throwArgumentError("invalid alt-root-status", "value.root", result.root);
              }
            } else if (result.root.length !== 66) {
              logger.throwArgumentError("invalid root hash", "value.root", result.root);
            }
          }
          if (result.status != null) {
            result.byzantium = true;
          }
          return result;
        };
        Formatter2.prototype.topics = function(value) {
          var _this = this;
          if (Array.isArray(value)) {
            return value.map(function(v) {
              return _this.topics(v);
            });
          } else if (value != null) {
            return this.hash(value, true);
          }
          return null;
        };
        Formatter2.prototype.filter = function(value) {
          return Formatter2.check(this.formats.filter, value);
        };
        Formatter2.prototype.filterLog = function(value) {
          return Formatter2.check(this.formats.filterLog, value);
        };
        Formatter2.check = function(format, object) {
          var result = {};
          for (var key in format) {
            try {
              var value = format[key](object[key]);
              if (value !== void 0) {
                result[key] = value;
              }
            } catch (error) {
              error.checkKey = key;
              error.checkValue = object[key];
              throw error;
            }
          }
          return result;
        };
        Formatter2.allowNull = function(format, nullValue) {
          return function(value) {
            if (value == null) {
              return nullValue;
            }
            return format(value);
          };
        };
        Formatter2.allowFalsish = function(format, replaceValue) {
          return function(value) {
            if (!value) {
              return replaceValue;
            }
            return format(value);
          };
        };
        Formatter2.arrayOf = function(format) {
          return function(array) {
            if (!Array.isArray(array)) {
              throw new Error("not an array");
            }
            var result = [];
            array.forEach(function(value) {
              result.push(format(value));
            });
            return result;
          };
        };
        return Formatter2;
      }()
    );
    exports2.Formatter = Formatter;
    function isCommunityResourcable(value) {
      return value && typeof value.isCommunityResource === "function";
    }
    exports2.isCommunityResourcable = isCommunityResourcable;
    function isCommunityResource(value) {
      return isCommunityResourcable(value) && value.isCommunityResource();
    }
    exports2.isCommunityResource = isCommunityResource;
    var throttleMessage = false;
    function showThrottleMessage() {
      if (throttleMessage) {
        return;
      }
      throttleMessage = true;
      console.log("========= NOTICE =========");
      console.log("Request-Rate Exceeded  (this message will not be repeated)");
      console.log("");
      console.log("The default API keys for each service are provided as a highly-throttled,");
      console.log("community resource for low-traffic projects and early prototyping.");
      console.log("");
      console.log("While your application will continue to function, we highly recommended");
      console.log("signing up for your own API keys to improve performance, increase your");
      console.log("request rate/limit and enable other perks, such as metrics and advanced APIs.");
      console.log("");
      console.log("For more details: https://docs.ethers.io/api-keys/");
      console.log("==========================");
    }
    exports2.showThrottleMessage = showThrottleMessage;
  }
});

// node_modules/@ethersproject/providers/lib/base-provider.js
var require_base_provider = __commonJS({
  "node_modules/@ethersproject/providers/lib/base-provider.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator = exports2 && exports2.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1) throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
